/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogColumnStat;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeMap$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Ceil;
import org.apache.spark.sql.catalyst.expressions.Coalesce;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.CreateStruct$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Least;
import org.apache.spark.sql.catalyst.expressions.Length;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Subtract;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateFunction;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproxCountDistinctForIntervals;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproxCountDistinctForIntervals$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproximatePercentile;
import org.apache.spark.sql.catalyst.expressions.aggregate.Average;
import org.apache.spark.sql.catalyst.expressions.aggregate.Count;
import org.apache.spark.sql.catalyst.expressions.aggregate.Count$;
import org.apache.spark.sql.catalyst.expressions.aggregate.HyperLogLogPlusPlus;
import org.apache.spark.sql.catalyst.expressions.aggregate.HyperLogLogPlusPlus$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Max;
import org.apache.spark.sql.catalyst.expressions.aggregate.Min;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat$;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.Histogram;
import org.apache.spark.sql.catalyst.plans.logical.HistogramBin;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.command.AnalyzeColumnCommand$;
import org.apache.spark.sql.execution.command.CommandUtils$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SessionState;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\u0015c\u0001B\u000f\u001f\u0001.B\u0001b\u0011\u0001\u0003\u0016\u0004%\t\u0001\u0012\u0005\t\u0013\u0002\u0011\t\u0012)A\u0005\u000b\"A!\n\u0001BK\u0002\u0013\u00051\n\u0003\u0005a\u0001\tE\t\u0015!\u0003M\u0011\u0015\t\u0007\u0001\"\u0001c\u0011\u00151\u0007\u0001\"\u0011h\u0011\u0015\u0011\b\u0001\"\u0003t\u0011\u001d\ti\u0001\u0001C\u0005\u0003\u001fAq!a\u000f\u0001\t\u0013\ti\u0004C\u0004\u0002V\u0001!I!a\u0016\t\u000f\u0005m\u0003\u0001\"\u0003\u0002^!9\u0011Q\u0010\u0001\u0005\n\u0005}\u0004\"CAR\u0001\u0005\u0005I\u0011AAS\u0011%\tY\u000bAI\u0001\n\u0003\ti\u000bC\u0005\u0002D\u0002\t\n\u0011\"\u0001\u0002F\"I\u0011\u0011\u001a\u0001\u0002\u0002\u0013\u0005\u00131\u001a\u0005\n\u00037\u0004\u0011\u0011!C\u0001\u0003;D\u0011\"!:\u0001\u0003\u0003%\t!a:\t\u0013\u0005M\b!!A\u0005B\u0005U\b\"\u0003B\u0002\u0001\u0005\u0005I\u0011\u0001B\u0003\u0011%\u0011I\u0001AA\u0001\n\u0003\u0012YaB\u0005\u0003\u0010y\t\t\u0011#\u0001\u0003\u0012\u0019AQDHA\u0001\u0012\u0003\u0011\u0019\u0002\u0003\u0004b/\u0011\u0005!\u0011\u0005\u0005\n\u0005G9\u0012\u0011!C#\u0005KA\u0011Ba\n\u0018\u0003\u0003%\tI!\u000b\t\u0013\t=r#!A\u0005\u0002\nE\u0002\"\u0003B\u001e/\u0005\u0005I\u0011\u0002B\u001f\u0005Q\te.\u00197zu\u0016\u001cu\u000e\\;n]\u000e{W.\\1oI*\u0011q\u0004I\u0001\bG>lW.\u00198e\u0015\t\t#%A\u0005fq\u0016\u001cW\u000f^5p]*\u00111\u0005J\u0001\u0004gFd'BA\u0013'\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0003&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002S\u0005\u0019qN]4\u0004\u0001M)\u0001\u0001\f\u001c;\u0001B\u0011Q\u0006N\u0007\u0002])\u0011q\u0006M\u0001\bY><\u0017nY1m\u0015\t\t$'A\u0003qY\u0006t7O\u0003\u00024E\u0005A1-\u0019;bYf\u001cH/\u0003\u00026]\tYAj\\4jG\u0006d\u0007\u000b\\1o!\t9\u0004(D\u0001\u001f\u0013\tIdDA\bSk:t\u0017M\u00197f\u0007>lW.\u00198e!\tYd(D\u0001=\u0015\u0005i\u0014!B:dC2\f\u0017BA =\u0005\u001d\u0001&o\u001c3vGR\u0004\"aO!\n\u0005\tc$\u0001D*fe&\fG.\u001b>bE2,\u0017A\u0003;bE2,\u0017\nZ3oiV\tQ\t\u0005\u0002G\u000f6\t!'\u0003\u0002Ie\tyA+\u00192mK&#WM\u001c;jM&,'/A\u0006uC\ndW-\u00133f]R\u0004\u0013aC2pYVlgNT1nKN,\u0012\u0001\u0014\t\u0004\u001bVCfB\u0001(T\u001d\ty%+D\u0001Q\u0015\t\t&&\u0001\u0004=e>|GOP\u0005\u0002{%\u0011A\u000bP\u0001\ba\u0006\u001c7.Y4f\u0013\t1vKA\u0002TKFT!\u0001\u0016\u001f\u0011\u0005ekfB\u0001.\\!\tyE(\u0003\u0002]y\u00051\u0001K]3eK\u001aL!AX0\u0003\rM#(/\u001b8h\u0015\taF(\u0001\u0007d_2,XN\u001c(b[\u0016\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0004G\u0012,\u0007CA\u001c\u0001\u0011\u0015\u0019U\u00011\u0001F\u0011\u0015QU\u00011\u0001M\u0003\r\u0011XO\u001c\u000b\u0003Q6\u00042!T+j!\tQ7.D\u0001#\u0013\ta'EA\u0002S_^DQA\u001c\u0004A\u0002=\fAb\u001d9be.\u001cVm]:j_:\u0004\"A\u001b9\n\u0005E\u0014#\u0001D*qCJ\\7+Z:tS>t\u0017AE2p[B,H/Z\"pYVlgn\u0015;biN$r\u0001^A\u0004\u0003\u0013\tY\u0001\u0005\u0003<k^T\u0018B\u0001<=\u0005\u0019!V\u000f\u001d7feA\u00111\b_\u0005\u0003sr\u0012A\u0001T8oOB!\u0011l\u001f-~\u0013\taxLA\u0002NCB\u00042A`A\u0002\u001b\u0005y(bAA\u0001e\u000591-\u0019;bY><\u0017bAA\u0003\u007f\n\t2)\u0019;bY><7i\u001c7v[:\u001cF/\u0019;\t\u000b9<\u0001\u0019A8\t\u000b\r;\u0001\u0019A#\t\u000b);\u0001\u0019\u0001'\u0002%\r|W\u000e];uKB+'oY3oi&dWm\u001d\u000b\t\u0003#\tI#!\u000e\u00028A1\u00111CA\r\u0003;i!!!\u0006\u000b\u0007\u0005]!'A\u0006fqB\u0014Xm]:j_:\u001c\u0018\u0002BA\u000e\u0003+\u0011A\"\u0011;ue&\u0014W\u000f^3NCB\u0004B!a\b\u0002&5\u0011\u0011\u0011\u0005\u0006\u0004\u0003G\u0011\u0014\u0001B;uS2LA!a\n\u0002\"\tI\u0011I\u001d:bs\u0012\u000bG/\u0019\u0005\b\u0003WA\u0001\u0019AA\u0017\u0003M\tG\u000f\u001e:jEV$Xm\u001d+p\u0003:\fG.\u001f>f!\u0011iU+a\f\u0011\t\u0005M\u0011\u0011G\u0005\u0005\u0003g\t)BA\u0005BiR\u0014\u0018NY;uK\")a\u000e\u0003a\u0001_\"1\u0011\u0011\b\u0005A\u00021\n\u0001B]3mCRLwN\\\u0001\rgV\u0004\bo\u001c:ugRK\b/\u001a\u000b\u0005\u0003\u007f\t)\u0005E\u0002<\u0003\u0003J1!a\u0011=\u0005\u001d\u0011un\u001c7fC:Dq!a\u0012\n\u0001\u0004\tI%\u0001\u0005eCR\fG+\u001f9f!\u0011\tY%!\u0015\u000e\u0005\u00055#bAA(E\u0005)A/\u001f9fg&!\u00111KA'\u0005!!\u0015\r^1UsB,\u0017!E:vaB|'\u000f^:ISN$xn\u001a:b[R!\u0011qHA-\u0011\u001d\t9E\u0003a\u0001\u0003\u0013\n\u0011b\u001d;bi\u0016C\bO]:\u0015\u0011\u0005}\u0013QMA5\u0003s\u0002B!a\u0005\u0002b%!\u00111MA\u000b\u0005E\u0019%/Z1uK:\u000bW.\u001a3TiJ,8\r\u001e\u0005\b\u0003OZ\u0001\u0019AA\u0018\u0003\r\u0019w\u000e\u001c\u0005\b\u0003WZ\u0001\u0019AA7\u0003\u0011\u0019wN\u001c4\u0011\t\u0005=\u0014QO\u0007\u0003\u0003cR1!a\u001d#\u0003!Ig\u000e^3s]\u0006d\u0017\u0002BA<\u0003c\u0012qaU)M\u0007>tg\rC\u0004\u0002|-\u0001\r!!\u0005\u0002\u001d\r|G\u000eU3sG\u0016tG/\u001b7fg\u0006y!o\\<U_\u000e{G.^7o'R\fG\u000f\u0006\u0006\u0002\u0002\u0006\u001d\u0015\u0011SAK\u00033\u00032!LAB\u0013\r\t)I\f\u0002\u000b\u0007>dW/\u001c8Ti\u0006$\bbBAE\u0019\u0001\u0007\u00111R\u0001\u0004e><\bc\u0001$\u0002\u000e&\u0019\u0011q\u0012\u001a\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0005\b\u0003'c\u0001\u0019AA\u0018\u0003\u0011\tG\u000f\u001e:\t\r\u0005]E\u00021\u0001x\u0003!\u0011xn^\"pk:$\bbBAN\u0019\u0001\u0007\u0011QT\u0001\fa\u0016\u00148-\u001a8uS2,7\u000fE\u0003<\u0003?\u000bi\"C\u0002\u0002\"r\u0012aa\u00149uS>t\u0017\u0001B2paf$RaYAT\u0003SCqaQ\u0007\u0011\u0002\u0003\u0007Q\tC\u0004K\u001bA\u0005\t\u0019\u0001'\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u0016\u0016\u0004\u000b\u0006E6FAAZ!\u0011\t),a0\u000e\u0005\u0005]&\u0002BA]\u0003w\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005uF(\u0001\u0006b]:|G/\u0019;j_:LA!!1\u00028\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\u0019\u0016\u0004\u0019\u0006E\u0016!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002NB!\u0011qZAm\u001b\t\t\tN\u0003\u0003\u0002T\u0006U\u0017\u0001\u00027b]\u001eT!!a6\u0002\t)\fg/Y\u0005\u0004=\u0006E\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAAp!\rY\u0014\u0011]\u0005\u0004\u0003Gd$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAu\u0003_\u00042aOAv\u0013\r\ti\u000f\u0010\u0002\u0004\u0003:L\b\"CAy%\u0005\u0005\t\u0019AAp\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u001f\t\u0007\u0003s\fy0!;\u000e\u0005\u0005m(bAA\u007fy\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t\u0005\u00111 \u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002@\t\u001d\u0001\"CAy)\u0005\u0005\t\u0019AAu\u0003\u0019)\u0017/^1mgR!\u0011q\bB\u0007\u0011%\t\t0FA\u0001\u0002\u0004\tI/\u0001\u000bB]\u0006d\u0017P_3D_2,XN\\\"p[6\fg\u000e\u001a\t\u0003o]\u0019Ba\u0006B\u000b\u0001B9!q\u0003B\u000f\u000b2\u001bWB\u0001B\r\u0015\r\u0011Y\u0002P\u0001\beVtG/[7f\u0013\u0011\u0011yB!\u0007\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0003\u0012\u0005AAo\\*ue&tw\r\u0006\u0002\u0002N\u0006)\u0011\r\u001d9msR)1Ma\u000b\u0003.!)1I\u0007a\u0001\u000b\")!J\u0007a\u0001\u0019\u00069QO\\1qa2LH\u0003\u0002B\u001a\u0005o\u0001RaOAP\u0005k\u0001BaO;F\u0019\"A!\u0011H\u000e\u0002\u0002\u0003\u00071-A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011!q\b\t\u0005\u0003\u001f\u0014\t%\u0003\u0003\u0003D\u0005E'AB(cU\u0016\u001cG\u000f")
public class AnalyzeColumnCommand
extends LogicalPlan
implements RunnableCommand,
scala.Serializable {
    private final TableIdentifier tableIdent;
    private final Seq<String> columnNames;
    private Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<TableIdentifier, Seq<String>>> unapply(AnalyzeColumnCommand analyzeColumnCommand) {
        return AnalyzeColumnCommand$.MODULE$.unapply(analyzeColumnCommand);
    }

    public static Function1<Tuple2<TableIdentifier, Seq<String>>, AnalyzeColumnCommand> tupled() {
        return AnalyzeColumnCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Seq<String>, AnalyzeColumnCommand>> curried() {
        return AnalyzeColumnCommand$.MODULE$.curried();
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.children$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        AnalyzeColumnCommand analyzeColumnCommand = this;
        synchronized (analyzeColumnCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public TableIdentifier tableIdent() {
        return this.tableIdent;
    }

    public Seq<String> columnNames() {
        return this.columnNames;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        SessionState sessionState = sparkSession.sessionState();
        String db = (String)this.tableIdent().database().getOrElse((Function0 & Serializable & scala.Serializable)() -> sessionState.catalog().getCurrentDatabase());
        TableIdentifier tableIdentWithDB = new TableIdentifier(this.tableIdent().table(), (Option)new Some((Object)db));
        CatalogTable tableMeta = sessionState.catalog().getTableMetadata(tableIdentWithDB);
        CatalogTableType catalogTableType = tableMeta.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
            throw new AnalysisException("ANALYZE TABLE is not supported on views.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        BigInt sizeInBytes = CommandUtils$.MODULE$.calculateTotalSize(sparkSession, tableMeta);
        Tuple2<Object, Map<String, CatalogColumnStat>> tuple2 = this.computeColumnStats(sparkSession, tableIdentWithDB, this.columnNames());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long rowCount = tuple2._1$mcJ$sp();
        Map newColStats = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)rowCount), (Object)newColStats);
        Tuple2 tuple23 = tuple22;
        long rowCount2 = tuple23._1$mcJ$sp();
        Map newColStats2 = (Map)tuple23._2();
        CatalogStatistics statistics = new CatalogStatistics(sizeInBytes, (Option)new Some((Object)BigInt$.MODULE$.long2bigInt(rowCount2)), ((MapLike)tableMeta.stats().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.colStats()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty())).$plus$plus((GenTraversableOnce)newColStats2));
        sessionState.catalog().alterTableStats(tableIdentWithDB, (Option)new Some((Object)statistics));
        return (Seq)Seq$.MODULE$.empty();
    }

    private Tuple2<Object, Map<String, CatalogColumnStat>> computeColumnStats(SparkSession sparkSession, TableIdentifier tableIdent, Seq<String> columnNames) {
        SQLConf conf = sparkSession.sessionState().conf();
        LogicalPlan relation = sparkSession.table(tableIdent).logicalPlan();
        Seq attributesToAnalyze = (Seq)columnNames.map((Function1 & Serializable & scala.Serializable)col -> {
            Option exprOption = relation.output().find((Function1 & Serializable & scala.Serializable)attr -> BoxesRunTime.boxToBoolean((boolean)AnalyzeColumnCommand.$anonfun$computeColumnStats$2(conf, col, attr)));
            return (Attribute)exprOption.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new AnalysisException(new StringBuilder(23).append("Column ").append((String)col).append(" does not exist.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            });
        }, Seq$.MODULE$.canBuildFrom());
        attributesToAnalyze.foreach((Function1 & Serializable & scala.Serializable)attr -> {
            AnalyzeColumnCommand.$anonfun$computeColumnStats$4(this, tableIdent, attr);
            return BoxedUnit.UNIT;
        });
        AttributeMap<ArrayData> attributePercentiles = this.computePercentiles((Seq<Attribute>)attributesToAnalyze, sparkSession, relation);
        AggregateExpression aggregateExpression = Count$.MODULE$.apply((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).toAggregateExpression();
        Seq expressions = (Seq)((SeqLike)attributesToAnalyze.map((Function1 & Serializable & scala.Serializable)x$3 -> this.statExprs((Attribute)x$3, conf, attributePercentiles), Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)aggregateExpression, Seq$.MODULE$.canBuildFrom());
        Seq namedExpressions = (Seq)expressions.map((Function1 & Serializable & scala.Serializable)e -> {
            Expression x$1 = e;
            String x$2 = e.toString();
            ExprId x$3 = Alias$.MODULE$.apply$default$3(x$1, x$2);
            Seq x$4 = Alias$.MODULE$.apply$default$4(x$1, x$2);
            Option x$5 = Alias$.MODULE$.apply$default$5(x$1, x$2);
            return new Alias(x$1, x$2, x$3, x$4, x$5);
        }, Seq$.MODULE$.canBuildFrom());
        InternalRow statsRow = (InternalRow)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new QueryExecution(sparkSession, (LogicalPlan)new Aggregate((Seq)Nil$.MODULE$, namedExpressions, relation)).executedPlan().executeTake(1))).head();
        long rowCount = statsRow.getLong(0);
        Map columnStats = ((TraversableOnce)((TraversableLike)attributesToAnalyze.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Attribute attr = (Attribute)tuple2._1();
            int i = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)attr.name(), (Object)this.rowToColumnStat(statsRow.getStruct(i + 1, 7), attr, rowCount, (Option<ArrayData>)attributePercentiles.get(attr)).toCatalogColumnStat(attr.name(), attr.dataType()));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)rowCount), (Object)columnStats);
    }

    private AttributeMap<ArrayData> computePercentiles(Seq<Attribute> attributesToAnalyze, SparkSession sparkSession, LogicalPlan relation) {
        HashMap attributePercentiles;
        block0: {
            Nil$ attrsToGenHistogram = this.conf().histogramEnabled() ? (Seq)attributesToAnalyze.filter((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean((boolean)this.supportsHistogram(a.dataType()))) : Nil$.MODULE$;
            attributePercentiles = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
            if (!attrsToGenHistogram.nonEmpty()) break block0;
            double[] percentiles = (double[])((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.conf().histogramNumBins()).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> (double)i / (double)this.conf().histogramNumBins(), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
            Seq namedExprs = (Seq)attrsToGenHistogram.map((Function1 & Serializable & scala.Serializable)attr -> {
                AggregateExpression expr;
                ApproximatePercentile aggFunc = new ApproximatePercentile((Expression)attr, (Expression)Literal$.MODULE$.apply((Object)percentiles), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.conf().percentileAccuracy())));
                AggregateExpression x$1 = expr = aggFunc.toAggregateExpression();
                String x$2 = expr.toString();
                ExprId x$3 = Alias$.MODULE$.apply$default$3((Expression)x$1, x$2);
                Seq x$4 = Alias$.MODULE$.apply$default$4((Expression)x$1, x$2);
                Option x$5 = Alias$.MODULE$.apply$default$5((Expression)x$1, x$2);
                return new Alias((Expression)x$1, x$2, x$3, x$4, x$5);
            }, Seq$.MODULE$.canBuildFrom());
            InternalRow percentilesRow = (InternalRow)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new QueryExecution(sparkSession, (LogicalPlan)new Aggregate((Seq)Nil$.MODULE$, namedExprs, relation)).executedPlan().executeTake(1))).head();
            ((IterableLike)attrsToGenHistogram.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Attribute attr = (Attribute)tuple2._1();
                int i = tuple2._2$mcI$sp();
                ArrayData percentiles = percentilesRow.getArray(i);
                BoxedUnit boxedUnit = percentiles != null ? attributePercentiles.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)attr), (Object)percentiles)) : BoxedUnit.UNIT;
                return boxedUnit;
            });
        }
        return AttributeMap$.MODULE$.apply(attributePercentiles.toSeq());
    }

    private boolean supportsType(DataType dataType) {
        boolean bl;
        boolean bl2;
        DataType dataType2 = dataType;
        boolean bl3 = dataType2 instanceof IntegralType ? true : (dataType2 instanceof DecimalType ? true : ((bl2 = DoubleType$.MODULE$.equals(dataType2) ? true : FloatType$.MODULE$.equals(dataType2)) ? true : (BooleanType$.MODULE$.equals(dataType2) ? true : (DateType$.MODULE$.equals(dataType2) ? true : (TimestampType$.MODULE$.equals(dataType2) ? true : (bl = BinaryType$.MODULE$.equals(dataType2) ? true : StringType$.MODULE$.equals(dataType2)))))));
        return bl3;
    }

    private boolean supportsHistogram(DataType dataType) {
        boolean bl;
        DataType dataType2 = dataType;
        boolean bl2 = dataType2 instanceof IntegralType ? true : (dataType2 instanceof DecimalType ? true : ((bl = DoubleType$.MODULE$.equals(dataType2) ? true : FloatType$.MODULE$.equals(dataType2)) ? true : (DateType$.MODULE$.equals(dataType2) ? true : TimestampType$.MODULE$.equals(dataType2))));
        return bl2;
    }

    private CreateNamedStruct statExprs(Attribute col, SQLConf conf, AttributeMap<ArrayData> colPercentiles) {
        CreateNamedStruct createNamedStruct;
        Literal one = new Literal((Object)BoxesRunTime.boxToInteger((int)1), (DataType)LongType$.MODULE$);
        Count numNonNulls = col.nullable() ? Count$.MODULE$.apply((Expression)col) : Count$.MODULE$.apply((Expression)one);
        Least ndv = new Least((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AggregateFunction[]{new HyperLogLogPlusPlus((Expression)col, conf.ndvMaxError(), HyperLogLogPlusPlus$.MODULE$.apply$default$3(), HyperLogLogPlusPlus$.MODULE$.apply$default$4()), numNonNulls})));
        Subtract numNulls = new Subtract((Expression)Count$.MODULE$.apply((Expression)one), (Expression)numNonNulls);
        Literal defaultSize = new Literal((Object)BoxesRunTime.boxToInteger((int)col.dataType().defaultSize()), (DataType)LongType$.MODULE$);
        Literal nullArray = new Literal(null, (DataType)ArrayType$.MODULE$.apply((DataType)LongType$.MODULE$));
        DataType dataType = col.dataType();
        if (dataType instanceof IntegralType) {
            createNamedStruct = this.fixedLenTypeStruct$1(col, colPercentiles, conf, nullArray, ndv, numNulls, defaultSize);
        } else if (dataType instanceof DecimalType) {
            createNamedStruct = this.fixedLenTypeStruct$1(col, colPercentiles, conf, nullArray, ndv, numNulls, defaultSize);
        } else {
            boolean bl = DoubleType$.MODULE$.equals(dataType) ? true : FloatType$.MODULE$.equals(dataType);
            if (bl) {
                createNamedStruct = this.fixedLenTypeStruct$1(col, colPercentiles, conf, nullArray, ndv, numNulls, defaultSize);
            } else if (BooleanType$.MODULE$.equals(dataType)) {
                createNamedStruct = this.fixedLenTypeStruct$1(col, colPercentiles, conf, nullArray, ndv, numNulls, defaultSize);
            } else if (DateType$.MODULE$.equals(dataType)) {
                createNamedStruct = this.fixedLenTypeStruct$1(col, colPercentiles, conf, nullArray, ndv, numNulls, defaultSize);
            } else if (TimestampType$.MODULE$.equals(dataType)) {
                createNamedStruct = this.fixedLenTypeStruct$1(col, colPercentiles, conf, nullArray, ndv, numNulls, defaultSize);
            } else {
                boolean bl2 = BinaryType$.MODULE$.equals(dataType) ? true : StringType$.MODULE$.equals(dataType);
                if (bl2) {
                    Literal nullLit = new Literal(null, col.dataType());
                    createNamedStruct = AnalyzeColumnCommand.struct$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{ndv, nullLit, nullLit, numNulls, new Coalesce((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Ceil((Expression)new Average((Expression)new Length((Expression)col))), defaultSize}))), new Coalesce((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Cast((Expression)new Max((Expression)new Length((Expression)col)), (DataType)LongType$.MODULE$, Cast$.MODULE$.apply$default$3()), defaultSize}))), nullArray}));
                } else {
                    throw new AnalysisException(new StringBuilder(56).append("Analyzing column statistics is not supported for column ").append(new StringBuilder(16).append(col.name()).append(" of data type: ").append(col.dataType()).append(".").toString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
            }
        }
        return createNamedStruct;
    }

    private ColumnStat rowToColumnStat(InternalRow row, Attribute attr, long rowCount, Option<ArrayData> percentiles) {
        ColumnStat columnStat;
        ColumnStat cs = new ColumnStat(Option$.MODULE$.apply((Object)package$.MODULE$.BigInt().apply(row.getLong(0))), Option$.MODULE$.apply(row.get(1, attr.dataType())), Option$.MODULE$.apply(row.get(2, attr.dataType())), Option$.MODULE$.apply((Object)package$.MODULE$.BigInt().apply(row.getLong(3))), Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)row.getLong(4))), Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)row.getLong(5))), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8());
        if (row.isNullAt(6) || cs.nullCount().isEmpty()) {
            columnStat = cs;
        } else {
            long[] ndvs = row.getArray(6).toLongArray();
            Predef$.MODULE$.assert(((ArrayData)percentiles.get()).numElements() == ndvs.length + 1);
            double[] endpoints = (double[])Predef$.MODULE$.genericArrayOps(((ArrayData)percentiles.get()).toArray(attr.dataType(), ClassTag$.MODULE$.Any())).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToDouble((double)AnalyzeColumnCommand.$anonfun$rowToColumnStat$1(x$5)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            HistogramBin[] bins = (HistogramBin[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(ndvs)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                long ndv = tuple2._1$mcJ$sp();
                int i = tuple2._2$mcI$sp();
                HistogramBin histogramBin = new HistogramBin(endpoints[i], endpoints[i + 1], ndv);
                return histogramBin;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(HistogramBin.class)));
            BigInt nonNullRows = BigInt$.MODULE$.long2bigInt(rowCount).$minus((BigInt)cs.nullCount().get());
            Histogram histogram = new Histogram(nonNullRows.toDouble() / (double)ndvs.length, bins);
            Some x$1 = new Some((Object)histogram);
            Option x$2 = cs.copy$default$1();
            Option x$3 = cs.copy$default$2();
            Option x$4 = cs.copy$default$3();
            Option x$52 = cs.copy$default$4();
            Option x$6 = cs.copy$default$5();
            Option x$7 = cs.copy$default$6();
            int x$8 = cs.copy$default$8();
            columnStat = cs.copy(x$2, x$3, x$4, x$52, x$6, x$7, (Option)x$1, x$8);
        }
        return columnStat;
    }

    public AnalyzeColumnCommand copy(TableIdentifier tableIdent, Seq<String> columnNames) {
        return new AnalyzeColumnCommand(tableIdent, columnNames);
    }

    public TableIdentifier copy$default$1() {
        return this.tableIdent();
    }

    public Seq<String> copy$default$2() {
        return this.columnNames();
    }

    public String productPrefix() {
        return "AnalyzeColumnCommand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Seq<String> seq;
        int n = x$1;
        switch (n) {
            case 0: {
                seq = this.tableIdent();
                break;
            }
            case 1: {
                seq = this.columnNames();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return seq;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AnalyzeColumnCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AnalyzeColumnCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AnalyzeColumnCommand analyzeColumnCommand = (AnalyzeColumnCommand)x$1;
        TableIdentifier tableIdentifier = this.tableIdent();
        TableIdentifier tableIdentifier2 = analyzeColumnCommand.tableIdent();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Seq<String> seq = this.columnNames();
        Seq<String> seq2 = analyzeColumnCommand.columnNames();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!analyzeColumnCommand.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$computeColumnStats$2(SQLConf conf$1, String col$1, Attribute attr) {
        return BoxesRunTime.unboxToBoolean((Object)conf$1.resolver().apply((Object)attr.name(), (Object)col$1));
    }

    public static final /* synthetic */ void $anonfun$computeColumnStats$4(AnalyzeColumnCommand $this, TableIdentifier tableIdent$1, Attribute attr) {
        if (!$this.supportsType(attr.dataType())) {
            throw new AnalysisException(new StringBuilder(100).append("Column ").append(attr.name()).append(" in table ").append(tableIdent$1).append(" is of type ").append(attr.dataType()).append(", ").append("and Spark does not support statistics collection on this column type.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    private static final CreateNamedStruct struct$1(Seq exprs) {
        return CreateStruct$.MODULE$.apply((Seq)exprs.map((Function1 & Serializable & scala.Serializable)expr -> (Expression)expr.transformUp((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof AggregateFunction) {
                    AggregateFunction aggregateFunction = (AggregateFunction)A1;
                    object = aggregateFunction.toAggregateExpression();
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                boolean bl = expression instanceof AggregateFunction;
                return bl;
            }
        }), Seq$.MODULE$.canBuildFrom()));
    }

    private final CreateNamedStruct fixedLenTypeStruct$1(Attribute col$2, AttributeMap colPercentiles$1, SQLConf conf$2, Literal nullArray$1, Least ndv$1, Subtract numNulls$1, Literal defaultSize$1) {
        boolean genHistogram = this.supportsHistogram(col$2.dataType()) && colPercentiles$1.contains(col$2);
        Literal intervalNdvsExpr = genHistogram ? new ApproxCountDistinctForIntervals((Expression)col$2, (Expression)new Literal(colPercentiles$1.apply((Object)col$2), (DataType)ArrayType$.MODULE$.apply(col$2.dataType())), conf$2.ndvMaxError(), ApproxCountDistinctForIntervals$.MODULE$.apply$default$4(), ApproxCountDistinctForIntervals$.MODULE$.apply$default$5()) : nullArray$1;
        return AnalyzeColumnCommand.struct$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{ndv$1, new Cast((Expression)new Min((Expression)col$2), col$2.dataType(), Cast$.MODULE$.apply$default$3()), new Cast((Expression)new Max((Expression)col$2), col$2.dataType(), Cast$.MODULE$.apply$default$3()), numNulls$1, defaultSize$1, defaultSize$1, intervalNdvsExpr}));
    }

    public static final /* synthetic */ double $anonfun$rowToColumnStat$1(Object x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5.toString())).toDouble();
    }

    public AnalyzeColumnCommand(TableIdentifier tableIdent, Seq<String> columnNames) {
        this.tableIdent = tableIdent;
        this.columnNames = columnNames;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
    }
}

