/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.FileNotFoundException;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.metrics.source.HiveCatalogMetrics$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.FileStatusCache;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex;
import org.apache.spark.sql.execution.datasources.NoopCache$;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class InMemoryFileIndex$
implements Logging {
    public static InMemoryFileIndex$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new InMemoryFileIndex$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public FileStatusCache $lessinit$greater$default$5() {
        return NoopCache$.MODULE$;
    }

    public Seq<Tuple2<Path, Seq<FileStatus>>> bulkListLeafFiles(Seq<Path> paths, Configuration hadoopConf, PathFilter filter, SparkSession sparkSession) {
        Tuple2[] tuple2Array;
        if (paths.size() <= sparkSession.sessionState().conf().parallelPartitionDiscoveryThreshold()) {
            return (Seq)paths.map((Function1 & Serializable & scala.Serializable)path -> new Tuple2(path, MODULE$.listLeafFiles((Path)path, hadoopConf, filter, (Option<SparkSession>)new Some((Object)sparkSession))), Seq$.MODULE$.canBuildFrom());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Listing leaf files and directories in parallel under: ").append(paths.mkString(", ")).toString());
        HiveCatalogMetrics$.MODULE$.incrementParallelListingJobCount(1);
        SparkContext sparkContext = sparkSession.sparkContext();
        SerializableConfiguration serializableConfiguration = new SerializableConfiguration(hadoopConf);
        Seq serializedPaths = (Seq)paths.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toString(), Seq$.MODULE$.canBuildFrom());
        int parallelPartitionDiscoveryParallelism = sparkSession.sessionState().conf().parallelPartitionDiscoveryParallelism();
        int numParallelism = Math.min(paths.size(), parallelPartitionDiscoveryParallelism);
        String previousJobDescription = sparkContext.getLocalProperty(SparkContext$.MODULE$.SPARK_JOB_DESCRIPTION());
        try {
            String string;
            int n = paths.size();
            switch (n) {
                case 0: {
                    string = "Listing leaf files and directories 0 paths";
                    break;
                }
                case 1: {
                    string = new StringBuilder(51).append("Listing leaf files and directories for 1 path:<br/>").append(paths.apply(0)).toString();
                    break;
                }
                default: {
                    string = new StringBuilder(56).append("Listing leaf files and directories for ").append(n).append(" paths:<br/>").append(paths.apply(0)).append(", ...").toString();
                    break;
                }
            }
            String description = string;
            sparkContext.setJobDescription(description);
            RDD qual$1 = sparkContext.parallelize(serializedPaths, numParallelism, ClassTag$.MODULE$.apply(String.class));
            Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)pathStrings -> {
                Configuration hadoopConf = serializableConfiguration.value();
                return ((IterableLike)pathStrings.map((Function1 & Serializable & scala.Serializable)x$4 -> new Path(x$4)).toSeq().map((Function1 & Serializable & scala.Serializable)path -> new Tuple2(path, MODULE$.listLeafFiles((Path)path, hadoopConf, filter, (Option<SparkSession>)None$.MODULE$)), Seq$.MODULE$.canBuildFrom())).iterator();
            };
            boolean x$2 = qual$1.mapPartitions$default$2();
            tuple2Array = (Tuple2[])qual$1.mapPartitions((Function1)x$1, x$2, ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Path path = (Path)tuple2._1();
                Seq statuses = (Seq)tuple2._2();
                Seq serializableStatuses = (Seq)statuses.map((Function1 & Serializable & scala.Serializable)status -> {
                    InMemoryFileIndex.SerializableBlockLocation[] serializableBlockLocationArray;
                    FileStatus fileStatus = status;
                    if (fileStatus instanceof LocatedFileStatus) {
                        LocatedFileStatus locatedFileStatus = (LocatedFileStatus)fileStatus;
                        serializableBlockLocationArray = (InMemoryFileIndex.SerializableBlockLocation[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])locatedFileStatus.getBlockLocations())).map((Function1 & Serializable & scala.Serializable)loc -> new InMemoryFileIndex.SerializableBlockLocation(loc.getNames(), loc.getHosts(), loc.getOffset(), loc.getLength()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InMemoryFileIndex.SerializableBlockLocation.class)));
                    } else {
                        serializableBlockLocationArray = (InMemoryFileIndex.SerializableBlockLocation[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(InMemoryFileIndex.SerializableBlockLocation.class));
                    }
                    InMemoryFileIndex.SerializableBlockLocation[] blockLocations = serializableBlockLocationArray;
                    return new InMemoryFileIndex.SerializableFileStatus(status.getPath().toString(), status.getLen(), status.isDirectory(), status.getReplication(), status.getBlockSize(), status.getModificationTime(), status.getAccessTime(), blockLocations);
                }, Seq$.MODULE$.canBuildFrom());
                Tuple2 tuple22 = new Tuple2((Object)path.toString(), (Object)serializableStatuses);
                return tuple22;
            }, ClassTag$.MODULE$.apply(Tuple2.class)).collect();
        }
        finally {
            sparkContext.setJobDescription(previousJobDescription);
        }
        Tuple2[] statusMap = tuple2Array;
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])statusMap)).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String path = (String)tuple2._1();
            Seq serializableStatuses = (Seq)tuple2._2();
            Seq statuses = (Seq)serializableStatuses.map((Function1 & Serializable & scala.Serializable)f -> {
                BlockLocation[] blockLocations = (BlockLocation[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])f.blockLocations())).map((Function1 & Serializable & scala.Serializable)loc -> new BlockLocation(loc.names(), loc.hosts(), loc.offset(), loc.length()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BlockLocation.class)));
                return new LocatedFileStatus(new FileStatus(f.length(), f.isDir(), (int)f.blockReplication(), f.blockSize(), f.modificationTime(), new Path(f.path())), blockLocations);
            }, Seq$.MODULE$.canBuildFrom());
            Tuple2 tuple22 = new Tuple2((Object)new Path(path), (Object)statuses);
            return tuple22;
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    private Seq<FileStatus> listLeafFiles(Path path, Configuration hadoopConf, PathFilter filter, Option<SparkSession> sessionOpt) {
        LocatedFileStatus[] resolvedLeafStatuses;
        block5: {
            Seq seq;
            FileStatus[] fileStatusArray;
            this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(8).append("Listing ").append(path).toString());
            FileSystem fs = path.getFileSystem(hadoopConf);
            try {
                fileStatusArray = fs.listStatus(path);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("The directory ").append(path).append(" was not found. Was it deleted very recently?").toString());
                fileStatusArray = (FileStatus[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(FileStatus.class));
            }
            FileStatus[] statuses = fileStatusArray;
            FileStatus[] filteredStatuses = (FileStatus[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])statuses)).filterNot((Function1 & Serializable & scala.Serializable)status -> BoxesRunTime.boxToBoolean((boolean)InMemoryFileIndex$.MODULE$.shouldFilterOut(status.getPath().getName())));
            Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredStatuses)).partition((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isDirectory()));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            FileStatus[] dirs = (FileStatus[])tuple2._1();
            FileStatus[] topLevelFiles = (FileStatus[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)dirs, (Object)topLevelFiles);
            Tuple2 tuple23 = tuple22;
            FileStatus[] dirs2 = (FileStatus[])tuple23._1();
            FileStatus[] topLevelFiles2 = (FileStatus[])tuple23._2();
            Option<SparkSession> option = sessionOpt;
            if (option instanceof Some) {
                Some some = (Some)option;
                SparkSession session = (SparkSession)some.value();
                seq = (Seq)this.bulkListLeafFiles((Seq<Path>)((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dirs2)).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getPath(), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))), hadoopConf, filter, session).flatMap((Function1 & Serializable & scala.Serializable)x$8 -> (Seq)x$8._2(), Seq$.MODULE$.canBuildFrom());
            } else {
                seq = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dirs2)).flatMap((Function1 & Serializable & scala.Serializable)dir -> MODULE$.listLeafFiles(dir.getPath(), hadoopConf, filter, sessionOpt), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
            }
            Seq nestedFiles = seq;
            FileStatus[] allFiles = (FileStatus[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topLevelFiles2)).$plus$plus((GenTraversableOnce)nestedFiles, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStatus.class)));
            FileStatus[] allLeafStatuses = filter != null ? (FileStatus[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allFiles)).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)filter.accept(f.getPath()))) : allFiles;
            ArrayBuffer missingFiles = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            FileStatus[] filteredLeafStatuses = (FileStatus[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allLeafStatuses)).filterNot((Function1 & Serializable & scala.Serializable)status -> BoxesRunTime.boxToBoolean((boolean)InMemoryFileIndex$.MODULE$.shouldFilterOut(status.getPath().getName())));
            resolvedLeafStatuses = (LocatedFileStatus[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredLeafStatuses)).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Iterable iterable;
                FileStatus fileStatus = x0$1;
                if (fileStatus instanceof LocatedFileStatus) {
                    LocatedFileStatus locatedFileStatus = (LocatedFileStatus)fileStatus;
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)locatedFileStatus));
                } else {
                    Iterable iterable2;
                    try {
                        BlockLocation[] locations = fs.getFileBlockLocations(fileStatus, 0L, fileStatus.getLen());
                        LocatedFileStatus lfs = new LocatedFileStatus(fileStatus.getLen(), fileStatus.isDirectory(), (int)fileStatus.getReplication(), fileStatus.getBlockSize(), fileStatus.getModificationTime(), 0L, null, null, null, null, fileStatus.getPath(), locations);
                        if (fileStatus.isSymlink()) {
                            lfs.setSymlink(fileStatus.getSymlink());
                        }
                        iterable2 = Option$.MODULE$.option2Iterable((Option)new Some((Object)lfs));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        missingFiles.$plus$eq((Object)fileStatus.getPath().toString());
                        iterable2 = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    }
                    iterable = iterable2;
                }
                return iterable;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LocatedFileStatus.class)));
            if (!missingFiles.nonEmpty()) break block5;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("the following files were missing during file scan:\n  ").append(missingFiles.mkString("\n  ")).toString());
        }
        return Predef$.MODULE$.wrapRefArray((Object[])resolvedLeafStatuses);
    }

    public boolean shouldFilterOut(String pathName) {
        boolean exclude = pathName.startsWith("_") && !pathName.contains("=") || pathName.startsWith(".") || pathName.endsWith("._COPYING_");
        boolean include = pathName.startsWith("_common_metadata") || pathName.startsWith("_metadata");
        return exclude && !include;
    }

    private InMemoryFileIndex$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

