/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.parquet.SparkToParquetSchemaConverter;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\tub!B\u0014)\u0001!2\u0004\"\u0002'\u0001\t\u0003qU\u0001B)\u0001\tIC\u0011\u0002\u001a\u0001A\u0002\u0003\u0007I\u0011B3\t\u00131\u0004\u0001\u0019!a\u0001\n\u0013i\u0007\"\u00039\u0001\u0001\u0004\u0005\t\u0015)\u0003g\u0011%\t\b\u00011AA\u0002\u0013%!\u000fC\u0005y\u0001\u0001\u0007\t\u0019!C\u0005s\"I1\u0010\u0001a\u0001\u0002\u0003\u0006Ka\u001d\u0005\ny\u0002\u0001\r\u00111A\u0005\nuD1\"a\u0003\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u000e!Q\u0011\u0011\u0003\u0001A\u0002\u0003\u0005\u000b\u0015\u0002@\t\u0017\u0005M\u0001\u00011AA\u0002\u0013%\u0011Q\u0003\u0005\f\u0003;\u0001\u0001\u0019!a\u0001\n\u0013\ty\u0002C\u0006\u0002$\u0001\u0001\r\u0011!Q!\n\u0005]\u0001bCA\u0013\u0001\u0001\u0007\t\u0019!C\u0005\u0003OA1\"!\u0012\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002H!Y\u00111\n\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0015\u0011%\ti\u0005\u0001b\u0001\n\u0013\ty\u0005\u0003\u0005\u0002Z\u0001\u0001\u000b\u0011BA)\u0011%\tY\u0006\u0001b\u0001\n\u0013\ty\u0005\u0003\u0005\u0002^\u0001\u0001\u000b\u0011BA)\u0011\u001d\ty\u0006\u0001C!\u0003CBq!!(\u0001\t\u0003\ny\nC\u0004\u0002$\u0002!\t%!*\t\u000f\u0005-\u0006\u0001\"\u0003\u0002.\"9\u0011q\u0017\u0001\u0005\n\u0005e\u0006bBAc\u0001\u0011%\u0011q\u0019\u0005\b\u0003#\u0004A\u0011AAj\u0011\u001d\ty\u000e\u0001C\u0005\u0003CDq!!<\u0001\t\u0013\ty\u000fC\u0004\u0002|\u0002!I!!@\t\u000f\t\u0005\u0001\u0001\"\u0003\u0003\u0004\u001dA!\u0011\u0005\u0015\t\u0002!\u0012\u0019CB\u0004(Q!\u0005\u0001F!\n\t\r1\u0013C\u0011\u0001B\u0017\u0011%\u0011yC\tb\u0001\n\u0003\u0011\t\u0004\u0003\u0005\u00034\t\u0002\u000b\u0011\u0002B\u0007\u0011\u001d\u0011)D\tC\u0001\u0005o\u00111\u0003U1scV,Go\u0016:ji\u0016\u001cV\u000f\u001d9peRT!!\u000b\u0016\u0002\u000fA\f'/];fi*\u00111\u0006L\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002.]\u0005IQ\r_3dkRLwN\u001c\u0006\u0003_A\n1a]9m\u0015\t\t$'A\u0003ta\u0006\u00148N\u0003\u00024i\u00051\u0011\r]1dQ\u0016T\u0011!N\u0001\u0004_J<7c\u0001\u00018\rB\u0019\u0001H\u0010!\u000e\u0003eR!AO\u001e\u0002\u0007\u0005\u0004\u0018N\u0003\u0002={\u00051\u0001.\u00193p_BT!!\u000b\u001a\n\u0005}J$\u0001D,sSR,7+\u001e9q_J$\bCA!E\u001b\u0005\u0011%BA\"/\u0003!\u0019\u0017\r^1msN$\u0018BA#C\u0005-Ie\u000e^3s]\u0006d'k\\<\u0011\u0005\u001dSU\"\u0001%\u000b\u0005%\u0003\u0014\u0001C5oi\u0016\u0014h.\u00197\n\u0005-C%a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\tq\n\u0005\u0002Q\u00015\t\u0001FA\u0006WC2,Xm\u0016:ji\u0016\u0014\b#B*W1z\u000bW\"\u0001+\u000b\u0003U\u000bQa]2bY\u0006L!a\u0016+\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004CA-]\u001b\u0005Q&BA.C\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\u0005uS&AE*qK\u000eL\u0017\r\\5{K\u0012<U\r\u001e;feN\u0004\"aU0\n\u0005\u0001$&aA%oiB\u00111KY\u0005\u0003GR\u0013A!\u00168ji\u000611o\u00195f[\u0006,\u0012A\u001a\t\u0003O*l\u0011\u0001\u001b\u0006\u0003S:\nQ\u0001^=qKNL!a\u001b5\u0003\u0015M#(/^2u)f\u0004X-\u0001\u0006tG\",W.Y0%KF$\"!\u00198\t\u000f=$\u0011\u0011!a\u0001M\u0006\u0019\u0001\u0010J\u0019\u0002\u000fM\u001c\u0007.Z7bA\u0005\u0001\"o\\8u\r&,G\u000eZ,sSR,'o]\u000b\u0002gB\u00191\u000b\u001e<\n\u0005U$&!B!se\u0006L\bCA<\u0003\u001b\u0005\u0001\u0011\u0001\u0006:p_R4\u0015.\u001a7e/JLG/\u001a:t?\u0012*\u0017\u000f\u0006\u0002bu\"9qnBA\u0001\u0002\u0004\u0019\u0018!\u0005:p_R4\u0015.\u001a7e/JLG/\u001a:tA\u0005q!/Z2pe\u0012\u001cuN\\:v[\u0016\u0014X#\u0001@\u0011\u0007}\f9!\u0004\u0002\u0002\u0002)\u0019!(a\u0001\u000b\u0007\u0005\u0015Q(\u0001\u0002j_&!\u0011\u0011BA\u0001\u00059\u0011VmY8sI\u000e{gn];nKJ\f!C]3d_J$7i\u001c8tk6,'o\u0018\u0013fcR\u0019\u0011-a\u0004\t\u000f=T\u0011\u0011!a\u0001}\u0006y!/Z2pe\u0012\u001cuN\\:v[\u0016\u0014\b%\u0001\rxe&$X\rT3hC\u000eL\b+\u0019:rk\u0016$hi\u001c:nCR,\"!a\u0006\u0011\u0007M\u000bI\"C\u0002\u0002\u001cQ\u0013qAQ8pY\u0016\fg.\u0001\u000fxe&$X\rT3hC\u000eL\b+\u0019:rk\u0016$hi\u001c:nCR|F%Z9\u0015\u0007\u0005\f\t\u0003\u0003\u0005p\u001b\u0005\u0005\t\u0019AA\f\u0003e9(/\u001b;f\u0019\u0016<\u0017mY=QCJ\fX/\u001a;G_Jl\u0017\r\u001e\u0011\u0002'=,H\u000f];u)&lWm\u001d;b[B$\u0016\u0010]3\u0016\u0005\u0005%\u0002\u0003BA\u0016\u0003{qA!!\f\u000289!\u0011qFA\u001a\u001b\t\t\tD\u0003\u0002J]%!\u0011QGA\u0019\u0003\u001d\u0019\u0016\u000bT\"p]\u001aLA!!\u000f\u0002<\u0005Q\u0002+\u0019:rk\u0016$x*\u001e;qkR$\u0016.\\3ti\u0006l\u0007\u000fV=qK*!\u0011QGA\u0019\u0013\u0011\ty$!\u0011\u0003\u000bY\u000bG.^3\n\u0007\u0005\rCKA\u0006F]VlWM]1uS>t\u0017aF8viB,H\u000fV5nKN$\u0018-\u001c9UsB,w\fJ3r)\r\t\u0017\u0011\n\u0005\t_B\t\t\u00111\u0001\u0002*\u0005!r.\u001e;qkR$\u0016.\\3ti\u0006l\u0007\u000fV=qK\u0002\nq\u0002^5nKN$\u0018-\u001c9Ck\u001a4WM]\u000b\u0003\u0003#\u0002Ba\u0015;\u0002TA\u00191+!\u0016\n\u0007\u0005]CK\u0001\u0003CsR,\u0017\u0001\u0005;j[\u0016\u001cH/Y7q\u0005V4g-\u001a:!\u00035!WmY5nC2\u0014UO\u001a4fe\u0006qA-Z2j[\u0006d')\u001e4gKJ\u0004\u0013\u0001B5oSR$B!a\u0019\u0002\fB!\u0011QMAC\u001d\u0011\t9'!!\u000f\t\u0005%\u0014q\u0010\b\u0005\u0003W\niH\u0004\u0003\u0002n\u0005md\u0002BA8\u0003srA!!\u001d\u0002x5\u0011\u00111\u000f\u0006\u0004\u0003kj\u0015A\u0002\u001fs_>$h(C\u00016\u0013\t\u0019D'\u0003\u0002*e%\u0011A(P\u0005\u0003umJ1!a!:\u000319&/\u001b;f'V\u0004\bo\u001c:u\u0013\u0011\t9)!#\u0003\u0019]\u0013\u0018\u000e^3D_:$X\r\u001f;\u000b\u0007\u0005\r\u0015\bC\u0004\u0002\u000eZ\u0001\r!a$\u0002\u001b\r|gNZ5hkJ\fG/[8o!\u0011\t\t*!'\u000e\u0005\u0005M%\u0002BAK\u0003/\u000bAaY8oM*\u0011AHM\u0005\u0005\u00037\u000b\u0019JA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\u0010aJ,\u0007/\u0019:f\r>\u0014xK]5uKR\u0019\u0011-!)\t\u000bq<\u0002\u0019\u0001@\u0002\u000b]\u0014\u0018\u000e^3\u0015\u0007\u0005\f9\u000b\u0003\u0004\u0002*b\u0001\r\u0001Q\u0001\u0004e><\u0018aC<sSR,g)[3mIN$r!YAX\u0003c\u000b\u0019\f\u0003\u0004\u0002*f\u0001\r\u0001\u0011\u0005\u0006If\u0001\rA\u001a\u0005\u0007\u0003kK\u0002\u0019A:\u0002\u0019\u0019LW\r\u001c3Xe&$XM]:\u0002\u00155\f7.Z,sSR,'\u000fF\u0002w\u0003wCq!!0\u001b\u0001\u0004\ty,\u0001\u0005eCR\fG+\u001f9f!\r9\u0017\u0011Y\u0005\u0004\u0003\u0007D'\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002#5\f7.\u001a#fG&l\u0017\r\\,sSR,'\u000fF\u0003w\u0003\u0013\fi\r\u0003\u0004\u0002Ln\u0001\rAX\u0001\naJ,7-[:j_:Da!a4\u001c\u0001\u0004q\u0016!B:dC2,\u0017aD7bW\u0016\f%O]1z/JLG/\u001a:\u0015\u0007Y\f)\u000eC\u0004\u0002Xr\u0001\r!!7\u0002\u0013\u0005\u0014(/Y=UsB,\u0007cA4\u0002\\&\u0019\u0011Q\u001c5\u0003\u0013\u0005\u0013(/Y=UsB,\u0017!D7bW\u0016l\u0015\r],sSR,'\u000fF\u0002w\u0003GDq!!:\u001e\u0001\u0004\t9/A\u0004nCB$\u0016\u0010]3\u0011\u0007\u001d\fI/C\u0002\u0002l\"\u0014q!T1q)f\u0004X-\u0001\bd_:\u001cX/\\3NKN\u001c\u0018mZ3\u0015\u0007\u0005\f\t\u0010\u0003\u0005\u0002tz!\t\u0019AA{\u0003\u00051\u0007\u0003B*\u0002x\u0006L1!!?U\u0005!a$-\u001f8b[\u0016t\u0014\u0001D2p]N,X.Z$s_V\u0004HcA1\u0002\u0000\"A\u00111_\u0010\u0005\u0002\u0004\t)0\u0001\u0007d_:\u001cX/\\3GS\u0016dG\r\u0006\u0004\u0003\u0006\t%!Q\u0004\u000b\u0004C\n\u001d\u0001\u0002CAzA\u0011\u0005\r!!>\t\u000f\t-\u0001\u00051\u0001\u0003\u000e\u0005)a-[3mIB!!q\u0002B\f\u001d\u0011\u0011\tBa\u0005\u0011\u0007\u0005ED+C\u0002\u0003\u0016Q\u000ba\u0001\u0015:fI\u00164\u0017\u0002\u0002B\r\u00057\u0011aa\u0015;sS:<'b\u0001B\u000b)\"1!q\u0004\u0011A\u0002y\u000bQ!\u001b8eKb\f1\u0003U1scV,Go\u0016:ji\u0016\u001cV\u000f\u001d9peR\u0004\"\u0001\u0015\u0012\u0014\u0007\t\u00129\u0003E\u0002T\u0005SI1Aa\u000bU\u0005\u0019\te.\u001f*fMR\u0011!1E\u0001\u0011'B\u000b%kS0S\u001f^{6k\u0011%F\u001b\u0006+\"A!\u0004\u0002#M\u0003\u0016IU&`%>;vlU\"I\u000b6\u000b\u0005%A\u0005tKR\u001c6\r[3nCR)\u0011M!\u000f\u0003<!)AM\na\u0001M\"9\u0011Q\u0012\u0014A\u0002\u0005=\u0005")
public class ParquetWriteSupport
extends WriteSupport<InternalRow>
implements Logging {
    private StructType schema;
    private Function2<SpecializedGetters, Object, BoxedUnit>[] rootFieldWriters;
    private RecordConsumer recordConsumer;
    private boolean writeLegacyParquetFormat;
    private Enumeration.Value outputTimestampType;
    private final byte[] timestampBuffer;
    private final byte[] decimalBuffer;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void setSchema(StructType structType, Configuration configuration) {
        ParquetWriteSupport$.MODULE$.setSchema(structType, configuration);
    }

    public static String SPARK_ROW_SCHEMA() {
        return ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private StructType schema() {
        return this.schema;
    }

    private void schema_$eq(StructType x$1) {
        this.schema = x$1;
    }

    private Function2<SpecializedGetters, Object, BoxedUnit>[] rootFieldWriters() {
        return this.rootFieldWriters;
    }

    private void rootFieldWriters_$eq(Function2<SpecializedGetters, Object, BoxedUnit>[] x$1) {
        this.rootFieldWriters = x$1;
    }

    private RecordConsumer recordConsumer() {
        return this.recordConsumer;
    }

    private void recordConsumer_$eq(RecordConsumer x$1) {
        this.recordConsumer = x$1;
    }

    private boolean writeLegacyParquetFormat() {
        return this.writeLegacyParquetFormat;
    }

    private void writeLegacyParquetFormat_$eq(boolean x$1) {
        this.writeLegacyParquetFormat = x$1;
    }

    private Enumeration.Value outputTimestampType() {
        return this.outputTimestampType;
    }

    private void outputTimestampType_$eq(Enumeration.Value x$1) {
        this.outputTimestampType = x$1;
    }

    private byte[] timestampBuffer() {
        return this.timestampBuffer;
    }

    private byte[] decimalBuffer() {
        return this.decimalBuffer;
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        String schemaString = configuration.get(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA());
        this.schema_$eq(StructType$.MODULE$.fromString(schemaString));
        Predef$.MODULE$.assert(configuration.get(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key()) != null);
        this.writeLegacyParquetFormat_$eq(new StringOps(Predef$.MODULE$.augmentString(configuration.get(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key()))).toBoolean());
        String key = SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key();
        Predef$.MODULE$.assert(configuration.get(key) != null);
        this.outputTimestampType_$eq(SQLConf.ParquetOutputTimestampType$.MODULE$.withName(configuration.get(key)));
        this.rootFieldWriters_$eq((Function2[])((TraversableOnce)((TraversableLike)this.schema().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.dataType(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)dataType -> this.makeWriter((DataType)dataType), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Function2.class)));
        MessageType messageType = new SparkToParquetSchemaConverter(configuration).convert(this.schema());
        java.util.Map metadata = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ParquetReadSupport$.MODULE$.SPARK_METADATA_KEY()), (Object)schemaString)}))).asJava();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(134).append("Initialized Parquet WriteSupport with Catalyst schema:\n         |").append(this.schema().prettyJson()).append("\n         |and corresponding Parquet message type:\n         |").append(messageType).append("\n       ").toString())).stripMargin());
        return new WriteSupport.WriteContext(messageType, metadata);
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.recordConsumer_$eq(recordConsumer);
    }

    public void write(InternalRow row) {
        this.consumeMessage((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.writeFields(row, this.schema(), this.rootFieldWriters()));
    }

    private void writeFields(InternalRow row, StructType schema, Function2<SpecializedGetters, Object, BoxedUnit>[] fieldWriters) {
        IntRef i = IntRef.create((int)0);
        while (i.elem < row.numFields()) {
            if (!row.isNullAt(i.elem)) {
                this.consumeField(schema.apply(i.elem).name(), i.elem, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fieldWriters[i$1.elem].apply((Object)row, (Object)BoxesRunTime.boxToInteger((int)i$1.elem)));
            }
            ++i.elem;
        }
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> makeWriter(DataType dataType2) {
        Function2 & Serializable & scala.Serializable intersect;
        block21: {
            while (true) {
                DecimalType decimalType;
                Option option;
                DataType dataType3;
                if (BooleanType$.MODULE$.equals(dataType3 = dataType2)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$1(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (ByteType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$2(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (ShortType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$3(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                boolean bl = IntegerType$.MODULE$.equals(dataType3) ? true : DateType$.MODULE$.equals(dataType3);
                if (bl) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$4(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (LongType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$5(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (FloatType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$6(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (DoubleType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$7(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (StringType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$8(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (TimestampType$.MODULE$.equals(dataType3)) {
                    Function2 & Serializable & scala.Serializable intersect2;
                    Enumeration.Value value = this.outputTimestampType();
                    Enumeration.Value value2 = SQLConf.ParquetOutputTimestampType$.MODULE$.INT96();
                    Enumeration.Value value3 = value;
                    if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                        intersect2 = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                            ParquetWriteSupport.$anonfun$makeWriter$9(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                            return BoxedUnit.UNIT;
                        };
                    } else {
                        Enumeration.Value value4 = SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MICROS();
                        Enumeration.Value value5 = value;
                        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                            intersect2 = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                                ParquetWriteSupport.$anonfun$makeWriter$10(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                                return BoxedUnit.UNIT;
                            };
                        } else {
                            Enumeration.Value value6 = SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MILLIS();
                            Enumeration.Value value7 = value;
                            if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                                intersect2 = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                                    ParquetWriteSupport.$anonfun$makeWriter$11(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                                    return BoxedUnit.UNIT;
                                };
                            } else {
                                throw new MatchError((Object)value);
                            }
                        }
                    }
                    intersect = intersect2;
                    break block21;
                }
                if (BinaryType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$12(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (dataType3 instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType3)).isEmpty()) {
                    int precision = ((Tuple2)option.get())._1$mcI$sp();
                    int scale = ((Tuple2)option.get())._2$mcI$sp();
                    intersect = this.makeDecimalWriter(precision, scale);
                    break block21;
                }
                if (dataType3 instanceof StructType) {
                    StructType structType = (StructType)dataType3;
                    Function2[] fieldWriters = (Function2[])((TraversableOnce)((TraversableLike)structType.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.dataType(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)dataType -> this.makeWriter((DataType)dataType), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Function2.class));
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.writeFields(row.getStruct(BoxesRunTime.unboxToInt((Object)ordinal), structType.length()), structType, fieldWriters));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (dataType3 instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType3;
                    intersect = this.makeArrayWriter(arrayType);
                    break block21;
                }
                if (dataType3 instanceof MapType) {
                    MapType mapType = (MapType)dataType3;
                    intersect = this.makeMapWriter(mapType);
                    break block21;
                }
                if (!(dataType3 instanceof UserDefinedType)) break;
                UserDefinedType userDefinedType = (UserDefinedType)dataType3;
                dataType2 = userDefinedType.sqlType();
            }
            throw package$.MODULE$.error(new StringBuilder(23).append("Unsupported data type ").append(dataType2).append(".").toString());
        }
        return intersect;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Function2<SpecializedGetters, Object, BoxedUnit> makeDecimalWriter(int precision, int scale) {
        Predef$.MODULE$.assert(precision <= DecimalType$.MODULE$.MAX_PRECISION(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Decimal precision ").append(precision).append(" exceeds max precision ").append(DecimalType$.MODULE$.MAX_PRECISION()).toString());
        int numBytes = Decimal$.MODULE$.minBytesForPrecision()[precision];
        Function2 & Serializable & scala.Serializable int32Writer = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeDecimalWriter$2(this, precision, scale, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable & scala.Serializable int64Writer = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeDecimalWriter$3(this, precision, scale, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable & scala.Serializable binaryWriterUsingUnscaledLong = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeDecimalWriter$4(this, precision, scale, numBytes, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable & scala.Serializable binaryWriterUsingUnscaledBytes = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeDecimalWriter$5(this, precision, scale, numBytes, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = this.writeLegacyParquetFormat();
        if (!bl3) {
            bl = true;
            bl2 = bl3;
            if (precision <= Decimal$.MODULE$.MAX_INT_DIGITS()) {
                return int32Writer;
            }
        }
        if (bl && precision <= Decimal$.MODULE$.MAX_LONG_DIGITS()) {
            return int64Writer;
        }
        if (true != bl3) return binaryWriterUsingUnscaledBytes;
        if (precision > Decimal$.MODULE$.MAX_LONG_DIGITS()) return binaryWriterUsingUnscaledBytes;
        return binaryWriterUsingUnscaledLong;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Function2<SpecializedGetters, Object, BoxedUnit> makeArrayWriter(ArrayType arrayType) {
        boolean bl;
        Function2<SpecializedGetters, Object, BoxedUnit> elementWriter = this.makeWriter(arrayType.elementType());
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(this.writeLegacyParquetFormat(), arrayType.containsNull());
        if (sp2 != null && !(bl = sp2._1$mcZ$sp())) {
            return this.threeLevelArrayWriter$1("list", "element", elementWriter);
        }
        if (sp2 != null) {
            boolean bl2 = sp2._1$mcZ$sp();
            boolean bl3 = sp2._2$mcZ$sp();
            if (bl2 && bl3) {
                return this.threeLevelArrayWriter$1("bag", "array", elementWriter);
            }
        }
        if (sp2 == null) throw new MatchError((Object)sp2);
        boolean bl4 = sp2._1$mcZ$sp();
        boolean bl5 = sp2._2$mcZ$sp();
        if (true != bl4) throw new MatchError((Object)sp2);
        if (false != bl5) throw new MatchError((Object)sp2);
        return this.twoLevelArrayWriter$1("array", elementWriter);
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> makeMapWriter(MapType mapType) {
        Function2<SpecializedGetters, Object, BoxedUnit> keyWriter = this.makeWriter(mapType.keyType());
        Function2<SpecializedGetters, Object, BoxedUnit> valueWriter = this.makeWriter(mapType.valueType());
        String repeatedGroupName = this.writeLegacyParquetFormat() ? "map" : "key_value";
        return (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeMapWriter$1(this, repeatedGroupName, keyWriter, valueWriter, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
    }

    private void consumeMessage(Function0<BoxedUnit> f) {
        this.recordConsumer().startMessage();
        f.apply$mcV$sp();
        this.recordConsumer().endMessage();
    }

    private void consumeGroup(Function0<BoxedUnit> f) {
        this.recordConsumer().startGroup();
        f.apply$mcV$sp();
        this.recordConsumer().endGroup();
    }

    private void consumeField(String field, int index, Function0<BoxedUnit> f) {
        this.recordConsumer().startField(field, index);
        f.apply$mcV$sp();
        this.recordConsumer().endField(field, index);
    }

    public static final /* synthetic */ void $anonfun$makeWriter$1(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addBoolean(row.getBoolean(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$2(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger((int)row.getByte(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$3(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger((int)row.getShort(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$4(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger(row.getInt(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$5(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addLong(row.getLong(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$6(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addFloat(row.getFloat(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$7(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addDouble(row.getDouble(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$8(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])row.getUTF8String(ordinal).getBytes()));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$9(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        Tuple2 tuple2 = DateTimeUtils$.MODULE$.toJulianDay(row.getLong(ordinal));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int julianDay = tuple2._1$mcI$sp();
        long timeOfDayNanos = tuple2._2$mcJ$sp();
        Tuple2.mcIJ.sp sp2 = new Tuple2.mcIJ.sp(julianDay, timeOfDayNanos);
        Tuple2.mcIJ.sp sp3 = sp2;
        int julianDay2 = sp3._1$mcI$sp();
        long timeOfDayNanos2 = sp3._2$mcJ$sp();
        ByteBuffer buf = ByteBuffer.wrap($this.timestampBuffer());
        buf.order(ByteOrder.LITTLE_ENDIAN).putLong(timeOfDayNanos2).putInt(julianDay2);
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])$this.timestampBuffer()));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$10(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addLong(row.getLong(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$11(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        long millis = DateTimeUtils$.MODULE$.toMillis(row.getLong(ordinal));
        $this.recordConsumer().addLong(millis);
    }

    public static final /* synthetic */ void $anonfun$makeWriter$12(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])row.getBinary(ordinal)));
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$2(ParquetWriteSupport $this, int precision$1, int scale$1, SpecializedGetters row, int ordinal) {
        long unscaledLong = row.getDecimal(ordinal, precision$1, scale$1).toUnscaledLong();
        $this.recordConsumer().addInteger((int)unscaledLong);
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$3(ParquetWriteSupport $this, int precision$1, int scale$1, SpecializedGetters row, int ordinal) {
        long unscaledLong = row.getDecimal(ordinal, precision$1, scale$1).toUnscaledLong();
        $this.recordConsumer().addLong(unscaledLong);
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$4(ParquetWriteSupport $this, int precision$1, int scale$1, int numBytes$1, SpecializedGetters row, int ordinal) {
        long unscaled = row.getDecimal(ordinal, precision$1, scale$1).toUnscaledLong();
        int i = 0;
        int shift = 8 * (numBytes$1 - 1);
        while (i < numBytes$1) {
            $this.decimalBuffer()[i] = (byte)(unscaled >> shift);
            ++i;
            shift -= 8;
        }
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])$this.decimalBuffer(), (int)0, (int)numBytes$1));
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$5(ParquetWriteSupport $this, int precision$1, int scale$1, int numBytes$1, SpecializedGetters row, int ordinal) {
        byte[] byArray;
        Decimal decimal = row.getDecimal(ordinal, precision$1, scale$1);
        byte[] bytes = decimal.toJavaBigDecimal().unscaledValue().toByteArray();
        if (bytes.length == numBytes$1) {
            byArray = bytes;
        } else {
            byte signByte = BoxesRunTime.unboxToByte((Object)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).head()) < 0 ? (byte)-1 : 0;
            Arrays.fill($this.decimalBuffer(), 0, numBytes$1 - bytes.length, signByte);
            System.arraycopy(bytes, 0, $this.decimalBuffer(), numBytes$1 - bytes.length, bytes.length);
            byArray = $this.decimalBuffer();
        }
        byte[] fixedLengthBytes = byArray;
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])fixedLengthBytes, (int)0, (int)numBytes$1));
    }

    public static final /* synthetic */ void $anonfun$makeArrayWriter$1(ParquetWriteSupport $this, String repeatedGroupName$1, String elementFieldName$1, Function2 elementWriter$1, SpecializedGetters row, int ordinal) {
        ArrayData array = row.getArray(ordinal);
        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (array.numElements() <= 0) break block0;
                $this.consumeField(repeatedGroupName$1, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    IntRef i = IntRef.create((int)0);
                    while (i.elem < array.numElements()) {
                        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                            block0: {
                                if (array.isNullAt(i$2.elem)) break block0;
                                $this.consumeField(elementFieldName$1, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> elementWriter$1.apply((Object)array, (Object)BoxesRunTime.boxToInteger((int)i$2.elem)));
                            }
                        });
                        ++i.elem;
                    }
                });
            }
        });
    }

    private final Function2 threeLevelArrayWriter$1(String repeatedGroupName, String elementFieldName, Function2 elementWriter$1) {
        return (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeArrayWriter$1(this, repeatedGroupName, elementFieldName, elementWriter$1, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
    }

    public static final /* synthetic */ void $anonfun$makeArrayWriter$6(ParquetWriteSupport $this, String repeatedFieldName$1, Function2 elementWriter$1, SpecializedGetters row, int ordinal) {
        ArrayData array = row.getArray(ordinal);
        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (array.numElements() <= 0) break block0;
                $this.consumeField(repeatedFieldName$1, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    for (int i = 0; i < array.numElements(); ++i) {
                        elementWriter$1.apply((Object)array, (Object)BoxesRunTime.boxToInteger((int)i));
                    }
                });
            }
        });
    }

    private final Function2 twoLevelArrayWriter$1(String repeatedFieldName, Function2 elementWriter$1) {
        return (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeArrayWriter$6(this, repeatedFieldName, elementWriter$1, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
    }

    public static final /* synthetic */ void $anonfun$makeMapWriter$1(ParquetWriteSupport $this, String repeatedGroupName$2, Function2 keyWriter$1, Function2 valueWriter$1, SpecializedGetters row, int ordinal) {
        MapData map = row.getMap(ordinal);
        ArrayData keyArray = map.keyArray();
        ArrayData valueArray = map.valueArray();
        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (map.numElements() <= 0) break block0;
                $this.consumeField(repeatedGroupName$2, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    IntRef i = IntRef.create((int)0);
                    while (i.elem < map.numElements()) {
                        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                            block0: {
                                $this.consumeField("key", 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> keyWriter$1.apply((Object)keyArray, (Object)BoxesRunTime.boxToInteger((int)i$3.elem)));
                                if (map.valueArray().isNullAt(i$3.elem)) break block0;
                                $this.consumeField("value", 1, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> valueWriter$1.apply((Object)valueArray, (Object)BoxesRunTime.boxToInteger((int)i$3.elem)));
                            }
                        });
                        ++i.elem;
                    }
                });
            }
        });
    }

    public ParquetWriteSupport() {
        Logging.$init$((Logging)this);
        this.timestampBuffer = new byte[12];
        this.decimalBuffer = new byte[Decimal$.MODULE$.minBytesForPrecision()[DecimalType$.MODULE$.MAX_PRECISION()]];
    }
}

