/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.sql.Date;
import java.util.NoSuchElementException;
import org.apache.spark.sql.catalyst.plans.logical.EventTimeTimeout$;
import org.apache.spark.sql.catalyst.plans.logical.ProcessingTimeTimeout$;
import org.apache.spark.sql.execution.streaming.GroupStateImpl$;
import org.apache.spark.sql.streaming.GroupState;
import org.apache.spark.sql.streaming.GroupStateTimeout;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ug!\u0002\u001a4\u0001]z\u0004\u0002\u0003-\u0001\u0005\u0003\u0005\u000b\u0011B-\t\u0011q\u0003!\u0011!Q\u0001\nuC\u0001\u0002\u0019\u0001\u0003\u0002\u0003\u0006I!\u0018\u0005\tC\u0002\u0011\t\u0011)A\u0005E\"AQ\r\u0001BC\u0002\u0013\u0005c\r\u0003\u0005k\u0001\t\u0005\t\u0015!\u0003h\u0011!Y\u0007A!A!\u0002\u00139\u0007\"\u00027\u0001\t\u0013i\u0007b\u0002<\u0001\u0001\u0004%Ia\u001e\u0005\bq\u0002\u0001\r\u0011\"\u0003z\u0011\u0019y\b\u0001)Q\u0005\u0019\"A\u0011\u0011\u0001\u0001A\u0002\u0013%a\rC\u0005\u0002\u0004\u0001\u0001\r\u0011\"\u0003\u0002\u0006!9\u0011\u0011\u0002\u0001!B\u00139\u0007\u0002CA\u0006\u0001\u0001\u0007I\u0011\u00024\t\u0013\u00055\u0001\u00011A\u0005\n\u0005=\u0001bBA\n\u0001\u0001\u0006Ka\u001a\u0005\t\u0003+\u0001\u0001\u0019!C\u0005M\"I\u0011q\u0003\u0001A\u0002\u0013%\u0011\u0011\u0004\u0005\b\u0003;\u0001\u0001\u0015)\u0003h\u0011%\ty\u0002\u0001a\u0001\n\u0013\t\t\u0003C\u0005\u0002$\u0001\u0001\r\u0011\"\u0003\u0002&!9\u0011\u0011\u0006\u0001!B\u0013i\u0006BBA\u0016\u0001\u0011\u0005c\r\u0003\u0004\u0002.\u0001!\te\u001e\u0005\b\u0003_\u0001A\u0011IA\u0019\u0011\u001d\t\u0019\u0004\u0001C!\u0003kAq!a\u000f\u0001\t\u0003\ni\u0004C\u0004\u0002@\u0001!\t%!\u0011\t\u000f\u0005}\u0002\u0001\"\u0011\u0002H!9\u00111\r\u0001\u0005B\u0005\u0015\u0004bBA2\u0001\u0011\u0005\u00131\u000e\u0005\b\u0003G\u0002A\u0011IA:\u0011\u001d\t\u0019\u0007\u0001C!\u0003\u000fCq!!$\u0001\t\u0003\ny\tC\u0004\u0002\u0012\u0002!\t%a$\t\u000f\u0005M\u0005\u0001\"\u0011\u0002\u0016\"1\u0011q\u0013\u0001\u0005\u0002\u0019Da!!'\u0001\t\u00031\u0007bBAN\u0001\u0011\u0005\u0011\u0011\u0005\u0005\b\u0003;\u0003A\u0011BAP\u0011\u001d\t\u0019\u000b\u0001C\u0005\u0003{9\u0001\"!*4\u0011\u00039\u0014q\u0015\u0004\beMB\taNAU\u0011\u0019aG\u0006\"\u0001\u0002,\"I\u0011Q\u0016\u0017C\u0002\u0013\u0005\u0011\u0011\u0005\u0005\b\u0003_c\u0003\u0015!\u0003^\u0011\u001d\t\t\f\fC\u0001\u0003gCq!a3-\t\u0003\tiM\u0001\bHe>,\bo\u0015;bi\u0016LU\u000e\u001d7\u000b\u0005Q*\u0014!C:ue\u0016\fW.\u001b8h\u0015\t1t'A\u0005fq\u0016\u001cW\u000f^5p]*\u0011\u0001(O\u0001\u0004gFd'B\u0001\u001e<\u0003\u0015\u0019\b/\u0019:l\u0015\taT(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002}\u0005\u0019qN]4\u0016\u0005\u0001s5c\u0001\u0001B\u000fB\u0011!)R\u0007\u0002\u0007*\tA)A\u0003tG\u0006d\u0017-\u0003\u0002G\u0007\n1\u0011I\\=SK\u001a\u00042\u0001\u0013&M\u001b\u0005I%B\u0001\u001b8\u0013\tY\u0015J\u0001\u0006He>,\bo\u0015;bi\u0016\u0004\"!\u0014(\r\u0001\u0011)q\n\u0001b\u0001#\n\t1k\u0001\u0001\u0012\u0005I+\u0006C\u0001\"T\u0013\t!6IA\u0004O_RD\u0017N\\4\u0011\u0005\t3\u0016BA,D\u0005\r\te._\u0001\u000e_B$\u0018n\u001c8bYZ\u000bG.^3\u0011\u0007\tSF*\u0003\u0002\\\u0007\n1q\n\u001d;j_:\fQCY1uG\"\u0004&o\\2fgNLgn\u001a+j[\u0016l5\u000f\u0005\u0002C=&\u0011ql\u0011\u0002\u0005\u0019>tw-\u0001\u000bfm\u0016tG\u000fV5nK^\u000bG/\u001a:nCJ\\Wj]\u0001\fi&lWm\\;u\u0007>tg\r\u0005\u0002IG&\u0011A-\u0013\u0002\u0012\u000fJ|W\u000f]*uCR,G+[7f_V$\u0018a\u00035bgRKW.\u001a3PkR,\u0012a\u001a\t\u0003\u0005\"L!![\"\u0003\u000f\t{w\u000e\\3b]\u0006a\u0001.Y:US6,GmT;uA\u0005\u0001r/\u0019;fe6\f'o\u001b)sKN,g\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f9\u0004\u0018O]:ukB\u0019q\u000e\u0001'\u000e\u0003MBQ\u0001\u0017\u0005A\u0002eCQ\u0001\u0018\u0005A\u0002uCQ\u0001\u0019\u0005A\u0002uCQ!\u0019\u0005A\u0002\tDQ!\u001a\u0005A\u0002\u001dDQa\u001b\u0005A\u0002\u001d\fQA^1mk\u0016,\u0012\u0001T\u0001\nm\u0006dW/Z0%KF$\"A_?\u0011\u0005\t[\u0018B\u0001?D\u0005\u0011)f.\u001b;\t\u000fyT\u0011\u0011!a\u0001\u0019\u0006\u0019\u0001\u0010J\u0019\u0002\rY\fG.^3!\u0003\u001d!WMZ5oK\u0012\f1\u0002Z3gS:,Gm\u0018\u0013fcR\u0019!0a\u0002\t\u000fyl\u0011\u0011!a\u0001O\u0006AA-\u001a4j]\u0016$\u0007%A\u0004va\u0012\fG/\u001a3\u0002\u0017U\u0004H-\u0019;fI~#S-\u001d\u000b\u0004u\u0006E\u0001b\u0002@\u0011\u0003\u0003\u0005\raZ\u0001\tkB$\u0017\r^3eA\u00059!/Z7pm\u0016$\u0017a\u0003:f[>4X\rZ0%KF$2A_A\u000e\u0011\u001dq8#!AA\u0002\u001d\f\u0001B]3n_Z,G\rI\u0001\u0011i&lWm\\;u)&lWm\u001d;b[B,\u0012!X\u0001\u0015i&lWm\\;u)&lWm\u001d;b[B|F%Z9\u0015\u0007i\f9\u0003C\u0004\u007f-\u0005\u0005\t\u0019A/\u0002#QLW.Z8viRKW.Z:uC6\u0004\b%\u0001\u0004fq&\u001cHo]\u0001\u0004O\u0016$\u0018!C4fi>\u0003H/[8o+\u0005I\u0016AB;qI\u0006$X\rF\u0002{\u0003oAa!!\u000f\u001c\u0001\u0004a\u0015\u0001\u00038foZ\u000bG.^3\u0002\rI,Wn\u001c<f)\u0005Q\u0018AE:fiRKW.Z8vi\u0012+(/\u0019;j_:$2A_A\"\u0011\u0019\t)%\ba\u0001;\u0006QA-\u001e:bi&|g.T:\u0015\u0007i\fI\u0005C\u0004\u0002Ly\u0001\r!!\u0014\u0002\u0011\u0011,(/\u0019;j_:\u0004B!a\u0014\u0002^9!\u0011\u0011KA-!\r\t\u0019fQ\u0007\u0003\u0003+R1!a\u0016Q\u0003\u0019a$o\\8u}%\u0019\u00111L\"\u0002\rA\u0013X\rZ3g\u0013\u0011\ty&!\u0019\u0003\rM#(/\u001b8h\u0015\r\tYfQ\u0001\u0014g\u0016$H+[7f_V$H+[7fgR\fW\u000e\u001d\u000b\u0004u\u0006\u001d\u0004BBA5?\u0001\u0007Q,A\u0006uS6,7\u000f^1na6\u001bH#\u0002>\u0002n\u0005=\u0004BBA5A\u0001\u0007Q\fC\u0004\u0002r\u0001\u0002\r!!\u0014\u0002%\u0005$G-\u001b;j_:\fG\u000eR;sCRLwN\u001c\u000b\u0004u\u0006U\u0004bBA<C\u0001\u0007\u0011\u0011P\u0001\ni&lWm\u001d;b[B\u0004B!a\u001f\u0002\u00046\u0011\u0011Q\u0010\u0006\u0004q\u0005}$BAAA\u0003\u0011Q\u0017M^1\n\t\u0005\u0015\u0015Q\u0010\u0002\u0005\t\u0006$X\rF\u0003{\u0003\u0013\u000bY\tC\u0004\u0002x\t\u0002\r!!\u001f\t\u000f\u0005E$\u00051\u0001\u0002N\u0005)r-\u001a;DkJ\u0014XM\u001c;XCR,'/\\1sW6\u001bH#A/\u00025\u001d,GoQ;se\u0016tG\u000f\u0015:pG\u0016\u001c8/\u001b8h)&lW-T:\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0014\u0002\u0015!\f7OU3n_Z,G-\u0001\u0006iCN,\u0006\u000fZ1uK\u0012\f1cZ3u)&lWm\\;u)&lWm\u001d;b[B\fQ\u0002]1sg\u0016$UO]1uS>tGcA/\u0002\"\"9\u00111J\u0015A\u0002\u00055\u0013\u0001H2iK\u000e\\G+[7f_V$H+[7fgR\fW\u000e]!mY><X\rZ\u0001\u000f\u000fJ|W\u000f]*uCR,\u0017*\u001c9m!\tyGf\u0005\u0002-\u0003R\u0011\u0011qU\u0001\r\u001d>{F+S'F'R\u000bU\nU\u0001\u000e\u001d>{F+S'F'R\u000bU\n\u0015\u0011\u0002%\r\u0014X-\u0019;f\r>\u00148\u000b\u001e:fC6LgnZ\u000b\u0005\u0003k\u000bY\f\u0006\b\u00028\u0006u\u0016\u0011YAb\u0003\u000b\f9-!3\u0011\t=\u0004\u0011\u0011\u0018\t\u0004\u001b\u0006mF!B(1\u0005\u0004\t\u0006B\u0002-1\u0001\u0004\ty\f\u0005\u0003C5\u0006e\u0006\"\u0002/1\u0001\u0004i\u0006\"\u000211\u0001\u0004i\u0006\"B11\u0001\u0004\u0011\u0007\"B31\u0001\u00049\u0007\"B61\u0001\u00049\u0017AD2sK\u0006$XMR8s\u0005\u0006$8\r\u001b\u000b\u0007\u0003\u001f\f\t.a5\u0011\u0007=\u0004Q\u000bC\u0003bc\u0001\u0007!\rC\u0003lc\u0001\u0007q\r")
public class GroupStateImpl<S>
implements GroupState<S> {
    private final long batchProcessingTimeMs;
    private final long eventTimeWatermarkMs;
    private final GroupStateTimeout timeoutConf;
    private final boolean hasTimedOut;
    private final boolean watermarkPresent;
    private S value;
    private boolean defined;
    private boolean updated;
    private boolean removed;
    private long timeoutTimestamp;

    public static GroupStateImpl<Object> createForBatch(GroupStateTimeout groupStateTimeout, boolean bl) {
        return GroupStateImpl$.MODULE$.createForBatch(groupStateTimeout, bl);
    }

    public static <S> GroupStateImpl<S> createForStreaming(Option<S> option, long l, long l2, GroupStateTimeout groupStateTimeout, boolean bl, boolean bl2) {
        return GroupStateImpl$.MODULE$.createForStreaming(option, l, l2, groupStateTimeout, bl, bl2);
    }

    public static long NO_TIMESTAMP() {
        return GroupStateImpl$.MODULE$.NO_TIMESTAMP();
    }

    @Override
    public boolean hasTimedOut() {
        return this.hasTimedOut;
    }

    private S value() {
        return this.value;
    }

    private void value_$eq(S x$1) {
        this.value = x$1;
    }

    private boolean defined() {
        return this.defined;
    }

    private void defined_$eq(boolean x$1) {
        this.defined = x$1;
    }

    private boolean updated() {
        return this.updated;
    }

    private void updated_$eq(boolean x$1) {
        this.updated = x$1;
    }

    private boolean removed() {
        return this.removed;
    }

    private void removed_$eq(boolean x$1) {
        this.removed = x$1;
    }

    private long timeoutTimestamp() {
        return this.timeoutTimestamp;
    }

    private void timeoutTimestamp_$eq(long x$1) {
        this.timeoutTimestamp = x$1;
    }

    @Override
    public boolean exists() {
        return this.defined();
    }

    @Override
    public S get() {
        if (!this.defined()) {
            throw new NoSuchElementException("State is either not defined or has already been removed");
        }
        return this.value();
    }

    @Override
    public Option<S> getOption() {
        return this.defined() ? new Some(this.value()) : None$.MODULE$;
    }

    @Override
    public void update(S newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("'null' is not a valid state value");
        }
        this.value_$eq(newValue);
        this.defined_$eq(true);
        this.updated_$eq(true);
        this.removed_$eq(false);
    }

    @Override
    public void remove() {
        this.defined_$eq(false);
        this.updated_$eq(false);
        this.removed_$eq(true);
    }

    @Override
    public void setTimeoutDuration(long durationMs) {
        GroupStateTimeout groupStateTimeout = this.timeoutConf;
        ProcessingTimeTimeout$ processingTimeTimeout$ = ProcessingTimeTimeout$.MODULE$;
        if (groupStateTimeout == null ? processingTimeTimeout$ != null : !groupStateTimeout.equals(processingTimeTimeout$)) {
            throw new UnsupportedOperationException("Cannot set timeout duration without enabling processing time timeout in [map|flatMap]GroupsWithState");
        }
        if (durationMs <= 0L) {
            throw new IllegalArgumentException("Timeout duration must be positive");
        }
        this.timeoutTimestamp_$eq(durationMs + this.batchProcessingTimeMs);
    }

    @Override
    public void setTimeoutDuration(String duration) {
        this.setTimeoutDuration(this.parseDuration(duration));
    }

    @Override
    public void setTimeoutTimestamp(long timestampMs) {
        this.checkTimeoutTimestampAllowed();
        if (timestampMs <= 0L) {
            throw new IllegalArgumentException("Timeout timestamp must be positive");
        }
        if (this.eventTimeWatermarkMs != GroupStateImpl$.MODULE$.NO_TIMESTAMP() && timestampMs < this.eventTimeWatermarkMs) {
            throw new IllegalArgumentException(new StringBuilder(48).append("Timeout timestamp (").append(timestampMs).append(") cannot be earlier than the ").append(new StringBuilder(20).append("current watermark (").append(this.eventTimeWatermarkMs).append(")").toString()).toString());
        }
        this.timeoutTimestamp_$eq(timestampMs);
    }

    @Override
    public void setTimeoutTimestamp(long timestampMs, String additionalDuration) {
        this.checkTimeoutTimestampAllowed();
        this.setTimeoutTimestamp(this.parseDuration(additionalDuration) + timestampMs);
    }

    @Override
    public void setTimeoutTimestamp(Date timestamp) {
        this.checkTimeoutTimestampAllowed();
        this.setTimeoutTimestamp(timestamp.getTime());
    }

    @Override
    public void setTimeoutTimestamp(Date timestamp, String additionalDuration) {
        this.checkTimeoutTimestampAllowed();
        this.setTimeoutTimestamp(timestamp.getTime() + this.parseDuration(additionalDuration));
    }

    @Override
    public long getCurrentWatermarkMs() {
        if (!this.watermarkPresent) {
            throw new UnsupportedOperationException("Cannot get event time watermark timestamp without setting watermark before [map|flatMap]GroupsWithState");
        }
        return this.eventTimeWatermarkMs;
    }

    @Override
    public long getCurrentProcessingTimeMs() {
        return this.batchProcessingTimeMs;
    }

    public String toString() {
        return new StringBuilder(12).append("GroupState(").append(this.getOption().map((Function1 & java.io.Serializable & Serializable)x$1 -> x$1.toString()).getOrElse((Function0 & java.io.Serializable & Serializable)() -> "<undefined>")).append(")").toString();
    }

    public boolean hasRemoved() {
        return this.removed();
    }

    public boolean hasUpdated() {
        return this.updated();
    }

    public long getTimeoutTimestamp() {
        return this.timeoutTimestamp();
    }

    private long parseDuration(String duration) {
        CalendarInterval cal = CalendarInterval.fromCaseInsensitiveString((String)duration);
        if (cal.milliseconds() < 0L || cal.months < 0) {
            throw new IllegalArgumentException(new StringBuilder(36).append("Provided duration (").append(duration).append(") is not positive").toString());
        }
        long millisPerMonth = 2678400000L;
        return cal.milliseconds() + (long)cal.months * millisPerMonth;
    }

    private void checkTimeoutTimestampAllowed() {
        GroupStateTimeout groupStateTimeout = this.timeoutConf;
        EventTimeTimeout$ eventTimeTimeout$ = EventTimeTimeout$.MODULE$;
        if (groupStateTimeout == null ? eventTimeTimeout$ != null : !groupStateTimeout.equals(eventTimeTimeout$)) {
            throw new UnsupportedOperationException("Cannot set timeout timestamp without enabling event time timeout in [map|flatMapGroupsWithState");
        }
    }

    public GroupStateImpl(Option<S> optionalValue, long batchProcessingTimeMs, long eventTimeWatermarkMs, GroupStateTimeout timeoutConf, boolean hasTimedOut, boolean watermarkPresent) {
        this.batchProcessingTimeMs = batchProcessingTimeMs;
        this.eventTimeWatermarkMs = eventTimeWatermarkMs;
        this.timeoutConf = timeoutConf;
        this.hasTimedOut = hasTimedOut;
        this.watermarkPresent = watermarkPresent;
        this.value = optionalValue.getOrElse((Function0 & java.io.Serializable & Serializable)() -> null);
        this.defined = optionalValue.isDefined();
        this.updated = false;
        this.removed = false;
        this.timeoutTimestamp = GroupStateImpl$.MODULE$.NO_TIMESTAMP();
    }
}

