/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.sources;

import java.util.Optional;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.execution.streaming.continuous.RateStreamContinuousReader;
import org.apache.spark.sql.execution.streaming.sources.RateStreamMicroBatchReader;
import org.apache.spark.sql.execution.streaming.sources.RateStreamProvider$;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.v2.ContinuousReadSupport;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.MicroBatchReadSupport;
import org.apache.spark.sql.sources.v2.reader.streaming.ContinuousReader;
import org.apache.spark.sql.sources.v2.reader.streaming.MicroBatchReader;
import org.apache.spark.sql.types.StructType;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001B\n\u0015\u0001\rBQ!\u0010\u0001\u0005\u0002yBQ!\u0011\u0001\u0005B\tCQ\u0001\u001c\u0001\u0005B5DQ\u0001\u001e\u0001\u0005BU<QA\u001e\u000b\t\u0002]4Qa\u0005\u000b\t\u0002aDQ!\u0010\u0004\u0005\u0002uDqA \u0004C\u0002\u0013\u0005q\u0010C\u0004\u0002\u0002\u0019\u0001\u000b\u0011\u0002*\t\u0013\u0005\raA1A\u0005\u0002\u0005\u0015\u0001\u0002CA\u0007\r\u0001\u0006I!a\u0002\t\u0013\u0005=aA1A\u0005\u0002\u0005E\u0001\u0002CA\f\r\u0001\u0006I!a\u0005\t\u0013\u0005eaA1A\u0005\u0002\u0005E\u0001\u0002CA\u000e\r\u0001\u0006I!a\u0005\t\u0013\u0005uaA1A\u0005\u0002\u0005E\u0001\u0002CA\u0010\r\u0001\u0006I!a\u0005\t\u000f\u0005\u0005b\u0001\"\u0001\u0002$\t\u0011\"+\u0019;f'R\u0014X-Y7Qe>4\u0018\u000eZ3s\u0015\t)b#A\u0004t_V\u00148-Z:\u000b\u0005]A\u0012!C:ue\u0016\fW.\u001b8h\u0015\tI\"$A\u0005fq\u0016\u001cW\u000f^5p]*\u00111\u0004H\u0001\u0004gFd'BA\u000f\u001f\u0003\u0015\u0019\b/\u0019:l\u0015\ty\u0002%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002C\u0005\u0019qN]4\u0004\u0001M1\u0001\u0001\n\u00174me\u0002\"!\n\u0016\u000e\u0003\u0019R!a\n\u0015\u0002\t1\fgn\u001a\u0006\u0002S\u0005!!.\u0019<b\u0013\tYcE\u0001\u0004PE*,7\r\u001e\t\u0003[Ej\u0011A\f\u0006\u0003_A\n!A\u001e\u001a\u000b\u0005UQ\u0012B\u0001\u001a/\u00051!\u0015\r^1T_V\u00148-\u001a,3!\tiC'\u0003\u00026]\t)R*[2s_\n\u000bGo\u00195SK\u0006$7+\u001e9q_J$\bCA\u00178\u0013\tAdFA\u000bD_:$\u0018N\\;pkN\u0014V-\u00193TkB\u0004xN\u001d;\u0011\u0005iZT\"\u0001\u0019\n\u0005q\u0002$A\u0005#bi\u0006\u001cv.\u001e:dKJ+w-[:uKJ\fa\u0001P5oSRtD#A \u0011\u0005\u0001\u0003Q\"\u0001\u000b\u0002-\r\u0014X-\u0019;f\u001b&\u001c'o\u001c\"bi\u000eD'+Z1eKJ$Ba\u0011&YOB\u0011A\tS\u0007\u0002\u000b*\u0011qC\u0012\u0006\u0003\u000f:\naA]3bI\u0016\u0014\u0018BA%F\u0005Ai\u0015n\u0019:p\u0005\u0006$8\r\u001b*fC\u0012,'\u000fC\u0003L\u0005\u0001\u0007A*\u0001\u0004tG\",W.\u0019\t\u0004\u001bB\u0013V\"\u0001(\u000b\u0005=C\u0013\u0001B;uS2L!!\u0015(\u0003\u0011=\u0003H/[8oC2\u0004\"a\u0015,\u000e\u0003QS!!\u0016\u000e\u0002\u000bQL\b/Z:\n\u0005]#&AC*ueV\u001cG\u000fV=qK\")\u0011L\u0001a\u00015\u0006\u00112\r[3dWB|\u0017N\u001c;M_\u000e\fG/[8o!\tYFM\u0004\u0002]EB\u0011Q\fY\u0007\u0002=*\u0011qLI\u0001\u0007yI|w\u000e\u001e \u000b\u0003\u0005\fQa]2bY\u0006L!a\u00191\u0002\rA\u0013X\rZ3g\u0013\t)gM\u0001\u0004TiJLgn\u001a\u0006\u0003G\u0002DQ\u0001\u001b\u0002A\u0002%\fqa\u001c9uS>t7\u000f\u0005\u0002.U&\u00111N\f\u0002\u0012\t\u0006$\u0018mU8ve\u000e,w\n\u001d;j_:\u001c\u0018AF2sK\u0006$XmQ8oi&tWo\\;t%\u0016\fG-\u001a:\u0015\t9\f(o\u001d\t\u0003\t>L!\u0001]#\u0003!\r{g\u000e^5ok>,8OU3bI\u0016\u0014\b\"B&\u0004\u0001\u0004a\u0005\"B-\u0004\u0001\u0004Q\u0006\"\u00025\u0004\u0001\u0004I\u0017!C:i_J$h*Y7f)\u0005Q\u0016A\u0005*bi\u0016\u001cFO]3b[B\u0013xN^5eKJ\u0004\"\u0001\u0011\u0004\u0014\u0005\u0019I\bC\u0001>|\u001b\u0005\u0001\u0017B\u0001?a\u0005\u0019\te.\u001f*fMR\tq/\u0001\u0004T\u0007\"+U*Q\u000b\u0002%\u000691k\u0011%F\u001b\u0006\u0003\u0013a\u0002,F%NKuJT\u000b\u0003\u0003\u000f\u00012A_A\u0005\u0013\r\tY\u0001\u0019\u0002\u0004\u0013:$\u0018\u0001\u0003,F%NKuJ\u0014\u0011\u0002\u001d9+Vj\u0018)B%RKE+S(O'V\u0011\u00111\u0003\t\u0004K\u0005U\u0011BA3'\u0003=qU+T0Q\u0003J#\u0016\nV%P\u001dN\u0003\u0013a\u0004*P/N{\u0006+\u0012*`'\u0016\u001buJ\u0014#\u0002!I{ukU0Q\u000bJ{6+R\"P\u001d\u0012\u0003\u0013\u0001\u0004*B\u001bB{V\u000bU0U\u00136+\u0015!\u0004*B\u001bB{V\u000bU0U\u00136+\u0005%A\u0007wC2,X-\u0011;TK\u000e|g\u000e\u001a\u000b\t\u0003K\tY#a\f\u00024A\u0019!0a\n\n\u0007\u0005%\u0002M\u0001\u0003M_:<\u0007bBA\u0017%\u0001\u0007\u0011QE\u0001\bg\u0016\u001cwN\u001c3t\u0011\u001d\t\tD\u0005a\u0001\u0003K\tQB]8xgB+'oU3d_:$\u0007bBA\u001b%\u0001\u0007\u0011QE\u0001\u0012e\u0006l\u0007/\u00169US6,7+Z2p]\u0012\u001c\b")
public class RateStreamProvider
implements MicroBatchReadSupport,
ContinuousReadSupport,
DataSourceRegister {
    public static long valueAtSecond(long l, long l2, long l3) {
        return RateStreamProvider$.MODULE$.valueAtSecond(l, l2, l3);
    }

    public static String RAMP_UP_TIME() {
        return RateStreamProvider$.MODULE$.RAMP_UP_TIME();
    }

    public static String ROWS_PER_SECOND() {
        return RateStreamProvider$.MODULE$.ROWS_PER_SECOND();
    }

    public static String NUM_PARTITIONS() {
        return RateStreamProvider$.MODULE$.NUM_PARTITIONS();
    }

    public static int VERSION() {
        return RateStreamProvider$.MODULE$.VERSION();
    }

    public static StructType SCHEMA() {
        return RateStreamProvider$.MODULE$.SCHEMA();
    }

    @Override
    public MicroBatchReader createMicroBatchReader(Optional<StructType> schema, String checkpointLocation, DataSourceOptions options) {
        int numPartitions;
        long rampUpTimeSeconds;
        long rowsPerSecond;
        if (options.get(RateStreamProvider$.MODULE$.ROWS_PER_SECOND()).isPresent() && (rowsPerSecond = new StringOps(Predef$.MODULE$.augmentString(options.get(RateStreamProvider$.MODULE$.ROWS_PER_SECOND()).get())).toLong()) <= 0L) {
            throw new IllegalArgumentException(new StringBuilder(61).append("Invalid value '").append(rowsPerSecond).append("'. The option 'rowsPerSecond' must be positive").toString());
        }
        if (options.get(RateStreamProvider$.MODULE$.RAMP_UP_TIME()).isPresent() && (rampUpTimeSeconds = JavaUtils.timeStringAsSec((String)options.get(RateStreamProvider$.MODULE$.RAMP_UP_TIME()).get())) < 0L) {
            throw new IllegalArgumentException(new StringBuilder(62).append("Invalid value '").append(rampUpTimeSeconds).append("'. The option 'rampUpTime' must not be negative").toString());
        }
        if (options.get(RateStreamProvider$.MODULE$.NUM_PARTITIONS()).isPresent() && (numPartitions = new StringOps(Predef$.MODULE$.augmentString(options.get(RateStreamProvider$.MODULE$.NUM_PARTITIONS()).get())).toInt()) <= 0) {
            throw new IllegalArgumentException(new StringBuilder(61).append("Invalid value '").append(numPartitions).append("'. The option 'numPartitions' must be positive").toString());
        }
        if (schema.isPresent()) {
            throw new AnalysisException("The rate source does not support a user-specified schema.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        return new RateStreamMicroBatchReader(options, checkpointLocation);
    }

    @Override
    public ContinuousReader createContinuousReader(Optional<StructType> schema, String checkpointLocation, DataSourceOptions options) {
        return new RateStreamContinuousReader(options);
    }

    @Override
    public String shortName() {
        return "rate";
    }
}

