/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.internal;

import java.io.Serializable;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalog.Catalog;
import org.apache.spark.sql.catalog.Column;
import org.apache.spark.sql.catalog.Database;
import org.apache.spark.sql.catalog.Function;
import org.apache.spark.sql.catalog.Table;
import org.apache.spark.sql.catalyst.DefinedByConstructorParams;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.CatalogUtils$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.ExpressionInfo;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.AlterTableRecoverPartitionsCommand;
import org.apache.spark.sql.execution.command.AlterTableRecoverPartitionsCommand$;
import org.apache.spark.sql.execution.datasources.CreateTable;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.internal.CatalogImpl$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\r\ra\u0001\u0002\u00192\u0001qB\u0001b\u0011\u0001\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\u0006\u0011\u0002!\t!\u0013\u0005\u0006\u001b\u0002!IA\u0014\u0005\u0006-\u0002!Ia\u0016\u0005\u0006W\u0002!I\u0001\u001c\u0005\u0006a\u0002!\t%\u001d\u0005\u0006e\u0002!\te\u001d\u0005\u0006}\u0002!\te \u0005\b\u0003\u001b\u0001A\u0011BA\b\u0011\u001d\t\u0019\u0002\u0001C!\u0003+Aq!a\u0005\u0001\t\u0003\ny\u0002C\u0004\u0002&\u0001!I!a\n\t\u000f\u0005U\u0002\u0001\"\u0011\u00028!9\u0011Q\u0007\u0001\u0005B\u0005\u0005\u0003bBA$\u0001\u0011%\u0011\u0011\n\u0005\b\u0003+\u0002A\u0011IA,\u0011\u001d\t)\u0006\u0001C!\u0003SBq!!\u0016\u0001\t\u0013\t)\bC\u0004\u0002|\u0001!\t%! \t\u000f\u0005\u0005\u0005\u0001\"\u0011\u0002\u0004\"9\u0011\u0011\u0011\u0001\u0005B\u0005\u001d\u0005bBAG\u0001\u0011\u0005\u0013q\u0012\u0005\b\u0003\u001b\u0003A\u0011IAK\u0011\u001d\tY\n\u0001C!\u0003;Cq!a*\u0001\t\u0003\nI\u000bC\u0004\u0002(\u0002!\t%!,\t\u000f\u0005M\u0006\u0001\"\u0011\u00026\"9\u00111\u0017\u0001\u0005B\u0005e\u0006bBA`\u0001\u0011\u0005\u0013\u0011\u0019\u0005\b\u0003\u007f\u0003A\u0011IA{\u0011\u001d\ty\f\u0001C!\u0005\u0003Aq!a0\u0001\t\u0003\u0012\u0019\u0002C\u0004\u0003.\u0001!\tEa\f\t\u000f\tU\u0002\u0001\"\u0011\u00038!9!1\b\u0001\u0005B\tu\u0002b\u0002B!\u0001\u0011\u0005#1\t\u0005\b\u0005\u000f\u0002A\u0011\tB%\u0011\u001d\u00119\u0005\u0001C!\u0005\u001bBqA!\u0019\u0001\t\u0003\u0012\u0019\u0007C\u0004\u0003h\u0001!\tE!\u001b\t\u0011\t\u0005\u0003\u0001\"\u00054\u0005WBqAa#\u0001\t\u0003\u0012i\tC\u0004\u0003\u0012\u0002!\tEa%\b\u0011\te\u0015\u0007#\u00014\u000573q\u0001M\u0019\t\u0002M\u0012i\n\u0003\u0004I[\u0011\u0005!Q\u0015\u0005\b\u0005OkC\u0011\u0001BU\u0005-\u0019\u0015\r^1m_\u001eLU\u000e\u001d7\u000b\u0005I\u001a\u0014\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005Q*\u0014aA:rY*\u0011agN\u0001\u0006gB\f'o\u001b\u0006\u0003qe\na!\u00199bG\",'\"\u0001\u001e\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001i\u0004C\u0001 B\u001b\u0005y$B\u0001!4\u0003\u001d\u0019\u0017\r^1m_\u001eL!AQ \u0003\u000f\r\u000bG/\u00197pO\u0006a1\u000f]1sWN+7o]5p]B\u0011QIR\u0007\u0002g%\u0011qi\r\u0002\r'B\f'o[*fgNLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005)c\u0005CA&\u0001\u001b\u0005\t\u0004\"B\"\u0003\u0001\u0004!\u0015AD:fgNLwN\\\"bi\u0006dwnZ\u000b\u0002\u001fB\u0011\u0001\u000bV\u0007\u0002#*\u0011\u0001I\u0015\u0006\u0003'N\n\u0001bY1uC2L8\u000f^\u0005\u0003+F\u0013abU3tg&|gnQ1uC2|w-A\u000bsKF,\u0018N]3ECR\f'-Y:f\u000bbL7\u000f^:\u0015\u0005as\u0006CA-]\u001b\u0005Q&\"A.\u0002\u000bM\u001c\u0017\r\\1\n\u0005uS&\u0001B+oSRDQa\u0018\u0003A\u0002\u0001\fa\u0001\u001a2OC6,\u0007CA1i\u001d\t\u0011g\r\u0005\u0002d56\tAM\u0003\u0002fw\u00051AH]8pizJ!a\u001a.\u0002\rA\u0013X\rZ3g\u0013\tI'N\u0001\u0004TiJLgn\u001a\u0006\u0003Oj\u000b!C]3rk&\u0014X\rV1cY\u0016,\u00050[:ugR\u0019\u0001,\u001c8\t\u000b}+\u0001\u0019\u00011\t\u000b=,\u0001\u0019\u00011\u0002\u0013Q\f'\r\\3OC6,\u0017aD2veJ,g\u000e\u001e#bi\u0006\u0014\u0017m]3\u0016\u0003\u0001\f!c]3u\u0007V\u0014(/\u001a8u\t\u0006$\u0018MY1tKR\u0011\u0001\f\u001e\u0005\u0006?\u001e\u0001\r\u0001\u0019\u0015\u0004\u000fYd\bcA-xs&\u0011\u0001P\u0017\u0002\u0007i\"\u0014xn^:\u0011\u0005\u0015S\u0018BA>4\u0005E\te.\u00197zg&\u001cX\t_2faRLwN\\\u0011\u0002{\u00069B-\u0019;bE\u0006\u001cX\r\t3pKN\u0004cn\u001c;!KbL7\u000f^\u0001\u000eY&\u001cH\u000fR1uC\n\f7/Z:\u0015\u0005\u0005\u0005\u0001#B#\u0002\u0004\u0005\u001d\u0011bAA\u0003g\t9A)\u0019;bg\u0016$\bc\u0001 \u0002\n%\u0019\u00111B \u0003\u0011\u0011\u000bG/\u00192bg\u0016\fA\"\\1lK\u0012\u000bG/\u00192bg\u0016$B!a\u0002\u0002\u0012!)q,\u0003a\u0001A\u0006QA.[:u)\u0006\u0014G.Z:\u0015\u0005\u0005]\u0001#B#\u0002\u0004\u0005e\u0001c\u0001 \u0002\u001c%\u0019\u0011QD \u0003\u000bQ\u000b'\r\\3\u0015\t\u0005]\u0011\u0011\u0005\u0005\u0006?.\u0001\r\u0001\u0019\u0015\u0004\u0017Yd\u0018!C7bW\u0016$\u0016M\u00197f)\u0011\tI\"!\u000b\t\u000f\u0005-B\u00021\u0001\u0002.\u0005QA/\u00192mK&#WM\u001c;\u0011\t\u0005=\u0012\u0011G\u0007\u0002%&\u0019\u00111\u0007*\u0003\u001fQ\u000b'\r\\3JI\u0016tG/\u001b4jKJ\fQ\u0002\\5ti\u001a+hn\u0019;j_:\u001cHCAA\u001d!\u0015)\u00151AA\u001e!\rq\u0014QH\u0005\u0004\u0003\u007fy$\u0001\u0003$v]\u000e$\u0018n\u001c8\u0015\t\u0005e\u00121\t\u0005\u0006?:\u0001\r\u0001\u0019\u0015\u0004\u001dYd\u0018\u0001D7bW\u00164UO\\2uS>tG\u0003BA\u001e\u0003\u0017Bq!!\u0014\u0010\u0001\u0004\ty%A\u0005gk:\u001c\u0017\nZ3oiB!\u0011qFA)\u0013\r\t\u0019F\u0015\u0002\u0013\rVt7\r^5p]&#WM\u001c;jM&,'/A\u0006mSN$8i\u001c7v[:\u001cH\u0003BA-\u0003C\u0002R!RA\u0002\u00037\u00022APA/\u0013\r\tyf\u0010\u0002\u0007\u0007>dW/\u001c8\t\u000b=\u0004\u0002\u0019\u00011)\tA1\u0018QM\u0011\u0003\u0003O\nA\u0003^1cY\u0016\u0004Cm\\3tA9|G\u000fI3ySN$HCBA-\u0003W\ni\u0007C\u0003`#\u0001\u0007\u0001\rC\u0003p#\u0001\u0007\u0001\r\u000b\u0003\u0012m\u0006E\u0014EAA:\u0003\u0001\"\u0017\r^1cCN,\u0007e\u001c:!i\u0006\u0014G.\u001a\u0011e_\u0016\u001c\bE\\8uA\u0015D\u0018n\u001d;\u0015\t\u0005e\u0013q\u000f\u0005\b\u0003s\u0012\u0002\u0019AA\u0017\u0003=!\u0018M\u00197f\u0013\u0012,g\u000e^5gS\u0016\u0014\u0018aC4fi\u0012\u000bG/\u00192bg\u0016$B!a\u0002\u0002\u0000!)ql\u0005a\u0001A\u0006Aq-\u001a;UC\ndW\r\u0006\u0003\u0002\u001a\u0005\u0015\u0005\"B8\u0015\u0001\u0004\u0001GCBA\r\u0003\u0013\u000bY\tC\u0003`+\u0001\u0007\u0001\rC\u0003p+\u0001\u0007\u0001-A\u0006hKR4UO\\2uS>tG\u0003BA\u001e\u0003#Ca!a%\u0017\u0001\u0004\u0001\u0017\u0001\u00044v]\u000e$\u0018n\u001c8OC6,GCBA\u001e\u0003/\u000bI\nC\u0003`/\u0001\u0007\u0001\r\u0003\u0004\u0002\u0014^\u0001\r\u0001Y\u0001\u000fI\u0006$\u0018MY1tK\u0016C\u0018n\u001d;t)\u0011\ty*!*\u0011\u0007e\u000b\t+C\u0002\u0002$j\u0013qAQ8pY\u0016\fg\u000eC\u0003`1\u0001\u0007\u0001-A\u0006uC\ndW-\u0012=jgR\u001cH\u0003BAP\u0003WCQa\\\rA\u0002\u0001$b!a(\u00020\u0006E\u0006\"B0\u001b\u0001\u0004\u0001\u0007\"B8\u001b\u0001\u0004\u0001\u0017A\u00044v]\u000e$\u0018n\u001c8Fq&\u001cHo\u001d\u000b\u0005\u0003?\u000b9\f\u0003\u0004\u0002\u0014n\u0001\r\u0001\u0019\u000b\u0007\u0003?\u000bY,!0\t\u000b}c\u0002\u0019\u00011\t\r\u0005ME\u00041\u0001a\u0003-\u0019'/Z1uKR\u000b'\r\\3\u0015\r\u0005\r\u0017\u0011]Ar!\u0011\t)-a7\u000f\t\u0005\u001d\u0017q\u001b\b\u0005\u0003\u0013\f)N\u0004\u0003\u0002L\u0006Mg\u0002BAg\u0003#t1aYAh\u0013\u0005Q\u0014B\u0001\u001d:\u0013\t1t'\u0003\u00025k%\u0019\u0011\u0011\\\u001a\u0002\u000fA\f7m[1hK&!\u0011Q\\Ap\u0005%!\u0015\r^1Ge\u0006lWMC\u0002\u0002ZNBQa\\\u000fA\u0002\u0001Da!!:\u001e\u0001\u0004\u0001\u0017\u0001\u00029bi\"D3!HAu!\u0011\tY/!=\u000e\u0005\u00055(bAAxk\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0018Q\u001e\u0002\r\u000bb\u0004XM]5nK:$\u0018\r\u001c\u000b\t\u0003\u0007\f90!?\u0002|\")qN\ba\u0001A\"1\u0011Q\u001d\u0010A\u0002\u0001Da!!@\u001f\u0001\u0004\u0001\u0017AB:pkJ\u001cW\rK\u0002\u001f\u0003S$\u0002\"a1\u0003\u0004\t\u0015!q\u0001\u0005\u0006_~\u0001\r\u0001\u0019\u0005\u0007\u0003{|\u0002\u0019\u00011\t\u000f\t%q\u00041\u0001\u0003\f\u00059q\u000e\u001d;j_:\u001c\b#B1\u0003\u000e\u0001\u0004\u0017b\u0001B\bU\n\u0019Q*\u00199)\u0007}\tI\u000f\u0006\u0006\u0002D\nU!q\u0003B\r\u0005SAQa\u001c\u0011A\u0002\u0001Da!!@!\u0001\u0004\u0001\u0007b\u0002B\u000eA\u0001\u0007!QD\u0001\u0007g\u000eDW-\\1\u0011\t\t}!QE\u0007\u0003\u0005CQ1Aa\t4\u0003\u0015!\u0018\u0010]3t\u0013\u0011\u00119C!\t\u0003\u0015M#(/^2u)f\u0004X\rC\u0004\u0003\n\u0001\u0002\rAa\u0003)\u0007\u0001\nI/\u0001\u0007ee>\u0004H+Z7q-&,w\u000f\u0006\u0003\u0002 \nE\u0002B\u0002B\u001aC\u0001\u0007\u0001-\u0001\u0005wS\u0016<h*Y7f\u0003I!'o\u001c9HY>\u0014\u0017\r\u001c+f[B4\u0016.Z<\u0015\t\u0005}%\u0011\b\u0005\u0007\u0005g\u0011\u0003\u0019\u00011\u0002#I,7m\u001c<feB\u000b'\u000f^5uS>t7\u000fF\u0002Y\u0005\u007fAQa\\\u0012A\u0002\u0001\f\u0001\"[:DC\u000eDW\r\u001a\u000b\u0005\u0003?\u0013)\u0005C\u0003pI\u0001\u0007\u0001-\u0001\u0006dC\u000eDW\rV1cY\u0016$2\u0001\u0017B&\u0011\u0015yW\u00051\u0001a)\u0015A&q\nB)\u0011\u0015yg\u00051\u0001a\u0011\u001d\u0011\u0019F\na\u0001\u0005+\nAb\u001d;pe\u0006<W\rT3wK2\u0004BAa\u0016\u0003^5\u0011!\u0011\f\u0006\u0004\u00057*\u0014aB:u_J\fw-Z\u0005\u0005\u0005?\u0012IF\u0001\u0007Ti>\u0014\u0018mZ3MKZ,G.\u0001\u0007v]\u000e\f7\r[3UC\ndW\rF\u0002Y\u0005KBQa\\\u0014A\u0002\u0001\f!b\u00197fCJ\u001c\u0015m\u00195f)\u0005AF\u0003BAP\u0005[BqAa\u001c*\u0001\u0004\u0011\t(A\u0003r\u001d\u0006lW\r\r\u0003\u0003t\te\u0004#B#\u0002\u0004\tU\u0004\u0003\u0002B<\u0005sb\u0001\u0001\u0002\u0007\u0003|\t5\u0014\u0011!A\u0001\u0006\u0003\u0011iHA\u0002`IE\nBAa \u0003\u0006B\u0019\u0011L!!\n\u0007\t\r%LA\u0004O_RD\u0017N\\4\u0011\u0007e\u00139)C\u0002\u0003\nj\u00131!\u00118z\u00031\u0011XM\u001a:fg\"$\u0016M\u00197f)\rA&q\u0012\u0005\u0006_*\u0002\r\u0001Y\u0001\u000ee\u00164'/Z:i\u0005f\u0004\u0016\r\u001e5\u0015\u0007a\u0013)\n\u0003\u0004\u0003\u0018.\u0002\r\u0001Y\u0001\re\u0016\u001cx.\u001e:dKB\u000bG\u000f[\u0001\f\u0007\u0006$\u0018\r\\8h\u00136\u0004H\u000e\u0005\u0002L[M\u0019QFa(\u0011\u0007e\u0013\t+C\u0002\u0003$j\u0013a!\u00118z%\u00164GC\u0001BN\u0003-i\u0017m[3ECR\f7/\u001a;\u0016\t\t-&1\u0017\u000b\u0007\u0005[\u0013\tp!\u0001\u0015\t\t=&q\u0018\t\u0006\u000b\u0006\r!\u0011\u0017\t\u0005\u0005o\u0012\u0019\fB\u0004\u00036>\u0012\rAa.\u0003\u0003Q\u000bBAa \u0003:B!\u0011q\u0006B^\u0013\r\u0011iL\u0015\u0002\u001b\t\u00164\u0017N\\3e\u0005f\u001cuN\\:ueV\u001cGo\u001c:QCJ\fWn\u001d\u0005\n\u0005\u0003|\u0013\u0011!a\u0002\u0005\u0007\f!\"\u001a<jI\u0016t7-\u001a\u00132!\u0019\u0011)M!:\u00032:!!q\u0019Bp\u001d\u0011\u0011IMa7\u000f\t\t-'Q\u001b\b\u0005\u0005\u001b\u0014\tND\u0002d\u0005\u001fL\u0011aW\u0005\u0004\u0005'T\u0016a\u0002:fM2,7\r^\u0005\u0005\u0005/\u0014I.A\u0004sk:$\u0018.\\3\u000b\u0007\tM',\u0003\u0003\u0002Z\nu'\u0002\u0002Bl\u00053LAA!9\u0003d\u0006AQO\\5wKJ\u001cXM\u0003\u0003\u0002Z\nu\u0017\u0002\u0002Bt\u0005S\u0014q\u0001V=qKR\u000bw-\u0003\u0003\u0003l\n5(\u0001\u0003+za\u0016$\u0016mZ:\u000b\t\t=(\u0011\\\u0001\u0004CBL\u0007b\u0002Bz_\u0001\u0007!Q_\u0001\u0005I\u0006$\u0018\r\u0005\u0004\u0003x\nm(\u0011\u0017\b\u0005\u0005\u001b\u0014I0C\u0002\u0002ZjKAA!@\u0003\u0000\n\u00191+Z9\u000b\u0007\u0005e'\fC\u0003D_\u0001\u0007A\t")
public class CatalogImpl
extends Catalog {
    private final SparkSession sparkSession;

    public static <T extends DefinedByConstructorParams> Dataset<T> makeDataset(Seq<T> seq, SparkSession sparkSession, TypeTags.TypeTag<T> typeTag) {
        return CatalogImpl$.MODULE$.makeDataset(seq, sparkSession, typeTag);
    }

    private SessionCatalog sessionCatalog() {
        return this.sparkSession.sessionState().catalog();
    }

    private void requireDatabaseExists(String dbName) {
        if (!this.sessionCatalog().databaseExists(dbName)) {
            throw new AnalysisException(new StringBuilder(27).append("Database '").append(dbName).append("' does not exist.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    private void requireTableExists(String dbName, String tableName) {
        if (!this.sessionCatalog().tableExists(new TableIdentifier(tableName, (Option)new Some((Object)dbName)))) {
            throw new AnalysisException(new StringBuilder(39).append("Table '").append(tableName).append("' does not exist in database '").append(dbName).append("'.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    @Override
    public String currentDatabase() {
        return this.sessionCatalog().getCurrentDatabase();
    }

    @Override
    public void setCurrentDatabase(String dbName) throws AnalysisException {
        this.requireDatabaseExists(dbName);
        this.sessionCatalog().setCurrentDatabase(dbName);
    }

    @Override
    public Dataset<Database> listDatabases() {
        Seq databases = (Seq)this.sessionCatalog().listDatabases().map((Function1 & Serializable & scala.Serializable)dbName -> this.makeDatabase((String)dbName), Seq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CatalogImpl.class.getClassLoader());
        public final class Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.catalog.Database").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$1(CatalogImpl $outer) {
            }
        }
        return CatalogImpl$.MODULE$.makeDataset(databases, this.sparkSession, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$1(null)));
    }

    private Database makeDatabase(String dbName) {
        CatalogDatabase metadata = this.sessionCatalog().getDatabaseMetadata(dbName);
        return new Database(metadata.name(), metadata.description(), CatalogUtils$.MODULE$.URIToString(metadata.locationUri()));
    }

    @Override
    public Dataset<Table> listTables() {
        return this.listTables(this.currentDatabase());
    }

    @Override
    public Dataset<Table> listTables(String dbName) throws AnalysisException {
        Seq tables = (Seq)this.sessionCatalog().listTables(dbName).map((Function1 & Serializable & scala.Serializable)tableIdent -> this.makeTable((TableIdentifier)tableIdent), Seq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CatalogImpl.class.getClassLoader());
        public final class Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.catalog.Table").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$2(CatalogImpl $outer) {
            }
        }
        return CatalogImpl$.MODULE$.makeDataset(tables, this.sparkSession, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$2(null)));
    }

    private Table makeTable(TableIdentifier tableIdent) {
        Some some;
        try {
            some = new Some((Object)this.sessionCatalog().getTempViewOrPermanentTableMetadata(tableIdent));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        Some metadata = some;
        boolean isTemp = this.sessionCatalog().isTemporaryTable(tableIdent);
        return new Table(tableIdent.table(), (String)((Option)metadata.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.identifier().database()).getOrElse((Function0 & Serializable & scala.Serializable)() -> tableIdent.database())).orNull(Predef$.MODULE$.$conforms()), (String)metadata.map((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2.comment().orNull(Predef$.MODULE$.$conforms())).orNull(Predef$.MODULE$.$conforms()), isTemp ? "TEMPORARY" : (String)metadata.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.tableType().name()).orNull(Predef$.MODULE$.$conforms()), isTemp);
    }

    @Override
    public Dataset<Function> listFunctions() {
        return this.listFunctions(this.currentDatabase());
    }

    @Override
    public Dataset<Function> listFunctions(String dbName) throws AnalysisException {
        this.requireDatabaseExists(dbName);
        Seq functions2 = (Seq)this.sessionCatalog().listFunctions(dbName).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            FunctionIdentifier functIdent = (FunctionIdentifier)tuple2._1();
            Function function = this.makeFunction(functIdent);
            return function;
        }, Seq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CatalogImpl.class.getClassLoader());
        public final class Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$3
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.catalog.Function").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$3(CatalogImpl $outer) {
            }
        }
        return CatalogImpl$.MODULE$.makeDataset(functions2, this.sparkSession, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$3(null)));
    }

    private Function makeFunction(FunctionIdentifier funcIdent) {
        ExpressionInfo metadata = this.sessionCatalog().lookupFunctionInfo(funcIdent);
        return new Function(metadata.getName(), metadata.getDb(), null, metadata.getClassName(), metadata.getDb() == null);
    }

    @Override
    public Dataset<Column> listColumns(String tableName) throws AnalysisException {
        TableIdentifier tableIdent = this.sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        return this.listColumns(tableIdent);
    }

    @Override
    public Dataset<Column> listColumns(String dbName, String tableName) throws AnalysisException {
        this.requireTableExists(dbName, tableName);
        return this.listColumns(new TableIdentifier(tableName, (Option)new Some((Object)dbName)));
    }

    private Dataset<Column> listColumns(TableIdentifier tableIdentifier) {
        CatalogTable tableMetadata = this.sessionCatalog().getTempViewOrPermanentTableMetadata(tableIdentifier);
        Set partitionColumnNames = tableMetadata.partitionColumnNames().toSet();
        Set bucketColumnNames = ((TraversableOnce)tableMetadata.bucketSpec().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.bucketColumnNames()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)).toSet();
        Seq columns = (Seq)tableMetadata.schema().map((Function1 & Serializable & scala.Serializable)c -> new Column(c.name(), (String)c.getComment().orNull(Predef$.MODULE$.$conforms()), c.dataType().catalogString(), c.nullable(), partitionColumnNames.contains((Object)c.name()), bucketColumnNames.contains((Object)c.name())), Seq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CatalogImpl.class.getClassLoader());
        public final class Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$4
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.catalog.Column").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$4(CatalogImpl $outer) {
            }
        }
        return CatalogImpl$.MODULE$.makeDataset(columns, this.sparkSession, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$4(null)));
    }

    @Override
    public Database getDatabase(String dbName) {
        return this.makeDatabase(dbName);
    }

    @Override
    public Table getTable(String tableName) {
        TableIdentifier tableIdent = this.sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        return this.getTable((String)tableIdent.database().orNull(Predef$.MODULE$.$conforms()), tableIdent.table());
    }

    @Override
    public Table getTable(String dbName, String tableName) {
        if (!this.tableExists(dbName, tableName)) {
            throw new AnalysisException(new StringBuilder(41).append("Table or view '").append(tableName).append("' not found in database '").append(dbName).append("'").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        return this.makeTable(new TableIdentifier(tableName, Option$.MODULE$.apply((Object)dbName)));
    }

    @Override
    public Function getFunction(String functionName) {
        FunctionIdentifier functionIdent = this.sparkSession.sessionState().sqlParser().parseFunctionIdentifier(functionName);
        return this.getFunction((String)functionIdent.database().orNull(Predef$.MODULE$.$conforms()), functionIdent.funcName());
    }

    @Override
    public Function getFunction(String dbName, String functionName) {
        return this.makeFunction(new FunctionIdentifier(functionName, Option$.MODULE$.apply((Object)dbName)));
    }

    @Override
    public boolean databaseExists(String dbName) {
        return this.sessionCatalog().databaseExists(dbName);
    }

    @Override
    public boolean tableExists(String tableName) {
        TableIdentifier tableIdent = this.sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        return this.tableExists((String)tableIdent.database().orNull(Predef$.MODULE$.$conforms()), tableIdent.table());
    }

    @Override
    public boolean tableExists(String dbName, String tableName) {
        TableIdentifier tableIdent = new TableIdentifier(tableName, Option$.MODULE$.apply((Object)dbName));
        return this.sessionCatalog().isTemporaryTable(tableIdent) || this.sessionCatalog().tableExists(tableIdent);
    }

    @Override
    public boolean functionExists(String functionName) {
        FunctionIdentifier functionIdent = this.sparkSession.sessionState().sqlParser().parseFunctionIdentifier(functionName);
        return this.functionExists((String)functionIdent.database().orNull(Predef$.MODULE$.$conforms()), functionIdent.funcName());
    }

    @Override
    public boolean functionExists(String dbName, String functionName) {
        return this.sessionCatalog().functionExists(new FunctionIdentifier(functionName, Option$.MODULE$.apply((Object)dbName)));
    }

    @Override
    @Experimental
    public Dataset<Row> createTable(String tableName, String path) {
        String dataSourceName = this.sparkSession.sessionState().conf().defaultDataSourceName();
        return this.createTable(tableName, path, dataSourceName);
    }

    @Override
    @Experimental
    public Dataset<Row> createTable(String tableName, String path, String source) {
        return this.createTable(tableName, source, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)path)}))));
    }

    @Override
    @Experimental
    public Dataset<Row> createTable(String tableName, String source, Map<String, String> options) {
        return this.createTable(tableName, source, new StructType(), options);
    }

    @Override
    @Experimental
    public Dataset<Row> createTable(String tableName, String source, StructType schema, Map<String, String> options) {
        TableIdentifier tableIdent = this.sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        CatalogStorageFormat storage = DataSource$.MODULE$.buildStorageFormatFromOptions(options);
        CatalogTableType tableType = storage.locationUri().isDefined() ? CatalogTableType$.MODULE$.EXTERNAL() : CatalogTableType$.MODULE$.MANAGED();
        CatalogTable tableDesc = new CatalogTable(tableIdent, tableType, storage, schema, (Option)new Some((Object)source), CatalogTable$.MODULE$.apply$default$6(), CatalogTable$.MODULE$.apply$default$7(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19());
        CreateTable plan = new CreateTable(tableDesc, SaveMode.ErrorIfExists, (Option<LogicalPlan>)None$.MODULE$);
        this.sparkSession.sessionState().executePlan(plan).toRdd();
        return this.sparkSession.table(tableIdent);
    }

    @Override
    public boolean dropTempView(String viewName) {
        return this.sparkSession.sessionState().catalog().getTempView(viewName).exists((Function1 & Serializable & scala.Serializable)viewDef -> BoxesRunTime.boxToBoolean((boolean)CatalogImpl.$anonfun$dropTempView$1(this, viewName, viewDef)));
    }

    @Override
    public boolean dropGlobalTempView(String viewName) {
        return this.sparkSession.sessionState().catalog().getGlobalTempView(viewName).exists((Function1 & Serializable & scala.Serializable)viewDef -> BoxesRunTime.boxToBoolean((boolean)CatalogImpl.$anonfun$dropGlobalTempView$1(this, viewName, viewDef)));
    }

    @Override
    public void recoverPartitions(String tableName) {
        TableIdentifier tableIdent = this.sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        this.sparkSession.sessionState().executePlan(new AlterTableRecoverPartitionsCommand(tableIdent, AlterTableRecoverPartitionsCommand$.MODULE$.apply$default$2())).toRdd();
    }

    @Override
    public boolean isCached(String tableName) {
        return this.sparkSession.sharedState().cacheManager().lookupCachedData(this.sparkSession.table(tableName)).nonEmpty();
    }

    @Override
    public void cacheTable(String tableName) {
        this.sparkSession.sharedState().cacheManager().cacheQuery(this.sparkSession.table(tableName), (Option<String>)new Some((Object)tableName), this.sparkSession.sharedState().cacheManager().cacheQuery$default$3());
    }

    @Override
    public void cacheTable(String tableName, StorageLevel storageLevel) {
        this.sparkSession.sharedState().cacheManager().cacheQuery(this.sparkSession.table(tableName), (Option<String>)new Some((Object)tableName), storageLevel);
    }

    @Override
    public void uncacheTable(String tableName) {
        TableIdentifier tableIdent = this.sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        boolean cascade = !this.sessionCatalog().isTemporaryTable(tableIdent);
        this.sparkSession.sharedState().cacheManager().uncacheQuery(this.sparkSession.table(tableName), cascade, this.sparkSession.sharedState().cacheManager().uncacheQuery$default$3());
    }

    @Override
    public void clearCache() {
        this.sparkSession.sharedState().cacheManager().clearCache();
    }

    public boolean isCached(Dataset<?> qName) {
        return this.sparkSession.sharedState().cacheManager().lookupCachedData(qName).nonEmpty();
    }

    @Override
    public void refreshTable(String tableName) {
        block2: {
            TableIdentifier tableIdent = this.sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
            CatalogTable tableMetadata = this.sessionCatalog().getTempViewOrPermanentTableMetadata(tableIdent);
            Dataset<Row> table = this.sparkSession.table(tableIdent);
            CatalogTableType catalogTableType = tableMetadata.tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
            if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
                table.queryExecution().analyzed().refresh();
            } else {
                this.sessionCatalog().refreshTable(tableIdent);
            }
            if (!this.isCached(table)) break block2;
            this.sparkSession.sharedState().cacheManager().uncacheQuery(table, true, true);
            this.sparkSession.sharedState().cacheManager().cacheQuery(table, (Option<String>)new Some((Object)tableIdent.table()), this.sparkSession.sharedState().cacheManager().cacheQuery$default$3());
        }
    }

    @Override
    public void refreshByPath(String resourcePath) {
        this.sparkSession.sharedState().cacheManager().recacheByPath(this.sparkSession, resourcePath);
    }

    public static final /* synthetic */ boolean $anonfun$dropTempView$1(CatalogImpl $this, String viewName$1, LogicalPlan viewDef) {
        $this.sparkSession.sharedState().cacheManager().uncacheQuery($this.sparkSession, viewDef, false, true);
        return $this.sessionCatalog().dropTempView(viewName$1);
    }

    public static final /* synthetic */ boolean $anonfun$dropGlobalTempView$1(CatalogImpl $this, String viewName$2, LogicalPlan viewDef) {
        $this.sparkSession.sharedState().cacheManager().uncacheQuery($this.sparkSession, viewDef, false, true);
        return $this.sessionCatalog().dropGlobalTempView(viewName$2);
    }

    public CatalogImpl(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
    }
}

