/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import org.apache.spark.annotation.InterfaceStability;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.EliminateSubqueryAliases$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.CreateTable;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Utils$;
import org.apache.spark.sql.execution.datasources.v2.WriteToDataSourceV2;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.DataSourceV2;
import org.apache.spark.sql.sources.v2.WriteSupport;
import org.apache.spark.sql.sources.v2.writer.DataSourceWriter;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@InterfaceStability.Stable
@ScalaSignature(bytes="\u0006\u0001\t-g\u0001\u0002\u001d:\u0005\tC\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ia\u0013\u0005\u00075\u0002!\t!O.\t\u000fy\u0003!\u0019!C\u0005?\"1q\r\u0001Q\u0001\n\u0001DQ\u0001\u001b\u0001\u0005\u0002%DQ\u0001\u001b\u0001\u0005\u0002=DQ\u0001 \u0001\u0005\u0002uDq!!\u0001\u0001\t\u0003\t\u0019\u0001C\u0004\u0002\u0002\u0001!\t!!\u0004\t\u000f\u0005\u0005\u0001\u0001\"\u0001\u0002\u001a!9\u0011\u0011\u0001\u0001\u0005\u0002\u0005\u0015\u0002bBA\u0019\u0001\u0011\u0005\u00111\u0007\u0005\b\u0003c\u0001A\u0011AA\"\u0011\u001d\t)\u0006\u0001C\u0001\u0003/Bq!!\u001d\u0001\t\u0003\t\u0019\bC\u0004\u0002\b\u0002!\t!!#\t\u000f\u0005E\u0005\u0001\"\u0001\u0002\u0014\"9\u0011\u0011\u0013\u0001\u0005\u0002\u0005}\u0005bBAQ\u0001\u0011%\u0011q\u0014\u0005\b\u0003G\u0003A\u0011AAS\u0011\u001d\t\u0019\u000b\u0001C\u0005\u0003WCq!!0\u0001\t\u0013\ty\fC\u0004\u0002T\u0002!I!!6\t\u000f\u0005m\u0007\u0001\"\u0003\u0002^\"9\u0011\u0011\u001d\u0001\u0005\u0002\u0005\r\bbBAq\u0001\u0011%\u0011q\u001d\u0005\b\u0003W\u0004A\u0011BAw\u0011\u001d\t\t\u0010\u0001C\u0001\u0003gDqAa\u0002\u0001\t\u0003\u0011I\u0001C\u0004\u0003\u000e\u0001!\tAa\u0004\t\u000f\tM\u0001\u0001\"\u0001\u0003\u0016!9!\u0011\u0004\u0001\u0005\u0002\tm\u0001b\u0002B\u0010\u0001\u0011\u0005!\u0011\u0005\u0005\b\u0005K\u0001A\u0011\u0002B\u0014\u0011!y\b\u00011A\u0005\n\t5\u0003\"\u0003B(\u0001\u0001\u0007I\u0011\u0002B)\u0011\u001d\u00119\u0006\u0001Q!\nED\u0001\u0002\u001b\u0001A\u0002\u0013%!\u0011\f\u0005\n\u00057\u0002\u0001\u0019!C\u0005\u0005;BqA!\u0019\u0001A\u0003&A\u000eC\u0005\u0003d\u0001\u0001\r\u0011\"\u0003\u0003f!I!\u0011\u000f\u0001A\u0002\u0013%!1\u000f\u0005\t\u0005o\u0002\u0001\u0015)\u0003\u0003h!I!\u0011\u0010\u0001A\u0002\u0013%!1\u0010\u0005\n\u0005\u001f\u0003\u0001\u0019!C\u0005\u0005#C\u0001B!&\u0001A\u0003&!Q\u0010\u0005\n\u0005/\u0003\u0001\u0019!C\u0005\u0005wB\u0011B!'\u0001\u0001\u0004%IAa'\t\u0011\t}\u0005\u0001)Q\u0005\u0005{B\u0011\"a\u001e\u0001\u0001\u0004%IA!)\t\u0013\t\u0015\u0006\u00011A\u0005\n\t\u001d\u0006\u0002\u0003BV\u0001\u0001\u0006KAa)\t\u0013\t5\u0006\u00011A\u0005\n\tm\u0004\"\u0003BX\u0001\u0001\u0007I\u0011\u0002BY\u0011!\u0011)\f\u0001Q!\n\tu$a\u0004#bi\u00064%/Y7f/JLG/\u001a:\u000b\u0005iZ\u0014aA:rY*\u0011A(P\u0001\u0006gB\f'o\u001b\u0006\u0003}}\na!\u00199bG\",'\"\u0001!\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0005\r\u000b6C\u0001\u0001E!\t)\u0005*D\u0001G\u0015\u00059\u0015!B:dC2\f\u0017BA%G\u0005\u0019\te.\u001f*fM\u0006\u0011Am\u001d\t\u0004\u00196{U\"A\u001d\n\u00059K$a\u0002#bi\u0006\u001cX\r\u001e\t\u0003!Fc\u0001\u0001B\u0003S\u0001\t\u00071KA\u0001U#\t!v\u000b\u0005\u0002F+&\u0011aK\u0012\u0002\b\u001d>$\b.\u001b8h!\t)\u0005,\u0003\u0002Z\r\n\u0019\u0011I\\=\u0002\rqJg.\u001b;?)\taV\fE\u0002M\u0001=CQA\u0013\u0002A\u0002-\u000b!\u0001\u001a4\u0016\u0003\u0001\u0004\"!\u00193\u000f\u00051\u0013\u0017BA2:\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u001a4\u0003\u0013\u0011\u000bG/\u0019$sC6,'BA2:\u0003\r!g\rI\u0001\u0005[>$W\r\u0006\u0002]U\")1.\u0002a\u0001Y\u0006A1/\u0019<f\u001b>$W\r\u0005\u0002M[&\u0011a.\u000f\u0002\t'\u00064X-T8eKR\u0011A\f\u001d\u0005\u0006W\u001a\u0001\r!\u001d\t\u0003eft!a]<\u0011\u0005Q4U\"A;\u000b\u0005Y\f\u0015A\u0002\u001fs_>$h(\u0003\u0002y\r\u00061\u0001K]3eK\u001aL!A_>\u0003\rM#(/\u001b8h\u0015\tAh)\u0001\u0004g_Jl\u0017\r\u001e\u000b\u00039zDQa`\u0004A\u0002E\faa]8ve\u000e,\u0017AB8qi&|g\u000eF\u0003]\u0003\u000b\tI\u0001\u0003\u0004\u0002\b!\u0001\r!]\u0001\u0004W\u0016L\bBBA\u0006\u0011\u0001\u0007\u0011/A\u0003wC2,X\rF\u0003]\u0003\u001f\t\t\u0002\u0003\u0004\u0002\b%\u0001\r!\u001d\u0005\b\u0003\u0017I\u0001\u0019AA\n!\r)\u0015QC\u0005\u0004\u0003/1%a\u0002\"p_2,\u0017M\u001c\u000b\u00069\u0006m\u0011Q\u0004\u0005\u0007\u0003\u000fQ\u0001\u0019A9\t\u000f\u0005-!\u00021\u0001\u0002 A\u0019Q)!\t\n\u0007\u0005\rbI\u0001\u0003M_:<G#\u0002/\u0002(\u0005%\u0002BBA\u0004\u0017\u0001\u0007\u0011\u000fC\u0004\u0002\f-\u0001\r!a\u000b\u0011\u0007\u0015\u000bi#C\u0002\u00020\u0019\u0013a\u0001R8vE2,\u0017aB8qi&|gn\u001d\u000b\u00049\u0006U\u0002bBA\u0019\u0019\u0001\u0007\u0011q\u0007\t\u0007\u0003s\ty$]9\u000e\u0005\u0005m\"bAA\u001f\r\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u0005\u00131\b\u0002\u0004\u001b\u0006\u0004Hc\u0001/\u0002F!9\u0011\u0011G\u0007A\u0002\u0005\u001d\u0003CBA%\u0003'\n\u0018/\u0004\u0002\u0002L)!\u0011QJA(\u0003\u0011)H/\u001b7\u000b\u0005\u0005E\u0013\u0001\u00026bm\u0006LA!!\u0011\u0002L\u0005Y\u0001/\u0019:uSRLwN\u001c\"z)\ra\u0016\u0011\f\u0005\b\u00037r\u0001\u0019AA/\u0003!\u0019w\u000e\u001c(b[\u0016\u001c\b\u0003B#\u0002`EL1!!\u0019G\u0005)a$/\u001a9fCR,GM\u0010\u0015\u0004\u001d\u0005\u0015\u0004\u0003BA4\u0003[j!!!\u001b\u000b\u0007\u0005-d)\u0001\u0006b]:|G/\u0019;j_:LA!a\u001c\u0002j\t9a/\u0019:be\u001e\u001c\u0018\u0001\u00032vG.,GOQ=\u0015\u000fq\u000b)(a \u0002\u0004\"9\u0011qO\bA\u0002\u0005e\u0014A\u00038v[\n+8m[3ugB\u0019Q)a\u001f\n\u0007\u0005udIA\u0002J]RDa!!!\u0010\u0001\u0004\t\u0018aB2pY:\u000bW.\u001a\u0005\b\u00037z\u0001\u0019AA/Q\ry\u0011QM\u0001\u0007g>\u0014HOQ=\u0015\u000bq\u000bY)!$\t\r\u0005\u0005\u0005\u00031\u0001r\u0011\u001d\tY\u0006\u0005a\u0001\u0003;B3\u0001EA3\u0003\u0011\u0019\u0018M^3\u0015\t\u0005U\u00151\u0014\t\u0004\u000b\u0006]\u0015bAAM\r\n!QK\\5u\u0011\u0019\ti*\u0005a\u0001c\u0006!\u0001/\u0019;i)\t\t)*\u0001\btCZ,Gk\u001c,2'>,(oY3\u0002\u0015%t7/\u001a:u\u0013:$x\u000e\u0006\u0003\u0002\u0016\u0006\u001d\u0006BBAU)\u0001\u0007\u0011/A\u0005uC\ndWMT1nKR!\u0011QSAW\u0011\u001d\ty+\u0006a\u0001\u0003c\u000b!\u0002^1cY\u0016LE-\u001a8u!\u0011\t\u0019,!/\u000e\u0005\u0005U&bAA\\s\u0005A1-\u0019;bYf\u001cH/\u0003\u0003\u0002<\u0006U&a\u0004+bE2,\u0017\nZ3oi&4\u0017.\u001a:\u0002\u001b\u001d,GOQ;dW\u0016$8\u000b]3d+\t\t\t\rE\u0003F\u0003\u0007\f9-C\u0002\u0002F\u001a\u0013aa\u00149uS>t\u0007\u0003BAe\u0003\u001fl!!a3\u000b\t\u00055\u0017QW\u0001\bG\u0006$\u0018\r\\8h\u0013\u0011\t\t.a3\u0003\u0015\t+8m[3u'B,7-A\tbgN,'\u000f\u001e(pi\n+8m[3uK\u0012$B!!&\u0002X\"1\u0011\u0011\\\fA\u0002E\f\u0011b\u001c9fe\u0006$\u0018n\u001c8\u0002)\u0005\u001c8/\u001a:u\u001d>$\b+\u0019:uSRLwN\\3e)\u0011\t)*a8\t\r\u0005e\u0007\u00041\u0001r\u0003-\u0019\u0018M^3BgR\u000b'\r\\3\u0015\t\u0005U\u0015Q\u001d\u0005\u0007\u0003SK\u0002\u0019A9\u0015\t\u0005U\u0015\u0011\u001e\u0005\b\u0003_S\u0002\u0019AAY\u0003-\u0019'/Z1uKR\u000b'\r\\3\u0015\t\u0005U\u0015q\u001e\u0005\b\u0003_[\u0002\u0019AAY\u0003\u0011QGMY2\u0015\u0011\u0005U\u0015Q_A}\u0003{Da!a>\u001d\u0001\u0004\t\u0018aA;sY\"1\u00111 \u000fA\u0002E\fQ\u0001^1cY\u0016Dq!a@\u001d\u0001\u0004\u0011\t!\u0001\u000bd_:tWm\u0019;j_:\u0004&o\u001c9feRLWm\u001d\t\u0005\u0003\u0013\u0012\u0019!\u0003\u0003\u0003\u0006\u0005-#A\u0003)s_B,'\u000f^5fg\u0006!!n]8o)\u0011\t)Ja\u0003\t\r\u0005uU\u00041\u0001r\u0003\u001d\u0001\u0018M]9vKR$B!!&\u0003\u0012!1\u0011Q\u0014\u0010A\u0002E\f1a\u001c:d)\u0011\t)Ja\u0006\t\r\u0005uu\u00041\u0001r\u0003\u0011!X\r\u001f;\u0015\t\u0005U%Q\u0004\u0005\u0007\u0003;\u0003\u0003\u0019A9\u0002\u0007\r\u001ch\u000f\u0006\u0003\u0002\u0016\n\r\u0002BBAOC\u0001\u0007\u0011/\u0001\u0006sk:\u001cu.\\7b]\u0012$bA!\u000b\u0003@\t%C\u0003BAK\u0005WAqA!\f#\u0001\u0004\u0011y#A\u0004d_6l\u0017M\u001c3\u0011\t\tE\"1H\u0007\u0003\u0005gQAA!\u000e\u00038\u00059An\\4jG\u0006d'\u0002\u0002B\u001d\u0003k\u000bQ\u0001\u001d7b]NLAA!\u0010\u00034\tYAj\\4jG\u0006d\u0007\u000b\\1o\u0011\u001d\u0011\tE\ta\u0001\u0005\u0007\nqa]3tg&|g\u000eE\u0002M\u0005\u000bJ1Aa\u0012:\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0011\u0019\u0011YE\ta\u0001c\u0006!a.Y7f+\u0005\t\u0018AC:pkJ\u001cWm\u0018\u0013fcR!\u0011Q\u0013B*\u0011!\u0011)\u0006JA\u0001\u0002\u0004\t\u0018a\u0001=%c\u000591o\\;sG\u0016\u0004S#\u00017\u0002\u00115|G-Z0%KF$B!!&\u0003`!A!QK\u0014\u0002\u0002\u0003\u0007A.A\u0003n_\u0012,\u0007%\u0001\u0007fqR\u0014\u0018m\u00149uS>t7/\u0006\u0002\u0003hA)!\u0011\u000eB7c6\u0011!1\u000e\u0006\u0005\u0003\u001b\n),\u0003\u0003\u0003p\t-$AE\"bg\u0016Len]3og&$\u0018N^3NCB\f\u0001#\u001a=ue\u0006|\u0005\u000f^5p]N|F%Z9\u0015\t\u0005U%Q\u000f\u0005\n\u0005+R\u0013\u0011!a\u0001\u0005O\nQ\"\u001a=ue\u0006|\u0005\u000f^5p]N\u0004\u0013a\u00059beRLG/[8oS:<7i\u001c7v[:\u001cXC\u0001B?!\u0015)\u00151\u0019B@!\u0015\u0011\tI!#r\u001d\u0011\u0011\u0019Ia\"\u000f\u0007Q\u0014))C\u0001H\u0013\t\u0019g)\u0003\u0003\u0003\f\n5%aA*fc*\u00111MR\u0001\u0018a\u0006\u0014H/\u001b;j_:LgnZ\"pYVlgn]0%KF$B!!&\u0003\u0014\"I!QK\u0017\u0002\u0002\u0003\u0007!QP\u0001\u0015a\u0006\u0014H/\u001b;j_:LgnZ\"pYVlgn\u001d\u0011\u0002#\t,8m[3u\u0007>dW/\u001c8OC6,7/A\u000bck\u000e\\W\r^\"pYVlgNT1nKN|F%Z9\u0015\t\u0005U%Q\u0014\u0005\n\u0005+\u0002\u0014\u0011!a\u0001\u0005{\n!CY;dW\u0016$8i\u001c7v[:t\u0015-\\3tAU\u0011!1\u0015\t\u0006\u000b\u0006\r\u0017\u0011P\u0001\u000f]Vl')^2lKR\u001cx\fJ3r)\u0011\t)J!+\t\u0013\tU3'!AA\u0002\t\r\u0016a\u00038v[\n+8m[3ug\u0002\nqb]8si\u000e{G.^7o\u001d\u0006lWm]\u0001\u0014g>\u0014HoQ8mk6tg*Y7fg~#S-\u001d\u000b\u0005\u0003+\u0013\u0019\fC\u0005\u0003VY\n\t\u00111\u0001\u0003~\u0005\u00012o\u001c:u\u0007>dW/\u001c8OC6,7\u000f\t\u0015\u0004\u0001\te\u0006\u0003\u0002B^\u0005\u000btAA!0\u0003B6\u0011!q\u0018\u0006\u0004\u0003WZ\u0014\u0002\u0002Bb\u0005\u007f\u000b!#\u00138uKJ4\u0017mY3Ti\u0006\u0014\u0017\u000e\\5us&!!q\u0019Be\u0005\u0019\u0019F/\u00192mK*!!1\u0019B`\u0001")
public final class DataFrameWriter<T> {
    private final Dataset<Row> df;
    private String source;
    private SaveMode mode;
    private CaseInsensitiveMap<String> extraOptions;
    private Option<Seq<String>> partitioningColumns;
    private Option<Seq<String>> bucketColumnNames;
    private Option<Object> numBuckets;
    private Option<Seq<String>> sortColumnNames;

    public DataFrameWriter<T> partitionBy(String ... colNames) {
        return this.partitionBy((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataFrameWriter<T> bucketBy(int numBuckets, String colName, String ... colNames) {
        return this.bucketBy(numBuckets, colName, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataFrameWriter<T> sortBy(String colName, String ... colNames) {
        return this.sortBy(colName, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    private Dataset<Row> df() {
        return this.df;
    }

    public DataFrameWriter<T> mode(SaveMode saveMode) {
        this.mode_$eq(saveMode);
        return this;
    }

    public DataFrameWriter<T> mode(String saveMode) {
        SaveMode saveMode2;
        String string = saveMode.toLowerCase(Locale.ROOT);
        if ("overwrite".equals(string)) {
            saveMode2 = SaveMode.Overwrite;
        } else if ("append".equals(string)) {
            saveMode2 = SaveMode.Append;
        } else if ("ignore".equals(string)) {
            saveMode2 = SaveMode.Ignore;
        } else {
            boolean bl = "error".equals(string) ? true : ("errorifexists".equals(string) ? true : "default".equals(string));
            if (bl) {
                saveMode2 = SaveMode.ErrorIfExists;
            } else {
                throw new IllegalArgumentException(new StringBuilder(103).append("Unknown save mode: ").append(saveMode).append(". ").append("Accepted save modes are 'overwrite', 'append', 'ignore', 'error', 'errorifexists'.").toString());
            }
        }
        this.mode_$eq(saveMode2);
        return this;
    }

    public DataFrameWriter<T> format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataFrameWriter<T> option(String key, String value) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value)));
        return this;
    }

    public DataFrameWriter<T> option(String key, boolean value) {
        return this.option(key, ((Object)BoxesRunTime.boxToBoolean((boolean)value)).toString());
    }

    public DataFrameWriter<T> option(String key, long value) {
        return this.option(key, ((Object)BoxesRunTime.boxToLong((long)value)).toString());
    }

    public DataFrameWriter<T> option(String key, double value) {
        return this.option(key, ((Object)BoxesRunTime.boxToDouble((double)value)).toString());
    }

    public DataFrameWriter<T> options(Map<String, String> options) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus(options));
        return this;
    }

    public DataFrameWriter<T> options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()));
        return this;
    }

    public DataFrameWriter<T> partitionBy(Seq<String> colNames) {
        this.partitioningColumns_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames));
        return this;
    }

    public DataFrameWriter<T> bucketBy(int numBuckets, String colName, Seq<String> colNames) {
        this.numBuckets_$eq((Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)numBuckets)));
        String string = colName;
        this.bucketColumnNames_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())));
        return this;
    }

    public DataFrameWriter<T> sortBy(String colName, Seq<String> colNames) {
        String string = colName;
        this.sortColumnNames_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())));
        return this;
    }

    public void save(String path) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)path)));
        this.save();
    }

    public void save() {
        String string = this.source().toLowerCase(Locale.ROOT);
        String string2 = DDLUtils$.MODULE$.HIVE_PROVIDER();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new AnalysisException("Hive data source can only be used with tables, you can not write files of Hive data source directly.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        this.assertNotBucketed("save");
        Class<?> cls = DataSource$.MODULE$.lookupDataSource(this.source(), this.df().sparkSession().sessionState().conf());
        if (DataSourceV2.class.isAssignableFrom(cls)) {
            DataSourceV2 source = (DataSourceV2)cls.newInstance();
            DataSourceV2 dataSourceV2 = source;
            if (dataSourceV2 instanceof WriteSupport) {
                BoxedUnit boxedUnit;
                WriteSupport writeSupport = (WriteSupport)dataSourceV2;
                scala.collection.immutable.Map<String, String> sessionOptions = DataSourceV2Utils$.MODULE$.extractSessionConfigs(source, this.df().sparkSession().sessionState().conf());
                scala.collection.immutable.Map options = sessionOptions.filterKeys((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DataFrameWriter.$anonfun$save$1(this, x$3))).$plus$plus((GenTraversableOnce)this.extraOptions().toMap());
                Optional<DataSourceWriter> writer = writeSupport.createWriter(UUID.randomUUID().toString(), package$.MODULE$.AttributeSeq(this.df().logicalPlan().output()).toStructType(), this.mode(), new DataSourceOptions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)options).asJava()));
                if (writer.isPresent()) {
                    this.runCommand(this.df().sparkSession(), "save", new WriteToDataSourceV2(writer.get(), this.df().logicalPlan()));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                this.saveToV1Source();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            this.saveToV1Source();
        }
    }

    private void saveToV1Source() {
        if (BoxesRunTime.unboxToBoolean((Object)SparkSession$.MODULE$.active().sessionState().conf().getConf(SQLConf$.MODULE$.LEGACY_PASS_PARTITION_BY_AS_OPTIONS()))) {
            this.partitioningColumns().foreach((Function1 & Serializable & scala.Serializable)columns -> {
                this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceUtils$.MODULE$.PARTITIONING_COLUMNS_KEY()), (Object)DataSourceUtils$.MODULE$.encodePartitioningColumns((Seq<String>)columns))));
                return BoxedUnit.UNIT;
            });
        }
        SparkSession x$1 = this.df().sparkSession();
        String x$2 = this.source();
        Seq x$3 = (Seq)this.partitioningColumns().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        scala.collection.immutable.Map x$4 = this.extraOptions().toMap();
        Seq<String> x$5 = DataSource$.MODULE$.apply$default$3();
        Option<StructType> x$6 = DataSource$.MODULE$.apply$default$4();
        Option<BucketSpec> x$7 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$8 = DataSource$.MODULE$.apply$default$8();
        this.runCommand(this.df().sparkSession(), "save", new DataSource(x$1, x$2, x$5, x$6, (Seq<String>)x$3, x$7, (scala.collection.immutable.Map<String, String>)x$4, x$8).planForWriting(this.mode(), this.df().logicalPlan()));
    }

    public void insertInto(String tableName) {
        this.insertInto(this.df().sparkSession().sessionState().sqlParser().parseTableIdentifier(tableName));
    }

    private void insertInto(TableIdentifier tableIdent) {
        this.assertNotBucketed("insertInto");
        if (this.partitioningColumns().isDefined()) {
            throw new AnalysisException("insertInto() can't be used together with partitionBy(). Partition columns have already been defined for the table. It is not necessary to use partitionBy().", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        SaveMode saveMode = this.mode();
        SaveMode saveMode2 = SaveMode.Overwrite;
        this.runCommand(this.df().sparkSession(), "insertInto", (LogicalPlan)new InsertIntoTable((LogicalPlan)new UnresolvedRelation(tableIdent), Predef$.MODULE$.Map().empty(), this.df().logicalPlan(), !(saveMode != null ? !((Object)((Object)saveMode)).equals((Object)saveMode2) : saveMode2 != null), false));
    }

    private Option<BucketSpec> getBucketSpec() {
        if (this.sortColumnNames().isDefined() && this.numBuckets().isEmpty()) {
            throw new AnalysisException("sortBy must be used together with bucketBy", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        return this.numBuckets().map((Function1 & Serializable & scala.Serializable)n -> DataFrameWriter.$anonfun$getBucketSpec$1(this, BoxesRunTime.unboxToInt((Object)n)));
    }

    private void assertNotBucketed(String operation) {
        if (this.getBucketSpec().isDefined()) {
            if (this.sortColumnNames().isEmpty()) {
                throw new AnalysisException(new StringBuilder(38).append("'").append(operation).append("' does not support bucketBy right now").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            throw new AnalysisException(new StringBuilder(49).append("'").append(operation).append("' does not support bucketBy and sortBy right now").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    private void assertNotPartitioned(String operation) {
        if (this.partitioningColumns().isDefined()) {
            throw new AnalysisException(new StringBuilder(32).append("'").append(operation).append("' does not support partitioning").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    public void saveAsTable(String tableName) {
        this.saveAsTable(this.df().sparkSession().sessionState().sqlParser().parseTableIdentifier(tableName));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void saveAsTable(TableIdentifier tableIdent) {
        SessionCatalog catalog = this.df().sparkSession().sessionState().catalog();
        boolean tableExists = catalog.tableExists(tableIdent);
        String db = (String)tableIdent.database().getOrElse((Function0 & Serializable & scala.Serializable)() -> catalog.getCurrentDatabase());
        Some x$1 = new Some((Object)db);
        String x$2 = tableIdent.copy$default$1();
        TableIdentifier tableIdentWithDB = tableIdent.copy(x$2, (Option)x$1);
        String tableName = tableIdentWithDB.unquotedString();
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)tableExists), (Object)this.mode());
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)((Object)tuple2._2());
            if (bl && ((Object)((Object)SaveMode.Ignore)).equals((Object)saveMode)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)((Object)tuple2._2());
            if (bl && ((Object)((Object)SaveMode.ErrorIfExists)).equals((Object)saveMode)) {
                throw new AnalysisException(new StringBuilder(22).append("Table ").append(tableIdent).append(" already exists.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
        }
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)((Object)tuple2._2());
            if (bl && ((Object)((Object)SaveMode.Overwrite)).equals((Object)saveMode)) {
                HiveTableRelation hiveTableRelation;
                BaseRelation baseRelation;
                LogicalRelation logicalRelation;
                BaseRelation dest;
                Seq srcRelations = this.df().logicalPlan().collect((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        LogicalRelation logicalRelation;
                        BaseRelation src;
                        A1 A1 = x1;
                        if (A1 instanceof LogicalRelation && (src = (logicalRelation = (LogicalRelation)A1).relation()) != null) {
                            BaseRelation baseRelation = src;
                            object = baseRelation;
                        } else if (A1 instanceof HiveTableRelation) {
                            HiveTableRelation hiveTableRelation = (HiveTableRelation)A1;
                            object = hiveTableRelation.tableMeta().identifier();
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(LogicalPlan x1) {
                        LogicalRelation logicalRelation;
                        BaseRelation src;
                        LogicalPlan logicalPlan2 = x1;
                        boolean bl = logicalPlan2 instanceof LogicalRelation && (src = (logicalRelation = (LogicalRelation)logicalPlan2).relation()) != null ? true : logicalPlan2 instanceof HiveTableRelation;
                        return bl;
                    }
                });
                LogicalPlan tableRelation = this.df().sparkSession().table(tableIdentWithDB).queryExecution().analyzed();
                LogicalPlan logicalPlan2 = EliminateSubqueryAliases$.MODULE$.apply(tableRelation);
                if (logicalPlan2 instanceof LogicalRelation && (dest = (logicalRelation = (LogicalRelation)logicalPlan2).relation()) != null && srcRelations.contains((Object)(baseRelation = dest))) {
                    throw new AnalysisException(new StringBuilder(52).append("Cannot overwrite table ").append(tableName).append(" that is also being read from").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
                if (logicalPlan2 instanceof HiveTableRelation && srcRelations.contains((Object)(hiveTableRelation = (HiveTableRelation)logicalPlan2).tableMeta().identifier())) {
                    throw new AnalysisException(new StringBuilder(52).append("Cannot overwrite table ").append(tableName).append(" that is also being read from").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                catalog.dropTable(tableIdentWithDB, true, false);
                this.createTable(tableIdentWithDB);
                catalog.refreshTable(tableIdentWithDB);
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                return;
            }
        }
        this.createTable(tableIdent);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void createTable(TableIdentifier tableIdent) {
        CatalogStorageFormat storage = DataSource$.MODULE$.buildStorageFormatFromOptions((scala.collection.immutable.Map<String, String>)this.extraOptions().toMap());
        CatalogTableType tableType = storage.locationUri().isDefined() ? CatalogTableType$.MODULE$.EXTERNAL() : CatalogTableType$.MODULE$.MANAGED();
        CatalogTable tableDesc = new CatalogTable(tableIdent, tableType, storage, new StructType(), (Option)new Some((Object)this.source()), (Seq)this.partitioningColumns().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$), this.getBucketSpec(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19());
        this.runCommand(this.df().sparkSession(), "saveAsTable", new CreateTable(tableDesc, this.mode(), (Option<LogicalPlan>)new Some((Object)this.df().logicalPlan())));
    }

    public void jdbc(String url, String table, Properties connectionProperties) {
        this.assertNotPartitioned("jdbc");
        this.assertNotBucketed("jdbc");
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(connectionProperties).asScala()));
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"url"), (Object)url), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dbtable"), (Object)table)}))));
        this.format("jdbc").save();
    }

    public void json(String path) {
        this.format("json").save(path);
    }

    public void parquet(String path) {
        this.format("parquet").save(path);
    }

    public void orc(String path) {
        this.format("orc").save(path);
    }

    public void text(String path) {
        this.format("text").save(path);
    }

    public void csv(String path) {
        this.format("csv").save(path);
    }

    private void runCommand(SparkSession session, String name, LogicalPlan command) {
        QueryExecution qe = session.sessionState().executePlan(command);
        try {
            long start = System.nanoTime();
            SQLExecution$.MODULE$.withNewExecutionId(session, qe, (Function0 & Serializable & scala.Serializable)() -> qe.toRdd());
            long end = System.nanoTime();
            session.listenerManager().onSuccess(name, qe, end - start);
        }
        catch (Throwable e) {
            session.listenerManager().onFailure(name, qe, e);
            throw e;
        }
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private SaveMode mode() {
        return this.mode;
    }

    private void mode_$eq(SaveMode x$1) {
        this.mode = x$1;
    }

    private CaseInsensitiveMap<String> extraOptions() {
        return this.extraOptions;
    }

    private void extraOptions_$eq(CaseInsensitiveMap<String> x$1) {
        this.extraOptions = x$1;
    }

    private Option<Seq<String>> partitioningColumns() {
        return this.partitioningColumns;
    }

    private void partitioningColumns_$eq(Option<Seq<String>> x$1) {
        this.partitioningColumns = x$1;
    }

    private Option<Seq<String>> bucketColumnNames() {
        return this.bucketColumnNames;
    }

    private void bucketColumnNames_$eq(Option<Seq<String>> x$1) {
        this.bucketColumnNames = x$1;
    }

    private Option<Object> numBuckets() {
        return this.numBuckets;
    }

    private void numBuckets_$eq(Option<Object> x$1) {
        this.numBuckets = x$1;
    }

    private Option<Seq<String>> sortColumnNames() {
        return this.sortColumnNames;
    }

    private void sortColumnNames_$eq(Option<Seq<String>> x$1) {
        this.sortColumnNames = x$1;
    }

    public static final /* synthetic */ boolean $anonfun$save$1(DataFrameWriter $this, String x$3) {
        return !$this.extraOptions().contains(x$3);
    }

    public static final /* synthetic */ BucketSpec $anonfun$getBucketSpec$1(DataFrameWriter $this, int n) {
        return new BucketSpec(n, (Seq)$this.bucketColumnNames().get(), (Seq)$this.sortColumnNames().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$));
    }

    public DataFrameWriter(Dataset<T> ds) {
        this.df = ds.toDF();
        this.source = this.df().sparkSession().sessionState().conf().defaultDataSourceName();
        this.mode = SaveMode.ErrorIfExists;
        this.extraOptions = CaseInsensitiveMap$.MODULE$.apply(Predef$.MODULE$.Map().empty());
        this.partitioningColumns = None$.MODULE$;
        this.bucketColumnNames = None$.MODULE$;
        this.numBuckets = None$.MODULE$;
        this.sortColumnNames = None$.MODULE$;
    }
}

