/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.arrow;

import java.io.Serializable;
import java.util.List;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class ArrowUtils$ {
    public static ArrowUtils$ MODULE$;
    private final RootAllocator rootAllocator;

    static {
        new ArrowUtils$();
    }

    public RootAllocator rootAllocator() {
        return this.rootAllocator;
    }

    public ArrowType toArrowType(DataType dt, String timeZoneId) {
        DecimalType decimalType;
        Option option;
        ArrowType.Bool bool;
        DataType dataType = dt;
        if (BooleanType$.MODULE$.equals(dataType)) {
            bool = ArrowType.Bool.INSTANCE;
        } else if (ByteType$.MODULE$.equals(dataType)) {
            bool = new ArrowType.Int(8, true);
        } else if (ShortType$.MODULE$.equals(dataType)) {
            bool = new ArrowType.Int(16, true);
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            bool = new ArrowType.Int(32, true);
        } else if (LongType$.MODULE$.equals(dataType)) {
            bool = new ArrowType.Int(64, true);
        } else if (FloatType$.MODULE$.equals(dataType)) {
            bool = new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE);
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            bool = new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE);
        } else if (StringType$.MODULE$.equals(dataType)) {
            bool = ArrowType.Utf8.INSTANCE;
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            bool = ArrowType.Binary.INSTANCE;
        } else if (dataType instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
            int precision = ((Tuple2)option.get())._1$mcI$sp();
            int scale = ((Tuple2)option.get())._2$mcI$sp();
            bool = new ArrowType.Decimal(precision, scale);
        } else if (DateType$.MODULE$.equals(dataType)) {
            bool = new ArrowType.Date(DateUnit.DAY);
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            if (timeZoneId == null) {
                throw new UnsupportedOperationException(new StringBuilder(33).append(TimestampType$.MODULE$.catalogString()).append(" must supply timeZoneId parameter").toString());
            }
            bool = new ArrowType.Timestamp(TimeUnit.MICROSECOND, timeZoneId);
        } else {
            throw new UnsupportedOperationException(new StringBuilder(23).append("Unsupported data type: ").append(dt.catalogString()).toString());
        }
        return bool;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataType fromArrowType(ArrowType dt) {
        boolean bl = false;
        ArrowType.Int intVal = null;
        boolean bl2 = false;
        ArrowType.FloatingPoint floatingPoint = null;
        ArrowType arrowType = dt;
        ArrowType.Bool bool = ArrowType.Bool.INSTANCE;
        ArrowType arrowType2 = arrowType;
        if (bool == null) {
            if (arrowType2 == null) return BooleanType$.MODULE$;
        } else if (bool.equals(arrowType2)) {
            return BooleanType$.MODULE$;
        }
        if (arrowType instanceof ArrowType.Int) {
            bl = true;
            intVal = (ArrowType.Int)arrowType;
            if (intVal.getIsSigned() && intVal.getBitWidth() == 8) {
                return ByteType$.MODULE$;
            }
        }
        if (bl && intVal.getIsSigned() && intVal.getBitWidth() == 16) {
            return ShortType$.MODULE$;
        }
        if (bl && intVal.getIsSigned() && intVal.getBitWidth() == 32) {
            return IntegerType$.MODULE$;
        }
        if (bl && intVal.getIsSigned() && intVal.getBitWidth() == 64) {
            return LongType$.MODULE$;
        }
        if (arrowType instanceof ArrowType.FloatingPoint) {
            bl2 = true;
            floatingPoint = (ArrowType.FloatingPoint)arrowType;
            FloatingPointPrecision floatingPointPrecision = floatingPoint.getPrecision();
            FloatingPointPrecision floatingPointPrecision2 = FloatingPointPrecision.SINGLE;
            if (floatingPointPrecision == null) {
                if (floatingPointPrecision2 == null) return FloatType$.MODULE$;
            } else if (floatingPointPrecision.equals(floatingPointPrecision2)) {
                return FloatType$.MODULE$;
            }
        }
        if (bl2) {
            FloatingPointPrecision floatingPointPrecision = floatingPoint.getPrecision();
            FloatingPointPrecision floatingPointPrecision3 = FloatingPointPrecision.DOUBLE;
            if (floatingPointPrecision == null) {
                if (floatingPointPrecision3 == null) return DoubleType$.MODULE$;
            } else if (floatingPointPrecision.equals(floatingPointPrecision3)) {
                return DoubleType$.MODULE$;
            }
        }
        ArrowType.Utf8 utf8 = ArrowType.Utf8.INSTANCE;
        ArrowType arrowType3 = arrowType;
        if (utf8 == null) {
            if (arrowType3 == null) return StringType$.MODULE$;
        } else if (utf8.equals(arrowType3)) {
            return StringType$.MODULE$;
        }
        ArrowType.Binary binary = ArrowType.Binary.INSTANCE;
        ArrowType arrowType4 = arrowType;
        if (binary == null) {
            if (arrowType4 == null) return BinaryType$.MODULE$;
        } else if (binary.equals(arrowType4)) {
            return BinaryType$.MODULE$;
        }
        if (arrowType instanceof ArrowType.Decimal) {
            ArrowType.Decimal decimal = (ArrowType.Decimal)arrowType;
            return new DecimalType(decimal.getPrecision(), decimal.getScale());
        }
        if (arrowType instanceof ArrowType.Date) {
            ArrowType.Date date = (ArrowType.Date)arrowType;
            DateUnit dateUnit = date.getUnit();
            DateUnit dateUnit2 = DateUnit.DAY;
            if (dateUnit == null) {
                if (dateUnit2 == null) return DateType$.MODULE$;
            } else if (dateUnit.equals(dateUnit2)) {
                return DateType$.MODULE$;
            }
        }
        if (!(arrowType instanceof ArrowType.Timestamp)) throw new UnsupportedOperationException(new StringBuilder(23).append("Unsupported data type: ").append(dt).toString());
        ArrowType.Timestamp timestamp = (ArrowType.Timestamp)arrowType;
        TimeUnit timeUnit = timestamp.getUnit();
        TimeUnit timeUnit2 = TimeUnit.MICROSECOND;
        if (timeUnit != null) {
            if (!timeUnit.equals(timeUnit2)) throw new UnsupportedOperationException(new StringBuilder(23).append("Unsupported data type: ").append(dt).toString());
            return TimestampType$.MODULE$;
        }
        if (timeUnit2 == null) return TimestampType$.MODULE$;
        throw new UnsupportedOperationException(new StringBuilder(23).append("Unsupported data type: ").append(dt).toString());
    }

    public Field toArrowField(String name, DataType dt, boolean nullable, String timeZoneId) {
        Field field2;
        DataType dataType = dt;
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType elementType = arrayType.elementType();
            boolean containsNull = arrayType.containsNull();
            FieldType fieldType = new FieldType(nullable, (ArrowType)ArrowType.List.INSTANCE, null);
            field2 = new Field(name, fieldType, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Field[]{this.toArrowField("element", elementType, containsNull, timeZoneId)}))).asJava());
        } else if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            FieldType fieldType = new FieldType(nullable, (ArrowType)ArrowType.Struct.INSTANCE, null);
            field2 = new Field(name, fieldType, (List)JavaConverters$.MODULE$.seqAsJavaListConverter(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & Serializable & scala.Serializable)field -> MODULE$.toArrowField(field.name(), field.dataType(), field.nullable(), timeZoneId), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Field.class))))).toSeq()).asJava());
        } else {
            FieldType fieldType = new FieldType(nullable, this.toArrowType(dataType, timeZoneId), null);
            field2 = new Field(name, fieldType, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.empty()).asJava());
        }
        return field2;
    }

    public DataType fromArrowField(Field field) {
        DataType dataType;
        ArrowType arrowType = field.getType();
        ArrowType.List list = ArrowType.List.INSTANCE;
        ArrowType arrowType2 = arrowType;
        if (!(list != null ? !list.equals(arrowType2) : arrowType2 != null)) {
            Field elementField = (Field)field.getChildren().get(0);
            DataType elementType = this.fromArrowField(elementField);
            dataType = new ArrayType(elementType, elementField.isNullable());
        } else {
            ArrowType.Struct struct = ArrowType.Struct.INSTANCE;
            ArrowType arrowType3 = arrowType;
            if (!(struct != null ? !struct.equals(arrowType3) : arrowType3 != null)) {
                Buffer fields = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(field.getChildren()).asScala()).map((Function1 & Serializable & scala.Serializable)child -> {
                    DataType dt = MODULE$.fromArrowField((Field)child);
                    return new StructField(child.getName(), dt, child.isNullable(), StructField$.MODULE$.apply$default$4());
                }, Buffer$.MODULE$.canBuildFrom());
                dataType = StructType$.MODULE$.apply((Seq)fields);
            } else {
                dataType = this.fromArrowType(arrowType);
            }
        }
        return dataType;
    }

    public Schema toArrowSchema(StructType schema, String timeZoneId) {
        return new Schema((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)schema.map((Function1 & Serializable & scala.Serializable)field -> MODULE$.toArrowField(field.name(), field.dataType(), field.nullable(), timeZoneId), Seq$.MODULE$.canBuildFrom())).asJava());
    }

    public StructType fromArrowSchema(Schema schema) {
        return StructType$.MODULE$.apply((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(schema.getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)field -> {
            DataType dt = MODULE$.fromArrowField((Field)field);
            return new StructField(field.getName(), dt, field.isNullable(), StructField$.MODULE$.apply$default$4());
        }, Buffer$.MODULE$.canBuildFrom()));
    }

    public Map<String, String> getPythonRunnerConfMap(SQLConf conf) {
        Nil$ timeZoneConf = conf.pandasRespectSessionTimeZone() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()), (Object)conf.sessionLocalTimeZone())})) : Nil$.MODULE$;
        Seq pandasColsByName = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PANDAS_GROUPED_MAP_ASSIGN_COLUMNS_BY_NAME().key()), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)conf.pandasGroupedMapAssignColumnsByName())).toString())}));
        return (Map)Predef$.MODULE$.Map().apply((Seq)timeZoneConf.$plus$plus((GenTraversableOnce)pandasColsByName, Seq$.MODULE$.canBuildFrom()));
    }

    private ArrowUtils$() {
        MODULE$ = this;
        this.rootAllocator = new RootAllocator(Long.MAX_VALUE);
    }
}

