/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.csv;

import com.univocity.parsers.csv.CsvParser;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.spark.TaskContext$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.HadoopFileLinesReader;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.csv.CSVDataSource;
import org.apache.spark.sql.execution.datasources.csv.CSVDataSource$;
import org.apache.spark.sql.execution.datasources.csv.CSVInferSchema$;
import org.apache.spark.sql.execution.datasources.csv.CSVOptions;
import org.apache.spark.sql.execution.datasources.csv.CSVUtils$;
import org.apache.spark.sql.execution.datasources.csv.UnivocityParser;
import org.apache.spark.sql.execution.datasources.csv.UnivocityParser$;
import org.apache.spark.sql.execution.datasources.text.TextFileFormat;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class TextInputCSVDataSource$
extends CSVDataSource {
    public static TextInputCSVDataSource$ MODULE$;
    private final boolean isSplitable;

    static {
        new TextInputCSVDataSource$();
    }

    @Override
    public boolean isSplitable() {
        return this.isSplitable;
    }

    @Override
    public Iterator<InternalRow> readFile(Configuration conf, PartitionedFile file, UnivocityParser parser, StructType requiredSchema, StructType dataSchema, boolean caseSensitive, boolean columnPruning) {
        Iterator lines;
        block0: {
            boolean hasHeader;
            HadoopFileLinesReader linesReader = new HadoopFileLinesReader(file, conf);
            Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1 & Serializable & scala.Serializable)x$5 -> x$5.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$6 -> {
                linesReader.close();
                return BoxedUnit.UNIT;
            }));
            lines = linesReader.map((Function1 & Serializable & scala.Serializable)line -> new String(line.getBytes(), 0, line.getLength(), parser.options().charset()));
            boolean bl = hasHeader = parser.options().headerFlag() && file.start() == 0L;
            if (!hasHeader) break block0;
            CSVUtils$.MODULE$.extractHeader(lines, parser.options()).foreach((Function1 & Serializable & scala.Serializable)header -> {
                TextInputCSVDataSource$.$anonfun$readFile$4(requiredSchema, parser, dataSchema, columnPruning, file, caseSensitive, header);
                return BoxedUnit.UNIT;
            });
        }
        return UnivocityParser$.MODULE$.parseIterator(lines, parser, requiredSchema);
    }

    @Override
    public StructType infer(SparkSession sparkSession, Seq<FileStatus> inputPaths, CSVOptions parsedOptions) {
        Dataset<String> csv = this.createBaseDataset(sparkSession, inputPaths, parsedOptions);
        Option maybeFirstLine = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])CSVUtils$.MODULE$.filterCommentAndEmpty(csv, parsedOptions).take(1))).headOption();
        return this.inferFromDataset(sparkSession, csv, (Option<String>)maybeFirstLine, parsedOptions);
    }

    public StructType inferFromDataset(SparkSession sparkSession, Dataset<String> csv, Option<String> maybeFirstLine, CSVOptions parsedOptions) {
        StructType structType;
        Some some;
        String[] firstRow;
        CsvParser csvParser = new CsvParser(parsedOptions.asParserSettings());
        Option option = maybeFirstLine.map((Function1 & Serializable & scala.Serializable)x$9 -> csvParser.parseLine(x$9));
        if (option instanceof Some && (firstRow = (String[])(some = (Some)option).value()) != null) {
            boolean caseSensitive = sparkSession.sessionState().conf().caseSensitiveAnalysis();
            String[] header = this.makeSafeHeader(firstRow, caseSensitive, parsedOptions);
            Dataset<String> sampled = CSVUtils$.MODULE$.sample(csv, parsedOptions);
            RDD tokenRDD = sampled.rdd().mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
                Iterator<String> filteredLines = CSVUtils$.MODULE$.filterCommentAndEmpty((Iterator<String>)iter, parsedOptions);
                Iterator<String> linesWithoutHeader = CSVUtils$.MODULE$.filterHeaderLine(filteredLines, (String)maybeFirstLine.get(), parsedOptions);
                CsvParser parser = new CsvParser(parsedOptions.asParserSettings());
                return linesWithoutHeader.map((Function1 & Serializable & scala.Serializable)x$1 -> parser.parseLine(x$1));
            }, sampled.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
            structType = CSVInferSchema$.MODULE$.infer((RDD<String[]>)tokenRDD, header, parsedOptions);
        } else {
            structType = StructType$.MODULE$.apply((Seq)Nil$.MODULE$);
        }
        return structType;
    }

    private Dataset<String> createBaseDataset(SparkSession sparkSession, Seq<FileStatus> inputPaths, CSVOptions options) {
        Dataset<String> dataset;
        Seq paths = (Seq)inputPaths.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.getPath().toString(), Seq$.MODULE$.canBuildFrom());
        Charset charset = Charset.forName(options.charset());
        Charset charset2 = StandardCharsets.UTF_8;
        if (!(charset != null ? !((Object)charset).equals(charset2) : charset2 != null)) {
            SparkSession x$1 = sparkSession;
            Seq x$2 = paths;
            String x$3 = TextFileFormat.class.getName();
            CaseInsensitiveMap x$4 = options.parameters().$plus$plus((TraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSource$.MODULE$.GLOB_PATHS_KEY()), (Object)"false")})));
            Option<StructType> x$5 = DataSource$.MODULE$.apply$default$4();
            Seq<String> x$6 = DataSource$.MODULE$.apply$default$5();
            Option<BucketSpec> x$7 = DataSource$.MODULE$.apply$default$6();
            Option<CatalogTable> x$8 = DataSource$.MODULE$.apply$default$8();
            dataset = sparkSession.baseRelationToDataFrame(new DataSource(x$1, x$3, (Seq<String>)x$2, x$5, x$6, x$7, (Map<String, String>)x$4, x$8).resolveRelation(false)).select("value", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).as(Encoders$.MODULE$.STRING());
        } else {
            String charset3 = options.charset();
            RDD qual$1 = sparkSession.sparkContext().hadoopFile(paths.mkString(","), ClassTag$.MODULE$.apply(LongWritable.class), ClassTag$.MODULE$.apply(Text.class), ClassTag$.MODULE$.apply(TextInputFormat.class));
            Function1 & Serializable & scala.Serializable x$9 = (Function1 & Serializable & scala.Serializable)x$11 -> x$11.map((Function1 & Serializable & scala.Serializable)pair -> new String(((Text)pair._2()).getBytes(), 0, ((Text)pair._2()).getLength(), charset3));
            boolean x$102 = qual$1.mapPartitions$default$2();
            RDD rdd = qual$1.mapPartitions((Function1)x$9, x$102, ClassTag$.MODULE$.apply(String.class));
            dataset = sparkSession.createDataset(rdd, Encoders$.MODULE$.STRING());
        }
        return dataset;
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$readFile$5(UnivocityParser parser$1, StructField x$7) {
        String string = x$7.name();
        String string2 = parser$1.options().columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$readFile$6(UnivocityParser parser$1, StructField x$8) {
        String string = x$8.name();
        String string2 = parser$1.options().columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$readFile$4(StructType requiredSchema$1, UnivocityParser parser$1, StructType dataSchema$1, boolean columnPruning$1, PartitionedFile file$1, boolean caseSensitive$2, String header) {
        StructType actualRequiredSchema = StructType$.MODULE$.apply((Seq)requiredSchema$1.filterNot((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)TextInputCSVDataSource$.$anonfun$readFile$5(parser$1, x$7))));
        StructType actualDataSchema = StructType$.MODULE$.apply((Seq)dataSchema$1.filterNot((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)TextInputCSVDataSource$.$anonfun$readFile$6(parser$1, x$8))));
        StructType schema = columnPruning$1 ? actualRequiredSchema : actualDataSchema;
        String[] columnNames = parser$1.tokenizer().parseLine(header);
        CSVDataSource$.MODULE$.checkHeaderColumnNames(schema, columnNames, file$1.filePath(), parser$1.options().enforceSchema(), caseSensitive$2);
    }

    private TextInputCSVDataSource$() {
        MODULE$ = this;
        this.isSplitable = true;
    }
}

