/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.spark.annotation.InterfaceStability;
import org.apache.spark.api.python.PythonEvalType$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.RelationalGroupedDataset$;
import org.apache.spark.sql.RelationalGroupedDataset$CubeType$;
import org.apache.spark.sql.RelationalGroupedDataset$GroupByType$;
import org.apache.spark.sql.RelationalGroupedDataset$RollupType$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.TypedColumn;
import org.apache.spark.sql.catalyst.analysis.Star;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAlias;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAlias$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.UnresolvedFunction;
import org.apache.spark.sql.catalyst.analysis.UnresolvedFunction$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Cube;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PythonUDF;
import org.apache.spark.sql.catalyst.expressions.Rollup;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateFunction;
import org.apache.spark.sql.catalyst.expressions.aggregate.Average$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Count$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Max$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Min$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Sum$;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.FlatMapGroupsInPandas;
import org.apache.spark.sql.catalyst.plans.logical.FlatMapGroupsInR$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Pivot;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.execution.aggregate.TypedAggregateExpression;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@InterfaceStability.Stable
@ScalaSignature(bytes="\u0006\u0001\rmc\u0001B\"E\u00015C\u0001\u0002\u0016\u0001\u0003\u0002\u0003\u0006I!\u0016\u0005\t;\u0002\u0011\t\u0011)A\u0005=\"A\u0011\u000f\u0001B\u0001B\u0003%!\u000fC\u0004x\u0001\u0011EAIa\b\t\u0011\t\u001d\u0002\u0001)C\u0005\u0005SA\u0001Ba\f\u0001A\u0013%!\u0011\u0007\u0005\t\u0005{\u0001\u0001\u0015\"\u0003\u0003@!A!1\r\u0001!\n\u0013\u0011)\u0007C\u0004\u0003l\u0001!\tA!\u001c\t\u000f\t-\u0004\u0001\"\u0001\u0003z!9!1\u000e\u0001\u0005\u0002\t\u0015\u0005b\u0002B6\u0001\u0011\u0005!1\u0013\u0005\b\u0005W\u0003A\u0011\u0001BW\u0011\u001d\u0011y\u000b\u0001C\u0001\u0005cCqAa.\u0001\t\u0003\u0011I\fC\u0004\u0003@\u0002!\tA!1\t\u000f\t\u001d\u0007\u0001\"\u0001\u0003J\"9!q\u001a\u0001\u0005\u0002\tE\u0007b\u0002Bl\u0001\u0011\u0005!\u0011\u001c\u0005\b\u0005/\u0004A\u0011\u0001Bp\u0011\u001d\u00119\u000e\u0001C\u0001\u0005ODqAa6\u0001\t\u0003\u0011\u0019\u0010C\u0004\u0003X\u0002!\tAa>\t\u000f\t]\u0007\u0001\"\u0001\u0003~\"A11\u0001\u0001\u0005\u0002\u0011\u001b)\u0001\u0003\u0005\u0004<\u0001!\t\u0001RB\u001f\u0011\u001d\t\t\u0002\u0001C!\u0003'9a\u0001\u001e#\t\u0002\u0011+hAB\"E\u0011\u0003!e\u000fC\u0003x;\u0011\u0005\u0001\u0010C\u0003z;\u0011\u0005!P\u0002\u0006\u0002\u0004u\u0001\n1!\u0001E\u0003\u000bAq!a\u0002!\t\u0003\tI\u0001C\u0004\u0002\u0012\u0001\"\t%a\u0005\b\u0011\u0005\u0015R\u0004#\u0001E\u0003O1\u0001\"!\u000b\u001e\u0011\u0003!\u00151\u0006\u0005\u0007o\u0012\"\t!!\f\b\u0011\u0005=R\u0004#\u0001E\u0003c1\u0001\"a\r\u001e\u0011\u0003!\u0015Q\u0007\u0005\u0007o\u001e\"\t!a\u000e\b\u0011\u0005eR\u0004#\u0001E\u0003w1\u0001\"!\u0010\u001e\u0011\u0003!\u0015q\b\u0005\u0007o*\"\t!!\u0011\u0007\u000f\u0005\rS\u0004\u0011#\u0002F!Q\u00111\u000b\u0017\u0003\u0016\u0004%\t!!\u0016\t\u0013\u0005]CF!E!\u0002\u0013I\u0007BCA-Y\tU\r\u0011\"\u0001\u0002\\!Q\u0011Q\r\u0017\u0003\u0012\u0003\u0006I!!\u0018\t\r]dC\u0011AA4\u0011%\ty\u0007LA\u0001\n\u0003\t\t\bC\u0005\u0002x1\n\n\u0011\"\u0001\u0002z!I\u0011q\u0012\u0017\u0012\u0002\u0013\u0005\u0011\u0011\u0013\u0005\n\u0003+c\u0013\u0011!C!\u0003/C\u0011\"a*-\u0003\u0003%\t!!+\t\u0013\u0005EF&!A\u0005\u0002\u0005M\u0006\"CA`Y\u0005\u0005I\u0011IAa\u0011%\ty\rLA\u0001\n\u0003\t\t\u000eC\u0005\u0002\\2\n\t\u0011\"\u0011\u0002^\"I\u0011q\u001c\u0017\u0002\u0002\u0013\u0005\u0013\u0011]\u0004\u000b\u0003Kl\u0012\u0011!E\u0001\t\u0006\u001dhACA\";\u0005\u0005\t\u0012\u0001#\u0002j\"1q/\u0010C\u0001\u0003oD\u0011\"!\u0005>\u0003\u0003%)%!?\t\u0011el\u0014\u0011!CA\u0003wD\u0011B!\u0001>\u0003\u0003%\tIa\u0001\t\u0013\tUQ(!A\u0005\n\t]!\u0001\u0007*fY\u0006$\u0018n\u001c8bY\u001e\u0013x.\u001e9fI\u0012\u000bG/Y:fi*\u0011QIR\u0001\u0004gFd'BA$I\u0003\u0015\u0019\b/\u0019:l\u0015\tI%*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0006\u0019qN]4\u0004\u0001M\u0011\u0001A\u0014\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0002#\u0006)1oY1mC&\u00111\u000b\u0015\u0002\u0007\u0003:L(+\u001a4\u0002\u0005\u00114\u0007C\u0001,[\u001d\t9\u0006,D\u0001E\u0013\tIF)A\u0004qC\u000e\\\u0017mZ3\n\u0005mc&!\u0003#bi\u00064%/Y7f\u0015\tIF)A\u0007he>,\b/\u001b8h\u000bb\u0004(o\u001d\t\u0004?\u001aLgB\u00011f\u001d\t\tG-D\u0001c\u0015\t\u0019G*\u0001\u0004=e>|GOP\u0005\u0002#&\u0011\u0011\fU\u0005\u0003O\"\u00141aU3r\u0015\tI\u0006\u000b\u0005\u0002k_6\t1N\u0003\u0002m[\u0006YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tqG)\u0001\u0005dCR\fG._:u\u0013\t\u00018N\u0001\u0006FqB\u0014Xm]:j_:\f\u0011b\u001a:pkB$\u0016\u0010]3\u0011\u0005M\u0004cBA,\u001d\u0003a\u0011V\r\\1uS>t\u0017\r\\$s_V\u0004X\r\u001a#bi\u0006\u001cX\r\u001e\t\u0003/v\u0019\"!\b(\u0002\rqJg.\u001b;?)\u0005)\u0018!B1qa2LH\u0003B>}{z\u0004\"a\u0016\u0001\t\u000bQ{\u0002\u0019A+\t\u000bu{\u0002\u0019\u00010\t\u000bE|\u0002\u0019A@\u0011\u0007\u0005\u0005\u0001%D\u0001\u001e\u0005%9%o\\;q)f\u0004Xm\u0005\u0002!\u001d\u00061A%\u001b8ji\u0012\"\"!a\u0003\u0011\u0007=\u000bi!C\u0002\u0002\u0010A\u0013A!\u00168ji\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\u0016A!\u0011qCA\u0010\u001d\u0011\tI\"a\u0007\u0011\u0005\u0005\u0004\u0016bAA\u000f!\u00061\u0001K]3eK\u001aLA!!\t\u0002$\t11\u000b\u001e:j]\u001eT1!!\bQ\u0003-9%o\\;q\u0005f$\u0016\u0010]3\u0011\u0007\u0005\u0005AEA\u0006He>,\bOQ=UsB,7c\u0001\u0013O\u007fR\u0011\u0011qE\u0001\t\u0007V\u0014W\rV=qKB\u0019\u0011\u0011A\u0014\u0003\u0011\r+(-\u001a+za\u0016\u001c2a\n(\u0000)\t\t\t$\u0001\u0006S_2dW\u000f\u001d+za\u0016\u00042!!\u0001+\u0005)\u0011v\u000e\u001c7vaRK\b/Z\n\u0004U9{HCAA\u001e\u0005%\u0001\u0016N^8u)f\u0004XmE\u0004-\u001d~\f9%!\u0014\u0011\u0007=\u000bI%C\u0002\u0002LA\u0013q\u0001\u0015:pIV\u001cG\u000fE\u0002P\u0003\u001fJ1!!\u0015Q\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003!\u0001\u0018N^8u\u0007>dW#A5\u0002\u0013ALgo\u001c;D_2\u0004\u0013A\u0002<bYV,7/\u0006\u0002\u0002^A!qLZA0!\rQ\u0017\u0011M\u0005\u0004\u0003GZ'a\u0002'ji\u0016\u0014\u0018\r\\\u0001\bm\u0006dW/Z:!)\u0019\tI'a\u001b\u0002nA\u0019\u0011\u0011\u0001\u0017\t\r\u0005M\u0013\u00071\u0001j\u0011\u001d\tI&\ra\u0001\u0003;\nAaY8qsR1\u0011\u0011NA:\u0003kB\u0001\"a\u00153!\u0003\u0005\r!\u001b\u0005\n\u00033\u0012\u0004\u0013!a\u0001\u0003;\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002|)\u001a\u0011.! ,\u0005\u0005}\u0004\u0003BAA\u0003\u0017k!!a!\u000b\t\u0005\u0015\u0015qQ\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!#Q\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u001b\u000b\u0019IA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\u0014*\"\u0011QLA?\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\u0014\t\u0005\u00037\u000b)+\u0004\u0002\u0002\u001e*!\u0011qTAQ\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\r\u0016\u0001\u00026bm\u0006LA!!\t\u0002\u001e\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111\u0016\t\u0004\u001f\u00065\u0016bAAX!\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011QWA^!\ry\u0015qW\u0005\u0004\u0003s\u0003&aA!os\"I\u0011QX\u001c\u0002\u0002\u0003\u0007\u00111V\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\r\u0007CBAc\u0003\u0017\f),\u0004\u0002\u0002H*\u0019\u0011\u0011\u001a)\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002N\u0006\u001d'\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a5\u0002ZB\u0019q*!6\n\u0007\u0005]\u0007KA\u0004C_>dW-\u00198\t\u0013\u0005u\u0016(!AA\u0002\u0005U\u0016\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005-\u0016AB3rk\u0006d7\u000f\u0006\u0003\u0002T\u0006\r\b\"CA_w\u0005\u0005\t\u0019AA[\u0003%\u0001\u0016N^8u)f\u0004X\rE\u0002\u0002\u0002u\u001aR!PAv\u0003\u001b\u0002\u0012\"!<\u0002t&\fi&!\u001b\u000e\u0005\u0005=(bAAy!\u00069!/\u001e8uS6,\u0017\u0002BA{\u0003_\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\t9\u000f\u0006\u0002\u0002\u001aR1\u0011\u0011NA\u007f\u0003\u007fDa!a\u0015A\u0001\u0004I\u0007bBA-\u0001\u0002\u0007\u0011QL\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011)A!\u0005\u0011\u000b=\u00139Aa\u0003\n\u0007\t%\u0001K\u0001\u0004PaRLwN\u001c\t\u0007\u001f\n5\u0011.!\u0018\n\u0007\t=\u0001K\u0001\u0004UkBdWM\r\u0005\n\u0005'\t\u0015\u0011!a\u0001\u0003S\n1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\te\u0001\u0003BAN\u00057IAA!\b\u0002\u001e\n1qJ\u00196fGR$ra\u001fB\u0011\u0005G\u0011)\u0003C\u0003U\t\u0001\u0007Q\u000bC\u0003^\t\u0001\u0007a\fC\u0003r\t\u0001\u0007!/\u0001\u0003u_\u00123EcA+\u0003,!1!QF\u0003A\u0002y\u000b\u0001\"Y4h\u000bb\u0004(o]\u0001\u0006C2L\u0017m\u001d\u000b\u0005\u0005g\u0011I\u0004E\u0002k\u0005kI1Aa\u000el\u0005=q\u0015-\\3e\u000bb\u0004(/Z:tS>t\u0007B\u0002B\u001e\r\u0001\u0007\u0011.\u0001\u0003fqB\u0014\u0018aF1hOJ,w-\u0019;f\u001dVlWM]5d\u0007>dW/\u001c8t)\u0011\u0011\tE!\u0017\u0015\u0007U\u0013\u0019\u0005C\u0004\u0003F\u001d\u0001\rAa\u0012\u0002\u0003\u0019\u0004ba\u0014B%S\n5\u0013b\u0001B&!\nIa)\u001e8di&|g.\r\t\u0005\u0005\u001f\u0012)&\u0004\u0002\u0003R)\u0019!1K6\u0002\u0013\u0005<wM]3hCR,\u0017\u0002\u0002B,\u0005#\u0012\u0011#Q4he\u0016<\u0017\r^3Gk:\u001cG/[8o\u0011\u001d\u0011Yf\u0002a\u0001\u0005;\n\u0001bY8m\u001d\u0006lWm\u001d\t\u0006\u001f\n}\u0013QC\u0005\u0004\u0005C\u0002&A\u0003\u001fsKB,\u0017\r^3e}\u0005I1\u000f\u001e:U_\u0016C\bO\u001d\u000b\u0005\u0005O\u0012I\u0007E\u0003P\u0005\u0013J\u0017\u000eC\u0004\u0003<!\u0001\r!!\u0006\u0002\u0007\u0005<w\rF\u0003V\u0005_\u0012)\bC\u0004\u0003r%\u0001\rAa\u001d\u0002\u000f\u0005<w-\u0012=qeB9qJ!\u0004\u0002\u0016\u0005U\u0001b\u0002B\u0017\u0013\u0001\u0007!q\u000f\t\u0006\u001f\n}#1\u000f\u000b\u0004+\nm\u0004b\u0002B?\u0015\u0001\u0007!qP\u0001\u0006Kb\u0004(o\u001d\t\t\u0003/\u0011\t)!\u0006\u0002\u0016%!!1QA\u0012\u0005\ri\u0015\r\u001d\u000b\u0004+\n\u001d\u0005b\u0002B?\u0017\u0001\u0007!\u0011\u0012\t\t\u0005\u0017\u0013\t*!\u0006\u0002\u00165\u0011!Q\u0012\u0006\u0005\u0005\u001f\u000b\t+\u0001\u0003vi&d\u0017\u0002\u0002BB\u0005\u001b#R!\u0016BK\u0005;CqAa\u000f\r\u0001\u0004\u00119\nE\u0002X\u00053K1Aa'E\u0005\u0019\u0019u\u000e\\;n]\"9!Q\u0010\u0007A\u0002\t}\u0005#B(\u0003`\t]\u0005f\u0001\u0007\u0003$B!!Q\u0015BT\u001b\t\t9)\u0003\u0003\u0003*\u0006\u001d%a\u0002<be\u0006\u0014xm]\u0001\u0006G>,h\u000e\u001e\u000b\u0002+\u0006!Q.Z1o)\r)&1\u0017\u0005\b\u00057r\u0001\u0019\u0001B/Q\rq!1U\u0001\u0004[\u0006DHcA+\u0003<\"9!1L\bA\u0002\tu\u0003fA\b\u0003$\u0006\u0019\u0011M^4\u0015\u0007U\u0013\u0019\rC\u0004\u0003\\A\u0001\rA!\u0018)\u0007A\u0011\u0019+A\u0002nS:$2!\u0016Bf\u0011\u001d\u0011Y&\u0005a\u0001\u0005;B3!\u0005BR\u0003\r\u0019X/\u001c\u000b\u0004+\nM\u0007b\u0002B.%\u0001\u0007!Q\f\u0015\u0004%\t\r\u0016!\u00029jm>$HcA>\u0003\\\"9!Q\\\nA\u0002\u0005U\u0011a\u00039jm>$8i\u001c7v[:$Ra\u001fBq\u0005GDqA!8\u0015\u0001\u0004\t)\u0002C\u0004\u0002ZQ\u0001\rA!:\u0011\t}3\u0017Q\u0017\u000b\u0006w\n%(1\u001e\u0005\b\u0005;,\u0002\u0019AA\u000b\u0011\u001d\tI&\u0006a\u0001\u0005[\u0004bAa#\u0003p\u0006U\u0016\u0002\u0002By\u0005\u001b\u0013A\u0001T5tiR\u00191P!>\t\u000f\tug\u00031\u0001\u0003\u0018R)1P!?\u0003|\"9!Q\\\fA\u0002\t]\u0005bBA-/\u0001\u0007!Q\u001d\u000b\u0006w\n}8\u0011\u0001\u0005\b\u0005;D\u0002\u0019\u0001BL\u0011\u001d\tI\u0006\u0007a\u0001\u0005[\f\u0001C\u001a7bi6\u000b\u0007o\u0012:pkB\u001c\u0018J\u001c*\u0015\u0013U\u001b9a!\u0006\u0004\u001a\r-\u0002b\u0002B#3\u0001\u00071\u0011\u0002\t\u0006\u001f\u000e-1qB\u0005\u0004\u0007\u001b\u0001&!B!se\u0006L\bcA(\u0004\u0012%\u001911\u0003)\u0003\t\tKH/\u001a\u0005\b\u0007/I\u0002\u0019AB\u0005\u00031\u0001\u0018mY6bO\u0016t\u0015-\\3t\u0011\u001d\u0019Y\"\u0007a\u0001\u0007;\tQB\u0019:pC\u0012\u001c\u0017m\u001d;WCJ\u001c\b#B(\u0004\f\r}\u0001CBB\u0011\u0007O\u0011I\"\u0004\u0002\u0004$)\u00191Q\u0005$\u0002\u0013\t\u0014x.\u00193dCN$\u0018\u0002BB\u0015\u0007G\u0011\u0011B\u0011:pC\u0012\u001c\u0017m\u001d;\t\u000f\r5\u0012\u00041\u0001\u00040\u0005aq.\u001e;qkR\u001c6\r[3nCB!1\u0011GB\u001c\u001b\t\u0019\u0019DC\u0002\u00046\u0011\u000bQ\u0001^=qKNLAa!\u000f\u00044\tQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002+\u0019d\u0017\r^'ba\u001e\u0013x.\u001e9t\u0013:\u0004\u0016M\u001c3bgR\u0019Qka\u0010\t\u000f\tm\"\u00041\u0001\u0004BA\u0019!na\u0011\n\u0007\r\u00153NA\u0005QsRDwN\\+E\r\"\u001a\u0001a!\u0013\u0011\t\r-3Q\u000b\b\u0005\u0007\u001b\u001a\t&\u0004\u0002\u0004P)\u0019\u0011\u0011\u0012$\n\t\rM3qJ\u0001\u0013\u0013:$XM\u001d4bG\u0016\u001cF/\u00192jY&$\u00180\u0003\u0003\u0004X\re#AB*uC\ndWM\u0003\u0003\u0004T\r=\u0003")
public class RelationalGroupedDataset {
    private final Dataset<Row> df;
    private final Seq<Expression> groupingExprs;
    private final GroupType groupType;

    public static RelationalGroupedDataset apply(Dataset<Row> dataset, Seq<Expression> seq, GroupType groupType) {
        return RelationalGroupedDataset$.MODULE$.apply(dataset, seq, groupType);
    }

    public Dataset<Row> agg(Column expr, Column ... exprs) {
        return this.agg(expr, (Seq<Column>)Predef$.MODULE$.wrapRefArray((Object[])exprs));
    }

    public Dataset<Row> mean(String ... colNames) {
        return this.mean((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public Dataset<Row> max(String ... colNames) {
        return this.max((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public Dataset<Row> avg(String ... colNames) {
        return this.avg((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public Dataset<Row> min(String ... colNames) {
        return this.min((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public Dataset<Row> sum(String ... colNames) {
        return this.sum((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    private Dataset<Row> toDF(Seq<Expression> aggExprs) {
        Dataset<Row> dataset;
        Seq aggregates = this.df.sparkSession().sessionState().conf().dataFrameRetainGroupColumns() ? (Seq)this.groupingExprs.$plus$plus(aggExprs, Seq$.MODULE$.canBuildFrom()) : aggExprs;
        Seq aliasedAgg = (Seq)aggregates.map((Function1 & Serializable & scala.Serializable)expr -> this.alias((Expression)expr), Seq$.MODULE$.canBuildFrom());
        GroupType groupType = this.groupType;
        if (RelationalGroupedDataset$GroupByType$.MODULE$.equals(groupType)) {
            dataset = Dataset$.MODULE$.ofRows(this.df.sparkSession(), (LogicalPlan)new Aggregate(this.groupingExprs, aliasedAgg, this.df.logicalPlan()));
        } else if (RelationalGroupedDataset$RollupType$.MODULE$.equals(groupType)) {
            dataset = Dataset$.MODULE$.ofRows(this.df.sparkSession(), (LogicalPlan)new Aggregate((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Rollup[]{new Rollup(this.groupingExprs)})), aliasedAgg, this.df.logicalPlan()));
        } else if (RelationalGroupedDataset$CubeType$.MODULE$.equals(groupType)) {
            dataset = Dataset$.MODULE$.ofRows(this.df.sparkSession(), (LogicalPlan)new Aggregate((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Cube[]{new Cube(this.groupingExprs)})), aliasedAgg, this.df.logicalPlan()));
        } else if (groupType instanceof PivotType) {
            PivotType pivotType = (PivotType)groupType;
            Expression pivotCol = pivotType.pivotCol();
            Seq<Literal> values = pivotType.values();
            Seq aliasedGrps = (Seq)this.groupingExprs.map((Function1 & Serializable & scala.Serializable)expr -> this.alias((Expression)expr), Seq$.MODULE$.canBuildFrom());
            dataset = Dataset$.MODULE$.ofRows(this.df.sparkSession(), (LogicalPlan)new Pivot((Option)new Some((Object)aliasedGrps), pivotCol, values, aggExprs, this.df.logicalPlan()));
        } else {
            throw new MatchError((Object)groupType);
        }
        return dataset;
    }

    private NamedExpression alias(Expression expr) {
        AggregateExpression aggregateExpression;
        NamedExpression namedExpression;
        Expression expression = expr;
        if (expression instanceof UnresolvedAttribute) {
            UnresolvedAttribute unresolvedAttribute = (UnresolvedAttribute)expression;
            namedExpression = new UnresolvedAlias((Expression)unresolvedAttribute, UnresolvedAlias$.MODULE$.apply$default$2());
        } else if (expression instanceof NamedExpression) {
            NamedExpression namedExpression2;
            namedExpression = namedExpression2 = (NamedExpression)expression;
        } else if (expression instanceof AggregateExpression && (aggregateExpression = (AggregateExpression)expression).aggregateFunction() instanceof TypedAggregateExpression) {
            namedExpression = new UnresolvedAlias((Expression)aggregateExpression, (Option)new Some((Function1 & Serializable & scala.Serializable)e -> Column$.MODULE$.generateAlias((Expression)e)));
        } else if (expression != null) {
            Expression expression2;
            Expression x$1 = expression2 = expression;
            String x$2 = package$.MODULE$.toPrettySQL(expression2);
            ExprId x$3 = Alias$.MODULE$.apply$default$3(x$1, x$2);
            Seq x$4 = Alias$.MODULE$.apply$default$4(x$1, x$2);
            Option x$5 = Alias$.MODULE$.apply$default$5(x$1, x$2);
            namedExpression = new Alias(x$1, x$2, x$3, x$4, x$5);
        } else {
            throw new MatchError((Object)expression);
        }
        return namedExpression;
    }

    private Dataset<Row> aggregateNumericColumns(Seq<String> colNames, Function1<Expression, AggregateFunction> f) {
        Seq columnExprs = colNames.isEmpty() ? this.df.numericColumns() : (Seq)colNames.map((Function1 & Serializable & scala.Serializable)colName -> {
            void var2_2;
            NamedExpression namedExpr = $this.df.resolve((String)colName);
            if (!(((Expression)namedExpr).dataType() instanceof NumericType)) {
                throw new AnalysisException(new java.lang.StringBuilder(89).append("\"").append((String)colName).append("\" is not a numeric column. ").append("Aggregation function can only be applied on a numeric column.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            return var2_2;
        }, Seq$.MODULE$.canBuildFrom());
        return this.toDF((Seq<Expression>)((Seq)columnExprs.map((Function1 & Serializable & scala.Serializable)expr -> ((AggregateFunction)f.apply(expr)).toAggregateExpression(), Seq$.MODULE$.canBuildFrom())));
    }

    private Function1<Expression, Expression> strToExpr(String expr) {
        Function1 & Serializable & scala.Serializable exprToFunc = (Function1 & Serializable & scala.Serializable)inputExpr -> {
            UnresolvedFunction unresolvedFunction;
            String string = expr.toLowerCase(Locale.ROOT);
            boolean bl = "avg".equals(string) ? true : ("average".equals(string) ? true : "mean".equals(string));
            if (bl) {
                Expression expression = inputExpr;
                unresolvedFunction = UnresolvedFunction$.MODULE$.apply("avg", (Seq)Nil$.MODULE$.$colon$colon((Object)expression), false);
            } else {
                boolean bl2 = "stddev".equals(string) ? true : "std".equals(string);
                if (bl2) {
                    Expression expression = inputExpr;
                    unresolvedFunction = UnresolvedFunction$.MODULE$.apply("stddev", (Seq)Nil$.MODULE$.$colon$colon((Object)expression), false);
                } else {
                    boolean bl3 = "count".equals(string) ? true : "size".equals(string);
                    if (bl3) {
                        Expression expression = inputExpr;
                        AggregateExpression aggregateExpression = expression instanceof Star ? Count$.MODULE$.apply((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).toAggregateExpression() : Count$.MODULE$.apply(inputExpr).toAggregateExpression();
                        unresolvedFunction = aggregateExpression;
                    } else {
                        Expression expression = inputExpr;
                        unresolvedFunction = UnresolvedFunction$.MODULE$.apply(string, (Seq)Nil$.MODULE$.$colon$colon((Object)expression), false);
                    }
                }
            }
            return unresolvedFunction;
        };
        return (Function1 & Serializable & scala.Serializable)inputExpr -> (Expression)exprToFunc.apply(inputExpr);
    }

    public Dataset<Row> agg(Tuple2<String, String> aggExpr, Seq<Tuple2<String, String>> aggExprs) {
        Tuple2<String, String> tuple2 = aggExpr;
        return this.toDF((Seq<Expression>)((Seq)((TraversableLike)aggExprs.$plus$colon(tuple2, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String colName = (String)tuple2._1();
            String expr = (String)tuple2._2();
            Expression expression = (Expression)this.strToExpr(expr).apply((Object)$this.df.apply(colName).expr());
            return expression;
        }, Seq$.MODULE$.canBuildFrom())));
    }

    public Dataset<Row> agg(scala.collection.immutable.Map<String, String> exprs) {
        return this.toDF((Seq<Expression>)((TraversableOnce)exprs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String colName = (String)tuple2._1();
            String expr = (String)tuple2._2();
            Expression expression = (Expression)this.strToExpr(expr).apply((Object)$this.df.apply(colName).expr());
            return expression;
        }, Iterable$.MODULE$.canBuildFrom())).toSeq());
    }

    public Dataset<Row> agg(Map<String, String> exprs) {
        return this.agg((scala.collection.immutable.Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(exprs).asScala()).toMap(Predef$.MODULE$.$conforms()));
    }

    public Dataset<Row> agg(Column expr, Seq<Column> exprs) {
        Column column = expr;
        return this.toDF((Seq<Expression>)((Seq)((TraversableLike)exprs.$plus$colon((Object)column, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Expression expression;
            Column column = x0$1;
            if (column instanceof TypedColumn) {
                TypedColumn typedColumn = (TypedColumn)column;
                expression = typedColumn.withInputType($this.df.exprEnc(), (Seq<Attribute>)$this.df.logicalPlan().output()).expr();
            } else {
                expression = column.expr();
            }
            return expression;
        }, Seq$.MODULE$.canBuildFrom())));
    }

    public Dataset<Row> count() {
        Alias[] aliasArray = new Alias[1];
        AggregateExpression x$1 = Count$.MODULE$.apply((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).toAggregateExpression();
        String x$2 = "count";
        ExprId x$3 = Alias$.MODULE$.apply$default$3((Expression)x$1, x$2);
        Seq x$4 = Alias$.MODULE$.apply$default$4((Expression)x$1, x$2);
        Option x$5 = Alias$.MODULE$.apply$default$5((Expression)x$1, x$2);
        aliasArray[0] = new Alias((Expression)x$1, x$2, x$3, x$4, x$5);
        return this.toDF((Seq<Expression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])aliasArray))));
    }

    public Dataset<Row> mean(Seq<String> colNames) {
        return this.aggregateNumericColumns(colNames, (Function1<Expression, AggregateFunction>)Average$.MODULE$);
    }

    public Dataset<Row> max(Seq<String> colNames) {
        return this.aggregateNumericColumns(colNames, (Function1<Expression, AggregateFunction>)Max$.MODULE$);
    }

    public Dataset<Row> avg(Seq<String> colNames) {
        return this.aggregateNumericColumns(colNames, (Function1<Expression, AggregateFunction>)Average$.MODULE$);
    }

    public Dataset<Row> min(Seq<String> colNames) {
        return this.aggregateNumericColumns(colNames, (Function1<Expression, AggregateFunction>)Min$.MODULE$);
    }

    public Dataset<Row> sum(Seq<String> colNames) {
        return this.aggregateNumericColumns(colNames, (Function1<Expression, AggregateFunction>)Sum$.MODULE$);
    }

    public RelationalGroupedDataset pivot(String pivotColumn) {
        return this.pivot(Column$.MODULE$.apply(pivotColumn));
    }

    public RelationalGroupedDataset pivot(String pivotColumn, Seq<Object> values) {
        return this.pivot(Column$.MODULE$.apply(pivotColumn), values);
    }

    public RelationalGroupedDataset pivot(String pivotColumn, List<Object> values) {
        return this.pivot(Column$.MODULE$.apply(pivotColumn), values);
    }

    public RelationalGroupedDataset pivot(Column pivotColumn) {
        int maxValues = this.df.sparkSession().sessionState().conf().dataFramePivotMaxValues();
        Seq values = Predef$.MODULE$.genericArrayOps(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.df.select((Seq<Column>)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{pivotColumn})).distinct().limit(maxValues + 1).sort((Seq<Column>)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{pivotColumn})).collect())).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.get(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))).toSeq();
        if (values.length() > maxValues) {
            throw new AnalysisException(new java.lang.StringBuilder(169).append("The pivot column ").append(pivotColumn).append(" has more than ").append(maxValues).append(" distinct values, ").append("this could indicate an error. ").append("If this was intended, set ").append(SQLConf$.MODULE$.DATAFRAME_PIVOT_MAX_VALUES().key()).append(" ").append("to at least the number of distinct values of the pivot column.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        return this.pivot(pivotColumn, (Seq<Object>)values);
    }

    public RelationalGroupedDataset pivot(Column pivotColumn, Seq<Object> values) {
        GroupType groupType = this.groupType;
        if (!RelationalGroupedDataset$GroupByType$.MODULE$.equals(groupType)) {
            if (groupType instanceof PivotType) {
                throw new UnsupportedOperationException("repeated pivots are not supported");
            }
            throw new UnsupportedOperationException("pivot is only supported after a groupBy");
        }
        RelationalGroupedDataset relationalGroupedDataset = new RelationalGroupedDataset(this.df, this.groupingExprs, new PivotType(pivotColumn.expr(), (Seq<Literal>)((Seq)values.map((Function1 & Serializable & scala.Serializable)v -> Literal$.MODULE$.apply(v), Seq$.MODULE$.canBuildFrom()))));
        return relationalGroupedDataset;
    }

    public RelationalGroupedDataset pivot(Column pivotColumn, List<Object> values) {
        return this.pivot(pivotColumn, (Seq<Object>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(values).asScala()));
    }

    public Dataset<Row> flatMapGroupsInR(byte[] f, byte[] packageNames, Broadcast<Object>[] broadcastVars, StructType outputSchema) {
        Seq groupingNamedExpressions = (Seq)this.groupingExprs.map((Function1 & Serializable & scala.Serializable)expr -> this.alias((Expression)expr), Seq$.MODULE$.canBuildFrom());
        Seq groupingCols = (Seq)groupingNamedExpressions.map((Function1 & Serializable & scala.Serializable)x$7 -> Column$.MODULE$.apply((Expression)x$7), Seq$.MODULE$.canBuildFrom());
        Dataset<Row> groupingDataFrame = this.df.select((Seq<Column>)groupingCols);
        Seq groupingAttributes = (Seq)groupingNamedExpressions.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.toAttribute(), Seq$.MODULE$.canBuildFrom());
        return Dataset$.MODULE$.ofRows(this.df.sparkSession(), FlatMapGroupsInR$.MODULE$.apply(f, packageNames, broadcastVars, outputSchema, groupingDataFrame.exprEnc().deserializer(), this.df.exprEnc().deserializer(), this.df.exprEnc().schema(), groupingAttributes, this.df.logicalPlan().output(), this.df.logicalPlan()));
    }

    public Dataset<Row> flatMapGroupsInPandas(PythonUDF expr) {
        Predef$.MODULE$.require(expr.evalType() == PythonEvalType$.MODULE$.SQL_GROUPED_MAP_PANDAS_UDF(), (Function0 & Serializable & scala.Serializable)() -> "Must pass a grouped map udf");
        Predef$.MODULE$.require(expr.dataType() instanceof StructType, (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(36).append("The returnType of the udf must be a ").append(StructType$.MODULE$.simpleString()).toString());
        Seq groupingNamedExpressions = (Seq)this.groupingExprs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            NamedExpression namedExpression;
            Expression expression = x0$1;
            if (expression instanceof NamedExpression) {
                NamedExpression namedExpression2;
                namedExpression = namedExpression2 = (NamedExpression)expression;
            } else {
                Expression x$1 = expression;
                String x$2 = expression.toString();
                ExprId x$3 = Alias$.MODULE$.apply$default$3(x$1, x$2);
                Seq x$4 = Alias$.MODULE$.apply$default$4(x$1, x$2);
                Option x$5 = Alias$.MODULE$.apply$default$5(x$1, x$2);
                namedExpression = new Alias(x$1, x$2, x$3, x$4, x$5);
            }
            return namedExpression;
        }, Seq$.MODULE$.canBuildFrom());
        Seq groupingAttributes = (Seq)groupingNamedExpressions.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.toAttribute(), Seq$.MODULE$.canBuildFrom());
        LogicalPlan child = this.df.logicalPlan();
        Project project = new Project((Seq)groupingNamedExpressions.$plus$plus((GenTraversableOnce)child.output(), Seq$.MODULE$.canBuildFrom()), child);
        Seq output = ((StructType)expr.dataType()).toAttributes();
        FlatMapGroupsInPandas plan = new FlatMapGroupsInPandas(groupingAttributes, (Expression)expr, output, (LogicalPlan)project);
        return Dataset$.MODULE$.ofRows(this.df.sparkSession(), (LogicalPlan)plan);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RelationalGroupedDataset: [grouping expressions: [");
        Seq kFields = (Seq)this.groupingExprs.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                String string;
                boolean bl = false;
                NamedExpression namedExpression = null;
                A1 A1 = x1;
                if (A1 instanceof NamedExpression) {
                    bl = true;
                    namedExpression = (NamedExpression)A1;
                    if (((Expression)namedExpression).resolved()) {
                        string = new java.lang.StringBuilder(2).append(namedExpression.name()).append(": ").append(((Expression)namedExpression).dataType().simpleString(2)).toString();
                        return (B1)string;
                    }
                }
                if (bl) {
                    string = namedExpression.name();
                    return (B1)string;
                }
                string = A1.toString();
                return (B1)string;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Expression x1) {
                boolean bl = false;
                NamedExpression namedExpression = null;
                Expression expression = x1;
                if (expression instanceof NamedExpression) {
                    bl = true;
                    namedExpression = (NamedExpression)expression;
                    if (((Expression)namedExpression).resolved()) {
                        return true;
                    }
                }
                if (!bl) return true;
                return true;
            }
        }, Seq$.MODULE$.canBuildFrom());
        builder.append(((TraversableOnce)kFields.take(2)).mkString(", "));
        Object object = kFields.length() > 2 ? builder.append(new java.lang.StringBuilder(19).append(" ... ").append(kFields.length() - 2).append(" more field(s)").toString()) : BoxedUnit.UNIT;
        return builder.append(new java.lang.StringBuilder(19).append("], value: ").append(this.df.toString()).append(", type: ").append(this.groupType).append("]").toString()).toString();
    }

    public RelationalGroupedDataset(Dataset<Row> df, Seq<Expression> groupingExprs, GroupType groupType) {
        this.df = df;
        this.groupingExprs = groupingExprs;
        this.groupType = groupType;
    }

    public static interface GroupType {
        default public String toString() {
            return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(this.getClass().getSimpleName())).stripSuffix("$"))).stripSuffix("Type");
        }

        public static void $init$(GroupType $this) {
        }
    }

    public static class PivotType
    implements GroupType,
    Product,
    scala.Serializable {
        private final Expression pivotCol;
        private final Seq<Literal> values;

        @Override
        public String toString() {
            return ((GroupType)this).toString();
        }

        public Expression pivotCol() {
            return this.pivotCol;
        }

        public Seq<Literal> values() {
            return this.values;
        }

        public PivotType copy(Expression pivotCol, Seq<Literal> values) {
            return new PivotType(pivotCol, values);
        }

        public Expression copy$default$1() {
            return this.pivotCol();
        }

        public Seq<Literal> copy$default$2() {
            return this.values();
        }

        public String productPrefix() {
            return "PivotType";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Seq<Literal> seq;
            int n = x$1;
            switch (n) {
                case 0: {
                    seq = this.pivotCol();
                    break;
                }
                case 1: {
                    seq = this.values();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return seq;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PivotType;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof PivotType)) return false;
            boolean bl = true;
            if (!bl) return false;
            PivotType pivotType = (PivotType)x$1;
            Expression expression = this.pivotCol();
            Expression expression2 = pivotType.pivotCol();
            if (expression == null) {
                if (expression2 != null) {
                    return false;
                }
            } else if (!expression.equals(expression2)) return false;
            Seq<Literal> seq = this.values();
            Seq<Literal> seq2 = pivotType.values();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!pivotType.canEqual(this)) return false;
            return true;
        }

        public PivotType(Expression pivotCol, Seq<Literal> values) {
            this.pivotCol = pivotCol;
            this.values = values;
            GroupType.$init$(this);
            Product.$init$((Product)this);
        }
    }
}

