/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.NamedRelation;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.AttributeSet$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.catalyst.planning.PhysicalOperation$;
import org.apache.spark.sql.catalyst.plans.logical.AppendData;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Repartition;
import org.apache.spark.sql.execution.CodegenSupport;
import org.apache.spark.sql.execution.FilterExec;
import org.apache.spark.sql.execution.ProjectExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.SparkStrategy;
import org.apache.spark.sql.execution.datasources.DataSourceStrategy$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2ScanExec;
import org.apache.spark.sql.execution.datasources.v2.StreamingDataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.WriteToDataSourceV2;
import org.apache.spark.sql.execution.datasources.v2.WriteToDataSourceV2Exec;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousCoalesceExec;
import org.apache.spark.sql.execution.streaming.continuous.WriteToContinuousDataSource;
import org.apache.spark.sql.execution.streaming.continuous.WriteToContinuousDataSourceExec;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.v2.reader.DataSourceReader;
import org.apache.spark.sql.sources.v2.reader.SupportsPushDownFilters;
import org.apache.spark.sql.sources.v2.reader.SupportsPushDownRequiredColumns;
import org.apache.spark.sql.sources.v2.reader.streaming.ContinuousReader;
import org.apache.spark.sql.sources.v2.writer.DataSourceWriter;
import org.apache.spark.sql.sources.v2.writer.streaming.StreamWriter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DataSourceV2Strategy$
extends SparkStrategy {
    public static DataSourceV2Strategy$ MODULE$;

    static {
        new DataSourceV2Strategy$();
    }

    private Tuple2<Seq<Expression>, Seq<Expression>> pushFilters(DataSourceReader reader, Seq<Expression> filters) {
        Tuple2 tuple2;
        DataSourceReader dataSourceReader = reader;
        if (dataSourceReader instanceof SupportsPushDownFilters) {
            SupportsPushDownFilters supportsPushDownFilters = (SupportsPushDownFilters)dataSourceReader;
            HashMap translatedFilterToExpr = HashMap$.MODULE$.empty();
            ArrayBuffer untranslatableExprs = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            filters.foreach((Function1 & Serializable & scala.Serializable)filterExpr -> {
                ArrayBuffer arrayBuffer;
                Option<Filter> translated = DataSourceStrategy$.MODULE$.translateFilter((Expression)filterExpr);
                if (translated.isDefined()) {
                    translatedFilterToExpr.update(translated.get(), filterExpr);
                    arrayBuffer = BoxedUnit.UNIT;
                } else {
                    arrayBuffer = untranslatableExprs.$plus$eq(filterExpr);
                }
                return arrayBuffer;
            });
            Expression[] postScanFilters = (Expression[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])supportsPushDownFilters.pushFilters((Filter[])translatedFilterToExpr.keys().toArray(ClassTag$.MODULE$.apply(Filter.class))))).map((Function1)translatedFilterToExpr, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Expression.class)));
            Expression[] pushedFilters = (Expression[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])supportsPushDownFilters.pushedFilters())).map((Function1)translatedFilterToExpr, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Expression.class)));
            tuple2 = new Tuple2((Object)Predef$.MODULE$.wrapRefArray((Object[])pushedFilters), (Object)untranslatableExprs.$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])postScanFilters))));
        } else {
            tuple2 = new Tuple2((Object)Nil$.MODULE$, filters);
        }
        return tuple2;
    }

    private Seq<AttributeReference> pruneColumns(DataSourceReader reader, DataSourceV2Relation relation, Seq<Expression> exprs) {
        Seq<AttributeReference> seq;
        DataSourceReader dataSourceReader = reader;
        if (dataSourceReader instanceof SupportsPushDownRequiredColumns) {
            Seq seq2;
            Seq neededOutput;
            SupportsPushDownRequiredColumns supportsPushDownRequiredColumns = (SupportsPushDownRequiredColumns)dataSourceReader;
            AttributeSet requiredColumns = AttributeSet$.MODULE$.apply((Iterable)exprs.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.references(), Seq$.MODULE$.canBuildFrom()));
            Seq seq3 = neededOutput = (Seq)relation.output().filter((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)requiredColumns.contains(elem)));
            Seq<AttributeReference> seq4 = relation.output();
            if (seq3 == null ? seq4 != null : !seq3.equals(seq4)) {
                supportsPushDownRequiredColumns.pruneColumns(package$.MODULE$.AttributeSeq(neededOutput).toStructType());
                Map nameToAttr = ((TraversableOnce)((IterableLike)relation.output().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name(), Seq$.MODULE$.canBuildFrom())).zip(relation.output(), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                seq2 = (Seq)supportsPushDownRequiredColumns.readSchema().toAttributes().map((Function1 & Serializable & scala.Serializable)a -> a.withExprId(((AttributeReference)nameToAttr.apply((Object)a.name())).exprId()), Seq$.MODULE$.canBuildFrom());
            } else {
                seq2 = relation.output();
            }
            seq = seq2;
        } else {
            seq = relation.output();
        }
        return seq;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Seq<SparkPlan> apply(LogicalPlan plan) {
        Nil$ nil$;
        LogicalPlan logicalPlan2 = plan;
        Option option = PhysicalOperation$.MODULE$.unapply(logicalPlan2);
        if (!option.isEmpty()) {
            Seq project = (Seq)((Tuple3)option.get())._1();
            Seq filters = (Seq)((Tuple3)option.get())._2();
            LogicalPlan relation = (LogicalPlan)((Tuple3)option.get())._3();
            if (relation instanceof DataSourceV2Relation) {
                DataSourceV2Relation dataSourceV2Relation = (DataSourceV2Relation)relation;
                DataSourceReader reader = dataSourceV2Relation.newReader();
                Tuple2<Seq<Expression>, Seq<Expression>> tuple2 = this.pushFilters(reader, (Seq<Expression>)filters);
                if (tuple2 == null) throw new MatchError(tuple2);
                Seq pushedFilters = (Seq)tuple2._1();
                Seq postScanFilters = (Seq)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)pushedFilters, (Object)postScanFilters);
                Tuple2 tuple23 = tuple22;
                Seq pushedFilters2 = (Seq)tuple23._1();
                Seq postScanFilters2 = (Seq)tuple23._2();
                Seq<AttributeReference> output = this.pruneColumns(reader, dataSourceV2Relation, (Seq<Expression>)((Seq)project.$plus$plus((GenTraversableOnce)postScanFilters2, Seq$.MODULE$.canBuildFrom())));
                this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(126).append("\n           |Pushing operators to ").append(dataSourceV2Relation.source().getClass()).append("\n           |Pushed Filters: ").append(pushedFilters2.mkString(", ")).append("\n           |Post-Scan Filters: ").append(postScanFilters2.mkString(",")).append("\n           |Output: ").append(output.mkString(", ")).append("\n         ").toString())).stripMargin());
                DataSourceV2ScanExec scan = new DataSourceV2ScanExec(output, dataSourceV2Relation.source(), dataSourceV2Relation.options(), (Seq<Expression>)pushedFilters2, reader);
                Option filterCondition = postScanFilters2.reduceLeftOption((Function2)And$.MODULE$);
                CodegenSupport withFilter = (CodegenSupport)filterCondition.map((Function1 & Serializable & scala.Serializable)x$4 -> new FilterExec((Expression)x$4, scan)).getOrElse((Function0 & Serializable & scala.Serializable)() -> scan);
                ProjectExec projectExec = new ProjectExec((Seq<NamedExpression>)project, (SparkPlan)((Object)withFilter));
                return Nil$.MODULE$.$colon$colon((Object)projectExec);
            }
        }
        if (logicalPlan2 instanceof StreamingDataSourceV2Relation) {
            StreamingDataSourceV2Relation streamingDataSourceV2Relation = (StreamingDataSourceV2Relation)logicalPlan2;
            ProjectExec projectExec = new ProjectExec(streamingDataSourceV2Relation.output(), new DataSourceV2ScanExec(streamingDataSourceV2Relation.output(), streamingDataSourceV2Relation.source(), streamingDataSourceV2Relation.options(), streamingDataSourceV2Relation.pushedFilters(), streamingDataSourceV2Relation.reader()));
            return Nil$.MODULE$.$colon$colon((Object)projectExec);
        }
        if (logicalPlan2 instanceof WriteToDataSourceV2) {
            WriteToDataSourceV2 writeToDataSourceV2 = (WriteToDataSourceV2)logicalPlan2;
            DataSourceWriter writer = writeToDataSourceV2.writer();
            LogicalPlan query = writeToDataSourceV2.query();
            WriteToDataSourceV2Exec writeToDataSourceV2Exec = new WriteToDataSourceV2Exec(writer, this.planLater(query));
            return Nil$.MODULE$.$colon$colon((Object)writeToDataSourceV2Exec);
        }
        if (logicalPlan2 instanceof AppendData) {
            AppendData appendData = (AppendData)logicalPlan2;
            NamedRelation r = appendData.table();
            LogicalPlan query = appendData.query();
            if (r instanceof DataSourceV2Relation) {
                DataSourceV2Relation dataSourceV2Relation = (DataSourceV2Relation)r;
                WriteToDataSourceV2Exec writeToDataSourceV2Exec = new WriteToDataSourceV2Exec(dataSourceV2Relation.newWriter(), this.planLater(query));
                return Nil$.MODULE$.$colon$colon((Object)writeToDataSourceV2Exec);
            }
        }
        if (logicalPlan2 instanceof WriteToContinuousDataSource) {
            WriteToContinuousDataSource writeToContinuousDataSource = (WriteToContinuousDataSource)logicalPlan2;
            StreamWriter writer = writeToContinuousDataSource.writer();
            LogicalPlan query = writeToContinuousDataSource.query();
            WriteToContinuousDataSourceExec writeToContinuousDataSourceExec = new WriteToContinuousDataSourceExec(writer, this.planLater(query));
            return Nil$.MODULE$.$colon$colon((Object)writeToContinuousDataSourceExec);
        }
        if (!(logicalPlan2 instanceof Repartition)) return Nil$.MODULE$;
        Repartition repartition = (Repartition)logicalPlan2;
        int n = repartition.numPartitions();
        boolean bl = repartition.shuffle();
        LogicalPlan child = repartition.child();
        if (1 != n) return Nil$.MODULE$;
        if (false != bl) return Nil$.MODULE$;
        boolean isContinuous = child.collectFirst((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                StreamingDataSourceV2Relation streamingDataSourceV2Relation;
                DataSourceReader r;
                A1 A1 = x1;
                if (A1 instanceof StreamingDataSourceV2Relation && (r = (streamingDataSourceV2Relation = (StreamingDataSourceV2Relation)A1).reader()) instanceof ContinuousReader) {
                    ContinuousReader continuousReader = (ContinuousReader)r;
                    object = continuousReader;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                StreamingDataSourceV2Relation streamingDataSourceV2Relation;
                DataSourceReader r;
                LogicalPlan logicalPlan2 = x1;
                boolean bl = logicalPlan2 instanceof StreamingDataSourceV2Relation && (r = (streamingDataSourceV2Relation = (StreamingDataSourceV2Relation)logicalPlan2).reader()) instanceof ContinuousReader;
                return bl;
            }
        }).isDefined();
        if (isContinuous) {
            ContinuousCoalesceExec continuousCoalesceExec = new ContinuousCoalesceExec(1, this.planLater(child));
            nil$ = Nil$.MODULE$.$colon$colon((Object)continuousCoalesceExec);
            return nil$;
        } else {
            nil$ = Nil$.MODULE$;
        }
        return nil$;
    }

    private DataSourceV2Strategy$() {
        MODULE$ = this;
    }
}

