/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.UUID;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.logical.EventTimeWatermark;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2ScanExec;
import org.apache.spark.sql.execution.streaming.BaseStreamingSink;
import org.apache.spark.sql.execution.streaming.BaseStreamingSource;
import org.apache.spark.sql.execution.streaming.EventTimeStats;
import org.apache.spark.sql.execution.streaming.EventTimeWatermarkExec;
import org.apache.spark.sql.execution.streaming.OffsetSeqMetadata;
import org.apache.spark.sql.execution.streaming.ProgressReporter$;
import org.apache.spark.sql.execution.streaming.ProgressReporter$ExecutionStats$;
import org.apache.spark.sql.execution.streaming.StateStoreWriter;
import org.apache.spark.sql.execution.streaming.StreamProgress;
import org.apache.spark.sql.execution.streaming.StreamingExecutionRelation;
import org.apache.spark.sql.sources.v2.reader.streaming.MicroBatchReader;
import org.apache.spark.sql.streaming.SinkProgress;
import org.apache.spark.sql.streaming.SourceProgress;
import org.apache.spark.sql.streaming.StateOperatorProgress;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.apache.spark.sql.streaming.StreamingQueryProgress;
import org.apache.spark.sql.streaming.StreamingQueryStatus;
import org.apache.spark.util.Clock;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Queue;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\rEea\u0002&L!\u0003\r\t\u0001\u0017\u0005\u0006K\u0002!\tA\u001a\u0004\u0005U\u0002\u00015\u000e\u0003\u0005s\u0005\tU\r\u0011\"\u0001t\u0011%\tiA\u0001B\tB\u0003%A\u000f\u0003\u0006\u0002\u0010\t\u0011)\u001a!C\u0001\u0003#A!\"a\f\u0003\u0005#\u0005\u000b\u0011BA\n\u0011)\t\tD\u0001BK\u0002\u0013\u0005\u00111\u0007\u0005\u000b\u0003{\u0011!\u0011#Q\u0001\n\u0005U\u0002bBA \u0005\u0011\u0005\u0011\u0011\t\u0005\n\u0003\u001b\u0012\u0011\u0011!C\u0001\u0003\u001fB\u0011\"a\u0016\u0003#\u0003%\t!!\u0017\t\u0013\u0005=$!%A\u0005\u0002\u0005E\u0004\"CA;\u0005E\u0005I\u0011AA<\u0011%\tYHAA\u0001\n\u0003\ni\bC\u0005\u0002\u000e\n\t\t\u0011\"\u0001\u0002\u0010\"I\u0011q\u0013\u0002\u0002\u0002\u0013\u0005\u0011\u0011\u0014\u0005\n\u0003K\u0013\u0011\u0011!C!\u0003OC\u0011\"!.\u0003\u0003\u0003%\t!a.\t\u0013\u0005\u0005'!!A\u0005B\u0005\r\u0007\"CAc\u0005\u0005\u0005I\u0011IAd\u0011%\tIMAA\u0001\n\u0003\nYmB\u0005\u0002P\u0002\t\t\u0011#\u0001\u0002R\u001aA!\u000eAA\u0001\u0012\u0003\t\u0019\u000eC\u0004\u0002@]!\t!!9\t\u0013\u0005\u0015w#!A\u0005F\u0005\u001d\u0007\"CAr/\u0005\u0005I\u0011QAs\u0011%\tioFA\u0001\n\u0003\u000by\u000fC\u0004\u0003\u0002\u00011\tBa\u0001\t\u000f\tE\u0001A\"\u0005\u0003\u0004!9!1\u0003\u0001\u0007\u0012\tU\u0001b\u0002B\f\u0001\u0019E!\u0011\u0004\u0005\b\u0005K\u0001a\u0011\u0003B\u0014\u0011\u001d\u0011i\u0004\u0001D\t\u0005\u007fAqA!\u0013\u0001\r#\u0011Y\u0005C\u0004\u0003P\u00011\tB!\u0015\t\u000f\tU\u0003A\"\u0005\u0003X!9!q\f\u0001\u0007\u0012\t\u0005\u0004b\u0002B5\u0001\u0019E!1\u000e\u0005\b\u0005[\u0002a\u0011\u0003B8\u0011\u001d\u0011I\b\u0001D\t\u0005wB\u0011Ba$\u0001\u0001\u0004%IAa\u001b\t\u0013\tE\u0005\u00011A\u0005\n\tM\u0005\"\u0003BL\u0001\u0001\u0007I\u0011\u0002B6\u0011%\u0011I\n\u0001a\u0001\n\u0013\u0011Y\nC\u0006\u0003 \u0002\u0001\r\u00111A\u0005\n\t\u0005\u0006b\u0003BS\u0001\u0001\u0007\t\u0019!C\u0005\u0005OC1Ba+\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003\"\"Y!Q\u0016\u0001A\u0002\u0003\u0007I\u0011\u0002BX\u0011%\u0011\u0019\f\u0001a\u0001\n\u0013\u0011Y\u0007C\u0005\u00036\u0002\u0001\r\u0011\"\u0003\u00038\"I!1\u0018\u0001C\u0002\u0013%!Q\u0018\u0005\n\u0005\u0017\u0004\u0001\u0019!C\u0005\u0005\u001bD\u0011Ba4\u0001\u0001\u0004%IA!5\t\u0013\tU\u0007A1A\u0005\n\t]\u0007\"\u0003Bs\u0001\t\u0007I\u0011\u0002B6\u0011%\u00119\u000f\u0001a\u0001\n\u0013\u0011Y\u0007C\u0005\u0003j\u0002\u0001\r\u0011\"\u0003\u0003l\"I!q\u001e\u0001C\u0002\u0013%!\u0011\u001f\u0005\n\u0005\u007f\u0004\u0001\u0019!C\t\u0007\u0003A\u0011b!\u0005\u0001\u0001\u0004%\tba\u0005\t\u000f\r]\u0001\u0001\"\u0001\u0004\u0002!91\u0011\u0004\u0001\u0005\u0002\rm\u0001bBB\u0012\u0001\u0011\u00051Q\u0005\u0005\u0007\u0007O\u0001A\u0011\u00034\t\u000f\r%\u0002\u0001\"\u0005\u0004,!911\b\u0001\u0005\n\ru\u0002bBB\"\u0001\u0011E1Q\t\u0005\b\u0007\u0017\u0002A\u0011BB'\u0011\u001d\u0019\t\u0006\u0001C\u0005\u0007'Bqaa\u0016\u0001\t\u0013\u0019I\u0006C\u0004\u0004\\\u0001!\tb!\u0018\t\u000f\r\u0005\u0005\u0001\"\u0003\u0004\u0004\"91\u0011\u0012\u0001\u0005\u0012\r-%\u0001\u0005)s_\u001e\u0014Xm]:SKB|'\u000f^3s\u0015\taU*A\u0005tiJ,\u0017-\\5oO*\u0011ajT\u0001\nKb,7-\u001e;j_:T!\u0001U)\u0002\u0007M\fHN\u0003\u0002S'\u0006)1\u000f]1sW*\u0011A+V\u0001\u0007CB\f7\r[3\u000b\u0003Y\u000b1a\u001c:h\u0007\u0001\u00192\u0001A-`!\tQV,D\u0001\\\u0015\u0005a\u0016!B:dC2\f\u0017B\u00010\\\u0005\u0019\te.\u001f*fMB\u0011\u0001mY\u0007\u0002C*\u0011!-U\u0001\tS:$XM\u001d8bY&\u0011A-\u0019\u0002\b\u0019><w-\u001b8h\u0003\u0019!\u0013N\\5uIQ\tq\r\u0005\u0002[Q&\u0011\u0011n\u0017\u0002\u0005+:LGO\u0001\bFq\u0016\u001cW\u000f^5p]N#\u0018\r^:\u0014\t\tIFn\u001c\t\u000356L!A\\.\u0003\u000fA\u0013x\u000eZ;diB\u0011!\f]\u0005\u0003cn\u0013AbU3sS\u0006d\u0017N_1cY\u0016\f\u0011\"\u001b8qkR\u0014vn^:\u0016\u0003Q\u0004R!\u001e?\u0000\u0003\u000fq!A\u001e>\u0011\u0005]\\V\"\u0001=\u000b\u0005e<\u0016A\u0002\u001fs_>$h(\u0003\u0002|7\u00061\u0001K]3eK\u001aL!! @\u0003\u00075\u000b\u0007O\u0003\u0002|7B!\u0011\u0011AA\u0002\u001b\u0005Y\u0015bAA\u0003\u0017\n\u0019\")Y:f'R\u0014X-Y7j]\u001e\u001cv.\u001e:dKB\u0019!,!\u0003\n\u0007\u0005-1L\u0001\u0003M_:<\u0017AC5oaV$(k\\<tA\u0005q1\u000f^1uK>\u0003XM]1u_J\u001cXCAA\n!\u0019\t)\"a\b\u0002&9!\u0011qCA\u000e\u001d\r9\u0018\u0011D\u0005\u00029&\u0019\u0011QD.\u0002\u000fA\f7m[1hK&!\u0011\u0011EA\u0012\u0005\r\u0019V-\u001d\u0006\u0004\u0003;Y\u0006\u0003BA\u0014\u0003Wi!!!\u000b\u000b\u00051{\u0015\u0002BA\u0017\u0003S\u0011Qc\u0015;bi\u0016|\u0005/\u001a:bi>\u0014\bK]8he\u0016\u001c8/A\bti\u0006$Xm\u00149fe\u0006$xN]:!\u00039)g/\u001a8u)&lWm\u0015;biN,\"!!\u000e\u0011\rUd\u0018qGA\u001c!\r)\u0018\u0011H\u0005\u0004\u0003wq(AB*ue&tw-A\bfm\u0016tG\u000fV5nKN#\u0018\r^:!\u0003\u0019a\u0014N\\5u}QA\u00111IA$\u0003\u0013\nY\u0005E\u0002\u0002F\ti\u0011\u0001\u0001\u0005\u0006e&\u0001\r\u0001\u001e\u0005\b\u0003\u001fI\u0001\u0019AA\n\u0011\u001d\t\t$\u0003a\u0001\u0003k\tAaY8qsRA\u00111IA)\u0003'\n)\u0006C\u0004s\u0015A\u0005\t\u0019\u0001;\t\u0013\u0005=!\u0002%AA\u0002\u0005M\u0001\"CA\u0019\u0015A\u0005\t\u0019AA\u001b\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u0017+\u0007Q\fif\u000b\u0002\u0002`A!\u0011\u0011MA6\u001b\t\t\u0019G\u0003\u0003\u0002f\u0005\u001d\u0014!C;oG\",7m[3e\u0015\r\tIgW\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA7\u0003G\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a\u001d+\t\u0005M\u0011QL\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\tIH\u000b\u0003\u00026\u0005u\u0013!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u0000A!\u0011\u0011QAF\u001b\t\t\u0019I\u0003\u0003\u0002\u0006\u0006\u001d\u0015\u0001\u00027b]\u001eT!!!#\u0002\t)\fg/Y\u0005\u0005\u0003w\t\u0019)\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\u0012B\u0019!,a%\n\u0007\u0005U5LA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u001c\u0006\u0005\u0006c\u0001.\u0002\u001e&\u0019\u0011qT.\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002$B\t\t\u00111\u0001\u0002\u0012\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!+\u0011\r\u0005-\u0016\u0011WAN\u001b\t\tiKC\u0002\u00020n\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019,!,\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003s\u000by\fE\u0002[\u0003wK1!!0\\\u0005\u001d\u0011un\u001c7fC:D\u0011\"a)\u0013\u0003\u0003\u0005\r!a'\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!%\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a \u0002\r\u0015\fX/\u00197t)\u0011\tI,!4\t\u0013\u0005\rV#!AA\u0002\u0005m\u0015AD#yK\u000e,H/[8o'R\fGo\u001d\t\u0004\u0003\u000b:2\u0003B\f\u0002V>\u00042\"a6\u0002^R\f\u0019\"!\u000e\u0002D5\u0011\u0011\u0011\u001c\u0006\u0004\u00037\\\u0016a\u0002:v]RLW.Z\u0005\u0005\u0003?\fINA\tBEN$(/Y2u\rVt7\r^5p]N\"\"!!5\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0011\u0005\r\u0013q]Au\u0003WDQA\u001d\u000eA\u0002QDq!a\u0004\u001b\u0001\u0004\t\u0019\u0002C\u0004\u00022i\u0001\r!!\u000e\u0002\u000fUt\u0017\r\u001d9msR!\u0011\u0011_A\u007f!\u0015Q\u00161_A|\u0013\r\t)p\u0017\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0011i\u000bI\u0010^A\n\u0003kI1!a?\\\u0005\u0019!V\u000f\u001d7fg!I\u0011q`\u000e\u0002\u0002\u0003\u0007\u00111I\u0001\u0004q\u0012\u0002\u0014AA5e+\t\u0011)\u0001\u0005\u0003\u0003\b\t5QB\u0001B\u0005\u0015\u0011\u0011Y!a\"\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005\u001f\u0011IA\u0001\u0003V+&#\u0015!\u0002:v]&#\u0017\u0001\u00028b[\u0016,\"!a\u000e\u0002\u0019Q\u0014\u0018nZ4fe\u000ecwnY6\u0016\u0005\tm\u0001\u0003\u0002B\u000f\u0005Ci!Aa\b\u000b\u0007\t-\u0011+\u0003\u0003\u0003$\t}!!B\"m_\u000e\\\u0017a\u00037pO&\u001c\u0017\r\u001c)mC:,\"A!\u000b\u0011\t\t-\"\u0011H\u0007\u0003\u0005[QAAa\f\u00032\u00059An\\4jG\u0006d'\u0002\u0002B\u001a\u0005k\tQ\u0001\u001d7b]NT1Aa\u000eP\u0003!\u0019\u0017\r^1msN$\u0018\u0002\u0002B\u001e\u0005[\u00111\u0002T8hS\u000e\fG\u000e\u00157b]\u0006iA.Y:u\u000bb,7-\u001e;j_:,\"A!\u0011\u0011\t\t\r#QI\u0007\u0002\u001b&\u0019!qI'\u0003\u001dE+XM]=Fq\u0016\u001cW\u000f^5p]\u00069a.Z<ECR\fWC\u0001B'!\u0015)Hp B\u0015\u0003\u001d\u0019x.\u001e:dKN,\"Aa\u0015\u0011\u000b\u0005U\u0011qD@\u0002\tMLgn[\u000b\u0003\u00053\u0002B!!\u0001\u0003\\%\u0019!QL&\u0003#\t\u000b7/Z*ue\u0016\fW.\u001b8h'&t7.A\tpM\u001a\u001cX\r^*fc6+G/\u00193bi\u0006,\"Aa\u0019\u0011\t\u0005\u0005!QM\u0005\u0004\u0005OZ%!E(gMN,GoU3r\u001b\u0016$\u0018\rZ1uC\u0006q1-\u001e:sK:$()\u0019;dQ&#WCAA\u0004\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o+\t\u0011\t\b\u0005\u0003\u0003t\tUT\"A(\n\u0007\t]tJ\u0001\u0007Ta\u0006\u00148nU3tg&|g.A\u0005q_N$XI^3oiR\u0019qM! \t\u000f\t}\u0004\u00061\u0001\u0003\u0002\u0006)QM^3oiB!!1\u0011BE\u001d\u0011\t9C!\"\n\t\t\u001d\u0015\u0011F\u0001\u0017'R\u0014X-Y7j]\u001e\fV/\u001a:z\u0019&\u001cH/\u001a8fe&!!1\u0012BG\u0005\u0015)e/\u001a8u\u0015\u0011\u00119)!\u000b\u00029\r,(O]3oiR\u0013\u0018nZ4feN#\u0018M\u001d;US6,7\u000f^1na\u0006\u00013-\u001e:sK:$HK]5hO\u0016\u00148\u000b^1siRKW.Z:uC6\u0004x\fJ3r)\r9'Q\u0013\u0005\n\u0003GS\u0013\u0011!a\u0001\u0003\u000f\t!dY;se\u0016tG\u000f\u0016:jO\u001e,'/\u00128e)&lWm\u001d;b[B\fadY;se\u0016tG\u000f\u0016:jO\u001e,'/\u00128e)&lWm\u001d;b[B|F%Z9\u0015\u0007\u001d\u0014i\nC\u0005\u0002$2\n\t\u00111\u0001\u0002\b\u0005Q2-\u001e:sK:$HK]5hO\u0016\u00148\u000b^1si>3gm]3ugV\u0011!1\u0015\t\u0006kr|\u0018qG\u0001\u001fGV\u0014(/\u001a8u)JLwmZ3s'R\f'\u000f^(gMN,Go]0%KF$2a\u001aBU\u0011%\t\u0019KLA\u0001\u0002\u0004\u0011\u0019+\u0001\rdkJ\u0014XM\u001c;Ue&<w-\u001a:F]\u0012|eMZ:fiN\fAdY;se\u0016tG\u000f\u0016:jO\u001e,'/\u00128e\u001f\u001a47/\u001a;t?\u0012*\u0017\u000fF\u0002h\u0005cC\u0011\"a)1\u0003\u0003\u0005\rAa)\u000231\f7\u000f\u001e+sS\u001e<WM]*uCJ$H+[7fgR\fW\u000e]\u0001\u001eY\u0006\u001cH\u000f\u0016:jO\u001e,'o\u0015;beR$\u0016.\\3ti\u0006l\u0007o\u0018\u0013fcR\u0019qM!/\t\u0013\u0005\r&'!AA\u0002\u0005\u001d\u0011AE2veJ,g\u000e\u001e#ve\u0006$\u0018n\u001c8t\u001bN,\"Aa0\u0011\u0011\t\u0005'qYA\u001c\u0003\u000fi!Aa1\u000b\t\t\u0015\u0017QV\u0001\b[V$\u0018M\u00197f\u0013\u0011\u0011IMa1\u0003\u000f!\u000b7\u000f['ba\u0006\u0019R.\u001a;sS\u000e<\u0016M\u001d8j]\u001edunZ4fIV\u0011\u0011\u0011X\u0001\u0018[\u0016$(/[2XCJt\u0017N\\4M_\u001e<W\rZ0%KF$2a\u001aBj\u0011%\t\u0019+NA\u0001\u0002\u0004\tI,\u0001\bqe><'/Z:t\u0005V4g-\u001a:\u0016\u0005\te\u0007C\u0002Ba\u00057\u0014y.\u0003\u0003\u0003^\n\r'!B)vKV,\u0007\u0003BA\u0014\u0005CLAAa9\u0002*\t12\u000b\u001e:fC6LgnZ)vKJL\bK]8he\u0016\u001c8/A\u000eo_\u0012\u000bG/\u0019)s_\u001e\u0014Xm]:Fm\u0016tG/\u00138uKJ4\u0018\r\\\u0001\u001cY\u0006\u001cHOT8ECR\f\u0007K]8he\u0016\u001c8/\u0012<f]R$\u0016.\\3\u0002?1\f7\u000f\u001e(p\t\u0006$\u0018\r\u0015:pOJ,7o]#wK:$H+[7f?\u0012*\u0017\u000fF\u0002h\u0005[D\u0011\"a):\u0003\u0003\u0005\r!a\u0002\u0002\u001fQLW.Z:uC6\u0004hi\u001c:nCR,\"Aa=\u0011\t\tU(1`\u0007\u0003\u0005oTAA!?\u0002\b\u0006!A/\u001a=u\u0013\u0011\u0011iPa>\u0003!MKW\u000e\u001d7f\t\u0006$XMR8s[\u0006$\u0018!D2veJ,g\u000e^*uCR,8/\u0006\u0002\u0004\u0004A!\u0011qEB\u0003\u0013\u0011\u00199!!\u000b\u0003)M#(/Z1nS:<\u0017+^3ssN#\u0018\r^;tQ\rY41\u0002\t\u00045\u000e5\u0011bAB\b7\nAao\u001c7bi&dW-A\tdkJ\u0014XM\u001c;Ti\u0006$Xo]0%KF$2aZB\u000b\u0011%\t\u0019\u000bPA\u0001\u0002\u0004\u0019\u0019!\u0001\u0004ti\u0006$Xo]\u0001\u000fe\u0016\u001cWM\u001c;Qe><'/Z:t+\t\u0019i\u0002E\u0003[\u0007?\u0011y.C\u0002\u0004\"m\u0013Q!\u0011:sCf\fA\u0002\\1tiB\u0013xn\u001a:fgN,\"Aa8\u0002\u0019M$\u0018M\u001d;Ue&<w-\u001a:\u0002)I,7m\u001c:e)JLwmZ3s\u001f\u001a47/\u001a;t)\u001597QFB\u001c\u0011\u001d\u0019y#\u0011a\u0001\u0007c\tAA\u001a:p[B!\u0011\u0011AB\u001a\u0013\r\u0019)d\u0013\u0002\u000f'R\u0014X-Y7Qe><'/Z:t\u0011\u001d\u0019I$\u0011a\u0001\u0007c\t!\u0001^8\u0002\u001dU\u0004H-\u0019;f!J|wM]3tgR\u0019qma\u0010\t\u000f\r\u0005#\t1\u0001\u0003`\u0006Ya.Z<Qe><'/Z:t\u000351\u0017N\\5tQR\u0013\u0018nZ4feR\u0019qma\u0012\t\u000f\r%3\t1\u0001\u0002:\u0006Q\u0001.Y:OK^$\u0015\r^1\u00027\u0015DHO]1diN#\u0018\r^3Pa\u0016\u0014\u0018\r^8s\u001b\u0016$(/[2t)\u0011\t\u0019ba\u0014\t\u000f\r%C\t1\u0001\u0002:\u0006)R\r\u001f;sC\u000e$X\t_3dkRLwN\\*uCR\u001cH\u0003BA\"\u0007+Bqa!\u0013F\u0001\u0004\tI,A\u000efqR\u0014\u0018m\u0019;T_V\u00148-\u001a+p\u001dVl\u0017J\u001c9viJ{wo\u001d\u000b\u0002i\u0006y!/\u001a9peR$\u0016.\\3UC.,g.\u0006\u0003\u0004`\r\u001dD\u0003BB1\u0007{\"Baa\u0019\u0004tA!1QMB4\u0019\u0001!qa!\u001bH\u0005\u0004\u0019YGA\u0001U#\u0011\u0019i'a'\u0011\u0007i\u001by'C\u0002\u0004rm\u0013qAT8uQ&tw\r\u0003\u0005\u0004v\u001d#\t\u0019AB<\u0003\u0011\u0011w\u000eZ=\u0011\u000bi\u001bIha\u0019\n\u0007\rm4L\u0001\u0005=Eft\u0017-\\3?\u0011\u001d\u0019yh\u0012a\u0001\u0003o\t\u0001\u0003\u001e:jO\u001e,'\u000fR3uC&d7*Z=\u0002\u001f\u0019|'/\\1u)&lWm\u001d;b[B$B!a\u000e\u0004\u0006\"91q\u0011%A\u0002\u0005\u001d\u0011AB7jY2L7/A\nva\u0012\fG/Z*uCR,8/T3tg\u0006<W\rF\u0002h\u0007\u001bCqaa$J\u0001\u0004\t9$A\u0004nKN\u001c\u0018mZ3")
public interface ProgressReporter
extends Logging {
    public ProgressReporter$ExecutionStats$ ExecutionStats();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs_$eq(scala.collection.mutable.HashMap<String, Object> var1);

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer_$eq(Queue<StreamingQueryProgress> var1);

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$noDataProgressEventInterval_$eq(long var1);

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$timestampFormat_$eq(SimpleDateFormat var1);

    public UUID id();

    public UUID runId();

    public String name();

    public Clock triggerClock();

    public LogicalPlan logicalPlan();

    public QueryExecution lastExecution();

    public scala.collection.immutable.Map<BaseStreamingSource, LogicalPlan> newData();

    public Seq<BaseStreamingSource> sources();

    public BaseStreamingSink sink();

    public OffsetSeqMetadata offsetSeqMetadata();

    public long currentBatchId();

    public SparkSession sparkSession();

    public void postEvent(StreamingQueryListener.Event var1);

    public long org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp_$eq(long var1);

    public long org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndTimestamp();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndTimestamp_$eq(long var1);

    public scala.collection.immutable.Map<BaseStreamingSource, String> org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartOffsets();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartOffsets_$eq(scala.collection.immutable.Map<BaseStreamingSource, String> var1);

    public scala.collection.immutable.Map<BaseStreamingSource, String> org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndOffsets();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndOffsets_$eq(scala.collection.immutable.Map<BaseStreamingSource, String> var1);

    public long org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp_$eq(long var1);

    public scala.collection.mutable.HashMap<String, Object> org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs();

    public boolean org$apache$spark$sql$execution$streaming$ProgressReporter$$metricWarningLogged();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$metricWarningLogged_$eq(boolean var1);

    public Queue<StreamingQueryProgress> org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer();

    public long org$apache$spark$sql$execution$streaming$ProgressReporter$$noDataProgressEventInterval();

    public long org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoDataProgressEventTime();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoDataProgressEventTime_$eq(long var1);

    public SimpleDateFormat org$apache$spark$sql$execution$streaming$ProgressReporter$$timestampFormat();

    public StreamingQueryStatus currentStatus();

    public void currentStatus_$eq(StreamingQueryStatus var1);

    public static /* synthetic */ StreamingQueryStatus status$(ProgressReporter $this) {
        return $this.status();
    }

    default public StreamingQueryStatus status() {
        return this.currentStatus();
    }

    public static /* synthetic */ StreamingQueryProgress[] recentProgress$(ProgressReporter $this) {
        return $this.recentProgress();
    }

    default public StreamingQueryProgress[] recentProgress() {
        StreamingQueryProgress[] streamingQueryProgressArray;
        Queue<StreamingQueryProgress> queue = this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer();
        synchronized (queue) {
            streamingQueryProgressArray = (StreamingQueryProgress[])this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer().toArray(ClassTag$.MODULE$.apply(StreamingQueryProgress.class));
        }
        return streamingQueryProgressArray;
    }

    public static /* synthetic */ StreamingQueryProgress lastProgress$(ProgressReporter $this) {
        return $this.lastProgress();
    }

    default public StreamingQueryProgress lastProgress() {
        StreamingQueryProgress streamingQueryProgress;
        Queue<StreamingQueryProgress> queue = this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer();
        synchronized (queue) {
            streamingQueryProgress = (StreamingQueryProgress)this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer().lastOption().orNull(Predef$.MODULE$.$conforms());
        }
        return streamingQueryProgress;
    }

    public static /* synthetic */ void startTrigger$(ProgressReporter $this) {
        $this.startTrigger();
    }

    default public void startTrigger() {
        this.logDebug((Function0 & Serializable & scala.Serializable)() -> "Starting Trigger Calculation");
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp_$eq(this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp());
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp_$eq(this.triggerClock().getTimeMillis());
        StreamingQueryStatus qual$1 = this.currentStatus();
        boolean x$1 = true;
        String x$2 = qual$1.copy$default$1();
        boolean x$3 = qual$1.copy$default$2();
        this.currentStatus_$eq(qual$1.copy(x$2, x$3, x$1));
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartOffsets_$eq(null);
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndOffsets_$eq(null);
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs().clear();
    }

    public static /* synthetic */ void recordTriggerOffsets$(ProgressReporter $this, StreamProgress from, StreamProgress to) {
        $this.recordTriggerOffsets(from, to);
    }

    default public void recordTriggerOffsets(StreamProgress from, StreamProgress to) {
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartOffsets_$eq(from.mapValues((Function1 & Serializable & scala.Serializable)x$1 -> x$1.json()));
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndOffsets_$eq(to.mapValues((Function1 & Serializable & scala.Serializable)x$2 -> x$2.json()));
    }

    private void updateProgress(StreamingQueryProgress newProgress) {
        Queue<StreamingQueryProgress> queue = this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer();
        synchronized (queue) {
            this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer().$plus$eq((Object)newProgress);
            while (this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer().length() >= this.sparkSession().sqlContext().conf().streamingProgressRetention()) {
                this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer().dequeue();
            }
        }
        this.postEvent(new StreamingQueryListener.QueryProgressEvent(newProgress));
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Streaming query made progress: ").append(newProgress).toString());
    }

    public static /* synthetic */ void finishTrigger$(ProgressReporter $this, boolean hasNewData) {
        $this.finishTrigger(hasNewData);
    }

    default public void finishTrigger(boolean hasNewData) {
        Predef$.MODULE$.assert(this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartOffsets() != null && this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndOffsets() != null);
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndTimestamp_$eq(this.triggerClock().getTimeMillis());
        ExecutionStats executionStats = this.extractExecutionStats(hasNewData);
        double processingTimeSec = (double)(this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndTimestamp() - this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp()) / (double)1000;
        double inputTimeSec = this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp() >= 0L ? (double)(this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp() - this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp()) / (double)1000 : Double.NaN;
        this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Execution stats: ").append(executionStats).toString());
        Seq sourceProgress = (Seq)((TraversableLike)this.sources().distinct()).map((Function1 & Serializable & scala.Serializable)source -> {
            long numRecords = BoxesRunTime.unboxToLong((Object)executionStats.inputRows().getOrElse(source, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
            return new SourceProgress(source.toString(), (String)this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartOffsets().get(source).orNull(Predef$.MODULE$.$conforms()), (String)this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndOffsets().get(source).orNull(Predef$.MODULE$.$conforms()), numRecords, (double)numRecords / inputTimeSec, (double)numRecords / processingTimeSec);
        }, Seq$.MODULE$.canBuildFrom());
        SinkProgress sinkProgress = new SinkProgress(this.sink().toString());
        StreamingQueryProgress newProgress = new StreamingQueryProgress(this.id(), this.runId(), this.name(), this.org$apache$spark$sql$execution$streaming$ProgressReporter$$formatTimestamp(this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp()), this.currentBatchId(), new HashMap<String, Long>((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs().toMap(Predef$.MODULE$.$conforms()).mapValues((Function1 & Serializable & scala.Serializable)x -> Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)x)))).asJava()), new HashMap<String, String>((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(executionStats.eventTimeStats()).asJava()), (StateOperatorProgress[])executionStats.stateOperators().toArray(ClassTag$.MODULE$.apply(StateOperatorProgress.class)), (SourceProgress[])sourceProgress.toArray(ClassTag$.MODULE$.apply(SourceProgress.class)), sinkProgress);
        if (hasNewData) {
            this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoDataProgressEventTime_$eq(Long.MIN_VALUE);
            this.updateProgress(newProgress);
        } else {
            long now = this.triggerClock().getTimeMillis();
            if (now - this.org$apache$spark$sql$execution$streaming$ProgressReporter$$noDataProgressEventInterval() >= this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoDataProgressEventTime()) {
                this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoDataProgressEventTime_$eq(now);
                this.updateProgress(newProgress);
            }
        }
        StreamingQueryStatus qual$1 = this.currentStatus();
        boolean x$1 = false;
        String x$2 = qual$1.copy$default$1();
        boolean x$3 = qual$1.copy$default$2();
        this.currentStatus_$eq(qual$1.copy(x$2, x$3, x$1));
    }

    private Seq<StateOperatorProgress> extractStateOperatorMetrics(boolean hasNewData) {
        if (this.lastExecution() == null) {
            return Nil$.MODULE$;
        }
        return this.lastExecution().executedPlan().collect((PartialFunction)new scala.Serializable(null, hasNewData){
            public static final long serialVersionUID = 0L;
            private final boolean hasNewData$1;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof StateStoreWriter) {
                    StateOperatorProgress progress = ((StateStoreWriter)((Object)A1)).getProgress();
                    object = this.hasNewData$1 ? progress : progress.copy(0L);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan = x1;
                boolean bl = sparkPlan instanceof StateStoreWriter;
                return bl;
            }
            {
                this.hasNewData$1 = hasNewData$1;
            }
        });
    }

    private ExecutionStats extractExecutionStats(boolean hasNewData) {
        boolean hasEventTime = this.logicalPlan().collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                EventTimeWatermark eventTimeWatermark;
                A1 A1 = x1;
                Object object = A1 instanceof EventTimeWatermark ? (eventTimeWatermark = (EventTimeWatermark)A1) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                boolean bl = logicalPlan2 instanceof EventTimeWatermark;
                return bl;
            }
        }).nonEmpty();
        scala.collection.immutable.Map watermarkTimestamp = hasEventTime ? (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"watermark"), (Object)this.org$apache$spark$sql$execution$streaming$ProgressReporter$$formatTimestamp(this.offsetSeqMetadata().batchWatermarkMs()))})) : Predef$.MODULE$.Map().empty();
        Seq<StateOperatorProgress> stateOperators = this.extractStateOperatorMetrics(hasNewData);
        if (!hasNewData) {
            return new ExecutionStats(this, (scala.collection.immutable.Map<BaseStreamingSource, Object>)Predef$.MODULE$.Map().empty(), stateOperators, (scala.collection.immutable.Map<String, String>)watermarkTimestamp);
        }
        scala.collection.immutable.Map<BaseStreamingSource, Object> numInputRows = this.extractSourceToNumInputRows();
        scala.collection.immutable.Map eventTimeStats = ((MapLike)this.lastExecution().executedPlan().collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProgressReporter $outer;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                EventTimeWatermarkExec eventTimeWatermarkExec;
                A1 A1 = x2;
                if (A1 instanceof EventTimeWatermarkExec && (eventTimeWatermarkExec = (EventTimeWatermarkExec)A1).eventTimeStats().value().count() > 0L) {
                    EventTimeStats stats = eventTimeWatermarkExec.eventTimeStats().value();
                    object = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max"), (Object)BoxesRunTime.boxToLong((long)stats.max())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"min"), (Object)BoxesRunTime.boxToLong((long)stats.min())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"avg"), (Object)BoxesRunTime.boxToLong((long)((long)stats.avg())))}))).mapValues((Function1 & Serializable & scala.Serializable)millis -> $anonfun$2.$anonfun$applyOrElse$1(this, BoxesRunTime.unboxToLong((Object)millis)));
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x2) {
                EventTimeWatermarkExec eventTimeWatermarkExec;
                SparkPlan sparkPlan = x2;
                boolean bl = sparkPlan instanceof EventTimeWatermarkExec && (eventTimeWatermarkExec = (EventTimeWatermarkExec)sparkPlan).eventTimeStats().value().count() > 0L;
                return bl;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$1($anonfun$2 $this, long millis) {
                return $this.$outer.org$apache$spark$sql$execution$streaming$ProgressReporter$$formatTimestamp(millis);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.spark.sql.execution.streaming.ProgressReporter$$anonfun$2 java.lang.Object )}, serializedLambda);
            }
        }).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty())).$plus$plus((GenTraversableOnce)watermarkTimestamp);
        return new ExecutionStats(this, numInputRows, stateOperators, (scala.collection.immutable.Map<String, String>)eventTimeStats);
    }

    private scala.collection.immutable.Map<BaseStreamingSource, Object> extractSourceToNumInputRows() {
        scala.collection.immutable.Map map;
        Seq allStreamingLeaves = this.logicalPlan().collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                StreamingExecutionRelation streamingExecutionRelation;
                A1 A1 = x1;
                Object object = A1 instanceof StreamingExecutionRelation ? (streamingExecutionRelation = (StreamingExecutionRelation)A1) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                boolean bl = logicalPlan2 instanceof StreamingExecutionRelation;
                return bl;
            }
        });
        boolean onlyDataSourceV2Sources = allStreamingLeaves.forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ProgressReporter.$anonfun$extractSourceToNumInputRows$4(x$6)));
        if (onlyDataSourceV2Sources) {
            IdentityHashMap uniqueStreamingExecLeavesMap = new IdentityHashMap();
            this.lastExecution().executedPlan().collectLeaves().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DataSourceV2ScanExec dataSourceV2ScanExec;
                SparkPlan sparkPlan = x0$1;
                Object object = sparkPlan instanceof DataSourceV2ScanExec && (dataSourceV2ScanExec = (DataSourceV2ScanExec)sparkPlan).reader() instanceof BaseStreamingSource ? uniqueStreamingExecLeavesMap.put(dataSourceV2ScanExec, dataSourceV2ScanExec) : BoxedUnit.UNIT;
                return object;
            });
            Seq sourceToInputRowsTuples = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(uniqueStreamingExecLeavesMap.values()).asScala()).map((Function1 & Serializable & scala.Serializable)execLeaf -> {
                long numRows = BoxesRunTime.unboxToLong((Object)execLeaf.metrics().get((Object)"numOutputRows").map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.value())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                BaseStreamingSource source = (BaseStreamingSource)((Object)execLeaf.reader());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)source), (Object)BoxesRunTime.boxToLong((long)numRows));
            }, Iterable$.MODULE$.canBuildFrom())).toSeq();
            this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Source -> # input rows\n\t").append(sourceToInputRowsTuples.mkString("\n\t")).toString());
            map = ProgressReporter.sumRows$1(sourceToInputRowsTuples);
        } else {
            scala.collection.immutable.Map logicalPlanLeafToSource = (scala.collection.immutable.Map)this.newData().flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                BaseStreamingSource source = (BaseStreamingSource)tuple2._1();
                LogicalPlan logicalPlan2 = (LogicalPlan)tuple2._2();
                Seq seq = (Seq)logicalPlan2.collectLeaves().map((Function1 & Serializable & scala.Serializable)leaf -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(leaf), (Object)source), Seq$.MODULE$.canBuildFrom());
                return seq;
            }, Map$.MODULE$.canBuildFrom());
            Seq allLogicalPlanLeaves = this.lastExecution().logical().collectLeaves();
            Seq allExecPlanLeaves = this.lastExecution().executedPlan().collectLeaves();
            if (allLogicalPlanLeaves.size() == allExecPlanLeaves.size()) {
                Seq execLeafToSource = (Seq)((TraversableLike)allLogicalPlanLeaves.zip((GenIterable)allExecPlanLeaves, Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
                    Tuple2 tuple2 = x0$3;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    LogicalPlan lp = (LogicalPlan)tuple2._1();
                    SparkPlan ep = (SparkPlan)((Object)((Object)tuple2._2()));
                    Iterable iterable = Option$.MODULE$.option2Iterable(logicalPlanLeafToSource.get((Object)lp).map((Function1 & Serializable & scala.Serializable)source -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ep), source)));
                    return iterable;
                }, Seq$.MODULE$.canBuildFrom());
                Seq sourceToInputRowsTuples = (Seq)execLeafToSource.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                    Tuple2 tuple2 = x0$4;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    SparkPlan execLeaf = (SparkPlan)((Object)((Object)tuple2._1()));
                    BaseStreamingSource source = (BaseStreamingSource)tuple2._2();
                    long numRows = BoxesRunTime.unboxToLong((Object)execLeaf.metrics().get((Object)"numOutputRows").map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.value())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)source), (Object)BoxesRunTime.boxToLong((long)numRows));
                    return tuple22;
                }, Seq$.MODULE$.canBuildFrom());
                map = ProgressReporter.sumRows$1(sourceToInputRowsTuples);
            } else {
                if (!this.org$apache$spark$sql$execution$streaming$ProgressReporter$$metricWarningLogged()) {
                    this.logWarning((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(154).append("Could not report metrics as number leaves in trigger logical plan did not match that").append(" of the execution plan:\n").append("logical plan leaves: ").append(ProgressReporter.toString$1(allLogicalPlanLeaves)).append("\n").append("execution plan leaves: ").append(ProgressReporter.toString$1(allExecPlanLeaves)).append("\n").toString());
                    this.org$apache$spark$sql$execution$streaming$ProgressReporter$$metricWarningLogged_$eq(true);
                }
                map = Predef$.MODULE$.Map().empty();
            }
        }
        return map;
    }

    public static /* synthetic */ Object reportTimeTaken$(ProgressReporter $this, String triggerDetailKey, Function0 body) {
        return $this.reportTimeTaken(triggerDetailKey, body);
    }

    default public <T> T reportTimeTaken(String triggerDetailKey, Function0<T> body) {
        long startTime = this.triggerClock().getTimeMillis();
        Object result = body.apply();
        long endTime = this.triggerClock().getTimeMillis();
        long timeTaken = package$.MODULE$.max(endTime - startTime, 0L);
        long previousTime = BoxesRunTime.unboxToLong((Object)this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs().getOrElse((Object)triggerDetailKey, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs().put((Object)triggerDetailKey, (Object)BoxesRunTime.boxToLong((long)(previousTime + timeTaken)));
        this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(9).append(triggerDetailKey).append(" took ").append(timeTaken).append(" ms").toString());
        return (T)result;
    }

    public static /* synthetic */ String org$apache$spark$sql$execution$streaming$ProgressReporter$$formatTimestamp$(ProgressReporter $this, long millis) {
        return $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$formatTimestamp(millis);
    }

    default public String org$apache$spark$sql$execution$streaming$ProgressReporter$$formatTimestamp(long millis) {
        return this.org$apache$spark$sql$execution$streaming$ProgressReporter$$timestampFormat().format(new Date(millis));
    }

    public static /* synthetic */ void updateStatusMessage$(ProgressReporter $this, String message) {
        $this.updateStatusMessage(message);
    }

    default public void updateStatusMessage(String message) {
        StreamingQueryStatus qual$1 = this.currentStatus();
        String x$1 = message;
        boolean x$2 = qual$1.copy$default$2();
        boolean x$3 = qual$1.copy$default$3();
        this.currentStatus_$eq(qual$1.copy(x$1, x$2, x$3));
    }

    public static /* synthetic */ long $anonfun$extractSourceToNumInputRows$2(Seq x$4) {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)x$4.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5._2$mcJ$sp()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    private static scala.collection.immutable.Map sumRows$1(Seq tuples) {
        return tuples.groupBy((Function1 & Serializable & scala.Serializable)x$3 -> (BaseStreamingSource)x$3._1()).mapValues((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)ProgressReporter.$anonfun$extractSourceToNumInputRows$2(x$4)));
    }

    public static /* synthetic */ boolean $anonfun$extractSourceToNumInputRows$4(StreamingExecutionRelation x$6) {
        return x$6.source() instanceof MicroBatchReader;
    }

    private static String toString$1(Seq seq) {
        return new StringBuilder(11).append("(size = ").append(seq.size()).append("), ").append(seq.mkString(", ")).toString();
    }

    public static void $init$(ProgressReporter $this) {
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp_$eq(-1L);
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndTimestamp_$eq(-1L);
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp_$eq(-1L);
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs_$eq((scala.collection.mutable.HashMap<String, Object>)new scala.collection.mutable.HashMap());
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$metricWarningLogged_$eq(false);
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer_$eq((Queue<StreamingQueryProgress>)new Queue());
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$noDataProgressEventInterval_$eq($this.sparkSession().sessionState().conf().streamingNoDataProgressEventInterval());
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoDataProgressEventTime_$eq(Long.MIN_VALUE);
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$timestampFormat_$eq(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"));
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$timestampFormat().setTimeZone(DateTimeUtils$.MODULE$.getTimeZone("UTC"));
        $this.currentStatus_$eq(new StreamingQueryStatus("Initializing StreamExecution", false, false));
    }

    public class ExecutionStats
    implements Product,
    scala.Serializable {
        private final scala.collection.immutable.Map<BaseStreamingSource, Object> inputRows;
        private final Seq<StateOperatorProgress> stateOperators;
        private final scala.collection.immutable.Map<String, String> eventTimeStats;
        public final /* synthetic */ ProgressReporter $outer;

        public scala.collection.immutable.Map<BaseStreamingSource, Object> inputRows() {
            return this.inputRows;
        }

        public Seq<StateOperatorProgress> stateOperators() {
            return this.stateOperators;
        }

        public scala.collection.immutable.Map<String, String> eventTimeStats() {
            return this.eventTimeStats;
        }

        public ExecutionStats copy(scala.collection.immutable.Map<BaseStreamingSource, Object> inputRows, Seq<StateOperatorProgress> stateOperators, scala.collection.immutable.Map<String, String> eventTimeStats) {
            return new ExecutionStats(this.org$apache$spark$sql$execution$streaming$ProgressReporter$ExecutionStats$$$outer(), inputRows, stateOperators, eventTimeStats);
        }

        public scala.collection.immutable.Map<BaseStreamingSource, Object> copy$default$1() {
            return this.inputRows();
        }

        public Seq<StateOperatorProgress> copy$default$2() {
            return this.stateOperators();
        }

        public scala.collection.immutable.Map<String, String> copy$default$3() {
            return this.eventTimeStats();
        }

        public String productPrefix() {
            return "ExecutionStats";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.inputRows();
                    break;
                }
                case 1: {
                    object = this.stateOperators();
                    break;
                }
                case 2: {
                    object = this.eventTimeStats();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ExecutionStats;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ExecutionStats)) return false;
            if (((ExecutionStats)object).org$apache$spark$sql$execution$streaming$ProgressReporter$ExecutionStats$$$outer() != this.org$apache$spark$sql$execution$streaming$ProgressReporter$ExecutionStats$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ExecutionStats executionStats = (ExecutionStats)x$1;
            scala.collection.immutable.Map<BaseStreamingSource, Object> map = this.inputRows();
            scala.collection.immutable.Map<BaseStreamingSource, Object> map2 = executionStats.inputRows();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            Seq<StateOperatorProgress> seq = this.stateOperators();
            Seq<StateOperatorProgress> seq2 = executionStats.stateOperators();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            scala.collection.immutable.Map<String, String> map3 = this.eventTimeStats();
            scala.collection.immutable.Map<String, String> map4 = executionStats.eventTimeStats();
            if (map3 == null) {
                if (map4 != null) {
                    return false;
                }
            } else if (!map3.equals(map4)) return false;
            if (!executionStats.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ProgressReporter org$apache$spark$sql$execution$streaming$ProgressReporter$ExecutionStats$$$outer() {
            return this.$outer;
        }

        public ExecutionStats(ProgressReporter $outer, scala.collection.immutable.Map<BaseStreamingSource, Object> inputRows, Seq<StateOperatorProgress> stateOperators, scala.collection.immutable.Map<String, String> eventTimeStats) {
            this.inputRows = inputRows;
            this.stateOperators = stateOperators;
            this.eventTimeStats = eventTimeStats;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

