/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.json;

import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JSONOptionsInRead$;
import org.apache.spark.sql.catalyst.json.JacksonGenerator;
import org.apache.spark.sql.execution.datasources.CodecStreams$;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001y4A!\u0004\b\u0001;!A\u0001\u0006\u0001B\u0001B\u0003%\u0011\u0006\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u0011!q\u0004A!A!\u0002\u0013y\u0004\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\t\u000b9\u0003A\u0011A(\t\u000fY\u0003!\u0019!C\u0005/\"1!\r\u0001Q\u0001\naCqa\u0019\u0001C\u0002\u0013%A\r\u0003\u0004l\u0001\u0001\u0006I!\u001a\u0005\u0007Y\u0002\u0001\u000b\u0011B7\t\u000bA\u0004A\u0011I9\t\u000bq\u0004A\u0011I?\u0003!)\u001bxN\\(viB,Ho\u0016:ji\u0016\u0014(BA\b\u0011\u0003\u0011Q7o\u001c8\u000b\u0005E\u0011\u0012a\u00033bi\u0006\u001cx.\u001e:dKNT!a\u0005\u000b\u0002\u0013\u0015DXmY;uS>t'BA\u000b\u0017\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003/a\tQa\u001d9be.T!!\u0007\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0012aA8sO\u000e\u00011c\u0001\u0001\u001fEA\u0011q\u0004I\u0007\u0002!%\u0011\u0011\u0005\u0005\u0002\r\u001fV$\b/\u001e;Xe&$XM\u001d\t\u0003G\u0019j\u0011\u0001\n\u0006\u0003KY\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003O\u0011\u0012q\u0001T8hO&tw-\u0001\u0003qCRD\u0007C\u0001\u00164\u001d\tY\u0013\u0007\u0005\u0002-_5\tQF\u0003\u0002/9\u00051AH]8pizR\u0011\u0001M\u0001\u0006g\u000e\fG.Y\u0005\u0003e=\na\u0001\u0015:fI\u00164\u0017B\u0001\u001b6\u0005\u0019\u0019FO]5oO*\u0011!gL\u0001\b_B$\u0018n\u001c8t!\tAD(D\u0001:\u0015\ty!H\u0003\u0002<)\u0005A1-\u0019;bYf\u001cH/\u0003\u0002>s\tY!jU(O\u001fB$\u0018n\u001c8t\u0003)!\u0017\r^1TG\",W.\u0019\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005R\tQ\u0001^=qKNL!\u0001R!\u0003\u0015M#(/^2u)f\u0004X-A\u0004d_:$X\r\u001f;\u0011\u0005\u001dcU\"\u0001%\u000b\u0005%S\u0015!C7baJ,G-^2f\u0015\tY\u0005$\u0001\u0004iC\u0012|w\u000e]\u0005\u0003\u001b\"\u0013!\u0003V1tW\u0006#H/Z7qi\u000e{g\u000e^3yi\u00061A(\u001b8jiz\"R\u0001\u0015*T)V\u0003\"!\u0015\u0001\u000e\u00039AQ\u0001K\u0003A\u0002%BQAN\u0003A\u0002]BQAP\u0003A\u0002}BQ!R\u0003A\u0002\u0019\u000b\u0001\"\u001a8d_\u0012LgnZ\u000b\u00021B\u0011\u0011\fY\u0007\u00025*\u00111\fX\u0001\bG\"\f'o]3u\u0015\tif,A\u0002oS>T\u0011aX\u0001\u0005U\u00064\u0018-\u0003\u0002b5\n91\t[1sg\u0016$\u0018!C3oG>$\u0017N\\4!\u0003\u00199(/\u001b;feV\tQ\r\u0005\u0002gS6\tqM\u0003\u0002i=\u0006\u0011\u0011n\\\u0005\u0003U\u001e\u0014!cT;uaV$8\u000b\u001e:fC6<&/\u001b;fe\u00069qO]5uKJ\u0004\u0013aA4f]B\u0011\u0001H\\\u0005\u0003_f\u0012\u0001CS1dWN|gnR3oKJ\fGo\u001c:\u0002\u000b]\u0014\u0018\u000e^3\u0015\u0005I4\bCA:u\u001b\u0005y\u0013BA;0\u0005\u0011)f.\u001b;\t\u000b]\\\u0001\u0019\u0001=\u0002\u0007I|w\u000f\u0005\u0002zu6\t!(\u0003\u0002|u\tY\u0011J\u001c;fe:\fGNU8x\u0003\u0015\u0019Gn\\:f)\u0005\u0011\b")
public class JsonOutputWriter
extends OutputWriter
implements Logging {
    private final String path;
    private final Charset encoding;
    private final OutputStreamWriter writer;
    private final JacksonGenerator gen;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Charset encoding() {
        return this.encoding;
    }

    private OutputStreamWriter writer() {
        return this.writer;
    }

    @Override
    public void write(InternalRow row) {
        this.gen.write(row);
        this.gen.writeLineEnding();
    }

    @Override
    public void close() {
        this.gen.close();
        this.writer().close();
    }

    public JsonOutputWriter(String path, JSONOptions options, StructType dataSchema, TaskAttemptContext context) {
        Charset charset;
        this.path = path;
        Logging.$init$((Logging)this);
        Option option = options.encoding();
        if (option instanceof Some) {
            Some some = (Some)option;
            String charsetName = (String)some.value();
            charset = Charset.forName(charsetName);
        } else if (None$.MODULE$.equals(option)) {
            charset = StandardCharsets.UTF_8;
        } else {
            throw new MatchError((Object)option);
        }
        this.encoding = charset;
        if (JSONOptionsInRead$.MODULE$.blacklist().contains((Object)this.encoding())) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(107).append("The JSON file (").append($this.path).append(") was written in the encoding ").append(this.encoding().displayName()).append(" which can be read back by Spark only if multiLine is enabled.").toString());
        }
        this.writer = CodecStreams$.MODULE$.createOutputStreamWriter((JobContext)context, new Path(path), this.encoding());
        this.gen = new JacksonGenerator((DataType)dataSchema, (Writer)this.writer(), options);
    }
}

