/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.exchange;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.spark.SparkException;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.plans.logical.Statistics$;
import org.apache.spark.sql.catalyst.plans.physical.BroadcastMode;
import org.apache.spark.sql.catalyst.plans.physical.BroadcastPartitioning;
import org.apache.spark.sql.catalyst.plans.physical.Partitioning;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.exchange.BroadcastExchangeExec$;
import org.apache.spark.sql.execution.exchange.BroadcastExchangeLike;
import org.apache.spark.sql.execution.exchange.Exchange;
import org.apache.spark.sql.execution.joins.HashedRelation;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.metric.SQLMetrics$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.SparkFatalException;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.math.BigInt$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tEc\u0001B\u0015+\u0001^B\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!\u0013\u0005\t)\u0002\u0011\t\u0012)A\u0005\u0015\"AQ\u000b\u0001BK\u0002\u0013\u0005a\u000b\u0003\u0005\\\u0001\tE\t\u0015!\u0003X\u0011\u0015a\u0006\u0001\"\u0001^\u0011\u001d\t\u0007A1A\u0005B\tDaa\u001b\u0001!\u0002\u0013\u0019\u0007\u0002\u00037\u0001\u0011\u000b\u0007I\u0011I7\t\u000f\u0005\u0015\u0001\u0001\"\u0011\u0002\b!9\u0011q\u0002\u0001\u0005B\u0005E\u0001bBA\n\u0001\u0011\u0005\u0013Q\u0003\u0005\u000b\u0003G\u0001\u0001R1A\u0005\n\u0005\u0015\u0002BCA'\u0001!\u0015\r\u0011\"\u0011\u0002P!I\u0011\u0011\f\u0001C\u0002\u0013%\u00111\f\u0005\t\u0003G\u0002\u0001\u0015!\u0003\u0002^!Q\u0011q\r\u0001\t\u0006\u0004%\t%!\u001b\t\u000f\u0005U\u0004\u0001\"\u0015\u0002x!9\u0011q\u0010\u0001\u0005R\u0005\u0005\u0005\u0002CAL\u0001\u0011Ec&!'\t\u0013\u0005=\u0006!!A\u0005\u0002\u0005E\u0006\"CA\\\u0001E\u0005I\u0011AA]\u0011%\ty\rAI\u0001\n\u0003\t\t\u000eC\u0005\u0002V\u0002\t\t\u0011\"\u0011\u0002X\"I\u0011\u0011\u001c\u0001\u0002\u0002\u0013\u0005\u00111\u001c\u0005\n\u0003G\u0004\u0011\u0011!C\u0001\u0003KD\u0011\"a;\u0001\u0003\u0003%\t%!<\t\u0013\u0005]\b!!A\u0005\u0002\u0005e\b\"\u0003B\u0002\u0001\u0005\u0005I\u0011\tB\u0003\u000f\u001d\u0011IA\u000bE\u0001\u0005\u00171a!\u000b\u0016\t\u0002\t5\u0001B\u0002/\u001f\t\u0003\u0011)\u0002C\u0005\u0003\u0018y\u0011\r\u0011\"\u0001\u0002\\!A!\u0011\u0004\u0010!\u0002\u0013\ti\u0006C\u0005\u0003\u001cy\u0011\r\u0011\"\u0001\u0002\\!A!Q\u0004\u0010!\u0002\u0013\ti\u0006\u0003\u0006\u0003 y\u0011\r\u0011\"\u0001-\u0005CA\u0001B!\u000b\u001fA\u0003%!1\u0005\u0005\n\u0005Wq\u0012\u0011!CA\u0005[A\u0011Ba\r\u001f\u0003\u0003%\tI!\u000e\t\u0013\t\u001dc$!A\u0005\n\t%#!\u0006\"s_\u0006$7-Y:u\u000bb\u001c\u0007.\u00198hK\u0016CXm\u0019\u0006\u0003W1\n\u0001\"\u001a=dQ\u0006tw-\u001a\u0006\u0003[9\n\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005=\u0002\u0014aA:rY*\u0011\u0011GM\u0001\u0006gB\f'o\u001b\u0006\u0003gQ\na!\u00199bG\",'\"A\u001b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001ADhP#\u0011\u0005eRT\"\u0001\u0016\n\u0005mR#\u0001C#yG\"\fgnZ3\u0011\u0005ej\u0014B\u0001 +\u0005U\u0011%o\\1eG\u0006\u001cH/\u0012=dQ\u0006tw-\u001a'jW\u0016\u0004\"\u0001Q\"\u000e\u0003\u0005S\u0011AQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\t\u0006\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002A\r&\u0011q)\u0011\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0005[>$W-F\u0001K!\tY%+D\u0001M\u0015\tie*\u0001\u0005qQf\u001c\u0018nY1m\u0015\ty\u0005+A\u0003qY\u0006t7O\u0003\u0002R]\u0005A1-\u0019;bYf\u001cH/\u0003\u0002T\u0019\ni!I]8bI\u000e\f7\u000f^'pI\u0016\fQ!\\8eK\u0002\nQa\u00195jY\u0012,\u0012a\u0016\t\u00031fk\u0011\u0001L\u0005\u000352\u0012\u0011b\u00159be.\u0004F.\u00198\u0002\r\rD\u0017\u000e\u001c3!\u0003\u0019a\u0014N\\5u}Q\u0019al\u00181\u0011\u0005e\u0002\u0001\"\u0002%\u0006\u0001\u0004Q\u0005\"B+\u0006\u0001\u00049\u0016!\u0002:v]&#W#A2\u0011\u0005\u0011LW\"A3\u000b\u0005\u0019<\u0017\u0001B;uS2T\u0011\u0001[\u0001\u0005U\u00064\u0018-\u0003\u0002kK\n!Q+V%E\u0003\u0019\u0011XO\\%eA\u00059Q.\u001a;sS\u000e\u001cX#\u00018\u0011\t=$h\u000f`\u0007\u0002a*\u0011\u0011O]\u0001\nS6lW\u000f^1cY\u0016T!a]!\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002va\n\u0019Q*\u00199\u0011\u0005]TX\"\u0001=\u000b\u0005e<\u0017\u0001\u00027b]\u001eL!a\u001f=\u0003\rM#(/\u001b8h!\ri\u0018\u0011A\u0007\u0002}*\u0011q\u0010L\u0001\u0007[\u0016$(/[2\n\u0007\u0005\raPA\u0005T#2kU\r\u001e:jG\u0006\u0011r.\u001e;qkR\u0004\u0016M\u001d;ji&|g.\u001b8h+\t\tI\u0001E\u0002L\u0003\u0017I1!!\u0004M\u00051\u0001\u0016M\u001d;ji&|g.\u001b8h\u00039!wnQ1o_:L7-\u00197ju\u0016$\u0012aV\u0001\u0012eVtG/[7f'R\fG/[:uS\u000e\u001cXCAA\f!\u0011\tI\"a\b\u000e\u0005\u0005m!bAA\u000f\u001d\u00069An\\4jG\u0006d\u0017\u0002BA\u0011\u00037\u0011!b\u0015;bi&\u001cH/[2t\u0003\u001d\u0001(o\\7jg\u0016,\"!a\n\u0011\r\u0005%\u0012qFA\u001a\u001b\t\tYCC\u0002\u0002.\u0005\u000b!bY8oGV\u0014(/\u001a8u\u0013\u0011\t\t$a\u000b\u0003\u000fA\u0013x.\\5tKB1\u0011QGA\u001e\u0003\u007fi!!a\u000e\u000b\u0007\u0005e\u0002'A\u0005ce>\fGmY1ti&!\u0011QHA\u001c\u0005%\u0011%o\\1eG\u0006\u001cH\u000fE\u0002A\u0003\u0003J1!a\u0011B\u0005\r\te.\u001f\u0015\u0004\u0019\u0005\u001d\u0003c\u0001!\u0002J%\u0019\u00111J!\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018\u0001E2p[BdW\r^5p]\u001a+H/\u001e:f+\t\t\t\u0006\u0005\u0004\u0002*\u0005M\u00131G\u0005\u0005\u0003+\nYC\u0001\u0004GkR,(/\u001a\u0015\u0004\u001b\u0005\u001d\u0013a\u0002;j[\u0016|W\u000f^\u000b\u0003\u0003;\u00022\u0001QA0\u0013\r\t\t'\u0011\u0002\u0005\u0019>tw-\u0001\u0005uS6,w.\u001e;!Q\ry\u0011qI\u0001\u000fe\u0016d\u0017\r^5p]\u001a+H/\u001e:f+\t\tY\u0007\u0005\u0004\u0002n\u0005E\u00141G\u0007\u0003\u0003_R1!!\ff\u0013\u0011\t)&a\u001c)\u0007A\t9%A\u0005e_B\u0013X\r]1sKR\u0011\u0011\u0011\u0010\t\u0004\u0001\u0006m\u0014bAA?\u0003\n!QK\\5u\u0003%!w.\u0012=fGV$X\r\u0006\u0002\u0002\u0004B1\u0011QQAF\u0003\u001fk!!a\"\u000b\u0007\u0005%\u0005'A\u0002sI\u0012LA!!$\u0002\b\n\u0019!\u000b\u0012#\u0011\t\u0005E\u00151S\u0007\u0002!&\u0019\u0011Q\u0013)\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\u0013I>,\u00050Z2vi\u0016\u0014%o\\1eG\u0006\u001cH/\u0006\u0003\u0002\u001c\u0006\rFCAAO!\u0019\t)$a\u000f\u0002 B!\u0011\u0011UAR\u0019\u0001!q!!*\u0014\u0005\u0004\t9KA\u0001U#\u0011\tI+a\u0010\u0011\u0007\u0001\u000bY+C\u0002\u0002.\u0006\u0013qAT8uQ&tw-\u0001\u0003d_BLH#\u00020\u00024\u0006U\u0006b\u0002%\u0015!\u0003\u0005\rA\u0013\u0005\b+R\u0001\n\u00111\u0001X\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a/+\u0007)\u000bil\u000b\u0002\u0002@B!\u0011\u0011YAf\u001b\t\t\u0019M\u0003\u0003\u0002F\u0006\u001d\u0017!C;oG\",7m[3e\u0015\r\tI-Q\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAg\u0003\u0007\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a5+\u0007]\u000bi,A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0002m\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u001c\t\u0004\u0001\u0006}\u0017bAAq\u0003\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011qHAt\u0011%\tI/GA\u0001\u0002\u0004\ti.A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003_\u0004b!!=\u0002t\u0006}R\"\u0001:\n\u0007\u0005U(O\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA~\u0005\u0003\u00012\u0001QA\u007f\u0013\r\ty0\u0011\u0002\b\u0005>|G.Z1o\u0011%\tIoGA\u0001\u0002\u0004\ty$\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003w\u00149\u0001C\u0005\u0002jr\t\t\u00111\u0001\u0002@\u0005)\"I]8bI\u000e\f7\u000f^#yG\"\fgnZ3Fq\u0016\u001c\u0007CA\u001d\u001f'\u0011q\"qB#\u0011\u0007\u0001\u0013\t\"C\u0002\u0003\u0014\u0005\u0013a!\u00118z%\u00164GC\u0001B\u0006\u0003ai\u0015\tW0C%>\u000bEiQ!T)~#\u0016I\u0011'F?J{ukU\u0001\u001a\u001b\u0006CvL\u0011*P\u0003\u0012\u001b\u0015i\u0015+`)\u0006\u0013E*R0S\u001f^\u001b\u0006%A\rN\u0003b{&IU(B\t\u000e\u000b5\u000bV0U\u0003\ncUi\u0018\"Z)\u0016\u001b\u0016AG'B1~\u0013%kT!E\u0007\u0006\u001bFk\u0018+B\u00052+uLQ-U\u000bN\u0003\u0013\u0001E3yK\u000e,H/[8o\u0007>tG/\u001a=u+\t\u0011\u0019\u0003\u0005\u0003\u0002*\t\u0015\u0012\u0002\u0002B\u0014\u0003W\u0011q$\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0003E)\u00070Z2vi&|gnQ8oi\u0016DH\u000fI\u0001\u0006CB\u0004H.\u001f\u000b\u0006=\n=\"\u0011\u0007\u0005\u0006\u0011\u001a\u0002\rA\u0013\u0005\u0006+\u001a\u0002\raV\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u00119Da\u0011\u0011\u000b\u0001\u0013ID!\u0010\n\u0007\tm\u0012I\u0001\u0004PaRLwN\u001c\t\u0006\u0001\n}\"jV\u0005\u0004\u0005\u0003\n%A\u0002+va2,'\u0007\u0003\u0005\u0003F\u001d\n\t\u00111\u0001_\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003LA\u0019qO!\u0014\n\u0007\t=\u0003P\u0001\u0004PE*,7\r\u001e")
public class BroadcastExchangeExec
extends Exchange
implements BroadcastExchangeLike {
    private Map<String, SQLMetric> metrics;
    private transient Promise<Broadcast<Object>> promise;
    private transient scala.concurrent.Future<Broadcast<Object>> completionFuture;
    private transient Future<Broadcast<Object>> relationFuture;
    private final BroadcastMode mode;
    private final SparkPlan child;
    private final UUID runId;
    private final transient long timeout;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<BroadcastMode, SparkPlan>> unapply(BroadcastExchangeExec broadcastExchangeExec) {
        return BroadcastExchangeExec$.MODULE$.unapply(broadcastExchangeExec);
    }

    public static long MAX_BROADCAST_TABLE_BYTES() {
        return BroadcastExchangeExec$.MODULE$.MAX_BROADCAST_TABLE_BYTES();
    }

    public static long MAX_BROADCAST_TABLE_ROWS() {
        return BroadcastExchangeExec$.MODULE$.MAX_BROADCAST_TABLE_ROWS();
    }

    public BroadcastMode mode() {
        return this.mode;
    }

    @Override
    public SparkPlan child() {
        return this.child;
    }

    @Override
    public UUID runId() {
        return this.runId;
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        BroadcastExchangeExec broadcastExchangeExec = this;
        synchronized (broadcastExchangeExec) {
            if (!this.bitmap$0) {
                this.metrics = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataSize"), (Object)SQLMetrics$.MODULE$.createSizeMetric(this.sparkContext(), "data size")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"collectTime"), (Object)SQLMetrics$.MODULE$.createTimingMetric(this.sparkContext(), "time to collect")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"buildTime"), (Object)SQLMetrics$.MODULE$.createTimingMetric(this.sparkContext(), "time to build")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broadcastTime"), (Object)SQLMetrics$.MODULE$.createTimingMetric(this.sparkContext(), "time to broadcast"))}));
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    @Override
    public Partitioning outputPartitioning() {
        return new BroadcastPartitioning(this.mode());
    }

    public SparkPlan doCanonicalize() {
        return new BroadcastExchangeExec(this.mode().canonicalized(), (SparkPlan)this.child().canonicalized());
    }

    @Override
    public Statistics runtimeStatistics() {
        long dataSize = ((SQLMetric)((Object)this.metrics().apply((Object)"dataSize"))).value();
        return new Statistics(BigInt$.MODULE$.long2bigInt(dataSize), Statistics$.MODULE$.apply$default$2(), Statistics$.MODULE$.apply$default$3());
    }

    private Promise<Broadcast<Object>> promise$lzycompute() {
        BroadcastExchangeExec broadcastExchangeExec = this;
        synchronized (broadcastExchangeExec) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.promise = Promise$.MODULE$.apply();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.promise;
    }

    private Promise<Broadcast<Object>> promise() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.promise$lzycompute() : this.promise;
    }

    private scala.concurrent.Future<Broadcast<Object>> completionFuture$lzycompute() {
        BroadcastExchangeExec broadcastExchangeExec = this;
        synchronized (broadcastExchangeExec) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.completionFuture = this.promise().future();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.completionFuture;
    }

    @Override
    public scala.concurrent.Future<Broadcast<Object>> completionFuture() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.completionFuture$lzycompute() : this.completionFuture;
    }

    private long timeout() {
        return this.timeout;
    }

    private Future<Broadcast<Object>> relationFuture$lzycompute() {
        BroadcastExchangeExec broadcastExchangeExec = this;
        synchronized (broadcastExchangeExec) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.relationFuture = SQLExecution$.MODULE$.withThreadLocalCaptured(this.sqlContext().sparkSession(), (ExecutorService)BroadcastExchangeExec$.MODULE$.executionContext(), (Function0 & Serializable & scala.Serializable)() -> {
                    Broadcast broadcast;
                    try {
                        long l;
                        Object relation;
                        this.sparkContext().setJobGroup(this.runId().toString(), new StringBuilder(27).append("broadcast exchange (runId ").append(this.runId()).append(")").toString(), true);
                        long beforeCollect = System.nanoTime();
                        Tuple2<Object, Iterator<InternalRow>> tuple2 = this.child().executeCollectIterator();
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        long numRows = tuple2._1$mcJ$sp();
                        Iterator input = (Iterator)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)numRows), (Object)input);
                        Tuple2 tuple23 = tuple22;
                        long numRows2 = tuple23._1$mcJ$sp();
                        Iterator input2 = (Iterator)tuple23._2();
                        if (numRows2 >= BroadcastExchangeExec$.MODULE$.MAX_BROADCAST_TABLE_ROWS()) {
                            throw new SparkException(new StringBuilder(44).append("Cannot broadcast the table over ").append(BroadcastExchangeExec$.MODULE$.MAX_BROADCAST_TABLE_ROWS()).append(" rows: ").append(numRows2).append(" rows").toString());
                        }
                        long beforeBuild = System.nanoTime();
                        this.longMetric("collectTime").$plus$eq(TimeUnit.NANOSECONDS.toMillis(beforeBuild - beforeCollect));
                        Object object = relation = this.mode().transform(input2, (Option)new Some((Object)BoxesRunTime.boxToLong((long)numRows2)));
                        if (object instanceof HashedRelation) {
                            HashedRelation hashedRelation = (HashedRelation)object;
                            l = hashedRelation.estimatedSize();
                        } else if (object instanceof InternalRow[]) {
                            InternalRow[] internalRowArray = (InternalRow[])object;
                            l = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])internalRowArray)).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)BroadcastExchangeExec.$anonfun$relationFuture$2(x$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                        } else {
                            throw new SparkException(new StringBuilder(56).append("[BUG] BroadcastMode.transform returned unexpected ").append("type: ").append(relation.getClass().getName()).toString());
                        }
                        long dataSize = l;
                        this.longMetric("dataSize").$plus$eq(dataSize);
                        if (dataSize >= BroadcastExchangeExec$.MODULE$.MAX_BROADCAST_TABLE_BYTES()) {
                            throw new SparkException(new StringBuilder(55).append("Cannot broadcast the table that is larger than 8GB: ").append(dataSize >> 30).append(" GB").toString());
                        }
                        long beforeBroadcast = System.nanoTime();
                        this.longMetric("buildTime").$plus$eq(TimeUnit.NANOSECONDS.toMillis(beforeBroadcast - beforeBuild));
                        Broadcast broadcasted = this.sparkContext().broadcast(relation, ClassTag$.MODULE$.Any());
                        this.longMetric("broadcastTime").$plus$eq(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - beforeBroadcast));
                        String executionId = this.sparkContext().getLocalProperty(SQLExecution$.MODULE$.EXECUTION_ID_KEY());
                        SQLMetrics$.MODULE$.postDriverMetricUpdates(this.sparkContext(), executionId, (Seq<SQLMetric>)this.metrics().values().toSeq());
                        this.promise().trySuccess((Object)broadcasted);
                        broadcast = broadcasted;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (throwable2 instanceof OutOfMemoryError) {
                            OutOfMemoryError outOfMemoryError = (OutOfMemoryError)throwable2;
                            SparkFatalException ex = new SparkFatalException(new OutOfMemoryError(new StringBuilder(225).append("Not enough memory to build and broadcast the table to all worker nodes. As a workaround, you can either disable broadcast by setting ").append(SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key()).append(" to -1 or increase the spark ").append("driver memory by setting ").append("spark.driver.memory").append(" to a higher value.").toString()).initCause(outOfMemoryError.getCause()));
                            this.promise().tryFailure((Throwable)ex);
                            throw ex;
                        }
                        if (!NonFatal$.MODULE$.apply(throwable2)) {
                            SparkFatalException ex = new SparkFatalException(throwable2);
                            this.promise().tryFailure((Throwable)ex);
                            throw ex;
                        }
                        if (throwable2 != null) {
                            Throwable throwable3 = throwable2;
                            this.promise().tryFailure(throwable3);
                            throw throwable3;
                        }
                        throw throwable;
                    }
                    return broadcast;
                });
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.relationFuture;
    }

    @Override
    public Future<Broadcast<Object>> relationFuture() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.relationFuture$lzycompute() : this.relationFuture;
    }

    @Override
    public void doPrepare() {
        this.relationFuture();
    }

    @Override
    public RDD<InternalRow> doExecute() {
        throw new UnsupportedOperationException("BroadcastExchange does not support the execute() code path.");
    }

    @Override
    public <T> Broadcast<T> doExecuteBroadcast() {
        Broadcast<Object> broadcast;
        try {
            broadcast = this.relationFuture().get(this.timeout(), TimeUnit.SECONDS);
        }
        catch (TimeoutException ex) {
            Object object;
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Could not execute broadcast in ").append(this.timeout()).append(" secs.").toString(), ex);
            if (!this.relationFuture().isDone()) {
                this.sparkContext().cancelJobGroup(this.runId().toString());
                object = BoxesRunTime.boxToBoolean((boolean)this.relationFuture().cancel(true));
            } else {
                object = BoxedUnit.UNIT;
            }
            throw new SparkException(new StringBuilder(130).append("Could not execute broadcast in ").append(this.timeout()).append(" secs. ").append("You can increase the timeout for broadcasts via ").append(SQLConf$.MODULE$.BROADCAST_TIMEOUT().key()).append(" or ").append("disable broadcast join by setting ").append(SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key()).append(" to -1").toString(), (Throwable)ex);
        }
        return broadcast;
    }

    public BroadcastExchangeExec copy(BroadcastMode mode, SparkPlan child) {
        return new BroadcastExchangeExec(mode, child);
    }

    public BroadcastMode copy$default$1() {
        return this.mode();
    }

    public SparkPlan copy$default$2() {
        return this.child();
    }

    public String productPrefix() {
        return "BroadcastExchangeExec";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.mode();
                break;
            }
            case 1: {
                object = this.child();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BroadcastExchangeExec;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BroadcastExchangeExec)) return false;
        boolean bl = true;
        if (!bl) return false;
        BroadcastExchangeExec broadcastExchangeExec = (BroadcastExchangeExec)x$1;
        BroadcastMode broadcastMode = this.mode();
        BroadcastMode broadcastMode2 = broadcastExchangeExec.mode();
        if (broadcastMode == null) {
            if (broadcastMode2 != null) {
                return false;
            }
        } else if (!broadcastMode.equals(broadcastMode2)) return false;
        SparkPlan sparkPlan = this.child();
        SparkPlan sparkPlan2 = broadcastExchangeExec.child();
        if (sparkPlan == null) {
            if (sparkPlan2 != null) {
                return false;
            }
        } else if (!((Object)((Object)sparkPlan)).equals((Object)sparkPlan2)) return false;
        if (!broadcastExchangeExec.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ long $anonfun$relationFuture$2(InternalRow x$2) {
        return ((UnsafeRow)x$2).getSizeInBytes();
    }

    public BroadcastExchangeExec(BroadcastMode mode, SparkPlan child) {
        this.mode = mode;
        this.child = child;
        BroadcastExchangeLike.$init$(this);
        this.runId = UUID.randomUUID();
        this.timeout = SQLConf$.MODULE$.get().broadcastTimeout();
    }
}

