/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.execution.command.AlterTableAddColumnsCommand$;
import org.apache.spark.sql.execution.command.CommandUtils$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.csv.CSVFileFormat;
import org.apache.spark.sql.execution.datasources.json.JsonFileFormat;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.execution.datasources.v2.csv.CSVDataSourceV2;
import org.apache.spark.sql.execution.datasources.v2.json.JsonDataSourceV2;
import org.apache.spark.sql.execution.datasources.v2.orc.OrcDataSourceV2;
import org.apache.spark.sql.execution.datasources.v2.parquet.ParquetDataSourceV2;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.util.SchemaUtils$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005Mf\u0001\u0002\r\u001a\u0001\u001aB\u0001B\u0010\u0001\u0003\u0016\u0004%\ta\u0010\u0005\t\t\u0002\u0011\t\u0012)A\u0005\u0001\"AQ\t\u0001BK\u0002\u0013\u0005a\t\u0003\u0005Z\u0001\tE\t\u0015!\u0003H\u0011\u0015Q\u0006\u0001\"\u0001\\\u0011\u0015y\u0006\u0001\"\u0011a\u0011\u0015Y\u0007\u0001\"\u0003m\u0011%\t\t\u0001AA\u0001\n\u0003\t\u0019\u0001C\u0005\u0002\n\u0001\t\n\u0011\"\u0001\u0002\f!I\u0011\u0011\u0005\u0001\u0012\u0002\u0013\u0005\u00111\u0005\u0005\n\u0003O\u0001\u0011\u0011!C!\u0003SA\u0011\"a\u000f\u0001\u0003\u0003%\t!!\u0010\t\u0013\u0005\u0015\u0003!!A\u0005\u0002\u0005\u001d\u0003\"CA*\u0001\u0005\u0005I\u0011IA+\u0011%\t\u0019\u0007AA\u0001\n\u0003\t)\u0007C\u0005\u0002p\u0001\t\t\u0011\"\u0011\u0002r\u001dI\u0011QO\r\u0002\u0002#\u0005\u0011q\u000f\u0004\t1e\t\t\u0011#\u0001\u0002z!1!L\u0005C\u0001\u0003\u000fC\u0011\"!#\u0013\u0003\u0003%)%a#\t\u0013\u00055%#!A\u0005\u0002\u0006=\u0005\"CAK%\u0005\u0005I\u0011QAL\u0011%\tIKEA\u0001\n\u0013\tYKA\u000eBYR,'\u000fV1cY\u0016\fE\rZ\"pYVlgn]\"p[6\fg\u000e\u001a\u0006\u00035m\tqaY8n[\u0006tGM\u0003\u0002\u001d;\u0005IQ\r_3dkRLwN\u001c\u0006\u0003=}\t1a]9m\u0015\t\u0001\u0013%A\u0003ta\u0006\u00148N\u0003\u0002#G\u00051\u0011\r]1dQ\u0016T\u0011\u0001J\u0001\u0004_J<7\u0001A\n\u0006\u0001\u001d\nTg\u000f\t\u0003Q=j\u0011!\u000b\u0006\u0003U-\nq\u0001\\8hS\u000e\fGN\u0003\u0002-[\u0005)\u0001\u000f\\1og*\u0011a&H\u0001\tG\u0006$\u0018\r\\=ti&\u0011\u0001'\u000b\u0002\f\u0019><\u0017nY1m!2\fg\u000e\u0005\u00023g5\t\u0011$\u0003\u000253\ty!+\u001e8oC\ndWmQ8n[\u0006tG\r\u0005\u00027s5\tqGC\u00019\u0003\u0015\u00198-\u00197b\u0013\tQtGA\u0004Qe>$Wo\u0019;\u0011\u0005Yb\u0014BA\u001f8\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0015!\u0018M\u00197f+\u0005\u0001\u0005CA!C\u001b\u0005i\u0013BA\".\u0005=!\u0016M\u00197f\u0013\u0012,g\u000e^5gS\u0016\u0014\u0018A\u0002;bE2,\u0007%A\u0005d_2\u001cHk\\!eIV\tq\tE\u0002I!Ns!!\u0013(\u000f\u0005)kU\"A&\u000b\u00051+\u0013A\u0002\u001fs_>$h(C\u00019\u0013\tyu'A\u0004qC\u000e\\\u0017mZ3\n\u0005E\u0013&aA*fc*\u0011qj\u000e\t\u0003)^k\u0011!\u0016\u0006\u0003-v\tQ\u0001^=qKNL!\u0001W+\u0003\u0017M#(/^2u\r&,G\u000eZ\u0001\u000bG>d7\u000fV8BI\u0012\u0004\u0013A\u0002\u001fj]&$h\bF\u0002];z\u0003\"A\r\u0001\t\u000by*\u0001\u0019\u0001!\t\u000b\u0015+\u0001\u0019A$\u0002\u0007I,h\u000e\u0006\u0002bMB\u0019\u0001\n\u00152\u0011\u0005\r$W\"A\u000f\n\u0005\u0015l\"a\u0001*po\")qM\u0002a\u0001Q\u0006a1\u000f]1sWN+7o]5p]B\u00111-[\u0005\u0003Uv\u0011Ab\u00159be.\u001cVm]:j_:\f\u0011D^3sS\u001aL\u0018\t\u001c;feR\u000b'\r\\3BI\u0012\u001cu\u000e\\;n]R!Qn]>\u0000!\tq\u0017/D\u0001p\u0015\t\u0001X&A\u0004dCR\fGn\\4\n\u0005I|'\u0001D\"bi\u0006dwn\u001a+bE2,\u0007\"\u0002;\b\u0001\u0004)\u0018\u0001B2p]\u001a\u0004\"A^=\u000e\u0003]T!\u0001_\u000f\u0002\u0011%tG/\u001a:oC2L!A_<\u0003\u000fM\u000bFjQ8oM\")\u0001o\u0002a\u0001yB\u0011a.`\u0005\u0003}>\u0014abU3tg&|gnQ1uC2|w\rC\u0003?\u000f\u0001\u0007\u0001)\u0001\u0003d_BLH#\u0002/\u0002\u0006\u0005\u001d\u0001b\u0002 \t!\u0003\u0005\r\u0001\u0011\u0005\b\u000b\"\u0001\n\u00111\u0001H\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\u0004+\u0007\u0001\u000bya\u000b\u0002\u0002\u0012A!\u00111CA\u000f\u001b\t\t)B\u0003\u0003\u0002\u0018\u0005e\u0011!C;oG\",7m[3e\u0015\r\tYbN\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0010\u0003+\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!\n+\u0007\u001d\u000by!A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003W\u0001B!!\f\u000285\u0011\u0011q\u0006\u0006\u0005\u0003c\t\u0019$\u0001\u0003mC:<'BAA\u001b\u0003\u0011Q\u0017M^1\n\t\u0005e\u0012q\u0006\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005}\u0002c\u0001\u001c\u0002B%\u0019\u00111I\u001c\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005%\u0013q\n\t\u0004m\u0005-\u0013bAA'o\t\u0019\u0011I\\=\t\u0013\u0005ES\"!AA\u0002\u0005}\u0012a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002XA1\u0011\u0011LA0\u0003\u0013j!!a\u0017\u000b\u0007\u0005us'\u0001\u0006d_2dWm\u0019;j_:LA!!\u0019\u0002\\\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t9'!\u001c\u0011\u0007Y\nI'C\u0002\u0002l]\u0012qAQ8pY\u0016\fg\u000eC\u0005\u0002R=\t\t\u00111\u0001\u0002J\u00051Q-];bYN$B!a\u001a\u0002t!I\u0011\u0011\u000b\t\u0002\u0002\u0003\u0007\u0011\u0011J\u0001\u001c\u00032$XM\u001d+bE2,\u0017\t\u001a3D_2,XN\\:D_6l\u0017M\u001c3\u0011\u0005I\u00122\u0003\u0002\n\u0002|m\u0002r!! \u0002\u0004\u0002;E,\u0004\u0002\u0002\u0000)\u0019\u0011\u0011Q\u001c\u0002\u000fI,h\u000e^5nK&!\u0011QQA@\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0003o\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003W\tQ!\u00199qYf$R\u0001XAI\u0003'CQAP\u000bA\u0002\u0001CQ!R\u000bA\u0002\u001d\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\u001a\u0006\u0015\u0006#\u0002\u001c\u0002\u001c\u0006}\u0015bAAOo\t1q\n\u001d;j_:\u0004RANAQ\u0001\u001eK1!a)8\u0005\u0019!V\u000f\u001d7fe!A\u0011q\u0015\f\u0002\u0002\u0003\u0007A,A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u0016\t\u0005\u0003[\ty+\u0003\u0003\u00022\u0006=\"AB(cU\u0016\u001cG\u000f")
public class AlterTableAddColumnsCommand
extends LogicalPlan
implements RunnableCommand,
scala.Serializable {
    private final TableIdentifier table;
    private final Seq<StructField> colsToAdd;
    private Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<TableIdentifier, Seq<StructField>>> unapply(AlterTableAddColumnsCommand alterTableAddColumnsCommand) {
        return AlterTableAddColumnsCommand$.MODULE$.unapply(alterTableAddColumnsCommand);
    }

    public static Function1<Tuple2<TableIdentifier, Seq<StructField>>, AlterTableAddColumnsCommand> tupled() {
        return AlterTableAddColumnsCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Seq<StructField>, AlterTableAddColumnsCommand>> curried() {
        return AlterTableAddColumnsCommand$.MODULE$.curried();
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.children$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        AlterTableAddColumnsCommand alterTableAddColumnsCommand = this;
        synchronized (alterTableAddColumnsCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public TableIdentifier table() {
        return this.table;
    }

    public Seq<StructField> colsToAdd() {
        return this.colsToAdd;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        CatalogTable catalogTable = this.verifyAlterTableAddColumn(sparkSession.sessionState().conf(), catalog, this.table());
        CommandUtils$.MODULE$.uncacheTableOrView(sparkSession, this.table().quotedString());
        catalog.refreshTable(this.table());
        SchemaUtils$.MODULE$.checkColumnNameDuplication((Seq)((TraversableLike)this.colsToAdd().$plus$plus((GenTraversableOnce)catalogTable.schema(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name(), Seq$.MODULE$.canBuildFrom()), new StringBuilder(27).append("in the table definition of ").append(this.table().identifier()).toString(), this.conf().caseSensitiveAnalysis());
        DDLUtils$.MODULE$.checkDataColNames(catalogTable, (Seq<String>)((Seq)this.colsToAdd().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.name(), Seq$.MODULE$.canBuildFrom())));
        catalog.alterTableDataSchema(this.table(), StructType$.MODULE$.apply((Seq)catalogTable.dataSchema().$plus$plus(this.colsToAdd(), Seq$.MODULE$.canBuildFrom())));
        return (Seq)Seq$.MODULE$.empty();
    }

    private CatalogTable verifyAlterTableAddColumn(SQLConf conf, SessionCatalog catalog, TableIdentifier table) {
        CatalogTable catalogTable = catalog.getTempViewOrPermanentTableMetadata(table);
        CatalogTableType catalogTableType = catalogTable.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
            throw new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(148).append("\n          |ALTER ADD COLUMNS does not support views.\n          |You must drop and re-create the views for adding the new columns. Views: ").append(table).append("\n         ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (DDLUtils$.MODULE$.isDatasourceTable(catalogTable)) {
            Object obj = DataSource$.MODULE$.lookupDataSource((String)catalogTable.provider().get(), conf).getConstructor(new Class[0]).newInstance(new Object[0]);
            boolean bl = obj instanceof CSVFileFormat ? true : (obj instanceof JsonFileFormat ? true : obj instanceof ParquetFileFormat);
            if (bl) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                boolean bl2 = obj instanceof JsonDataSourceV2 ? true : (obj instanceof CSVDataSourceV2 ? true : (obj instanceof OrcDataSourceV2 ? true : obj instanceof ParquetDataSourceV2));
                if (bl2) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (obj.getClass().getCanonicalName().endsWith("OrcFileFormat")) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(183).append("\n              |ALTER ADD COLUMNS does not support datasource table with type ").append(obj).append(".\n              |You must drop and re-create the table for adding the new columns. Tables: ").append(table).append("\n             ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
            }
        }
        return catalogTable;
    }

    public AlterTableAddColumnsCommand copy(TableIdentifier table, Seq<StructField> colsToAdd) {
        return new AlterTableAddColumnsCommand(table, colsToAdd);
    }

    public TableIdentifier copy$default$1() {
        return this.table();
    }

    public Seq<StructField> copy$default$2() {
        return this.colsToAdd();
    }

    public String productPrefix() {
        return "AlterTableAddColumnsCommand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Seq<StructField> seq;
        int n = x$1;
        switch (n) {
            case 0: {
                seq = this.table();
                break;
            }
            case 1: {
                seq = this.colsToAdd();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return seq;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterTableAddColumnsCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterTableAddColumnsCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterTableAddColumnsCommand alterTableAddColumnsCommand = (AlterTableAddColumnsCommand)x$1;
        TableIdentifier tableIdentifier = this.table();
        TableIdentifier tableIdentifier2 = alterTableAddColumnsCommand.table();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Seq<StructField> seq = this.colsToAdd();
        Seq<StructField> seq2 = alterTableAddColumnsCommand.colsToAdd();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!alterTableAddColumnsCommand.canEqual(this)) return false;
        return true;
    }

    public AlterTableAddColumnsCommand(TableIdentifier table, Seq<StructField> colsToAdd) {
        this.table = table;
        this.colsToAdd = colsToAdd;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
    }
}

