/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.UnresolvedFunction;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.View;
import org.apache.spark.sql.catalyst.plans.logical.With;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.SchemaUtils$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ViewHelper$ {
    public static ViewHelper$ MODULE$;
    private final Seq<String> configPrefixDenyList;

    static {
        new ViewHelper$();
    }

    private Seq<String> configPrefixDenyList() {
        return this.configPrefixDenyList;
    }

    private boolean shouldCaptureConfig(String key) {
        return !this.configPrefixDenyList().exists((Function1 & Serializable & scala.Serializable)prefix -> BoxesRunTime.boxToBoolean((boolean)key.startsWith(prefix)));
    }

    private Map<String, String> generateQueryColumnNames(Seq<String> columns) {
        HashMap props;
        block0: {
            props = new HashMap();
            if (!columns.nonEmpty()) break block0;
            props.put((Object)CatalogTable$.MODULE$.VIEW_QUERY_OUTPUT_NUM_COLUMNS(), (Object)((Object)BoxesRunTime.boxToInteger((int)columns.length())).toString());
            ((IterableLike)columns.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String colName = (String)tuple2._1();
                int index = tuple2._2$mcI$sp();
                Option option = props.put((Object)new StringBuilder(0).append(CatalogTable$.MODULE$.VIEW_QUERY_OUTPUT_COLUMN_NAME_PREFIX()).append(index).toString(), (Object)colName);
                return option;
            });
        }
        return props.toMap(Predef$.MODULE$.$conforms());
    }

    private Map<String, String> removeQueryColumnNames(Map<String, String> properties) {
        return (Map)properties.filterNot((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ViewHelper$.$anonfun$removeQueryColumnNames$1(x0$1)));
    }

    private Map<String, String> sqlConfigsToProps(SQLConf conf) {
        Map modifiedConfs = (Map)conf.getAllConfs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ViewHelper$.$anonfun$sqlConfigsToProps$1(conf, x0$1)));
        HashMap props = new HashMap();
        modifiedConfs.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ViewHelper$.$anonfun$sqlConfigsToProps$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            Tuple2 tuple2 = x$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            Option option = props.put((Object)new StringBuilder(0).append(CatalogTable$.MODULE$.VIEW_SQL_CONFIG_PREFIX()).append(key).toString(), (Object)value);
            return option;
        });
        return props.toMap(Predef$.MODULE$.$conforms());
    }

    private Map<String, String> removeSQLConfigs(Map<String, String> properties) {
        return (Map)properties.filterNot((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ViewHelper$.$anonfun$removeSQLConfigs$1(x0$1)));
    }

    private Map<String, String> referredTempNamesToProps(Seq<Seq<String>> viewNames, Seq<String> functionsNames) {
        JsonAST.JArray viewNamesJson = new JsonAST.JArray(((TraversableOnce)viewNames.map((Function1 & Serializable & scala.Serializable)nameParts -> new JsonAST.JArray(((TraversableOnce)nameParts.map((Function1)JsonAST.JString$.MODULE$, Seq$.MODULE$.canBuildFrom())).toList()), Seq$.MODULE$.canBuildFrom())).toList());
        JsonAST.JArray functionsNamesJson = new JsonAST.JArray(((TraversableOnce)functionsNames.map((Function1)JsonAST.JString$.MODULE$, Seq$.MODULE$.canBuildFrom())).toList());
        HashMap props = new HashMap();
        JsonAST.JArray x$1 = viewNamesJson;
        Formats x$2 = JsonMethods$.MODULE$.render$default$2((JsonAST.JValue)x$1);
        props.put((Object)CatalogTable$.MODULE$.VIEW_REFERRED_TEMP_VIEW_NAMES(), (Object)JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)x$1, x$2)));
        JsonAST.JArray x$3 = functionsNamesJson;
        Formats x$4 = JsonMethods$.MODULE$.render$default$2((JsonAST.JValue)x$3);
        props.put((Object)CatalogTable$.MODULE$.VIEW_REFERRED_TEMP_FUNCTION_NAMES(), (Object)JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)x$3, x$4)));
        return props.toMap(Predef$.MODULE$.$conforms());
    }

    private Map<String, String> removeReferredTempNames(Map<String, String> properties) {
        return (Map)properties.filterNot((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ViewHelper$.$anonfun$removeReferredTempNames$1(x0$1)));
    }

    public Map<String, String> generateViewProperties(Map<String, String> properties, SparkSession session, LogicalPlan analyzedPlan, String[] fieldNames, Seq<Seq<String>> tempViewNames, Seq<String> tempFunctionNames) {
        String[] queryOutput = analyzedPlan.schema().fieldNames();
        SQLConf conf = session.sessionState().conf();
        SchemaUtils$.MODULE$.checkColumnNameDuplication((Seq)Predef$.MODULE$.wrapRefArray((Object[])fieldNames), "in the view definition", conf.resolver());
        CatalogManager manager = session.sessionState().catalogManager();
        return this.removeReferredTempNames(this.removeSQLConfigs(this.removeQueryColumnNames(properties))).$plus$plus((GenTraversableOnce)CatalogTable$.MODULE$.catalogAndNamespaceToProps(manager.currentCatalog().name(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])manager.currentNamespace()))).$plus$plus(this.sqlConfigsToProps(conf)).$plus$plus(this.generateQueryColumnNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])queryOutput))).$plus$plus(this.referredTempNamesToProps(tempViewNames, tempFunctionNames));
    }

    public Seq<Seq<String>> generateViewProperties$default$5() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public Seq<String> generateViewProperties$default$6() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public void checkCyclicViewReference(LogicalPlan plan, Seq<TableIdentifier> path, TableIdentifier viewIdent) {
        LogicalPlan logicalPlan2 = plan;
        if (logicalPlan2 instanceof View) {
            View view = (View)logicalPlan2;
            TableIdentifier ident = view.desc().identifier();
            Seq newPath = (Seq)path.$colon$plus((Object)ident, Seq$.MODULE$.canBuildFrom());
            TableIdentifier tableIdentifier = ident;
            TableIdentifier tableIdentifier2 = viewIdent;
            if (!(tableIdentifier != null ? !tableIdentifier.equals(tableIdentifier2) : tableIdentifier2 != null)) {
                throw new AnalysisException(new StringBuilder(34).append("Recursive view ").append(viewIdent).append(" detected ").append("(cycle: ").append(newPath.mkString(" -> ")).append(")").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            view.children().foreach((Function1 & Serializable & scala.Serializable)child -> {
                ViewHelper$.MODULE$.checkCyclicViewReference(child, (Seq<TableIdentifier>)newPath, viewIdent);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            plan.children().foreach((Function1 & Serializable & scala.Serializable)child -> {
                ViewHelper$.MODULE$.checkCyclicViewReference(child, (Seq<TableIdentifier>)path, viewIdent);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        plan.expressions().foreach((Function1 & Serializable & scala.Serializable)expr -> {
            ViewHelper$.$anonfun$checkCyclicViewReference$3(path, viewIdent, expr);
            return BoxedUnit.UNIT;
        });
    }

    public void verifyTemporaryObjectsNotExists(SessionCatalog catalog, boolean isTemporary, TableIdentifier name, LogicalPlan child) {
        block1: {
            if (isTemporary) break block1;
            Tuple2<Seq<Seq<String>>, Seq<String>> tuple2 = this.collectTemporaryObjects(catalog, child);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Seq tempViews = (Seq)tuple2._1();
            Seq tempFunctions = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)tempViews, (Object)tempFunctions);
            Tuple2 tuple23 = tuple22;
            Seq tempViews2 = (Seq)tuple23._1();
            Seq tempFunctions2 = (Seq)tuple23._2();
            tempViews2.foreach((Function1 & Serializable & scala.Serializable)nameParts -> {
                throw new AnalysisException(new StringBuilder(127).append("Not allowed to create a permanent view ").append(name).append(" by ").append("referencing a temporary view ").append(CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(nameParts).quoted()).append(". ").append("Please create a temp view instead by CREATE TEMP VIEW").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            });
            tempFunctions2.foreach((Function1 & Serializable & scala.Serializable)funcName -> {
                throw new AnalysisException(new StringBuilder(78).append("Not allowed to create a permanent view ").append(name).append(" by ").append("referencing a temporary function `").append((String)funcName).append("`").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            });
        }
    }

    private Tuple2<Seq<Seq<String>>, Seq<String>> collectTemporaryObjects(SessionCatalog catalog, LogicalPlan child) {
        return new Tuple2((Object)ViewHelper$.collectTempViews$1(child, catalog), (Object)ViewHelper$.collectTempFunctions$1(child, catalog));
    }

    public CatalogTable prepareTemporaryView(TableIdentifier viewName, SparkSession session, LogicalPlan analyzedPlan, StructType viewSchema, Option<String> originalText, LogicalPlan child) {
        SessionCatalog catalog = session.sessionState().catalog();
        Tuple2<Seq<Seq<String>>, Seq<String>> tuple2 = this.collectTemporaryObjects(catalog, child);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq tempViews = (Seq)tuple2._1();
        Seq tempFunctions = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tempViews, (Object)tempFunctions);
        Tuple2 tuple23 = tuple22;
        Seq tempViews2 = (Seq)tuple23._1();
        Seq tempFunctions2 = (Seq)tuple23._2();
        Map<String, String> newProperties = this.generateViewProperties((Map<String, String>)Predef$.MODULE$.Map().empty(), session, analyzedPlan, viewSchema.fieldNames(), (Seq<Seq<String>>)tempViews2, (Seq<String>)tempFunctions2);
        TableIdentifier x$1 = viewName;
        CatalogTableType x$2 = CatalogTableType$.MODULE$.VIEW();
        CatalogStorageFormat x$3 = CatalogStorageFormat$.MODULE$.empty();
        StructType x$4 = viewSchema;
        Option<String> x$5 = originalText;
        Map<String, String> x$6 = newProperties;
        Option x$7 = CatalogTable$.MODULE$.apply$default$5();
        Seq x$8 = CatalogTable$.MODULE$.apply$default$6();
        Option x$9 = CatalogTable$.MODULE$.apply$default$7();
        String x$10 = CatalogTable$.MODULE$.apply$default$8();
        long x$11 = CatalogTable$.MODULE$.apply$default$9();
        long x$12 = CatalogTable$.MODULE$.apply$default$10();
        String x$13 = CatalogTable$.MODULE$.apply$default$11();
        Option x$14 = CatalogTable$.MODULE$.apply$default$13();
        Option x$15 = CatalogTable$.MODULE$.apply$default$15();
        Seq x$16 = CatalogTable$.MODULE$.apply$default$16();
        boolean x$17 = CatalogTable$.MODULE$.apply$default$17();
        boolean x$18 = CatalogTable$.MODULE$.apply$default$18();
        Map x$19 = CatalogTable$.MODULE$.apply$default$19();
        Option x$20 = CatalogTable$.MODULE$.apply$default$20();
        return new CatalogTable(x$1, x$2, x$3, x$4, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$6, x$14, x$5, x$15, x$16, x$17, x$18, x$19, x$20);
    }

    public static final /* synthetic */ boolean $anonfun$removeQueryColumnNames$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        boolean bl = key.startsWith(CatalogTable$.MODULE$.VIEW_QUERY_OUTPUT_PREFIX());
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$sqlConfigsToProps$1(SQLConf conf$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        boolean bl = conf$1.isModifiable(k) && MODULE$.shouldCaptureConfig(k);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$sqlConfigsToProps$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$removeSQLConfigs$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        boolean bl = key.startsWith(CatalogTable$.MODULE$.VIEW_SQL_CONFIG_PREFIX());
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$removeReferredTempNames$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        boolean bl = key.startsWith(CatalogTable$.MODULE$.VIEW_REFERRED_TEMP_VIEW_NAMES()) || key.startsWith(CatalogTable$.MODULE$.VIEW_REFERRED_TEMP_FUNCTION_NAMES());
        return bl;
    }

    public static final /* synthetic */ void $anonfun$checkCyclicViewReference$3(Seq path$1, TableIdentifier viewIdent$3, Expression expr) {
        Expression expression = expr;
        if (expression instanceof SubqueryExpression) {
            SubqueryExpression subqueryExpression = (SubqueryExpression)expression;
            MODULE$.checkCyclicViewReference((LogicalPlan)subqueryExpression.plan(), (Seq<TableIdentifier>)path$1, viewIdent$3);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private static final Seq collectTempViews$1(LogicalPlan child, SessionCatalog catalog$2) {
        return (Seq)child.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            With with;
            UnresolvedRelation unresolvedRelation;
            Seq nameParts;
            LogicalPlan logicalPlan2 = x0$1;
            Seq seq = logicalPlan2 instanceof UnresolvedRelation && catalog$2.isTempView(nameParts = (unresolvedRelation = (UnresolvedRelation)logicalPlan2).multipartIdentifier()) ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{nameParts})) : (logicalPlan2 instanceof With && !(with = (With)logicalPlan2).resolved() ? (Seq)with.innerChildren().flatMap((Function1 & Serializable & scala.Serializable)child -> ViewHelper$.collectTempViews$1(child, catalog$2), Seq$.MODULE$.canBuildFrom()) : (!logicalPlan2.resolved() ? (Seq)logicalPlan2.expressions().flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Seq seq;
                Expression expression = x0$2;
                if (expression instanceof SubqueryExpression) {
                    SubqueryExpression subqueryExpression = (SubqueryExpression)expression;
                    seq = ViewHelper$.collectTempViews$1((LogicalPlan)subqueryExpression.plan(), catalog$2);
                } else {
                    seq = (Seq)Seq$.MODULE$.empty();
                }
                return seq;
            }), Seq$.MODULE$.canBuildFrom()) : (Seq)Seq$.MODULE$.empty()));
            return seq;
        }).distinct();
    }

    private static final Seq collectTempFunctions$1(LogicalPlan child, SessionCatalog catalog$2) {
        return (Seq)child.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            With with;
            LogicalPlan logicalPlan2 = x0$1;
            Seq seq = logicalPlan2 instanceof With && !(with = (With)logicalPlan2).resolved() ? (Seq)with.innerChildren().flatMap((Function1 & Serializable & scala.Serializable)child -> ViewHelper$.collectTempFunctions$1(child, catalog$2), Seq$.MODULE$.canBuildFrom()) : (!logicalPlan2.resolved() ? (Seq)logicalPlan2.expressions().flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Seq seq;
                Expression expression = x0$2;
                if (expression instanceof SubqueryExpression) {
                    SubqueryExpression subqueryExpression = (SubqueryExpression)expression;
                    seq = ViewHelper$.collectTempFunctions$1((LogicalPlan)subqueryExpression.plan(), catalog$2);
                } else {
                    UnresolvedFunction unresolvedFunction;
                    seq = expression instanceof UnresolvedFunction && catalog$2.isTemporaryFunction((unresolvedFunction = (UnresolvedFunction)expression).name()) ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{unresolvedFunction.name().funcName()})) : (Seq)Seq$.MODULE$.empty();
                }
                return seq;
            }), Seq$.MODULE$.canBuildFrom()) : (Seq)Seq$.MODULE$.empty());
            return seq;
        }).distinct();
    }

    private ViewHelper$() {
        MODULE$ = this;
        this.configPrefixDenyList = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{SQLConf$.MODULE$.MAX_NESTED_VIEW_DEPTH().key(), "spark.sql.optimizer.", "spark.sql.codegen.", "spark.sql.execution.", "spark.sql.shuffle.", "spark.sql.adaptive."}));
    }
}

