/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.execution.command.AlterTableChangeColumnCommand$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t-a\u0001B\u000f\u001f\u0001.B\u0001b\u0011\u0001\u0003\u0016\u0004%\t\u0001\u0012\u0005\t\u0013\u0002\u0011\t\u0012)A\u0005\u000b\"A!\n\u0001BK\u0002\u0013\u00051\n\u0003\u0005X\u0001\tE\t\u0015!\u0003M\u0011!A\u0006A!f\u0001\n\u0003I\u0006\u0002\u00031\u0001\u0005#\u0005\u000b\u0011\u0002.\t\u000b\u0005\u0004A\u0011\u00012\t\u000b\u001d\u0004A\u0011\t5\t\u000bm\u0004A\u0011\u0002?\t\u000f\u0005U\u0002\u0001\"\u0003\u00028!9\u0011q\t\u0001\u0005\n\u0005%\u0003\"CA.\u0001\u0005\u0005I\u0011AA/\u0011%\t)\u0007AI\u0001\n\u0003\t9\u0007C\u0005\u0002~\u0001\t\n\u0011\"\u0001\u0002\u0000!I\u00111\u0011\u0001\u0012\u0002\u0013\u0005\u0011Q\u0011\u0005\n\u0003\u0013\u0003\u0011\u0011!C!\u0003\u0017C\u0011\"a'\u0001\u0003\u0003%\t!!(\t\u0013\u0005\u0015\u0006!!A\u0005\u0002\u0005\u001d\u0006\"CAZ\u0001\u0005\u0005I\u0011IA[\u0011%\t\u0019\rAA\u0001\n\u0003\t)\rC\u0005\u0002J\u0002\t\t\u0011\"\u0011\u0002L\u001eI\u0011q\u001a\u0010\u0002\u0002#\u0005\u0011\u0011\u001b\u0004\t;y\t\t\u0011#\u0001\u0002T\"1\u0011m\u0006C\u0001\u0003CD\u0011\"a9\u0018\u0003\u0003%)%!:\t\u0013\u0005\u001dx#!A\u0005\u0002\u0006%\b\"CAy/\u0005\u0005I\u0011QAz\u0011%\u0011\taFA\u0001\n\u0013\u0011\u0019AA\u000fBYR,'\u000fV1cY\u0016\u001c\u0005.\u00198hK\u000e{G.^7o\u0007>lW.\u00198e\u0015\ty\u0002%A\u0004d_6l\u0017M\u001c3\u000b\u0005\u0005\u0012\u0013!C3yK\u000e,H/[8o\u0015\t\u0019C%A\u0002tc2T!!\n\u0014\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dB\u0013AB1qC\u000eDWMC\u0001*\u0003\ry'oZ\u0002\u0001'\u0015\u0001AF\u000e\u001eA!\tiC'D\u0001/\u0015\ty\u0003'A\u0004m_\u001eL7-\u00197\u000b\u0005E\u0012\u0014!\u00029mC:\u001c(BA\u001a#\u0003!\u0019\u0017\r^1msN$\u0018BA\u001b/\u0005-aunZ5dC2\u0004F.\u00198\u0011\u0005]BT\"\u0001\u0010\n\u0005er\"a\u0004*v]:\f'\r\\3D_6l\u0017M\u001c3\u0011\u0005mrT\"\u0001\u001f\u000b\u0003u\nQa]2bY\u0006L!a\u0010\u001f\u0003\u000fA\u0013x\u000eZ;diB\u00111(Q\u0005\u0003\u0005r\u0012AbU3sS\u0006d\u0017N_1cY\u0016\f\u0011\u0002^1cY\u0016t\u0015-\\3\u0016\u0003\u0015\u0003\"AR$\u000e\u0003IJ!\u0001\u0013\u001a\u0003\u001fQ\u000b'\r\\3JI\u0016tG/\u001b4jKJ\f!\u0002^1cY\u0016t\u0015-\\3!\u0003)\u0019w\u000e\\;n]:\u000bW.Z\u000b\u0002\u0019B\u0011Q\n\u0016\b\u0003\u001dJ\u0003\"a\u0014\u001f\u000e\u0003AS!!\u0015\u0016\u0002\rq\u0012xn\u001c;?\u0013\t\u0019F(\u0001\u0004Qe\u0016$WMZ\u0005\u0003+Z\u0013aa\u0015;sS:<'BA*=\u0003-\u0019w\u000e\\;n]:\u000bW.\u001a\u0011\u0002\u00139,woQ8mk6tW#\u0001.\u0011\u0005msV\"\u0001/\u000b\u0005u\u0013\u0013!\u0002;za\u0016\u001c\u0018BA0]\u0005-\u0019FO];di\u001aKW\r\u001c3\u0002\u00159,woQ8mk6t\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0005G\u0012,g\r\u0005\u00028\u0001!)1i\u0002a\u0001\u000b\")!j\u0002a\u0001\u0019\")\u0001l\u0002a\u00015\u0006\u0019!/\u001e8\u0015\u0005%4\bc\u00016pe:\u00111.\u001c\b\u0003\u001f2L\u0011!P\u0005\u0003]r\nq\u0001]1dW\u0006<W-\u0003\u0002qc\n\u00191+Z9\u000b\u00059d\u0004CA:u\u001b\u0005\u0011\u0013BA;#\u0005\r\u0011vn\u001e\u0005\u0006o\"\u0001\r\u0001_\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003gfL!A\u001f\u0012\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002!\u0019Lg\u000eZ\"pYVlgNQ=OC6,GC\u0002.~\u0003\u000b\tI\u0001C\u0003\u007f\u0013\u0001\u0007q0\u0001\u0004tG\",W.\u0019\t\u00047\u0006\u0005\u0011bAA\u00029\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\r\u0005\u001d\u0011\u00021\u0001M\u0003\u0011q\u0017-\\3\t\u000f\u0005-\u0011\u00021\u0001\u0002\u000e\u0005A!/Z:pYZ,'\u000f\u0005\u0003\u0002\u0010\u0005=b\u0002BA\t\u0003WqA!a\u0005\u0002(9!\u0011QCA\u0013\u001d\u0011\t9\"a\t\u000f\t\u0005e\u0011\u0011\u0005\b\u0005\u00037\tyBD\u0002P\u0003;I\u0011!K\u0005\u0003O!J!!\n\u0014\n\u0005\r\"\u0013BA\u001a#\u0013\r\tICM\u0001\tC:\fG._:jg&\u0019a.!\f\u000b\u0007\u0005%\"'\u0003\u0003\u00022\u0005M\"\u0001\u0003*fg>dg/\u001a:\u000b\u00079\fi#\u0001\u0006bI\u0012\u001cu.\\7f]R$RAWA\u001d\u0003{Aa!a\u000f\u000b\u0001\u0004Q\u0016AB2pYVlg\u000eC\u0004\u0002@)\u0001\r!!\u0011\u0002\u000f\r|W.\\3oiB!1(a\u0011M\u0013\r\t)\u0005\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0017\r|G.^7o\u000bF,\u0018\r\u001c\u000b\t\u0003\u0017\n\t&!\u0016\u0002ZA\u00191(!\u0014\n\u0007\u0005=CHA\u0004C_>dW-\u00198\t\r\u0005M3\u00021\u0001[\u0003\u00151\u0017.\u001a7e\u0011\u0019\t9f\u0003a\u00015\u0006)q\u000e\u001e5fe\"9\u00111B\u0006A\u0002\u00055\u0011\u0001B2paf$raYA0\u0003C\n\u0019\u0007C\u0004D\u0019A\u0005\t\u0019A#\t\u000f)c\u0001\u0013!a\u0001\u0019\"9\u0001\f\u0004I\u0001\u0002\u0004Q\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003SR3!RA6W\t\ti\u0007\u0005\u0003\u0002p\u0005eTBAA9\u0015\u0011\t\u0019(!\u001e\u0002\u0013Ut7\r[3dW\u0016$'bAA<y\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0014\u0011\u000f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003\u0003S3\u0001TA6\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!a\"+\u0007i\u000bY'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u001b\u0003B!a$\u0002\u001a6\u0011\u0011\u0011\u0013\u0006\u0005\u0003'\u000b)*\u0001\u0003mC:<'BAAL\u0003\u0011Q\u0017M^1\n\u0007U\u000b\t*\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002 B\u00191(!)\n\u0007\u0005\rFHA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002*\u0006=\u0006cA\u001e\u0002,&\u0019\u0011Q\u0016\u001f\u0003\u0007\u0005s\u0017\u0010C\u0005\u00022J\t\t\u00111\u0001\u0002 \u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a.\u0011\r\u0005e\u0016qXAU\u001b\t\tYLC\u0002\u0002>r\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t-a/\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u0017\n9\rC\u0005\u00022R\t\t\u00111\u0001\u0002*\u00061Q-];bYN$B!a\u0013\u0002N\"I\u0011\u0011W\u000b\u0002\u0002\u0003\u0007\u0011\u0011V\u0001\u001e\u00032$XM\u001d+bE2,7\t[1oO\u0016\u001cu\u000e\\;n]\u000e{W.\\1oIB\u0011qgF\n\u0005/\u0005U\u0007\t\u0005\u0005\u0002X\u0006uW\t\u0014.d\u001b\t\tINC\u0002\u0002\\r\nqA];oi&lW-\u0003\u0003\u0002`\u0006e'!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogQ\u0011\u0011\u0011[\u0001\ti>\u001cFO]5oOR\u0011\u0011QR\u0001\u0006CB\u0004H.\u001f\u000b\bG\u0006-\u0018Q^Ax\u0011\u0015\u0019%\u00041\u0001F\u0011\u0015Q%\u00041\u0001M\u0011\u0015A&\u00041\u0001[\u0003\u001d)h.\u00199qYf$B!!>\u0002~B)1(a\u0011\u0002xB11(!?F\u0019jK1!a?=\u0005\u0019!V\u000f\u001d7fg!A\u0011q`\u000e\u0002\u0002\u0003\u00071-A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011!Q\u0001\t\u0005\u0003\u001f\u00139!\u0003\u0003\u0003\n\u0005E%AB(cU\u0016\u001cG\u000f")
public class AlterTableChangeColumnCommand
extends LogicalPlan
implements RunnableCommand,
scala.Serializable {
    private final TableIdentifier tableName;
    private final String columnName;
    private final StructField newColumn;
    private Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<TableIdentifier, String, StructField>> unapply(AlterTableChangeColumnCommand alterTableChangeColumnCommand) {
        return AlterTableChangeColumnCommand$.MODULE$.unapply(alterTableChangeColumnCommand);
    }

    public static Function1<Tuple3<TableIdentifier, String, StructField>, AlterTableChangeColumnCommand> tupled() {
        return AlterTableChangeColumnCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<String, Function1<StructField, AlterTableChangeColumnCommand>>> curried() {
        return AlterTableChangeColumnCommand$.MODULE$.curried();
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.children$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        AlterTableChangeColumnCommand alterTableChangeColumnCommand = this;
        synchronized (alterTableChangeColumnCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public TableIdentifier tableName() {
        return this.tableName;
    }

    public String columnName() {
        return this.columnName;
    }

    public StructField newColumn() {
        return this.newColumn;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        CatalogTable table = catalog.getTableRawMetadata(this.tableName());
        Function2 resolver = sparkSession.sessionState().conf().resolver();
        DDLUtils$.MODULE$.verifyAlterTableType(catalog, table, false);
        StructField originColumn = this.findColumnByName(table.dataSchema(), this.columnName(), (Function2<String, String, Object>)resolver);
        if (!this.columnEqual(originColumn, this.newColumn(), (Function2<String, String, Object>)resolver)) {
            throw new AnalysisException(new StringBuilder(97).append("ALTER TABLE CHANGE COLUMN is not supported for changing column ").append("'").append(originColumn.name()).append("' with type '").append(originColumn.dataType()).append("' to ").append("'").append(this.newColumn().name()).append("' with type '").append(this.newColumn().dataType()).append("'").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        StructField[] newDataSchema = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])table.dataSchema().fields())).map((Function1 & Serializable & scala.Serializable)field -> {
            String string = field.name();
            String string2 = originColumn.name();
            return !(string != null ? !string.equals(string2) : string2 != null) ? this.addComment((StructField)field, (Option<String>)this.newColumn().getComment()) : field;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        catalog.alterTableDataSchema(this.tableName(), new StructType(newDataSchema));
        return (Seq)Seq$.MODULE$.empty();
    }

    private StructField findColumnByName(StructType schema, String name, Function2<String, String, Object> resolver) {
        return (StructField)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).collectFirst((PartialFunction)new scala.Serializable(null, resolver, name){
            public static final long serialVersionUID = 0L;
            private final Function2 resolver$1;
            private final String name$1;

            public final <A1 extends StructField, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = BoxesRunTime.unboxToBoolean((Object)this.resolver$1.apply((Object)A1.name(), (Object)this.name$1)) ? A1 : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(StructField x1) {
                StructField structField = x1;
                boolean bl = BoxesRunTime.unboxToBoolean((Object)this.resolver$1.apply((Object)structField.name(), (Object)this.name$1));
                return bl;
            }
            {
                this.resolver$1 = resolver$1;
                this.name$1 = name$1;
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AnalysisException(new StringBuilder(46).append("Can't find column `").append(name).append("` given table data columns ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames())).mkString("[`", "`, `", "`]")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        });
    }

    private StructField addComment(StructField column, Option<String> comment2) {
        return (StructField)comment2.map((Function1 & Serializable & scala.Serializable)comment -> column.withComment(comment)).getOrElse((Function0 & Serializable & scala.Serializable)() -> column);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean columnEqual(StructField field, StructField other, Function2<String, String, Object> resolver) {
        if (!BoxesRunTime.unboxToBoolean((Object)resolver.apply((Object)field.name(), (Object)other.name()))) return false;
        DataType dataType = field.dataType();
        DataType dataType2 = other.dataType();
        if (dataType != null) {
            if (!dataType.equals(dataType2)) return false;
            return true;
        }
        if (dataType2 == null) return true;
        return false;
    }

    public AlterTableChangeColumnCommand copy(TableIdentifier tableName, String columnName, StructField newColumn) {
        return new AlterTableChangeColumnCommand(tableName, columnName, newColumn);
    }

    public TableIdentifier copy$default$1() {
        return this.tableName();
    }

    public String copy$default$2() {
        return this.columnName();
    }

    public StructField copy$default$3() {
        return this.newColumn();
    }

    public String productPrefix() {
        return "AlterTableChangeColumnCommand";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.tableName();
                break;
            }
            case 1: {
                object = this.columnName();
                break;
            }
            case 2: {
                object = this.newColumn();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterTableChangeColumnCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterTableChangeColumnCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterTableChangeColumnCommand alterTableChangeColumnCommand = (AlterTableChangeColumnCommand)x$1;
        TableIdentifier tableIdentifier = this.tableName();
        TableIdentifier tableIdentifier2 = alterTableChangeColumnCommand.tableName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        String string = this.columnName();
        String string2 = alterTableChangeColumnCommand.columnName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        StructField structField = this.newColumn();
        StructField structField2 = alterTableChangeColumnCommand.newColumn();
        if (structField == null) {
            if (structField2 != null) {
                return false;
            }
        } else if (!structField.equals(structField2)) return false;
        if (!alterTableChangeColumnCommand.canEqual(this)) return false;
        return true;
    }

    public AlterTableChangeColumnCommand(TableIdentifier tableName, String columnName, StructField newColumn) {
        this.tableName = tableName;
        this.columnName = columnName;
        this.newColumn = newColumn;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
    }
}

