/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import org.apache.spark.InterruptibleIterator;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.execution.datasources.v2.DataSourceRDDPartition;
import org.apache.spark.sql.execution.datasources.v2.MetricsBatchIterator;
import org.apache.spark.sql.execution.datasources.v2.MetricsIterator;
import org.apache.spark.sql.execution.datasources.v2.MetricsRowIterator;
import org.apache.spark.sql.execution.datasources.v2.PartitionIterator;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\u0006\r\u0001mA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t[\u0001\u0011)\u0019!C\u0005]!AQ\t\u0001B\u0001B\u0003%q\u0006\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003M\u0011!y\u0005A!A!\u0002\u0013\u0001\u0006\"B*\u0001\t\u0003!\u0006\"B.\u0001\t#b\u0006\"B2\u0001\t\u0013!\u0007\"\u00026\u0001\t\u0003Z\u0007\"B;\u0001\t\u00032(!\u0004#bi\u0006\u001cv.\u001e:dKJ#EI\u0003\u0002\u000e\u001d\u0005\u0011aO\r\u0006\u0003\u001fA\t1\u0002Z1uCN|WO]2fg*\u0011\u0011CE\u0001\nKb,7-\u001e;j_:T!a\u0005\u000b\u0002\u0007M\fHN\u0003\u0002\u0016-\u0005)1\u000f]1sW*\u0011q\u0003G\u0001\u0007CB\f7\r[3\u000b\u0003e\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000f\u0011\u0007u\u0001#%D\u0001\u001f\u0015\tyB#A\u0002sI\u0012L!!\t\u0010\u0003\u0007I#E\t\u0005\u0002$M5\tAE\u0003\u0002&%\u0005A1-\u0019;bYf\u001cH/\u0003\u0002(I\tY\u0011J\u001c;fe:\fGNU8x\u0003\t\u00198\r\u0005\u0002+W5\tA#\u0003\u0002-)\ta1\u000b]1sW\u000e{g\u000e^3yi\u0006y\u0011N\u001c9viB\u000b'\u000f^5uS>t7/F\u00010!\r\u0001$(\u0010\b\u0003c]r!AM\u001b\u000e\u0003MR!\u0001\u000e\u000e\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0014!B:dC2\f\u0017B\u0001\u001d:\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011AN\u0005\u0003wq\u00121aU3r\u0015\tA\u0014\b\u0005\u0002?\u00076\tqH\u0003\u0002A\u0003\u0006!!/Z1e\u0015\t\u0011%#A\u0005d_:tWm\u0019;pe&\u0011Ai\u0010\u0002\u000f\u0013:\u0004X\u000f\u001e)beRLG/[8o\u0003AIg\u000e];u!\u0006\u0014H/\u001b;j_:\u001c\b\u0005\u000b\u0002\u0004\u000fB\u0011\u0001*S\u0007\u0002s%\u0011!*\u000f\u0002\niJ\fgn]5f]R\fa\u0003]1si&$\u0018n\u001c8SK\u0006$WM\u001d$bGR|'/\u001f\t\u0003}5K!AT \u0003-A\u000b'\u000f^5uS>t'+Z1eKJ4\u0015m\u0019;pef\fQbY8mk6t\u0017M\u001d*fC\u0012\u001c\bC\u0001%R\u0013\t\u0011\u0016HA\u0004C_>dW-\u00198\u0002\rqJg.\u001b;?)\u0015)v\u000bW-[!\t1\u0006!D\u0001\r\u0011\u0015Ac\u00011\u0001*\u0011\u0015ic\u00011\u00010\u0011\u0015Ye\u00011\u0001M\u0011\u0015ye\u00011\u0001Q\u000359W\r\u001e)beRLG/[8ogV\tQ\fE\u0002I=\u0002L!aX\u001d\u0003\u000b\u0005\u0013(/Y=\u0011\u0005)\n\u0017B\u00012\u0015\u0005%\u0001\u0016M\u001d;ji&|g.A\u0007dCN$\b+\u0019:uSRLwN\u001c\u000b\u0003K\"\u0004\"A\u00164\n\u0005\u001dd!A\u0006#bi\u0006\u001cv.\u001e:dKJ#E\tU1si&$\u0018n\u001c8\t\u000b%D\u0001\u0019\u00011\u0002\u000bM\u0004H.\u001b;\u0002\u000f\r|W\u000e];uKR\u0019An\u001c9\u0011\u0007Aj'%\u0003\u0002oy\tA\u0011\n^3sCR|'\u000fC\u0003j\u0013\u0001\u0007\u0001\rC\u0003r\u0013\u0001\u0007!/A\u0004d_:$X\r\u001f;\u0011\u0005)\u001a\u0018B\u0001;\u0015\u0005-!\u0016m]6D_:$X\r\u001f;\u0002+\u001d,G\u000f\u0015:fM\u0016\u0014(/\u001a3M_\u000e\fG/[8ogR\u0019q/!\u0001\u0011\u0007AR\u0004\u0010\u0005\u0002z{:\u0011!p\u001f\t\u0003eeJ!\u0001`\u001d\u0002\rA\u0013X\rZ3g\u0013\tqxP\u0001\u0004TiJLgn\u001a\u0006\u0003yfBQ!\u001b\u0006A\u0002\u0001\u0004")
public class DataSourceRDD
extends RDD<InternalRow> {
    private final transient Seq<InputPartition> inputPartitions;
    private final PartitionReaderFactory partitionReaderFactory;
    private final boolean columnarReads;

    private Seq<InputPartition> inputPartitions() {
        return this.inputPartitions;
    }

    public Partition[] getPartitions() {
        return (Partition[])((TraversableOnce)((TraversableLike)this.inputPartitions().zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            InputPartition inputPartition = (InputPartition)tuple2._1();
            int index = tuple2._2$mcI$sp();
            DataSourceRDDPartition dataSourceRDDPartition = new DataSourceRDDPartition(index, inputPartition);
            return dataSourceRDDPartition;
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Partition.class));
    }

    private DataSourceRDDPartition castPartition(Partition split) {
        DataSourceRDDPartition dataSourceRDDPartition;
        Partition partition = split;
        if (!(partition instanceof DataSourceRDDPartition)) {
            throw new SparkException(new StringBuilder(36).append("[BUG] Not a DataSourceRDDPartition: ").append(split).toString());
        }
        DataSourceRDDPartition dataSourceRDDPartition2 = dataSourceRDDPartition = (DataSourceRDDPartition)partition;
        return dataSourceRDDPartition2;
    }

    public Iterator<InternalRow> compute(Partition split, TaskContext context) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        InputPartition inputPartition = this.castPartition(split).inputPartition();
        if (this.columnarReads) {
            PartitionReader batchReader = this.partitionReaderFactory.createColumnarReader(inputPartition);
            MetricsBatchIterator iter = new MetricsBatchIterator((Iterator<ColumnarBatch>)new PartitionIterator<ColumnarBatch>(batchReader));
            tuple22 = new Tuple2((Object)iter, (Object)batchReader);
        } else {
            PartitionReader rowReader = this.partitionReaderFactory.createReader(inputPartition);
            MetricsRowIterator iter = new MetricsRowIterator((Iterator<InternalRow>)new PartitionIterator<InternalRow>(rowReader));
            tuple22 = tuple2 = new Tuple2((Object)iter, (Object)rowReader);
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        MetricsIterator iter = (MetricsIterator)tuple2._1();
        PartitionReader reader = (PartitionReader)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)iter, (Object)reader);
        Tuple2 tuple24 = tuple23;
        MetricsIterator iter2 = (MetricsIterator)tuple24._1();
        PartitionReader reader2 = (PartitionReader)tuple24._2();
        context.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$2 -> {
            reader2.close();
            return BoxedUnit.UNIT;
        });
        return new InterruptibleIterator(context, (Iterator)iter2);
    }

    public Seq<String> getPreferredLocations(Partition split) {
        return Predef$.MODULE$.wrapRefArray((Object[])this.castPartition(split).inputPartition().preferredLocations());
    }

    public DataSourceRDD(SparkContext sc, Seq<InputPartition> inputPartitions, PartitionReaderFactory partitionReaderFactory, boolean columnarReads) {
        this.inputPartitions = inputPartitions;
        this.partitionReaderFactory = partitionReaderFactory;
        this.columnarReads = columnarReads;
        super(sc, (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(InternalRow.class));
    }
}

