/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.util.Locale;
import java.util.Properties;
import org.apache.spark.annotation.Stable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.EliminateSubqueryAliases$;
import org.apache.spark.sql.catalyst.analysis.NamedRelation;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation$;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.plans.logical.AppendData$;
import org.apache.spark.sql.catalyst.plans.logical.CreateTableAsSelect;
import org.apache.spark.sql.catalyst.plans.logical.CreateTableAsSelectStatement;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoStatement;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OverwriteByExpression$;
import org.apache.spark.sql.catalyst.plans.logical.OverwritePartitionsDynamic$;
import org.apache.spark.sql.catalyst.plans.logical.ReplaceTableAsSelectStatement;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsCatalogOptions;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.connector.catalog.V1Table;
import org.apache.spark.sql.connector.expressions.FieldReference$;
import org.apache.spark.sql.connector.expressions.IdentityTransform;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.CreateTable;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Implicits$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Utils$;
import org.apache.spark.sql.execution.datasources.v2.FileDataSourceV2;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Stable
@ScalaSignature(bytes="\u0006\u0001\rMb\u0001\u0002 @\u0005!C\u0001\u0002\u0015\u0001\u0003\u0002\u0003\u0006I!\u0015\u0005\u0007A\u0002!\taP1\t\u000f\u0011\u0004!\u0019!C\u0005K\"1Q\u000e\u0001Q\u0001\n\u0019DQA\u001c\u0001\u0005\u0002=DQA\u001c\u0001\u0005\u0002UDq!!\u0002\u0001\t\u0003\t9\u0001C\u0004\u0002\u000e\u0001!\t!a\u0004\t\u000f\u00055\u0001\u0001\"\u0001\u0002\u001a!9\u0011Q\u0002\u0001\u0005\u0002\u0005\u0015\u0002bBA\u0007\u0001\u0011\u0005\u0011\u0011\u0007\u0005\b\u0003{\u0001A\u0011AA \u0011\u001d\ti\u0004\u0001C\u0001\u0003\u001fBq!!\u0019\u0001\t\u0003\t\u0019\u0007C\u0004\u0002~\u0001!\t!a \t\u000f\u0005M\u0005\u0001\"\u0001\u0002\u0016\"9\u0011Q\u0014\u0001\u0005\u0002\u0005}\u0005bBAO\u0001\u0011\u0005\u00111\u0016\u0005\b\u0003[\u0003A\u0011BAX\u0011\u001d\tI\f\u0001C\u0005\u0003wCq!a0\u0001\t\u0003\t\t\rC\u0004\u0002@\u0002!I!a2\t\u000f\u0005}\u0006\u0001\"\u0003\u0002f\"9\u0011q\u001f\u0001\u0005\n\u0005e\bb\u0002B\u0004\u0001\u0011%!\u0011\u0002\u0005\b\u0005\u001f\u0001A\u0011\u0002B\t\u0011\u001d\u0011)\u0002\u0001C\u0001\u0005/AqA!\u0006\u0001\t\u0013\u0011Y\u0002C\u0004\u0003\u0016\u0001!IAa\u000f\t\u000f\t}\u0002\u0001\"\u0003\u0003B!9!Q\t\u0001\u0005\n\t\u001d\u0003b\u0002B,\u0001\u0011%!\u0011\f\u0005\b\u0005K\u0002A\u0011\u0001B4\u0011\u001d\u0011Y\b\u0001C\u0001\u0005{BqA!!\u0001\t\u0003\u0011\u0019\tC\u0004\u0003\b\u0002!\tA!#\t\u000f\t5\u0005\u0001\"\u0001\u0003\u0010\"9!1\u0013\u0001\u0005\u0002\tU\u0005b\u0002BM\u0001\u0011%!1\u0014\u0005\b\u0005\u0003\u0004A\u0011\u0002Bb\u0011%\tY\u0001\u0001a\u0001\n\u0013\u0011i\rC\u0005\u0003P\u0002\u0001\r\u0011\"\u0003\u0003R\"9!q\u001b\u0001!B\u00139\b\u0002\u00038\u0001\u0001\u0004%IA!7\t\u0013\tm\u0007\u00011A\u0005\n\tu\u0007b\u0002Bq\u0001\u0001\u0006KA\u001d\u0005\n\u0005G\u0004\u0001\u0019!C\u0005\u0005KD\u0011B!=\u0001\u0001\u0004%IAa=\t\u0011\t]\b\u0001)Q\u0005\u0005OD\u0011B!?\u0001\u0001\u0004%IAa?\t\u0013\t}\b\u00011A\u0005\n\r\u0005\u0001\u0002CB\u0003\u0001\u0001\u0006KA!@\t\u0013\r\u001d\u0001\u00011A\u0005\n\tm\b\"CB\u0005\u0001\u0001\u0007I\u0011BB\u0006\u0011!\u0019y\u0001\u0001Q!\n\tu\b\"CAB\u0001\u0001\u0007I\u0011BB\t\u0011%\u0019)\u0002\u0001a\u0001\n\u0013\u00199\u0002\u0003\u0005\u0004\u001c\u0001\u0001\u000b\u0015BB\n\u0011%\u0019i\u0002\u0001a\u0001\n\u0013\u0011Y\u0010C\u0005\u0004 \u0001\u0001\r\u0011\"\u0003\u0004\"!A1Q\u0005\u0001!B\u0013\u0011iPA\bECR\fgI]1nK^\u0013\u0018\u000e^3s\u0015\t\u0001\u0015)A\u0002tc2T!AQ\"\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0011+\u0015AB1qC\u000eDWMC\u0001G\u0003\ry'oZ\u0002\u0001+\tIuk\u0005\u0002\u0001\u0015B\u00111JT\u0007\u0002\u0019*\tQ*A\u0003tG\u0006d\u0017-\u0003\u0002P\u0019\n1\u0011I\\=SK\u001a\f!\u0001Z:\u0011\u0007I\u001bV+D\u0001@\u0013\t!vHA\u0004ECR\f7/\u001a;\u0011\u0005Y;F\u0002\u0001\u0003\u00061\u0002\u0011\r!\u0017\u0002\u0002)F\u0011!,\u0018\t\u0003\u0017nK!\u0001\u0018'\u0003\u000f9{G\u000f[5oOB\u00111JX\u0005\u0003?2\u00131!\u00118z\u0003\u0019a\u0014N\\5u}Q\u0011!m\u0019\t\u0004%\u0002)\u0006\"\u0002)\u0003\u0001\u0004\t\u0016A\u00013g+\u00051\u0007CA4k\u001d\t\u0011\u0006.\u0003\u0002j\u007f\u00059\u0001/Y2lC\u001e,\u0017BA6m\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0002j\u007f\u0005\u0019AM\u001a\u0011\u0002\t5|G-\u001a\u000b\u0003EBDQ!]\u0003A\u0002I\f\u0001b]1wK6{G-\u001a\t\u0003%NL!\u0001^ \u0003\u0011M\u000bg/Z'pI\u0016$\"A\u0019<\t\u000bE4\u0001\u0019A<\u0011\u0005a|hBA=~!\tQH*D\u0001|\u0015\tax)\u0001\u0004=e>|GOP\u0005\u0003}2\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0001\u0003\u0007\u0011aa\u0015;sS:<'B\u0001@M\u0003\u00191wN]7biR\u0019!-!\u0003\t\r\u0005-q\u00011\u0001x\u0003\u0019\u0019x.\u001e:dK\u00061q\u000e\u001d;j_:$RAYA\t\u0003+Aa!a\u0005\t\u0001\u00049\u0018aA6fs\"1\u0011q\u0003\u0005A\u0002]\fQA^1mk\u0016$RAYA\u000e\u0003;Aa!a\u0005\n\u0001\u00049\bbBA\f\u0013\u0001\u0007\u0011q\u0004\t\u0004\u0017\u0006\u0005\u0012bAA\u0012\u0019\n9!i\\8mK\u0006tG#\u00022\u0002(\u0005%\u0002BBA\n\u0015\u0001\u0007q\u000fC\u0004\u0002\u0018)\u0001\r!a\u000b\u0011\u0007-\u000bi#C\u0002\u000201\u0013A\u0001T8oOR)!-a\r\u00026!1\u00111C\u0006A\u0002]Dq!a\u0006\f\u0001\u0004\t9\u0004E\u0002L\u0003sI1!a\u000fM\u0005\u0019!u.\u001e2mK\u00069q\u000e\u001d;j_:\u001cHc\u00012\u0002B!9\u0011Q\b\u0007A\u0002\u0005\r\u0003CBA#\u0003\u0017:x/\u0004\u0002\u0002H)\u0019\u0011\u0011\n'\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002N\u0005\u001d#aA'baR\u0019!-!\u0015\t\u000f\u0005uR\u00021\u0001\u0002TA1\u0011QKA0o^l!!a\u0016\u000b\t\u0005e\u00131L\u0001\u0005kRLGN\u0003\u0002\u0002^\u0005!!.\u0019<b\u0013\u0011\ti%a\u0016\u0002\u0017A\f'\u000f^5uS>t')\u001f\u000b\u0004E\u0006\u0015\u0004bBA4\u001d\u0001\u0007\u0011\u0011N\u0001\tG>dg*Y7fgB!1*a\u001bx\u0013\r\ti\u0007\u0014\u0002\u000byI,\u0007/Z1uK\u0012t\u0004f\u0001\b\u0002rA!\u00111OA=\u001b\t\t)HC\u0002\u0002x1\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\tY(!\u001e\u0003\u000fY\f'/\u0019:hg\u0006A!-^2lKR\u0014\u0015\u0010F\u0004c\u0003\u0003\u000bY)a$\t\u000f\u0005\ru\u00021\u0001\u0002\u0006\u0006Qa.^7Ck\u000e\\W\r^:\u0011\u0007-\u000b9)C\u0002\u0002\n2\u00131!\u00138u\u0011\u0019\tii\u0004a\u0001o\u000691m\u001c7OC6,\u0007bBA4\u001f\u0001\u0007\u0011\u0011\u000e\u0015\u0004\u001f\u0005E\u0014AB:peR\u0014\u0015\u0010F\u0003c\u0003/\u000bI\n\u0003\u0004\u0002\u000eB\u0001\ra\u001e\u0005\b\u0003O\u0002\u0002\u0019AA5Q\r\u0001\u0012\u0011O\u0001\u0005g\u00064X\r\u0006\u0003\u0002\"\u0006\u001d\u0006cA&\u0002$&\u0019\u0011Q\u0015'\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003S\u000b\u0002\u0019A<\u0002\tA\fG\u000f\u001b\u000b\u0003\u0003C\u000bAb]1wK&sG/\u001a:oC2$B!!)\u00022\"9\u0011\u0011V\nA\u0002\u0005M\u0006\u0003B&\u00026^L1!a.M\u0005\u0019y\u0005\u000f^5p]\u0006q1/\u0019<f)>4\u0016gU8ve\u000e,G\u0003BAQ\u0003{Cq!!+\u0015\u0001\u0004\t\u0019,\u0001\u0006j]N,'\u000f^%oi>$B!!)\u0002D\"1\u0011QY\u000bA\u0002]\f\u0011\u0002^1cY\u0016t\u0015-\\3\u0015\r\u0005\u0005\u0016\u0011ZAn\u0011\u001d\tYM\u0006a\u0001\u0003\u001b\fqaY1uC2|w\r\u0005\u0003\u0002P\u0006]WBAAi\u0015\u0011\tY-a5\u000b\u0007\u0005Uw(A\u0005d_:tWm\u0019;pe&!\u0011\u0011\\Ai\u00055\u0019\u0015\r^1m_\u001e\u0004F.^4j]\"9\u0011Q\u001c\fA\u0002\u0005}\u0017!B5eK:$\b\u0003BAh\u0003CLA!a9\u0002R\nQ\u0011\nZ3oi&4\u0017.\u001a:\u0015\t\u0005\u0005\u0016q\u001d\u0005\b\u0003S<\u0002\u0019AAv\u0003)!\u0018M\u00197f\u0013\u0012,g\u000e\u001e\t\u0005\u0003[\f\u00190\u0004\u0002\u0002p*\u0019\u0011\u0011_ \u0002\u0011\r\fG/\u00197zgRLA!!>\u0002p\nyA+\u00192mK&#WM\u001c;jM&,'/A\u0007hKR\u0014UoY6fiN\u0003XmY\u000b\u0003\u0003w\u0004RaSA[\u0003{\u0004B!a@\u0003\u00045\u0011!\u0011\u0001\u0006\u0005\u0003\u0017\fy/\u0003\u0003\u0003\u0006\t\u0005!A\u0003\"vG.,Go\u00159fG\u0006\t\u0012m]:feRtu\u000e\u001e\"vG.,G/\u001a3\u0015\t\u0005\u0005&1\u0002\u0005\u0007\u0005\u001bI\u0002\u0019A<\u0002\u0013=\u0004XM]1uS>t\u0017\u0001F1tg\u0016\u0014HOT8u!\u0006\u0014H/\u001b;j_:,G\r\u0006\u0003\u0002\"\nM\u0001B\u0002B\u00075\u0001\u0007q/A\u0006tCZ,\u0017i\u001d+bE2,G\u0003BAQ\u00053Aa!!2\u001c\u0001\u00049H\u0003CAQ\u0005;\u0011)Ca\n\t\u000f\u0005-G\u00041\u0001\u0003 A!\u0011q\u001aB\u0011\u0013\u0011\u0011\u0019#!5\u0003\u0019Q\u000b'\r\\3DCR\fGn\\4\t\u000f\u0005uG\u00041\u0001\u0002`\"9!\u0011\u0006\u000fA\u0002\t-\u0012!\u00038b[\u0016\u0004\u0016M\u001d;t!\u0015\u0011iC!\u000ex\u001d\u0011\u0011yCa\r\u000f\u0007i\u0014\t$C\u0001N\u0013\tIG*\u0003\u0003\u00038\te\"aA*fc*\u0011\u0011\u000e\u0014\u000b\u0005\u0003C\u0013i\u0004C\u0004\u0002jv\u0001\r!a;\u0002\u0017\r\u0014X-\u0019;f)\u0006\u0014G.\u001a\u000b\u0005\u0003C\u0013\u0019\u0005C\u0004\u0002jz\u0001\r!a;\u0002!A\f'\u000f^5uS>t\u0017N\\4BgZ\u0013TC\u0001B%!\u0019\u0011iC!\u000e\u0003LA!!Q\nB*\u001b\t\u0011yE\u0003\u0003\u0003R\u0005M\u0017aC3yaJ,7o]5p]NLAA!\u0016\u0003P\tIAK]1og\u001a|'/\\\u0001 G\",7m\u001b)beRLG/[8oS:<W*\u0019;dQ\u0016\u001chK\r+bE2,G\u0003BAQ\u00057BqA!\u0018!\u0001\u0004\u0011y&A\u0007fq&\u001cH/\u001b8h)\u0006\u0014G.\u001a\t\u0005\u0003\u001f\u0014\t'\u0003\u0003\u0003d\u0005E'!\u0002+bE2,\u0017\u0001\u00026eE\u000e$\u0002\"!)\u0003j\t5$\u0011\u000f\u0005\u0007\u0005W\n\u0003\u0019A<\u0002\u0007U\u0014H\u000e\u0003\u0004\u0003p\u0005\u0002\ra^\u0001\u0006i\u0006\u0014G.\u001a\u0005\b\u0005g\n\u0003\u0019\u0001B;\u0003Q\u0019wN\u001c8fGRLwN\u001c)s_B,'\u000f^5fgB!\u0011Q\u000bB<\u0013\u0011\u0011I(a\u0016\u0003\u0015A\u0013x\u000e]3si&,7/\u0001\u0003kg>tG\u0003BAQ\u0005\u007fBa!!+#\u0001\u00049\u0018a\u00029beF,X\r\u001e\u000b\u0005\u0003C\u0013)\t\u0003\u0004\u0002*\u000e\u0002\ra^\u0001\u0004_J\u001cG\u0003BAQ\u0005\u0017Ca!!+%\u0001\u00049\u0018\u0001\u0002;fqR$B!!)\u0003\u0012\"1\u0011\u0011V\u0013A\u0002]\f1aY:w)\u0011\t\tKa&\t\r\u0005%f\u00051\u0001x\u0003)\u0011XO\\\"p[6\fg\u000e\u001a\u000b\u0007\u0005;\u0013\u0019L!0\u0015\t\u0005\u0005&q\u0014\u0005\b\u0005C;\u0003\u0019\u0001BR\u0003\u001d\u0019w.\\7b]\u0012\u0004BA!*\u000306\u0011!q\u0015\u0006\u0005\u0005S\u0013Y+A\u0004m_\u001eL7-\u00197\u000b\t\t5\u0016q^\u0001\u0006a2\fgn]\u0005\u0005\u0005c\u00139KA\u0006M_\u001eL7-\u00197QY\u0006t\u0007b\u0002B[O\u0001\u0007!qW\u0001\bg\u0016\u001c8/[8o!\r\u0011&\u0011X\u0005\u0004\u0005w{$\u0001D*qCJ\\7+Z:tS>t\u0007B\u0002B`O\u0001\u0007q/\u0001\u0003oC6,\u0017\u0001\u00057p_.,\bO\u0016\u001aQe>4\u0018\u000eZ3s)\t\u0011)\rE\u0003L\u0003k\u00139\r\u0005\u0003\u0002P\n%\u0017\u0002\u0002Bf\u0003#\u0014Q\u0002V1cY\u0016\u0004&o\u001c<jI\u0016\u0014X#A<\u0002\u0015M|WO]2f?\u0012*\u0017\u000f\u0006\u0003\u0002\"\nM\u0007\u0002\u0003BkU\u0005\u0005\t\u0019A<\u0002\u0007a$\u0013'A\u0004t_V\u00148-\u001a\u0011\u0016\u0003I\f\u0001\"\\8eK~#S-\u001d\u000b\u0005\u0003C\u0013y\u000e\u0003\u0005\u0003V6\n\t\u00111\u0001s\u0003\u0015iw\u000eZ3!\u00031)\u0007\u0010\u001e:b\u001fB$\u0018n\u001c8t+\t\u00119\u000fE\u0003\u0003j\n5x/\u0004\u0002\u0003l*!\u0011\u0011LAx\u0013\u0011\u0011yOa;\u0003%\r\u000b7/Z%og\u0016t7/\u001b;jm\u0016l\u0015\r]\u0001\u0011Kb$(/Y(qi&|gn]0%KF$B!!)\u0003v\"I!Q\u001b\u0019\u0002\u0002\u0003\u0007!q]\u0001\u000eKb$(/Y(qi&|gn\u001d\u0011\u0002'A\f'\u000f^5uS>t\u0017N\\4D_2,XN\\:\u0016\u0005\tu\b#B&\u00026\n-\u0012a\u00069beRLG/[8oS:<7i\u001c7v[:\u001cx\fJ3r)\u0011\t\tka\u0001\t\u0013\tU7'!AA\u0002\tu\u0018\u0001\u00069beRLG/[8oS:<7i\u001c7v[:\u001c\b%A\tck\u000e\\W\r^\"pYVlgNT1nKN\fQCY;dW\u0016$8i\u001c7v[:t\u0015-\\3t?\u0012*\u0017\u000f\u0006\u0003\u0002\"\u000e5\u0001\"\u0003Bkm\u0005\u0005\t\u0019\u0001B\u007f\u0003I\u0011WoY6fi\u000e{G.^7o\u001d\u0006lWm\u001d\u0011\u0016\u0005\rM\u0001#B&\u00026\u0006\u0015\u0015A\u00048v[\n+8m[3ug~#S-\u001d\u000b\u0005\u0003C\u001bI\u0002C\u0005\u0003Vf\n\t\u00111\u0001\u0004\u0014\u0005Ya.^7Ck\u000e\\W\r^:!\u0003=\u0019xN\u001d;D_2,XN\u001c(b[\u0016\u001c\u0018aE:peR\u001cu\u000e\\;n]:\u000bW.Z:`I\u0015\fH\u0003BAQ\u0007GA\u0011B!6=\u0003\u0003\u0005\rA!@\u0002!M|'\u000f^\"pYVlgNT1nKN\u0004\u0003f\u0001\u0001\u0004*A!11FB\u0018\u001b\t\u0019iCC\u0002\u0002x\u0005KAa!\r\u0004.\t11\u000b^1cY\u0016\u0004")
public final class DataFrameWriter<T> {
    private final Dataset<Row> df;
    private String source;
    private SaveMode mode;
    private CaseInsensitiveMap<String> extraOptions;
    private Option<Seq<String>> partitioningColumns;
    private Option<Seq<String>> bucketColumnNames;
    private Option<Object> numBuckets;
    private Option<Seq<String>> sortColumnNames;

    public DataFrameWriter<T> partitionBy(String ... colNames) {
        return this.partitionBy((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataFrameWriter<T> bucketBy(int numBuckets, String colName, String ... colNames) {
        return this.bucketBy(numBuckets, colName, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataFrameWriter<T> sortBy(String colName, String ... colNames) {
        return this.sortBy(colName, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    private Dataset<Row> df() {
        return this.df;
    }

    public DataFrameWriter<T> mode(SaveMode saveMode) {
        this.mode_$eq(saveMode);
        return this;
    }

    public DataFrameWriter<T> mode(String saveMode) {
        DataFrameWriter<T> dataFrameWriter;
        String string = saveMode.toLowerCase(Locale.ROOT);
        if ("overwrite".equals(string)) {
            dataFrameWriter = this.mode(SaveMode.Overwrite);
        } else if ("append".equals(string)) {
            dataFrameWriter = this.mode(SaveMode.Append);
        } else if ("ignore".equals(string)) {
            dataFrameWriter = this.mode(SaveMode.Ignore);
        } else {
            boolean bl = "error".equals(string) ? true : ("errorifexists".equals(string) ? true : "default".equals(string));
            if (bl) {
                dataFrameWriter = this.mode(SaveMode.ErrorIfExists);
            } else {
                throw new IllegalArgumentException(new StringBuilder(114).append("Unknown save mode: ").append(saveMode).append(". Accepted ").append("save modes are 'overwrite', 'append', 'ignore', 'error', 'errorifexists', 'default'.").toString());
            }
        }
        return dataFrameWriter;
    }

    public DataFrameWriter<T> format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataFrameWriter<T> option(String key, String value) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value)));
        return this;
    }

    public DataFrameWriter<T> option(String key, boolean value) {
        return this.option(key, ((Object)BoxesRunTime.boxToBoolean((boolean)value)).toString());
    }

    public DataFrameWriter<T> option(String key, long value) {
        return this.option(key, ((Object)BoxesRunTime.boxToLong((long)value)).toString());
    }

    public DataFrameWriter<T> option(String key, double value) {
        return this.option(key, ((Object)BoxesRunTime.boxToDouble((double)value)).toString());
    }

    public DataFrameWriter<T> options(Map<String, String> options) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus(options));
        return this;
    }

    public DataFrameWriter<T> options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()));
        return this;
    }

    public DataFrameWriter<T> partitionBy(Seq<String> colNames) {
        this.partitioningColumns_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames));
        return this;
    }

    public DataFrameWriter<T> bucketBy(int numBuckets, String colName, Seq<String> colNames) {
        this.numBuckets_$eq((Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)numBuckets)));
        String string = colName;
        this.bucketColumnNames_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())));
        return this;
    }

    public DataFrameWriter<T> sortBy(String colName, Seq<String> colNames) {
        String string = colName;
        this.sortColumnNames_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())));
        return this;
    }

    public void save(String path) {
        if (!this.df().sparkSession().sessionState().conf().legacyPathOptionBehavior() && this.extraOptions().contains("path")) {
            throw new AnalysisException(new StringBuilder(181).append("There is a 'path' option set and save() is called with a path parameter. Either remove the path option, or call save() without the parameter. ").append("To ignore this check, set '").append(SQLConf$.MODULE$.LEGACY_PATH_OPTION_BEHAVIOR().key()).append("' to 'true'.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        this.saveInternal((Option<String>)new Some((Object)path));
    }

    public void save() {
        this.saveInternal((Option<String>)None$.MODULE$);
    }

    private void saveInternal(Option<String> path) {
        String string = this.source().toLowerCase(Locale.ROOT);
        String string2 = DDLUtils$.MODULE$.HIVE_PROVIDER();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new AnalysisException("Hive data source can only be used with tables, you can not write files of Hive data source directly.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        this.assertNotBucketed("save");
        Option<TableProvider> maybeV2Provider = this.lookupV2Provider();
        if (maybeV2Provider.isDefined()) {
            TableProvider provider = (TableProvider)maybeV2Provider.get();
            scala.collection.immutable.Map<String, String> sessionOptions = DataSourceV2Utils$.MODULE$.extractSessionConfigs(provider, this.df().sparkSession().sessionState().conf());
            CaseInsensitiveMap optionsWithPath = path.isEmpty() ? this.extraOptions() : this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), path.get()));
            scala.collection.immutable.Map finalOptions = sessionOptions.filterKeys((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DataFrameWriter.$anonfun$saveInternal$1(optionsWithPath, x$3))).toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)optionsWithPath.originalMap());
            CaseInsensitiveStringMap dsOptions = new CaseInsensitiveStringMap((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)finalOptions).asJava());
            CatalogManager catalogManager = this.df().sparkSession().sessionState().catalogManager();
            SaveMode saveMode = this.mode();
            boolean bl = ((Object)((Object)SaveMode.Append)).equals((Object)saveMode) ? true : ((Object)((Object)SaveMode.Overwrite)).equals((Object)saveMode);
            if (bl) {
                BoxedUnit boxedUnit;
                Tuple3 tuple3;
                TableProvider tableProvider = provider;
                if (tableProvider instanceof SupportsCatalogOptions) {
                    SupportsCatalogOptions supportsCatalogOptions = (SupportsCatalogOptions)tableProvider;
                    Identifier ident = supportsCatalogOptions.extractIdentifier(dsOptions);
                    TableCatalog catalog = CatalogV2Util$.MODULE$.getTableProviderCatalog(supportsCatalogOptions, catalogManager, dsOptions);
                    tuple3 = new Tuple3((Object)catalog.loadTable(ident), (Object)new Some((Object)catalog), (Object)new Some((Object)ident));
                } else if (tableProvider != null) {
                    Table t = this.getTable$1(provider, dsOptions);
                    if (!DataSourceV2Implicits$.MODULE$.TableHelper(t).supports(TableCapability.BATCH_WRITE)) {
                        this.saveToV1Source(path);
                        return;
                    }
                    tuple3 = new Tuple3((Object)t, (Object)None$.MODULE$, (Object)None$.MODULE$);
                } else {
                    throw new MatchError((Object)tableProvider);
                }
                Tuple3 tuple32 = tuple3;
                if (tuple32 == null) {
                    throw new MatchError((Object)tuple32);
                }
                Table table = (Table)tuple32._1();
                Option catalog = (Option)tuple32._2();
                Option ident = (Option)tuple32._3();
                Tuple3 tuple33 = new Tuple3((Object)table, (Object)catalog, (Object)ident);
                Tuple3 tuple34 = tuple33;
                Table table2 = (Table)tuple34._1();
                Option catalog2 = (Option)tuple34._2();
                Option ident2 = (Option)tuple34._3();
                DataSourceV2Relation relation = DataSourceV2Relation$.MODULE$.create(table2, catalog2, ident2, dsOptions);
                this.checkPartitioningMatchesV2Table(table2);
                SaveMode saveMode2 = this.mode();
                SaveMode saveMode3 = SaveMode.Append;
                if (!(saveMode2 != null ? !((Object)((Object)saveMode2)).equals((Object)saveMode3) : saveMode3 != null)) {
                    this.runCommand(this.df().sparkSession(), "save", (LogicalPlan)AppendData$.MODULE$.byName((NamedRelation)relation, this.df().logicalPlan(), finalOptions));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.runCommand(this.df().sparkSession(), "save", (LogicalPlan)OverwriteByExpression$.MODULE$.byName((NamedRelation)relation, this.df().logicalPlan(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)), finalOptions));
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                TableProvider tableProvider = provider;
                if (tableProvider instanceof SupportsCatalogOptions) {
                    SupportsCatalogOptions supportsCatalogOptions = (SupportsCatalogOptions)tableProvider;
                    Identifier ident = supportsCatalogOptions.extractIdentifier(dsOptions);
                    TableCatalog catalog = CatalogV2Util$.MODULE$.getTableProviderCatalog(supportsCatalogOptions, catalogManager, dsOptions);
                    Option location = Option$.MODULE$.apply((Object)dsOptions.get((Object)"path")).map((Function1 & Serializable & scala.Serializable)x$5 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"location"), x$5));
                    SaveMode saveMode4 = saveMode;
                    SaveMode saveMode5 = SaveMode.Ignore;
                    this.runCommand(this.df().sparkSession(), "save", (LogicalPlan)new CreateTableAsSelect(catalog, ident, this.partitioningAsV2(), this.df().queryExecution().analyzed(), ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)this.source())}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(location)), finalOptions, !(saveMode4 != null ? !((Object)((Object)saveMode4)).equals((Object)saveMode5) : saveMode5 != null)));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (tableProvider != null) {
                    if (DataSourceV2Implicits$.MODULE$.TableHelper(this.getTable$1(provider, dsOptions)).supports(TableCapability.BATCH_WRITE)) {
                        throw new AnalysisException(new StringBuilder(105).append("TableProvider implementation ").append(this.source()).append(" cannot be ").append("written with ").append((Object)saveMode).append(" mode, please use Append or Overwrite ").append("modes instead.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    }
                    this.saveToV1Source(path);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)tableProvider);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            this.saveToV1Source(path);
        }
    }

    private void saveToV1Source(Option<String> path) {
        this.partitioningColumns().foreach((Function1 & Serializable & scala.Serializable)columns -> {
            this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceUtils$.MODULE$.PARTITIONING_COLUMNS_KEY()), (Object)DataSourceUtils$.MODULE$.encodePartitioningColumns((Seq<String>)columns))));
            return BoxedUnit.UNIT;
        });
        CaseInsensitiveMap optionsWithPath = path.isEmpty() ? this.extraOptions() : this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), path.get()));
        SparkSession x$1 = this.df().sparkSession();
        String x$2 = this.source();
        Seq x$3 = (Seq)this.partitioningColumns().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        scala.collection.immutable.Map x$4 = optionsWithPath.originalMap();
        Seq<String> x$5 = DataSource$.MODULE$.apply$default$3();
        Option<StructType> x$6 = DataSource$.MODULE$.apply$default$4();
        Option<BucketSpec> x$7 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$8 = DataSource$.MODULE$.apply$default$8();
        this.runCommand(this.df().sparkSession(), "save", new DataSource(x$1, x$2, x$5, x$6, (Seq<String>)x$3, x$7, (scala.collection.immutable.Map<String, String>)x$4, x$8).planForWriting(this.mode(), this.df().logicalPlan()));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void insertInto(String tableName) {
        Option option;
        this.assertNotBucketed("insertInto");
        if (this.partitioningColumns().isDefined()) {
            throw new AnalysisException("insertInto() can't be used together with partitionBy(). Partition columns have already been defined for the table. It is not necessary to use partitionBy().", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        SparkSession session = this.df().sparkSession();
        boolean canUseV2 = this.lookupV2Provider().isDefined();
        Seq seq = session.sessionState().sqlParser().parseMultipartIdentifier(tableName);
        Option option2 = this.df().sparkSession().sessionState().analyzer().NonSessionCatalogAndIdentifier().unapply(seq);
        if (!option2.isEmpty()) {
            CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option2.get())._1();
            Identifier ident = (Identifier)((Tuple2)option2.get())._2();
            this.insertInto(catalog, ident);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        Option option3 = this.df().sparkSession().sessionState().analyzer().SessionCatalogAndIdentifier().unapply(seq);
        if (!option3.isEmpty()) {
            CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option3.get())._1();
            Identifier ident = (Identifier)((Tuple2)option3.get())._2();
            if (canUseV2 && ident.namespace().length <= 1) {
                this.insertInto(catalog, ident);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if ((option = this.df().sparkSession().sessionState().analyzer().AsTableIdentifier().unapply(seq)).isEmpty()) throw new AnalysisException(new StringBuilder(50).append("Couldn't find a catalog to handle the identifier ").append(CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(seq).quoted()).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        TableIdentifier tableIdentifier = (TableIdentifier)option.get();
        this.insertInto(tableIdentifier);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Unable to fully structure code
     */
    private void insertInto(CatalogPlugin catalog, Identifier ident) {
        block4: {
            block5: {
                block3: {
                    var7_3 = CatalogV2Implicits$.MODULE$.CatalogHelper(catalog).asTableCatalog().loadTable(ident);
                    if (var7_3 instanceof V1Table) {
                        this.insertInto(new TableIdentifier(ident.name(), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ident.namespace())).headOption()));
                        return;
                    }
                    table = var5_4 = DataSourceV2Relation$.MODULE$.create(var7_3, (Option)new Some((Object)catalog), (Option)new Some((Object)ident));
                    var9_6 = this.mode();
                    var4_7 = SaveMode.Append.equals((Object)var9_6) != false ? true : (SaveMode.ErrorIfExists.equals((Object)var9_6) != false ? true : SaveMode.Ignore.equals((Object)var9_6) != false);
                    if (!var4_7) break block3;
                    var3_8 = AppendData$.MODULE$.byPosition((NamedRelation)table, this.df().logicalPlan(), this.extraOptions().toMap());
                    break block4;
                }
                if (!SaveMode.Overwrite.equals((Object)var9_6)) break block5;
                conf = this.df().sparkSession().sessionState().conf();
                if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])table.table().partitioning())).size() <= 0) ** GOTO lbl-1000
                v0 = conf.partitionOverwriteMode();
                var12_10 = SQLConf.PartitionOverwriteMode$.MODULE$.DYNAMIC();
                if (!(v0 != null ? v0.equals(var12_10) == false : var12_10 != null)) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                dynamicPartitionOverwrite = v1;
                var3_8 = dynamicPartitionOverwrite != false ? OverwritePartitionsDynamic$.MODULE$.byPosition((NamedRelation)table, this.df().logicalPlan(), this.extraOptions().toMap()) : OverwriteByExpression$.MODULE$.byPosition((NamedRelation)table, this.df().logicalPlan(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)), this.extraOptions().toMap());
                break block4;
            }
            throw new MatchError((Object)var9_6);
        }
        command = var3_8;
        this.runCommand(this.df().sparkSession(), "insertInto", (LogicalPlan)command);
    }

    private void insertInto(TableIdentifier tableIdent) {
        SaveMode saveMode = this.mode();
        SaveMode saveMode2 = SaveMode.Overwrite;
        this.runCommand(this.df().sparkSession(), "insertInto", (LogicalPlan)new InsertIntoStatement((LogicalPlan)UnresolvedRelation$.MODULE$.apply(tableIdent), Predef$.MODULE$.Map().empty(), (Seq)Nil$.MODULE$, this.df().logicalPlan(), !(saveMode != null ? !((Object)((Object)saveMode)).equals((Object)saveMode2) : saveMode2 != null), false));
    }

    private Option<BucketSpec> getBucketSpec() {
        if (this.sortColumnNames().isDefined() && this.numBuckets().isEmpty()) {
            throw new AnalysisException("sortBy must be used together with bucketBy", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        return this.numBuckets().map((Function1 & Serializable & scala.Serializable)n -> DataFrameWriter.$anonfun$getBucketSpec$1(this, BoxesRunTime.unboxToInt((Object)n)));
    }

    private void assertNotBucketed(String operation) {
        if (this.getBucketSpec().isDefined()) {
            if (this.sortColumnNames().isEmpty()) {
                throw new AnalysisException(new StringBuilder(38).append("'").append(operation).append("' does not support bucketBy right now").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            throw new AnalysisException(new StringBuilder(49).append("'").append(operation).append("' does not support bucketBy and sortBy right now").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    private void assertNotPartitioned(String operation) {
        if (this.partitioningColumns().isDefined()) {
            throw new AnalysisException(new StringBuilder(32).append("'").append(operation).append("' does not support partitioning").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void saveAsTable(String tableName) {
        Option option;
        SparkSession session = this.df().sparkSession();
        boolean canUseV2 = this.lookupV2Provider().isDefined();
        Seq seq = session.sessionState().sqlParser().parseMultipartIdentifier(tableName);
        Option option2 = this.df().sparkSession().sessionState().analyzer().NonSessionCatalogAndIdentifier().unapply(seq);
        if (!option2.isEmpty()) {
            CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option2.get())._1();
            Identifier ident = (Identifier)((Tuple2)option2.get())._2();
            this.saveAsTable(CatalogV2Implicits$.MODULE$.CatalogHelper(catalog).asTableCatalog(), ident, (Seq<String>)seq);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        Option option3 = this.df().sparkSession().sessionState().analyzer().SessionCatalogAndIdentifier().unapply(seq);
        if (!option3.isEmpty()) {
            CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option3.get())._1();
            Identifier ident = (Identifier)((Tuple2)option3.get())._2();
            if (canUseV2 && ident.namespace().length <= 1) {
                this.saveAsTable(CatalogV2Implicits$.MODULE$.CatalogHelper(catalog).asTableCatalog(), ident, (Seq<String>)seq);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if ((option = this.df().sparkSession().sessionState().analyzer().AsTableIdentifier().unapply(seq)).isEmpty()) throw new AnalysisException(new StringBuilder(50).append("Couldn't find a catalog to handle the identifier ").append(CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(seq).quoted()).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        TableIdentifier tableIdentifier = (TableIdentifier)option.get();
        this.saveAsTable(tableIdentifier);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Unable to fully structure code
     */
    private void saveAsTable(TableCatalog catalog, Identifier ident, Seq<String> nameParts) {
        try {
            v0 = Option$.MODULE$.apply((Object)catalog.loadTable(ident));
        }
        catch (NoSuchTableException v1) {
            v0 = None$.MODULE$;
        }
        tableOpt = v0;
        var7_5 = new Tuple2((Object)this.mode(), (Object)tableOpt);
        if (var7_5 != null && (var8_6 = (Option)var7_5._2()) instanceof Some && (var9_7 = (Some)var8_6).value() instanceof V1Table) {
            this.saveAsTable(new TableIdentifier(ident.name(), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ident.namespace())).headOption()));
            return;
        }
        if (var7_5 == null) ** GOTO lbl-1000
        var10_8 = (SaveMode)var7_5._1();
        var11_9 = (Option)var7_5._2();
        if (SaveMode.Append.equals((Object)var10_8) && var11_9 instanceof Some) {
            var12_10 = (Some)var11_9;
            table = (Table)var12_10.value();
            this.checkPartitioningMatchesV2Table(table);
            v2Relation = DataSourceV2Relation$.MODULE$.create(table, (Option)new Some((Object)catalog), (Option)new Some((Object)ident));
            var4_13 = AppendData$.MODULE$.byName((NamedRelation)v2Relation, this.df().logicalPlan(), this.extraOptions().toMap());
        } else if (var7_5 != null && SaveMode.Overwrite.equals((Object)(var15_14 = (SaveMode)var7_5._1()))) {
            var4_13 = new ReplaceTableAsSelectStatement(nameParts, this.df().queryExecution().analyzed(), this.partitioningAsV2(), (Option)None$.MODULE$, Predef$.MODULE$.Map().empty(), (Option)new Some((Object)this.source()), Predef$.MODULE$.Map().empty(), this.extraOptions().get("path"), this.extraOptions().get("comment"), this.extraOptions().toMap(), (Option)None$.MODULE$, true);
        } else if (var7_5 != null) {
            other = (SaveMode)var7_5._1();
            x$1 = nameParts;
            x$2 = this.df().queryExecution().analyzed();
            x$3 = this.partitioningAsV2();
            x$4 = None$.MODULE$;
            x$5 = Predef$.MODULE$.Map().empty();
            x$6 = new Some((Object)this.source());
            x$7 = Predef$.MODULE$.Map().empty();
            x$8 = this.extraOptions().get("path");
            x$9 = this.extraOptions().get("comment");
            x$10 = this.extraOptions().toMap();
            x$11 = None$.MODULE$;
            v2 = other;
            var29_27 = SaveMode.Ignore;
            x$12 = !(v2 != null ? v2.equals((Object)var29_27) == false : var29_27 != null);
            x$13 = false;
            var4_13 = new CreateTableAsSelectStatement(x$1, x$2, x$3, (Option)x$4, x$5, (Option)x$6, x$7, x$8, x$9, x$10, (Option)x$11, x$13, x$12);
        } else {
            throw new MatchError((Object)var7_5);
        }
        command = var4_13;
        this.runCommand(this.df().sparkSession(), "saveAsTable", (LogicalPlan)command);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void saveAsTable(TableIdentifier tableIdent) {
        SessionCatalog catalog = this.df().sparkSession().sessionState().catalog();
        boolean tableExists = catalog.tableExists(tableIdent);
        String db = (String)tableIdent.database().getOrElse((Function0 & Serializable & scala.Serializable)() -> catalog.getCurrentDatabase());
        Some x$1 = new Some((Object)db);
        String x$2 = tableIdent.copy$default$1();
        TableIdentifier tableIdentWithDB = tableIdent.copy(x$2, (Option)x$1);
        String tableName = tableIdentWithDB.unquotedString();
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)tableExists), (Object)this.mode());
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)((Object)tuple2._2());
            if (bl && ((Object)((Object)SaveMode.Ignore)).equals((Object)saveMode)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)((Object)tuple2._2());
            if (bl && ((Object)((Object)SaveMode.ErrorIfExists)).equals((Object)saveMode)) {
                throw new AnalysisException(new StringBuilder(22).append("Table ").append(tableIdent).append(" already exists.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
        }
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)((Object)tuple2._2());
            if (bl && ((Object)((Object)SaveMode.Overwrite)).equals((Object)saveMode)) {
                HiveTableRelation hiveTableRelation;
                BaseRelation baseRelation;
                LogicalRelation logicalRelation;
                BaseRelation dest;
                Seq srcRelations = this.df().logicalPlan().collect((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        LogicalRelation logicalRelation;
                        BaseRelation src;
                        A1 A1 = x1;
                        if (A1 instanceof LogicalRelation && (src = (logicalRelation = (LogicalRelation)A1).relation()) != null) {
                            BaseRelation baseRelation = src;
                            object = baseRelation;
                        } else if (A1 instanceof HiveTableRelation) {
                            HiveTableRelation hiveTableRelation = (HiveTableRelation)A1;
                            object = hiveTableRelation.tableMeta().identifier();
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(LogicalPlan x1) {
                        LogicalRelation logicalRelation;
                        BaseRelation src;
                        LogicalPlan logicalPlan2 = x1;
                        boolean bl = logicalPlan2 instanceof LogicalRelation && (src = (logicalRelation = (LogicalRelation)logicalPlan2).relation()) != null ? true : logicalPlan2 instanceof HiveTableRelation;
                        return bl;
                    }
                });
                LogicalPlan tableRelation = this.df().sparkSession().table(tableIdentWithDB).queryExecution().analyzed();
                LogicalPlan logicalPlan2 = EliminateSubqueryAliases$.MODULE$.apply(tableRelation);
                if (logicalPlan2 instanceof LogicalRelation && (dest = (logicalRelation = (LogicalRelation)logicalPlan2).relation()) != null && srcRelations.contains((Object)(baseRelation = dest))) {
                    throw new AnalysisException(new StringBuilder(52).append("Cannot overwrite table ").append(tableName).append(" that is also being read from").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
                if (logicalPlan2 instanceof HiveTableRelation && srcRelations.contains((Object)(hiveTableRelation = (HiveTableRelation)logicalPlan2).tableMeta().identifier())) {
                    throw new AnalysisException(new StringBuilder(52).append("Cannot overwrite table ").append(tableName).append(" that is also being read from").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                catalog.dropTable(tableIdentWithDB, true, false);
                this.createTable(tableIdentWithDB);
                catalog.refreshTable(tableIdentWithDB);
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                return;
            }
        }
        this.createTable(tableIdent);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void createTable(TableIdentifier tableIdent) {
        CatalogStorageFormat storage = DataSource$.MODULE$.buildStorageFormatFromOptions((scala.collection.immutable.Map<String, String>)this.extraOptions().toMap());
        CatalogTableType tableType = storage.locationUri().isDefined() ? CatalogTableType$.MODULE$.EXTERNAL() : CatalogTableType$.MODULE$.MANAGED();
        CatalogTable tableDesc = new CatalogTable(tableIdent, tableType, storage, new StructType(), (Option)new Some((Object)this.source()), (Seq)this.partitioningColumns().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$), this.getBucketSpec(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19(), CatalogTable$.MODULE$.apply$default$20());
        this.runCommand(this.df().sparkSession(), "saveAsTable", new CreateTable(tableDesc, this.mode(), (Option<LogicalPlan>)new Some((Object)this.df().logicalPlan())));
    }

    private Seq<Transform> partitioningAsV2() {
        Seq partitioning = (Seq)this.partitioningColumns().map((Function1 & Serializable & scala.Serializable)colNames -> (Seq)colNames.map((Function1 & Serializable & scala.Serializable)name -> new IdentityTransform(FieldReference$.MODULE$.apply(name)), Seq$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
        Seq bucketing = Option$.MODULE$.option2Iterable(this.getBucketSpec().map((Function1 & Serializable & scala.Serializable)spec -> CatalogV2Implicits$.MODULE$.BucketSpecHelper(spec).asTransform())).toSeq();
        return (Seq)partitioning.$plus$plus((GenTraversableOnce)bucketing, Seq$.MODULE$.canBuildFrom());
    }

    private void checkPartitioningMatchesV2Table(Table existingTable) {
        Seq<Transform> v2Partitions = this.partitioningAsV2();
        if (v2Partitions.isEmpty()) {
            return;
        }
        Predef$.MODULE$.require(v2Partitions.sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])existingTable.partitioning())), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("The provided partitioning does not match of the table.\n").append(" - provided: ").append(v2Partitions.mkString(", ")).append("\n").append(" - table: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])existingTable.partitioning())).mkString(", ")).toString());
    }

    public void jdbc(String url, String table, Properties connectionProperties) {
        this.assertNotPartitioned("jdbc");
        this.assertNotBucketed("jdbc");
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(connectionProperties).asScala()));
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"url"), (Object)url), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dbtable"), (Object)table)}))));
        this.format("jdbc").save();
    }

    public void json(String path) {
        this.format("json").save(path);
    }

    public void parquet(String path) {
        this.format("parquet").save(path);
    }

    public void orc(String path) {
        this.format("orc").save(path);
    }

    public void text(String path) {
        this.format("text").save(path);
    }

    public void csv(String path) {
        this.format("csv").save(path);
    }

    private void runCommand(SparkSession session, String name, LogicalPlan command) {
        QueryExecution qe = session.sessionState().executePlan(command);
        SQLExecution$.MODULE$.withNewExecutionId(qe, (Option<String>)new Some((Object)name), (Function0 & Serializable & scala.Serializable)() -> qe.toRdd());
    }

    private Option<TableProvider> lookupV2Provider() {
        Some some;
        None$ none$ = DataSource$.MODULE$.lookupDataSourceV2(this.source(), this.df().sparkSession().sessionState().conf());
        None$ none$2 = none$ instanceof Some && (some = (Some)none$).value() instanceof FileDataSourceV2 ? None$.MODULE$ : none$;
        return none$2;
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private SaveMode mode() {
        return this.mode;
    }

    private void mode_$eq(SaveMode x$1) {
        this.mode = x$1;
    }

    private CaseInsensitiveMap<String> extraOptions() {
        return this.extraOptions;
    }

    private void extraOptions_$eq(CaseInsensitiveMap<String> x$1) {
        this.extraOptions = x$1;
    }

    private Option<Seq<String>> partitioningColumns() {
        return this.partitioningColumns;
    }

    private void partitioningColumns_$eq(Option<Seq<String>> x$1) {
        this.partitioningColumns = x$1;
    }

    private Option<Seq<String>> bucketColumnNames() {
        return this.bucketColumnNames;
    }

    private void bucketColumnNames_$eq(Option<Seq<String>> x$1) {
        this.bucketColumnNames = x$1;
    }

    private Option<Object> numBuckets() {
        return this.numBuckets;
    }

    private void numBuckets_$eq(Option<Object> x$1) {
        this.numBuckets = x$1;
    }

    private Option<Seq<String>> sortColumnNames() {
        return this.sortColumnNames;
    }

    private void sortColumnNames_$eq(Option<Seq<String>> x$1) {
        this.sortColumnNames = x$1;
    }

    public static final /* synthetic */ boolean $anonfun$saveInternal$1(CaseInsensitiveMap optionsWithPath$1, String x$3) {
        return !optionsWithPath$1.contains(x$3);
    }

    private final Table getTable$1(TableProvider provider$1, CaseInsensitiveStringMap dsOptions$1) {
        return provider$1.supportsExternalMetadata() ? provider$1.getTable(this.df().schema().asNullable(), (Transform[])this.partitioningAsV2().toArray(ClassTag$.MODULE$.apply(Transform.class)), dsOptions$1.asCaseSensitiveMap()) : DataSourceV2Utils$.MODULE$.getTableFromProvider(provider$1, dsOptions$1, (Option<StructType>)None$.MODULE$);
    }

    public static final /* synthetic */ BucketSpec $anonfun$getBucketSpec$1(DataFrameWriter $this, int n) {
        return new BucketSpec(n, (Seq)$this.bucketColumnNames().get(), (Seq)$this.sortColumnNames().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$));
    }

    public DataFrameWriter(Dataset<T> ds) {
        this.df = ds.toDF();
        this.source = this.df().sparkSession().sessionState().conf().defaultDataSourceName();
        this.mode = SaveMode.ErrorIfExists;
        this.extraOptions = CaseInsensitiveMap$.MODULE$.apply(Predef$.MODULE$.Map().empty());
        this.partitioningColumns = None$.MODULE$;
        this.bucketColumnNames = None$.MODULE$;
        this.numBuckets = None$.MODULE$;
        this.sortColumnNames = None$.MODULE$;
    }
}

