/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.CreateTableWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.WriteConfigMethods;
import org.apache.spark.sql.catalyst.analysis.NamedRelation;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Bucket;
import org.apache.spark.sql.catalyst.expressions.Days;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Hours;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Months;
import org.apache.spark.sql.catalyst.expressions.Years;
import org.apache.spark.sql.catalyst.plans.logical.AppendData;
import org.apache.spark.sql.catalyst.plans.logical.AppendData$;
import org.apache.spark.sql.catalyst.plans.logical.CreateTableAsSelectStatement;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OverwriteByExpression;
import org.apache.spark.sql.catalyst.plans.logical.OverwriteByExpression$;
import org.apache.spark.sql.catalyst.plans.logical.OverwritePartitionsDynamic;
import org.apache.spark.sql.catalyst.plans.logical.OverwritePartitionsDynamic$;
import org.apache.spark.sql.catalyst.plans.logical.ReplaceTableAsSelectStatement;
import org.apache.spark.sql.connector.expressions.LogicalExpressions$;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\t=a\u0001\u0002\u0013&\u00059B\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\t#\u0002\u0011\t\u0011)A\u0005%\"1Q\u000b\u0001C\u0001KYCqA\u0017\u0001C\u0002\u0013%1\f\u0003\u0004d\u0001\u0001\u0006I\u0001\u0018\u0005\bI\u0002\u0011\r\u0011\"\u0003f\u0011\u0019I\u0007\u0001)A\u0005M\"9!\u000e\u0001b\u0001\n\u0013Y\u0007B\u0002;\u0001A\u0003%A\u000eC\u0004v\u0001\t\u0007I\u0011\u0002<\t\u000f\u0005\r\u0001\u0001)A\u0005o\"I\u0011Q\u0001\u0001A\u0002\u0013%\u0011q\u0001\u0005\n\u0003\u001f\u0001\u0001\u0019!C\u0005\u0003#A\u0001\"!\b\u0001A\u0003&\u0011\u0011\u0002\u0005\n\u0003?\u0001!\u0019!C\u0005\u0003CA\u0001\"a\r\u0001A\u0003%\u00111\u0005\u0005\n\u0003k\u0001!\u0019!C\u0005\u0003CA\u0001\"a\u000e\u0001A\u0003%\u00111\u0005\u0005\n\u0003s\u0001\u0001\u0019!C\u0005\u0003wA\u0011\"!\u0015\u0001\u0001\u0004%I!a\u0015\t\u0011\u0005]\u0003\u0001)Q\u0005\u0003{Aq!!\u0017\u0001\t\u0003\nY\u0006C\u0004\u0002`\u0001!\t%!\u0019\t\u000f\u0005}\u0001\u0001\"\u0011\u0002l!9\u0011q\u0004\u0001\u0005B\u0005]\u0004bBAE\u0001\u0011\u0005\u00131\u0012\u0005\b\u0003'\u0003A\u0011IAK\u0011\u001d\tI\f\u0001C!\u0003wCq!!0\u0001\t\u0003\nY\fC\u0004\u0002@\u0002!\t%a/\t\u000f\u0005\u0005\u0007\u0001\"\u0001\u0002<\"9\u0011\u0011\u001c\u0001\u0005\u0002\u0005m\u0007bBAr\u0001\u0011\u0005\u00111\u0018\u0005\b\u0003O\u0004A\u0011BAu\u0011\u001d\t)\u0010\u0001C\u0005\u0003o\u0014\u0011\u0003R1uC\u001a\u0013\u0018-\\3Xe&$XM\u001d,3\u0015\t1s%A\u0002tc2T!\u0001K\u0015\u0002\u000bM\u0004\u0018M]6\u000b\u0005)Z\u0013AB1qC\u000eDWMC\u0001-\u0003\ry'oZ\u0002\u0001+\tyChE\u0002\u0001aY\u0002\"!\r\u001b\u000e\u0003IR\u0011aM\u0001\u0006g\u000e\fG.Y\u0005\u0003kI\u0012a!\u00118z%\u00164\u0007cA\u001c9u5\tQ%\u0003\u0002:K\t\t2I]3bi\u0016$\u0016M\u00197f/JLG/\u001a:\u0011\u0005mbD\u0002\u0001\u0003\u0006{\u0001\u0011\rA\u0010\u0002\u0002)F\u0011qH\u0011\t\u0003c\u0001K!!\u0011\u001a\u0003\u000f9{G\u000f[5oOB\u0011\u0011gQ\u0005\u0003\tJ\u00121!\u00118z\u0003\u0015!\u0018M\u00197f!\t9eJ\u0004\u0002I\u0019B\u0011\u0011JM\u0007\u0002\u0015*\u00111*L\u0001\u0007yI|w\u000e\u001e \n\u00055\u0013\u0014A\u0002)sK\u0012,g-\u0003\u0002P!\n11\u000b\u001e:j]\u001eT!!\u0014\u001a\u0002\u0005\u0011\u001c\bcA\u001cTu%\u0011A+\n\u0002\b\t\u0006$\u0018m]3u\u0003\u0019a\u0014N\\5u}Q\u0019q\u000bW-\u0011\u0007]\u0002!\bC\u0003F\u0007\u0001\u0007a\tC\u0003R\u0007\u0001\u0007!+\u0001\u0002eMV\tA\f\u0005\u0002^A:\u0011qGX\u0005\u0003?\u0016\nq\u0001]1dW\u0006<W-\u0003\u0002bE\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0003?\u0016\n1\u0001\u001a4!\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o+\u00051\u0007CA\u001ch\u0013\tAWE\u0001\u0007Ta\u0006\u00148nU3tg&|g.A\u0007ta\u0006\u00148nU3tg&|g\u000eI\u0001\ni\u0006\u0014G.\u001a(b[\u0016,\u0012\u0001\u001c\t\u0004[F4eB\u00018q\u001d\tIu.C\u00014\u0013\ty&'\u0003\u0002sg\n\u00191+Z9\u000b\u0005}\u0013\u0014A\u0003;bE2,g*Y7fA\u0005YAn\\4jG\u0006d\u0007\u000b\\1o+\u00059\bC\u0001=\u0000\u001b\u0005I(B\u0001>|\u0003\u001dawnZ5dC2T!\u0001`?\u0002\u000bAd\u0017M\\:\u000b\u0005y,\u0013\u0001C2bi\u0006d\u0017p\u001d;\n\u0007\u0005\u0005\u0011PA\u0006M_\u001eL7-\u00197QY\u0006t\u0017\u0001\u00047pO&\u001c\u0017\r\u001c)mC:\u0004\u0013\u0001\u00039s_ZLG-\u001a:\u0016\u0005\u0005%\u0001\u0003B\u0019\u0002\f\u0019K1!!\u00043\u0005\u0019y\u0005\u000f^5p]\u0006a\u0001O]8wS\u0012,'o\u0018\u0013fcR!\u00111CA\r!\r\t\u0014QC\u0005\u0004\u0003/\u0011$\u0001B+oSRD\u0011\"a\u0007\u000e\u0003\u0003\u0005\r!!\u0003\u0002\u0007a$\u0013'A\u0005qe>4\u0018\u000eZ3sA\u00059q\u000e\u001d;j_:\u001cXCAA\u0012!\u0019\t)#a\fG\r6\u0011\u0011q\u0005\u0006\u0005\u0003S\tY#A\u0004nkR\f'\r\\3\u000b\u0007\u00055\"'\u0001\u0006d_2dWm\u0019;j_:LA!!\r\u0002(\t9\u0001*Y:i\u001b\u0006\u0004\u0018\u0001C8qi&|gn\u001d\u0011\u0002\u0015A\u0014x\u000e]3si&,7/A\u0006qe>\u0004XM\u001d;jKN\u0004\u0013\u0001\u00049beRLG/[8oS:<WCAA\u001f!\u0015\t\u00141BA !\u0011i\u0017/!\u0011\u0011\t\u0005\r\u0013QJ\u0007\u0003\u0003\u000bRA!a\u0012\u0002J\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\r\tY%J\u0001\nG>tg.Z2u_JLA!a\u0014\u0002F\tIAK]1og\u001a|'/\\\u0001\u0011a\u0006\u0014H/\u001b;j_:LgnZ0%KF$B!a\u0005\u0002V!I\u00111\u0004\u000b\u0002\u0002\u0003\u0007\u0011QH\u0001\u000ea\u0006\u0014H/\u001b;j_:Lgn\u001a\u0011\u0002\u000bU\u001c\u0018N\\4\u0015\u0007Y\ni\u0006\u0003\u0004\u0002\u0006Y\u0001\rAR\u0001\u0007_B$\u0018n\u001c8\u0015\u000b]\u000b\u0019'a\u001a\t\r\u0005\u0015t\u00031\u0001G\u0003\rYW-\u001f\u0005\u0007\u0003S:\u0002\u0019\u0001$\u0002\u000bY\fG.^3\u0015\u0007]\u000bi\u0007C\u0004\u0002 a\u0001\r!a\u001c\u0011\r\u0005E\u00141\u000f$G\u001b\t\tY#\u0003\u0003\u0002v\u0005-\"aA'baR\u0019q+!\u001f\t\u000f\u0005}\u0011\u00041\u0001\u0002|A1\u0011QPAD\r\u001ak!!a \u000b\t\u0005\u0005\u00151Q\u0001\u0005kRLGN\u0003\u0002\u0002\u0006\u0006!!.\u0019<b\u0013\u0011\t)(a \u0002\u001bQ\f'\r\\3Qe>\u0004XM\u001d;z)\u00151\u0014QRAI\u0011\u0019\tyI\u0007a\u0001\r\u0006A\u0001O]8qKJ$\u0018\u0010\u0003\u0004\u0002ji\u0001\rAR\u0001\u000ea\u0006\u0014H/\u001b;j_:,GMQ=\u0015\u000bY\n9*!)\t\u000f\u0005e5\u00041\u0001\u0002\u001c\u000611m\u001c7v[:\u00042aNAO\u0013\r\ty*\n\u0002\u0007\u0007>dW/\u001c8\t\u000f\u0005\r6\u00041\u0001\u0002&\u000691m\u001c7v[:\u001c\b#B\u0019\u0002(\u0006m\u0015bAAUe\tQAH]3qK\u0006$X\r\u001a )\u0007m\ti\u000b\u0005\u0003\u00020\u0006UVBAAY\u0015\r\t\u0019LM\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\\\u0003c\u0013qA^1sCJ<7/\u0001\u0004de\u0016\fG/\u001a\u000b\u0003\u0003'\tqA]3qY\u0006\u001cW-A\bde\u0016\fG/Z(s%\u0016\u0004H.Y2f\u0003\u0019\t\u0007\u000f]3oI\"*q$!2\u0002XB)\u0011'a2\u0002L&\u0019\u0011\u0011\u001a\u001a\u0003\rQD'o\\<t!\u0011\ti-a5\u000e\u0005\u0005='bAAi{\u0006A\u0011M\\1msNL7/\u0003\u0003\u0002V\u0006='\u0001\u0006(p'V\u001c\u0007\u000eV1cY\u0016,\u0005pY3qi&|gn\t\u0002\u0002L\u0006IqN^3soJLG/\u001a\u000b\u0005\u0003'\ti\u000eC\u0004\u0002`\u0002\u0002\r!a'\u0002\u0013\r|g\u000eZ5uS>t\u0007&\u0002\u0011\u0002F\u0006]\u0017aE8wKJ<(/\u001b;f!\u0006\u0014H/\u001b;j_:\u001c\b&B\u0011\u0002F\u0006]\u0017A\u0003:v]\u000e{W.\\1oIR!\u00111^Ay)\u0011\t\u0019\"!<\t\r\u0005=(\u00051\u0001x\u0003\u001d\u0019w.\\7b]\u0012Da!a=#\u0001\u00041\u0015\u0001\u00028b[\u0016\fq\"\u001b8uKJt\u0017\r\u001c*fa2\f7-\u001a\u000b\u0005\u0003'\tI\u0010C\u0004\u0002|\u000e\u0002\r!!@\u0002\u0011=\u00148I]3bi\u0016\u00042!MA\u0000\u0013\r\u0011\tA\r\u0002\b\u0005>|G.Z1oQ\r\u0001!Q\u0001\t\u0005\u0005\u000f\u0011Y!\u0004\u0002\u0003\n)\u0019\u00111W\u0014\n\t\t5!\u0011\u0002\u0002\r\u000bb\u0004XM]5nK:$\u0018\r\u001c")
public final class DataFrameWriterV2<T>
implements CreateTableWriter<T> {
    private final Dataset<Row> df;
    private final SparkSession sparkSession;
    private final Seq<String> tableName;
    private final LogicalPlan logicalPlan;
    private Option<String> provider;
    private final HashMap<String, String> options;
    private final HashMap<String, String> properties;
    private Option<Seq<Transform>> partitioning;

    @Override
    public Object option(String key, boolean value) {
        return WriteConfigMethods.option$((WriteConfigMethods)this, key, value);
    }

    @Override
    public Object option(String key, long value) {
        return WriteConfigMethods.option$((WriteConfigMethods)this, key, value);
    }

    @Override
    public Object option(String key, double value) {
        return WriteConfigMethods.option$((WriteConfigMethods)this, key, value);
    }

    public CreateTableWriter<T> partitionedBy(Column column, Column ... columns) {
        return this.partitionedBy(column, (Seq<Column>)Predef$.MODULE$.wrapRefArray((Object[])columns));
    }

    private Dataset<Row> df() {
        return this.df;
    }

    private SparkSession sparkSession() {
        return this.sparkSession;
    }

    private Seq<String> tableName() {
        return this.tableName;
    }

    private LogicalPlan logicalPlan() {
        return this.logicalPlan;
    }

    private Option<String> provider() {
        return this.provider;
    }

    private void provider_$eq(Option<String> x$1) {
        this.provider = x$1;
    }

    private HashMap<String, String> options() {
        return this.options;
    }

    private HashMap<String, String> properties() {
        return this.properties;
    }

    private Option<Seq<Transform>> partitioning() {
        return this.partitioning;
    }

    private void partitioning_$eq(Option<Seq<Transform>> x$1) {
        this.partitioning = x$1;
    }

    @Override
    public CreateTableWriter<T> using(String provider) {
        this.provider_$eq((Option<String>)new Some((Object)provider));
        return this;
    }

    @Override
    public DataFrameWriterV2<T> option(String key, String value) {
        this.options().put((Object)key, (Object)value);
        return this;
    }

    @Override
    public DataFrameWriterV2<T> options(Map<String, String> options) {
        options.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            Option option = this.options().put((Object)key, (Object)value);
            return option;
        });
        return this;
    }

    @Override
    public DataFrameWriterV2<T> options(java.util.Map<String, String> options) {
        this.options((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala());
        return this;
    }

    @Override
    public CreateTableWriter<T> tableProperty(String property, String value) {
        this.properties().put((Object)property, (Object)value);
        return this;
    }

    @Override
    public CreateTableWriter<T> partitionedBy(Column column, Seq<Column> columns) {
        Column column2 = column;
        Seq asTransforms = (Seq)((TraversableLike)((TraversableLike)columns.$plus$colon((Object)column2, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.expr(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Hours hours;
            Expression attr;
            Days days;
            Expression attr2;
            Months months;
            Expression attr3;
            Years years;
            Expression attr4;
            Expression expression = x0$1;
            if (expression instanceof Years && (attr4 = (years = (Years)expression).child()) instanceof Attribute) {
                Attribute attribute = (Attribute)attr4;
                return LogicalExpressions$.MODULE$.years(DataFrameWriterV2.ref$1(attribute.name()));
            }
            if (expression instanceof Months && (attr3 = (months = (Months)expression).child()) instanceof Attribute) {
                Attribute attribute = (Attribute)attr3;
                return LogicalExpressions$.MODULE$.months(DataFrameWriterV2.ref$1(attribute.name()));
            }
            if (expression instanceof Days && (attr2 = (days = (Days)expression).child()) instanceof Attribute) {
                Attribute attribute = (Attribute)attr2;
                return LogicalExpressions$.MODULE$.days(DataFrameWriterV2.ref$1(attribute.name()));
            }
            if (expression instanceof Hours && (attr = (hours = (Hours)expression).child()) instanceof Attribute) {
                Attribute attribute = (Attribute)attr;
                return LogicalExpressions$.MODULE$.hours(DataFrameWriterV2.ref$1(attribute.name()));
            }
            if (expression instanceof Bucket) {
                Bucket bucket = (Bucket)expression;
                Literal literal = bucket.numBuckets();
                Expression attr5 = bucket.child();
                if (literal != null) {
                    Object numBuckets = literal.value();
                    DataType dataType = literal.dataType();
                    if (numBuckets instanceof Integer) {
                        int n = BoxesRunTime.unboxToInt((Object)numBuckets);
                        if (IntegerType$.MODULE$.equals(dataType) && attr5 instanceof Attribute) {
                            Attribute attribute = (Attribute)attr5;
                            return LogicalExpressions$.MODULE$.bucket(n, (NamedReference[])((Object[])new NamedReference[]{DataFrameWriterV2.ref$1(attribute.name())}));
                        }
                    }
                }
            }
            if (!(expression instanceof Attribute)) throw new AnalysisException(new StringBuilder(34).append("Invalid partition transformation: ").append(expression.sql()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            Attribute attribute = (Attribute)expression;
            return LogicalExpressions$.MODULE$.identity(DataFrameWriterV2.ref$1(attribute.name()));
        }, Seq$.MODULE$.canBuildFrom());
        this.partitioning_$eq((Option<Seq<Transform>>)new Some((Object)asTransforms));
        return this;
    }

    @Override
    public void create() {
        Seq<String> x$1 = this.tableName();
        LogicalPlan x$2 = this.logicalPlan();
        Seq x$3 = (Seq)this.partitioning().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
        None$ x$4 = None$.MODULE$;
        scala.collection.immutable.Map x$5 = this.properties().toMap(Predef$.MODULE$.$conforms());
        Option<String> x$6 = this.provider();
        scala.collection.immutable.Map x$7 = Predef$.MODULE$.Map().empty();
        None$ x$8 = None$.MODULE$;
        None$ x$9 = None$.MODULE$;
        scala.collection.immutable.Map x$10 = this.options().toMap(Predef$.MODULE$.$conforms());
        None$ x$11 = None$.MODULE$;
        boolean x$12 = false;
        boolean x$13 = false;
        this.runCommand("create", (LogicalPlan)new CreateTableAsSelectStatement(x$1, x$2, x$3, (Option)x$4, x$5, x$6, x$7, (Option)x$8, (Option)x$9, x$10, (Option)x$11, x$13, x$12));
    }

    @Override
    public void replace() {
        this.internalReplace(false);
    }

    @Override
    public void createOrReplace() {
        this.internalReplace(true);
    }

    public void append() throws NoSuchTableException {
        AppendData append = AppendData$.MODULE$.byName((NamedRelation)new UnresolvedRelation(this.tableName(), UnresolvedRelation$.MODULE$.apply$default$2(), UnresolvedRelation$.MODULE$.apply$default$3()), this.logicalPlan(), this.options().toMap(Predef$.MODULE$.$conforms()));
        this.runCommand("append", (LogicalPlan)append);
    }

    public void overwrite(Column condition) throws NoSuchTableException {
        OverwriteByExpression overwrite = OverwriteByExpression$.MODULE$.byName((NamedRelation)new UnresolvedRelation(this.tableName(), UnresolvedRelation$.MODULE$.apply$default$2(), UnresolvedRelation$.MODULE$.apply$default$3()), this.logicalPlan(), condition.expr(), this.options().toMap(Predef$.MODULE$.$conforms()));
        this.runCommand("overwrite", (LogicalPlan)overwrite);
    }

    public void overwritePartitions() throws NoSuchTableException {
        OverwritePartitionsDynamic dynamicOverwrite = OverwritePartitionsDynamic$.MODULE$.byName((NamedRelation)new UnresolvedRelation(this.tableName(), UnresolvedRelation$.MODULE$.apply$default$2(), UnresolvedRelation$.MODULE$.apply$default$3()), this.logicalPlan(), this.options().toMap(Predef$.MODULE$.$conforms()));
        this.runCommand("overwritePartitions", (LogicalPlan)dynamicOverwrite);
    }

    private void runCommand(String name, LogicalPlan command) {
        QueryExecution qe = this.sparkSession().sessionState().executePlan(command);
        SQLExecution$.MODULE$.withNewExecutionId(qe, (Option<String>)new Some((Object)name), (Function0 & Serializable & scala.Serializable)() -> qe.toRdd());
    }

    private void internalReplace(boolean orCreate) {
        this.runCommand("replace", (LogicalPlan)new ReplaceTableAsSelectStatement(this.tableName(), this.logicalPlan(), (Seq)this.partitioning().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty()), (Option)None$.MODULE$, this.properties().toMap(Predef$.MODULE$.$conforms()), this.provider(), Predef$.MODULE$.Map().empty(), (Option)None$.MODULE$, (Option)None$.MODULE$, this.options().toMap(Predef$.MODULE$.$conforms()), (Option)None$.MODULE$, orCreate));
    }

    private static final NamedReference ref$1(String name) {
        return LogicalExpressions$.MODULE$.parseReference(name);
    }

    public DataFrameWriterV2(String table, Dataset<T> ds) {
        WriteConfigMethods.$init$(this);
        this.df = ds.toDF();
        this.sparkSession = ds.sparkSession();
        this.tableName = this.sparkSession().sessionState().sqlParser().parseMultipartIdentifier(table);
        this.logicalPlan = this.df().queryExecution().logical();
        this.provider = None$.MODULE$;
        this.options = new HashMap();
        this.properties = new HashMap();
        this.partitioning = None$.MODULE$;
    }
}

