/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.execution.command.CreateTableLikeCommand$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple6;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005uh\u0001B\u0013'\u0001NB\u0001b\u0013\u0001\u0003\u0016\u0004%\t\u0001\u0014\u0005\t#\u0002\u0011\t\u0012)A\u0005\u001b\"A!\u000b\u0001BK\u0002\u0013\u0005A\n\u0003\u0005T\u0001\tE\t\u0015!\u0003N\u0011!!\u0006A!f\u0001\n\u0003)\u0006\u0002\u0003/\u0001\u0005#\u0005\u000b\u0011\u0002,\t\u0011u\u0003!Q3A\u0005\u0002yC\u0001\"\u001c\u0001\u0003\u0012\u0003\u0006Ia\u0018\u0005\t]\u0002\u0011)\u001a!C\u0001_\"A1\u000f\u0001B\tB\u0003%\u0001\u000f\u0003\u0005u\u0001\tU\r\u0011\"\u0001v\u0011!I\bA!E!\u0002\u00131\b\"\u0002>\u0001\t\u0003Y\bbBA\u0004\u0001\u0011\u0005\u0013\u0011\u0002\u0005\n\u0003_\u0001\u0011\u0011!C\u0001\u0003cA\u0011\"a\u0010\u0001#\u0003%\t!!\u0011\t\u0013\u0005]\u0003!%A\u0005\u0002\u0005\u0005\u0003\"CA-\u0001E\u0005I\u0011AA.\u0011%\ty\u0006AI\u0001\n\u0003\t\t\u0007C\u0005\u0002f\u0001\t\n\u0011\"\u0001\u0002h!I\u00111\u000e\u0001\u0012\u0002\u0013\u0005\u0011Q\u000e\u0005\n\u0003c\u0002\u0011\u0011!C!\u0003gB\u0011\"a!\u0001\u0003\u0003%\t!!\"\t\u0013\u00055\u0005!!A\u0005\u0002\u0005=\u0005\"CAN\u0001\u0005\u0005I\u0011IAO\u0011%\tY\u000bAA\u0001\n\u0003\ti\u000bC\u0005\u00022\u0002\t\t\u0011\"\u0011\u00024\u001eI\u0011q\u0017\u0014\u0002\u0002#\u0005\u0011\u0011\u0018\u0004\tK\u0019\n\t\u0011#\u0001\u0002<\"1!0\bC\u0001\u0003\u0013D\u0011\"a3\u001e\u0003\u0003%)%!4\t\u0013\u0005=W$!A\u0005\u0002\u0006E\u0007\"CAp;E\u0005I\u0011AA4\u0011%\t\t/HA\u0001\n\u0003\u000b\u0019\u000fC\u0005\u0002rv\t\n\u0011\"\u0001\u0002h!I\u00111_\u000f\u0002\u0002\u0013%\u0011Q\u001f\u0002\u0017\u0007J,\u0017\r^3UC\ndW\rT5lK\u000e{W.\\1oI*\u0011q\u0005K\u0001\bG>lW.\u00198e\u0015\tI#&A\u0005fq\u0016\u001cW\u000f^5p]*\u00111\u0006L\u0001\u0004gFd'BA\u0017/\u0003\u0015\u0019\b/\u0019:l\u0015\ty\u0003'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002c\u0005\u0019qN]4\u0004\u0001M)\u0001\u0001\u000e C\u0011B\u0011Q\u0007P\u0007\u0002m)\u0011q\u0007O\u0001\bY><\u0017nY1m\u0015\tI$(A\u0003qY\u0006t7O\u0003\u0002<U\u0005A1-\u0019;bYf\u001cH/\u0003\u0002>m\tYAj\\4jG\u0006d\u0007\u000b\\1o!\ty\u0004)D\u0001'\u0013\t\teEA\bSk:t\u0017M\u00197f\u0007>lW.\u00198e!\t\u0019e)D\u0001E\u0015\u0005)\u0015!B:dC2\f\u0017BA$E\u0005\u001d\u0001&o\u001c3vGR\u0004\"aQ%\n\u0005)#%\u0001D*fe&\fG.\u001b>bE2,\u0017a\u0003;be\u001e,G\u000fV1cY\u0016,\u0012!\u0014\t\u0003\u001d>k\u0011AO\u0005\u0003!j\u0012q\u0002V1cY\u0016LE-\u001a8uS\u001aLWM]\u0001\ri\u0006\u0014x-\u001a;UC\ndW\rI\u0001\fg>,(oY3UC\ndW-\u0001\u0007t_V\u00148-\u001a+bE2,\u0007%\u0001\u0006gS2,gi\u001c:nCR,\u0012A\u0016\t\u0003/jk\u0011\u0001\u0017\u0006\u00033j\nqaY1uC2|w-\u0003\u0002\\1\n!2)\u0019;bY><7\u000b^8sC\u001e,gi\u001c:nCR\f1BZ5mK\u001a{'/\\1uA\u0005A\u0001O]8wS\u0012,'/F\u0001`!\r\u0019\u0005MY\u0005\u0003C\u0012\u0013aa\u00149uS>t\u0007CA2k\u001d\t!\u0007\u000e\u0005\u0002f\t6\taM\u0003\u0002he\u00051AH]8pizJ!!\u001b#\u0002\rA\u0013X\rZ3g\u0013\tYGN\u0001\u0004TiJLgn\u001a\u0006\u0003S\u0012\u000b\u0011\u0002\u001d:pm&$WM\u001d\u0011\u0002\u0015A\u0014x\u000e]3si&,7/F\u0001q!\u0011\u0019\u0017O\u00192\n\u0005Id'aA'ba\u0006Y\u0001O]8qKJ$\u0018.Z:!\u0003-IgMT8u\u000bbL7\u000f^:\u0016\u0003Y\u0004\"aQ<\n\u0005a$%a\u0002\"p_2,\u0017M\\\u0001\rS\u001atu\u000e^#ySN$8\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0015qlhp`A\u0001\u0003\u0007\t)\u0001\u0005\u0002@\u0001!)1*\u0004a\u0001\u001b\")!+\u0004a\u0001\u001b\")A+\u0004a\u0001-\")Q,\u0004a\u0001?\"9a.\u0004I\u0001\u0002\u0004\u0001\b\"\u0002;\u000e\u0001\u00041\u0018a\u0001:v]R!\u00111BA\u0013!\u0019\ti!a\u0006\u0002\u001e9!\u0011qBA\n\u001d\r)\u0017\u0011C\u0005\u0002\u000b&\u0019\u0011Q\u0003#\u0002\u000fA\f7m[1hK&!\u0011\u0011DA\u000e\u0005\r\u0019V-\u001d\u0006\u0004\u0003+!\u0005\u0003BA\u0010\u0003Ci\u0011AK\u0005\u0004\u0003GQ#a\u0001*po\"9\u0011q\u0005\bA\u0002\u0005%\u0012\u0001D:qCJ\\7+Z:tS>t\u0007\u0003BA\u0010\u0003WI1!!\f+\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003\u0011\u0019w\u000e]=\u0015\u001bq\f\u0019$!\u000e\u00028\u0005e\u00121HA\u001f\u0011\u001dYu\u0002%AA\u00025CqAU\b\u0011\u0002\u0003\u0007Q\nC\u0004U\u001fA\u0005\t\u0019\u0001,\t\u000fu{\u0001\u0013!a\u0001?\"9an\u0004I\u0001\u0002\u0004\u0001\bb\u0002;\u0010!\u0003\u0005\rA^\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\u0019EK\u0002N\u0003\u000bZ#!a\u0012\u0011\t\u0005%\u00131K\u0007\u0003\u0003\u0017RA!!\u0014\u0002P\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003#\"\u0015AC1o]>$\u0018\r^5p]&!\u0011QKA&\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!!\u0018+\u0007Y\u000b)%\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005\r$fA0\u0002F\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012*TCAA5U\r\u0001\u0018QI\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00137+\t\tyGK\u0002w\u0003\u000b\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA;!\u0011\t9(!!\u000e\u0005\u0005e$\u0002BA>\u0003{\nA\u0001\\1oO*\u0011\u0011qP\u0001\u0005U\u00064\u0018-C\u0002l\u0003s\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\"\u0011\u0007\r\u000bI)C\u0002\u0002\f\u0012\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!%\u0002\u0018B\u00191)a%\n\u0007\u0005UEIA\u0002B]fD\u0011\"!'\u0019\u0003\u0003\u0005\r!a\"\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ty\n\u0005\u0004\u0002\"\u0006\u001d\u0016\u0011S\u0007\u0003\u0003GS1!!*E\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003S\u000b\u0019K\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u0001<\u00020\"I\u0011\u0011\u0014\u000e\u0002\u0002\u0003\u0007\u0011\u0011S\u0001\u0007KF,\u0018\r\\:\u0015\u0007Y\f)\fC\u0005\u0002\u001an\t\t\u00111\u0001\u0002\u0012\u000612I]3bi\u0016$\u0016M\u00197f\u0019&\\WmQ8n[\u0006tG\r\u0005\u0002@;M!Q$!0I!-\ty,!2N\u001bZ{\u0006O\u001e?\u000e\u0005\u0005\u0005'bAAb\t\u00069!/\u001e8uS6,\u0017\u0002BAd\u0003\u0003\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c87)\t\tI,\u0001\u0005u_N#(/\u001b8h)\t\t)(A\u0003baBd\u0017\u0010F\u0007}\u0003'\f).a6\u0002Z\u0006m\u0017Q\u001c\u0005\u0006\u0017\u0002\u0002\r!\u0014\u0005\u0006%\u0002\u0002\r!\u0014\u0005\u0006)\u0002\u0002\rA\u0016\u0005\u0006;\u0002\u0002\ra\u0018\u0005\b]\u0002\u0002\n\u00111\u0001q\u0011\u0015!\b\u00051\u0001w\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012*\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0003K\fi\u000f\u0005\u0003DA\u0006\u001d\b#C\"\u0002j6kek\u00189w\u0013\r\tY\u000f\u0012\u0002\u0007)V\u0004H.\u001a\u001c\t\u0011\u0005=(%!AA\u0002q\f1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%k\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t9\u0010\u0005\u0003\u0002x\u0005e\u0018\u0002BA~\u0003s\u0012aa\u00142kK\u000e$\b")
public class CreateTableLikeCommand
extends LogicalPlan
implements RunnableCommand,
Serializable {
    private final TableIdentifier targetTable;
    private final TableIdentifier sourceTable;
    private final CatalogStorageFormat fileFormat;
    private final Option<String> provider;
    private final Map<String, String> properties;
    private final boolean ifNotExists;
    private Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Map<String, String> $lessinit$greater$default$5() {
        return CreateTableLikeCommand$.MODULE$.$lessinit$greater$default$5();
    }

    public static Option<Tuple6<TableIdentifier, TableIdentifier, CatalogStorageFormat, Option<String>, Map<String, String>, Object>> unapply(CreateTableLikeCommand createTableLikeCommand) {
        return CreateTableLikeCommand$.MODULE$.unapply(createTableLikeCommand);
    }

    public static Map<String, String> apply$default$5() {
        return CreateTableLikeCommand$.MODULE$.apply$default$5();
    }

    public static Function1<Tuple6<TableIdentifier, TableIdentifier, CatalogStorageFormat, Option<String>, Map<String, String>, Object>, CreateTableLikeCommand> tupled() {
        return CreateTableLikeCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<TableIdentifier, Function1<CatalogStorageFormat, Function1<Option<String>, Function1<Map<String, String>, Function1<Object, CreateTableLikeCommand>>>>>> curried() {
        return CreateTableLikeCommand$.MODULE$.curried();
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.children$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        CreateTableLikeCommand createTableLikeCommand = this;
        synchronized (createTableLikeCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public TableIdentifier targetTable() {
        return this.targetTable;
    }

    public TableIdentifier sourceTable() {
        return this.sourceTable;
    }

    public CatalogStorageFormat fileFormat() {
        return this.fileFormat;
    }

    public Option<String> provider() {
        return this.provider;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        Object object;
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        CatalogTable sourceTableDesc = catalog.getTempViewOrPermanentTableMetadata(this.sourceTable());
        if (this.provider().isDefined()) {
            Object object2 = !DDLUtils$.MODULE$.isHiveTable(this.provider()) ? DataSource$.MODULE$.lookupDataSource((String)this.provider().get(), sparkSession.sessionState().conf()) : BoxedUnit.UNIT;
            object = this.provider();
        } else {
            CatalogTableType catalogTableType = sourceTableDesc.tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
            object = !(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null) ? new Some((Object)sparkSession.sessionState().conf().defaultDataSourceName()) : (this.fileFormat().inputFormat().isDefined() ? new Some((Object)DDLUtils$.MODULE$.HIVE_PROVIDER()) : sourceTableDesc.provider());
        }
        Some newProvider = object;
        CatalogStorageFormat newStorage = this.fileFormat().inputFormat().isDefined() ? this.fileFormat() : sourceTableDesc.storage().copy(this.fileFormat().locationUri(), sourceTableDesc.storage().copy$default$2(), sourceTableDesc.storage().copy$default$3(), sourceTableDesc.storage().copy$default$4(), sourceTableDesc.storage().copy$default$5(), sourceTableDesc.storage().copy$default$6());
        CatalogTableType tblType = newStorage.locationUri().isEmpty() ? CatalogTableType$.MODULE$.MANAGED() : CatalogTableType$.MODULE$.EXTERNAL();
        StructType newTableSchema = CharVarcharUtils$.MODULE$.getRawSchema(sourceTableDesc.schema());
        TableIdentifier x$1 = this.targetTable();
        CatalogTableType x$2 = tblType;
        CatalogStorageFormat x$3 = newStorage;
        StructType x$4 = newTableSchema;
        Some x$5 = newProvider;
        Seq x$6 = sourceTableDesc.partitionColumnNames();
        Option x$7 = sourceTableDesc.bucketSpec();
        Map<String, String> x$8 = this.properties();
        boolean x$9 = sourceTableDesc.tracksPartitionsInCatalog();
        String x$10 = CatalogTable$.MODULE$.apply$default$8();
        long x$11 = CatalogTable$.MODULE$.apply$default$9();
        long x$12 = CatalogTable$.MODULE$.apply$default$10();
        String x$13 = CatalogTable$.MODULE$.apply$default$11();
        Option x$14 = CatalogTable$.MODULE$.apply$default$13();
        Option x$15 = CatalogTable$.MODULE$.apply$default$14();
        Option x$16 = CatalogTable$.MODULE$.apply$default$15();
        Seq x$17 = CatalogTable$.MODULE$.apply$default$16();
        boolean x$18 = CatalogTable$.MODULE$.apply$default$18();
        Map x$19 = CatalogTable$.MODULE$.apply$default$19();
        Option x$20 = CatalogTable$.MODULE$.apply$default$20();
        CatalogTable newTableDesc = new CatalogTable(x$1, x$2, x$3, x$4, (Option)x$5, x$6, x$7, x$10, x$11, x$12, x$13, x$8, x$14, x$15, x$16, x$17, x$9, x$18, x$19, x$20);
        catalog.createTable(newTableDesc, this.ifNotExists(), catalog.createTable$default$3());
        return (Seq)Seq$.MODULE$.empty();
    }

    public CreateTableLikeCommand copy(TableIdentifier targetTable, TableIdentifier sourceTable, CatalogStorageFormat fileFormat, Option<String> provider, Map<String, String> properties, boolean ifNotExists) {
        return new CreateTableLikeCommand(targetTable, sourceTable, fileFormat, provider, properties, ifNotExists);
    }

    public TableIdentifier copy$default$1() {
        return this.targetTable();
    }

    public TableIdentifier copy$default$2() {
        return this.sourceTable();
    }

    public CatalogStorageFormat copy$default$3() {
        return this.fileFormat();
    }

    public Option<String> copy$default$4() {
        return this.provider();
    }

    public Map<String, String> copy$default$5() {
        return this.properties();
    }

    public boolean copy$default$6() {
        return this.ifNotExists();
    }

    public String productPrefix() {
        return "CreateTableLikeCommand";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.targetTable();
                break;
            }
            case 1: {
                object = this.sourceTable();
                break;
            }
            case 2: {
                object = this.fileFormat();
                break;
            }
            case 3: {
                object = this.provider();
                break;
            }
            case 4: {
                object = this.properties();
                break;
            }
            case 5: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ifNotExists());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CreateTableLikeCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CreateTableLikeCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        CreateTableLikeCommand createTableLikeCommand = (CreateTableLikeCommand)x$1;
        TableIdentifier tableIdentifier = this.targetTable();
        TableIdentifier tableIdentifier2 = createTableLikeCommand.targetTable();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        TableIdentifier tableIdentifier3 = this.sourceTable();
        TableIdentifier tableIdentifier4 = createTableLikeCommand.sourceTable();
        if (tableIdentifier3 == null) {
            if (tableIdentifier4 != null) {
                return false;
            }
        } else if (!tableIdentifier3.equals(tableIdentifier4)) return false;
        CatalogStorageFormat catalogStorageFormat = this.fileFormat();
        CatalogStorageFormat catalogStorageFormat2 = createTableLikeCommand.fileFormat();
        if (catalogStorageFormat == null) {
            if (catalogStorageFormat2 != null) {
                return false;
            }
        } else if (!catalogStorageFormat.equals(catalogStorageFormat2)) return false;
        Option<String> option = this.provider();
        Option<String> option2 = createTableLikeCommand.provider();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Map<String, String> map = this.properties();
        Map<String, String> map2 = createTableLikeCommand.properties();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        if (this.ifNotExists() != createTableLikeCommand.ifNotExists()) return false;
        if (!createTableLikeCommand.canEqual(this)) return false;
        return true;
    }

    public CreateTableLikeCommand(TableIdentifier targetTable, TableIdentifier sourceTable, CatalogStorageFormat fileFormat, Option<String> provider, Map<String, String> properties, boolean ifNotExists) {
        this.targetTable = targetTable;
        this.sourceTable = sourceTable;
        this.fileFormat = fileFormat;
        this.provider = provider;
        this.properties = properties;
        this.ifNotExists = ifNotExists;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
    }
}

