/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import java.util.Locale;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkUpgradeException;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogUtils$;
import org.apache.spark.sql.catalyst.util.RebaseDateTime$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.package$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.util.Utils$;
import org.json4s.Formats;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.jackson.Serialization$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenSetLike;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class DataSourceUtils$ {
    public static DataSourceUtils$ MODULE$;
    private final String PARTITIONING_COLUMNS_KEY;
    private final Formats formats;

    static {
        new DataSourceUtils$();
    }

    public String PARTITIONING_COLUMNS_KEY() {
        return this.PARTITIONING_COLUMNS_KEY;
    }

    private Formats formats() {
        return this.formats;
    }

    public String encodePartitioningColumns(Seq<String> columns) {
        return Serialization$.MODULE$.write(columns, this.formats());
    }

    public Seq<String> decodePartitioningColumns(String str) {
        return (Seq)Serialization$.MODULE$.read(str, this.formats(), ManifestFactory$.MODULE$.classType(Seq.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
    }

    public void verifySchema(FileFormat format, StructType schema) {
        schema.foreach((Function1 & Serializable & scala.Serializable)field -> {
            DataSourceUtils$.$anonfun$verifySchema$1(format, field);
            return BoxedUnit.UNIT;
        });
    }

    public boolean isDataPath(Path path) {
        return this.isDataFile(path.getName());
    }

    public boolean isDataFile(String fileName) {
        return !fileName.startsWith("_") && !fileName.startsWith(".");
    }

    public boolean supportNestedPredicatePushdown(BaseRelation relation) {
        boolean bl;
        BaseRelation baseRelation = relation;
        if (baseRelation instanceof HadoopFsRelation) {
            HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)baseRelation;
            Seq supportedDatasources = Utils$.MODULE$.stringToSeq(((String)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.NESTED_PREDICATE_PUSHDOWN_FILE_SOURCE_LIST())).toLowerCase(Locale.ROOT));
            bl = supportedDatasources.contains((Object)hadoopFsRelation.toString());
        } else {
            bl = false;
        }
        return bl;
    }

    public Enumeration.Value datetimeRebaseMode(Function1<String, String> lookupFileMeta, String modeByConfig) {
        if (Utils$.MODULE$.isTesting()) {
            String string = SQLConf$.MODULE$.get().getConfString("spark.test.forceNoRebase", "");
            String string2 = "true";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED();
            }
        }
        return (Enumeration.Value)Option$.MODULE$.apply(lookupFileMeta.apply((Object)package$.MODULE$.SPARK_VERSION_METADATA_KEY())).map((Function1 & Serializable & scala.Serializable)version -> new StringOps(Predef$.MODULE$.augmentString(version)).$less((Object)"3.0.0") || lookupFileMeta.apply((Object)package$.MODULE$.SPARK_LEGACY_DATETIME()) != null ? SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY() : SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED()).getOrElse((Function0 & Serializable & scala.Serializable)() -> SQLConf.LegacyBehaviorPolicy$.MODULE$.withName(modeByConfig));
    }

    public Enumeration.Value int96RebaseMode(Function1<String, String> lookupFileMeta, String modeByConfig) {
        if (Utils$.MODULE$.isTesting()) {
            String string = SQLConf$.MODULE$.get().getConfString("spark.test.forceNoRebase", "");
            String string2 = "true";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED();
            }
        }
        return (Enumeration.Value)Option$.MODULE$.apply(lookupFileMeta.apply((Object)package$.MODULE$.SPARK_VERSION_METADATA_KEY())).map((Function1 & Serializable & scala.Serializable)version -> new StringOps(Predef$.MODULE$.augmentString(version)).$less((Object)"3.1.0") || lookupFileMeta.apply((Object)package$.MODULE$.SPARK_LEGACY_INT96()) != null ? SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY() : SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED()).getOrElse((Function0 & Serializable & scala.Serializable)() -> SQLConf.LegacyBehaviorPolicy$.MODULE$.withName(modeByConfig));
    }

    public SparkUpgradeException newRebaseExceptionInRead(String format) {
        String string;
        String string2 = format;
        if ("Parquet INT96".equals(string2)) {
            string = SQLConf$.MODULE$.LEGACY_PARQUET_INT96_REBASE_MODE_IN_READ().key();
        } else if ("Parquet".equals(string2)) {
            string = SQLConf$.MODULE$.LEGACY_PARQUET_REBASE_MODE_IN_READ().key();
        } else if ("Avro".equals(string2)) {
            string = SQLConf$.MODULE$.LEGACY_AVRO_REBASE_MODE_IN_READ().key();
        } else {
            throw new IllegalStateException(new StringBuilder(20).append("unrecognized format ").append(format).toString());
        }
        String config = string;
        return new SparkUpgradeException("3.0", new StringBuilder(470).append("reading dates before 1582-10-15 or timestamps before ").append("1900-01-01T00:00:00Z from ").append(format).append(" files can be ambiguous, as the files may be written by ").append("Spark 2.x or legacy versions of Hive, which uses a legacy hybrid calendar that is ").append("different from Spark 3.0+'s Proleptic Gregorian calendar. See more details in ").append("SPARK-31404. You can set ").append(config).append(" to 'LEGACY' to rebase the datetime values w.r.t. ").append("the calendar difference during reading. Or set ").append(config).append(" to 'CORRECTED' to read the ").append("datetime values as it is.").toString(), null);
    }

    public SparkUpgradeException newRebaseExceptionInWrite(String format) {
        String string;
        String string2 = format;
        if ("Parquet INT96".equals(string2)) {
            string = SQLConf$.MODULE$.LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE().key();
        } else if ("Parquet".equals(string2)) {
            string = SQLConf$.MODULE$.LEGACY_PARQUET_REBASE_MODE_IN_WRITE().key();
        } else if ("Avro".equals(string2)) {
            string = SQLConf$.MODULE$.LEGACY_AVRO_REBASE_MODE_IN_WRITE().key();
        } else {
            throw new IllegalStateException(new StringBuilder(20).append("unrecognized format ").append(format).toString());
        }
        String config = string;
        return new SparkUpgradeException("3.0", new StringBuilder(639).append("writing dates before 1582-10-15 or timestamps before ").append("1900-01-01T00:00:00Z into ").append(format).append(" files can be dangerous, as the files may be read by ").append("Spark 2.x or legacy versions of Hive later, which uses a legacy hybrid calendar that is ").append("different from Spark 3.0+'s Proleptic Gregorian calendar. See more details in ").append("SPARK-31404. You can set ").append(config).append(" to 'LEGACY' to rebase the datetime values w.r.t. ").append("the calendar difference during writing, to get maximum interoperability. Or set ").append(config).append(" to 'CORRECTED' to write the datetime values as it is, if you are 100% sure that ").append("the written files will only be read by Spark 3.0+ or other systems that use Proleptic ").append("Gregorian calendar.").toString(), null);
    }

    public Function1<Object, Object> createDateRebaseFuncInRead(Enumeration.Value rebaseMode, String format) {
        JFunction1.mcII.sp & Serializable & scala.Serializable intersect;
        Enumeration.Value value = rebaseMode;
        Enumeration.Value value2 = SQLConf.LegacyBehaviorPolicy$.MODULE$.EXCEPTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            intersect = (JFunction1.mcII.sp & Serializable & scala.Serializable)days -> {
                if (days < RebaseDateTime$.MODULE$.lastSwitchJulianDay()) {
                    throw MODULE$.newRebaseExceptionInRead(format);
                }
                return days;
            };
        } else {
            Enumeration.Value value4 = SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                intersect = (JFunction1.mcII.sp & Serializable & scala.Serializable)days -> RebaseDateTime$.MODULE$.rebaseJulianToGregorianDays(days);
            } else {
                Enumeration.Value value6 = SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    intersect = (JFunction1.mcII.sp & Serializable & scala.Serializable)x -> BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToInteger((int)x)));
                } else {
                    throw new MatchError((Object)value);
                }
            }
        }
        return intersect;
    }

    public Function1<Object, Object> createDateRebaseFuncInWrite(Enumeration.Value rebaseMode, String format) {
        JFunction1.mcII.sp & Serializable & scala.Serializable intersect;
        Enumeration.Value value = rebaseMode;
        Enumeration.Value value2 = SQLConf.LegacyBehaviorPolicy$.MODULE$.EXCEPTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            intersect = (JFunction1.mcII.sp & Serializable & scala.Serializable)days -> {
                if (days < RebaseDateTime$.MODULE$.lastSwitchGregorianDay()) {
                    throw MODULE$.newRebaseExceptionInWrite(format);
                }
                return days;
            };
        } else {
            Enumeration.Value value4 = SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                intersect = (JFunction1.mcII.sp & Serializable & scala.Serializable)days -> RebaseDateTime$.MODULE$.rebaseGregorianToJulianDays(days);
            } else {
                Enumeration.Value value6 = SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    intersect = (JFunction1.mcII.sp & Serializable & scala.Serializable)x -> BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToInteger((int)x)));
                } else {
                    throw new MatchError((Object)value);
                }
            }
        }
        return intersect;
    }

    public Function1<Object, Object> createTimestampRebaseFuncInRead(Enumeration.Value rebaseMode, String format) {
        JFunction1.mcJJ.sp & Serializable & scala.Serializable intersect;
        Enumeration.Value value = rebaseMode;
        Enumeration.Value value2 = SQLConf.LegacyBehaviorPolicy$.MODULE$.EXCEPTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            intersect = (JFunction1.mcJJ.sp & Serializable & scala.Serializable)micros -> {
                if (micros < RebaseDateTime$.MODULE$.lastSwitchJulianTs()) {
                    throw MODULE$.newRebaseExceptionInRead(format);
                }
                return micros;
            };
        } else {
            Enumeration.Value value4 = SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                intersect = (JFunction1.mcJJ.sp & Serializable & scala.Serializable)micros -> RebaseDateTime$.MODULE$.rebaseJulianToGregorianMicros(micros);
            } else {
                Enumeration.Value value6 = SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    intersect = (JFunction1.mcJJ.sp & Serializable & scala.Serializable)x -> BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToLong((long)x)));
                } else {
                    throw new MatchError((Object)value);
                }
            }
        }
        return intersect;
    }

    public Function1<Object, Object> createTimestampRebaseFuncInWrite(Enumeration.Value rebaseMode, String format) {
        JFunction1.mcJJ.sp & Serializable & scala.Serializable intersect;
        Enumeration.Value value = rebaseMode;
        Enumeration.Value value2 = SQLConf.LegacyBehaviorPolicy$.MODULE$.EXCEPTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            intersect = (JFunction1.mcJJ.sp & Serializable & scala.Serializable)micros -> {
                if (micros < RebaseDateTime$.MODULE$.lastSwitchGregorianTs()) {
                    throw MODULE$.newRebaseExceptionInWrite(format);
                }
                return micros;
            };
        } else {
            Enumeration.Value value4 = SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                intersect = (JFunction1.mcJJ.sp & Serializable & scala.Serializable)micros -> RebaseDateTime$.MODULE$.rebaseGregorianToJulianMicros(micros);
            } else {
                Enumeration.Value value6 = SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    intersect = (JFunction1.mcJJ.sp & Serializable & scala.Serializable)x -> BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToLong((long)x)));
                } else {
                    throw new MatchError((Object)value);
                }
            }
        }
        return intersect;
    }

    public Map<String, String> generateDatasourceOptions(CaseInsensitiveStringMap extraOptions, CatalogTable table) {
        Map map;
        Option pathOption = table.storage().locationUri().map((Function1 & Serializable & scala.Serializable)x$1 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)CatalogUtils$.MODULE$.URIToString(x$1)));
        Map options = table.storage().properties().$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(pathOption));
        if (!BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_EXTRA_OPTIONS_BEHAVIOR()))) {
            table.storage().properties().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DataSourceUtils$.$anonfun$generateDatasourceOptions$2(extraOptions, table, x0$1);
                return BoxedUnit.UNIT;
            });
            Set lowerCasedDuplicatedKeys = (Set)((GenSetLike)table.storage().properties().keySet().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toLowerCase(Locale.ROOT), Set$.MODULE$.canBuildFrom())).intersect((GenSet)JavaConverters$.MODULE$.asScalaSetConverter(extraOptions.keySet()).asScala());
            map = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(extraOptions.asCaseSensitiveMap()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)DataSourceUtils$.$anonfun$generateDatasourceOptions$4(lowerCasedDuplicatedKeys, x0$2))).toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)options);
        } else {
            map = options;
        }
        return map;
    }

    public static final /* synthetic */ void $anonfun$verifySchema$1(FileFormat format$1, StructField field) {
        if (!format$1.supportDataType(field.dataType())) {
            throw new AnalysisException(new StringBuilder(41).append(format$1).append(" data source does not support ").append(field.dataType().catalogString()).append(" data type.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    public static final /* synthetic */ void $anonfun$generateDatasourceOptions$2(CaseInsensitiveStringMap extraOptions$1, CatalogTable table$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            if (extraOptions$1.containsKey((Object)k)) {
                String string = extraOptions$1.get((Object)k);
                String string2 = v;
                if (string == null ? string2 != null : !string.equals(string2)) {
                    throw new AnalysisException(new StringBuilder(314).append("Fail to resolve data source for the table ").append(table$1.identifier()).append(" since the table ").append("serde property has the duplicated key ").append(k).append(" with extra options specified for this ").append("scan operation. To fix this, you can rollback to the legacy behavior of ignoring ").append("the extra options by setting the config ").append(SQLConf$.MODULE$.LEGACY_EXTRA_OPTIONS_BEHAVIOR().key()).append(" to `false`, or address the ").append("conflicts of the same config.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$generateDatasourceOptions$4(Set lowerCasedDuplicatedKeys$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        boolean bl = lowerCasedDuplicatedKeys$1.contains((Object)k.toLowerCase(Locale.ROOT));
        return bl;
    }

    private DataSourceUtils$() {
        MODULE$ = this;
        this.PARTITIONING_COLUMNS_KEY = "__partition_columns";
        this.formats = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
    }
}

