/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.command.DropTableCommand$;
import org.apache.spark.sql.execution.command.LeafRunnableCommand;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple4;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005ue\u0001B\u000f\u001f\u0001.B\u0001b\u0011\u0001\u0003\u0016\u0004%\t\u0001\u0012\u0005\t\u0013\u0002\u0011\t\u0012)A\u0005\u000b\"A!\n\u0001BK\u0002\u0013\u00051\n\u0003\u0005P\u0001\tE\t\u0015!\u0003M\u0011!\u0001\u0006A!f\u0001\n\u0003Y\u0005\u0002C)\u0001\u0005#\u0005\u000b\u0011\u0002'\t\u0011I\u0003!Q3A\u0005\u0002-C\u0001b\u0015\u0001\u0003\u0012\u0003\u0006I\u0001\u0014\u0005\u0006)\u0002!\t!\u0016\u0005\u00067\u0002!\t\u0005\u0018\u0005\be\u0002\t\t\u0011\"\u0001t\u0011\u001dA\b!%A\u0005\u0002eD\u0011\"!\u0003\u0001#\u0003%\t!a\u0003\t\u0013\u0005=\u0001!%A\u0005\u0002\u0005-\u0001\"CA\t\u0001E\u0005I\u0011AA\u0006\u0011%\t\u0019\u0002AA\u0001\n\u0003\n)\u0002C\u0005\u0002(\u0001\t\t\u0011\"\u0001\u0002*!I\u0011\u0011\u0007\u0001\u0002\u0002\u0013\u0005\u00111\u0007\u0005\n\u0003\u007f\u0001\u0011\u0011!C!\u0003\u0003B\u0011\"a\u0014\u0001\u0003\u0003%\t!!\u0015\t\u0013\u0005U\u0003!!A\u0005B\u0005]s!CA.=\u0005\u0005\t\u0012AA/\r!ib$!A\t\u0002\u0005}\u0003B\u0002+\u0018\t\u0003\ti\u0007C\u0005\u0002p]\t\t\u0011\"\u0012\u0002r!I\u00111O\f\u0002\u0002\u0013\u0005\u0015Q\u000f\u0005\n\u0003\u007f:\u0012\u0011!CA\u0003\u0003C\u0011\"a%\u0018\u0003\u0003%I!!&\u0003!\u0011\u0013x\u000e\u001d+bE2,7i\\7nC:$'BA\u0010!\u0003\u001d\u0019w.\\7b]\u0012T!!\t\u0012\u0002\u0013\u0015DXmY;uS>t'BA\u0012%\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003K\u0019\nQa\u001d9be.T!a\n\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0013aA8sO\u000e\u00011#\u0002\u0001-mi\u0002\u0005CA\u00175\u001b\u0005q#BA\u00181\u0003\u001dawnZ5dC2T!!\r\u001a\u0002\u000bAd\u0017M\\:\u000b\u0005M\u0012\u0013\u0001C2bi\u0006d\u0017p\u001d;\n\u0005Ur#a\u0003'pO&\u001c\u0017\r\u001c)mC:\u0004\"a\u000e\u001d\u000e\u0003yI!!\u000f\u0010\u0003'1+\u0017M\u001a*v]:\f'\r\\3D_6l\u0017M\u001c3\u0011\u0005mrT\"\u0001\u001f\u000b\u0003u\nQa]2bY\u0006L!a\u0010\u001f\u0003\u000fA\u0013x\u000eZ;diB\u00111(Q\u0005\u0003\u0005r\u0012AbU3sS\u0006d\u0017N_1cY\u0016\f\u0011\u0002^1cY\u0016t\u0015-\\3\u0016\u0003\u0015\u0003\"AR$\u000e\u0003IJ!\u0001\u0013\u001a\u0003\u001fQ\u000b'\r\\3JI\u0016tG/\u001b4jKJ\f!\u0002^1cY\u0016t\u0015-\\3!\u0003!Ig-\u0012=jgR\u001cX#\u0001'\u0011\u0005mj\u0015B\u0001(=\u0005\u001d\u0011un\u001c7fC:\f\u0011\"\u001b4Fq&\u001cHo\u001d\u0011\u0002\r%\u001ch+[3x\u0003\u001dI7OV5fo\u0002\nQ\u0001];sO\u0016\fa\u0001];sO\u0016\u0004\u0013A\u0002\u001fj]&$h\bF\u0003W/bK&\f\u0005\u00028\u0001!)1)\u0003a\u0001\u000b\")!*\u0003a\u0001\u0019\")\u0001+\u0003a\u0001\u0019\")!+\u0003a\u0001\u0019\u0006\u0019!/\u001e8\u0015\u0005uk\u0007c\u00010gS:\u0011q\f\u001a\b\u0003A\u000el\u0011!\u0019\u0006\u0003E*\na\u0001\u0010:p_Rt\u0014\"A\u001f\n\u0005\u0015d\u0014a\u00029bG.\fw-Z\u0005\u0003O\"\u00141aU3r\u0015\t)G\b\u0005\u0002kW6\t!%\u0003\u0002mE\t\u0019!k\\<\t\u000b9T\u0001\u0019A8\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005)\u0004\u0018BA9#\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003\u0011\u0019w\u000e]=\u0015\u000bY#XO^<\t\u000f\r[\u0001\u0013!a\u0001\u000b\"9!j\u0003I\u0001\u0002\u0004a\u0005b\u0002)\f!\u0003\u0005\r\u0001\u0014\u0005\b%.\u0001\n\u00111\u0001M\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012A\u001f\u0016\u0003\u000bn\\\u0013\u0001 \t\u0004{\u0006\u0015Q\"\u0001@\u000b\u0007}\f\t!A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0001\u001f\u0002\u0015\u0005tgn\u001c;bi&|g.C\u0002\u0002\by\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!\u0004+\u00051[\u0018AD2paf$C-\u001a4bk2$HeM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\u0003\t\u0005\u00033\t\u0019#\u0004\u0002\u0002\u001c)!\u0011QDA\u0010\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0005\u0012\u0001\u00026bm\u0006LA!!\n\u0002\u001c\t11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u000b\u0011\u0007m\ni#C\u0002\u00020q\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u000e\u0002<A\u00191(a\u000e\n\u0007\u0005eBHA\u0002B]fD\u0011\"!\u0010\u0013\u0003\u0003\u0005\r!a\u000b\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\u0019\u0005\u0005\u0004\u0002F\u0005-\u0013QG\u0007\u0003\u0003\u000fR1!!\u0013=\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u001b\n9E\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u0001'\u0002T!I\u0011Q\b\u000b\u0002\u0002\u0003\u0007\u0011QG\u0001\u0007KF,\u0018\r\\:\u0015\u00071\u000bI\u0006C\u0005\u0002>U\t\t\u00111\u0001\u00026\u0005\u0001BI]8q)\u0006\u0014G.Z\"p[6\fg\u000e\u001a\t\u0003o]\u0019BaFA1\u0001BI\u00111MA5\u000b2cEJV\u0007\u0003\u0003KR1!a\u001a=\u0003\u001d\u0011XO\u001c;j[\u0016LA!a\u001b\u0002f\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001b\u0015\u0005\u0005u\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005]\u0011!B1qa2LH#\u0003,\u0002x\u0005e\u00141PA?\u0011\u0015\u0019%\u00041\u0001F\u0011\u0015Q%\u00041\u0001M\u0011\u0015\u0001&\u00041\u0001M\u0011\u0015\u0011&\u00041\u0001M\u0003\u001d)h.\u00199qYf$B!a!\u0002\u0010B)1(!\"\u0002\n&\u0019\u0011q\u0011\u001f\u0003\r=\u0003H/[8o!\u001dY\u00141R#M\u00192K1!!$=\u0005\u0019!V\u000f\u001d7fi!A\u0011\u0011S\u000e\u0002\u0002\u0003\u0007a+A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011q\u0013\t\u0005\u00033\tI*\u0003\u0003\u0002\u001c\u0006m!AB(cU\u0016\u001cG\u000f")
public class DropTableCommand
extends LogicalPlan
implements LeafRunnableCommand,
Serializable {
    private final TableIdentifier tableName;
    private final boolean ifExists;
    private final boolean isView;
    private final boolean purge;
    private Map<String, SQLMetric> metrics;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple4<TableIdentifier, Object, Object, Object>> unapply(DropTableCommand dropTableCommand) {
        return DropTableCommand$.MODULE$.unapply(dropTableCommand);
    }

    public static Function1<Tuple4<TableIdentifier, Object, Object, Object>, DropTableCommand> tupled() {
        return DropTableCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Object, Function1<Object, Function1<Object, DropTableCommand>>>> curried() {
        return DropTableCommand$.MODULE$.curried();
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        DropTableCommand dropTableCommand = this;
        synchronized (dropTableCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public TableIdentifier tableName() {
        return this.tableName;
    }

    public boolean ifExists() {
        return this.ifExists;
    }

    public boolean isView() {
        return this.isView;
    }

    public boolean purge() {
        return this.purge;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        boolean isTempView = catalog.isTempView(this.tableName());
        if (!isTempView && catalog.tableExists(this.tableName())) {
            CatalogTableType catalogTableType = catalog.getTableMetadata(this.tableName()).tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
            CatalogTableType catalogTableType3 = catalogTableType;
            if (!(catalogTableType2 != null ? !catalogTableType2.equals(catalogTableType3) : catalogTableType3 != null) && !this.isView()) {
                throw QueryCompilationErrors$.MODULE$.cannotDropViewWithDropTableError();
            }
            CatalogTableType catalogTableType4 = catalogTableType;
            CatalogTableType catalogTableType5 = CatalogTableType$.MODULE$.VIEW();
            if ((catalogTableType4 == null ? catalogTableType5 != null : !catalogTableType4.equals(catalogTableType5)) && this.isView()) {
                throw QueryCompilationErrors$.MODULE$.cannotDropViewWithDropTableError();
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        if (isTempView || catalog.tableExists(this.tableName())) {
            try {
                boolean hasViewText = isTempView && catalog.getTempViewOrPermanentTableMetadata(this.tableName()).viewText().isDefined();
                sparkSession.sharedState().cacheManager().uncacheQuery(sparkSession.table(this.tableName()), !isTempView || hasViewText);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    this.log().warn(e.toString(), e);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                throw throwable;
            }
            catalog.refreshTable(this.tableName());
            catalog.dropTable(this.tableName(), this.ifExists(), this.purge());
        } else if (!this.ifExists()) {
            throw QueryCompilationErrors$.MODULE$.tableOrViewNotFoundError(this.tableName().identifier());
        }
        return (Seq)Nil$.MODULE$;
    }

    public DropTableCommand copy(TableIdentifier tableName, boolean ifExists, boolean isView, boolean purge) {
        return new DropTableCommand(tableName, ifExists, isView, purge);
    }

    public TableIdentifier copy$default$1() {
        return this.tableName();
    }

    public boolean copy$default$2() {
        return this.ifExists();
    }

    public boolean copy$default$3() {
        return this.isView();
    }

    public boolean copy$default$4() {
        return this.purge();
    }

    public String productPrefix() {
        return "DropTableCommand";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.tableName();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ifExists());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.isView());
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.purge());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DropTableCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DropTableCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        DropTableCommand dropTableCommand = (DropTableCommand)x$1;
        TableIdentifier tableIdentifier = this.tableName();
        TableIdentifier tableIdentifier2 = dropTableCommand.tableName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        if (this.ifExists() != dropTableCommand.ifExists()) return false;
        if (this.isView() != dropTableCommand.isView()) return false;
        if (this.purge() != dropTableCommand.purge()) return false;
        if (!dropTableCommand.canEqual(this)) return false;
        return true;
    }

    public DropTableCommand(TableIdentifier tableName, boolean ifExists, boolean isView, boolean purge) {
        this.tableName = tableName;
        this.ifExists = ifExists;
        this.isView = isView;
        this.purge = purge;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
        LeafLike.$init$((LeafLike)this);
    }
}

