/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.Locale;
import java.util.Properties;
import org.apache.spark.Partition;
import org.apache.spark.annotation.Stable;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation$;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.csv.CSVHeaderChecker;
import org.apache.spark.sql.catalyst.csv.CSVHeaderChecker$;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.csv.UnivocityParser;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.catalyst.json.JacksonParser$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.catalyst.util.FailureSafeParser;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsCatalogOptions;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.csv.CSVUtils$;
import org.apache.spark.sql.execution.datasources.csv.TextInputCSVDataSource$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCPartition;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation$;
import org.apache.spark.sql.execution.datasources.json.TextInputJsonDataSource$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Implicits$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Utils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Stable
@ScalaSignature(bytes="\u0006\u0001\t]e\u0001B\u00181\u0001eB\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\u0007\u0017\u0002!\t\u0001\r'\t\u000b=\u0003A\u0011\u0001)\t\u000by\u0003A\u0011A0\t\u000by\u0003A\u0011A4\t\u000b)\u0004A\u0011A6\t\u000b)\u0004A\u0011\u00019\t\u000b)\u0004A\u0011\u0001<\t\u000b)\u0004A\u0011\u0001?\t\u000f\u0005\u0015\u0001\u0001\"\u0001\u0002\b!9\u0011Q\u0001\u0001\u0005\u0002\u0005]\u0001bBA\u0015\u0001\u0011\u0005\u00111\u0006\u0005\b\u0003S\u0001A\u0011AA\u001e\u0011\u001d\tI\u0003\u0001C\u0001\u0003\u0003Bq!a\u0017\u0001\t\u0013\ti\u0006C\u0004\u0002p\u0001!I!!\u001d\t\u000f\u0005U\u0004\u0001\"\u0001\u0002x!9\u0011Q\u000f\u0001\u0005\u0002\u0005-\u0005bBA;\u0001\u0011\u0005\u00111\u0016\u0005\b\u0003{\u0003A\u0011AA`\u0011\u001d\ti\f\u0001C\u0001\u0003\u0007Dq!!0\u0001\t\u0003\tI\rC\u0004\u0002>\u0002!\t!!<\t\u000f\u0005u\u0006\u0001\"\u0001\u0002\u0000\"9!1\u0002\u0001\u0005\u0002\t5\u0001b\u0002B\u0006\u0001\u0011\u0005!\u0011\u0003\u0005\b\u0005\u0017\u0001A\u0011\u0001B\f\u0011\u001d\u0011i\u0002\u0001C\u0001\u0005?AqA!\b\u0001\t\u0003\u0011\u0019\u0003C\u0004\u0003*\u0001!\tAa\u000b\t\u000f\t%\u0002\u0001\"\u0001\u00030!9\u0011q\u0010\u0001\u0005\u0002\tU\u0002b\u0002B\u001e\u0001\u0011\u0005!Q\b\u0005\b\u0005w\u0001A\u0011\u0001B!\u0011\u001d\u00119\u0005\u0001C\u0001\u0005\u0013BqAa\u0012\u0001\t\u0003\u0011i\u0005C\u0004\u0003T\u0001!IA!\u0016\t\u0011I\u0003\u0001\u0019!C\u0005\u0005CB\u0011Ba\u0019\u0001\u0001\u0004%IA!\u001a\t\u000f\t-\u0004\u0001)Q\u0005'\"I!Q\u000e\u0001A\u0002\u0013%!q\u000e\u0005\n\u0005o\u0002\u0001\u0019!C\u0005\u0005sB\u0001B! \u0001A\u0003&!\u0011\u000f\u0005\n\u0005\u007f\u0002\u0001\u0019!C\u0005\u0005\u0003C\u0011Ba!\u0001\u0001\u0004%IA!\"\t\u0011\t%\u0005\u0001)Q\u0005\u0003?\u0012q\u0002R1uC\u001a\u0013\u0018-\\3SK\u0006$WM\u001d\u0006\u0003cI\n1a]9m\u0015\t\u0019D'A\u0003ta\u0006\u00148N\u0003\u00026m\u00051\u0011\r]1dQ\u0016T\u0011aN\u0001\u0004_J<7\u0001A\n\u0004\u0001i\u0002\u0005CA\u001e?\u001b\u0005a$\"A\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}b$AB!osJ+g\r\u0005\u0002B\t6\t!I\u0003\u0002De\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002F\u0005\n9Aj\\4hS:<\u0017\u0001D:qCJ\\7+Z:tS>t\u0007C\u0001%J\u001b\u0005\u0001\u0014B\u0001&1\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003\u0019a\u0014N\\5u}Q\u0011QJ\u0014\t\u0003\u0011\u0002AQA\u0012\u0002A\u0002\u001d\u000baAZ8s[\u0006$HCA'R\u0011\u0015\u00116\u00011\u0001T\u0003\u0019\u0019x.\u001e:dKB\u0011Ak\u0017\b\u0003+f\u0003\"A\u0016\u001f\u000e\u0003]S!\u0001\u0017\u001d\u0002\rq\u0012xn\u001c;?\u0013\tQF(\u0001\u0004Qe\u0016$WMZ\u0005\u00039v\u0013aa\u0015;sS:<'B\u0001.=\u0003\u0019\u00198\r[3nCR\u0011Q\n\u0019\u0005\u0006=\u0012\u0001\r!\u0019\t\u0003E\u0016l\u0011a\u0019\u0006\u0003IB\nQ\u0001^=qKNL!AZ2\u0003\u0015M#(/^2u)f\u0004X\r\u0006\u0002NQ\")\u0011.\u0002a\u0001'\u0006a1o\u00195f[\u0006\u001cFO]5oO\u00061q\u000e\u001d;j_:$2!\u00147o\u0011\u0015ig\u00011\u0001T\u0003\rYW-\u001f\u0005\u0006_\u001a\u0001\raU\u0001\u0006m\u0006dW/\u001a\u000b\u0004\u001bF\u0014\b\"B7\b\u0001\u0004\u0019\u0006\"B8\b\u0001\u0004\u0019\bCA\u001eu\u0013\t)HHA\u0004C_>dW-\u00198\u0015\u00075;\b\u0010C\u0003n\u0011\u0001\u00071\u000bC\u0003p\u0011\u0001\u0007\u0011\u0010\u0005\u0002<u&\u00111\u0010\u0010\u0002\u0005\u0019>tw\rF\u0002N{zDQ!\\\u0005A\u0002MCQa\\\u0005A\u0002}\u00042aOA\u0001\u0013\r\t\u0019\u0001\u0010\u0002\u0007\t>,(\r\\3\u0002\u000f=\u0004H/[8ogR\u0019Q*!\u0003\t\u000f\u0005\u0015!\u00021\u0001\u0002\fA1\u0011QBA\n'Nk!!a\u0004\u000b\u0007\u0005EA(\u0001\u0006d_2dWm\u0019;j_:LA!!\u0006\u0002\u0010\t\u0019Q*\u00199\u0015\u00075\u000bI\u0002C\u0004\u0002\u0006-\u0001\r!a\u0007\u0011\r\u0005u\u0011qE*T\u001b\t\tyB\u0003\u0003\u0002\"\u0005\r\u0012\u0001B;uS2T!!!\n\u0002\t)\fg/Y\u0005\u0005\u0003+\ty\"\u0001\u0003m_\u0006$GCAA\u0017!\u0011\ty#!\u000e\u000f\u0007!\u000b\t$C\u0002\u00024A\nq\u0001]1dW\u0006<W-\u0003\u0003\u00028\u0005e\"!\u0003#bi\u00064%/Y7f\u0015\r\t\u0019\u0004\r\u000b\u0005\u0003[\ti\u0004\u0003\u0004\u0002@5\u0001\raU\u0001\u0005a\u0006$\b\u000e\u0006\u0003\u0002.\u0005\r\u0003bBA#\u001d\u0001\u0007\u0011qI\u0001\u0006a\u0006$\bn\u001d\t\u0005w\u0005%3+C\u0002\u0002Lq\u0012!\u0002\u0010:fa\u0016\fG/\u001a3?Q\rq\u0011q\n\t\u0005\u0003#\n9&\u0004\u0002\u0002T)\u0019\u0011Q\u000b\u001f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002Z\u0005M#a\u0002<be\u0006\u0014xm]\u0001\u0014O\u0016$x\n\u001d;j_:\u001cx+\u001b;i!\u0006$\bn\u001d\u000b\u0005\u0003?\ni\u0007E\u0003\u0002b\u0005%4+\u0004\u0002\u0002d)!\u0011\u0011EA3\u0015\r\t9\u0007M\u0001\tG\u0006$\u0018\r\\=ti&!\u00111NA2\u0005I\u0019\u0015m]3J]N,gn]5uSZ,W*\u00199\t\u000f\u0005\u0015s\u00021\u0001\u0002H\u0005aAn\\1e-F\u001av.\u001e:dKR!\u0011QFA:\u0011\u001d\t)\u0005\u0005a\u0001\u0003\u000f\nAA\u001b3cGRA\u0011QFA=\u0003{\n\t\t\u0003\u0004\u0002|E\u0001\raU\u0001\u0004kJd\u0007BBA@#\u0001\u00071+A\u0003uC\ndW\rC\u0004\u0002\u0004F\u0001\r!!\"\u0002\u0015A\u0014x\u000e]3si&,7\u000f\u0005\u0003\u0002\u001e\u0005\u001d\u0015\u0002BAE\u0003?\u0011!\u0002\u0015:pa\u0016\u0014H/[3t)A\ti#!$\u0002\u0010\u0006E\u0015QSAM\u0003;\u000b9\u000b\u0003\u0004\u0002|I\u0001\ra\u0015\u0005\u0007\u0003\u007f\u0012\u0002\u0019A*\t\r\u0005M%\u00031\u0001T\u0003)\u0019w\u000e\\;n]:\u000bW.\u001a\u0005\u0007\u0003/\u0013\u0002\u0019A=\u0002\u00151|w/\u001a:C_VtG\r\u0003\u0004\u0002\u001cJ\u0001\r!_\u0001\u000bkB\u0004XM\u001d\"pk:$\u0007bBAP%\u0001\u0007\u0011\u0011U\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\u0011\u0007m\n\u0019+C\u0002\u0002&r\u00121!\u00138u\u0011\u001d\tIK\u0005a\u0001\u0003\u000b\u000bAcY8o]\u0016\u001cG/[8o!J|\u0007/\u001a:uS\u0016\u001cHCCA\u0017\u0003[\u000by+!-\u0002<\"1\u00111P\nA\u0002MCa!a \u0014\u0001\u0004\u0019\u0006bBAZ'\u0001\u0007\u0011QW\u0001\u000baJ,G-[2bi\u0016\u001c\b\u0003B\u001e\u00028NK1!!/=\u0005\u0015\t%O]1z\u0011\u001d\tIk\u0005a\u0001\u0003\u000b\u000bAA[:p]R!\u0011QFAa\u0011\u0019\ty\u0004\u0006a\u0001'R!\u0011QFAc\u0011\u001d\t)%\u0006a\u0001\u0003\u000fB3!FA()\u0011\ti#a3\t\u000f\u00055g\u00031\u0001\u0002P\u00069!n]8o%\u0012#\u0005#BAi\u00033\u001cVBAAj\u0015\u0011\t)#!6\u000b\u0007\u0005]''A\u0002ba&LA!a7\u0002T\n9!*\u0019<b%\u0012#\u0005f\u0002\f\u0002`\u0006\u0015\u0018\u0011\u001e\t\u0004w\u0005\u0005\u0018bAAry\tQA-\u001a9sK\u000e\fG/\u001a3\"\u0005\u0005\u001d\u0018AI+tK\u0002R7o\u001c8)\t\u0006$\u0018m]3u7N#(/\u001b8h;&\u0002\u0013N\\:uK\u0006$g&\t\u0002\u0002l\u0006)!G\f\u001a/aQ!\u0011QFAx\u0011\u001d\tim\u0006a\u0001\u0003c\u0004R!a=\u0002zNk!!!>\u000b\u0007\u0005]('A\u0002sI\u0012LA!a?\u0002v\n\u0019!\u000b\u0012#)\u000f]\ty.!:\u0002jR!\u0011Q\u0006B\u0001\u0011\u001d\u0011\u0019\u0001\u0007a\u0001\u0005\u000b\t1B[:p]\u0012\u000bG/Y:fiB!\u0001Ja\u0002T\u0013\r\u0011I\u0001\r\u0002\b\t\u0006$\u0018m]3u\u0003\r\u00197O\u001e\u000b\u0005\u0003[\u0011y\u0001\u0003\u0004\u0002@e\u0001\ra\u0015\u000b\u0005\u0003[\u0011\u0019\u0002C\u0004\u0003\u0016i\u0001\rA!\u0002\u0002\u0015\r\u001ch\u000fR1uCN,G\u000f\u0006\u0003\u0002.\te\u0001bBA#7\u0001\u0007\u0011q\t\u0015\u00047\u0005=\u0013a\u00029beF,X\r\u001e\u000b\u0005\u0003[\u0011\t\u0003\u0003\u0004\u0002@q\u0001\ra\u0015\u000b\u0005\u0003[\u0011)\u0003C\u0004\u0002Fu\u0001\r!a\u0012)\u0007u\ty%A\u0002pe\u000e$B!!\f\u0003.!1\u0011q\b\u0010A\u0002M#B!!\f\u00032!9\u0011QI\u0010A\u0002\u0005\u001d\u0003fA\u0010\u0002PQ!\u0011Q\u0006B\u001c\u0011\u0019\u0011I\u0004\ta\u0001'\u0006IA/\u00192mK:\u000bW.Z\u0001\u0005i\u0016DH\u000f\u0006\u0003\u0002.\t}\u0002BBA C\u0001\u00071\u000b\u0006\u0003\u0002.\t\r\u0003bBA#E\u0001\u0007\u0011q\t\u0015\u0004E\u0005=\u0013\u0001\u0003;fqR4\u0015\u000e\\3\u0015\t\t\u0015!1\n\u0005\u0007\u0003\u007f\u0019\u0003\u0019A*\u0015\t\t\u0015!q\n\u0005\b\u0003\u000b\"\u0003\u0019AA$Q\r!\u0013qJ\u0001\u0018CN\u001cXM\u001d;O_N\u0003XmY5gS\u0016$7k\u00195f[\u0006$BAa\u0016\u0003^A\u00191H!\u0017\n\u0007\tmCH\u0001\u0003V]&$\bB\u0002B0K\u0001\u00071+A\u0005pa\u0016\u0014\u0018\r^5p]V\t1+\u0001\u0006t_V\u00148-Z0%KF$BAa\u0016\u0003h!A!\u0011N\u0014\u0002\u0002\u0003\u00071+A\u0002yIE\nqa]8ve\u000e,\u0007%A\nvg\u0016\u00148\u000b]3dS\u001aLW\rZ*dQ\u0016l\u0017-\u0006\u0002\u0003rA!1Ha\u001db\u0013\r\u0011)\b\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0002/U\u001cXM]*qK\u000eLg-[3e'\u000eDW-\\1`I\u0015\fH\u0003\u0002B,\u0005wB\u0011B!\u001b+\u0003\u0003\u0005\rA!\u001d\u0002)U\u001cXM]*qK\u000eLg-[3e'\u000eDW-\\1!\u00031)\u0007\u0010\u001e:b\u001fB$\u0018n\u001c8t+\t\ty&\u0001\tfqR\u0014\u0018m\u00149uS>t7o\u0018\u0013fcR!!q\u000bBD\u0011%\u0011I'LA\u0001\u0002\u0004\ty&A\u0007fqR\u0014\u0018m\u00149uS>t7\u000f\t\u0015\u0004\u0001\t5\u0005\u0003\u0002BH\u0005'k!A!%\u000b\u0007\u0005U#'\u0003\u0003\u0003\u0016\nE%AB*uC\ndW\r")
public class DataFrameReader
implements Logging {
    private final SparkSession sparkSession;
    private String source;
    private Option<StructType> userSpecifiedSchema;
    private CaseInsensitiveMap<String> extraOptions;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Dataset<Row> load(String ... paths) {
        return this.load((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> json(String ... paths) {
        return this.json((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> csv(String ... paths) {
        return this.csv((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> parquet(String ... paths) {
        return this.parquet((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> orc(String ... paths) {
        return this.orc((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> text(String ... paths) {
        return this.text((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<String> textFile(String ... paths) {
        return this.textFile((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public DataFrameReader format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataFrameReader schema(StructType schema) {
        block0: {
            if (schema == null) break block0;
            StructType replaced = (StructType)CharVarcharUtils$.MODULE$.failIfHasCharVarchar((DataType)schema);
            this.userSpecifiedSchema_$eq((Option<StructType>)Option$.MODULE$.apply((Object)replaced));
        }
        return this;
    }

    public DataFrameReader schema(String schemaString) {
        return this.schema(StructType$.MODULE$.fromDDL(schemaString));
    }

    public DataFrameReader option(String key, String value) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value)));
        return this;
    }

    public DataFrameReader option(String key, boolean value) {
        return this.option(key, Boolean.toString(value));
    }

    public DataFrameReader option(String key, long value) {
        return this.option(key, Long.toString(value));
    }

    public DataFrameReader option(String key, double value) {
        return this.option(key, Double.toString(value));
    }

    public DataFrameReader options(Map<String, String> options) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus(options));
        return this;
    }

    public DataFrameReader options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()));
        return this;
    }

    public Dataset<Row> load() {
        return this.load((Seq<String>)((Seq)Nil$.MODULE$));
    }

    public Dataset<Row> load(String path) {
        return this.sparkSession.sessionState().conf().legacyPathOptionBehavior() ? this.option("path", path).load((Seq<String>)((Seq)Nil$.MODULE$)) : this.load((Seq<String>)((Seq)new .colon.colon((Object)path, (List)Nil$.MODULE$)));
    }

    public Dataset<Row> load(Seq<String> paths) {
        String string = this.source().toLowerCase(Locale.ROOT);
        String string2 = DDLUtils$.MODULE$.HIVE_PROVIDER();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw QueryCompilationErrors$.MODULE$.cannotOperateOnHiveDataSourceFilesError("read");
        }
        boolean legacyPathOptionBehavior = this.sparkSession.sessionState().conf().legacyPathOptionBehavior();
        if (!legacyPathOptionBehavior && (this.extraOptions().contains("path") || this.extraOptions().contains("paths")) && paths.nonEmpty()) {
            throw QueryCompilationErrors$.MODULE$.pathOptionNotSetCorrectlyWhenReadingError();
        }
        return (Dataset)DataSource$.MODULE$.lookupDataSourceV2(this.source(), this.sparkSession.sessionState().conf()).map((Function1 & Serializable & scala.Serializable)provider -> {
            Tuple3 tuple3;
            CatalogManager catalogManager = $this.sparkSession.sessionState().catalogManager();
            scala.collection.immutable.Map<String, String> sessionOptions = DataSourceV2Utils$.MODULE$.extractSessionConfigs((TableProvider)provider, $this.sparkSession.sessionState().conf());
            CaseInsensitiveMap<String> optionsWithPath = this.getOptionsWithPaths(paths);
            scala.collection.immutable.Map finalOptions = sessionOptions.filterKeys((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DataFrameReader.$anonfun$load$2(optionsWithPath, x$1))).toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)optionsWithPath.originalMap());
            CaseInsensitiveStringMap dsOptions = new CaseInsensitiveStringMap((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)finalOptions).asJava());
            boolean bl = false;
            SupportsCatalogOptions supportsCatalogOptions = null;
            TableProvider tableProvider = provider;
            if (tableProvider instanceof SupportsCatalogOptions) {
                bl = true;
                supportsCatalogOptions = (SupportsCatalogOptions)tableProvider;
                if (this.userSpecifiedSchema().nonEmpty()) {
                    throw new IllegalArgumentException(new StringBuilder(73).append(this.source()).append(" does not support user specified schema. Please don't specify the schema.").toString());
                }
            }
            if (bl) {
                Identifier ident = supportsCatalogOptions.extractIdentifier(dsOptions);
                TableCatalog catalog = CatalogV2Util$.MODULE$.getTableProviderCatalog(supportsCatalogOptions, catalogManager, dsOptions);
                tuple3 = new Tuple3((Object)catalog.loadTable(ident), (Object)new Some((Object)catalog), (Object)new Some((Object)ident));
            } else {
                Table tbl = DataSourceV2Utils$.MODULE$.getTableFromProvider((TableProvider)provider, dsOptions, this.userSpecifiedSchema());
                tuple3 = new Tuple3((Object)tbl, (Object)None$.MODULE$, (Object)None$.MODULE$);
            }
            Tuple3 tuple32 = tuple3;
            if (tuple32 == null) {
                throw new MatchError((Object)tuple32);
            }
            Table table = (Table)tuple32._1();
            Option catalog = (Option)tuple32._2();
            Option ident = (Option)tuple32._3();
            Tuple3 tuple33 = new Tuple3((Object)table, (Object)catalog, (Object)ident);
            Tuple3 tuple34 = tuple33;
            Table table2 = (Table)tuple34._1();
            Option catalog2 = (Option)tuple34._2();
            Option ident2 = (Option)tuple34._3();
            Table table3 = table2;
            Dataset<Row> dataset = table3 instanceof SupportsRead && DataSourceV2Implicits$.MODULE$.TableHelper(table2).supports(TableCapability.BATCH_READ) ? Dataset$.MODULE$.ofRows($this.sparkSession, (LogicalPlan)DataSourceV2Relation$.MODULE$.create(table2, catalog2, ident2, dsOptions)) : this.loadV1Source(paths);
            return dataset;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.loadV1Source(paths));
    }

    private CaseInsensitiveMap<String> getOptionsWithPaths(Seq<String> paths) {
        CaseInsensitiveMap caseInsensitiveMap;
        if (paths.isEmpty()) {
            caseInsensitiveMap = this.extraOptions();
        } else if (paths.length() == 1) {
            caseInsensitiveMap = this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), paths.head()));
        } else {
            ObjectMapper objectMapper = new ObjectMapper();
            caseInsensitiveMap = this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paths"), (Object)objectMapper.writeValueAsString(paths.toArray(ClassTag$.MODULE$.apply(String.class)))));
        }
        return caseInsensitiveMap;
    }

    private Dataset<Row> loadV1Source(Seq<String> paths) {
        Tuple2 tuple2;
        boolean legacyPathOptionBehavior = this.sparkSession.sessionState().conf().legacyPathOptionBehavior();
        Tuple2 tuple22 = tuple2 = !legacyPathOptionBehavior && paths.length() == 1 ? new Tuple2((Object)Nil$.MODULE$, (Object)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), paths.head()))) : new Tuple2(paths, this.extraOptions());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq finalPaths = (Seq)tuple2._1();
        CaseInsensitiveMap finalOptions = (CaseInsensitiveMap)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)finalPaths, (Object)finalOptions);
        Tuple2 tuple24 = tuple23;
        Seq finalPaths2 = (Seq)tuple24._1();
        CaseInsensitiveMap finalOptions2 = (CaseInsensitiveMap)tuple24._2();
        SparkSession x$1 = this.sparkSession;
        Seq x$2 = finalPaths2;
        Option<StructType> x$3 = this.userSpecifiedSchema();
        String x$4 = this.source();
        scala.collection.immutable.Map x$5 = finalOptions2.originalMap();
        Seq<String> x$6 = DataSource$.MODULE$.apply$default$5();
        Option<BucketSpec> x$7 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$8 = DataSource$.MODULE$.apply$default$8();
        DataSource qual$1 = new DataSource(x$1, x$4, (Seq<String>)x$2, x$3, x$6, x$7, (scala.collection.immutable.Map<String, String>)x$5, x$8);
        boolean x$9 = qual$1.resolveRelation$default$1();
        return this.sparkSession.baseRelationToDataFrame(qual$1.resolveRelation(x$9));
    }

    public Dataset<Row> jdbc(String url, String table, Properties properties) {
        this.assertNoSpecifiedSchema("jdbc");
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(properties).asScala()));
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus((TraversableOnce)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_URL()), (Object)url), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_TABLE_NAME()), (Object)table), (List)Nil$.MODULE$))));
        return this.format("jdbc").load();
    }

    public Dataset<Row> jdbc(String url, String table, String columnName, long lowerBound, long upperBound, int numPartitions, Properties connectionProperties) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus((TraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_PARTITION_COLUMN()), (Object)columnName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_LOWER_BOUND()), (Object)Long.toString(lowerBound)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_UPPER_BOUND()), (Object)Long.toString(upperBound)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_NUM_PARTITIONS()), (Object)Integer.toString(numPartitions))}))));
        return this.jdbc(url, table, connectionProperties);
    }

    public Dataset<Row> jdbc(String url, String table, String[] predicates, Properties connectionProperties) {
        this.assertNoSpecifiedSchema("jdbc");
        CaseInsensitiveMap params = this.extraOptions().$plus$plus((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(connectionProperties).asScala());
        JDBCOptions options = new JDBCOptions(url, table, (scala.collection.immutable.Map<String, String>)params);
        Partition[] parts = (Partition[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predicates)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String part = (String)tuple2._1();
            int i = tuple2._2$mcI$sp();
            JDBCPartition jDBCPartition = new JDBCPartition(part, i);
            return jDBCPartition;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Partition.class)));
        JDBCRelation relation = JDBCRelation$.MODULE$.apply(parts, options, this.sparkSession);
        return this.sparkSession.baseRelationToDataFrame(relation);
    }

    public Dataset<Row> json(String path) {
        return this.json((Seq<String>)((Seq)new .colon.colon((Object)path, (List)Nil$.MODULE$)));
    }

    public Dataset<Row> json(Seq<String> paths) {
        return this.format("json").load(paths);
    }

    public Dataset<Row> json(JavaRDD<String> jsonRDD) {
        return this.json((RDD<String>)jsonRDD.rdd());
    }

    public Dataset<Row> json(RDD<String> jsonRDD) {
        return this.json(this.sparkSession.createDataset(jsonRDD, Encoders$.MODULE$.STRING()));
    }

    public Dataset<Row> json(Dataset<String> jsonDataset) {
        JSONOptions parsedOptions = new JSONOptions(this.extraOptions().toMap(), this.sparkSession.sessionState().conf().sessionLocalTimeZone(), this.sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        StructType schema = (StructType)this.userSpecifiedSchema().getOrElse((Function0 & Serializable & scala.Serializable)() -> TextInputJsonDataSource$.MODULE$.inferFromDataset(jsonDataset, parsedOptions));
        ExprUtils$.MODULE$.verifyColumnNameOfCorruptRecord(schema, parsedOptions.columnNameOfCorruptRecord());
        StructType actualSchema = StructType$.MODULE$.apply((Seq)schema.filterNot((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DataFrameReader.$anonfun$json$2(parsedOptions, x$4))));
        Function2 & Serializable & scala.Serializable createParser = (Function2 & Serializable & scala.Serializable)(jsonFactory, record) -> CreateJacksonParser$.MODULE$.string(jsonFactory, record);
        RDD parsed = jsonDataset.rdd().mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            JacksonParser rawParser = new JacksonParser((DataType)actualSchema, parsedOptions, true, JacksonParser$.MODULE$.$lessinit$greater$default$4());
            FailureSafeParser parser = new FailureSafeParser((Function1 & Serializable & scala.Serializable)input -> rawParser.parse(input, createParser, (Function1 & Serializable & scala.Serializable)x$1 -> UTF8String.fromString((String)x$1)), parsedOptions.parseMode(), schema, parsedOptions.columnNameOfCorruptRecord());
            return iter.flatMap((Function1 & Serializable & scala.Serializable)input -> parser.parse(input));
        }, jsonDataset.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
        return this.sparkSession.internalCreateDataFrame((RDD<InternalRow>)parsed, schema, jsonDataset.isStreaming());
    }

    public Dataset<Row> csv(String path) {
        return this.csv((Seq<String>)((Seq)new .colon.colon((Object)path, (List)Nil$.MODULE$)));
    }

    public Dataset<Row> csv(Dataset<String> csvDataset) {
        CSVOptions parsedOptions = new CSVOptions(this.extraOptions().toMap(), this.sparkSession.sessionState().conf().csvColumnPruning(), this.sparkSession.sessionState().conf().sessionLocalTimeZone());
        Dataset<String> filteredLines = CSVUtils$.MODULE$.filterCommentAndEmpty(csvDataset, parsedOptions);
        None$ maybeFirstLine = this.userSpecifiedSchema().isEmpty() || parsedOptions.headerFlag() ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredLines.take(1))).headOption() : None$.MODULE$;
        StructType schema = (StructType)this.userSpecifiedSchema().getOrElse(() -> DataFrameReader.$anonfun$csv$1(this, csvDataset, (Option)maybeFirstLine, parsedOptions));
        ExprUtils$.MODULE$.verifyColumnNameOfCorruptRecord(schema, parsedOptions.columnNameOfCorruptRecord());
        StructType actualSchema = StructType$.MODULE$.apply((Seq)schema.filterNot((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DataFrameReader.$anonfun$csv$2(parsedOptions, x$5))));
        RDD linesWithoutHeader = (RDD)maybeFirstLine.map((Function1 & Serializable & scala.Serializable)firstLine -> {
            CSVHeaderChecker headerChecker = new CSVHeaderChecker(actualSchema, parsedOptions, new StringBuilder(12).append("CSV source: ").append(csvDataset).toString(), CSVHeaderChecker$.MODULE$.$lessinit$greater$default$4());
            headerChecker.checkHeaderColumnNames(firstLine);
            return filteredLines.rdd().mapPartitions((Function1 & Serializable & scala.Serializable)x$6 -> CSVUtils$.MODULE$.filterHeaderLine((Iterator<String>)x$6, (String)firstLine, parsedOptions), filteredLines.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(String.class));
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> filteredLines.rdd());
        RDD parsed = linesWithoutHeader.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            UnivocityParser rawParser = new UnivocityParser(actualSchema, parsedOptions);
            FailureSafeParser parser = new FailureSafeParser((Function1 & Serializable & scala.Serializable)input -> Option$.MODULE$.option2Iterable((Option)rawParser.parse().apply(input)), parsedOptions.parseMode(), schema, parsedOptions.columnNameOfCorruptRecord());
            return iter.flatMap((Function1 & Serializable & scala.Serializable)input -> parser.parse(input));
        }, linesWithoutHeader.mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
        return this.sparkSession.internalCreateDataFrame((RDD<InternalRow>)parsed, schema, csvDataset.isStreaming());
    }

    public Dataset<Row> csv(Seq<String> paths) {
        return this.format("csv").load(paths);
    }

    public Dataset<Row> parquet(String path) {
        return this.parquet((Seq<String>)((Seq)new .colon.colon((Object)path, (List)Nil$.MODULE$)));
    }

    public Dataset<Row> parquet(Seq<String> paths) {
        return this.format("parquet").load(paths);
    }

    public Dataset<Row> orc(String path) {
        return this.orc((Seq<String>)((Seq)new .colon.colon((Object)path, (List)Nil$.MODULE$)));
    }

    public Dataset<Row> orc(Seq<String> paths) {
        return this.format("orc").load(paths);
    }

    public Dataset<Row> table(String tableName) {
        this.assertNoSpecifiedSchema("table");
        Seq multipartIdentifier = this.sparkSession.sessionState().sqlParser().parseMultipartIdentifier(tableName);
        return Dataset$.MODULE$.ofRows(this.sparkSession, (LogicalPlan)new UnresolvedRelation(multipartIdentifier, new CaseInsensitiveStringMap((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.extraOptions().toMap()).asJava()), UnresolvedRelation$.MODULE$.apply$default$3()));
    }

    public Dataset<Row> text(String path) {
        return this.text((Seq<String>)((Seq)new .colon.colon((Object)path, (List)Nil$.MODULE$)));
    }

    public Dataset<Row> text(Seq<String> paths) {
        return this.format("text").load(paths);
    }

    public Dataset<String> textFile(String path) {
        return this.textFile((Seq<String>)((Seq)new .colon.colon((Object)path, (List)Nil$.MODULE$)));
    }

    public Dataset<String> textFile(Seq<String> paths) {
        this.assertNoSpecifiedSchema("textFile");
        return this.text(paths).select("value", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).as(this.sparkSession.implicits().newStringEncoder());
    }

    private void assertNoSpecifiedSchema(String operation) {
        if (this.userSpecifiedSchema().nonEmpty()) {
            throw QueryCompilationErrors$.MODULE$.userSpecifiedSchemaUnsupportedError(operation);
        }
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private Option<StructType> userSpecifiedSchema() {
        return this.userSpecifiedSchema;
    }

    private void userSpecifiedSchema_$eq(Option<StructType> x$1) {
        this.userSpecifiedSchema = x$1;
    }

    private CaseInsensitiveMap<String> extraOptions() {
        return this.extraOptions;
    }

    private void extraOptions_$eq(CaseInsensitiveMap<String> x$1) {
        this.extraOptions = x$1;
    }

    public static final /* synthetic */ boolean $anonfun$load$2(CaseInsensitiveMap optionsWithPath$1, String x$1) {
        return !optionsWithPath$1.contains(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$json$2(JSONOptions parsedOptions$1, StructField x$4) {
        String string = x$4.name();
        String string2 = parsedOptions$1.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ StructType $anonfun$csv$1(DataFrameReader $this, Dataset csvDataset$1, Option maybeFirstLine$1, CSVOptions parsedOptions$2) {
        return TextInputCSVDataSource$.MODULE$.inferFromDataset($this.sparkSession, csvDataset$1, (Option<String>)maybeFirstLine$1, parsedOptions$2);
    }

    public static final /* synthetic */ boolean $anonfun$csv$2(CSVOptions parsedOptions$2, StructField x$5) {
        String string = x$5.name();
        String string2 = parsedOptions$2.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public DataFrameReader(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        Logging.$init$((Logging)this);
        this.source = sparkSession.sessionState().conf().defaultDataSourceName();
        this.userSpecifiedSchema = None$.MODULE$;
        this.extraOptions = CaseInsensitiveMap$.MODULE$.apply(Predef$.MODULE$.Map().empty());
    }
}

