/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2.parquet;

import java.io.Serializable;
import java.net.URI;
import java.time.ZoneId;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.RebaseDateTime;
import org.apache.spark.sql.connector.metric.CustomTaskMetric;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFilters;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFooterReader;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedParquetRecordReader;
import org.apache.spark.sql.execution.datasources.v2.FilePartitionReaderFactory;
import org.apache.spark.sql.execution.datasources.v2.PartitionReaderWithPartitionValues;
import org.apache.spark.sql.execution.datasources.v2.parquet.ParquetPartitionReaderFactory$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function7;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple7;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\r=g\u0001B'O\u0001~C\u0001b\u001d\u0001\u0003\u0016\u0004%\t\u0001\u001e\u0005\tu\u0002\u0011\t\u0012)A\u0005k\"A1\u0010\u0001BK\u0002\u0013\u0005A\u0010C\u0005\u0002\u0014\u0001\u0011\t\u0012)A\u0005{\"Q\u0011Q\u0003\u0001\u0003\u0016\u0004%\t!a\u0006\t\u0015\u0005\u0015\u0002A!E!\u0002\u0013\tI\u0002\u0003\u0006\u0002(\u0001\u0011)\u001a!C\u0001\u0003/A!\"!\u000b\u0001\u0005#\u0005\u000b\u0011BA\r\u0011)\tY\u0003\u0001BK\u0002\u0013\u0005\u0011q\u0003\u0005\u000b\u0003[\u0001!\u0011#Q\u0001\n\u0005e\u0001BCA\u0018\u0001\tU\r\u0011\"\u0001\u00022!Q\u0011Q\t\u0001\u0003\u0012\u0003\u0006I!a\r\t\u0015\u0005\u001d\u0003A!f\u0001\n\u0003\tI\u0005\u0003\u0006\u0002V\u0001\u0011\t\u0012)A\u0005\u0003\u0017Bq!a\u0016\u0001\t\u0003\tI\u0006C\u0005\u0002n\u0001\u0011\r\u0011\"\u0003\u0002p!A\u0011q\u000f\u0001!\u0002\u0013\t\t\bC\u0005\u0002z\u0001\u0011\r\u0011\"\u0003\u0002\u0018!A\u00111\u0010\u0001!\u0002\u0013\tI\u0002C\u0005\u0002~\u0001\u0011\r\u0011\"\u0003\u0002p!A\u0011q\u0010\u0001!\u0002\u0013\t\t\bC\u0005\u0002\u0002\u0002\u0011\r\u0011\"\u0003\u0002p!A\u00111\u0011\u0001!\u0002\u0013\t\t\bC\u0005\u0002\u0006\u0002\u0011\r\u0011\"\u0003\u0002p!A\u0011q\u0011\u0001!\u0002\u0013\t\t\bC\u0005\u0002\n\u0002\u0011\r\u0011\"\u0003\u0002p!A\u00111\u0012\u0001!\u0002\u0013\t\t\bC\u0005\u0002\u000e\u0002\u0011\r\u0011\"\u0003\u0002\u0010\"A\u0011q\u0013\u0001!\u0002\u0013\t\t\nC\u0005\u0002\u001a\u0002\u0011\r\u0011\"\u0003\u0002p!A\u00111\u0014\u0001!\u0002\u0013\t\t\bC\u0005\u0002\u001e\u0002\u0011\r\u0011\"\u0003\u0002p!A\u0011q\u0014\u0001!\u0002\u0013\t\t\bC\u0005\u0002\"\u0002\u0011\r\u0011\"\u0003\u0002p!A\u00111\u0015\u0001!\u0002\u0013\t\t\bC\u0005\u0002&\u0002\u0011\r\u0011\"\u0003\u0002p!A\u0011q\u0015\u0001!\u0002\u0013\t\t\bC\u0005\u0002*\u0002\u0011\r\u0011\"\u0003\u0002p!A\u00111\u0016\u0001!\u0002\u0013\t\t\bC\u0005\u0002.\u0002\u0011\r\u0011\"\u0003\u0002\u0010\"A\u0011q\u0016\u0001!\u0002\u0013\t\t\nC\u0005\u00022\u0002\u0011\r\u0011\"\u0003\u00024\"A\u00111\u001a\u0001!\u0002\u0013\t)\fC\u0005\u0002N\u0002\u0011\r\u0011\"\u0003\u00024\"A\u0011q\u001a\u0001!\u0002\u0013\t)\fC\u0004\u0002R\u0002!\t%a5\t\u000f\u0005%\b\u0001\"\u0011\u0002l\"9!1\u0002\u0001\u0005B\t5\u0001b\u0002B\u0010\u0001\u0011%!\u0011\u0005\u0005\b\u0005\u001b\u0004A\u0011\u0002Bh\u0011\u001d\u0011)\u000e\u0001C\u0005\u0005/DqA!>\u0001\t\u0013\u00119\u0010C\u0004\u0004\u0002\u0001!Iaa\u0001\t\u0013\rM\u0001!!A\u0005\u0002\rU\u0001\"CB\u0013\u0001E\u0005I\u0011AB\u0014\u0011%\u0019i\u0004AI\u0001\n\u0003\u0019y\u0004C\u0005\u0004D\u0001\t\n\u0011\"\u0001\u0004F!I1\u0011\n\u0001\u0012\u0002\u0013\u00051Q\t\u0005\n\u0007\u0017\u0002\u0011\u0013!C\u0001\u0007\u000bB\u0011b!\u0014\u0001#\u0003%\taa\u0014\t\u0013\rM\u0003!%A\u0005\u0002\rU\u0003\"CB-\u0001\u0005\u0005I\u0011IB.\u0011%\u0019\t\u0007AA\u0001\n\u0003\ty\tC\u0005\u0004d\u0001\t\t\u0011\"\u0001\u0004f!I11\u000e\u0001\u0002\u0002\u0013\u00053Q\u000e\u0005\n\u0007w\u0002\u0011\u0011!C\u0001\u0007{B\u0011b!!\u0001\u0003\u0003%\tea!\t\u0013\r\u0015\u0005!!A\u0005B\r\u001d\u0005\"CBE\u0001\u0005\u0005I\u0011IBF\u000f%\u0019yITA\u0001\u0012\u0003\u0019\tJ\u0002\u0005N\u001d\u0006\u0005\t\u0012ABJ\u0011\u001d\t9f\u0012C\u0001\u0007CC\u0011b!\"H\u0003\u0003%)ea\"\t\u0013\r\rv)!A\u0005\u0002\u000e\u0015\u0006\"CB[\u000f\u0006\u0005I\u0011QB\\\u0011%\u0019)mRA\u0001\n\u0013\u00199MA\u000fQCJ\fX/\u001a;QCJ$\u0018\u000e^5p]J+\u0017\rZ3s\r\u0006\u001cGo\u001c:z\u0015\ty\u0005+A\u0004qCJ\fX/\u001a;\u000b\u0005E\u0013\u0016A\u0001<3\u0015\t\u0019F+A\u0006eCR\f7o\\;sG\u0016\u001c(BA+W\u0003%)\u00070Z2vi&|gN\u0003\u0002X1\u0006\u00191/\u001d7\u000b\u0005eS\u0016!B:qCJ\\'BA.]\u0003\u0019\t\u0007/Y2iK*\tQ,A\u0002pe\u001e\u001c\u0001aE\u0003\u0001A\u0012T\u0007\u000f\u0005\u0002bE6\t\u0001+\u0003\u0002d!\nQb)\u001b7f!\u0006\u0014H/\u001b;j_:\u0014V-\u00193fe\u001a\u000b7\r^8ssB\u0011Q\r[\u0007\u0002M*\u0011q\rW\u0001\tS:$XM\u001d8bY&\u0011\u0011N\u001a\u0002\b\u0019><w-\u001b8h!\tYg.D\u0001m\u0015\u0005i\u0017!B:dC2\f\u0017BA8m\u0005\u001d\u0001&o\u001c3vGR\u0004\"a[9\n\u0005Id'\u0001D*fe&\fG.\u001b>bE2,\u0017aB:rY\u000e{gNZ\u000b\u0002kB\u0011a\u000f_\u0007\u0002o*\u0011qMV\u0005\u0003s^\u0014qaU)M\u0007>tg-\u0001\u0005tc2\u001cuN\u001c4!\u0003=\u0011'o\\1eG\u0006\u001cH/\u001a3D_:4W#A?\u0011\u000by\f\u0019!a\u0002\u000e\u0003}T1!!\u0001Y\u0003%\u0011'o\\1eG\u0006\u001cH/C\u0002\u0002\u0006}\u0014\u0011B\u0011:pC\u0012\u001c\u0017m\u001d;\u0011\t\u0005%\u0011qB\u0007\u0003\u0003\u0017Q1!!\u0004Y\u0003\u0011)H/\u001b7\n\t\u0005E\u00111\u0002\u0002\u001a'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\"p]\u001aLw-\u001e:bi&|g.\u0001\tce>\fGmY1ti\u0016$7i\u001c8gA\u0005QA-\u0019;b'\u000eDW-\\1\u0016\u0005\u0005e\u0001\u0003BA\u000e\u0003Ci!!!\b\u000b\u0007\u0005}a+A\u0003usB,7/\u0003\u0003\u0002$\u0005u!AC*ueV\u001cG\u000fV=qK\u0006YA-\u0019;b'\u000eDW-\\1!\u00039\u0011X-\u00193ECR\f7k\u00195f[\u0006\fqB]3bI\u0012\u000bG/Y*dQ\u0016l\u0017\rI\u0001\u0010a\u0006\u0014H/\u001b;j_:\u001c6\r[3nC\u0006\u0001\u0002/\u0019:uSRLwN\\*dQ\u0016l\u0017\rI\u0001\bM&dG/\u001a:t+\t\t\u0019\u0004E\u0003l\u0003k\tI$C\u0002\u000281\u0014Q!\u0011:sCf\u0004B!a\u000f\u0002B5\u0011\u0011Q\b\u0006\u0004\u0003\u007f1\u0016aB:pkJ\u001cWm]\u0005\u0005\u0003\u0007\niD\u0001\u0004GS2$XM]\u0001\tM&dG/\u001a:tA\u0005q\u0001/\u0019:rk\u0016$x\n\u001d;j_:\u001cXCAA&!\u0011\ti%!\u0015\u000e\u0005\u0005=#BA(S\u0013\u0011\t\u0019&a\u0014\u0003\u001dA\u000b'/];fi>\u0003H/[8og\u0006y\u0001/\u0019:rk\u0016$x\n\u001d;j_:\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0011\u00037\ny&!\u0019\u0002d\u0005\u0015\u0014qMA5\u0003W\u00022!!\u0018\u0001\u001b\u0005q\u0005\"B:\u0010\u0001\u0004)\b\"B>\u0010\u0001\u0004i\bbBA\u000b\u001f\u0001\u0007\u0011\u0011\u0004\u0005\b\u0003Oy\u0001\u0019AA\r\u0011\u001d\tYc\u0004a\u0001\u00033Aq!a\f\u0010\u0001\u0004\t\u0019\u0004C\u0004\u0002H=\u0001\r!a\u0013\u0002\u001f%\u001c8)Y:f'\u0016t7/\u001b;jm\u0016,\"!!\u001d\u0011\u0007-\f\u0019(C\u0002\u0002v1\u0014qAQ8pY\u0016\fg.\u0001\tjg\u000e\u000b7/Z*f]NLG/\u001b<fA\u0005a!/Z:vYR\u001c6\r[3nC\u0006i!/Z:vYR\u001c6\r[3nC\u0002\n\u0011$\u001a8bE2,wJ\u001a4IK\u0006\u00048i\u001c7v[:4Vm\u0019;pe\u0006QRM\\1cY\u0016|eM\u001a%fCB\u001cu\u000e\\;n]Z+7\r^8sA\u00051RM\\1cY\u00164Vm\u0019;pe&TX\r\u001a*fC\u0012,'/A\ff]\u0006\u0014G.\u001a,fGR|'/\u001b>fIJ+\u0017\rZ3sA\u0005\u0011RM\\1cY\u0016\u0014VmY8sI\u001aKG\u000e^3s\u0003M)g.\u00192mKJ+7m\u001c:e\r&dG/\u001a:!\u0003M!\u0018.\\3ti\u0006l\u0007oQ8om\u0016\u00148/[8o\u0003Q!\u0018.\\3ti\u0006l\u0007oQ8om\u0016\u00148/[8oA\u0005A1-\u00199bG&$\u00180\u0006\u0002\u0002\u0012B\u00191.a%\n\u0007\u0005UENA\u0002J]R\f\u0011bY1qC\u000eLG/\u001f\u0011\u00027\u0015t\u0017M\u00197f!\u0006\u0014\u0018/^3u\r&dG/\u001a:QkNDGi\\<o\u0003q)g.\u00192mKB\u000b'/];fi\u001aKG\u000e^3s!V\u001c\b\u000eR8x]\u0002\nA\u0002];tQ\u0012{wO\u001c#bi\u0016\fQ\u0002];tQ\u0012{wO\u001c#bi\u0016\u0004\u0013!\u00059vg\"$un\u001e8US6,7\u000f^1na\u0006\u0011\u0002/^:i\t><h\u000eV5nKN$\u0018-\u001c9!\u0003=\u0001Xo\u001d5E_^tG)Z2j[\u0006d\u0017\u0001\u00059vg\"$un\u001e8EK\u000eLW.\u00197!\u0003]\u0001Xo\u001d5E_^t7\u000b\u001e:j]\u001e\u001cF/\u0019:u/&$\b.\u0001\rqkNDGi\\<o'R\u0014\u0018N\\4Ti\u0006\u0014HoV5uQ\u0002\n\u0011\u0004];tQ\u0012{wO\\%o\r&dG/\u001a:UQJ,7\u000f[8mI\u0006Q\u0002/^:i\t><h.\u00138GS2$XM\u001d+ie\u0016\u001c\bn\u001c7eA\u0005AB-\u0019;fi&lWMU3cCN,Wj\u001c3f\u0013:\u0014V-\u00193\u0016\u0005\u0005U\u0006\u0003BA\\\u0003\u000btA!!/\u0002BB\u0019\u00111\u00187\u000e\u0005\u0005u&bAA`=\u00061AH]8pizJ1!a1m\u0003\u0019\u0001&/\u001a3fM&!\u0011qYAe\u0005\u0019\u0019FO]5oO*\u0019\u00111\u00197\u00023\u0011\fG/\u001a;j[\u0016\u0014VMY1tK6{G-Z%o%\u0016\fG\rI\u0001\u0016S:$\u0018H\u000e*fE\u0006\u001cX-T8eK&s'+Z1e\u0003YIg\u000e^\u001d7%\u0016\u0014\u0017m]3N_\u0012,\u0017J\u001c*fC\u0012\u0004\u0013\u0001F:vaB|'\u000f^\"pYVlg.\u0019:SK\u0006$7\u000f\u0006\u0003\u0002r\u0005U\u0007bBAl]\u0001\u0007\u0011\u0011\\\u0001\na\u0006\u0014H/\u001b;j_:\u0004B!a7\u0002f6\u0011\u0011Q\u001c\u0006\u0005\u0003?\f\t/\u0001\u0003sK\u0006$'bAAr-\u0006I1m\u001c8oK\u000e$xN]\u0005\u0005\u0003O\fiN\u0001\bJ]B,H\u000fU1si&$\u0018n\u001c8\u0002\u0017\t,\u0018\u000e\u001c3SK\u0006$WM\u001d\u000b\u0005\u0003[\fy\u0010\u0005\u0004\u0002\\\u0006=\u00181_\u0005\u0005\u0003c\fiNA\bQCJ$\u0018\u000e^5p]J+\u0017\rZ3s!\u0011\t)0a?\u000e\u0005\u0005](bAA}-\u0006A1-\u0019;bYf\u001cH/\u0003\u0003\u0002~\u0006](aC%oi\u0016\u0014h.\u00197S_^DqA!\u00010\u0001\u0004\u0011\u0019!\u0001\u0003gS2,\u0007\u0003\u0002B\u0003\u0005\u000fi\u0011AU\u0005\u0004\u0005\u0013\u0011&a\u0004)beRLG/[8oK\u00124\u0015\u000e\\3\u0002'\t,\u0018\u000e\u001c3D_2,XN\\1s%\u0016\fG-\u001a:\u0015\t\t=!Q\u0004\t\u0007\u00037\fyO!\u0005\u0011\t\tM!\u0011D\u0007\u0003\u0005+Q1Aa\u0006W\u0003)1Xm\u0019;pe&TX\rZ\u0005\u0005\u00057\u0011)BA\u0007D_2,XN\\1s\u0005\u0006$8\r\u001b\u0005\b\u0005\u0003\u0001\u0004\u0019\u0001B\u0002\u0003=\u0011W/\u001b7e%\u0016\fG-\u001a:CCN,W\u0003\u0002B\u0012\u0005\u0013\"bA!\n\u0003\\\tu\u0003\u0003\u0003B\u0014\u0005c\u0011)D!\u0012\u000e\u0005\t%\"\u0002\u0002B\u0016\u0005[\t\u0011\"\\1qe\u0016$WoY3\u000b\u0007\t=\",\u0001\u0004iC\u0012|w\u000e]\u0005\u0005\u0005g\u0011IC\u0001\u0007SK\u000e|'\u000f\u001a*fC\u0012,'\u000f\u0005\u0003\u00038\t\u0005SB\u0001B\u001d\u0015\u0011\u0011YD!\u0010\u0002\t1\fgn\u001a\u0006\u0003\u0005\u007f\tAA[1wC&!!1\tB\u001d\u0005\u00111v.\u001b3\u0011\t\t\u001d#\u0011\n\u0007\u0001\t\u001d\u0011Y%\rb\u0001\u0005\u001b\u0012\u0011\u0001V\t\u0005\u0005\u001f\u0012)\u0006E\u0002l\u0005#J1Aa\u0015m\u0005\u001dqu\u000e\u001e5j]\u001e\u00042a\u001bB,\u0013\r\u0011I\u0006\u001c\u0002\u0004\u0003:L\bb\u0002B\u0001c\u0001\u0007!1\u0001\u0005\b\u0005?\n\u0004\u0019\u0001B1\u0003=\u0011W/\u001b7e%\u0016\fG-\u001a:Gk:\u001c\u0007cE6\u0003d\t\u001d\u00141\u001fB:\u0005\u007f\u00129J!*\u0003&\n\u0015\u0012b\u0001B3Y\nIa)\u001e8di&|gn\u000e\t\u0005\u0005S\u0012y'\u0004\u0002\u0003l)!!Q\u000eB\u0017\u0003\u0019i\u0017\r\u001d:fI&!!\u0011\u000fB6\u0005%1\u0015\u000e\\3Ta2LG\u000f\u0005\u0003\u0003v\tmTB\u0001B<\u0015\u0011\u0011IH!\u000b\u0002\tQ\f7o[\u0005\u0005\u0005{\u00129H\u0001\fUCN\\\u0017\t\u001e;f[B$8i\u001c8uKb$\u0018*\u001c9m!\u0015Y'\u0011\u0011BC\u0013\r\u0011\u0019\t\u001c\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\t\u001d%1S\u0007\u0003\u0005\u0013SAAa#\u0003\u000e\u0006I\u0001O]3eS\u000e\fG/\u001a\u0006\u0005\u0005\u001f\u0013\t*A\u0004gS2$XM\u001d\u001a\u000b\u0005=S\u0016\u0002\u0002BK\u0005\u0013\u0013qBR5mi\u0016\u0014\bK]3eS\u000e\fG/\u001a\t\u0006W\n\u0005%\u0011\u0014\t\u0005\u00057\u0013\t+\u0004\u0002\u0003\u001e*!!q\u0014B\u001f\u0003\u0011!\u0018.\\3\n\t\t\r&Q\u0014\u0002\u00075>tW-\u00133\u0011\t\t\u001d&q\u0019\b\u0005\u0005S\u0013\tM\u0004\u0003\u0003,\n}f\u0002\u0002BW\u0005{sAAa,\u0003<:!!\u0011\u0017B]\u001d\u0011\u0011\u0019La.\u000f\t\u0005m&QW\u0005\u0002;&\u00111\fX\u0005\u00033jK!a\u0016-\n\u0007\u0005eh+\u0003\u0003\u0002\u000e\u0005]\u0018\u0002\u0002Bb\u0005\u000b\faBU3cCN,G)\u0019;f)&lWM\u0003\u0003\u0002\u000e\u0005]\u0018\u0002\u0002Be\u0005\u0017\u0014!BU3cCN,7\u000b]3d\u0015\u0011\u0011\u0019M!2\u0002'\r\u0014X-\u0019;f%><()Y:f%\u0016\fG-\u001a:\u0015\t\tE'1\u001b\t\t\u0005O\u0011\tD!\u000e\u0002t\"9!\u0011\u0001\u001aA\u0002\t\r\u0011AG2sK\u0006$XMU8x\u0005\u0006\u001cX\rU1scV,GOU3bI\u0016\u0014H\u0003\u0005Bi\u00053\u0014iN!9\u0003f\n%(Q\u001eBy\u0011\u001d\u0011Yn\ra\u0001\u0005O\nQa\u001d9mSRDqAa84\u0001\u0004\t\u00190A\bqCJ$\u0018\u000e^5p]Z\u000bG.^3t\u0011\u001d\u0011\u0019o\ra\u0001\u0005g\nA\u0003[1e_>\u0004\u0018\t\u001e;f[B$8i\u001c8uKb$\bb\u0002Btg\u0001\u0007!qP\u0001\u0007aV\u001c\b.\u001a3\t\u000f\t-8\u00071\u0001\u0003\u0018\u0006I1m\u001c8wKJ$HK\u001f\u0005\b\u0005_\u001c\u0004\u0019\u0001BS\u0003I!\u0017\r^3uS6,'+\u001a2bg\u0016\u001c\u0006/Z2\t\u000f\tM8\u00071\u0001\u0003&\u0006y\u0011N\u001c;:mI+'-Y:f'B,7-\u0001\fde\u0016\fG/\u001a,fGR|'/\u001b>fIJ+\u0017\rZ3s)\u0011\u0011IPa@\u0011\t\u00055#1`\u0005\u0005\u0005{\fyEA\u000fWK\u000e$xN]5{K\u0012\u0004\u0016M]9vKR\u0014VmY8sIJ+\u0017\rZ3s\u0011\u001d\u0011\t\u0001\u000ea\u0001\u0005\u0007\tQd\u0019:fCR,\u0007+\u0019:rk\u0016$h+Z2u_JL'0\u001a3SK\u0006$WM\u001d\u000b\u0011\u0005s\u001c)aa\u0002\u0004\n\r-1QBB\b\u0007#AqAa76\u0001\u0004\u00119\u0007C\u0004\u0003`V\u0002\r!a=\t\u000f\t\rX\u00071\u0001\u0003t!9!q]\u001bA\u0002\t}\u0004b\u0002Bvk\u0001\u0007!q\u0013\u0005\b\u0005_,\u0004\u0019\u0001BS\u0011\u001d\u0011\u00190\u000ea\u0001\u0005K\u000bAaY8qsR\u0001\u00121LB\f\u00073\u0019Yb!\b\u0004 \r\u000521\u0005\u0005\bgZ\u0002\n\u00111\u0001v\u0011\u001dYh\u0007%AA\u0002uD\u0011\"!\u00067!\u0003\u0005\r!!\u0007\t\u0013\u0005\u001db\u0007%AA\u0002\u0005e\u0001\"CA\u0016mA\u0005\t\u0019AA\r\u0011%\tyC\u000eI\u0001\u0002\u0004\t\u0019\u0004C\u0005\u0002HY\u0002\n\u00111\u0001\u0002L\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAB\u0015U\r)81F\u0016\u0003\u0007[\u0001Baa\f\u0004:5\u00111\u0011\u0007\u0006\u0005\u0007g\u0019)$A\u0005v]\u000eDWmY6fI*\u00191q\u00077\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004<\rE\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAB!U\ri81F\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\u00199E\u000b\u0003\u0002\u001a\r-\u0012AD2paf$C-\u001a4bk2$H\u0005N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIY*\"a!\u0015+\t\u0005M21F\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00138+\t\u00199F\u000b\u0003\u0002L\r-\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0004^A!!qGB0\u0013\u0011\t9M!\u000f\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!QKB4\u0011%\u0019I\u0007QA\u0001\u0002\u0004\t\t*A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0007_\u0002ba!\u001d\u0004x\tUSBAB:\u0015\r\u0019)\b\\\u0001\u000bG>dG.Z2uS>t\u0017\u0002BB=\u0007g\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011\u0011OB@\u0011%\u0019IGQA\u0001\u0002\u0004\u0011)&\u0001\u0005iCND7i\u001c3f)\t\t\t*\u0001\u0005u_N#(/\u001b8h)\t\u0019i&\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003c\u001ai\tC\u0005\u0004j\u0015\u000b\t\u00111\u0001\u0003V\u0005i\u0002+\u0019:rk\u0016$\b+\u0019:uSRLwN\u001c*fC\u0012,'OR1di>\u0014\u0018\u0010E\u0002\u0002^\u001d\u001bBaRBKaB\u00112qSBOkv\fI\"!\u0007\u0002\u001a\u0005M\u00121JA.\u001b\t\u0019IJC\u0002\u0004\u001c2\fqA];oi&lW-\u0003\u0003\u0004 \u000ee%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ooQ\u00111\u0011S\u0001\u0006CB\u0004H.\u001f\u000b\u0011\u00037\u001a9k!+\u0004,\u000e56qVBY\u0007gCQa\u001d&A\u0002UDQa\u001f&A\u0002uDq!!\u0006K\u0001\u0004\tI\u0002C\u0004\u0002()\u0003\r!!\u0007\t\u000f\u0005-\"\n1\u0001\u0002\u001a!9\u0011q\u0006&A\u0002\u0005M\u0002bBA$\u0015\u0002\u0007\u00111J\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0019Il!1\u0011\u000b-\u0014\tia/\u0011\u001f-\u001ci,^?\u0002\u001a\u0005e\u0011\u0011DA\u001a\u0003\u0017J1aa0m\u0005\u0019!V\u000f\u001d7fo!I11Y&\u0002\u0002\u0003\u0007\u00111L\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"a!3\u0011\t\t]21Z\u0005\u0005\u0007\u001b\u0014ID\u0001\u0004PE*,7\r\u001e")
public class ParquetPartitionReaderFactory
extends FilePartitionReaderFactory
implements Logging,
Product,
scala.Serializable {
    private final SQLConf sqlConf;
    private final Broadcast<SerializableConfiguration> broadcastedConf;
    private final StructType dataSchema;
    private final StructType readDataSchema;
    private final StructType partitionSchema;
    private final Filter[] filters;
    private final ParquetOptions parquetOptions;
    private final boolean isCaseSensitive;
    private final StructType resultSchema;
    private final boolean enableOffHeapColumnVector;
    private final boolean enableVectorizedReader;
    private final boolean enableRecordFilter;
    private final boolean timestampConversion;
    private final int capacity;
    private final boolean enableParquetFilterPushDown;
    private final boolean pushDownDate;
    private final boolean pushDownTimestamp;
    private final boolean pushDownDecimal;
    private final boolean pushDownStringStartWith;
    private final int pushDownInFilterThreshold;
    private final String datetimeRebaseModeInRead;
    private final String int96RebaseModeInRead;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Option<Tuple7<SQLConf, Broadcast<SerializableConfiguration>, StructType, StructType, StructType, Filter[], ParquetOptions>> unapply(ParquetPartitionReaderFactory parquetPartitionReaderFactory) {
        return ParquetPartitionReaderFactory$.MODULE$.unapply(parquetPartitionReaderFactory);
    }

    public static ParquetPartitionReaderFactory apply(SQLConf sQLConf, Broadcast<SerializableConfiguration> broadcast, StructType structType, StructType structType2, StructType structType3, Filter[] filterArray, ParquetOptions parquetOptions) {
        return ParquetPartitionReaderFactory$.MODULE$.apply(sQLConf, broadcast, structType, structType2, structType3, filterArray, parquetOptions);
    }

    public static Function1<Tuple7<SQLConf, Broadcast<SerializableConfiguration>, StructType, StructType, StructType, Filter[], ParquetOptions>, ParquetPartitionReaderFactory> tupled() {
        return ParquetPartitionReaderFactory$.MODULE$.tupled();
    }

    public static Function1<SQLConf, Function1<Broadcast<SerializableConfiguration>, Function1<StructType, Function1<StructType, Function1<StructType, Function1<Filter[], Function1<ParquetOptions, ParquetPartitionReaderFactory>>>>>>> curried() {
        return ParquetPartitionReaderFactory$.MODULE$.curried();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SQLConf sqlConf() {
        return this.sqlConf;
    }

    public Broadcast<SerializableConfiguration> broadcastedConf() {
        return this.broadcastedConf;
    }

    public StructType dataSchema() {
        return this.dataSchema;
    }

    public StructType readDataSchema() {
        return this.readDataSchema;
    }

    public StructType partitionSchema() {
        return this.partitionSchema;
    }

    public Filter[] filters() {
        return this.filters;
    }

    public ParquetOptions parquetOptions() {
        return this.parquetOptions;
    }

    private boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    private StructType resultSchema() {
        return this.resultSchema;
    }

    private boolean enableOffHeapColumnVector() {
        return this.enableOffHeapColumnVector;
    }

    private boolean enableVectorizedReader() {
        return this.enableVectorizedReader;
    }

    private boolean enableRecordFilter() {
        return this.enableRecordFilter;
    }

    private boolean timestampConversion() {
        return this.timestampConversion;
    }

    private int capacity() {
        return this.capacity;
    }

    private boolean enableParquetFilterPushDown() {
        return this.enableParquetFilterPushDown;
    }

    private boolean pushDownDate() {
        return this.pushDownDate;
    }

    private boolean pushDownTimestamp() {
        return this.pushDownTimestamp;
    }

    private boolean pushDownDecimal() {
        return this.pushDownDecimal;
    }

    private boolean pushDownStringStartWith() {
        return this.pushDownStringStartWith;
    }

    private int pushDownInFilterThreshold() {
        return this.pushDownInFilterThreshold;
    }

    private String datetimeRebaseModeInRead() {
        return this.datetimeRebaseModeInRead;
    }

    private String int96RebaseModeInRead() {
        return this.int96RebaseModeInRead;
    }

    @Override
    public boolean supportColumnarReads(InputPartition partition) {
        return this.sqlConf().parquetVectorizedReaderEnabled() && this.sqlConf().wholeStageEnabled() && this.resultSchema().length() <= this.sqlConf().wholeStageMaxNumFields() && this.resultSchema().forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ParquetPartitionReaderFactory.$anonfun$supportColumnarReads$1(x$2)));
    }

    @Override
    public PartitionReader<InternalRow> buildReader(PartitionedFile file) {
        RecordReader<Void, InternalRow> reader = this.enableVectorizedReader() ? this.createVectorizedReader(file) : this.createRowBaseReader(file);
        PartitionReader<InternalRow> fileReader = new PartitionReader<InternalRow>(null, reader){
            private final RecordReader reader$1;

            public CustomTaskMetric[] currentMetricsValues() {
                return super.currentMetricsValues();
            }

            public boolean next() {
                return this.reader$1.nextKeyValue();
            }

            public InternalRow get() {
                return (InternalRow)this.reader$1.getCurrentValue();
            }

            public void close() {
                this.reader$1.close();
            }
            {
                this.reader$1 = reader$1;
            }
        };
        return new PartitionReaderWithPartitionValues(fileReader, this.readDataSchema(), this.partitionSchema(), file.partitionValues());
    }

    @Override
    public PartitionReader<ColumnarBatch> buildColumnarReader(PartitionedFile file) {
        VectorizedParquetRecordReader vectorizedReader = this.createVectorizedReader(file);
        vectorizedReader.enableReturningBatches();
        return new PartitionReader<ColumnarBatch>(null, vectorizedReader){
            private final VectorizedParquetRecordReader vectorizedReader$1;

            public CustomTaskMetric[] currentMetricsValues() {
                return super.currentMetricsValues();
            }

            public boolean next() {
                return this.vectorizedReader$1.nextKeyValue();
            }

            public ColumnarBatch get() {
                return (ColumnarBatch)this.vectorizedReader$1.getCurrentValue();
            }

            public void close() {
                this.vectorizedReader$1.close();
            }
            {
                this.vectorizedReader$1 = vectorizedReader$1;
            }
        };
    }

    private <T> RecordReader<Void, T> buildReaderBase(PartitionedFile file, Function7<FileSplit, InternalRow, TaskAttemptContextImpl, Option<FilterPredicate>, Option<ZoneId>, RebaseDateTime.RebaseSpec, RebaseDateTime.RebaseSpec, RecordReader<Void, T>> buildReaderFunc) {
        None$ none$;
        LazyRef footerFileMetaData$lzy = new LazyRef();
        Configuration conf = ((SerializableConfiguration)this.broadcastedConf().value()).value();
        Path filePath = new Path(new URI(file.filePath()));
        FileSplit split = new FileSplit(filePath, file.start(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
        Map map = ParquetPartitionReaderFactory.footerFileMetaData$1(footerFileMetaData$lzy, conf, filePath).getKeyValueMetaData();
        RebaseDateTime.RebaseSpec datetimeRebaseSpec = DataSourceUtils$.MODULE$.datetimeRebaseSpec((Function1<String, String>)(Function1 & Serializable & scala.Serializable)x$1 -> (String)map.get(x$1), this.datetimeRebaseModeInRead());
        if (this.enableParquetFilterPushDown()) {
            MessageType parquetSchema = ParquetPartitionReaderFactory.footerFileMetaData$1(footerFileMetaData$lzy, conf, filePath).getSchema();
            ParquetFilters parquetFilters = new ParquetFilters(parquetSchema, this.pushDownDate(), this.pushDownTimestamp(), this.pushDownDecimal(), this.pushDownStringStartWith(), this.pushDownInFilterThreshold(), this.isCaseSensitive(), datetimeRebaseSpec);
            none$ = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.filters())).flatMap((Function1 & Serializable & scala.Serializable)predicate -> Option$.MODULE$.option2Iterable(parquetFilters.createFilter((Filter)predicate)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FilterPredicate.class))))).reduceOption((Function2 & Serializable & scala.Serializable)(x$1, x$2) -> FilterApi.and((FilterPredicate)x$1, (FilterPredicate)x$2));
        } else {
            none$ = None$.MODULE$;
        }
        None$ pushed = none$;
        None$ convertTz = this.timestampConversion() && !ParquetPartitionReaderFactory.isCreatedByParquetMr$1(footerFileMetaData$lzy, conf, filePath) ? new Some((Object)DateTimeUtils$.MODULE$.getZoneId(conf.get(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()))) : None$.MODULE$;
        TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
        TaskAttemptContextImpl hadoopAttemptContext = new TaskAttemptContextImpl(conf, attemptId);
        if (pushed.isDefined()) {
            ParquetInputFormat.setFilterPredicate((Configuration)hadoopAttemptContext.getConfiguration(), (FilterPredicate)((FilterPredicate)pushed.get()));
        }
        Map map2 = ParquetPartitionReaderFactory.footerFileMetaData$1(footerFileMetaData$lzy, conf, filePath).getKeyValueMetaData();
        RebaseDateTime.RebaseSpec int96RebaseSpec = DataSourceUtils$.MODULE$.int96RebaseSpec((Function1<String, String>)(Function1 & Serializable & scala.Serializable)x$1 -> (String)map2.get(x$1), this.int96RebaseModeInRead());
        RecordReader reader = (RecordReader)buildReaderFunc.apply((Object)split, (Object)file.partitionValues(), (Object)hadoopAttemptContext, (Object)pushed, (Object)convertTz, (Object)datetimeRebaseSpec, (Object)int96RebaseSpec);
        reader.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
        return reader;
    }

    private RecordReader<Void, InternalRow> createRowBaseReader(PartitionedFile file) {
        return this.buildReaderBase(file, (Function7 & Serializable & scala.Serializable)(split, partitionValues, hadoopAttemptContext, pushed, convertTz, datetimeRebaseSpec, int96RebaseSpec) -> this.createRowBaseParquetReader((FileSplit)split, (InternalRow)partitionValues, (TaskAttemptContextImpl)hadoopAttemptContext, (Option<FilterPredicate>)pushed, (Option<ZoneId>)convertTz, (RebaseDateTime.RebaseSpec)datetimeRebaseSpec, (RebaseDateTime.RebaseSpec)int96RebaseSpec));
    }

    private RecordReader<Void, InternalRow> createRowBaseParquetReader(FileSplit split, InternalRow partitionValues, TaskAttemptContextImpl hadoopAttemptContext, Option<FilterPredicate> pushed, Option<ZoneId> convertTz, RebaseDateTime.RebaseSpec datetimeRebaseSpec, RebaseDateTime.RebaseSpec int96RebaseSpec) {
        ParquetRecordReader parquetRecordReader;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Falling back to parquet-mr");
        Option taskContext = Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get());
        ParquetReadSupport readSupport = new ParquetReadSupport(convertTz, false, datetimeRebaseSpec, int96RebaseSpec);
        if (pushed.isDefined() && this.enableRecordFilter()) {
            FilterCompat.Filter parquetFilter = FilterCompat.get((FilterPredicate)((FilterPredicate)pushed.get()), null);
            parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport, parquetFilter);
        } else {
            parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport);
        }
        ParquetRecordReader reader = parquetRecordReader;
        RecordReaderIterator iter = new RecordReaderIterator(reader);
        taskContext.foreach((Function1 & Serializable & scala.Serializable)x$3 -> x$3.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$4 -> {
            iter.close();
            return BoxedUnit.UNIT;
        }));
        return reader;
    }

    /*
     * WARNING - void declaration
     */
    private VectorizedParquetRecordReader createVectorizedReader(PartitionedFile file) {
        void var2_2;
        VectorizedParquetRecordReader vectorizedReader = (VectorizedParquetRecordReader)this.buildReaderBase(file, (Function7 & Serializable & scala.Serializable)(split, partitionValues, hadoopAttemptContext, pushed, convertTz, datetimeRebaseSpec, int96RebaseSpec) -> this.createParquetVectorizedReader((FileSplit)split, (InternalRow)partitionValues, (TaskAttemptContextImpl)hadoopAttemptContext, (Option<FilterPredicate>)pushed, (Option<ZoneId>)convertTz, (RebaseDateTime.RebaseSpec)datetimeRebaseSpec, (RebaseDateTime.RebaseSpec)int96RebaseSpec));
        vectorizedReader.initBatch(this.partitionSchema(), file.partitionValues());
        return var2_2;
    }

    private VectorizedParquetRecordReader createParquetVectorizedReader(FileSplit split, InternalRow partitionValues, TaskAttemptContextImpl hadoopAttemptContext, Option<FilterPredicate> pushed, Option<ZoneId> convertTz, RebaseDateTime.RebaseSpec datetimeRebaseSpec, RebaseDateTime.RebaseSpec int96RebaseSpec) {
        Option taskContext = Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get());
        VectorizedParquetRecordReader vectorizedReader = new VectorizedParquetRecordReader((ZoneId)convertTz.orNull(Predef$.MODULE$.$conforms()), datetimeRebaseSpec.mode().toString(), datetimeRebaseSpec.timeZone(), int96RebaseSpec.mode().toString(), int96RebaseSpec.timeZone(), this.enableOffHeapColumnVector() && taskContext.isDefined(), this.capacity());
        RecordReaderIterator<Object> iter = new RecordReaderIterator<Object>(vectorizedReader);
        taskContext.foreach((Function1 & Serializable & scala.Serializable)x$5 -> x$5.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$6 -> {
            iter.close();
            return BoxedUnit.UNIT;
        }));
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("Appending ").append(this.partitionSchema()).append(" ").append(partitionValues).toString());
        return vectorizedReader;
    }

    public ParquetPartitionReaderFactory copy(SQLConf sqlConf, Broadcast<SerializableConfiguration> broadcastedConf, StructType dataSchema, StructType readDataSchema, StructType partitionSchema, Filter[] filters, ParquetOptions parquetOptions) {
        return new ParquetPartitionReaderFactory(sqlConf, broadcastedConf, dataSchema, readDataSchema, partitionSchema, filters, parquetOptions);
    }

    public SQLConf copy$default$1() {
        return this.sqlConf();
    }

    public Broadcast<SerializableConfiguration> copy$default$2() {
        return this.broadcastedConf();
    }

    public StructType copy$default$3() {
        return this.dataSchema();
    }

    public StructType copy$default$4() {
        return this.readDataSchema();
    }

    public StructType copy$default$5() {
        return this.partitionSchema();
    }

    public Filter[] copy$default$6() {
        return this.filters();
    }

    public ParquetOptions copy$default$7() {
        return this.parquetOptions();
    }

    public String productPrefix() {
        return "ParquetPartitionReaderFactory";
    }

    public int productArity() {
        return 7;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.sqlConf();
                break;
            }
            case 1: {
                object = this.broadcastedConf();
                break;
            }
            case 2: {
                object = this.dataSchema();
                break;
            }
            case 3: {
                object = this.readDataSchema();
                break;
            }
            case 4: {
                object = this.partitionSchema();
                break;
            }
            case 5: {
                object = this.filters();
                break;
            }
            case 6: {
                object = this.parquetOptions();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ParquetPartitionReaderFactory;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ParquetPartitionReaderFactory)) return false;
        boolean bl = true;
        if (!bl) return false;
        ParquetPartitionReaderFactory parquetPartitionReaderFactory = (ParquetPartitionReaderFactory)x$1;
        SQLConf sQLConf = this.sqlConf();
        SQLConf sQLConf2 = parquetPartitionReaderFactory.sqlConf();
        if (sQLConf == null) {
            if (sQLConf2 != null) {
                return false;
            }
        } else if (!sQLConf.equals(sQLConf2)) return false;
        Broadcast<SerializableConfiguration> broadcast = this.broadcastedConf();
        Broadcast<SerializableConfiguration> broadcast2 = parquetPartitionReaderFactory.broadcastedConf();
        if (broadcast == null) {
            if (broadcast2 != null) {
                return false;
            }
        } else if (!broadcast.equals(broadcast2)) return false;
        StructType structType = this.dataSchema();
        StructType structType2 = parquetPartitionReaderFactory.dataSchema();
        if (structType == null) {
            if (structType2 != null) {
                return false;
            }
        } else if (!structType.equals(structType2)) return false;
        StructType structType3 = this.readDataSchema();
        StructType structType4 = parquetPartitionReaderFactory.readDataSchema();
        if (structType3 == null) {
            if (structType4 != null) {
                return false;
            }
        } else if (!structType3.equals(structType4)) return false;
        StructType structType5 = this.partitionSchema();
        StructType structType6 = parquetPartitionReaderFactory.partitionSchema();
        if (structType5 == null) {
            if (structType6 != null) {
                return false;
            }
        } else if (!structType5.equals(structType6)) return false;
        if (this.filters() != parquetPartitionReaderFactory.filters()) return false;
        ParquetOptions parquetOptions = this.parquetOptions();
        ParquetOptions parquetOptions2 = parquetPartitionReaderFactory.parquetOptions();
        if (parquetOptions == null) {
            if (parquetOptions2 != null) {
                return false;
            }
        } else if (!parquetOptions.equals(parquetOptions2)) return false;
        if (!parquetPartitionReaderFactory.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$enableVectorizedReader$1(StructField x$1) {
        return x$1.dataType() instanceof AtomicType;
    }

    public static final /* synthetic */ boolean $anonfun$supportColumnarReads$1(StructField x$2) {
        return x$2.dataType() instanceof AtomicType;
    }

    private static final /* synthetic */ FileMetaData footerFileMetaData$lzycompute$1(LazyRef footerFileMetaData$lzy$1, Configuration conf$1, Path filePath$1) {
        FileMetaData fileMetaData;
        LazyRef lazyRef = footerFileMetaData$lzy$1;
        synchronized (lazyRef) {
            fileMetaData = footerFileMetaData$lzy$1.initialized() ? (FileMetaData)footerFileMetaData$lzy$1.value() : (FileMetaData)footerFileMetaData$lzy$1.initialize((Object)ParquetFooterReader.readFooter(conf$1, filePath$1, ParquetMetadataConverter.SKIP_ROW_GROUPS).getFileMetaData());
        }
        return fileMetaData;
    }

    private static final FileMetaData footerFileMetaData$1(LazyRef footerFileMetaData$lzy$1, Configuration conf$1, Path filePath$1) {
        return footerFileMetaData$lzy$1.initialized() ? (FileMetaData)footerFileMetaData$lzy$1.value() : ParquetPartitionReaderFactory.footerFileMetaData$lzycompute$1(footerFileMetaData$lzy$1, conf$1, filePath$1);
    }

    private static final boolean isCreatedByParquetMr$1(LazyRef footerFileMetaData$lzy$1, Configuration conf$1, Path filePath$1) {
        return ParquetPartitionReaderFactory.footerFileMetaData$1(footerFileMetaData$lzy$1, conf$1, filePath$1).getCreatedBy().startsWith("parquet-mr");
    }

    public ParquetPartitionReaderFactory(SQLConf sqlConf, Broadcast<SerializableConfiguration> broadcastedConf, StructType dataSchema, StructType readDataSchema, StructType partitionSchema, Filter[] filters, ParquetOptions parquetOptions) {
        this.sqlConf = sqlConf;
        this.broadcastedConf = broadcastedConf;
        this.dataSchema = dataSchema;
        this.readDataSchema = readDataSchema;
        this.partitionSchema = partitionSchema;
        this.filters = filters;
        this.parquetOptions = parquetOptions;
        Logging.$init$((Logging)this);
        Product.$init$((Product)this);
        this.isCaseSensitive = sqlConf.caseSensitiveAnalysis();
        this.resultSchema = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])readDataSchema.fields())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        this.enableOffHeapColumnVector = sqlConf.offHeapColumnVectorEnabled();
        this.enableVectorizedReader = sqlConf.parquetVectorizedReaderEnabled() && this.resultSchema().forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ParquetPartitionReaderFactory.$anonfun$enableVectorizedReader$1(x$1)));
        this.enableRecordFilter = sqlConf.parquetRecordFilterEnabled();
        this.timestampConversion = sqlConf.isParquetINT96TimestampConversion();
        this.capacity = sqlConf.parquetVectorizedReaderBatchSize();
        this.enableParquetFilterPushDown = sqlConf.parquetFilterPushDown();
        this.pushDownDate = sqlConf.parquetFilterPushDownDate();
        this.pushDownTimestamp = sqlConf.parquetFilterPushDownTimestamp();
        this.pushDownDecimal = sqlConf.parquetFilterPushDownDecimal();
        this.pushDownStringStartWith = sqlConf.parquetFilterPushDownStringStartWith();
        this.pushDownInFilterThreshold = sqlConf.parquetFilterPushDownInFilterThreshold();
        this.datetimeRebaseModeInRead = parquetOptions.datetimeRebaseModeInRead();
        this.int96RebaseModeInRead = parquetOptions.int96RebaseModeInRead();
    }
}

