/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.Histogram;
import org.apache.spark.sql.catalyst.plans.logical.HistogramBin;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.command.DescribeColumnCommand$;
import org.apache.spark.sql.execution.command.LeafRunnableCommand;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.types.DataType;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005]g\u0001\u0002\u0010 \u00012B\u0001\u0002\u0012\u0001\u0003\u0016\u0004%\t!\u0012\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005\r\"A1\n\u0001BK\u0002\u0013\u0005A\n\u0003\u0005b\u0001\tE\t\u0015!\u0003N\u0011!\u0011\u0007A!f\u0001\n\u0003\u0019\u0007\u0002C4\u0001\u0005#\u0005\u000b\u0011\u00023\t\u0011!\u0004!Q3A\u0005B%D\u0001\"\u001d\u0001\u0003\u0012\u0003\u0006IA\u001b\u0005\u0006e\u0002!\ta\u001d\u0005\u0006s\u0002!\tE\u001f\u0005\b\u0003\u0017\u0001A\u0011BA\u0007\u0011%\tI\u0002AA\u0001\n\u0003\tY\u0002C\u0005\u0002&\u0001\t\n\u0011\"\u0001\u0002(!I\u0011Q\b\u0001\u0012\u0002\u0013\u0005\u0011q\b\u0005\n\u0003\u0007\u0002\u0011\u0013!C\u0001\u0003\u000bB\u0011\"!\u0013\u0001#\u0003%\t!a\u0013\t\u0013\u0005=\u0003!!A\u0005B\u0005E\u0003\"CA1\u0001\u0005\u0005I\u0011AA2\u0011%\tY\u0007AA\u0001\n\u0003\ti\u0007C\u0005\u0002z\u0001\t\t\u0011\"\u0011\u0002|!I\u0011\u0011\u0012\u0001\u0002\u0002\u0013\u0005\u00111\u0012\u0005\n\u0003\u001f\u0003\u0011\u0011!C!\u0003#;\u0011\"!& \u0003\u0003E\t!a&\u0007\u0011yy\u0012\u0011!E\u0001\u00033CaA\u001d\r\u0005\u0002\u0005\u001d\u0006\"CAU1\u0005\u0005IQIAV\u0011%\ti\u000bGA\u0001\n\u0003\u000by\u000bC\u0005\u0002:b\t\t\u0011\"!\u0002<\"I\u0011Q\u001a\r\u0002\u0002\u0013%\u0011q\u001a\u0002\u0016\t\u0016\u001c8M]5cK\u000e{G.^7o\u0007>lW.\u00198e\u0015\t\u0001\u0013%A\u0004d_6l\u0017M\u001c3\u000b\u0005\t\u001a\u0013!C3yK\u000e,H/[8o\u0015\t!S%A\u0002tc2T!AJ\u0014\u0002\u000bM\u0004\u0018M]6\u000b\u0005!J\u0013AB1qC\u000eDWMC\u0001+\u0003\ry'oZ\u0002\u0001'\u0015\u0001QfN\u001eB!\tqS'D\u00010\u0015\t\u0001\u0014'A\u0004m_\u001eL7-\u00197\u000b\u0005I\u001a\u0014!\u00029mC:\u001c(B\u0001\u001b$\u0003!\u0019\u0017\r^1msN$\u0018B\u0001\u001c0\u0005-aunZ5dC2\u0004F.\u00198\u0011\u0005aJT\"A\u0010\n\u0005iz\"a\u0005'fC\u001a\u0014VO\u001c8bE2,7i\\7nC:$\u0007C\u0001\u001f@\u001b\u0005i$\"\u0001 \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001k$a\u0002)s_\u0012,8\r\u001e\t\u0003y\tK!aQ\u001f\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u000bQ\f'\r\\3\u0016\u0003\u0019\u0003\"a\u0012%\u000e\u0003MJ!!S\u001a\u0003\u001fQ\u000b'\r\\3JI\u0016tG/\u001b4jKJ\fa\u0001^1cY\u0016\u0004\u0013\u0001D2pY:\u000bW.\u001a)beR\u001cX#A'\u0011\u000793\u0016L\u0004\u0002P):\u0011\u0001kU\u0007\u0002#*\u0011!kK\u0001\u0007yI|w\u000e\u001e \n\u0003yJ!!V\u001f\u0002\u000fA\f7m[1hK&\u0011q\u000b\u0017\u0002\u0004'\u0016\f(BA+>!\tQfL\u0004\u0002\\9B\u0011\u0001+P\u0005\u0003;v\na\u0001\u0015:fI\u00164\u0017BA0a\u0005\u0019\u0019FO]5oO*\u0011Q,P\u0001\u000eG>dg*Y7f!\u0006\u0014Ho\u001d\u0011\u0002\u0015%\u001cX\t\u001f;f]\u0012,G-F\u0001e!\taT-\u0003\u0002g{\t9!i\\8mK\u0006t\u0017aC5t\u000bb$XM\u001c3fI\u0002\naa\\;uaV$X#\u00016\u0011\u0007936\u000e\u0005\u0002m_6\tQN\u0003\u0002og\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\t\u0001XNA\u0005BiR\u0014\u0018NY;uK\u00069q.\u001e;qkR\u0004\u0013A\u0002\u001fj]&$h\bF\u0003ukZ<\b\u0010\u0005\u00029\u0001!)A)\u0003a\u0001\r\")1*\u0003a\u0001\u001b\")!-\u0003a\u0001I\")\u0001.\u0003a\u0001U\u0006\u0019!/\u001e8\u0015\u0007m\f\t\u0001E\u0002O-r\u0004\"! @\u000e\u0003\rJ!a`\u0012\u0003\u0007I{w\u000fC\u0004\u0002\u0004)\u0001\r!!\u0002\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0007u\f9!C\u0002\u0002\n\r\u0012Ab\u00159be.\u001cVm]:j_:\fA\u0003[5ti><'/Y7EKN\u001c'/\u001b9uS>tGcA>\u0002\u0010!9\u0011\u0011C\u0006A\u0002\u0005M\u0011!\u00035jgR|wM]1n!\rq\u0013QC\u0005\u0004\u0003/y#!\u0003%jgR|wM]1n\u0003\u0011\u0019w\u000e]=\u0015\u0013Q\fi\"a\b\u0002\"\u0005\r\u0002b\u0002#\r!\u0003\u0005\rA\u0012\u0005\b\u00172\u0001\n\u00111\u0001N\u0011\u001d\u0011G\u0002%AA\u0002\u0011Dq\u0001\u001b\u0007\u0011\u0002\u0003\u0007!.\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005%\"f\u0001$\u0002,-\u0012\u0011Q\u0006\t\u0005\u0003_\tI$\u0004\u0002\u00022)!\u00111GA\u001b\u0003%)hn\u00195fG.,GMC\u0002\u00028u\n!\"\u00198o_R\fG/[8o\u0013\u0011\tY$!\r\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\u0005#fA'\u0002,\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAA$U\r!\u00171F\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\tiEK\u0002k\u0003W\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA*!\u0011\t)&a\u0018\u000e\u0005\u0005]#\u0002BA-\u00037\nA\u0001\\1oO*\u0011\u0011QL\u0001\u0005U\u00064\u0018-C\u0002`\u0003/\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u001a\u0011\u0007q\n9'C\u0002\u0002ju\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\u001c\u0002vA\u0019A(!\u001d\n\u0007\u0005MTHA\u0002B]fD\u0011\"a\u001e\u0014\u0003\u0003\u0005\r!!\u001a\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ti\b\u0005\u0004\u0002\u0000\u0005\u0015\u0015qN\u0007\u0003\u0003\u0003S1!a!>\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u000f\u000b\tI\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u00013\u0002\u000e\"I\u0011qO\u000b\u0002\u0002\u0003\u0007\u0011qN\u0001\u0007KF,\u0018\r\\:\u0015\u0007\u0011\f\u0019\nC\u0005\u0002xY\t\t\u00111\u0001\u0002p\u0005)B)Z:de&\u0014WmQ8mk6t7i\\7nC:$\u0007C\u0001\u001d\u0019'\u0011A\u00121T!\u0011\u0013\u0005u\u00151\u0015$NI*$XBAAP\u0015\r\t\t+P\u0001\beVtG/[7f\u0013\u0011\t)+a(\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tG\u0007\u0006\u0002\u0002\u0018\u0006AAo\\*ue&tw\r\u0006\u0002\u0002T\u0005)\u0011\r\u001d9msRIA/!-\u00024\u0006U\u0016q\u0017\u0005\u0006\tn\u0001\rA\u0012\u0005\u0006\u0017n\u0001\r!\u0014\u0005\u0006En\u0001\r\u0001\u001a\u0005\u0006Qn\u0001\rA[\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\ti,!3\u0011\u000bq\ny,a1\n\u0007\u0005\u0005WH\u0001\u0004PaRLwN\u001c\t\by\u0005\u0015g)\u00143k\u0013\r\t9-\u0010\u0002\u0007)V\u0004H.\u001a\u001b\t\u0011\u0005-G$!AA\u0002Q\f1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005E\u0007\u0003BA+\u0003'LA!!6\u0002X\t1qJ\u00196fGR\u0004")
public class DescribeColumnCommand
extends LogicalPlan
implements LeafRunnableCommand,
scala.Serializable {
    private final TableIdentifier table;
    private final Seq<String> colNameParts;
    private final boolean isExtended;
    private final Seq<Attribute> output;
    private Map<String, SQLMetric> metrics;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple4<TableIdentifier, Seq<String>, Object, Seq<Attribute>>> unapply(DescribeColumnCommand describeColumnCommand) {
        return DescribeColumnCommand$.MODULE$.unapply(describeColumnCommand);
    }

    public static Function1<Tuple4<TableIdentifier, Seq<String>, Object, Seq<Attribute>>, DescribeColumnCommand> tupled() {
        return DescribeColumnCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Seq<String>, Function1<Object, Function1<Seq<Attribute>, DescribeColumnCommand>>>> curried() {
        return DescribeColumnCommand$.MODULE$.curried();
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        DescribeColumnCommand describeColumnCommand = this;
        synchronized (describeColumnCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public TableIdentifier table() {
        return this.table;
    }

    public Seq<String> colNameParts() {
        return this.colNameParts;
    }

    public boolean isExtended() {
        return this.isExtended;
    }

    public Seq<Attribute> output() {
        return this.output;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        BoxedUnit boxedUnit;
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        Function2 resolver = sparkSession.sessionState().conf().resolver();
        LogicalPlan relation = sparkSession.table(this.table()).queryExecution().analyzed();
        String colName = new UnresolvedAttribute(this.colNameParts()).name();
        NamedExpression field = (NamedExpression)relation.resolve(this.colNameParts(), resolver).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw QueryCompilationErrors$.MODULE$.columnDoesNotExistError(colName);
        });
        if (!(field instanceof Attribute)) {
            throw QueryCompilationErrors$.MODULE$.commandNotSupportNestedColumnError("DESC TABLE COLUMN", colName);
        }
        CatalogTable catalogTable = catalog.getTempViewOrPermanentTableMetadata(this.table());
        Map colStatsMap = (Map)catalogTable.stats().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.colStats()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
        Map colStats = this.conf().caseSensitiveAnalysis() ? colStatsMap : CaseInsensitiveMap$.MODULE$.apply(colStatsMap);
        Option cs = colStats.get((Object)field.name());
        None$ comment = field.metadata().contains("comment") ? Option$.MODULE$.apply((Object)field.metadata().getString("comment")) : None$.MODULE$;
        String dataType = ((DataType)CharVarcharUtils$.MODULE$.getRawType(field.metadata()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ((Expression)field).dataType())).catalogString();
        ArrayBuffer buffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"col_name", field.name()})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"data_type", dataType})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"comment", comment.getOrElse((Function0 & Serializable & scala.Serializable)() -> "NULL")}))}));
        if (this.isExtended()) {
            buffer.$plus$eq((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"min", cs.flatMap((Function1 & Serializable & scala.Serializable)x$7 -> x$7.min().map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.toString())).getOrElse((Function0 & Serializable & scala.Serializable)() -> "NULL")})));
            buffer.$plus$eq((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"max", cs.flatMap((Function1 & Serializable & scala.Serializable)x$9 -> x$9.max().map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.toString())).getOrElse((Function0 & Serializable & scala.Serializable)() -> "NULL")})));
            buffer.$plus$eq((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"num_nulls", cs.flatMap((Function1 & Serializable & scala.Serializable)x$11 -> x$11.nullCount().map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.toString())).getOrElse((Function0 & Serializable & scala.Serializable)() -> "NULL")})));
            buffer.$plus$eq((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"distinct_count", cs.flatMap((Function1 & Serializable & scala.Serializable)x$13 -> x$13.distinctCount().map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.toString())).getOrElse((Function0 & Serializable & scala.Serializable)() -> "NULL")})));
            buffer.$plus$eq((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"avg_col_len", cs.flatMap((Function1 & Serializable & scala.Serializable)x$15 -> x$15.avgLen().map((Function1 & Serializable & scala.Serializable)x$16 -> DescribeColumnCommand.$anonfun$run$32(BoxesRunTime.unboxToLong((Object)x$16)))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "NULL")})));
            buffer.$plus$eq((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"max_col_len", cs.flatMap((Function1 & Serializable & scala.Serializable)x$17 -> x$17.maxLen().map((Function1 & Serializable & scala.Serializable)x$18 -> DescribeColumnCommand.$anonfun$run$35(BoxesRunTime.unboxToLong((Object)x$18)))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "NULL")})));
            Option histDesc = cs.flatMap((Function1 & Serializable & scala.Serializable)c -> c.histogram().map((Function1 & Serializable & scala.Serializable)hist -> this.histogramDescription((Histogram)hist)));
            boxedUnit = buffer.$plus$plus$eq((TraversableOnce)histDesc.getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"histogram", "NULL"})), (List)Nil$.MODULE$)));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return buffer.toSeq();
    }

    private Seq<Row> histogramDescription(Histogram histogram) {
        Row header = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"histogram", new StringBuilder(23).append("height: ").append(histogram.height()).append(", num_of_bins: ").append(histogram.bins().length).toString()}));
        Row[] bins = (Row[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])histogram.bins())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            HistogramBin bin = (HistogramBin)tuple2._1();
            int index = tuple2._2$mcI$sp();
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(4).append("bin_").append(index).toString(), new StringBuilder(46).append("lower_bound: ").append(bin.lo()).append(", upper_bound: ").append(bin.hi()).append(", distinct_count: ").append(bin.ndv()).toString()}));
            return row;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)));
        Row row = header;
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])bins)).$plus$colon((Object)row, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public DescribeColumnCommand copy(TableIdentifier table, Seq<String> colNameParts, boolean isExtended, Seq<Attribute> output) {
        return new DescribeColumnCommand(table, colNameParts, isExtended, output);
    }

    public TableIdentifier copy$default$1() {
        return this.table();
    }

    public Seq<String> copy$default$2() {
        return this.colNameParts();
    }

    public boolean copy$default$3() {
        return this.isExtended();
    }

    public Seq<Attribute> copy$default$4() {
        return this.output();
    }

    public String productPrefix() {
        return "DescribeColumnCommand";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.table();
                break;
            }
            case 1: {
                object = this.colNameParts();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.isExtended());
                break;
            }
            case 3: {
                object = this.output();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DescribeColumnCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DescribeColumnCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        DescribeColumnCommand describeColumnCommand = (DescribeColumnCommand)x$1;
        TableIdentifier tableIdentifier = this.table();
        TableIdentifier tableIdentifier2 = describeColumnCommand.table();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Seq<String> seq = this.colNameParts();
        Seq<String> seq2 = describeColumnCommand.colNameParts();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (this.isExtended() != describeColumnCommand.isExtended()) return false;
        Seq<Attribute> seq3 = this.output();
        Seq<Attribute> seq4 = describeColumnCommand.output();
        if (seq3 == null) {
            if (seq4 != null) {
                return false;
            }
        } else if (!seq3.equals(seq4)) return false;
        if (!describeColumnCommand.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ String $anonfun$run$32(long x$16) {
        return Long.toString(x$16);
    }

    public static final /* synthetic */ String $anonfun$run$35(long x$18) {
        return Long.toString(x$18);
    }

    public DescribeColumnCommand(TableIdentifier table, Seq<String> colNameParts, boolean isExtended, Seq<Attribute> output) {
        this.table = table;
        this.colNameParts = colNameParts;
        this.isExtended = isExtended;
        this.output = output;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
        LeafLike.$init$((LeafLike)this);
    }
}

