/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.net.URI;
import java.time.ZoneId;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetOutputCommitter;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.codec.CodecConfig;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.util.ContextUtil;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.RebaseDateTime;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFilters;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFooterReader;
import org.apache.spark.sql.execution.datasources.parquet.ParquetLogRedirector;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOutputWriter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetUtils$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedParquetRecordReader;
import org.apache.spark.sql.execution.vectorized.OffHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.AnsiIntervalType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

@ScalaSignature(bytes="\u0006\u0001\t-c\u0001B\r\u001b\u0001%BQa\u0011\u0001\u0005\u0002\u0011Cqa\u0012\u0001C\u0002\u0013%\u0001\n\u0003\u0004M\u0001\u0001\u0006I!\u0013\u0005\u0006\u001b\u0002!\tE\u0014\u0005\u00065\u0002!\tE\u0014\u0005\u00067\u0002!\t\u0005\u0018\u0005\u0006A\u0002!\t%\u0019\u0005\u0006U\u0002!\te\u001b\u0005\b\u00033\u0001A\u0011IA\u000e\u0011\u001d\tY\u0005\u0001C!\u0003\u001bBq!!\u0016\u0001\t\u0003\n9\u0006C\u0004\u0002t\u0001!\t%!\u001e\t\u000f\u0005\u0015\u0005\u0001\"\u0011\u0002\b\"9\u0011Q\u001a\u0001\u0005B\u0005=\u0007bBAn\u0001\u0011\u0005\u0013Q\\\u0004\b\u0003GT\u0002\u0012AAs\r\u0019I\"\u0004#\u0001\u0002h\"11)\u0005C\u0001\u0003SD\u0001\"a;\u0012\t\u0003Q\u0012Q\u001e\u0005\t\u0005\u0007\tB\u0011\u0001\u000e\u0003\u0006!9!\u0011C\t\u0005\u0002\tM\u0001b\u0002B\u000f#\u0011\u0005!q\u0004\u0005\b\u0005_\tB\u0011\u0002B\u0019\u0011%\u00119$EA\u0001\n\u0013\u0011IDA\tQCJ\fX/\u001a;GS2,gi\u001c:nCRT!a\u0007\u000f\u0002\u000fA\f'/];fi*\u0011QDH\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002 A\u0005IQ\r_3dkRLwN\u001c\u0006\u0003C\t\n1a]9m\u0015\t\u0019C%A\u0003ta\u0006\u00148N\u0003\u0002&M\u00051\u0011\r]1dQ\u0016T\u0011aJ\u0001\u0004_J<7\u0001A\n\u0007\u0001)\u0002DG\u000f!\u0011\u0005-rS\"\u0001\u0017\u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0003\r\u0005s\u0017PU3g!\t\t$'D\u0001\u001d\u0013\t\u0019DD\u0001\u0006GS2,gi\u001c:nCR\u0004\"!\u000e\u001d\u000e\u0003YR!a\u000e\u0011\u0002\u000fM|WO]2fg&\u0011\u0011H\u000e\u0002\u0013\t\u0006$\u0018mU8ve\u000e,'+Z4jgR,'\u000f\u0005\u0002<}5\tAH\u0003\u0002>E\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002@y\t9Aj\\4hS:<\u0007CA\u0016B\u0013\t\u0011EF\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0004=S:LGO\u0010\u000b\u0002\u000bB\u0011a\tA\u0007\u00025\u0005!\u0002/\u0019:rk\u0016$Hj\\4SK\u0012L'/Z2u_J,\u0012!\u0013\t\u0003\r*K!a\u0013\u000e\u0003)A\u000b'/];fi2{wMU3eSJ,7\r^8s\u0003U\u0001\u0018M]9vKRdun\u001a*fI&\u0014Xm\u0019;pe\u0002\n\u0011b\u001d5peRt\u0015-\\3\u0015\u0003=\u0003\"\u0001U,\u000f\u0005E+\u0006C\u0001*-\u001b\u0005\u0019&B\u0001+)\u0003\u0019a$o\\8u}%\u0011a\u000bL\u0001\u0007!J,G-\u001a4\n\u0005aK&AB*ue&twM\u0003\u0002WY\u0005AAo\\*ue&tw-\u0001\u0005iCND7i\u001c3f)\u0005i\u0006CA\u0016_\u0013\tyFFA\u0002J]R\fa!Z9vC2\u001cHC\u00012f!\tY3-\u0003\u0002eY\t9!i\\8mK\u0006t\u0007\"\u00024\b\u0001\u00049\u0017!B8uQ\u0016\u0014\bCA\u0016i\u0013\tIGFA\u0002B]f\fA\u0002\u001d:fa\u0006\u0014Xm\u0016:ji\u0016$b\u0001\\8v\u007f\u0006%\u0001CA\u0019n\u0013\tqGDA\nPkR\u0004X\u000f^,sSR,'OR1di>\u0014\u0018\u0010C\u0003q\u0011\u0001\u0007\u0011/\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0002sg6\t\u0001%\u0003\u0002uA\ta1\u000b]1sWN+7o]5p]\")a\u000f\u0003a\u0001o\u0006\u0019!n\u001c2\u0011\u0005alX\"A=\u000b\u0005i\\\u0018!C7baJ,G-^2f\u0015\taH%\u0001\u0004iC\u0012|w\u000e]\u0005\u0003}f\u00141AS8c\u0011\u001d\t\t\u0001\u0003a\u0001\u0003\u0007\tqa\u001c9uS>t7\u000fE\u0003Q\u0003\u000byu*C\u0002\u0002\be\u00131!T1q\u0011\u001d\tY\u0001\u0003a\u0001\u0003\u001b\t!\u0002Z1uCN\u001b\u0007.Z7b!\u0011\ty!!\u0006\u000e\u0005\u0005E!bAA\nA\u0005)A/\u001f9fg&!\u0011qCA\t\u0005)\u0019FO];diRK\b/Z\u0001\fS:4WM]*dQ\u0016l\u0017\r\u0006\u0005\u0002\u001e\u0005\r\u0012QEA\u0015!\u0015Y\u0013qDA\u0007\u0013\r\t\t\u0003\f\u0002\u0007\u001fB$\u0018n\u001c8\t\u000bAL\u0001\u0019A9\t\u000f\u0005\u001d\u0012\u00021\u0001\u0002\u0004\u0005Q\u0001/\u0019:b[\u0016$XM]:\t\u000f\u0005-\u0012\u00021\u0001\u0002.\u0005)a-\u001b7fgB1\u0011qFA\u001d\u0003\u007fqA!!\r\u000269\u0019!+a\r\n\u00035J1!a\u000e-\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u000f\u0002>\t\u00191+Z9\u000b\u0007\u0005]B\u0006\u0005\u0003\u0002B\u0005\u001dSBAA\"\u0015\r\t)e_\u0001\u0003MNLA!!\u0013\u0002D\tQa)\u001b7f'R\fG/^:\u0002\u0019M,\b\u000f]8si\n\u000bGo\u00195\u0015\u000b\t\fy%!\u0015\t\u000bAT\u0001\u0019A9\t\u000f\u0005M#\u00021\u0001\u0002\u000e\u000511o\u00195f[\u0006\f1B^3di>\u0014H+\u001f9fgRA\u0011\u0011LA/\u0003C\n)\u0007E\u0003,\u0003?\tY\u0006E\u0003\u00020\u0005er\nC\u0004\u0002`-\u0001\r!!\u0004\u0002\u001dI,\u0017/^5sK\u0012\u001c6\r[3nC\"9\u00111M\u0006A\u0002\u00055\u0011a\u00049beRLG/[8o'\u000eDW-\\1\t\u000f\u0005\u001d4\u00021\u0001\u0002j\u000591/\u001d7D_:4\u0007\u0003BA6\u0003_j!!!\u001c\u000b\u0005u\u0002\u0013\u0002BA9\u0003[\u0012qaU)M\u0007>tg-A\u0006jgN\u0003H.\u001b;bE2,Gc\u00022\u0002x\u0005e\u00141\u0010\u0005\u0006a2\u0001\r!\u001d\u0005\b\u0003\u0003a\u0001\u0019AA\u0002\u0011\u001d\ti\b\u0004a\u0001\u0003\u007f\nA\u0001]1uQB!\u0011\u0011IAA\u0013\u0011\t\u0019)a\u0011\u0003\tA\u000bG\u000f[\u0001\u001fEVLG\u000e\u001a*fC\u0012,'oV5uQB\u000b'\u000f^5uS>tg+\u00197vKN$\u0002#!#\u0002(\u0006%\u00161VAW\u0003_\u000bY,!0\u0011\u000f-\nY)a$\u0002\u0016&\u0019\u0011Q\u0012\u0017\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA\u0019\u0002\u0012&\u0019\u00111\u0013\u000f\u0003\u001fA\u000b'\u000f^5uS>tW\r\u001a$jY\u0016\u0004b!a\f\u0002\u0018\u0006m\u0015\u0002BAM\u0003{\u0011\u0001\"\u0013;fe\u0006$xN\u001d\t\u0005\u0003;\u000b\u0019+\u0004\u0002\u0002 *\u0019\u0011\u0011\u0015\u0011\u0002\u0011\r\fG/\u00197zgRLA!!*\u0002 \nY\u0011J\u001c;fe:\fGNU8x\u0011\u0015\u0001X\u00021\u0001r\u0011\u001d\tY!\u0004a\u0001\u0003\u001bAq!a\u0019\u000e\u0001\u0004\ti\u0001C\u0004\u0002`5\u0001\r!!\u0004\t\u000f\u0005EV\u00021\u0001\u00024\u00069a-\u001b7uKJ\u001c\bCBA\u0018\u0003s\t)\fE\u00026\u0003oK1!!/7\u0005\u00191\u0015\u000e\u001c;fe\"9\u0011\u0011A\u0007A\u0002\u0005\r\u0001bBA`\u001b\u0001\u0007\u0011\u0011Y\u0001\u000bQ\u0006$wn\u001c9D_:4\u0007\u0003BAb\u0003\u0013l!!!2\u000b\u0007\u0005\u001d70\u0001\u0003d_:4\u0017\u0002BAf\u0003\u000b\u0014QbQ8oM&<WO]1uS>t\u0017aD:vaB|'\u000f\u001e#bi\u0006$\u0016\u0010]3\u0015\u0007\t\f\t\u000eC\u0004\u0002T:\u0001\r!!6\u0002\u0011\u0011\fG/\u0019+za\u0016\u0004B!a\u0004\u0002X&!\u0011\u0011\\A\t\u0005!!\u0015\r^1UsB,\u0017\u0001E:vaB|'\u000f\u001e$jK2$g*Y7f)\r\u0011\u0017q\u001c\u0005\u0007\u0003C|\u0001\u0019A(\u0002\t9\fW.Z\u0001\u0012!\u0006\u0014\u0018/^3u\r&dWMR8s[\u0006$\bC\u0001$\u0012'\u0011\t\"F\u000f!\u0015\u0005\u0005\u0015\u0018A\u0003:fC\u0012\u001c6\r[3nCR1\u0011QDAx\u0005\u0003Aq!!=\u0014\u0001\u0004\t\u00190A\u0004g_>$XM]:\u0011\r\u0005=\u0012\u0011HA{!\u0011\t90!@\u000e\u0005\u0005e(b\u0001?\u0002|*\u00111\u0004J\u0005\u0005\u0003\u007f\fIP\u0001\u0004G_>$XM\u001d\u0005\u0006aN\u0001\r!]\u0001\u001de\u0016\fG\rU1scV,GOR8pi\u0016\u00148/\u00138QCJ\fG\u000e\\3m)!\t\u0019Pa\u0002\u0003\n\t5\u0001bBAd)\u0001\u0007\u0011\u0011\u0019\u0005\b\u0005\u0017!\u0002\u0019AA\u0017\u0003%\u0001\u0018M\u001d;GS2,7\u000f\u0003\u0004\u0003\u0010Q\u0001\rAY\u0001\u0013S\u001etwN]3D_J\u0014X\u000f\u001d;GS2,7/\u0001\fnKJ<WmU2iK6\f7/\u00138QCJ\fG\u000e\\3m)!\tiB!\u0006\u0003\u0018\tm\u0001bBA\u0014+\u0001\u0007\u00111\u0001\u0005\b\u00053)\u0002\u0019AA\u0017\u000311\u0017\u000e\\3t)>$v.^2i\u0011\u0015\u0001X\u00031\u0001r\u0003Q\u0011X-\u00193TG\",W.\u0019$s_64un\u001c;feR1\u0011Q\u0002B\u0011\u0005KAqAa\t\u0017\u0001\u0004\t)0\u0001\u0004g_>$XM\u001d\u0005\b\u0005O1\u0002\u0019\u0001B\u0015\u0003%\u0019wN\u001c<feR,'\u000fE\u0002G\u0005WI1A!\f\u001b\u0005u\u0001\u0016M]9vKR$vn\u00159be.\u001c6\r[3nC\u000e{gN^3si\u0016\u0014\u0018a\u00063fg\u0016\u0014\u0018.\u00197ju\u0016\u001c6\r[3nCN#(/\u001b8h)\u0011\tiBa\r\t\r\tUr\u00031\u0001P\u00031\u00198\r[3nCN#(/\u001b8h\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\tm\u0002\u0003\u0002B\u001f\u0005\u000fj!Aa\u0010\u000b\t\t\u0005#1I\u0001\u0005Y\u0006twM\u0003\u0002\u0003F\u0005!!.\u0019<b\u0013\u0011\u0011IEa\u0010\u0003\r=\u0013'.Z2u\u0001")
public class ParquetFileFormat
implements FileFormat,
DataSourceRegister,
Logging,
scala.Serializable {
    private final ParquetLogRedirector parquetLogRedirector;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static StructType readSchemaFromFooter(Footer footer, ParquetToSparkSchemaConverter parquetToSparkSchemaConverter) {
        return ParquetFileFormat$.MODULE$.readSchemaFromFooter(footer, parquetToSparkSchemaConverter);
    }

    public static Option<StructType> mergeSchemasInParallel(scala.collection.immutable.Map<String, String> map, Seq<FileStatus> seq, SparkSession sparkSession) {
        return ParquetFileFormat$.MODULE$.mergeSchemasInParallel(map, seq, sparkSession);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, scala.collection.immutable.Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.buildReader$(this, sparkSession, dataSchema, partitionSchema, requiredSchema, filters, options, hadoopConf);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ParquetLogRedirector parquetLogRedirector() {
        return this.parquetLogRedirector;
    }

    @Override
    public String shortName() {
        return "parquet";
    }

    public String toString() {
        return "Parquet";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof ParquetFileFormat;
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, scala.collection.immutable.Map<String, String> options, StructType dataSchema) {
        ParquetOptions parquetOptions = new ParquetOptions(options, sparkSession.sessionState().conf());
        Configuration conf = ContextUtil.getConfiguration((JobContext)job);
        Class committerClass = conf.getClass(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key(), ParquetOutputCommitter.class, OutputCommitter.class);
        if (conf.get(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key()) == null) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Using default output committer for Parquet: ").append(ParquetOutputCommitter.class.getCanonicalName()).toString());
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Using user defined output committer for Parquet: ").append(committerClass.getCanonicalName()).toString());
        }
        conf.setClass(SQLConf$.MODULE$.OUTPUT_COMMITTER_CLASS().key(), committerClass, OutputCommitter.class);
        job.setOutputFormatClass(ParquetOutputFormat.class);
        ParquetOutputFormat.setWriteSupportClass((Job)job, ParquetWriteSupport.class);
        ParquetWriteSupport$.MODULE$.setSchema(dataSchema, conf);
        conf.set(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key(), Boolean.toString(sparkSession.sessionState().conf().writeLegacyParquetFormat()));
        conf.set(SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key(), sparkSession.sessionState().conf().parquetOutputTimestampType().toString());
        conf.set(SQLConf$.MODULE$.LEGACY_PARQUET_NANOS_AS_LONG().key(), Boolean.toString(sparkSession.sessionState().conf().legacyParquetNanosAsLong()));
        conf.set("parquet.compression", parquetOptions.compressionCodecClassName());
        if (conf.get("parquet.summary.metadata.level") == null && conf.get("parquet.enable.summary-metadata") == null) {
            conf.setEnum("parquet.summary.metadata.level", (Enum)ParquetOutputFormat.JobSummaryLevel.NONE);
        }
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel = ParquetOutputFormat.getJobSummaryLevel((Configuration)conf);
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel2 = ParquetOutputFormat.JobSummaryLevel.NONE;
        if ((jobSummaryLevel == null ? jobSummaryLevel2 != null : !jobSummaryLevel.equals(jobSummaryLevel2)) && !ParquetOutputCommitter.class.isAssignableFrom(committerClass)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(134).append("Committer ").append(committerClass).append(" is not a ParquetOutputCommitter and cannot").append(" create job summaries. ").append("Set Parquet option ").append("parquet.summary.metadata.level").append(" to NONE.").toString());
        }
        return new OutputWriterFactory(null){
            private final ParquetLogRedirector parquetLogRedirector;

            private ParquetLogRedirector parquetLogRedirector() {
                return this.parquetLogRedirector;
            }

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new ParquetOutputWriter(path, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder(8).append(CodecConfig.from((TaskAttemptContext)context).getCodec().getExtension()).append(".parquet").toString();
            }
            {
                this.parquetLogRedirector = ParquetLogRedirector.INSTANCE;
            }
        };
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, scala.collection.immutable.Map<String, String> parameters, Seq<FileStatus> files) {
        return ParquetUtils$.MODULE$.inferSchema(sparkSession, parameters, files);
    }

    @Override
    public boolean supportBatch(SparkSession sparkSession, StructType schema) {
        SQLConf conf = sparkSession.sessionState().conf();
        return conf.parquetVectorizedReaderEnabled() && conf.wholeStageEnabled() && schema.length() <= conf.wholeStageMaxNumFields() && schema.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ParquetFileFormat.$anonfun$supportBatch$1(x$1)));
    }

    @Override
    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return Option$.MODULE$.apply((Object)Seq$.MODULE$.fill(requiredSchema.fields().length + partitionSchema.fields().length, (Function0 & Serializable & scala.Serializable)() -> !sqlConf.offHeapColumnVectorEnabled() ? OnHeapColumnVector.class.getName() : OffHeapColumnVector.class.getName()));
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, scala.collection.immutable.Map<String, String> options, Path path) {
        return true;
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, scala.collection.immutable.Map<String, String> options, Configuration hadoopConf) {
        hadoopConf.set("parquet.read.support.class", ParquetReadSupport.class.getName());
        hadoopConf.set(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA(), requiredSchema.json());
        hadoopConf.set(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA(), requiredSchema.json());
        hadoopConf.set(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key(), sparkSession.sessionState().conf().sessionLocalTimeZone());
        hadoopConf.setBoolean(SQLConf$.MODULE$.NESTED_SCHEMA_PRUNING_ENABLED().key(), sparkSession.sessionState().conf().nestedSchemaPruningEnabled());
        hadoopConf.setBoolean(SQLConf$.MODULE$.CASE_SENSITIVE().key(), sparkSession.sessionState().conf().caseSensitiveAnalysis());
        ParquetWriteSupport$.MODULE$.setSchema(requiredSchema, hadoopConf);
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), sparkSession.sessionState().conf().isParquetBinaryAsString());
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), sparkSession.sessionState().conf().isParquetINT96AsTimestamp());
        hadoopConf.setBoolean(SQLConf$.MODULE$.LEGACY_PARQUET_NANOS_AS_LONG().key(), sparkSession.sessionState().conf().legacyParquetNanosAsLong());
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        StructType resultSchema = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fields())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        SQLConf sqlConf = sparkSession.sessionState().conf();
        boolean enableOffHeapColumnVector = sqlConf.offHeapColumnVectorEnabled();
        boolean enableVectorizedReader = sqlConf.parquetVectorizedReaderEnabled() && resultSchema.forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ParquetFileFormat.$anonfun$buildReaderWithPartitionValues$1(x$2)));
        boolean enableRecordFilter = sqlConf.parquetRecordFilterEnabled();
        boolean timestampConversion = sqlConf.isParquetINT96TimestampConversion();
        int capacity = sqlConf.parquetVectorizedReaderBatchSize();
        boolean enableParquetFilterPushDown = sqlConf.parquetFilterPushDown();
        boolean returningBatch = this.supportBatch(sparkSession, resultSchema);
        boolean pushDownDate = sqlConf.parquetFilterPushDownDate();
        boolean pushDownTimestamp = sqlConf.parquetFilterPushDownTimestamp();
        boolean pushDownDecimal = sqlConf.parquetFilterPushDownDecimal();
        boolean pushDownStringStartWith = sqlConf.parquetFilterPushDownStringStartWith();
        int pushDownInFilterThreshold = sqlConf.parquetFilterPushDownInFilterThreshold();
        boolean isCaseSensitive = sqlConf.caseSensitiveAnalysis();
        ParquetOptions parquetOptions = new ParquetOptions(options, sparkSession.sessionState().conf());
        String datetimeRebaseModeInRead = parquetOptions.datetimeRebaseModeInRead();
        String int96RebaseModeInRead = parquetOptions.int96RebaseModeInRead();
        return (Function1 & Serializable & scala.Serializable)file -> {
            ParquetRecordReader parquetRecordReader;
            RecordReaderIterator<Object> recordReaderIterator;
            None$ none$;
            LazyRef footerFileMetaData$lzy = new LazyRef();
            Predef$.MODULE$.assert(file.partitionValues().numFields() == partitionSchema.size());
            Path filePath = new Path(new URI(file.filePath()));
            FileSplit split = new FileSplit(filePath, file.start(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
            Configuration sharedConf = ((SerializableConfiguration)broadcastedHadoopConf.value()).value();
            Map map = ParquetFileFormat.footerFileMetaData$1(footerFileMetaData$lzy, sharedConf, filePath).getKeyValueMetaData();
            RebaseDateTime.RebaseSpec datetimeRebaseSpec = DataSourceUtils$.MODULE$.datetimeRebaseSpec((Function1<String, String>)(Function1 & Serializable & scala.Serializable)x$1 -> (String)map.get(x$1), datetimeRebaseModeInRead);
            if (enableParquetFilterPushDown) {
                MessageType parquetSchema = ParquetFileFormat.footerFileMetaData$1(footerFileMetaData$lzy, sharedConf, filePath).getSchema();
                ParquetFilters parquetFilters = new ParquetFilters(parquetSchema, pushDownDate, pushDownTimestamp, pushDownDecimal, pushDownStringStartWith, pushDownInFilterThreshold, isCaseSensitive, datetimeRebaseSpec);
                none$ = ((TraversableOnce)filters.flatMap((Function1 & Serializable & scala.Serializable)x$3 -> Option$.MODULE$.option2Iterable(parquetFilters.createFilter((Filter)x$3)), Seq$.MODULE$.canBuildFrom())).reduceOption((Function2 & Serializable & scala.Serializable)(x$1, x$2) -> FilterApi.and((FilterPredicate)x$1, (FilterPredicate)x$2));
            } else {
                none$ = None$.MODULE$;
            }
            None$ pushed = none$;
            None$ convertTz = timestampConversion && !ParquetFileFormat.isCreatedByParquetMr$1(footerFileMetaData$lzy, sharedConf, filePath) ? new Some((Object)DateTimeUtils$.MODULE$.getZoneId(sharedConf.get(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()))) : None$.MODULE$;
            Map map2 = ParquetFileFormat.footerFileMetaData$1(footerFileMetaData$lzy, sharedConf, filePath).getKeyValueMetaData();
            RebaseDateTime.RebaseSpec int96RebaseSpec = DataSourceUtils$.MODULE$.int96RebaseSpec((Function1<String, String>)(Function1 & Serializable & scala.Serializable)x$1 -> (String)map2.get(x$1), int96RebaseModeInRead);
            TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
            TaskAttemptContextImpl hadoopAttemptContext = new TaskAttemptContextImpl(((SerializableConfiguration)broadcastedHadoopConf.value()).value(), attemptId);
            if (pushed.isDefined()) {
                ParquetInputFormat.setFilterPredicate((Configuration)hadoopAttemptContext.getConfiguration(), (FilterPredicate)((FilterPredicate)pushed.get()));
            }
            Option taskContext = Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get());
            if (enableVectorizedReader) {
                VectorizedParquetRecordReader vectorizedReader = new VectorizedParquetRecordReader((ZoneId)convertTz.orNull(Predef$.MODULE$.$conforms()), datetimeRebaseSpec.mode().toString(), datetimeRebaseSpec.timeZone(), int96RebaseSpec.mode().toString(), int96RebaseSpec.timeZone(), enableOffHeapColumnVector && taskContext.isDefined(), capacity);
                RecordReaderIterator<Object> iter = new RecordReaderIterator<Object>(vectorizedReader);
                try {
                    vectorizedReader.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("Appending ").append(partitionSchema).append(" ").append(file.partitionValues()).toString());
                    vectorizedReader.initBatch(partitionSchema, file.partitionValues());
                    if (returningBatch) {
                        vectorizedReader.enableReturningBatches();
                    }
                    recordReaderIterator = iter;
                }
                catch (Throwable e) {
                    iter.close();
                    throw e;
                }
            }
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Falling back to parquet-mr");
            ParquetReadSupport readSupport = new ParquetReadSupport((Option<ZoneId>)convertTz, false, datetimeRebaseSpec, int96RebaseSpec);
            if (pushed.isDefined() && enableRecordFilter) {
                FilterCompat.Filter parquetFilter = FilterCompat.get((FilterPredicate)((FilterPredicate)pushed.get()), null);
                parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport, parquetFilter);
            } else {
                parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport);
            }
            ParquetRecordReader reader = parquetRecordReader;
            RecordReaderIterator iter = new RecordReaderIterator(reader);
            try {
                reader.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
                Seq fullSchema = (Seq)requiredSchema.toAttributes().$plus$plus((GenTraversableOnce)partitionSchema.toAttributes(), Seq$.MODULE$.canBuildFrom());
                UnsafeProjection unsafeProjection = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)fullSchema, fullSchema);
                if (partitionSchema.length() == 0) {
                    recordReaderIterator = iter.map(unsafeProjection);
                } else {
                    JoinedRow joinedRow = new JoinedRow();
                    recordReaderIterator = iter.map((Function1 & Serializable & scala.Serializable)d -> unsafeProjection.apply((InternalRow)joinedRow.apply(d, file.partitionValues())));
                }
            }
            catch (Throwable e) {
                iter.close();
                throw e;
            }
            return recordReaderIterator;
        };
    }

    @Override
    public boolean supportDataType(DataType dataType) {
        boolean bl;
        DataType dataType2 = dataType;
        if (dataType2 instanceof AnsiIntervalType) {
            bl = false;
        } else if (dataType2 instanceof AtomicType) {
            bl = true;
        } else if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            bl = structType.forall((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.supportDataType(f.dataType())));
        } else if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            bl = this.supportDataType(elementType);
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            bl = this.supportDataType(keyType) && this.supportDataType(valueType);
        } else if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            bl = this.supportDataType(userDefinedType.sqlType());
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean supportFieldName(String name) {
        return !name.matches(".*[ ,;{}()\n\t=].*");
    }

    public static final /* synthetic */ boolean $anonfun$supportBatch$1(StructField x$1) {
        return x$1.dataType() instanceof AtomicType;
    }

    public static final /* synthetic */ boolean $anonfun$buildReaderWithPartitionValues$1(StructField x$2) {
        return x$2.dataType() instanceof AtomicType;
    }

    private static final /* synthetic */ FileMetaData footerFileMetaData$lzycompute$1(LazyRef footerFileMetaData$lzy$1, Configuration sharedConf$1, Path filePath$1) {
        FileMetaData fileMetaData;
        LazyRef lazyRef = footerFileMetaData$lzy$1;
        synchronized (lazyRef) {
            fileMetaData = footerFileMetaData$lzy$1.initialized() ? (FileMetaData)footerFileMetaData$lzy$1.value() : (FileMetaData)footerFileMetaData$lzy$1.initialize((Object)ParquetFooterReader.readFooter(sharedConf$1, filePath$1, ParquetMetadataConverter.SKIP_ROW_GROUPS).getFileMetaData());
        }
        return fileMetaData;
    }

    private static final FileMetaData footerFileMetaData$1(LazyRef footerFileMetaData$lzy$1, Configuration sharedConf$1, Path filePath$1) {
        return footerFileMetaData$lzy$1.initialized() ? (FileMetaData)footerFileMetaData$lzy$1.value() : ParquetFileFormat.footerFileMetaData$lzycompute$1(footerFileMetaData$lzy$1, sharedConf$1, filePath$1);
    }

    private static final boolean isCreatedByParquetMr$1(LazyRef footerFileMetaData$lzy$1, Configuration sharedConf$1, Path filePath$1) {
        return ParquetFileFormat.footerFileMetaData$1(footerFileMetaData$lzy$1, sharedConf$1, filePath$1).getCreatedBy().startsWith("parquet-mr");
    }

    public ParquetFileFormat() {
        FileFormat.$init$(this);
        Logging.$init$((Logging)this);
        this.parquetLogRedirector = ParquetLogRedirector.INSTANCE;
    }
}

