/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00055b\u0001B\n\u0015\u0001\rB\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\t]\u0001\u0011\t\u0011)A\u0005W!Aq\u0006\u0001B\u0001B\u0003%1\u0006C\u00031\u0001\u0011\u0005\u0011\u0007C\u00031\u0001\u0011\u0005q\u0007C\u00031\u0001\u0011\u0005\u0001\tC\u0003J\u0001\u0011\u0005!\nC\u0003J\u0001\u0011%!\fC\u0003`\u0001\u0011\u0005\u0001\rC\u0003j\u0001\u0011%!\u000eC\u0003q\u0001\u0011%\u0011\u000f\u0003\u0004t\u0001\u0011\u0005A\u0003^\u0004\n\u0003\u0013!\u0012\u0011!E\u0001\u0003\u00171\u0001b\u0005\u000b\u0002\u0002#\u0005\u0011Q\u0002\u0005\u0007a9!\t!a\u0004\t\u0013\u0005Ea\"%A\u0005\u0002\u0005M\u0001\"CA\u0015\u001dE\u0005I\u0011AA\n\u0011%\tYCDI\u0001\n\u0003\t\u0019BA\u000fQCJ\fX/\u001a;U_N\u0003\u0018M]6TG\",W.Y\"p]Z,'\u000f^3s\u0015\t)b#A\u0004qCJ\fX/\u001a;\u000b\u0005]A\u0012a\u00033bi\u0006\u001cx.\u001e:dKNT!!\u0007\u000e\u0002\u0013\u0015DXmY;uS>t'BA\u000e\u001d\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003;y\tQa\u001d9be.T!a\b\u0011\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0013aA8sO\u000e\u00011C\u0001\u0001%!\t)\u0003&D\u0001'\u0015\u00059\u0013!B:dC2\f\u0017BA\u0015'\u0005\u0019\te.\u001f*fM\u0006!\u0012m]:v[\u0016\u0014\u0015N\\1ss&\u001b8\u000b\u001e:j]\u001e\u0004\"!\n\u0017\n\u000552#a\u0002\"p_2,\u0017M\\\u0001\u0017CN\u001cX/\\3J]RLd'S:US6,7\u000f^1na\u0006Ya.\u00198pg\u0006\u001bHj\u001c8h\u0003\u0019a\u0014N\\5u}Q!!\u0007N\u001b7!\t\u0019\u0004!D\u0001\u0015\u0011\u001dQC\u0001%AA\u0002-BqA\f\u0003\u0011\u0002\u0003\u00071\u0006C\u00040\tA\u0005\t\u0019A\u0016\u0015\u0005IB\u0004\"B\u001d\u0006\u0001\u0004Q\u0014\u0001B2p]\u001a\u0004\"a\u000f \u000e\u0003qR!!\u0010\u000e\u0002\u0011%tG/\u001a:oC2L!a\u0010\u001f\u0003\u000fM\u000bFjQ8oMR\u0011!'\u0011\u0005\u0006s\u0019\u0001\rA\u0011\t\u0003\u0007\u001ek\u0011\u0001\u0012\u0006\u0003s\u0015S!A\u0012\u0010\u0002\r!\fGm\\8q\u0013\tAEIA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\bG>tg/\u001a:u)\tY\u0015\u000b\u0005\u0002M\u001f6\tQJ\u0003\u0002O5\u0005)A/\u001f9fg&\u0011\u0001+\u0014\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\"\u0002*\b\u0001\u0004\u0019\u0016!\u00049beF,X\r^*dQ\u0016l\u0017\r\u0005\u0002U16\tQK\u0003\u0002W/\u000611o\u00195f[\u0006T!!\u0006\u0010\n\u0005e+&aC'fgN\fw-\u001a+za\u0016$\"aS.\t\u000bIC\u0001\u0019\u0001/\u0011\u0005Qk\u0016B\u00010V\u0005%9%o\\;q)f\u0004X-\u0001\u0007d_:4XM\u001d;GS\u0016dG\r\u0006\u0002bIB\u0011AJY\u0005\u0003G6\u0013\u0001\u0002R1uCRK\b/\u001a\u0005\u0006K&\u0001\rAZ\u0001\fa\u0006\u0014\u0018/^3u)f\u0004X\r\u0005\u0002UO&\u0011\u0001.\u0016\u0002\u0005)f\u0004X-A\u000bd_:4XM\u001d;Qe&l\u0017\u000e^5wK\u001aKW\r\u001c3\u0015\u0005\u0005\\\u0007\"\u00027\u000b\u0001\u0004i\u0017!\u00024jK2$\u0007C\u0001+o\u0013\tyWKA\u0007Qe&l\u0017\u000e^5wKRK\b/Z\u0001\u0012G>tg/\u001a:u\u000fJ|W\u000f\u001d$jK2$GCA1s\u0011\u0015a7\u00021\u0001]\u00035I7/\u00127f[\u0016tG\u000fV=qKR\u00191&^<\t\u000bYd\u0001\u0019\u00014\u0002\u0019I,\u0007/Z1uK\u0012$\u0016\u0010]3\t\u000bad\u0001\u0019A=\u0002\u0015A\f'/\u001a8u\u001d\u0006lW\rE\u0002{\u0003\u0007q!a_@\u0011\u0005q4S\"A?\u000b\u0005y\u0014\u0013A\u0002\u001fs_>$h(C\u0002\u0002\u0002\u0019\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0003\u0003\u000f\u0011aa\u0015;sS:<'bAA\u0001M\u0005i\u0002+\u0019:rk\u0016$Hk\\*qCJ\\7k\u00195f[\u0006\u001cuN\u001c<feR,'\u000f\u0005\u00024\u001dM\u0011a\u0002\n\u000b\u0003\u0003\u0017\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\nTCAA\u000bU\rY\u0013qC\u0016\u0003\u00033\u0001B!a\u0007\u0002&5\u0011\u0011Q\u0004\u0006\u0005\u0003?\t\t#A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0005\u0014\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002(\u0005u!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0004")
public class ParquetToSparkSchemaConverter {
    private final boolean assumeBinaryIsString;
    private final boolean assumeInt96IsTimestamp;
    private final boolean nanosAsLong;

    public static boolean $lessinit$greater$default$3() {
        return ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$3();
    }

    public static boolean $lessinit$greater$default$2() {
        return ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$2();
    }

    public static boolean $lessinit$greater$default$1() {
        return ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$1();
    }

    public StructType convert(MessageType parquetSchema) {
        return this.convert(parquetSchema.asGroupType());
    }

    private StructType convert(GroupType parquetSchema) {
        Buffer fields = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(parquetSchema.getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)field -> {
            StructField structField;
            Type.Repetition repetition = field.getRepetition();
            if (Type.Repetition.OPTIONAL.equals(repetition)) {
                structField = new StructField(field.getName(), this.convertField((Type)field), true, StructField$.MODULE$.apply$default$4());
            } else if (Type.Repetition.REQUIRED.equals(repetition)) {
                structField = new StructField(field.getName(), this.convertField((Type)field), false, StructField$.MODULE$.apply$default$4());
            } else if (Type.Repetition.REPEATED.equals(repetition)) {
                ArrayType arrayType = new ArrayType(this.convertField((Type)field), false);
                structField = new StructField(field.getName(), (DataType)arrayType, false, StructField$.MODULE$.apply$default$4());
            } else {
                throw new MatchError((Object)repetition);
            }
            return structField;
        }, Buffer$.MODULE$.canBuildFrom());
        return StructType$.MODULE$.apply(fields.toSeq());
    }

    public DataType convertField(Type parquetType) {
        DataType dataType;
        Type type = parquetType;
        if (type instanceof PrimitiveType) {
            PrimitiveType primitiveType = (PrimitiveType)type;
            dataType = this.convertPrimitiveField(primitiveType);
        } else if (type instanceof GroupType) {
            GroupType groupType = (GroupType)type;
            dataType = this.convertGroupField(groupType.asGroupType());
        } else {
            throw new MatchError((Object)type);
        }
        return dataType;
    }

    /*
     * Unable to fully structure code
     */
    private DataType convertPrimitiveField(PrimitiveType field) {
        block43: {
            block56: {
                block58: {
                    block57: {
                        block55: {
                            block47: {
                                block49: {
                                    block54: {
                                        block53: {
                                            block52: {
                                                block51: {
                                                    block50: {
                                                        block48: {
                                                            block46: {
                                                                block45: {
                                                                    block44: {
                                                                        block42: {
                                                                            typeName = field.getPrimitiveTypeName();
                                                                            typeAnnotation = field.getLogicalTypeAnnotation();
                                                                            var10_4 = typeName;
                                                                            if (!PrimitiveType.PrimitiveTypeName.BOOLEAN.equals(var10_4)) break block42;
                                                                            var2_5 = BooleanType$.MODULE$;
                                                                            break block43;
                                                                        }
                                                                        if (!PrimitiveType.PrimitiveTypeName.FLOAT.equals(var10_4)) break block44;
                                                                        var2_5 = FloatType$.MODULE$;
                                                                        break block43;
                                                                    }
                                                                    if (!PrimitiveType.PrimitiveTypeName.DOUBLE.equals(var10_4)) break block45;
                                                                    var2_5 = DoubleType$.MODULE$;
                                                                    break block43;
                                                                }
                                                                if (!PrimitiveType.PrimitiveTypeName.INT32.equals(var10_4)) break block46;
                                                                var11_6 = false;
                                                                var12_7 = null;
                                                                var13_8 = typeAnnotation;
                                                                if (!(var13_8 instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation)) ** GOTO lbl-1000
                                                                var11_6 = true;
                                                                var12_7 = (LogicalTypeAnnotation.IntLogicalTypeAnnotation)var13_8;
                                                                if (var12_7.isSigned()) {
                                                                    var14_9 = var12_7.getBitWidth();
                                                                    switch (var14_9) {
                                                                        case 8: {
                                                                            v0 = ByteType$.MODULE$;
                                                                            break;
                                                                        }
                                                                        case 16: {
                                                                            v0 = ShortType$.MODULE$;
                                                                            break;
                                                                        }
                                                                        case 32: {
                                                                            v0 = IntegerType$.MODULE$;
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
                                                                        }
                                                                    }
                                                                    var7_10 = v0;
                                                                } else if (var13_8 == null) {
                                                                    var7_10 = IntegerType$.MODULE$;
                                                                } else if (var13_8 instanceof LogicalTypeAnnotation.DateLogicalTypeAnnotation) {
                                                                    var7_10 = DateType$.MODULE$;
                                                                } else if (var13_8 instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                                                                    var7_10 = ParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.MAX_INT_DIGITS(), field, typeName);
                                                                } else if (var11_6 && !var12_7.isSigned()) {
                                                                    var15_11 = var12_7.getBitWidth();
                                                                    switch (var15_11) {
                                                                        case 8: {
                                                                            v1 = ShortType$.MODULE$;
                                                                            break;
                                                                        }
                                                                        case 16: {
                                                                            v1 = IntegerType$.MODULE$;
                                                                            break;
                                                                        }
                                                                        case 32: {
                                                                            v1 = LongType$.MODULE$;
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
                                                                        }
                                                                    }
                                                                    var7_10 = v1;
                                                                } else {
                                                                    if (var13_8 instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation) {
                                                                        var16_12 = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)var13_8;
                                                                        v2 = var16_12.getUnit();
                                                                        var17_13 = LogicalTypeAnnotation.TimeUnit.MILLIS;
                                                                        if (!(v2 != null ? v2.equals(var17_13) == false : var17_13 != null)) {
                                                                            throw ParquetToSparkSchemaConverter.typeNotImplemented$1(typeAnnotation, typeName);
                                                                        }
                                                                    }
                                                                    throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
                                                                }
                                                                var2_5 = var7_10;
                                                                break block43;
                                                            }
                                                            if (!PrimitiveType.PrimitiveTypeName.INT64.equals(var10_4)) break block47;
                                                            var18_14 = false;
                                                            var19_15 = null;
                                                            var20_16 = false;
                                                            var21_17 = null;
                                                            var22_18 = typeAnnotation;
                                                            if (!(var22_18 instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation)) break block48;
                                                            var18_14 = true;
                                                            var19_15 = (LogicalTypeAnnotation.IntLogicalTypeAnnotation)var22_18;
                                                            if (!var19_15.isSigned()) break block48;
                                                            var23_19 = var19_15.getBitWidth();
                                                            switch (var23_19) {
                                                                case 64: {
                                                                    break;
                                                                }
                                                                default: {
                                                                    throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
                                                                }
                                                            }
                                                            var6_20 = LongType$.MODULE$;
                                                            break block49;
                                                        }
                                                        if (var22_18 != null) break block50;
                                                        var6_20 = LongType$.MODULE$;
                                                        break block49;
                                                    }
                                                    if (!(var22_18 instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)) break block51;
                                                    var6_20 = ParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.MAX_LONG_DIGITS(), field, typeName);
                                                    break block49;
                                                }
                                                if (!var18_14 || var19_15.isSigned()) break block52;
                                                var24_21 = var19_15.getBitWidth();
                                                switch (var24_21) {
                                                    case 64: {
                                                        ** break;
                                                    }
                                                    default: {
                                                        throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
                                                    }
lbl-1000:
                                                    // 1 sources

                                                    {
                                                        var6_20 = new DecimalType(20, 0);
                                                    }
                                                }
                                                break block49;
                                            }
                                            if (!(var22_18 instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)) break block53;
                                            var20_16 = true;
                                            var21_17 = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)var22_18;
                                            v3 = var21_17.getUnit();
                                            var25_22 = LogicalTypeAnnotation.TimeUnit.MICROS;
                                            if (v3 != null ? v3.equals(var25_22) == false : var25_22 != null) break block53;
                                            var6_20 = TimestampType$.MODULE$;
                                            break block49;
                                        }
                                        if (!var20_16) break block54;
                                        v4 = var21_17.getUnit();
                                        var26_23 = LogicalTypeAnnotation.TimeUnit.MILLIS;
                                        if (v4 != null ? v4.equals(var26_23) == false : var26_23 != null) break block54;
                                        var6_20 = TimestampType$.MODULE$;
                                        break block49;
                                    }
                                    if (!var20_16) ** GOTO lbl-1000
                                    v5 = var21_17.getUnit();
                                    var27_24 = LogicalTypeAnnotation.TimeUnit.NANOS;
                                    if (!(v5 != null ? v5.equals(var27_24) == false : var27_24 != null) && this.nanosAsLong) {
                                        var6_20 = LongType$.MODULE$;
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
                                    }
                                }
                                var2_5 = var6_20;
                                break block43;
                            }
                            if (!PrimitiveType.PrimitiveTypeName.INT96.equals(var10_4)) break block55;
                            ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Z, $anonfun$convertPrimitiveField$2(org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter ), ()Z)((ParquetToSparkSchemaConverter)this), new StringBuilder(88).append("INT96 is not supported unless it's interpreted as timestamp. ").append("Please try to set ").append(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key()).append(" to true.").toString());
                            var2_5 = TimestampType$.MODULE$;
                            break block43;
                        }
                        if (!PrimitiveType.PrimitiveTypeName.BINARY.equals(var10_4)) break block56;
                        var28_25 = false;
                        var29_26 = null;
                        var30_27 = typeAnnotation;
                        var5_28 = var30_27 instanceof LogicalTypeAnnotation.StringLogicalTypeAnnotation != false ? true : (var30_27 instanceof LogicalTypeAnnotation.EnumLogicalTypeAnnotation != false ? true : var30_27 instanceof LogicalTypeAnnotation.JsonLogicalTypeAnnotation != false);
                        if (!var5_28) break block57;
                        var4_29 = StringType$.MODULE$;
                        break block58;
                    }
                    if (var30_27 != null) ** GOTO lbl-1000
                    var28_25 = true;
                    var29_26 = var30_27;
                    if (this.assumeBinaryIsString) {
                        var4_29 = StringType$.MODULE$;
                    } else if (var28_25) {
                        var4_29 = BinaryType$.MODULE$;
                    } else if (var30_27 instanceof LogicalTypeAnnotation.BsonLogicalTypeAnnotation) {
                        var4_29 = BinaryType$.MODULE$;
                    } else if (var30_27 instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                        var4_29 = ParquetToSparkSchemaConverter.makeDecimalType$1(ParquetToSparkSchemaConverter.makeDecimalType$default$1$1(), field, typeName);
                    } else {
                        throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
                    }
                }
                var2_5 = var4_29;
                break block43;
            }
            if (PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY.equals(var10_4)) {
                var31_30 = typeAnnotation;
                if (!(var31_30 instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)) {
                    if (var31_30 instanceof LogicalTypeAnnotation.IntervalLogicalTypeAnnotation) {
                        throw ParquetToSparkSchemaConverter.typeNotImplemented$1(typeAnnotation, typeName);
                    }
                    throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
                }
                var3_31 = ParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.maxPrecisionForBytes(field.getTypeLength()), field, typeName);
                var2_5 = var3_31;
            } else {
                throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
            }
        }
        return var2_5;
    }

    private DataType convertGroupField(GroupType field) {
        return (DataType)Option$.MODULE$.apply((Object)field.getLogicalTypeAnnotation()).fold((Function0 & Serializable & scala.Serializable)() -> this.convert(field), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            ArrayType arrayType;
            LogicalTypeAnnotation logicalTypeAnnotation = x0$1;
            if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.ListLogicalTypeAnnotation) {
                ArrayType arrayType2;
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> field.getFieldCount() == 1, new StringBuilder(18).append("Invalid list type ").append(field).toString());
                Type repeatedType = field.getType(0);
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> repeatedType.isRepetition(Type.Repetition.REPEATED), new StringBuilder(18).append("Invalid list type ").append(field).toString());
                if (this.isElementType(repeatedType, field.getName())) {
                    arrayType2 = new ArrayType(this.convertField(repeatedType), false);
                } else {
                    Type elementType = repeatedType.asGroupType().getType(0);
                    boolean optional = elementType.isRepetition(Type.Repetition.OPTIONAL);
                    arrayType2 = new ArrayType(this.convertField(elementType), optional);
                }
                arrayType = arrayType2;
            } else {
                boolean bl = logicalTypeAnnotation instanceof LogicalTypeAnnotation.MapLogicalTypeAnnotation ? true : logicalTypeAnnotation instanceof LogicalTypeAnnotation.MapKeyValueTypeAnnotation;
                if (bl) {
                    ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> field.getFieldCount() == 1 && !field.getType(0).isPrimitive(), new StringBuilder(18).append("Invalid map type: ").append(field).toString());
                    GroupType keyValueType = field.getType(0).asGroupType();
                    ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> keyValueType.isRepetition(Type.Repetition.REPEATED) && keyValueType.getFieldCount() == 2, new StringBuilder(18).append("Invalid map type: ").append(field).toString());
                    Type keyType = keyValueType.getType(0);
                    Type valueType = keyValueType.getType(1);
                    boolean valueOptional = valueType.isRepetition(Type.Repetition.OPTIONAL);
                    arrayType = new MapType(this.convertField(keyType), this.convertField(valueType), valueOptional);
                } else {
                    throw QueryCompilationErrors$.MODULE$.unrecognizedParquetTypeError(field.toString());
                }
            }
            return arrayType;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isElementType(Type repeatedType, String parentName) {
        if (repeatedType.isPrimitive()) return true;
        if (repeatedType.asGroupType().getFieldCount() > 1) return true;
        String string = repeatedType.getName();
        String string2 = "array";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = repeatedType.getName();
        String string4 = new StringBuilder(6).append(parentName).append("_tuple").toString();
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    private static final String typeString$1(LogicalTypeAnnotation typeAnnotation$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        return typeAnnotation$1 == null ? String.valueOf(typeName$1) : new StringBuilder(3).append(typeName$1).append(" (").append(typeAnnotation$1).append(")").toString();
    }

    private static final Nothing$ typeNotImplemented$1(LogicalTypeAnnotation typeAnnotation$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        throw QueryCompilationErrors$.MODULE$.parquetTypeUnsupportedYetError(ParquetToSparkSchemaConverter.typeString$1(typeAnnotation$1, typeName$1));
    }

    private static final Nothing$ illegalType$1(LogicalTypeAnnotation typeAnnotation$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        throw QueryCompilationErrors$.MODULE$.illegalParquetTypeError(ParquetToSparkSchemaConverter.typeString$1(typeAnnotation$1, typeName$1));
    }

    private static final DecimalType makeDecimalType$1(int maxPrecision, PrimitiveType field$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalTypeAnnotation = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)field$1.getLogicalTypeAnnotation();
        int precision = decimalLogicalTypeAnnotation.getPrecision();
        int scale = decimalLogicalTypeAnnotation.getScale();
        ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> maxPrecision == -1 || 1 <= precision && precision <= maxPrecision, new StringBuilder(55).append("Invalid decimal precision: ").append(typeName$1).append(" cannot store ").append(precision).append(" digits (max ").append(maxPrecision).append(")").toString());
        return new DecimalType(precision, scale);
    }

    private static final int makeDecimalType$default$1$1() {
        return -1;
    }

    public static final /* synthetic */ boolean $anonfun$convertPrimitiveField$2(ParquetToSparkSchemaConverter $this) {
        return $this.assumeInt96IsTimestamp;
    }

    public ParquetToSparkSchemaConverter(boolean assumeBinaryIsString, boolean assumeInt96IsTimestamp, boolean nanosAsLong) {
        this.assumeBinaryIsString = assumeBinaryIsString;
        this.assumeInt96IsTimestamp = assumeInt96IsTimestamp;
        this.nanosAsLong = nanosAsLong;
    }

    public ParquetToSparkSchemaConverter(SQLConf conf) {
        this(conf.isParquetBinaryAsString(), conf.isParquetINT96AsTimestamp(), conf.legacyParquetNanosAsLong());
    }

    public ParquetToSparkSchemaConverter(Configuration conf) {
        this(new StringOps(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key()))).toBoolean(), new StringOps(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key()))).toBoolean(), new StringOps(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.LEGACY_PARQUET_NANOS_AS_LONG().key()))).toBoolean());
    }
}

