/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.connector.catalog.SessionConfigSupport;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;

public final class DataSourceV2Utils$
implements Logging {
    public static DataSourceV2Utils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new DataSourceV2Utils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Map<String, String> extractSessionConfigs(TableProvider source, SQLConf conf) {
        Map map;
        TableProvider tableProvider = source;
        if (tableProvider instanceof SessionConfigSupport) {
            SessionConfigSupport sessionConfigSupport = (SessionConfigSupport)tableProvider;
            String keyPrefix = sessionConfigSupport.keyPrefix();
            Predef$.MODULE$.require(keyPrefix != null, (Function0 & Serializable & scala.Serializable)() -> "The data source config key prefix can't be null.");
            Pattern pattern = Pattern.compile(new StringBuilder(26).append("^spark\\.datasource\\.").append(keyPrefix).append("\\.(.+)").toString());
            map = (Map)conf.getAllConfs().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                Matcher m = pattern.matcher(key);
                Seq seq = m.matches() && m.groupCount() > 0 ? (Seq)new .colon.colon((Object)new Tuple2((Object)m.group(1), (Object)value), (List)Nil$.MODULE$) : (Seq)Nil$.MODULE$;
                return seq;
            }, Map$.MODULE$.canBuildFrom());
        } else {
            map = Predef$.MODULE$.Map().empty();
        }
        return map;
    }

    public Table getTableFromProvider(TableProvider provider, CaseInsensitiveStringMap options, Option<StructType> userSpecifiedSchema) {
        Table table;
        Option<StructType> option = userSpecifiedSchema;
        if (option instanceof Some) {
            Some some = (Some)option;
            StructType schema = (StructType)some.value();
            if (!provider.supportsExternalMetadata()) {
                throw QueryExecutionErrors$.MODULE$.userSpecifiedSchemaUnsupportedByDataSourceError(provider);
            }
            table = provider.getTable(schema, provider.inferPartitioning(options), options.asCaseSensitiveMap());
        } else if (None$.MODULE$.equals(option)) {
            table = provider.getTable(provider.inferSchema(options), provider.inferPartitioning(options), options.asCaseSensitiveMap());
        } else {
            throw new MatchError(option);
        }
        return table;
    }

    private DataSourceV2Utils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

