/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.FileSourceMetadataAttribute$;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class FileFormat$ {
    public static FileFormat$ MODULE$;
    private final String FILE_PATH;
    private final String FILE_NAME;
    private final String FILE_SIZE;
    private final String FILE_MODIFICATION_TIME;
    private final String METADATA_NAME;
    private final StructType METADATA_STRUCT;

    static {
        new FileFormat$();
    }

    public String FILE_PATH() {
        return this.FILE_PATH;
    }

    public String FILE_NAME() {
        return this.FILE_NAME;
    }

    public String FILE_SIZE() {
        return this.FILE_SIZE;
    }

    public String FILE_MODIFICATION_TIME() {
        return this.FILE_MODIFICATION_TIME;
    }

    public String METADATA_NAME() {
        return this.METADATA_NAME;
    }

    public StructType METADATA_STRUCT() {
        return this.METADATA_STRUCT;
    }

    public AttributeReference createFileMetadataCol() {
        return FileSourceMetadataAttribute$.MODULE$.apply(this.METADATA_NAME(), (DataType)this.METADATA_STRUCT(), FileSourceMetadataAttribute$.MODULE$.apply$default$3());
    }

    public InternalRow createMetadataInternalRow(Seq<String> fieldNames, Path filePath, long fileSize, long fileModificationTime) {
        return this.updateMetadataInternalRow((InternalRow)new GenericInternalRow(fieldNames.length()), fieldNames, filePath, fileSize, fileModificationTime);
    }

    public InternalRow updateMetadataInternalRow(InternalRow row, Seq<String> fieldNames, Path filePath, long fileSize, long fileModificationTime) {
        ((IterableLike)fieldNames.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            FileFormat$.$anonfun$updateMetadataInternalRow$1(row, filePath, fileSize, fileModificationTime, x0$1);
            return BoxedUnit.UNIT;
        });
        return row;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$updateMetadataInternalRow$1(InternalRow row$1, Path filePath$1, long fileSize$1, long fileModificationTime$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String name = (String)tuple2._1();
        int i = tuple2._2$mcI$sp();
        String string = name;
        String string2 = MODULE$.FILE_PATH();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            row$1.update(i, (Object)UTF8String.fromString((String)filePath$1.toString()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            String string4 = MODULE$.FILE_NAME();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                row$1.update(i, (Object)UTF8String.fromString((String)filePath$1.getName()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                String string6 = MODULE$.FILE_SIZE();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    row$1.update(i, (Object)BoxesRunTime.boxToLong((long)fileSize$1));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    String string8 = MODULE$.FILE_MODIFICATION_TIME();
                    String string9 = string;
                    if (string8 != null ? !string8.equals(string9) : string9 != null) throw new MatchError((Object)string);
                    row$1.update(i, (Object)BoxesRunTime.boxToLong((long)(fileModificationTime$1 * 1000L)));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private FileFormat$() {
        MODULE$ = this;
        this.FILE_PATH = "file_path";
        this.FILE_NAME = "file_name";
        this.FILE_SIZE = "file_size";
        this.FILE_MODIFICATION_TIME = "file_modification_time";
        this.METADATA_NAME = "_metadata";
        this.METADATA_STRUCT = new StructType().add(new StructField(this.FILE_PATH(), (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())).add(new StructField(this.FILE_NAME(), (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())).add(new StructField(this.FILE_SIZE(), (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())).add(new StructField(this.FILE_MODIFICATION_TIME(), (DataType)TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()));
    }
}

