/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.NamespaceChange;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRDD$;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcOptionsInWrite;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.execution.datasources.v2.jdbc.JDBCTable;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcDialects$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\rh\u0001B\u000f\u001f\u0001=BQ!\u0013\u0001\u0005\u0002)Cq!\u0014\u0001A\u0002\u0013%a\nC\u0004]\u0001\u0001\u0007I\u0011B/\t\r\u0011\u0004\u0001\u0015)\u0003P\u0011%)\u0007\u00011AA\u0002\u0013%a\rC\u0005m\u0001\u0001\u0007\t\u0019!C\u0005[\"Iq\u000e\u0001a\u0001\u0002\u0003\u0006Ka\u001a\u0005\na\u0002\u0001\r\u00111A\u0005\nED\u0011b\u001e\u0001A\u0002\u0003\u0007I\u0011\u0002=\t\u0013i\u0004\u0001\u0019!A!B\u0013\u0011\b\"B>\u0001\t\u0003b\b\"B?\u0001\t\u0003r\bbBA\b\u0001\u0011\u0005\u0013\u0011\u0003\u0005\b\u0003K\u0001A\u0011IA\u0014\u0011\u001d\t\u0019\u0004\u0001C!\u0003kAq!!\u000f\u0001\t\u0003\nY\u0004C\u0004\u0002F\u0001!\t%a\u0012\t\u000f\u0005E\u0003\u0001\"\u0011\u0002T!9\u0011q\u0011\u0001\u0005B\u0005%\u0005bBAO\u0001\u0011\u0005\u0013q\u0014\u0005\b\u0003G\u0003A\u0011IAS\u0011\u001d\t\u0019\u000b\u0001C!\u0003SCq!!,\u0001\t\u0003\ny\u000bC\u0004\u00024\u0002!\t%!.\t\u000f\u0005u\u0006\u0001\"\u0011\u0002@\"9\u0011Q\u001a\u0001\u0005B\u0005=\u0007bBAl\u0001\u0011%\u0011\u0011\u001c\u0005\b\u0003;\u0004A\u0011BAp\u0005AQEIQ\"UC\ndWmQ1uC2|wM\u0003\u0002 A\u0005!!\u000e\u001a2d\u0015\t\t#%\u0001\u0002we)\u00111\u0005J\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002&M\u0005IQ\r_3dkRLwN\u001c\u0006\u0003O!\n1a]9m\u0015\tI#&A\u0003ta\u0006\u00148N\u0003\u0002,Y\u00051\u0011\r]1dQ\u0016T\u0011!L\u0001\u0004_J<7\u0001A\n\u0006\u0001AB\u0004i\u0011\t\u0003cYj\u0011A\r\u0006\u0003gQ\nA\u0001\\1oO*\tQ'\u0001\u0003kCZ\f\u0017BA\u001c3\u0005\u0019y%M[3diB\u0011\u0011HP\u0007\u0002u)\u00111\bP\u0001\bG\u0006$\u0018\r\\8h\u0015\tid%A\u0005d_:tWm\u0019;pe&\u0011qH\u000f\u0002\r)\u0006\u0014G.Z\"bi\u0006dwn\u001a\t\u0003s\u0005K!A\u0011\u001e\u0003%M+\b\u000f]8siNt\u0015-\\3ta\u0006\u001cWm\u001d\t\u0003\t\u001ek\u0011!\u0012\u0006\u0003\r\"\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003\u0011\u0016\u0013q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002\u0017B\u0011A\nA\u0007\u0002=\u0005Y1-\u0019;bY><g*Y7f+\u0005y\u0005C\u0001)Z\u001d\t\tv\u000b\u0005\u0002S+6\t1K\u0003\u0002U]\u00051AH]8pizR\u0011AV\u0001\u0006g\u000e\fG.Y\u0005\u00031V\u000ba\u0001\u0015:fI\u00164\u0017B\u0001.\\\u0005\u0019\u0019FO]5oO*\u0011\u0001,V\u0001\u0010G\u0006$\u0018\r\\8h\u001d\u0006lWm\u0018\u0013fcR\u0011aL\u0019\t\u0003?\u0002l\u0011!V\u0005\u0003CV\u0013A!\u00168ji\"91mAA\u0001\u0002\u0004y\u0015a\u0001=%c\u0005a1-\u0019;bY><g*Y7fA\u00059q\u000e\u001d;j_:\u001cX#A4\u0011\u0005!TW\"A5\u000b\u0005}\u0011\u0013BA6j\u0005-QEIQ\"PaRLwN\\:\u0002\u0017=\u0004H/[8og~#S-\u001d\u000b\u0003=:Dqa\u0019\u0004\u0002\u0002\u0003\u0007q-\u0001\u0005paRLwN\\:!\u0003\u001d!\u0017.\u00197fGR,\u0012A\u001d\t\u0003gVl\u0011\u0001\u001e\u0006\u0003?\u0019J!A\u001e;\u0003\u0017)#'m\u0019#jC2,7\r^\u0001\fI&\fG.Z2u?\u0012*\u0017\u000f\u0006\u0002_s\"91-CA\u0001\u0002\u0004\u0011\u0018\u0001\u00033jC2,7\r\u001e\u0011\u0002\t9\fW.\u001a\u000b\u0002\u001f\u0006Q\u0011N\\5uS\u0006d\u0017N_3\u0015\ty{\u0018\u0011\u0001\u0005\u0006w2\u0001\ra\u0014\u0005\u0007K2\u0001\r!a\u0001\u0011\t\u0005\u0015\u00111B\u0007\u0003\u0003\u000fQ1!!\u0003'\u0003\u0011)H/\u001b7\n\t\u00055\u0011q\u0001\u0002\u0019\u0007\u0006\u001cX-\u00138tK:\u001c\u0018\u000e^5wKN#(/\u001b8h\u001b\u0006\u0004\u0018A\u00037jgR$\u0016M\u00197fgR!\u00111CA\u0010!\u0015y\u0016QCA\r\u0013\r\t9\"\u0016\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004s\u0005m\u0011bAA\u000fu\tQ\u0011\nZ3oi&4\u0017.\u001a:\t\u000f\u0005\u0005R\u00021\u0001\u0002$\u0005Ia.Y7fgB\f7-\u001a\t\u0005?\u0006Uq*A\u0006uC\ndW-\u0012=jgR\u001cH\u0003BA\u0015\u0003_\u00012aXA\u0016\u0013\r\ti#\u0016\u0002\b\u0005>|G.Z1o\u0011\u001d\t\tD\u0004a\u0001\u00033\tQ!\u001b3f]R\f\u0011\u0002\u001a:paR\u000b'\r\\3\u0015\t\u0005%\u0012q\u0007\u0005\b\u0003cy\u0001\u0019AA\r\u0003-\u0011XM\\1nKR\u000b'\r\\3\u0015\u000by\u000bi$!\u0011\t\u000f\u0005}\u0002\u00031\u0001\u0002\u001a\u0005Aq\u000e\u001c3JI\u0016tG\u000fC\u0004\u0002DA\u0001\r!!\u0007\u0002\u00119,w/\u00133f]R\f\u0011\u0002\\8bIR\u000b'\r\\3\u0015\t\u0005%\u0013q\n\t\u0004s\u0005-\u0013bAA'u\t)A+\u00192mK\"9\u0011\u0011G\tA\u0002\u0005e\u0011aC2sK\u0006$X\rV1cY\u0016$\"\"!\u0013\u0002V\u0005]\u0013qMA=\u0011\u001d\t\tD\u0005a\u0001\u00033Aq!!\u0017\u0013\u0001\u0004\tY&\u0001\u0004tG\",W.\u0019\t\u0005\u0003;\n\u0019'\u0004\u0002\u0002`)\u0019\u0011\u0011\r\u0014\u0002\u000bQL\b/Z:\n\t\u0005\u0015\u0014q\f\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007bBA5%\u0001\u0007\u00111N\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\b#B0\u0002\u0016\u00055\u0004\u0003BA8\u0003kj!!!\u001d\u000b\u0007\u0005MD(A\u0006fqB\u0014Xm]:j_:\u001c\u0018\u0002BA<\u0003c\u0012\u0011\u0002\u0016:b]N4wN]7\t\u000f\u0005m$\u00031\u0001\u0002~\u0005Q\u0001O]8qKJ$\u0018.Z:\u0011\r\u0005}\u00141Q(P\u001b\t\t\tIC\u0002\u0002\nQJA!!\"\u0002\u0002\n\u0019Q*\u00199\u0002\u0015\u0005dG/\u001a:UC\ndW\r\u0006\u0004\u0002J\u0005-\u0015Q\u0012\u0005\b\u0003c\u0019\u0002\u0019AA\r\u0011\u001d\tyi\u0005a\u0001\u0003#\u000bqa\u00195b]\u001e,7\u000fE\u0003`\u0003'\u000b9*C\u0002\u0002\u0016V\u0013!\u0002\u0010:fa\u0016\fG/\u001a3?!\rI\u0014\u0011T\u0005\u0004\u00037S$a\u0003+bE2,7\t[1oO\u0016\fqB\\1nKN\u0004\u0018mY3Fq&\u001cHo\u001d\u000b\u0005\u0003S\t\t\u000bC\u0004\u0002\"Q\u0001\r!a\t\u0002\u001d1L7\u000f\u001e(b[\u0016\u001c\b/Y2fgR\u0011\u0011q\u0015\t\u0006?\u0006U\u00111\u0005\u000b\u0005\u0003O\u000bY\u000bC\u0004\u0002\"Y\u0001\r!a\t\u0002+1|\u0017\r\u001a(b[\u0016\u001c\b/Y2f\u001b\u0016$\u0018\rZ1uCR!\u0011QPAY\u0011\u001d\t\tc\u0006a\u0001\u0003G\tqb\u0019:fCR,g*Y7fgB\f7-\u001a\u000b\u0006=\u0006]\u0016\u0011\u0018\u0005\b\u0003CA\u0002\u0019AA\u0012\u0011\u001d\tY\f\u0007a\u0001\u0003{\n\u0001\"\\3uC\u0012\fG/Y\u0001\u000fC2$XM\u001d(b[\u0016\u001c\b/Y2f)\u0015q\u0016\u0011YAb\u0011\u001d\t\t#\u0007a\u0001\u0003GAq!a$\u001a\u0001\u0004\t)\rE\u0003`\u0003'\u000b9\rE\u0002:\u0003\u0013L1!a3;\u0005=q\u0015-\\3ta\u0006\u001cWm\u00115b]\u001e,\u0017!\u00043s_Bt\u0015-\\3ta\u0006\u001cW\r\u0006\u0004\u0002*\u0005E\u00171\u001b\u0005\b\u0003CQ\u0002\u0019AA\u0012\u0011\u001d\t)N\u0007a\u0001\u0003S\tqaY1tG\u0006$W-\u0001\bdQ\u0016\u001c7NT1nKN\u0004\u0018mY3\u0015\u0007y\u000bY\u000eC\u0004\u0002\"m\u0001\r!a\t\u0002\u0019\u001d,G\u000fV1cY\u0016t\u0015-\\3\u0015\u0007=\u000b\t\u000fC\u0004\u00022q\u0001\r!!\u0007")
public class JDBCTableCatalog
implements TableCatalog,
SupportsNamespaces,
Logging {
    private String catalogName;
    private JDBCOptions options;
    private JdbcDialect dialect;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Table loadTable(Identifier x$1, String x$2) throws NoSuchTableException {
        return super.loadTable(x$1, x$2);
    }

    public Table loadTable(Identifier x$1, long x$2) throws NoSuchTableException {
        return super.loadTable(x$1, x$2);
    }

    public void invalidateTable(Identifier x$1) {
        super.invalidateTable(x$1);
    }

    public boolean purgeTable(Identifier x$1) throws UnsupportedOperationException {
        return super.purgeTable(x$1);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String catalogName() {
        return this.catalogName;
    }

    private void catalogName_$eq(String x$1) {
        this.catalogName = x$1;
    }

    private JDBCOptions options() {
        return this.options;
    }

    private void options_$eq(JDBCOptions x$1) {
        this.options = x$1;
    }

    private JdbcDialect dialect() {
        return this.dialect;
    }

    private void dialect_$eq(JdbcDialect x$1) {
        this.dialect = x$1;
    }

    public String name() {
        Predef$.MODULE$.require(this.catalogName() != null, (Function0 & Serializable & scala.Serializable)() -> "The JDBC table catalog is not initialed");
        return this.catalogName();
    }

    public void initialize(String name, CaseInsensitiveStringMap options) {
        Predef$.MODULE$.assert(this.catalogName() == null, (Function0 & Serializable & scala.Serializable)() -> "The JDBC table catalog is already initialed");
        this.catalogName_$eq(name);
        scala.collection.immutable.Map map = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(options.asCaseSensitiveMap()).asScala()).toMap(Predef$.MODULE$.$conforms());
        this.options_$eq(new JDBCOptions((scala.collection.immutable.Map<String, String>)map.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_TABLE_NAME()), (Object)"__invalid_dbtable"))));
        this.dialect_$eq(JdbcDialects$.MODULE$.get(this.options().url()));
    }

    public Identifier[] listTables(String[] namespace) {
        this.checkNamespace(namespace);
        return (Identifier[])JdbcUtils$.MODULE$.withConnection(this.options(), (Function1 & Serializable & scala.Serializable)conn -> {
            String schemaPattern = namespace.length == 1 ? (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])namespace)).head() : null;
            ResultSet rs = conn.getMetaData().getTables(null, schemaPattern, "%", (String[])((Object[])new String[]{"TABLE"}));
            return (Identifier[])new Iterator<Identifier>(null, rs, namespace){
                private final ResultSet rs$1;
                private final String[] namespace$1;

                public Iterator<Identifier> seq() {
                    return Iterator.seq$((Iterator)this);
                }

                public boolean isEmpty() {
                    return Iterator.isEmpty$((Iterator)this);
                }

                public boolean isTraversableAgain() {
                    return Iterator.isTraversableAgain$((Iterator)this);
                }

                public boolean hasDefiniteSize() {
                    return Iterator.hasDefiniteSize$((Iterator)this);
                }

                public Iterator<Identifier> take(int n) {
                    return Iterator.take$((Iterator)this, (int)n);
                }

                public Iterator<Identifier> drop(int n) {
                    return Iterator.drop$((Iterator)this, (int)n);
                }

                public Iterator<Identifier> slice(int from, int until) {
                    return Iterator.slice$((Iterator)this, (int)from, (int)until);
                }

                public Iterator<Identifier> sliceIterator(int from, int until) {
                    return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
                }

                public <B> Iterator<B> map(Function1<Identifier, B> f) {
                    return Iterator.map$((Iterator)this, f);
                }

                public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                    return Iterator.$plus$plus$((Iterator)this, that);
                }

                public <B> Iterator<B> flatMap(Function1<Identifier, GenTraversableOnce<B>> f) {
                    return Iterator.flatMap$((Iterator)this, f);
                }

                public Iterator<Identifier> filter(Function1<Identifier, Object> p) {
                    return Iterator.filter$((Iterator)this, p);
                }

                public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<Identifier, B, Object> p) {
                    return Iterator.corresponds$((Iterator)this, that, p);
                }

                public Iterator<Identifier> withFilter(Function1<Identifier, Object> p) {
                    return Iterator.withFilter$((Iterator)this, p);
                }

                public Iterator<Identifier> filterNot(Function1<Identifier, Object> p) {
                    return Iterator.filterNot$((Iterator)this, p);
                }

                public <B> Iterator<B> collect(PartialFunction<Identifier, B> pf) {
                    return Iterator.collect$((Iterator)this, pf);
                }

                public <B> Iterator<B> scanLeft(B z, Function2<B, Identifier, B> op) {
                    return Iterator.scanLeft$((Iterator)this, z, op);
                }

                public <B> Iterator<B> scanRight(B z, Function2<Identifier, B, B> op) {
                    return Iterator.scanRight$((Iterator)this, z, op);
                }

                public Iterator<Identifier> takeWhile(Function1<Identifier, Object> p) {
                    return Iterator.takeWhile$((Iterator)this, p);
                }

                public Tuple2<Iterator<Identifier>, Iterator<Identifier>> partition(Function1<Identifier, Object> p) {
                    return Iterator.partition$((Iterator)this, p);
                }

                public Tuple2<Iterator<Identifier>, Iterator<Identifier>> span(Function1<Identifier, Object> p) {
                    return Iterator.span$((Iterator)this, p);
                }

                public Iterator<Identifier> dropWhile(Function1<Identifier, Object> p) {
                    return Iterator.dropWhile$((Iterator)this, p);
                }

                public <B> Iterator<Tuple2<Identifier, B>> zip(Iterator<B> that) {
                    return Iterator.zip$((Iterator)this, that);
                }

                public <A1> Iterator<A1> padTo(int len, A1 elem) {
                    return Iterator.padTo$((Iterator)this, (int)len, elem);
                }

                public Iterator<Tuple2<Identifier, Object>> zipWithIndex() {
                    return Iterator.zipWithIndex$((Iterator)this);
                }

                public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                    return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
                }

                public <U> void foreach(Function1<Identifier, U> f) {
                    Iterator.foreach$((Iterator)this, f);
                }

                public boolean forall(Function1<Identifier, Object> p) {
                    return Iterator.forall$((Iterator)this, p);
                }

                public boolean exists(Function1<Identifier, Object> p) {
                    return Iterator.exists$((Iterator)this, p);
                }

                public boolean contains(Object elem) {
                    return Iterator.contains$((Iterator)this, (Object)elem);
                }

                public Option<Identifier> find(Function1<Identifier, Object> p) {
                    return Iterator.find$((Iterator)this, p);
                }

                public int indexWhere(Function1<Identifier, Object> p) {
                    return Iterator.indexWhere$((Iterator)this, p);
                }

                public int indexWhere(Function1<Identifier, Object> p, int from) {
                    return Iterator.indexWhere$((Iterator)this, p, (int)from);
                }

                public <B> int indexOf(B elem) {
                    return Iterator.indexOf$((Iterator)this, elem);
                }

                public <B> int indexOf(B elem, int from) {
                    return Iterator.indexOf$((Iterator)this, elem, (int)from);
                }

                public BufferedIterator<Identifier> buffered() {
                    return Iterator.buffered$((Iterator)this);
                }

                public <B> Iterator.GroupedIterator<B> grouped(int size) {
                    return Iterator.grouped$((Iterator)this, (int)size);
                }

                public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                    return Iterator.sliding$((Iterator)this, (int)size, (int)step);
                }

                public <B> int sliding$default$2() {
                    return Iterator.sliding$default$2$((Iterator)this);
                }

                public int length() {
                    return Iterator.length$((Iterator)this);
                }

                public Tuple2<Iterator<Identifier>, Iterator<Identifier>> duplicate() {
                    return Iterator.duplicate$((Iterator)this);
                }

                public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                    return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
                }

                public <B> void copyToArray(Object xs, int start, int len) {
                    Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
                }

                public boolean sameElements(Iterator<?> that) {
                    return Iterator.sameElements$((Iterator)this, that);
                }

                public Traversable<Identifier> toTraversable() {
                    return Iterator.toTraversable$((Iterator)this);
                }

                public Iterator<Identifier> toIterator() {
                    return Iterator.toIterator$((Iterator)this);
                }

                public Stream<Identifier> toStream() {
                    return Iterator.toStream$((Iterator)this);
                }

                public String toString() {
                    return Iterator.toString$((Iterator)this);
                }

                public List<Identifier> reversed() {
                    return TraversableOnce.reversed$((TraversableOnce)this);
                }

                public int size() {
                    return TraversableOnce.size$((TraversableOnce)this);
                }

                public boolean nonEmpty() {
                    return TraversableOnce.nonEmpty$((TraversableOnce)this);
                }

                public int count(Function1<Identifier, Object> p) {
                    return TraversableOnce.count$((TraversableOnce)this, p);
                }

                public <B> Option<B> collectFirst(PartialFunction<Identifier, B> pf) {
                    return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
                }

                public <B> B $div$colon(B z, Function2<B, Identifier, B> op) {
                    return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
                }

                public <B> B $colon$bslash(B z, Function2<Identifier, B, B> op) {
                    return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
                }

                public <B> B foldLeft(B z, Function2<B, Identifier, B> op) {
                    return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
                }

                public <B> B foldRight(B z, Function2<Identifier, B, B> op) {
                    return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
                }

                public <B> B reduceLeft(Function2<B, Identifier, B> op) {
                    return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
                }

                public <B> B reduceRight(Function2<Identifier, B, B> op) {
                    return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
                }

                public <B> Option<B> reduceLeftOption(Function2<B, Identifier, B> op) {
                    return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
                }

                public <B> Option<B> reduceRightOption(Function2<Identifier, B, B> op) {
                    return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
                }

                public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                    return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
                }

                public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                    return TraversableOnce.reduceOption$((TraversableOnce)this, op);
                }

                public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                    return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
                }

                public <B> B aggregate(Function0<B> z, Function2<B, Identifier, B> seqop, Function2<B, B, B> combop) {
                    return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
                }

                public <B> B sum(Numeric<B> num) {
                    return (B)TraversableOnce.sum$((TraversableOnce)this, num);
                }

                public <B> B product(Numeric<B> num) {
                    return (B)TraversableOnce.product$((TraversableOnce)this, num);
                }

                public Object min(Ordering cmp) {
                    return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
                }

                public Object max(Ordering cmp) {
                    return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
                }

                public Object maxBy(Function1 f, Ordering cmp) {
                    return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                }

                public Object minBy(Function1 f, Ordering cmp) {
                    return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                }

                public <B> void copyToBuffer(Buffer<B> dest) {
                    TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
                }

                public <B> void copyToArray(Object xs, int start) {
                    TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
                }

                public <B> void copyToArray(Object xs) {
                    TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
                }

                public <B> Object toArray(ClassTag<B> evidence$1) {
                    return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
                }

                public List<Identifier> toList() {
                    return TraversableOnce.toList$((TraversableOnce)this);
                }

                public Iterable<Identifier> toIterable() {
                    return TraversableOnce.toIterable$((TraversableOnce)this);
                }

                public Seq<Identifier> toSeq() {
                    return TraversableOnce.toSeq$((TraversableOnce)this);
                }

                public IndexedSeq<Identifier> toIndexedSeq() {
                    return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
                }

                public <B> Buffer<B> toBuffer() {
                    return TraversableOnce.toBuffer$((TraversableOnce)this);
                }

                public <B> Set<B> toSet() {
                    return TraversableOnce.toSet$((TraversableOnce)this);
                }

                public Vector<Identifier> toVector() {
                    return TraversableOnce.toVector$((TraversableOnce)this);
                }

                public <Col> Col to(CanBuildFrom<Nothing$, Identifier, Col> cbf) {
                    return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
                }

                public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef.$less$colon$less<Identifier, Tuple2<T, U>> ev) {
                    return TraversableOnce.toMap$((TraversableOnce)this, ev);
                }

                public String mkString(String start, String sep, String end) {
                    return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
                }

                public String mkString(String sep) {
                    return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
                }

                public String mkString() {
                    return TraversableOnce.mkString$((TraversableOnce)this);
                }

                public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                    return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                }

                public StringBuilder addString(StringBuilder b, String sep) {
                    return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
                }

                public StringBuilder addString(StringBuilder b) {
                    return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
                }

                public int sizeHintIfCheap() {
                    return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
                }

                public boolean hasNext() {
                    return this.rs$1.next();
                }

                public Identifier next() {
                    return Identifier.of((String[])this.namespace$1, (String)this.rs$1.getString("TABLE_NAME"));
                }
                {
                    this.rs$1 = rs$1;
                    this.namespace$1 = namespace$1;
                    GenTraversableOnce.$init$((GenTraversableOnce)this);
                    TraversableOnce.$init$((TraversableOnce)this);
                    Iterator.$init$((Iterator)this);
                }
            }.toArray(ClassTag$.MODULE$.apply(Identifier.class));
        });
    }

    public boolean tableExists(Identifier ident) {
        this.checkNamespace(ident.namespace());
        JdbcOptionsInWrite writeOptions = new JdbcOptionsInWrite((CaseInsensitiveMap<String>)this.options().parameters().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_TABLE_NAME()), (Object)this.getTableName(ident))));
        return BoxesRunTime.unboxToBoolean(JdbcUtils$.MODULE$.classifyException(new java.lang.StringBuilder(30).append("Failed table existence check: ").append(ident).toString(), this.dialect(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean(JdbcUtils$.MODULE$.withConnection(this.options(), (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JdbcUtils$.MODULE$.tableExists(x$1, writeOptions))))));
    }

    public boolean dropTable(Identifier ident) {
        this.checkNamespace(ident.namespace());
        return BoxesRunTime.unboxToBoolean(JdbcUtils$.MODULE$.withConnection(this.options(), (Function1 & Serializable & scala.Serializable)conn -> BoxesRunTime.boxToBoolean((boolean)JDBCTableCatalog.$anonfun$dropTable$1(this, ident, conn))));
    }

    public void renameTable(Identifier oldIdent, Identifier newIdent) {
        this.checkNamespace(oldIdent.namespace());
        JdbcUtils$.MODULE$.withConnection(this.options(), (Function1 & Serializable & scala.Serializable)conn -> {
            JdbcUtils$.MODULE$.classifyException(new java.lang.StringBuilder(31).append("Failed table renaming from ").append(oldIdent).append(" to ").append(newIdent).toString(), this.dialect(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> JdbcUtils$.MODULE$.renameTable(conn, this.getTableName(oldIdent), this.getTableName(newIdent), this.options()));
            return BoxedUnit.UNIT;
        });
    }

    public Table loadTable(Identifier ident) {
        JDBCTable jDBCTable;
        this.checkNamespace(ident.namespace());
        JDBCOptions optionsWithTableName = new JDBCOptions((CaseInsensitiveMap<String>)this.options().parameters().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_TABLE_NAME()), (Object)this.getTableName(ident))));
        try {
            StructType schema = JDBCRDD$.MODULE$.resolveTable(optionsWithTableName);
            jDBCTable = new JDBCTable(ident, schema, optionsWithTableName);
        }
        catch (SQLException sQLException) {
            throw QueryCompilationErrors$.MODULE$.noSuchTableError(ident);
        }
        return jDBCTable;
    }

    public Table createTable(Identifier ident, StructType schema, Transform[] partitions, Map<String, String> properties) {
        this.checkNamespace(ident.namespace());
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitions)).nonEmpty()) {
            throw QueryExecutionErrors$.MODULE$.cannotCreateJDBCTableWithPartitionsError();
        }
        CaseInsensitiveMap tableOptions = this.options().parameters().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_TABLE_NAME()), (Object)this.getTableName(ident)));
        ObjectRef tableComment = ObjectRef.create((Object)"");
        ObjectRef tableProperties = ObjectRef.create((Object)"");
        if (!properties.isEmpty()) {
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(properties).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                JDBCTableCatalog.$anonfun$createTable$1(tableComment, tableProperties, x0$1);
                return BoxedUnit.UNIT;
            });
        }
        String string = (String)tableComment.elem;
        String string2 = "";
        if (string == null ? string2 != null : !string.equals(string2)) {
            tableOptions = tableOptions.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_TABLE_COMMENT()), (Object)((String)tableComment.elem)));
        }
        String string3 = (String)tableProperties.elem;
        String string4 = "";
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            tableOptions = tableOptions.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_CREATE_TABLE_OPTIONS()), (Object)((String)tableProperties.elem)));
        }
        JdbcOptionsInWrite writeOptions = new JdbcOptionsInWrite((CaseInsensitiveMap<String>)tableOptions);
        boolean caseSensitive = SQLConf$.MODULE$.get().caseSensitiveAnalysis();
        JdbcUtils$.MODULE$.withConnection(this.options(), (Function1 & Serializable & scala.Serializable)conn -> {
            JdbcUtils$.MODULE$.classifyException(new java.lang.StringBuilder(23).append("Failed table creation: ").append(ident).toString(), this.dialect(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> JdbcUtils$.MODULE$.createTable(conn, this.getTableName(ident), schema, caseSensitive, writeOptions));
            return BoxedUnit.UNIT;
        });
        return new JDBCTable(ident, schema, writeOptions);
    }

    public Table alterTable(Identifier ident, Seq<TableChange> changes) {
        this.checkNamespace(ident.namespace());
        return (Table)JdbcUtils$.MODULE$.withConnection(this.options(), (Function1 & Serializable & scala.Serializable)conn -> {
            JdbcUtils$.MODULE$.classifyException(new java.lang.StringBuilder(23).append("Failed table altering: ").append(ident).toString(), this.dialect(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> JdbcUtils$.MODULE$.alterTable((Connection)conn, this.getTableName(ident), changes, this.options()));
            return this.loadTable(ident);
        });
    }

    public boolean namespaceExists(String[] namespace) {
        boolean bl;
        String[] stringArray = namespace;
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(1) == 0) {
            String db = (String)((SeqLike)option.get()).apply(0);
            bl = BoxesRunTime.unboxToBoolean(JdbcUtils$.MODULE$.withConnection(this.options(), (Function1 & Serializable & scala.Serializable)conn -> BoxesRunTime.boxToBoolean((boolean)JdbcUtils$.MODULE$.schemaExists(conn, this.options(), db))));
        } else {
            bl = false;
        }
        return bl;
    }

    public String[][] listNamespaces() {
        return (String[][])JdbcUtils$.MODULE$.withConnection(this.options(), (Function1 & Serializable & scala.Serializable)conn -> JdbcUtils$.MODULE$.listSchemas((Connection)conn, this.options()));
    }

    public String[][] listNamespaces(String[] namespace) {
        String[][] stringArray;
        String[] stringArray2 = namespace;
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray2);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(0) == 0) {
            stringArray = this.listNamespaces();
        } else {
            Option option2 = Array$.MODULE$.unapplySeq((Object)stringArray2);
            if (!option2.isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(1) == 0 && this.namespaceExists(namespace)) {
                stringArray = (String[][])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
            } else {
                throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError(namespace);
            }
        }
        return stringArray;
    }

    public Map<String, String> loadNamespaceMetadata(String[] namespace) {
        String[] stringArray = namespace;
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(1) == 0) {
            String db = (String)((SeqLike)option.get()).apply(0);
            if (!this.namespaceExists(namespace)) {
                throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError((String[])((Object[])new String[]{db}));
            }
        } else {
            throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError(namespace);
        }
        Map map = (Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$)).asJava();
        return map;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void createNamespace(String[] namespace, Map<String, String> metadata) {
        Option option;
        String[] stringArray = namespace;
        Option option2 = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option2.isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(1) == 0) {
            String db = (String)((SeqLike)option2.get()).apply(0);
            if (!this.namespaceExists(namespace)) {
                ObjectRef comment = ObjectRef.create((Object)"");
                if (!metadata.isEmpty()) {
                    ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(metadata).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        JDBCTableCatalog.$anonfun$createNamespace$1(comment, x0$1);
                        return BoxedUnit.UNIT;
                    });
                }
                BoxedUnit boxedUnit = (BoxedUnit)JdbcUtils$.MODULE$.withConnection(this.options(), (Function1 & Serializable & scala.Serializable)conn -> {
                    JdbcUtils$.MODULE$.classifyException(new java.lang.StringBuilder(26).append("Failed create name space: ").append(db).toString(), this.dialect(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> JdbcUtils$.MODULE$.createSchema(conn, this.options(), db, (String)comment$1.elem));
                    return BoxedUnit.UNIT;
                });
                return;
            }
        }
        if ((option = Array$.MODULE$.unapplySeq((Object)stringArray)).isEmpty()) throw QueryExecutionErrors$.MODULE$.invalidNamespaceNameError(namespace);
        if (option.get() == null) throw QueryExecutionErrors$.MODULE$.invalidNamespaceNameError(namespace);
        if (((SeqLike)option.get()).lengthCompare(1) != 0) throw QueryExecutionErrors$.MODULE$.invalidNamespaceNameError(namespace);
        throw QueryCompilationErrors$.MODULE$.namespaceAlreadyExistsError(namespace);
    }

    public void alterNamespace(String[] namespace, Seq<NamespaceChange> changes) {
        String[] stringArray = namespace;
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0) {
            throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError(namespace);
        }
        String db = (String)((SeqLike)option.get()).apply(0);
        changes.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            JDBCTableCatalog.$anonfun$alterNamespace$1(this, db, changes, x0$1);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public boolean dropNamespace(String[] namespace, boolean cascade) {
        String db;
        block3: {
            block2: {
                String[] stringArray = namespace;
                Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0) break block2;
                db = (String)((SeqLike)option.get()).apply(0);
                if (this.namespaceExists(namespace)) break block3;
            }
            throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError(namespace);
        }
        boolean bl = BoxesRunTime.unboxToBoolean(JdbcUtils$.MODULE$.withConnection(this.options(), (Function1 & Serializable & scala.Serializable)conn -> BoxesRunTime.boxToBoolean((boolean)JDBCTableCatalog.$anonfun$dropNamespace$1(this, db, cascade, conn))));
        return bl;
    }

    private void checkNamespace(String[] namespace) {
        if (namespace.length > 1) {
            throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError(namespace);
        }
    }

    private String getTableName(Identifier ident) {
        JdbcDialect jdbcDialect = this.dialect();
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ident.namespace())).$colon$plus((Object)ident.name(), ClassTag$.MODULE$.apply(String.class)))).map((Function1 & Serializable & scala.Serializable)colName -> jdbcDialect.quoteIdentifier((String)colName), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(".");
    }

    public void alterNamespace(String[] namespace, NamespaceChange[] changes) {
        this.alterNamespace(namespace, (Seq<NamespaceChange>)Predef$.MODULE$.wrapRefArray((Object[])changes));
    }

    public Table alterTable(Identifier ident, TableChange[] changes) {
        return this.alterTable(ident, (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])changes));
    }

    public static final /* synthetic */ boolean $anonfun$dropTable$1(JDBCTableCatalog $this, Identifier ident$1, Connection conn) {
        boolean bl;
        try {
            JdbcUtils$.MODULE$.dropTable(conn, $this.getTableName(ident$1), $this.options());
            bl = true;
        }
        catch (SQLException sQLException) {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ void $anonfun$createTable$1(ObjectRef tableComment$1, ObjectRef tableProperties$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            String string = k;
            if ("comment".equals(string)) {
                tableComment$1.elem = v;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                if ("provider".equals(string)) {
                    throw QueryCompilationErrors$.MODULE$.cannotCreateJDBCTableUsingProviderError();
                }
                if ("owner".equals(string)) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    if ("location".equals(string)) {
                        throw QueryCompilationErrors$.MODULE$.cannotCreateJDBCTableUsingLocationError();
                    }
                    tableProperties$1.elem = new java.lang.StringBuilder(2).append((String)tableProperties$1.elem).append(" ").append(k).append(" ").append(v).toString();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$createNamespace$1(ObjectRef comment$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        String string = k;
        if ("comment".equals(string)) {
            comment$1.elem = v;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("owner".equals(string)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (!"location".equals(string)) throw QueryCompilationErrors$.MODULE$.cannotCreateJDBCNamespaceWithPropertyError(k);
            throw QueryCompilationErrors$.MODULE$.cannotCreateJDBCNamespaceUsingProviderError();
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$alterNamespace$1(JDBCTableCatalog $this, String db$3, Seq changes$2, NamespaceChange x0$1) {
        block8: {
            block9: {
                block11: {
                    NamespaceChange.RemoveProperty removeProperty;
                    block12: {
                        String string;
                        String string2;
                        block10: {
                            NamespaceChange namespaceChange;
                            block4: {
                                NamespaceChange.SetProperty setProperty;
                                block6: {
                                    block7: {
                                        String string3;
                                        String string4;
                                        block5: {
                                            namespaceChange = x0$1;
                                            if (!(namespaceChange instanceof NamespaceChange.SetProperty)) break block4;
                                            setProperty = (NamespaceChange.SetProperty)namespaceChange;
                                            string4 = setProperty.property();
                                            string3 = "comment";
                                            if (string4 != null) break block5;
                                            if (string3 == null) break block6;
                                            break block7;
                                        }
                                        if (string4.equals(string3)) break block6;
                                    }
                                    throw QueryCompilationErrors$.MODULE$.cannotSetJDBCNamespaceWithPropertyError(setProperty.property());
                                }
                                BoxedUnit boxedUnit = (BoxedUnit)JdbcUtils$.MODULE$.withConnection($this.options(), (Function1 & Serializable & scala.Serializable)conn -> {
                                    JdbcUtils$.MODULE$.classifyException(new java.lang.StringBuilder(37).append("Failed create comment on name space: ").append(db$3).toString(), $this.dialect(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> JdbcUtils$.MODULE$.alterSchemaComment(conn, $this.options(), db$3, setProperty.value()));
                                    return BoxedUnit.UNIT;
                                });
                                break block8;
                            }
                            if (!(namespaceChange instanceof NamespaceChange.RemoveProperty)) break block9;
                            removeProperty = (NamespaceChange.RemoveProperty)namespaceChange;
                            string2 = removeProperty.property();
                            string = "comment";
                            if (string2 != null) break block10;
                            if (string == null) break block11;
                            break block12;
                        }
                        if (string2.equals(string)) break block11;
                    }
                    throw QueryCompilationErrors$.MODULE$.cannotUnsetJDBCNamespaceWithPropertyError(removeProperty.property());
                }
                BoxedUnit boxedUnit = (BoxedUnit)JdbcUtils$.MODULE$.withConnection($this.options(), (Function1 & Serializable & scala.Serializable)conn -> {
                    JdbcUtils$.MODULE$.classifyException(new java.lang.StringBuilder(37).append("Failed remove comment on name space: ").append(db$3).toString(), $this.dialect(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> JdbcUtils$.MODULE$.removeSchemaComment(conn, $this.options(), db$3));
                    return BoxedUnit.UNIT;
                });
                break block8;
            }
            throw QueryCompilationErrors$.MODULE$.unsupportedJDBCNamespaceChangeInCatalogError(changes$2);
        }
    }

    public static final /* synthetic */ boolean $anonfun$dropNamespace$1(JDBCTableCatalog $this, String db$4, boolean cascade$1, Connection conn) {
        return BoxesRunTime.unboxToBoolean(JdbcUtils$.MODULE$.classifyException(new java.lang.StringBuilder(24).append("Failed drop name space: ").append(db$4).toString(), $this.dialect(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            JdbcUtils$.MODULE$.dropSchema(conn, $this.options(), db$4, cascade$1);
            return true;
        }));
    }

    public JDBCTableCatalog() {
        Logging.$init$((Logging)this);
        this.catalogName = null;
    }
}

