/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.compression;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.execution.columnar.ColumnStats;
import org.apache.spark.sql.execution.columnar.ColumnarTestUtils$;
import org.apache.spark.sql.execution.columnar.INT$;
import org.apache.spark.sql.execution.columnar.IntColumnStats;
import org.apache.spark.sql.execution.columnar.LONG$;
import org.apache.spark.sql.execution.columnar.LongColumnStats;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.STRING$;
import org.apache.spark.sql.execution.columnar.StringColumnStats;
import org.apache.spark.sql.execution.columnar.compression.CompressionScheme;
import org.apache.spark.sql.execution.columnar.compression.CompressionScheme$;
import org.apache.spark.sql.execution.columnar.compression.DictionaryEncoding;
import org.apache.spark.sql.execution.columnar.compression.DictionaryEncoding$;
import org.apache.spark.sql.execution.columnar.compression.TestCompressibleColumnBuilder;
import org.apache.spark.sql.execution.columnar.compression.TestCompressibleColumnBuilder$;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001i3AAB\u0004\u0001-!)1\u0004\u0001C\u00019!9q\u0004\u0001b\u0001\n\u0003\u0001\u0003BB\u0014\u0001A\u0003%\u0011\u0005C\u0003)\u0001\u0011\u0005\u0011\u0006C\u0004M\u0001E\u0005I\u0011A'\u0003/\u0011K7\r^5p]\u0006\u0014\u00180\u00128d_\u0012LgnZ*vSR,'B\u0001\u0005\n\u0003-\u0019w.\u001c9sKN\u001c\u0018n\u001c8\u000b\u0005)Y\u0011\u0001C2pYVlg.\u0019:\u000b\u00051i\u0011!C3yK\u000e,H/[8o\u0015\tqq\"A\u0002tc2T!\u0001E\t\u0002\u000bM\u0004\u0018M]6\u000b\u0005I\u0019\u0012AB1qC\u000eDWMC\u0001\u0015\u0003\ry'oZ\u0002\u0001'\t\u0001q\u0003\u0005\u0002\u001935\tq\"\u0003\u0002\u001b\u001f\ti1\u000b]1sW\u001a+hnU;ji\u0016\fa\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"A\u0004\u0002\u00139,H\u000e\u001c,bYV,W#A\u0011\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\u0007%sG/\u0001\u0006ok2dg+\u00197vK\u0002\na\u0003^3ti\u0012K7\r^5p]\u0006\u0014\u00180\u00128d_\u0012LgnZ\u000b\u0003Um\"Ba\u000b\u00185\u000fB\u0011!\u0005L\u0005\u0003[\r\u0012A!\u00168ji\")q\u0006\u0002a\u0001a\u0005Y1m\u001c7v[:\u001cF/\u0019;t!\t\t$'D\u0001\n\u0013\t\u0019\u0014BA\u0006D_2,XN\\*uCR\u001c\b\"B\u001b\u0005\u0001\u00041\u0014AC2pYVlg\u000eV=qKB\u0019\u0011gN\u001d\n\u0005aJ!\u0001\u0005(bi&4XmQ8mk6tG+\u001f9f!\tQ4\b\u0004\u0001\u0005\u000bq\"!\u0019A\u001f\u0003\u0003Q\u000b\"AP!\u0011\u0005\tz\u0014B\u0001!$\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"AQ#\u000e\u0003\rS!\u0001R\u0007\u0002\u000bQL\b/Z:\n\u0005\u0019\u001b%AC!u_6L7\rV=qK\"9\u0001\n\u0002I\u0001\u0002\u0004I\u0015A\u0004;fgR$UmY8naJ,7o\u001d\t\u0003E)K!aS\u0012\u0003\u000f\t{w\u000e\\3b]\u0006\u0001C/Z:u\t&\u001cG/[8oCJLXI\\2pI&tw\r\n3fM\u0006,H\u000e\u001e\u00134+\tq\u0015,F\u0001PU\tI\u0005kK\u0001R!\t\u0011v+D\u0001T\u0015\t!V+A\u0005v]\u000eDWmY6fI*\u0011akI\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001-T\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0003\u0006y\u0015\u0011\r!\u0010")
public class DictionaryEncodingSuite
extends SparkFunSuite {
    private final int nullValue;

    public int nullValue() {
        return this.nullValue;
    }

    public <T extends AtomicType> void testDictionaryEncoding(ColumnStats columnStats, NativeColumnType<T> columnType, boolean testDecompress) {
        String typeName = new StringOps(Predef$.MODULE$.augmentString(columnType.getClass().getSimpleName())).stripSuffix("$");
        this.test(new StringBuilder(13).append(DictionaryEncoding$.MODULE$).append(" with ").append(typeName).append(": empty").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.skeleton$1(0, (Seq)Nil$.MODULE$, columnStats, columnType), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
        this.test(new StringBuilder(19).append(DictionaryEncoding$.MODULE$).append(" with ").append(typeName).append(": simple case").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.skeleton$1(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 0, 1})), columnStats, columnType), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
        this.test(new StringBuilder(27).append(DictionaryEncoding$.MODULE$).append(" with ").append(typeName).append(": dictionary overflow").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.skeleton$1(DictionaryEncoding$.MODULE$.MAX_DICT_SIZE() + 1, (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), (int)DictionaryEncoding$.MODULE$.MAX_DICT_SIZE()), columnStats, columnType), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
        this.test(new StringBuilder(30).append(DictionaryEncoding$.MODULE$).append(" with ").append(typeName).append(": empty for decompress()").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.skeletonForDecompress$1(0, (Seq)Nil$.MODULE$, testDecompress, columnStats, columnType), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
        this.test(new StringBuilder(36).append(DictionaryEncoding$.MODULE$).append(" with ").append(typeName).append(": simple case for decompress()").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.skeletonForDecompress$1(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, this.nullValue(), 0, this.nullValue()})), testDecompress, columnStats, columnType), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
        this.test(new StringBuilder(44).append(DictionaryEncoding$.MODULE$).append(" with ").append(typeName).append(": dictionary overflow for decompress()").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.skeletonForDecompress$1(DictionaryEncoding$.MODULE$.MAX_DICT_SIZE() + 2, (Seq)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.nullValue()}))).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), DictionaryEncoding$.MODULE$.MAX_DICT_SIZE() - 1), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.nullValue()})), Seq$.MODULE$.canBuildFrom()), testDecompress, columnStats, columnType), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
    }

    public <T extends AtomicType> boolean testDictionaryEncoding$default$3() {
        return true;
    }

    private static final Map buildDictionary$1(ByteBuffer buffer, NativeColumnType columnType$1) {
        return ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), buffer.getInt()).map((Function1 & Serializable & scala.Serializable)x$1 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(columnType$1.extract(buffer)), (Object)BoxesRunTime.boxToShort((short)((short)BoxesRunTime.unboxToInt((Object)x$1)))), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private static final Seq stableDistinct$1(Seq seq) {
        Seq seq2;
        if (seq.isEmpty()) {
            seq2 = (Seq)Nil$.MODULE$;
        } else {
            int n = BoxesRunTime.unboxToInt((Object)seq.head());
            seq2 = (Seq)((SeqLike)((TraversableLike)seq.tail()).filterNot((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$2 -> x$2 == BoxesRunTime.unboxToInt((Object)seq.head()))).$plus$colon((Object)BoxesRunTime.boxToInteger((int)n), Seq$.MODULE$.canBuildFrom());
        }
        return seq2;
    }

    public static final /* synthetic */ Assertion $anonfun$testDictionaryEncoding$9(DictionaryEncodingSuite $this, DictionaryEncoding.Decoder decoder$1, Seq values$1, GenericInternalRow mutableRow$1, NativeColumnType columnType$1, int i) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(decoder$1.hasNext(), "decoder.hasNext", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        Object object = values$1.apply(i);
        decoder$1.next((InternalRow)mutableRow$1, 0);
        return $this.assertResult(object, "Wrong decoded value", columnType$1.getField((InternalRow)mutableRow$1, 0), Prettifier$.MODULE$.default(), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
    }

    private final void skeleton$1(int uniqueValueCount, Seq inputSeq, ColumnStats columnStats$1, NativeColumnType columnType$1) {
        TestCompressibleColumnBuilder builder = TestCompressibleColumnBuilder$.MODULE$.apply(columnStats$1, columnType$1, (CompressionScheme)DictionaryEncoding$.MODULE$);
        Tuple2<Seq<Object>, Seq<GenericInternalRow>> tuple2 = ColumnarTestUtils$.MODULE$.makeUniqueValuesAndSingleValueRows(columnType$1, uniqueValueCount);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq values = (Seq)tuple2._1();
        Seq rows = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)values, (Object)rows);
        Tuple2 tuple23 = tuple22;
        Seq values2 = (Seq)tuple23._1();
        Seq rows2 = (Seq)tuple23._2();
        Seq dictValues = DictionaryEncodingSuite.stableDistinct$1(inputSeq);
        inputSeq.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> builder.appendFrom((InternalRow)rows2.apply(i), 0));
        if (dictValues.length() > DictionaryEncoding$.MODULE$.MAX_DICT_SIZE()) {
            this.withClue("Dictionary overflowed, compression should fail", (Function0 & Serializable & scala.Serializable)() -> (Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> builder.build(), ClassTag$.MODULE$.apply(Throwable.class), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65)));
        } else {
            ByteBuffer buffer = builder.build();
            int headerSize = CompressionScheme$.MODULE$.columnHeaderSize(buffer);
            int dictionarySize = 4 + BoxesRunTime.unboxToInt((Object)((TraversableOnce)rows2.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)columnType$1.actualSize((InternalRow)x$5, 0)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            int compressedSize = 4 + dictionarySize + 2 * inputSeq.length();
            this.assertResult(BoxesRunTime.boxToInteger((int)(headerSize + compressedSize)), "Wrong buffer capacity", BoxesRunTime.boxToInteger((int)buffer.capacity()), Prettifier$.MODULE$.default(), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
            buffer.position(headerSize);
            this.assertResult(BoxesRunTime.boxToInteger((int)DictionaryEncoding$.MODULE$.typeId()), "Wrong compression scheme ID", BoxesRunTime.boxToInteger((int)buffer.getInt()), Prettifier$.MODULE$.default(), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
            Map dictionary = DictionaryEncodingSuite.buildDictionary$1(buffer, columnType$1).toMap(Predef$.MODULE$.$conforms());
            dictValues.foreach((Function1 & Serializable & scala.Serializable)i -> this.assertResult(BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), "Wrong dictionary entry", dictionary.apply(values2.apply(BoxesRunTime.unboxToInt((Object)i))), Prettifier$.MODULE$.default(), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86)));
            inputSeq.foreach((Function1 & Serializable & scala.Serializable)i -> this.assertResult(BoxesRunTime.boxToShort((short)((short)BoxesRunTime.unboxToInt((Object)i))), "Wrong column element value", BoxesRunTime.boxToShort((short)buffer.getShort()), Prettifier$.MODULE$.default(), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92)));
            buffer.rewind().position(headerSize + 4);
            DictionaryEncoding.Decoder decoder = DictionaryEncoding$.MODULE$.decoder(buffer, columnType$1);
            GenericInternalRow mutableRow = new GenericInternalRow(1);
            if (inputSeq.nonEmpty()) {
                inputSeq.foreach((Function1 & Serializable & scala.Serializable)i -> DictionaryEncodingSuite.$anonfun$testDictionaryEncoding$9(this, decoder, values2, mutableRow, columnType$1, BoxesRunTime.unboxToInt((Object)i)));
            }
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(decoder.hasNext(), "decoder.hasNext", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        }
    }

    private final void skeletonForDecompress$1(int uniqueValueCount, Seq inputSeq, boolean testDecompress$1, ColumnStats columnStats$1, NativeColumnType columnType$1) {
        block2: {
            if (!testDecompress$1) {
                return;
            }
            TestCompressibleColumnBuilder builder = TestCompressibleColumnBuilder$.MODULE$.apply(columnStats$1, columnType$1, (CompressionScheme)DictionaryEncoding$.MODULE$);
            Tuple2<Seq<Object>, Seq<GenericInternalRow>> tuple2 = ColumnarTestUtils$.MODULE$.makeUniqueValuesAndSingleValueRows(columnType$1, uniqueValueCount);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Seq values = (Seq)tuple2._1();
            Seq rows = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)values, (Object)rows);
            Tuple2 tuple23 = tuple22;
            Seq values2 = (Seq)tuple23._1();
            Seq rows2 = (Seq)tuple23._2();
            Seq dictValues = DictionaryEncodingSuite.stableDistinct$1(inputSeq);
            GenericInternalRow nullRow = new GenericInternalRow(1);
            nullRow.setNullAt(0);
            inputSeq.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                if (i == this.nullValue()) {
                    builder.appendFrom((InternalRow)nullRow, 0);
                } else {
                    builder.appendFrom((InternalRow)rows2.apply(i), 0);
                }
            });
            ByteBuffer buffer = builder.build();
            int headerSize = CompressionScheme$.MODULE$.columnHeaderSize(buffer);
            buffer.position(headerSize);
            this.assertResult(BoxesRunTime.boxToInteger((int)DictionaryEncoding$.MODULE$.typeId()), "Wrong compression scheme ID", BoxesRunTime.boxToInteger((int)buffer.getInt()), Prettifier$.MODULE$.default(), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
            DictionaryEncoding.Decoder decoder = DictionaryEncoding$.MODULE$.decoder(buffer, columnType$1);
            OnHeapColumnVector columnVector = new OnHeapColumnVector(inputSeq.length(), (DataType)columnType$1.dataType());
            decoder.decompress((WritableColumnVector)columnVector, inputSeq.length());
            if (!inputSeq.nonEmpty()) break block2;
            ((IterableLike)inputSeq.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Assertion assertion;
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    int i = tuple2._1$mcI$sp();
                    int index = tuple2._2$mcI$sp();
                    int n = i;
                    int n2 = index;
                    if (n == this.nullValue()) {
                        assertion = this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), new StringBuilder(23).append("Wrong null ").append(n2).append("-th position").toString(), BoxesRunTime.boxToBoolean((boolean)columnVector.isNullAt(n2)), Prettifier$.MODULE$.default(), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
                    } else {
                        Assertion assertion2;
                        NativeColumnType nativeColumnType = columnType$1;
                        if (INT$.MODULE$.equals(nativeColumnType)) {
                            assertion2 = this.assertResult(values2.apply(n), new StringBuilder(27).append("Wrong ").append(n2).append("-th decoded int value").toString(), BoxesRunTime.boxToInteger((int)columnVector.getInt(n2)), Prettifier$.MODULE$.default(), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
                        } else if (LONG$.MODULE$.equals(nativeColumnType)) {
                            assertion2 = this.assertResult(values2.apply(n), new StringBuilder(28).append("Wrong ").append(n2).append("-th decoded long value").toString(), BoxesRunTime.boxToLong((long)columnVector.getLong(n2)), Prettifier$.MODULE$.default(), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
                        } else {
                            throw this.fail("Unsupported type", new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
                        }
                        assertion = assertion2;
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                Assertion assertion3 = assertion;
                return assertion3;
            });
        }
    }

    public DictionaryEncodingSuite() {
        this.nullValue = -1;
        this.testDictionaryEncoding((ColumnStats)new IntColumnStats(), (NativeColumnType)INT$.MODULE$, this.testDictionaryEncoding$default$3());
        this.testDictionaryEncoding((ColumnStats)new LongColumnStats(), (NativeColumnType)LONG$.MODULE$, this.testDictionaryEncoding$default$3());
        this.testDictionaryEncoding((ColumnStats)new StringColumnStats(), (NativeColumnType)STRING$.MODULE$, false);
    }
}

