/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.vectorized;

import java.io.Serializable;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.vectorized.OffHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.util.collection.BitSet;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

public final class ColumnarBatchBenchmark$
extends BenchmarkBase {
    public static ColumnarBatchBenchmark$ MODULE$;

    static {
        new ColumnarBatchBenchmark$();
    }

    public void intAccess(long iters) {
        int count = 8000;
        JFunction1.mcVI.sp & Serializable & scala.Serializable javaArray = (JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int[] data = new int[count];
            LongRef sum = LongRef.create((long)0L);
            new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)iters)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)n -> {
                int i;
                for (i = 0; i < count; ++i) {
                    data$1[i] = i;
                }
                for (i = 0; i < count; ++i) {
                    sum$1.elem += (long)data[i];
                }
            });
        };
        JFunction1.mcVI.sp & Serializable & scala.Serializable byteBufferUnsafe = (JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            ByteBuffer data = ByteBuffer.allocate(count * 4);
            LongRef sum = LongRef.create((long)0L);
            new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)iters)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)n -> {
                int i;
                for (i = 0; i < count; ++i) {
                    Platform.putInt((Object)data.array(), (long)(Platform.BYTE_ARRAY_OFFSET + i * 4), (int)i);
                }
                for (i = 0; i < count; ++i) {
                    sum$2.elem += (long)Platform.getInt((Object)data.array(), (long)(Platform.BYTE_ARRAY_OFFSET + i * 4));
                }
            });
        };
        JFunction1.mcVI.sp & Serializable & scala.Serializable directByteBuffer = (JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            IntBuffer data = ByteBuffer.allocateDirect(count * 4).asIntBuffer();
            LongRef sum = LongRef.create((long)0L);
            new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)iters)).foreach((Function1 & Serializable & scala.Serializable)n -> ColumnarBatchBenchmark$.$anonfun$intAccess$6(count, data, sum, BoxesRunTime.unboxToLong((Object)n)));
        };
        JFunction1.mcVI.sp & Serializable & scala.Serializable byteBufferApi = (JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            ByteBuffer data = ByteBuffer.allocate(count * 4);
            LongRef sum = LongRef.create((long)0L);
            new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)iters)).foreach((Function1 & Serializable & scala.Serializable)n -> ColumnarBatchBenchmark$.$anonfun$intAccess$8(count, data, sum, BoxesRunTime.unboxToLong((Object)n)));
        };
        JFunction1.mcVI.sp & Serializable & scala.Serializable unsafeBuffer = (JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            long data = Platform.allocateMemory((long)(count * 4));
            LongRef sum = LongRef.create((long)0L);
            new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)iters)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)n -> {
                int i;
                long ptr = data;
                for (i = 0; i < count; ++i) {
                    Platform.putInt(null, (long)ptr, (int)i);
                    ptr += 4L;
                }
                ptr = data;
                for (i = 0; i < count; ++i) {
                    sum$5.elem += (long)Platform.getInt(null, (long)ptr);
                    ptr += 4L;
                }
            });
        };
        JFunction1.mcVI.sp & Serializable & scala.Serializable columnOnHeap = (JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            OnHeapColumnVector col = new OnHeapColumnVector(count, (DataType)IntegerType$.MODULE$);
            LongRef sum = LongRef.create((long)0L);
            new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)iters)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)n -> {
                int i;
                for (i = 0; i < count; ++i) {
                    col.putInt(i, i);
                }
                for (i = 0; i < count; ++i) {
                    sum$6.elem += (long)col.getInt(i);
                }
            });
            col.close();
        };
        JFunction1.mcVI.sp & Serializable & scala.Serializable columnOffheapDirect = (JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            OffHeapColumnVector col = new OffHeapColumnVector(count, (DataType)IntegerType$.MODULE$);
            LongRef sum = LongRef.create((long)0L);
            new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)iters)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)n -> {
                int i;
                long addr = col.valuesNativeAddress();
                for (i = 0; i < count; ++i) {
                    Platform.putInt(null, (long)addr, (int)i);
                    addr += 4L;
                }
                addr = col.valuesNativeAddress();
                for (i = 0; i < count; ++i) {
                    sum$8.elem += (long)Platform.getInt(null, (long)addr);
                    addr += 4L;
                }
            });
            col.close();
        };
        JFunction1.mcVI.sp & Serializable & scala.Serializable unsafeRowOnheap = (JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            byte[] buffer = new byte[count * 16];
            LongRef sum = LongRef.create((long)0L);
            new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)iters)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)n -> {
                int i;
                UnsafeRow row = new UnsafeRow(1);
                for (i = 0; i < count; ++i) {
                    row.pointTo((Object)buffer, (long)(Platform.BYTE_ARRAY_OFFSET + i * 16), 16);
                    row.setInt(0, i);
                }
                for (i = 0; i < count; ++i) {
                    row.pointTo((Object)buffer, (long)(Platform.BYTE_ARRAY_OFFSET + i * 16), 16);
                    sum$9.elem += (long)row.getInt(0);
                }
            });
        };
        JFunction1.mcVI.sp & Serializable & scala.Serializable unsafeRowOffheap = (JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            long buffer = Platform.allocateMemory((long)(count * 16));
            LongRef sum = LongRef.create((long)0L);
            new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)iters)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)n -> {
                int i;
                UnsafeRow row = new UnsafeRow(1);
                for (i = 0; i < count; ++i) {
                    row.pointTo(null, buffer + (long)(i * 16), 16);
                    row.setInt(0, i);
                }
                for (i = 0; i < count; ++i) {
                    row.pointTo(null, buffer + (long)(i * 16), 16);
                    sum$10.elem += (long)row.getInt(0);
                }
            });
            Platform.freeMemory((long)buffer);
        };
        JFunction1.mcVI.sp & Serializable & scala.Serializable onHeapAppend = (JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            OnHeapColumnVector col = new OnHeapColumnVector(count, (DataType)IntegerType$.MODULE$);
            LongRef sum = LongRef.create((long)0L);
            new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)iters)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)n -> {
                int i;
                for (i = 0; i < count; ++i) {
                    col.appendInt(i);
                }
                for (i = 0; i < count; ++i) {
                    sum$11.elem += (long)col.getInt(i);
                }
                col.reset();
            });
            col.close();
        };
        String x$1 = "Int Read/Write";
        long x$2 = (long)count * iters;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        benchmark.addCase("Java Array", benchmark.addCase$default$2(), (Function1)javaArray);
        benchmark.addCase("ByteBuffer Unsafe", benchmark.addCase$default$2(), (Function1)byteBufferUnsafe);
        benchmark.addCase("ByteBuffer API", benchmark.addCase$default$2(), (Function1)byteBufferApi);
        benchmark.addCase("DirectByteBuffer", benchmark.addCase$default$2(), (Function1)directByteBuffer);
        benchmark.addCase("Unsafe Buffer", benchmark.addCase$default$2(), (Function1)unsafeBuffer);
        benchmark.addCase("Column(on heap)", benchmark.addCase$default$2(), (Function1)columnOnHeap);
        benchmark.addCase("Column(off heap)", benchmark.addCase$default$2(), ColumnarBatchBenchmark$.columnOffHeap$1(count, iters));
        benchmark.addCase("Column(off heap direct)", benchmark.addCase$default$2(), (Function1)columnOffheapDirect);
        benchmark.addCase("UnsafeRow (on heap)", benchmark.addCase$default$2(), (Function1)unsafeRowOnheap);
        benchmark.addCase("UnsafeRow (off heap)", benchmark.addCase$default$2(), (Function1)unsafeRowOffheap);
        benchmark.addCase("Column On Heap Append", benchmark.addCase$default$2(), (Function1)onHeapAppend);
        benchmark.run();
    }

    public void booleanAccess(int iters) {
        int count = 8192;
        String x$1 = "Boolean Read/Write";
        long x$2 = (long)iters * (long)count;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        benchmark.addCase("Bitset", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            BitSet b = new BitSet(count);
            LongRef sum = LongRef.create((long)0L);
            new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)iters)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)n -> {
                int i;
                for (i = 0; i < count; ++i) {
                    if (i % 2 != 0) continue;
                    b.set(i);
                }
                for (i = 0; i < count; ++i) {
                    if (!b.get(i)) continue;
                    ++sum$12.elem;
                }
            });
        });
        benchmark.addCase("Byte Array", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            byte[] b = new byte[count];
            LongRef sum = LongRef.create((long)0L);
            new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)iters)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)n -> {
                int i;
                for (i = 0; i < count; ++i) {
                    if (i % 2 != 0) continue;
                    b$2[i] = 1;
                }
                for (i = 0; i < count; ++i) {
                    if (b[i] != 1) continue;
                    ++sum$13.elem;
                }
            });
        });
        benchmark.run();
    }

    public void stringAccess(long iters) {
        String chars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        Random random = new Random(0);
        int minString = 3;
        int maxString = 32;
        int count = 4000;
        byte[][] data = (byte[][])((TraversableOnce)((TraversableLike)Seq$.MODULE$.fill(count, (Function0 & Serializable & scala.Serializable)() -> ColumnarBatchBenchmark$.randomString$1(minString, maxString, random, chars))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getBytes(StandardCharsets.UTF_8), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        String x$12 = "String Read/Write";
        long x$2 = (long)count * iters;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$12, x$2, x$4, x$5, x$6, x$7, x$3);
        benchmark.addCase("On Heap", benchmark.addCase$default$2(), ColumnarBatchBenchmark$.column$1(MemoryMode.ON_HEAP, count, iters, data));
        benchmark.addCase("Off Heap", benchmark.addCase$default$2(), ColumnarBatchBenchmark$.column$1(MemoryMode.OFF_HEAP, count, iters, data));
        benchmark.run();
    }

    public void arrayAccess(int iters) {
        Random random = new Random(0);
        int count = 4000;
        OnHeapColumnVector onHeapVector = new OnHeapColumnVector(count, (DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$));
        OffHeapColumnVector offHeapVector = new OffHeapColumnVector(count, (DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$));
        int minSize = 3;
        int maxSize = 32;
        int elementsCount = 0;
        for (int arraysCount = 0; arraysCount < count; ++arraysCount) {
            int size = random.nextInt(maxSize - minSize) + minSize;
            WritableColumnVector onHeapArrayData = onHeapVector.arrayData();
            WritableColumnVector offHeapArrayData = offHeapVector.arrayData();
            for (int i = 0; i < size; ++i) {
                int value = random.nextInt();
                onHeapArrayData.appendInt(value);
                offHeapArrayData.appendInt(value);
            }
            onHeapVector.putArray(arraysCount, elementsCount, size);
            offHeapVector.putArray(arraysCount, elementsCount, size);
            elementsCount += size;
        }
        String x$1 = "Array Vector Read";
        long x$22 = count * iters;
        Option x$32 = this.output();
        int x$42 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$52 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$22, x$42, x$52, x$6, x$7, x$32);
        benchmark.addCase("On Heap Read Size Only", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$2 -> ColumnarBatchBenchmark$.readArrays$1(true, onHeapVector, offHeapVector, iters, count));
        benchmark.addCase("Off Heap Read Size Only", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$3 -> ColumnarBatchBenchmark$.readArrays$1(false, onHeapVector, offHeapVector, iters, count));
        benchmark.addCase("On Heap Read Elements", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$4 -> ColumnarBatchBenchmark$.readArrayElements$1(true, onHeapVector, offHeapVector, iters, count));
        benchmark.addCase("Off Heap Read Elements", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$5 -> ColumnarBatchBenchmark$.readArrayElements$1(false, onHeapVector, offHeapVector, iters, count));
        benchmark.run();
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        this.runBenchmark("Int Read/Write", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.intAccess(40960L));
        this.runBenchmark("Boolean Read/Write", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.booleanAccess(40960));
        this.runBenchmark("String Read/Write", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.stringAccess(4096L));
        this.runBenchmark("Array Vector Read", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.arrayAccess(40960));
    }

    public static final /* synthetic */ Buffer $anonfun$intAccess$6(int count$1, IntBuffer data$3, LongRef sum$3, long n) {
        int i;
        for (i = 0; i < count$1; ++i) {
            data$3.put(i);
        }
        data$3.rewind();
        for (i = 0; i < count$1; ++i) {
            sum$3.elem += (long)data$3.get();
        }
        return data$3.rewind();
    }

    public static final /* synthetic */ Buffer $anonfun$intAccess$8(int count$1, ByteBuffer data$4, LongRef sum$4, long n) {
        int i;
        for (i = 0; i < count$1; ++i) {
            data$4.putInt(i);
        }
        data$4.rewind();
        for (i = 0; i < count$1; ++i) {
            sum$4.elem += (long)data$4.getInt();
        }
        return data$4.rewind();
    }

    private static final Function1 columnOffHeap$1(int count$1, long iters$1) {
        return (JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            OffHeapColumnVector col = new OffHeapColumnVector(count$1, (DataType)IntegerType$.MODULE$);
            LongRef sum = LongRef.create((long)0L);
            new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)iters$1)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)n -> {
                int i;
                for (i = 0; i < count$1; ++i) {
                    col.putInt(i, i);
                }
                for (i = 0; i < count$1; ++i) {
                    sum$7.elem += (long)col.getInt(i);
                }
            });
            col.close();
        };
    }

    private static final String randomString$1(int min, int max, Random random$1, String chars$1) {
        int len = random$1.nextInt(max - min) + min;
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            sb.append(chars$1.charAt(random$1.nextInt(chars$1.length())));
        }
        return sb.toString();
    }

    public static final /* synthetic */ void $anonfun$stringAccess$4(int count$3, WritableColumnVector column$2, byte[][] data$6, LongRef sum$14, long n) {
        int i;
        for (i = 0; i < count$3; ++i) {
            column$2.putByteArray(i, data$6[i]);
        }
        for (i = 0; i < count$3; ++i) {
            sum$14.elem += (long)column$2.getUTF8String(i).numBytes();
        }
        column$2.reset();
    }

    private static final Function1 column$1(MemoryMode memoryMode, int count$3, long iters$3, byte[][] data$6) {
        return (JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            MemoryMode memoryMode = memoryMode;
            MemoryMode memoryMode2 = MemoryMode.OFF_HEAP;
            OffHeapColumnVector column = !(memoryMode != null ? !memoryMode.equals(memoryMode2) : memoryMode2 != null) ? new OffHeapColumnVector(count$3, (DataType)BinaryType$.MODULE$) : new OnHeapColumnVector(count$3, (DataType)BinaryType$.MODULE$);
            LongRef sum = LongRef.create((long)0L);
            new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)iters$3)).foreach((Function1)((JFunction1.mcVJ.sp & Serializable & scala.Serializable)arg_0 -> ColumnarBatchBenchmark$.$anonfun$stringAccess$4(count$3, (WritableColumnVector)column, data$6, sum, arg_0)));
        };
    }

    public static final /* synthetic */ void $anonfun$arrayAccess$1(int count$4, LongRef sum$15, WritableColumnVector vector$1, int _) {
        for (int i = 0; i < count$4; ++i) {
            sum$15.elem += (long)vector$1.getArray(i).numElements();
        }
    }

    private static final void readArrays$1(boolean onHeap, OnHeapColumnVector onHeapVector$1, OffHeapColumnVector offHeapVector$1, int iters$4, int count$4) {
        OnHeapColumnVector vector = onHeap ? onHeapVector$1 : offHeapVector$1;
        LongRef sum = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), iters$4).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable & scala.Serializable)arg_0 -> ColumnarBatchBenchmark$.$anonfun$arrayAccess$1(count$4, sum, (WritableColumnVector)vector, arg_0)));
    }

    public static final /* synthetic */ void $anonfun$arrayAccess$2(int count$4, WritableColumnVector vector$2, LongRef sum$16, int _) {
        for (int i = 0; i < count$4; ++i) {
            ColumnarArray array = vector$2.getArray(i);
            int size = array.numElements();
            for (int j = 0; j < size; ++j) {
                sum$16.elem += (long)array.getInt(j);
            }
        }
    }

    private static final void readArrayElements$1(boolean onHeap, OnHeapColumnVector onHeapVector$1, OffHeapColumnVector offHeapVector$1, int iters$4, int count$4) {
        OnHeapColumnVector vector = onHeap ? onHeapVector$1 : offHeapVector$1;
        LongRef sum = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), iters$4).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable & scala.Serializable)arg_0 -> ColumnarBatchBenchmark$.$anonfun$arrayAccess$2(count$4, (WritableColumnVector)vector, sum, arg_0)));
    }

    private ColumnarBatchBenchmark$() {
        MODULE$ = this;
    }
}

