/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.io.ColumnIO;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.GroupColumnIO;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.PrimitiveColumnIO;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetColumn;
import org.apache.spark.sql.execution.datasources.parquet.ParquetColumn$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001de\u0001\u0002\u000e\u001c\u0001)B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tk\u0001\u0011\t\u0011)A\u0005e!Aa\u0007\u0001B\u0001B\u0003%!\u0007C\u00038\u0001\u0011\u0005\u0001\bC\u00038\u0001\u0011\u0005a\bC\u00038\u0001\u0011\u0005q\tC\u0003Q\u0001\u0011\u0005\u0011\u000bC\u0003b\u0001\u0011\u0005!\rC\u0004m\u0001E\u0005I\u0011A7\t\u000ba\u0004A\u0011B=\t\u0011\u0005\u001d\u0001!%A\u0005\n5Dq!!\u0003\u0001\t\u0013\tY\u0001C\u0004\u0002(\u0001!\t!!\u000b\t\u0013\u0005\u0005\u0003!%A\u0005\u0002\u0005\r\u0003bBA$\u0001\u0011%\u0011\u0011\n\u0005\n\u0003/\u0002\u0011\u0013!C\u0005\u0003\u0007Bq!!\u0017\u0001\t\u0013\tY\u0006C\u0005\u0002b\u0001\t\n\u0011\"\u0003\u0002D!A\u00111\r\u0001\u0005\u0002m\t)gB\u0005\u0002vm\t\t\u0011#\u0001\u0002x\u0019A!dGA\u0001\u0012\u0003\tI\b\u0003\u00048+\u0011\u0005\u00111\u0010\u0005\n\u0003{*\u0012\u0013!C\u0001\u0003\u007fB\u0011\"a!\u0016#\u0003%\t!a \t\u0013\u0005\u0015U#%A\u0005\u0002\u0005}$!\b)beF,X\r\u001e+p'B\f'o[*dQ\u0016l\u0017mQ8om\u0016\u0014H/\u001a:\u000b\u0005qi\u0012a\u00029beF,X\r\u001e\u0006\u0003=}\t1\u0002Z1uCN|WO]2fg*\u0011\u0001%I\u0001\nKb,7-\u001e;j_:T!AI\u0012\u0002\u0007M\fHN\u0003\u0002%K\u0005)1\u000f]1sW*\u0011aeJ\u0001\u0007CB\f7\r[3\u000b\u0003!\n1a\u001c:h\u0007\u0001\u0019\"\u0001A\u0016\u0011\u00051zS\"A\u0017\u000b\u00039\nQa]2bY\u0006L!\u0001M\u0017\u0003\r\u0005s\u0017PU3g\u0003Q\t7o];nK\nKg.\u0019:z\u0013N\u001cFO]5oOB\u0011AfM\u0005\u0003i5\u0012qAQ8pY\u0016\fg.\u0001\fbgN,X.Z%oif2\u0014j\u001d+j[\u0016\u001cH/Y7q\u00035\u0019\u0017m]3TK:\u001c\u0018\u000e^5wK\u00061A(\u001b8jiz\"B!O\u001e={A\u0011!\bA\u0007\u00027!9\u0011\u0007\u0002I\u0001\u0002\u0004\u0011\u0004bB\u001b\u0005!\u0003\u0005\rA\r\u0005\bm\u0011\u0001\n\u00111\u00013)\tIt\bC\u0003A\u000b\u0001\u0007\u0011)\u0001\u0003d_:4\u0007C\u0001\"F\u001b\u0005\u0019%B\u0001#\"\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001$D\u0005\u001d\u0019\u0016\u000bT\"p]\u001a$\"!\u000f%\t\u000b\u00013\u0001\u0019A%\u0011\u0005)sU\"A&\u000b\u0005\u0001c%BA'&\u0003\u0019A\u0017\rZ8pa&\u0011qj\u0013\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u000f\r|gN^3siR\u0011!\u000b\u0017\t\u0003'Zk\u0011\u0001\u0016\u0006\u0003+\u0006\nQ\u0001^=qKNL!a\u0016+\u0003\u0015M#(/^2u)f\u0004X\rC\u0003Z\u000f\u0001\u0007!,A\u0007qCJ\fX/\u001a;TG\",W.\u0019\t\u00037~k\u0011\u0001\u0018\u0006\u0003;z\u000baa]2iK6\f'B\u0001\u000f&\u0013\t\u0001GLA\u0006NKN\u001c\u0018mZ3UsB,\u0017\u0001F2p]Z,'\u000f\u001e)beF,X\r^\"pYVlg\u000eF\u0002dM\u001e\u0004\"A\u000f3\n\u0005\u0015\\\"!\u0004)beF,X\r^\"pYVlg\u000eC\u0003Z\u0011\u0001\u0007!\fC\u0004i\u0011A\u0005\t\u0019A5\u0002\u001fM\u0004\u0018M]6SK\u0006$7k\u00195f[\u0006\u00042\u0001\f6S\u0013\tYWF\u0001\u0004PaRLwN\\\u0001\u001fG>tg/\u001a:u!\u0006\u0014\u0018/^3u\u0007>dW/\u001c8%I\u00164\u0017-\u001e7uII*\u0012A\u001c\u0016\u0003S>\\\u0013\u0001\u001d\t\u0003cZl\u0011A\u001d\u0006\u0003gR\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005Ul\u0013AC1o]>$\u0018\r^5p]&\u0011qO\u001d\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aD2p]Z,'\u000f^%oi\u0016\u0014h.\u00197\u0015\t\rT\u0018Q\u0001\u0005\u0006w*\u0001\r\u0001`\u0001\fOJ|W\u000f]\"pYVlg\u000eE\u0002~\u0003\u0003i\u0011A \u0006\u0003\u007fz\u000b!![8\n\u0007\u0005\raPA\u0007He>,\boQ8mk6t\u0017j\u0014\u0005\bQ*\u0001\n\u00111\u0001j\u0003e\u0019wN\u001c<feRLe\u000e^3s]\u0006dG\u0005Z3gCVdG\u000f\n\u001a\u0002%9|'/\\1mSj,g)[3mI:\u000bW.\u001a\u000b\u0005\u0003\u001b\t\u0019\u0003\u0005\u0003\u0002\u0010\u0005ua\u0002BA\t\u00033\u00012!a\u0005.\u001b\t\t)BC\u0002\u0002\u0018%\na\u0001\u0010:p_Rt\u0014bAA\u000e[\u00051\u0001K]3eK\u001aLA!a\b\u0002\"\t11\u000b\u001e:j]\u001eT1!a\u0007.\u0011\u001d\t)\u0003\u0004a\u0001\u0003\u001b\tAA\\1nK\u0006a1m\u001c8wKJ$h)[3mIR)1-a\u000b\u00026!9\u0011QF\u0007A\u0002\u0005=\u0012!\u00024jK2$\u0007cA?\u00022%\u0019\u00111\u0007@\u0003\u0011\r{G.^7o\u0013>C\u0011\"a\u000e\u000e!\u0003\u0005\r!!\u000f\u0002\u001bM\u0004\u0018M]6SK\u0006$G+\u001f9f!\u0011a#.a\u000f\u0011\u0007M\u000bi$C\u0002\u0002@Q\u0013\u0001\u0002R1uCRK\b/Z\u0001\u0017G>tg/\u001a:u\r&,G\u000e\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\t\u0016\u0004\u0003sy\u0017!F2p]Z,'\u000f\u001e)sS6LG/\u001b<f\r&,G\u000e\u001a\u000b\u0006G\u0006-\u0013Q\u000b\u0005\b\u0003\u001bz\u0001\u0019AA(\u0003=\u0001(/[7ji&4XmQ8mk6t\u0007cA?\u0002R%\u0019\u00111\u000b@\u0003#A\u0013\u0018.\\5uSZ,7i\u001c7v[:Lu\nC\u0005\u00028=\u0001\n\u00111\u0001\u0002:\u0005y2m\u001c8wKJ$\bK]5nSRLg/\u001a$jK2$G\u0005Z3gCVdG\u000f\n\u001a\u0002#\r|gN^3si\u001e\u0013x.\u001e9GS\u0016dG\rF\u0003d\u0003;\ny\u0006C\u0003|#\u0001\u0007A\u0010C\u0005\u00028E\u0001\n\u00111\u0001\u0002:\u0005Y2m\u001c8wKJ$xI]8va\u001aKW\r\u001c3%I\u00164\u0017-\u001e7uII\nQ\"[:FY\u0016lWM\u001c;UsB,G#\u0002\u001a\u0002h\u0005E\u0004bBA5'\u0001\u0007\u00111N\u0001\re\u0016\u0004X-\u0019;fIRK\b/\u001a\t\u00047\u00065\u0014bAA89\n!A+\u001f9f\u0011\u001d\t\u0019h\u0005a\u0001\u0003\u001b\t!\u0002]1sK:$h*Y7f\u0003u\u0001\u0016M]9vKR$vn\u00159be.\u001c6\r[3nC\u000e{gN^3si\u0016\u0014\bC\u0001\u001e\u0016'\t)2\u0006\u0006\u0002\u0002x\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE*\"!!!+\u0005Iz\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$He\r")
public class ParquetToSparkSchemaConverter {
    private final boolean assumeBinaryIsString;
    private final boolean assumeInt96IsTimestamp;
    private final boolean caseSensitive;

    public static boolean $lessinit$greater$default$3() {
        return ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$3();
    }

    public static boolean $lessinit$greater$default$2() {
        return ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$2();
    }

    public static boolean $lessinit$greater$default$1() {
        return ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$1();
    }

    public StructType convert(MessageType parquetSchema) {
        MessageColumnIO column = new ColumnIOFactory().getColumnIO(parquetSchema);
        ParquetColumn converted = this.convertInternal((GroupColumnIO)column, this.convertInternal$default$2());
        return (StructType)converted.sparkType();
    }

    public ParquetColumn convertParquetColumn(MessageType parquetSchema, Option<StructType> sparkReadSchema) {
        MessageColumnIO column = new ColumnIOFactory().getColumnIO(parquetSchema);
        return this.convertInternal((GroupColumnIO)column, sparkReadSchema);
    }

    public Option<StructType> convertParquetColumn$default$2() {
        return None$.MODULE$;
    }

    private ParquetColumn convertInternal(GroupColumnIO groupColumn, Option<StructType> sparkReadSchema) {
        Option schemaMapOpt = sparkReadSchema.map((Function1 & Serializable & scala.Serializable)schema -> ((TraversableOnce)schema.map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.normalizeFieldName(f.name())), f), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        IndexedSeq converted = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), groupColumn.getChildrenCount()).map((Function1 & Serializable & scala.Serializable)i -> ParquetToSparkSchemaConverter.$anonfun$convertInternal$3(this, groupColumn, schemaMapOpt, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        return ParquetColumn$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)converted.map((Function1 & Serializable & scala.Serializable)x$3 -> (StructField)x$3._1(), IndexedSeq$.MODULE$.canBuildFrom())), groupColumn, (Seq<ParquetColumn>)((Seq)converted.map((Function1 & Serializable & scala.Serializable)x$4 -> (ParquetColumn)x$4._2(), IndexedSeq$.MODULE$.canBuildFrom())));
    }

    private Option<StructType> convertInternal$default$2() {
        return None$.MODULE$;
    }

    private String normalizeFieldName(String name) {
        return this.caseSensitive ? name : name.toLowerCase(Locale.ROOT);
    }

    public ParquetColumn convertField(ColumnIO field, Option<DataType> sparkReadType) {
        ParquetColumn parquetColumn;
        ColumnIO columnIO = field;
        if (columnIO instanceof PrimitiveColumnIO) {
            PrimitiveColumnIO primitiveColumnIO = (PrimitiveColumnIO)columnIO;
            parquetColumn = this.convertPrimitiveField(primitiveColumnIO, sparkReadType);
        } else if (columnIO instanceof GroupColumnIO) {
            GroupColumnIO groupColumnIO = (GroupColumnIO)columnIO;
            parquetColumn = this.convertGroupField(groupColumnIO, sparkReadType);
        } else {
            throw new MatchError((Object)columnIO);
        }
        return parquetColumn;
    }

    public Option<DataType> convertField$default$2() {
        return None$.MODULE$;
    }

    private ParquetColumn convertPrimitiveField(PrimitiveColumnIO primitiveColumn, Option<DataType> sparkReadType) {
        PrimitiveType parquetType = primitiveColumn.getType().asPrimitiveType();
        LogicalTypeAnnotation typeAnnotation = primitiveColumn.getType().getLogicalTypeAnnotation();
        PrimitiveType.PrimitiveTypeName typeName = primitiveColumn.getPrimitive();
        DataType sparkType = (DataType)sparkReadType.getOrElse(() -> ParquetToSparkSchemaConverter.$anonfun$convertPrimitiveField$2(this, typeName, typeAnnotation, parquetType));
        return ParquetColumn$.MODULE$.apply(sparkType, primitiveColumn);
    }

    private Option<DataType> convertPrimitiveField$default$2() {
        return None$.MODULE$;
    }

    private ParquetColumn convertGroupField(GroupColumnIO groupColumn, Option<DataType> sparkReadType) {
        GroupType field = groupColumn.getType().asGroupType();
        return (ParquetColumn)Option$.MODULE$.apply((Object)field.getLogicalTypeAnnotation()).fold((Function0 & Serializable & scala.Serializable)() -> this.convertInternal(groupColumn, (Option<StructType>)sparkReadType.map((Function1 & Serializable & scala.Serializable)x$5 -> (StructType)x$5)), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            ParquetColumn parquetColumn;
            LogicalTypeAnnotation logicalTypeAnnotation = x0$1;
            if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.ListLogicalTypeAnnotation) {
                ParquetColumn parquetColumn2;
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> field.getFieldCount() == 1, new StringBuilder(18).append("Invalid list type ").append(field).toString());
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> sparkReadType.forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ParquetToSparkSchemaConverter.$anonfun$convertGroupField$6(x$6))), new StringBuilder(61).append("Invalid Spark read type: expected ").append(field).append(" to be list type but found ").append(sparkReadType).toString());
                ColumnIO repeated = groupColumn.getChild(0);
                Type repeatedType = repeated.getType();
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> repeatedType.isRepetition(Type.Repetition.REPEATED), new StringBuilder(18).append("Invalid list type ").append(field).toString());
                Option sparkReadElementType = sparkReadType.map((Function1 & Serializable & scala.Serializable)x$7 -> ((ArrayType)x$7).elementType());
                if (this.isElementType(repeatedType, field.getName())) {
                    ObjectRef converted = ObjectRef.create((Object)this.convertField(repeated, (Option<DataType>)sparkReadElementType));
                    DataType convertedType = (DataType)sparkReadElementType.getOrElse((Function0 & Serializable & scala.Serializable)() -> ((ParquetColumn)converted$1.elem).sparkType());
                    if (repeatedType.isPrimitive()) {
                        ParquetColumn qual$1 = (ParquetColumn)converted.elem;
                        boolean x$1 = true;
                        DataType x$2 = qual$1.copy$default$1();
                        Option<ColumnDescriptor> x$3 = qual$1.copy$default$2();
                        int x$4 = qual$1.copy$default$3();
                        int x$5 = qual$1.copy$default$4();
                        Seq<String> x$6 = qual$1.copy$default$6();
                        Seq<ParquetColumn> x$72 = qual$1.copy$default$7();
                        converted.elem = qual$1.copy(x$2, x$3, x$4, x$5, x$1, x$6, x$72);
                    }
                    parquetColumn2 = ParquetColumn$.MODULE$.apply((DataType)new ArrayType(convertedType, false), groupColumn, (Seq<ParquetColumn>)((Seq)new .colon.colon((Object)((ParquetColumn)converted.elem), (List)Nil$.MODULE$)));
                } else {
                    ColumnIO element = ((GroupColumnIO)repeated).getChild(0);
                    ParquetColumn converted = this.convertField(element, (Option<DataType>)sparkReadElementType);
                    DataType convertedType = (DataType)sparkReadElementType.getOrElse((Function0 & Serializable & scala.Serializable)() -> converted.sparkType());
                    boolean optional = element.getType().isRepetition(Type.Repetition.OPTIONAL);
                    parquetColumn2 = ParquetColumn$.MODULE$.apply((DataType)new ArrayType(convertedType, optional), groupColumn, (Seq<ParquetColumn>)((Seq)new .colon.colon((Object)converted, (List)Nil$.MODULE$)));
                }
                parquetColumn = parquetColumn2;
            } else {
                boolean bl = logicalTypeAnnotation instanceof LogicalTypeAnnotation.MapLogicalTypeAnnotation ? true : logicalTypeAnnotation instanceof LogicalTypeAnnotation.MapKeyValueTypeAnnotation;
                if (bl) {
                    ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> field.getFieldCount() == 1 && !field.getType(0).isPrimitive(), new StringBuilder(18).append("Invalid map type: ").append(field).toString());
                    ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> sparkReadType.forall((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ParquetToSparkSchemaConverter.$anonfun$convertGroupField$13(x$8))), new StringBuilder(60).append("Invalid Spark read type: expected ").append(field).append(" to be map type but found ").append(sparkReadType).toString());
                    GroupColumnIO keyValue = (GroupColumnIO)groupColumn.getChild(0);
                    GroupType keyValueType = keyValue.getType().asGroupType();
                    ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> keyValueType.isRepetition(Type.Repetition.REPEATED) && keyValueType.getFieldCount() == 2, new StringBuilder(18).append("Invalid map type: ").append(field).toString());
                    ColumnIO key = keyValue.getChild(0);
                    ColumnIO value = keyValue.getChild(1);
                    Option sparkReadKeyType = sparkReadType.map((Function1 & Serializable & scala.Serializable)x$9 -> ((MapType)x$9).keyType());
                    Option sparkReadValueType = sparkReadType.map((Function1 & Serializable & scala.Serializable)x$10 -> ((MapType)x$10).valueType());
                    ParquetColumn convertedKey = this.convertField(key, (Option<DataType>)sparkReadKeyType);
                    ParquetColumn convertedValue = this.convertField(value, (Option<DataType>)sparkReadValueType);
                    DataType convertedKeyType = (DataType)sparkReadKeyType.getOrElse((Function0 & Serializable & scala.Serializable)() -> convertedKey.sparkType());
                    DataType convertedValueType = (DataType)sparkReadValueType.getOrElse((Function0 & Serializable & scala.Serializable)() -> convertedValue.sparkType());
                    boolean valueOptional = value.getType().isRepetition(Type.Repetition.OPTIONAL);
                    parquetColumn = ParquetColumn$.MODULE$.apply((DataType)new MapType(convertedKeyType, convertedValueType, valueOptional), groupColumn, (Seq<ParquetColumn>)((Seq)new .colon.colon((Object)convertedKey, (List)new .colon.colon((Object)convertedValue, (List)Nil$.MODULE$))));
                } else {
                    throw QueryCompilationErrors$.MODULE$.unrecognizedParquetTypeError(field.toString());
                }
            }
            return parquetColumn;
        });
    }

    private Option<DataType> convertGroupField$default$2() {
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isElementType(Type repeatedType, String parentName) {
        if (repeatedType.isPrimitive()) return true;
        if (repeatedType.asGroupType().getFieldCount() > 1) return true;
        String string = repeatedType.getName();
        String string2 = "array";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = repeatedType.getName();
        String string4 = new StringBuilder(6).append(parentName).append("_tuple").toString();
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public static final /* synthetic */ Tuple2 $anonfun$convertInternal$3(ParquetToSparkSchemaConverter $this, GroupColumnIO groupColumn$1, Option schemaMapOpt$1, int i) {
        Tuple2 tuple2;
        ColumnIO field = groupColumn$1.getChild(i);
        Option fieldFromReadSchema = schemaMapOpt$1.flatMap((Function1 & Serializable & scala.Serializable)schemaMap -> schemaMap.get((Object)$this.normalizeFieldName(field.getName())));
        Option fieldReadType = fieldFromReadSchema.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.dataType());
        Type.Repetition repetition = field.getType().getRepetition();
        Type.Repetition repetition2 = Type.Repetition.REPEATED;
        if (!(repetition != null ? !repetition.equals(repetition2) : repetition2 != null)) {
            fieldReadType = fieldReadType.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DataType dataType = x0$1;
                if (!(dataType instanceof ArrayType)) {
                    throw QueryCompilationErrors$.MODULE$.illegalParquetTypeError(groupColumn$1.toString());
                }
                ArrayType arrayType = (ArrayType)dataType;
                Some some = new Some((Object)arrayType.elementType());
                return some;
            });
        }
        ParquetColumn convertedField = $this.convertField(field, (Option<DataType>)fieldReadType);
        String fieldName = (String)fieldFromReadSchema.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name()).getOrElse((Function0 & Serializable & scala.Serializable)() -> field.getType().getName());
        Type.Repetition repetition3 = field.getType().getRepetition();
        boolean bl = Type.Repetition.OPTIONAL.equals(repetition3) ? true : Type.Repetition.REQUIRED.equals(repetition3);
        if (bl) {
            Type.Repetition repetition4 = field.getType().getRepetition();
            Type.Repetition repetition5 = Type.Repetition.OPTIONAL;
            boolean nullable = !(repetition4 != null ? !repetition4.equals(repetition5) : repetition5 != null);
            tuple2 = new Tuple2((Object)new StructField(fieldName, convertedField.sparkType(), nullable, StructField$.MODULE$.apply$default$4()), (Object)convertedField);
        } else if (Type.Repetition.REPEATED.equals(repetition3)) {
            ArrayType arrayType = new ArrayType(convertedField.sparkType(), false);
            boolean x$12 = true;
            DataType x$22 = convertedField.copy$default$1();
            Option<ColumnDescriptor> x$3 = convertedField.copy$default$2();
            int x$4 = convertedField.copy$default$3();
            int x$5 = convertedField.copy$default$4();
            Seq<String> x$6 = convertedField.copy$default$6();
            Seq<ParquetColumn> x$7 = convertedField.copy$default$7();
            tuple2 = new Tuple2((Object)new StructField(fieldName, (DataType)arrayType, false, StructField$.MODULE$.apply$default$4()), (Object)new ParquetColumn((DataType)arrayType, (Option<ColumnDescriptor>)None$.MODULE$, convertedField.repetitionLevel() - 1, convertedField.definitionLevel() - 1, true, convertedField.path(), (Seq<ParquetColumn>)((Seq)new .colon.colon((Object)convertedField.copy(x$22, x$3, x$4, x$5, x$12, x$6, x$7), (List)Nil$.MODULE$))));
        } else {
            throw new MatchError((Object)repetition3);
        }
        return tuple2;
    }

    private static final String typeString$1(LogicalTypeAnnotation typeAnnotation$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        return typeAnnotation$1 == null ? String.valueOf(typeName$1) : new StringBuilder(3).append(typeName$1).append(" (").append(typeAnnotation$1).append(")").toString();
    }

    private static final Nothing$ typeNotImplemented$1(LogicalTypeAnnotation typeAnnotation$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        throw QueryCompilationErrors$.MODULE$.parquetTypeUnsupportedYetError(ParquetToSparkSchemaConverter.typeString$1(typeAnnotation$1, typeName$1));
    }

    private static final Nothing$ illegalType$1(LogicalTypeAnnotation typeAnnotation$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        throw QueryCompilationErrors$.MODULE$.illegalParquetTypeError(ParquetToSparkSchemaConverter.typeString$1(typeAnnotation$1, typeName$1));
    }

    private static final DecimalType makeDecimalType$1(int maxPrecision, LogicalTypeAnnotation typeAnnotation$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalTypeAnnotation = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)typeAnnotation$1;
        int precision = decimalLogicalTypeAnnotation.getPrecision();
        int scale = decimalLogicalTypeAnnotation.getScale();
        ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> maxPrecision == -1 || 1 <= precision && precision <= maxPrecision, new StringBuilder(55).append("Invalid decimal precision: ").append(typeName$1).append(" cannot store ").append(precision).append(" digits (max ").append(maxPrecision).append(")").toString());
        return new DecimalType(precision, scale);
    }

    private static final int makeDecimalType$default$1$1() {
        return -1;
    }

    public static final /* synthetic */ boolean $anonfun$convertPrimitiveField$3(ParquetToSparkSchemaConverter $this) {
        return $this.assumeInt96IsTimestamp;
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ AtomicType $anonfun$convertPrimitiveField$2(ParquetToSparkSchemaConverter $this, PrimitiveType.PrimitiveTypeName typeName$1, LogicalTypeAnnotation typeAnnotation$1, PrimitiveType parquetType$1) {
        block50: {
            block49: {
                var10_4 = typeName$1;
                if (PrimitiveType.PrimitiveTypeName.BOOLEAN.equals(var10_4)) {
                    return BooleanType$.MODULE$;
                }
                if (PrimitiveType.PrimitiveTypeName.FLOAT.equals(var10_4)) {
                    return FloatType$.MODULE$;
                }
                if (PrimitiveType.PrimitiveTypeName.DOUBLE.equals(var10_4)) {
                    return DoubleType$.MODULE$;
                }
                if (!PrimitiveType.PrimitiveTypeName.INT32.equals(var10_4)) break block49;
                var11_6 = false;
                var12_7 = null;
                var13_8 = typeAnnotation$1;
                if (!(var13_8 instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation)) ** GOTO lbl-1000
                var11_6 = true;
                var12_7 = (LogicalTypeAnnotation.IntLogicalTypeAnnotation)var13_8;
                if (var12_7.isSigned()) {
                    var14_9 = var12_7.getBitWidth();
                    switch (var14_9) {
                        case 8: {
                            v0 = ByteType$.MODULE$;
                            break;
                        }
                        case 16: {
                            v0 = ShortType$.MODULE$;
                            break;
                        }
                        case 32: {
                            v0 = IntegerType$.MODULE$;
                            break;
                        }
                        default: {
                            throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation$1, typeName$1);
                        }
                    }
                    var9_10 = v0;
                    return var9_10;
                } else if (var13_8 == null) {
                    var9_10 = IntegerType$.MODULE$;
                    return var9_10;
                } else if (var13_8 instanceof LogicalTypeAnnotation.DateLogicalTypeAnnotation) {
                    var9_10 = DateType$.MODULE$;
                    return var9_10;
                } else if (var13_8 instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                    var9_10 = ParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.MAX_INT_DIGITS(), typeAnnotation$1, typeName$1);
                    return var9_10;
                } else if (var11_6 && !var12_7.isSigned()) {
                    var15_11 = var12_7.getBitWidth();
                    switch (var15_11) {
                        case 8: {
                            v1 = ShortType$.MODULE$;
                            break;
                        }
                        case 16: {
                            v1 = IntegerType$.MODULE$;
                            break;
                        }
                        case 32: {
                            v1 = LongType$.MODULE$;
                            break;
                        }
                        default: {
                            throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation$1, typeName$1);
                        }
                    }
                    var9_10 = v1;
                    return var9_10;
                } else {
                    if (var13_8 instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation == false) throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation$1, typeName$1);
                    var16_12 = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)var13_8;
                    v2 = var16_12.getUnit();
                    var17_13 = LogicalTypeAnnotation.TimeUnit.MILLIS;
                    if (v2 != null) {
                        if (v2.equals(var17_13) == false) throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation$1, typeName$1);
                        throw ParquetToSparkSchemaConverter.typeNotImplemented$1(typeAnnotation$1, typeName$1);
                    }
                    if (var17_13 == null) throw ParquetToSparkSchemaConverter.typeNotImplemented$1(typeAnnotation$1, typeName$1);
                    throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation$1, typeName$1);
                }
            }
            if (PrimitiveType.PrimitiveTypeName.INT64.equals(var10_4)) {
                var18_14 = false;
                var19_15 = null;
                var20_16 = typeAnnotation$1;
                if (var20_16 instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation) {
                    var18_14 = true;
                    var19_15 = (LogicalTypeAnnotation.IntLogicalTypeAnnotation)var20_16;
                    if (var19_15.isSigned()) {
                        var21_17 = var19_15.getBitWidth();
                        switch (var21_17) {
                            case 64: {
                                break;
                            }
                            default: {
                                throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation$1, typeName$1);
                            }
                        }
                        var8_18 = LongType$.MODULE$;
                        return var8_18;
                    }
                }
                if (var20_16 == null) {
                    var8_18 = LongType$.MODULE$;
                    return var8_18;
                }
                if (var20_16 instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                    var8_18 = ParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.MAX_LONG_DIGITS(), typeAnnotation$1, typeName$1);
                    return var8_18;
                }
                if (var18_14 && !var19_15.isSigned()) {
                    var22_19 = var19_15.getBitWidth();
                    switch (var22_19) {
                        case 64: {
                            ** break;
                        }
                        default: {
                            throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation$1, typeName$1);
                        }
lbl-1000:
                        // 1 sources

                        {
                            var8_18 = new DecimalType(20, 0);
                        }
                    }
                    return var8_18;
                }
                if (var20_16 instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation == false) throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation$1, typeName$1);
                var23_20 = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)var20_16;
                v3 = var23_20.getUnit();
                var24_21 = LogicalTypeAnnotation.TimeUnit.MICROS;
                if (v3 == null ? var24_21 != null : v3.equals(var24_21) == false) {
                    v4 = var23_20.getUnit();
                    var25_22 = LogicalTypeAnnotation.TimeUnit.MILLIS;
                    if (v4 == null) {
                        if (var25_22 != null) {
                            throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation$1, typeName$1);
                        }
                    } else if (v4.equals(var25_22) == false) throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation$1, typeName$1);
                }
                var8_18 = var23_20.isAdjustedToUTC() != false ? TimestampType$.MODULE$ : (Utils$.MODULE$.isTesting() != false ? TimestampNTZType$.MODULE$ : TimestampType$.MODULE$);
                return var8_18;
            }
            if (PrimitiveType.PrimitiveTypeName.INT96.equals(var10_4)) {
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Z, $anonfun$convertPrimitiveField$3(org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter ), ()Z)((ParquetToSparkSchemaConverter)$this), new StringBuilder(88).append("INT96 is not supported unless it's interpreted as timestamp. ").append("Please try to set ").append(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key()).append(" to true.").toString());
                return TimestampType$.MODULE$;
            }
            if (!PrimitiveType.PrimitiveTypeName.BINARY.equals(var10_4)) break block50;
            var26_23 = false;
            var27_24 = null;
            var28_25 = typeAnnotation$1;
            var7_26 = var28_25 instanceof LogicalTypeAnnotation.StringLogicalTypeAnnotation != false ? true : (var28_25 instanceof LogicalTypeAnnotation.EnumLogicalTypeAnnotation != false ? true : var28_25 instanceof LogicalTypeAnnotation.JsonLogicalTypeAnnotation != false);
            if (var7_26) {
                var6_27 = StringType$.MODULE$;
                return var6_27;
            }
            if (var28_25 != null) ** GOTO lbl-1000
            var26_23 = true;
            var27_24 = var28_25;
            if ($this.assumeBinaryIsString) {
                var6_27 = StringType$.MODULE$;
                return var6_27;
            } else if (var26_23) {
                var6_27 = BinaryType$.MODULE$;
                return var6_27;
            } else if (var28_25 instanceof LogicalTypeAnnotation.BsonLogicalTypeAnnotation) {
                var6_27 = BinaryType$.MODULE$;
                return var6_27;
            } else {
                if (var28_25 instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation == false) throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation$1, typeName$1);
                var6_27 = ParquetToSparkSchemaConverter.makeDecimalType$1(ParquetToSparkSchemaConverter.makeDecimalType$default$1$1(), typeAnnotation$1, typeName$1);
            }
            return var6_27;
        }
        if (PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY.equals(var10_4) == false) throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation$1, typeName$1);
        var29_28 = typeAnnotation$1;
        if (!(var29_28 instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)) {
            if (var29_28 instanceof LogicalTypeAnnotation.IntervalLogicalTypeAnnotation == false) throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation$1, typeName$1);
            throw ParquetToSparkSchemaConverter.typeNotImplemented$1(typeAnnotation$1, typeName$1);
        }
        var5_29 = ParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.maxPrecisionForBytes(parquetType$1.getTypeLength()), typeAnnotation$1, typeName$1);
        return var5_29;
    }

    public static final /* synthetic */ boolean $anonfun$convertGroupField$6(DataType x$6) {
        return x$6 instanceof ArrayType;
    }

    public static final /* synthetic */ boolean $anonfun$convertGroupField$13(DataType x$8) {
        return x$8 instanceof MapType;
    }

    public ParquetToSparkSchemaConverter(boolean assumeBinaryIsString, boolean assumeInt96IsTimestamp, boolean caseSensitive) {
        this.assumeBinaryIsString = assumeBinaryIsString;
        this.assumeInt96IsTimestamp = assumeInt96IsTimestamp;
        this.caseSensitive = caseSensitive;
    }

    public ParquetToSparkSchemaConverter(SQLConf conf) {
        this(conf.isParquetBinaryAsString(), conf.isParquetINT96AsTimestamp(), conf.caseSensitiveAnalysis());
    }

    public ParquetToSparkSchemaConverter(Configuration conf) {
        this(new StringOps(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key()))).toBoolean(), new StringOps(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key()))).toBoolean(), new StringOps(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.CASE_SENSITIVE().key()))).toBoolean());
    }
}

