/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import java.io.Serializable;
import java.util.Locale;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.fs.Path;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.api.java.function.VoidFunction2;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.ForeachWriter;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.UnresolvedDBObjectName;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.CreateTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.TableSpec;
import org.apache.spark.sql.catalyst.streaming.InternalOutputModes$;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.connector.catalog.V1Table;
import org.apache.spark.sql.connector.catalog.V2TableWithV1Fallback;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Implicits$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Utils$;
import org.apache.spark.sql.execution.datasources.v2.FileDataSourceV2;
import org.apache.spark.sql.execution.streaming.ContinuousTrigger;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.execution.streaming.sources.ForeachBatchSink;
import org.apache.spark.sql.execution.streaming.sources.ForeachWriterTable;
import org.apache.spark.sql.execution.streaming.sources.ForeachWriterTable$;
import org.apache.spark.sql.execution.streaming.sources.MemoryPlan;
import org.apache.spark.sql.execution.streaming.sources.MemorySink;
import org.apache.spark.sql.streaming.DataStreamWriter$;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.util.Clock;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Evolving
@ScalaSignature(bytes="\u0006\u0001\r%e\u0001\u0002%J\u0005QC\u0001\u0002\u0018\u0001\u0003\u0002\u0003\u0006I!\u0018\u0005\u0007Y\u0002!\taS7\t\u000fE\u0004!\u0019!C\u0005e\"1!\u0010\u0001Q\u0001\nMDQa\u001f\u0001\u0005\u0002qDaa\u001f\u0001\u0005\u0002\u0005\r\u0001bBA\u000f\u0001\u0011\u0005\u0011q\u0004\u0005\b\u0003S\u0001A\u0011AA\u0016\u0011\u001d\ty\u0003\u0001C\u0001\u0003cAq!a\u000e\u0001\t\u0003\tI\u0004C\u0004\u0002T\u0001!\t!!\u0016\t\u000f\u0005M\u0003\u0001\"\u0001\u0002`!9\u00111\u000b\u0001\u0005\u0002\u0005-\u0004bBA*\u0001\u0011\u0005\u0011q\u000f\u0005\b\u0003\u0007\u0003A\u0011AAC\u0011\u001d\t\u0019\t\u0001C\u0001\u0003+Cq!a*\u0001\t\u0003\tI\u000bC\u0004\u0002(\u0002!\t!!.\t\u000f\u0005]\b\u0001\"\u0001\u0002z\"9!q\u0003\u0001\u0005\n\te\u0001b\u0002B\u0012\u0001\u0011%!Q\u0005\u0005\n\u0005S\u0002\u0011\u0013!C\u0005\u0005WB\u0011B! \u0001#\u0003%IAa \t\u000f\t\r\u0005\u0001\"\u0003\u0003\u0006\"9!\u0011\u0014\u0001\u0005\u0002\tm\u0005b\u0002BT\u0001\u0011\u0005!\u0011\u0016\u0005\b\u0005O\u0003A\u0011\u0001B_\u0011\u001d\u0011i\u000e\u0001C\u0005\u0005?DqAa<\u0001\t\u0013\u0011\t\u0010C\u0004\u0003|\u0002!IA!@\t\u0013\u0005U\u0002\u00011A\u0005\n\u0005E\u0007\"CB\u0002\u0001\u0001\u0007I\u0011BB\u0003\u0011!\u0019Y\u0001\u0001Q!\n\u0005\u001d\u0001\"CA\u007f\u0001\u0001\u0007I\u0011BAi\u0011%\u0019i\u0001\u0001a\u0001\n\u0013\u0019y\u0001\u0003\u0005\u0004\u0014\u0001\u0001\u000b\u0015BA\u0004\u0011!Y\b\u00011A\u0005\n\rU\u0001\"CB\f\u0001\u0001\u0007I\u0011BB\r\u0011\u001d\u0019i\u0002\u0001Q!\nyD\u0011\"!\b\u0001\u0001\u0004%Iaa\b\t\u0013\r\u0005\u0002\u00011A\u0005\n\r\r\u0002\u0002CB\u0014\u0001\u0001\u0006K!a\t\t\u0013\r%\u0002\u00011A\u0005\n\r-\u0002\"CB\u0017\u0001\u0001\u0007I\u0011BB\u0018\u0011!\u0019\u0019\u0004\u0001Q!\n\t}\u0002\"CB\u001b\u0001\u0001\u0007I\u0011BB\u001c\u0011%\u0019I\u0004\u0001a\u0001\n\u0013\u0019Y\u0004\u0003\u0005\u0004@\u0001\u0001\u000b\u0015\u0002BQ\u0011%\u0019\t\u0005\u0001a\u0001\n\u0013\u0019\u0019\u0005C\u0005\u0004F\u0001\u0001\r\u0011\"\u0003\u0004H!A11\n\u0001!B\u0013\u0011y\u000bC\u0005\u0004N\u0001\u0001\r\u0011\"\u0003\u0003`\"I1q\n\u0001A\u0002\u0013%1\u0011\u000b\u0005\t\u0007+\u0002\u0001\u0015)\u0003\u0003b\u001e91\u0011L%\t\u0002\rmcA\u0002%J\u0011\u0003\u0019i\u0006\u0003\u0004mq\u0011\u00051q\f\u0005\n\u0007CB$\u0019!C\u0001\u0007GB\u0001b!\u001b9A\u0003%1Q\r\u0005\n\u0007WB$\u0019!C\u0001\u0007GB\u0001b!\u001c9A\u0003%1Q\r\u0005\n\u0007_B$\u0019!C\u0001\u0007GB\u0001b!\u001d9A\u0003%1Q\r\u0005\n\u0007gB$\u0019!C\u0001\u0007GB\u0001b!\u001e9A\u0003%1Q\r\u0005\n\u0007oB$\u0019!C\u0001\u0007GB\u0001b!\u001f9A\u0003%1Q\r\u0005\n\u0007wB$\u0019!C\u0001\u0007GB\u0001b! 9A\u0003%1Q\r\u0005\n\u0007\u007fB$\u0019!C\u0001\u0007\u0003C\u0001ba\"9A\u0003%11\u0011\u0002\u0011\t\u0006$\u0018m\u0015;sK\u0006lwK]5uKJT!AS&\u0002\u0013M$(/Z1nS:<'B\u0001'N\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u001d>\u000bQa\u001d9be.T!\u0001U)\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0016aA8sO\u000e\u0001QCA+d'\t\u0001a\u000b\u0005\u0002X56\t\u0001LC\u0001Z\u0003\u0015\u00198-\u00197b\u0013\tY\u0006L\u0001\u0004B]f\u0014VMZ\u0001\u0003IN\u00042AX0b\u001b\u0005Y\u0015B\u00011L\u0005\u001d!\u0015\r^1tKR\u0004\"AY2\r\u0001\u0011)A\r\u0001b\u0001K\n\tA+\u0005\u0002gSB\u0011qkZ\u0005\u0003Qb\u0013qAT8uQ&tw\r\u0005\u0002XU&\u00111\u000e\u0017\u0002\u0004\u0003:L\u0018A\u0002\u001fj]&$h\b\u0006\u0002oaB\u0019q\u000eA1\u000e\u0003%CQ\u0001\u0018\u0002A\u0002u\u000b!\u0001\u001a4\u0016\u0003M\u0004\"\u0001^<\u000f\u0005y+\u0018B\u0001<L\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001_=\u0003\u0013\u0011\u000bG/\u0019$sC6,'B\u0001<L\u0003\r!g\rI\u0001\u000b_V$\b/\u001e;N_\u0012,GC\u00018~\u0011\u0015YX\u00011\u0001\u007f!\tyw0C\u0002\u0002\u0002%\u0013!bT;uaV$Xj\u001c3f)\rq\u0017Q\u0001\u0005\u0007w\u001a\u0001\r!a\u0002\u0011\t\u0005%\u0011q\u0003\b\u0005\u0003\u0017\t\u0019\u0002E\u0002\u0002\u000eak!!a\u0004\u000b\u0007\u0005E1+\u0001\u0004=e>|GOP\u0005\u0004\u0003+A\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0002\u001a\u0005m!AB*ue&twMC\u0002\u0002\u0016a\u000bq\u0001\u001e:jO\u001e,'\u000fF\u0002o\u0003CAq!!\b\b\u0001\u0004\t\u0019\u0003E\u0002p\u0003KI1!a\nJ\u0005\u001d!&/[4hKJ\f\u0011\"];feft\u0015-\\3\u0015\u00079\fi\u0003C\u0004\u0002*!\u0001\r!a\u0002\u0002\r\u0019|'/\\1u)\rq\u00171\u0007\u0005\b\u0003kI\u0001\u0019AA\u0004\u0003\u0019\u0019x.\u001e:dK\u0006Y\u0001/\u0019:uSRLwN\u001c\"z)\rq\u00171\b\u0005\b\u0003{Q\u0001\u0019AA \u0003!\u0019w\u000e\u001c(b[\u0016\u001c\b#B,\u0002B\u0005\u001d\u0011bAA\"1\nQAH]3qK\u0006$X\r\u001a )\u0007)\t9\u0005\u0005\u0003\u0002J\u0005=SBAA&\u0015\r\ti\u0005W\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA)\u0003\u0017\u0012qA^1sCJ<7/\u0001\u0004paRLwN\u001c\u000b\u0006]\u0006]\u00131\f\u0005\b\u00033Z\u0001\u0019AA\u0004\u0003\rYW-\u001f\u0005\b\u0003;Z\u0001\u0019AA\u0004\u0003\u00151\u0018\r\\;f)\u0015q\u0017\u0011MA2\u0011\u001d\tI\u0006\u0004a\u0001\u0003\u000fAq!!\u0018\r\u0001\u0004\t)\u0007E\u0002X\u0003OJ1!!\u001bY\u0005\u001d\u0011un\u001c7fC:$RA\\A7\u0003_Bq!!\u0017\u000e\u0001\u0004\t9\u0001C\u0004\u0002^5\u0001\r!!\u001d\u0011\u0007]\u000b\u0019(C\u0002\u0002va\u0013A\u0001T8oOR)a.!\u001f\u0002|!9\u0011\u0011\f\bA\u0002\u0005\u001d\u0001bBA/\u001d\u0001\u0007\u0011Q\u0010\t\u0004/\u0006}\u0014bAAA1\n1Ai\\;cY\u0016\fqa\u001c9uS>t7\u000fF\u0002o\u0003\u000fCq!a!\u0010\u0001\u0004\tI\t\u0005\u0005\u0002\f\u0006E\u0015qAA\u0004\u001b\t\tiIC\u0002\u0002\u0010b\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019*!$\u0003\u00075\u000b\u0007\u000fF\u0002o\u0003/Cq!a!\u0011\u0001\u0004\tI\n\u0005\u0005\u0002\u001c\u0006\u0015\u0016qAA\u0004\u001b\t\tiJ\u0003\u0003\u0002 \u0006\u0005\u0016\u0001B;uS2T!!a)\u0002\t)\fg/Y\u0005\u0005\u0003'\u000bi*A\u0003ti\u0006\u0014H\u000f\u0006\u0003\u0002,\u0006E\u0006cA8\u0002.&\u0019\u0011qV%\u0003\u001dM#(/Z1nS:<\u0017+^3ss\"9\u00111W\tA\u0002\u0005\u001d\u0011\u0001\u00029bi\"$\"!a+)\u000bI\tI,a3\u0011\u000b]\u000bY,a0\n\u0007\u0005u\u0006L\u0001\u0004uQJ|wo\u001d\t\u0005\u0003\u0003\f9-\u0004\u0002\u0002D*!\u0011QYAO\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003\u0013\f\u0019M\u0001\tUS6,w.\u001e;Fq\u000e,\u0007\u000f^5p]F:a$a\u0002\u0002N\u0006U\u0018'C\u0012\u0002P\u0006U\u00171^Al+\u0011\t\t.a5\u0016\u0005\u0005\u001dAA\u00023T\u0005\u0004\ti.\u0003\u0003\u0002X\u0006e\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013GC\u0002\u0002\\b\u000ba\u0001\u001e5s_^\u001c\u0018c\u00014\u0002`B!\u0011\u0011]As\u001d\r9\u00161]\u0005\u0003mbKA!a:\u0002j\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0003mb\u000b\u0014bIAw\u0003_\f\t0a7\u000f\u0007]\u000by/C\u0002\u0002\\b\u000bTAI,Y\u0003g\u0014Qa]2bY\u0006\f4AJA`\u0003\u001d!x\u000eV1cY\u0016$B!a+\u0002|\"9\u0011Q`\nA\u0002\u0005\u001d\u0011!\u0003;bE2,g*Y7fQ\u0015\u0019\u0012\u0011\u0018B\u0001c\u001dq\u0012q\u0001B\u0002\u0005\u0013\t\u0014bIAh\u0003+\u0014)!a62\u0013\r\ni/a<\u0003\b\u0005m\u0017'\u0002\u0012X1\u0006M\u0018g\u0001\u0014\u0002@\"\u001a1C!\u0004\u0011\t\t=!1C\u0007\u0003\u0005#Q1!!\u0014N\u0013\u0011\u0011)B!\u0005\u0003\u0011\u00153x\u000e\u001c<j]\u001e\fQb\u001d;beRLe\u000e^3s]\u0006dG\u0003BAV\u00057Aq!a-\u0015\u0001\u0004\u0011i\u0002E\u0003X\u0005?\t9!C\u0002\u0003\"a\u0013aa\u00149uS>t\u0017AC:uCJ$\u0018+^3ssRQ\u00111\u0016B\u0014\u0005w\u0011iE!\u0015\t\u000f\t%R\u00031\u0001\u0003,\u0005!1/\u001b8l!\u0011\u0011iCa\u000e\u000e\u0005\t=\"\u0002\u0002B\u0019\u0005g\tqaY1uC2|wMC\u0002\u00036-\u000b\u0011bY8o]\u0016\u001cGo\u001c:\n\t\te\"q\u0006\u0002\u0006)\u0006\u0014G.\u001a\u0005\b\u0005{)\u0002\u0019\u0001B \u0003)qWm^(qi&|gn\u001d\t\u0007\u0005\u0003\u0012I%a\u0002\u000e\u0005\t\r#\u0002BAP\u0005\u000bR1Aa\u0012L\u0003!\u0019\u0017\r^1msN$\u0018\u0002\u0002B&\u0005\u0007\u0012!cQ1tK&s7/\u001a8tSRLg/Z'ba\"I!qJ\u000b\u0011\u0002\u0003\u0007\u0011QM\u0001\u0016e\u0016\u001cwN^3s\rJ|Wn\u00115fG.\u0004x.\u001b8u\u0011%\u0011\u0019&\u0006I\u0001\u0002\u0004\u0011)&A\bdCR\fGn\\4B]\u0012LE-\u001a8u!\u00159&q\u0004B,!\u001d9&\u0011\fB/\u0005GJ1Aa\u0017Y\u0005\u0019!V\u000f\u001d7feA!!Q\u0006B0\u0013\u0011\u0011\tGa\f\u0003\u0019Q\u000b'\r\\3DCR\fGn\\4\u0011\t\t5\"QM\u0005\u0005\u0005O\u0012yC\u0001\u0006JI\u0016tG/\u001b4jKJ\fAc\u001d;beR\fV/\u001a:zI\u0011,g-Y;mi\u0012\u001aTC\u0001B7U\u0011\t)Ga\u001c,\u0005\tE\u0004\u0003\u0002B:\u0005sj!A!\u001e\u000b\t\t]\u00141J\u0001\nk:\u001c\u0007.Z2lK\u0012LAAa\u001f\u0003v\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002)M$\u0018M\u001d;Rk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011\tI\u000b\u0003\u0003V\t=\u0014\u0001D2sK\u0006$XMV\u0019TS:\\G\u0003\u0002BD\u0005+\u0003BA!#\u0003\u00126\u0011!1\u0012\u0006\u0004\u0015\n5%b\u0001BH\u0017\u0006IQ\r_3dkRLwN\\\u0005\u0005\u0005'\u0013YI\u0001\u0003TS:\\\u0007b\u0002BL1\u0001\u0007!qH\u0001\u0010_B$\u0018n\u001c8t/&$\b\u000eU1uQ\u00069am\u001c:fC\u000eDGc\u00018\u0003\u001e\"9!qT\rA\u0002\t\u0005\u0016AB<sSR,'\u000f\u0005\u0003_\u0005G\u000b\u0017b\u0001BS\u0017\niai\u001c:fC\u000eDwK]5uKJ\fABZ8sK\u0006\u001c\u0007NQ1uG\"$2A\u001cBV\u0011\u001d\u0011iK\u0007a\u0001\u0005_\u000b\u0001BZ;oGRLwN\u001c\t\t/\nEV,!\u001d\u00036&\u0019!1\u0017-\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004cA,\u00038&\u0019!\u0011\u0018-\u0003\tUs\u0017\u000e\u001e\u0015\u00045\t5Ac\u00018\u0003@\"9!QV\u000eA\u0002\t\u0005\u0007c\u0002Bb\u0005\u001bl&\u0011[\u0007\u0003\u0005\u000bTAA!,\u0003H*!\u00111\u0015Be\u0015\r\u0011Y-T\u0001\u0004CBL\u0017\u0002\u0002Bh\u0005\u000b\u0014QBV8jI\u001a+hn\u0019;j_:\u0014\u0004\u0003\u0002Bj\u00053l!A!6\u000b\t\t]\u0017\u0011U\u0001\u0005Y\u0006tw-\u0003\u0003\u0002v\tU\u0007fA\u000e\u0003\u000e\u0005\tbn\u001c:nC2L'0\u001a3QCJ\u001cu\u000e\\:\u0016\u0005\t\u0005\b#B,\u0003 \t\r\bC\u0002Bs\u0005W\f9A\u0004\u0003\u0003h\u0006\rh\u0002BA\u0007\u0005SL\u0011!W\u0005\u0005\u0005[\fIOA\u0002TKF\f\u0011B\\8s[\u0006d\u0017N_3\u0015\r\u0005\u001d!1\u001fB|\u0011\u001d\u0011)0\ba\u0001\u0003\u000f\t!bY8mk6tg*Y7f\u0011\u001d\u0011I0\ba\u0001\u0003\u000f\t!bY8mk6tG+\u001f9f\u0003Q\t7o]3si:{G\u000fU1si&$\u0018n\u001c8fIR!!Q\u0017B\u0000\u0011\u001d\u0019\tA\ba\u0001\u0003\u000f\t\u0011b\u001c9fe\u0006$\u0018n\u001c8\u0002\u0015M|WO]2f?\u0012*\u0017\u000f\u0006\u0003\u00036\u000e\u001d\u0001\"CB\u0005A\u0005\u0005\t\u0019AA\u0004\u0003\rAH%M\u0001\bg>,(oY3!\u00035!\u0018M\u00197f\u001d\u0006lWm\u0018\u0013fcR!!QWB\t\u0011%\u0019IaIA\u0001\u0002\u0004\t9!\u0001\u0006uC\ndWMT1nK\u0002*\u0012A`\u0001\u000f_V$\b/\u001e;N_\u0012,w\fJ3r)\u0011\u0011)la\u0007\t\u0011\r%a%!AA\u0002y\f1b\\;uaV$Xj\u001c3fAU\u0011\u00111E\u0001\fiJLwmZ3s?\u0012*\u0017\u000f\u0006\u0003\u00036\u000e\u0015\u0002\"CB\u0005S\u0005\u0005\t\u0019AA\u0012\u0003!!(/[4hKJ\u0004\u0013\u0001D3yiJ\fw\n\u001d;j_:\u001cXC\u0001B \u0003A)\u0007\u0010\u001e:b\u001fB$\u0018n\u001c8t?\u0012*\u0017\u000f\u0006\u0003\u00036\u000eE\u0002\"CB\u0005Y\u0005\u0005\t\u0019\u0001B \u00035)\u0007\u0010\u001e:b\u001fB$\u0018n\u001c8tA\u0005iam\u001c:fC\u000eDwK]5uKJ,\"A!)\u0002#\u0019|'/Z1dQ^\u0013\u0018\u000e^3s?\u0012*\u0017\u000f\u0006\u0003\u00036\u000eu\u0002\"CB\u0005_\u0005\u0005\t\u0019\u0001BQ\u000391wN]3bG\"<&/\u001b;fe\u0002\n!CZ8sK\u0006\u001c\u0007NQ1uG\"<&/\u001b;feV\u0011!qV\u0001\u0017M>\u0014X-Y2i\u0005\u0006$8\r[,sSR,'o\u0018\u0013fcR!!QWB%\u0011%\u0019IAMA\u0001\u0002\u0004\u0011y+A\ng_J,\u0017m\u00195CCR\u001c\u0007n\u0016:ji\u0016\u0014\b%A\nqCJ$\u0018\u000e^5p]&twmQ8mk6t7/A\fqCJ$\u0018\u000e^5p]&twmQ8mk6t7o\u0018\u0013fcR!!QWB*\u0011%\u0019I!NA\u0001\u0002\u0004\u0011\t/\u0001\u000bqCJ$\u0018\u000e^5p]&twmQ8mk6t7\u000f\t\u0015\u0004\u0001\t5\u0011\u0001\u0005#bi\u0006\u001cFO]3b[^\u0013\u0018\u000e^3s!\ty\u0007h\u0005\u00029-R\u001111L\u0001\u0013'>+&kQ#`\u001d\u0006kUiX'F\u001b>\u0013\u0016,\u0006\u0002\u0004fA!!1[B4\u0013\u0011\tIB!6\u0002'M{UKU\"F?:\u000bU*R0N\u000b6{%+\u0017\u0011\u0002'M{UKU\"F?:\u000bU*R0G\u001fJ+\u0015i\u0011%\u0002)M{UKU\"F?:\u000bU*R0G\u001fJ+\u0015i\u0011%!\u0003e\u0019v*\u0016*D\u000b~s\u0015)T#`\r>\u0013V)Q\"I?\n\u000bEk\u0011%\u00025M{UKU\"F?:\u000bU*R0G\u001fJ+\u0015i\u0011%`\u0005\u0006#6\t\u0013\u0011\u0002'M{UKU\"F?:\u000bU*R0D\u001f:\u001bv\nT#\u0002)M{UKU\"F?:\u000bU*R0D\u001f:\u001bv\nT#!\u0003E\u0019v*\u0016*D\u000b~s\u0015)T#`)\u0006\u0013E*R\u0001\u0013'>+&kQ#`\u001d\u0006kUi\u0018+B\u00052+\u0005%\u0001\tT\u001fV\u00136)R0O\u00036+uLT(P!\u0006\t2kT+S\u0007\u0016{f*Q'F?:{u\n\u0015\u0011\u00029M{UKU\"F'~\u000bE\nT(X?>sUi\u0018+J\u001b\u0016{\u0016+V#S3V\u001111\u0011\t\u0007\u0003\u0017\u001b)i!\u001a\n\t\t5\u0018QR\u0001\u001e'>+&kQ#T?\u0006cEjT,`\u001f:+u\fV%N\u000b~\u000bV+\u0012*ZA\u0001")
public final class DataStreamWriter<T> {
    private final Dataset<T> ds;
    private final Dataset<Row> df;
    private String source;
    private String tableName;
    private OutputMode outputMode;
    private Trigger trigger;
    private CaseInsensitiveMap<String> extraOptions;
    private ForeachWriter<T> foreachWriter;
    private Function2<Dataset<T>, Object, BoxedUnit> foreachBatchWriter;
    private Option<Seq<String>> partitioningColumns;

    public static Seq<String> SOURCES_ALLOW_ONE_TIME_QUERY() {
        return DataStreamWriter$.MODULE$.SOURCES_ALLOW_ONE_TIME_QUERY();
    }

    public static String SOURCE_NAME_NOOP() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_NOOP();
    }

    public static String SOURCE_NAME_TABLE() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_TABLE();
    }

    public static String SOURCE_NAME_CONSOLE() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_CONSOLE();
    }

    public static String SOURCE_NAME_FOREACH_BATCH() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH_BATCH();
    }

    public static String SOURCE_NAME_FOREACH() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH();
    }

    public static String SOURCE_NAME_MEMORY() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_MEMORY();
    }

    public DataStreamWriter<T> partitionBy(String ... colNames) {
        return this.partitionBy((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    private Dataset<Row> df() {
        return this.df;
    }

    public DataStreamWriter<T> outputMode(OutputMode outputMode) {
        this.outputMode_$eq(outputMode);
        return this;
    }

    public DataStreamWriter<T> outputMode(String outputMode) {
        this.outputMode_$eq(InternalOutputModes$.MODULE$.apply(outputMode));
        return this;
    }

    public DataStreamWriter<T> trigger(Trigger trigger) {
        this.trigger_$eq(trigger);
        return this;
    }

    public DataStreamWriter<T> queryName(String queryName) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"queryName"), (Object)queryName)));
        return this;
    }

    public DataStreamWriter<T> format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataStreamWriter<T> partitionBy(Seq<String> colNames) {
        this.partitioningColumns_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames));
        return this;
    }

    public DataStreamWriter<T> option(String key, String value) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value)));
        return this;
    }

    public DataStreamWriter<T> option(String key, boolean value) {
        return this.option(key, Boolean.toString(value));
    }

    public DataStreamWriter<T> option(String key, long value) {
        return this.option(key, Long.toString(value));
    }

    public DataStreamWriter<T> option(String key, double value) {
        return this.option(key, Double.toString(value));
    }

    public DataStreamWriter<T> options(Map<String, String> options) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus(options));
        return this;
    }

    public DataStreamWriter<T> options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()));
        return this;
    }

    public StreamingQuery start(String path) {
        if (!this.df().sparkSession().sessionState().conf().legacyPathOptionBehavior() && this.extraOptions().contains("path")) {
            throw QueryCompilationErrors$.MODULE$.setPathOptionAndCallWithPathParameterError("start");
        }
        return this.startInternal((Option<String>)new Some((Object)path));
    }

    public StreamingQuery start() throws TimeoutException {
        return this.startInternal((Option<String>)None$.MODULE$);
    }

    @Evolving
    public StreamingQuery toTable(String tableName) throws TimeoutException {
        StreamingQuery streamingQuery;
        SupportsWrite supportsWrite;
        Table tableInstance;
        Object object;
        Seq originalMultipartIdentifier;
        this.tableName_$eq(tableName);
        Seq seq = originalMultipartIdentifier = this.df().sparkSession().sessionState().sqlParser().parseMultipartIdentifier(tableName);
        Option option = this.df().sparkSession().sessionState().analyzer().CatalogAndIdentifier().unapply(seq);
        if (option.isEmpty()) {
            throw new MatchError((Object)seq);
        }
        CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option.get())._1();
        Identifier identifier = (Identifier)((Tuple2)option.get())._2();
        Tuple2 tuple2 = new Tuple2((Object)catalog, (Object)identifier);
        Tuple2 tuple22 = tuple2;
        CatalogPlugin catalog2 = (CatalogPlugin)tuple22._1();
        Identifier identifier2 = (Identifier)tuple22._2();
        if (this.df().sparkSession().sessionState().catalog().isTempView(originalMultipartIdentifier)) {
            throw QueryCompilationErrors$.MODULE$.tempViewNotSupportStreamingWriteError(tableName);
        }
        if (!CatalogV2Implicits$.MODULE$.CatalogHelper(catalog2).asTableCatalog().tableExists(identifier2)) {
            TableSpec tableSpec = new TableSpec(Predef$.MODULE$.Map().empty(), (Option)new Some((Object)this.source()), Predef$.MODULE$.Map().empty(), this.extraOptions().get("path"), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
            CreateTable cmd = new CreateTable((LogicalPlan)new UnresolvedDBObjectName(originalMultipartIdentifier, false), this.df().schema().asNullable(), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])CatalogV2Implicits$.MODULE$.PartitionTypeHelper((Seq)this.partitioningColumns().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)).asTransforms())).toSeq(), tableSpec, false);
            object = Dataset$.MODULE$.ofRows(this.df().sparkSession(), (LogicalPlan)cmd);
        } else {
            object = BoxedUnit.UNIT;
        }
        Table table = tableInstance = CatalogV2Implicits$.MODULE$.CatalogHelper(catalog2).asTableCatalog().loadTable(identifier2);
        if (table instanceof SupportsWrite && DataSourceV2Implicits$.MODULE$.TableHelper((Table)(supportsWrite = (SupportsWrite)table)).supports(TableCapability.STREAMING_WRITE)) {
            SupportsWrite x$1 = supportsWrite;
            CaseInsensitiveMap<String> x$2 = this.extraOptions();
            Some x$3 = new Some((Object)new Tuple2((Object)CatalogV2Implicits$.MODULE$.CatalogHelper(catalog2).asTableCatalog(), (Object)identifier2));
            boolean x$4 = this.startQuery$default$3();
            streamingQuery = this.startQuery((Table)x$1, x$2, x$4, (Option<Tuple2<TableCatalog, Identifier>>)x$3);
        } else if (table instanceof V2TableWithV1Fallback) {
            V2TableWithV1Fallback v2TableWithV1Fallback = (V2TableWithV1Fallback)table;
            streamingQuery = this.writeToV1Table$1(v2TableWithV1Fallback.v1Table(), tableName);
        } else if (table instanceof V1Table) {
            V1Table v1Table = (V1Table)table;
            streamingQuery = this.writeToV1Table$1(v1Table.v1Table(), tableName);
        } else {
            throw QueryCompilationErrors$.MODULE$.tableNotSupportStreamingWriteError(tableName, table);
        }
        return streamingQuery;
    }

    private StreamingQuery startInternal(Option<String> path) {
        StreamingQuery streamingQuery;
        String string = this.source().toLowerCase(Locale.ROOT);
        String string2 = DDLUtils$.MODULE$.HIVE_PROVIDER();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw QueryCompilationErrors$.MODULE$.cannotOperateOnHiveDataSourceFilesError("write");
        }
        String string3 = this.source();
        String string4 = DataStreamWriter$.MODULE$.SOURCE_NAME_MEMORY();
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            this.assertNotPartitioned(DataStreamWriter$.MODULE$.SOURCE_NAME_MEMORY());
            if (this.extraOptions().get("queryName").isEmpty()) {
                throw QueryCompilationErrors$.MODULE$.queryNameNotSpecifiedForMemorySinkError();
            }
            MemorySink sink = new MemorySink();
            Dataset<Row> resultDf = Dataset$.MODULE$.ofRows(this.df().sparkSession(), new MemoryPlan(sink, (Seq<Attribute>)this.df().schema().toAttributes()));
            OutputMode outputMode = this.outputMode();
            OutputMode outputMode2 = OutputMode.Complete();
            boolean recoverFromCheckpoint = !(outputMode != null ? !outputMode.equals(outputMode2) : outputMode2 != null);
            StreamingQuery query = this.startQuery(sink, this.extraOptions(), recoverFromCheckpoint, this.startQuery$default$4());
            resultDf.createOrReplaceTempView(query.name());
            streamingQuery = query;
        } else {
            String string5 = this.source();
            String string6 = DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH();
            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                this.assertNotPartitioned(DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH());
                ForeachWriterTable<?> sink = ForeachWriterTable$.MODULE$.apply(this.foreachWriter(), this.ds.exprEnc());
                streamingQuery = this.startQuery(sink, this.extraOptions(), this.startQuery$default$3(), this.startQuery$default$4());
            } else {
                String string7 = this.source();
                String string8 = DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH_BATCH();
                if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                    this.assertNotPartitioned(DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH_BATCH());
                    if (this.trigger() instanceof ContinuousTrigger) {
                        throw QueryCompilationErrors$.MODULE$.sourceNotSupportedWithContinuousTriggerError(this.source());
                    }
                    ForeachBatchSink<T> sink = new ForeachBatchSink<T>(this.foreachBatchWriter(), this.ds.exprEnc());
                    streamingQuery = this.startQuery(sink, this.extraOptions(), this.startQuery$default$3(), this.startQuery$default$4());
                } else {
                    Sink sink;
                    CaseInsensitiveMap optionsWithPath;
                    Class<?> cls = DataSource$.MODULE$.lookupDataSource(this.source(), this.df().sparkSession().sessionState().conf());
                    Seq disabledSources = Utils$.MODULE$.stringToSeq(this.df().sparkSession().sqlContext().conf().disabledV2StreamingWriters());
                    boolean useV1Source = disabledSources.contains((Object)cls.getCanonicalName()) || FileDataSourceV2.class.isAssignableFrom(cls);
                    CaseInsensitiveMap caseInsensitiveMap = optionsWithPath = path.isEmpty() ? this.extraOptions() : this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), path.get()));
                    if (TableProvider.class.isAssignableFrom(cls) && !useV1Source) {
                        SupportsWrite supportsWrite;
                        Table table;
                        TableProvider provider = (TableProvider)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
                        scala.collection.immutable.Map<String, String> sessionOptions = DataSourceV2Utils$.MODULE$.extractSessionConfigs(provider, this.df().sparkSession().sessionState().conf());
                        scala.collection.immutable.Map finalOptions = sessionOptions.filterKeys((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DataStreamWriter.$anonfun$startInternal$1(optionsWithPath, x$2))).toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)optionsWithPath.originalMap());
                        CaseInsensitiveStringMap dsOptions = new CaseInsensitiveStringMap((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)finalOptions).asJava());
                        None$ outputSchema = provider.supportsExternalMetadata() ? new Some((Object)this.df().schema()) : None$.MODULE$;
                        Table table2 = table = DataSourceV2Utils$.MODULE$.getTableFromProvider(provider, dsOptions, (Option<StructType>)outputSchema);
                        Sink sink2 = table2 instanceof SupportsWrite && DataSourceV2Implicits$.MODULE$.TableHelper((Table)(supportsWrite = (SupportsWrite)table2)).supports(TableCapability.STREAMING_WRITE) ? supportsWrite : this.createV1Sink((CaseInsensitiveMap<String>)optionsWithPath);
                        sink = sink2;
                    } else {
                        sink = this.createV1Sink((CaseInsensitiveMap<String>)optionsWithPath);
                    }
                    Sink sink3 = sink;
                    streamingQuery = this.startQuery(sink3, (CaseInsensitiveMap<String>)optionsWithPath, this.startQuery$default$3(), this.startQuery$default$4());
                }
            }
        }
        return streamingQuery;
    }

    private StreamingQuery startQuery(Table sink, CaseInsensitiveMap<String> newOptions, boolean recoverFromCheckpoint, Option<Tuple2<TableCatalog, Identifier>> catalogAndIdent) {
        boolean useTempCheckpointLocation = DataStreamWriter$.MODULE$.SOURCES_ALLOW_ONE_TIME_QUERY().contains((Object)this.source());
        Option x$1 = newOptions.get("queryName");
        Option x$2 = newOptions.get("checkpointLocation");
        Dataset<Row> x$3 = this.df();
        scala.collection.immutable.Map x$4 = newOptions.originalMap();
        Table x$5 = sink;
        OutputMode x$6 = this.outputMode();
        boolean x$7 = useTempCheckpointLocation;
        boolean x$8 = recoverFromCheckpoint;
        Trigger x$9 = this.trigger();
        Option<Tuple2<TableCatalog, Identifier>> x$10 = catalogAndIdent;
        Clock x$11 = this.df().sparkSession().sessionState().streamingQueryManager().startQuery$default$10();
        return this.df().sparkSession().sessionState().streamingQueryManager().startQuery((Option<String>)x$1, (Option<String>)x$2, x$3, (scala.collection.immutable.Map<String, String>)x$4, x$5, x$6, x$7, x$8, x$9, x$11, x$10);
    }

    private boolean startQuery$default$3() {
        return true;
    }

    private Option<Tuple2<TableCatalog, Identifier>> startQuery$default$4() {
        return None$.MODULE$;
    }

    private Sink createV1Sink(CaseInsensitiveMap<String> optionsWithPath) {
        SparkSession x$1 = this.df().sparkSession();
        String x$2 = this.source();
        scala.collection.immutable.Map x$3 = optionsWithPath.originalMap();
        Seq x$4 = (Seq)this.normalizedParCols().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        Seq<String> x$5 = DataSource$.MODULE$.apply$default$3();
        Option<StructType> x$6 = DataSource$.MODULE$.apply$default$4();
        Option<BucketSpec> x$7 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$8 = DataSource$.MODULE$.apply$default$8();
        DataSource ds = new DataSource(x$1, x$2, x$5, x$6, (Seq<String>)x$4, x$7, (scala.collection.immutable.Map<String, String>)x$3, x$8);
        return ds.createSink(this.outputMode());
    }

    public DataStreamWriter<T> foreach(ForeachWriter<T> writer) {
        this.source_$eq(DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH());
        if (writer == null) {
            throw new IllegalArgumentException("foreach writer cannot be null");
        }
        this.foreachWriter_$eq((ForeachWriter)this.ds.sparkSession().sparkContext().clean(writer, this.ds.sparkSession().sparkContext().clean$default$2()));
        return this;
    }

    @Evolving
    public DataStreamWriter<T> foreachBatch(Function2<Dataset<T>, Object, BoxedUnit> function) {
        this.source_$eq(DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH_BATCH());
        if (function == null) {
            throw new IllegalArgumentException("foreachBatch function cannot be null");
        }
        this.foreachBatchWriter_$eq(function);
        return this;
    }

    @Evolving
    public DataStreamWriter<T> foreachBatch(VoidFunction2<Dataset<T>, Long> function) {
        return this.foreachBatch((Function2 & Serializable & scala.Serializable)(batchDs, batchId) -> {
            function.call((Object)batchDs, (Object)Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)batchId)));
            return BoxedUnit.UNIT;
        });
    }

    private Option<Seq<String>> normalizedParCols() {
        return this.partitioningColumns().map((Function1 & Serializable & scala.Serializable)cols -> (Seq)cols.map((Function1 & Serializable & scala.Serializable)x$3 -> this.normalize((String)x$3, "Partition"), Seq$.MODULE$.canBuildFrom()));
    }

    private String normalize(String columnName, String columnType) {
        Seq validColumnNames = (Seq)this.df().logicalPlan().output().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.name(), Seq$.MODULE$.canBuildFrom());
        return (String)validColumnNames.find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DataStreamWriter.$anonfun$normalize$2(this, columnName, x$5))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw QueryCompilationErrors$.MODULE$.columnNotFoundInExistingColumnsError(columnType, columnName, validColumnNames);
        });
    }

    private void assertNotPartitioned(String operation) {
        if (this.partitioningColumns().isDefined()) {
            throw QueryCompilationErrors$.MODULE$.operationNotSupportPartitioningError(operation);
        }
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private String tableName() {
        return this.tableName;
    }

    private void tableName_$eq(String x$1) {
        this.tableName = x$1;
    }

    private OutputMode outputMode() {
        return this.outputMode;
    }

    private void outputMode_$eq(OutputMode x$1) {
        this.outputMode = x$1;
    }

    private Trigger trigger() {
        return this.trigger;
    }

    private void trigger_$eq(Trigger x$1) {
        this.trigger = x$1;
    }

    private CaseInsensitiveMap<String> extraOptions() {
        return this.extraOptions;
    }

    private void extraOptions_$eq(CaseInsensitiveMap<String> x$1) {
        this.extraOptions = x$1;
    }

    private ForeachWriter<T> foreachWriter() {
        return this.foreachWriter;
    }

    private void foreachWriter_$eq(ForeachWriter<T> x$1) {
        this.foreachWriter = x$1;
    }

    private Function2<Dataset<T>, Object, BoxedUnit> foreachBatchWriter() {
        return this.foreachBatchWriter;
    }

    private void foreachBatchWriter_$eq(Function2<Dataset<T>, Object, BoxedUnit> x$1) {
        this.foreachBatchWriter = x$1;
    }

    private Option<Seq<String>> partitioningColumns() {
        return this.partitioningColumns;
    }

    private void partitioningColumns_$eq(Option<Seq<String>> x$1) {
        this.partitioningColumns = x$1;
    }

    private final StreamingQuery writeToV1Table$1(CatalogTable table, String tableName$1) {
        CatalogTableType catalogTableType = table.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
            throw QueryCompilationErrors$.MODULE$.streamingIntoViewNotSupportedError(tableName$1);
        }
        Predef$.MODULE$.require(table.provider().isDefined());
        String string = this.source();
        Object object = table.provider().get();
        if (string == null ? object != null : !string.equals(object)) {
            throw QueryCompilationErrors$.MODULE$.inputSourceDiffersFromDataSourceProviderError(this.source(), tableName$1, table);
        }
        return this.format((String)table.provider().get()).option("path", new Path(table.location()).toString()).start();
    }

    public static final /* synthetic */ boolean $anonfun$startInternal$1(CaseInsensitiveMap optionsWithPath$1, String x$2) {
        return !optionsWithPath$1.contains(x$2);
    }

    public static final /* synthetic */ boolean $anonfun$normalize$2(DataStreamWriter $this, String columnName$1, String x$5) {
        return BoxesRunTime.unboxToBoolean((Object)$this.df().sparkSession().sessionState().analyzer().resolver().apply((Object)x$5, (Object)columnName$1));
    }

    public DataStreamWriter(Dataset<T> ds) {
        this.ds = ds;
        this.df = ds.toDF();
        this.source = this.df().sparkSession().sessionState().conf().defaultDataSourceName();
        this.tableName = null;
        this.outputMode = OutputMode.Append();
        this.trigger = Trigger.ProcessingTime(0L);
        this.extraOptions = CaseInsensitiveMap$.MODULE$.apply(Predef$.MODULE$.Map().empty());
        this.foreachWriter = null;
        this.foreachBatchWriter = null;
        this.partitioningColumns = None$.MODULE$;
    }
}

