/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql.connector.catalog.functions;

import java.util.Random;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.functions.BoundFunction;
import org.apache.spark.sql.connector.catalog.functions.ScalarFunction;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.StructType;

public class JavaRandomAdd
implements UnboundFunction {
    private final BoundFunction fn;

    public JavaRandomAdd(BoundFunction fn) {
        this.fn = fn;
    }

    public String name() {
        return "rand";
    }

    public BoundFunction bind(StructType inputType) {
        if (inputType.fields().length != 1) {
            throw new UnsupportedOperationException("Expect exactly one argument");
        }
        if (inputType.fields()[0].dataType() instanceof IntegerType) {
            return this.fn;
        }
        throw new UnsupportedOperationException("Expect IntegerType");
    }

    public String description() {
        return "rand_add: add a random integer to the input\nrand_add(int) -> int";
    }

    public static class JavaRandomAddStaticMagic
    extends JavaRandomAddBase {
        private static final Random rand = new Random();

        public static int invoke(int input) {
            return input + rand.nextInt();
        }
    }

    public static class JavaRandomAddMagic
    extends JavaRandomAddBase {
        private final Random rand = new Random();

        public int invoke(int input) {
            return input + this.rand.nextInt();
        }
    }

    public static class JavaRandomAddDefault
    extends JavaRandomAddBase {
        private final Random rand = new Random();

        public Integer produceResult(InternalRow input) {
            return input.getInt(0) + this.rand.nextInt();
        }
    }

    public static abstract class JavaRandomAddBase
    implements ScalarFunction<Integer> {
        public DataType[] inputTypes() {
            return new DataType[]{DataTypes.IntegerType};
        }

        public DataType resultType() {
            return DataTypes.IntegerType;
        }

        public String name() {
            return "rand_add";
        }

        public boolean isDeterministic() {
            return false;
        }
    }
}

