/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql.execution.datasources.orc;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.crypto.key.KeyProviderFactory;
import org.apache.hadoop.crypto.key.kms.KMSClientProvider;

public class FakeKeyProvider
extends KeyProvider {
    private final Map<String, TestMetadata> keyMetdata = new HashMap<String, TestMetadata>();
    private final Map<String, KeyProvider.KeyVersion> keyVersions = new HashMap<String, KeyProvider.KeyVersion>();

    public FakeKeyProvider(Configuration conf) {
        super(conf);
    }

    public KeyProvider.KeyVersion getKeyVersion(String name) {
        return this.keyVersions.get(name);
    }

    public List<String> getKeys() {
        return new ArrayList<String>(this.keyMetdata.keySet());
    }

    public List<KeyProvider.KeyVersion> getKeyVersions(String name) {
        ArrayList<KeyProvider.KeyVersion> result = new ArrayList<KeyProvider.KeyVersion>();
        KeyProvider.Metadata meta = this.getMetadata(name);
        for (int v = 0; v < meta.getVersions(); ++v) {
            String versionName = FakeKeyProvider.buildVersionName((String)name, (int)v);
            KeyProvider.KeyVersion material = this.keyVersions.get(versionName);
            if (material == null) continue;
            result.add(material);
        }
        return result;
    }

    public KeyProvider.Metadata getMetadata(String name) {
        return this.keyMetdata.get(name);
    }

    public KeyProvider.KeyVersion createKey(String name, byte[] bytes, KeyProvider.Options options) {
        String versionName = FakeKeyProvider.buildVersionName((String)name, (int)0);
        this.keyMetdata.put(name, new TestMetadata(options.getCipher(), options.getBitLength(), 1));
        KMSClientProvider.KMSKeyVersion result = new KMSClientProvider.KMSKeyVersion(name, versionName, bytes);
        this.keyVersions.put(versionName, (KeyProvider.KeyVersion)result);
        return result;
    }

    public void deleteKey(String name) {
        throw new UnsupportedOperationException("Can't delete keys");
    }

    public KeyProvider.KeyVersion rollNewVersion(String name, byte[] bytes) {
        TestMetadata key = this.keyMetdata.get(name);
        String versionName = FakeKeyProvider.buildVersionName((String)name, (int)key.addVersion());
        KMSClientProvider.KMSKeyVersion result = new KMSClientProvider.KMSKeyVersion(name, versionName, bytes);
        this.keyVersions.put(versionName, (KeyProvider.KeyVersion)result);
        return result;
    }

    public void flush() {
    }

    public static class Factory
    extends KeyProviderFactory {
        public KeyProvider createProvider(URI uri, Configuration conf) throws IOException {
            if ("test".equals(uri.getScheme())) {
                FakeKeyProvider provider = new FakeKeyProvider(conf);
                byte[] piiKey = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
                KeyProvider.Options aes128 = new KeyProvider.Options(conf);
                provider.createKey("pii", piiKey, aes128);
                byte[] piiKey2 = new byte[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
                provider.rollNewVersion("pii", piiKey2);
                byte[] secretKey = new byte[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
                provider.createKey("secret", secretKey, aes128);
                return KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)provider);
            }
            return null;
        }
    }

    static class TestMetadata
    extends KeyProvider.Metadata {
        TestMetadata(String cipher, int bitLength, int versions) {
            super(cipher, bitLength, null, null, null, versions);
        }

        public int addVersion() {
            return super.addVersion();
        }
    }
}

