/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.catalog.TemporaryViewRelation;
import org.apache.spark.sql.catalyst.catalog.TemporaryViewRelation$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.View;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.command.CommandUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.SchemaUtils$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class ViewHelper$
implements SQLConfHelper,
Logging {
    public static ViewHelper$ MODULE$;
    private final Seq<String> configPrefixDenyList;
    private final Seq<String> configAllowList;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ViewHelper$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Seq<String> configPrefixDenyList() {
        return this.configPrefixDenyList;
    }

    private Seq<String> configAllowList() {
        return this.configAllowList;
    }

    private boolean shouldCaptureConfig(String key) {
        return this.configAllowList().exists((Function1 & Serializable & scala.Serializable)prefix -> BoxesRunTime.boxToBoolean((boolean)key.equals(prefix))) || !this.configPrefixDenyList().exists((Function1 & Serializable & scala.Serializable)prefix -> BoxesRunTime.boxToBoolean((boolean)key.startsWith(prefix)));
    }

    private Map<String, String> generateQueryColumnNames(Seq<String> columns) {
        HashMap props;
        block0: {
            props = new HashMap();
            if (!columns.nonEmpty()) break block0;
            props.put((Object)CatalogTable$.MODULE$.VIEW_QUERY_OUTPUT_NUM_COLUMNS(), (Object)Integer.toString(columns.length()));
            ((IterableLike)columns.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String colName = (String)tuple2._1();
                int index = tuple2._2$mcI$sp();
                Option option = props.put((Object)new StringBuilder(0).append(CatalogTable$.MODULE$.VIEW_QUERY_OUTPUT_COLUMN_NAME_PREFIX()).append(index).toString(), (Object)colName);
                return option;
            });
        }
        return props.toMap(Predef$.MODULE$.$conforms());
    }

    private Map<String, String> removeQueryColumnNames(Map<String, String> properties) {
        return (Map)properties.filterNot((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ViewHelper$.$anonfun$removeQueryColumnNames$1(x0$1)));
    }

    private Map<String, String> sqlConfigsToProps(SQLConf conf) {
        Map modifiedConfs = (Map)conf.getAllConfs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ViewHelper$.$anonfun$sqlConfigsToProps$1(conf, x0$1)));
        Seq alwaysCaptured = (Seq)((TraversableLike)((TraversableLike)new .colon.colon((Object)SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE(), (List)Nil$.MODULE$)).filter((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)ViewHelper$.$anonfun$sqlConfigsToProps$2(modifiedConfs, c)))).map((Function1 & Serializable & scala.Serializable)c -> new Tuple2((Object)c.key(), conf.getConf(c)), Seq$.MODULE$.canBuildFrom());
        HashMap props = new HashMap();
        modifiedConfs.$plus$plus((GenTraversableOnce)alwaysCaptured).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ViewHelper$.$anonfun$sqlConfigsToProps$4(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            Tuple2 tuple2 = x$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            Option option = props.put((Object)new StringBuilder(0).append(CatalogTable$.MODULE$.VIEW_SQL_CONFIG_PREFIX()).append(key).toString(), (Object)value);
            return option;
        });
        return props.toMap(Predef$.MODULE$.$conforms());
    }

    private Map<String, String> removeSQLConfigs(Map<String, String> properties) {
        return (Map)properties.filterNot((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ViewHelper$.$anonfun$removeSQLConfigs$1(x0$1)));
    }

    private Map<String, String> referredTempNamesToProps(Seq<Seq<String>> viewNames, Seq<String> functionsNames) {
        JsonAST.JArray viewNamesJson = new JsonAST.JArray(((TraversableOnce)viewNames.map((Function1 & Serializable & scala.Serializable)nameParts -> new JsonAST.JArray(((TraversableOnce)nameParts.map((Function1)JsonAST.JString$.MODULE$, Seq$.MODULE$.canBuildFrom())).toList()), Seq$.MODULE$.canBuildFrom())).toList());
        JsonAST.JArray functionsNamesJson = new JsonAST.JArray(((TraversableOnce)functionsNames.map((Function1)JsonAST.JString$.MODULE$, Seq$.MODULE$.canBuildFrom())).toList());
        HashMap props = new HashMap();
        JsonAST.JArray x$1 = viewNamesJson;
        Formats x$2 = JsonMethods$.MODULE$.render$default$2((JsonAST.JValue)x$1);
        props.put((Object)CatalogTable$.MODULE$.VIEW_REFERRED_TEMP_VIEW_NAMES(), (Object)JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)x$1, x$2)));
        JsonAST.JArray x$3 = functionsNamesJson;
        Formats x$4 = JsonMethods$.MODULE$.render$default$2((JsonAST.JValue)x$3);
        props.put((Object)CatalogTable$.MODULE$.VIEW_REFERRED_TEMP_FUNCTION_NAMES(), (Object)JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)x$3, x$4)));
        return props.toMap(Predef$.MODULE$.$conforms());
    }

    private Map<String, String> removeReferredTempNames(Map<String, String> properties) {
        return (Map)properties.filterNot((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ViewHelper$.$anonfun$removeReferredTempNames$1(x0$1)));
    }

    public Map<String, String> generateViewProperties(Map<String, String> properties, SparkSession session, LogicalPlan analyzedPlan, String[] fieldNames, Seq<Seq<String>> tempViewNames, Seq<String> tempFunctionNames) {
        String[] queryOutput = analyzedPlan.schema().fieldNames();
        SQLConf conf = session.sessionState().conf();
        SchemaUtils$.MODULE$.checkColumnNameDuplication((Seq)Predef$.MODULE$.wrapRefArray((Object[])fieldNames), "in the view definition", conf.resolver());
        CatalogManager manager = session.sessionState().catalogManager();
        return this.removeReferredTempNames(this.removeSQLConfigs(this.removeQueryColumnNames(properties))).$plus$plus((GenTraversableOnce)CatalogTable$.MODULE$.catalogAndNamespaceToProps(manager.currentCatalog().name(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])manager.currentNamespace()))).$plus$plus(this.sqlConfigsToProps(conf)).$plus$plus(this.generateQueryColumnNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])queryOutput))).$plus$plus(this.referredTempNamesToProps(tempViewNames, tempFunctionNames));
    }

    public Seq<Seq<String>> generateViewProperties$default$5() {
        return (Seq)Nil$.MODULE$;
    }

    public Seq<String> generateViewProperties$default$6() {
        return (Seq)Nil$.MODULE$;
    }

    public void checkCyclicViewReference(LogicalPlan plan, Seq<TableIdentifier> path, TableIdentifier viewIdent) {
        LogicalPlan logicalPlan2 = plan;
        if (logicalPlan2 instanceof View) {
            View view = (View)logicalPlan2;
            TableIdentifier ident = view.desc().identifier();
            Seq newPath = (Seq)path.$colon$plus((Object)ident, Seq$.MODULE$.canBuildFrom());
            TableIdentifier tableIdentifier = ident;
            TableIdentifier tableIdentifier2 = viewIdent;
            if (!(tableIdentifier != null ? !tableIdentifier.equals(tableIdentifier2) : tableIdentifier2 != null)) {
                throw QueryCompilationErrors$.MODULE$.recursiveViewDetectedError(viewIdent, newPath);
            }
            view.children().foreach((Function1 & Serializable & scala.Serializable)child -> {
                ViewHelper$.MODULE$.checkCyclicViewReference(child, (Seq<TableIdentifier>)newPath, viewIdent);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            plan.children().foreach((Function1 & Serializable & scala.Serializable)child -> {
                ViewHelper$.MODULE$.checkCyclicViewReference(child, (Seq<TableIdentifier>)path, viewIdent);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        plan.expressions().foreach((Function1 & Serializable & scala.Serializable)expr -> {
            ViewHelper$.$anonfun$checkCyclicViewReference$3(path, viewIdent, expr);
            return BoxedUnit.UNIT;
        });
    }

    public void verifyAutoGeneratedAliasesNotExists(LogicalPlan child, boolean isTemporary, TableIdentifier name) {
        block0: {
            if (isTemporary || this.conf().allowAutoGeneratedAliasForView()) break block0;
            child.output().foreach((Function1 & Serializable & scala.Serializable)attr -> {
                ViewHelper$.$anonfun$verifyAutoGeneratedAliasesNotExists$1(name, attr);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void verifyTemporaryObjectsNotExists(boolean isTemporary, TableIdentifier name, LogicalPlan child, Seq<String> referredTempFunctions) {
        block0: {
            if (isTemporary) break block0;
            Seq<Seq<String>> tempViews = this.collectTemporaryViews(child);
            tempViews.foreach((Function1 & Serializable & scala.Serializable)nameParts -> {
                throw QueryCompilationErrors$.MODULE$.notAllowedToCreatePermanentViewByReferencingTempViewError(name, CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(nameParts).quoted());
            });
            referredTempFunctions.foreach((Function1 & Serializable & scala.Serializable)funcName -> {
                throw QueryCompilationErrors$.MODULE$.notAllowedToCreatePermanentViewByReferencingTempFuncError(name, funcName);
            });
        }
    }

    private Seq<Seq<String>> collectTemporaryViews(LogicalPlan child) {
        return ViewHelper$.collectTempViews$1(child);
    }

    public TemporaryViewRelation createTemporaryViewRelation(TableIdentifier name, SparkSession session, boolean replace, Function1<String, Option<TemporaryViewRelation>> getRawTempView, Option<String> originalText, LogicalPlan analyzedPlan, LogicalPlan aliasedPlan, Seq<String> referredTempFunctions) {
        boolean storeAnalyzedPlanForView;
        boolean uncache = BoxesRunTime.unboxToBoolean((Object)((Option)getRawTempView.apply((Object)name.table())).map((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)ViewHelper$.MODULE$.needsToUncache(r, aliasedPlan))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
        boolean bl = storeAnalyzedPlanForView = this.conf().storeAnalyzedPlanForView() || originalText.isEmpty();
        if (replace && uncache) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Try to uncache ").append(name.quotedString()).append(" before replacing.").toString());
            if (!storeAnalyzedPlanForView) {
                this.checkCyclicViewReference(analyzedPlan, (Seq<TableIdentifier>)((Seq)new .colon.colon((Object)name, (List)Nil$.MODULE$)), name);
            }
            CommandUtils$.MODULE$.uncacheTableOrView(session, name.quotedString());
        }
        return !storeAnalyzedPlanForView ? new TemporaryViewRelation(this.prepareTemporaryView(name, session, analyzedPlan, aliasedPlan.schema(), (String)originalText.get(), referredTempFunctions), TemporaryViewRelation$.MODULE$.apply$default$2()) : new TemporaryViewRelation(this.prepareTemporaryViewStoringAnalyzedPlan(name, aliasedPlan), (Option)new Some((Object)aliasedPlan));
    }

    private boolean needsToUncache(TemporaryViewRelation rawTempView, LogicalPlan aliasedPlan) {
        boolean bl;
        Option option = rawTempView.plan();
        if (option instanceof Some) {
            Some some = (Some)option;
            LogicalPlan p = (LogicalPlan)some.value();
            bl = !p.sameResult((QueryPlan)aliasedPlan);
        } else if (None$.MODULE$.equals(option)) {
            bl = true;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    private CatalogTable prepareTemporaryView(TableIdentifier viewName, SparkSession session, LogicalPlan analyzedPlan, StructType viewSchema, String originalText, Seq<String> tempFunctions) {
        SessionCatalog catalog = session.sessionState().catalog();
        Seq<Seq<String>> tempViews = this.collectTemporaryViews(analyzedPlan);
        Map<String, String> newProperties = this.generateViewProperties((Map<String, String>)Predef$.MODULE$.Map().empty(), session, analyzedPlan, viewSchema.fieldNames(), tempViews, tempFunctions);
        TableIdentifier x$1 = viewName;
        CatalogTableType x$2 = CatalogTableType$.MODULE$.VIEW();
        CatalogStorageFormat x$3 = CatalogStorageFormat$.MODULE$.empty();
        StructType x$4 = viewSchema;
        Some x$5 = new Some((Object)originalText);
        Map<String, String> x$6 = newProperties;
        Option x$7 = CatalogTable$.MODULE$.apply$default$5();
        Seq x$8 = CatalogTable$.MODULE$.apply$default$6();
        Option x$9 = CatalogTable$.MODULE$.apply$default$7();
        String x$10 = CatalogTable$.MODULE$.apply$default$8();
        long x$11 = CatalogTable$.MODULE$.apply$default$9();
        long x$12 = CatalogTable$.MODULE$.apply$default$10();
        String x$13 = CatalogTable$.MODULE$.apply$default$11();
        Option x$14 = CatalogTable$.MODULE$.apply$default$13();
        Option x$15 = CatalogTable$.MODULE$.apply$default$15();
        Seq x$16 = CatalogTable$.MODULE$.apply$default$16();
        boolean x$17 = CatalogTable$.MODULE$.apply$default$17();
        boolean x$18 = CatalogTable$.MODULE$.apply$default$18();
        Map x$19 = CatalogTable$.MODULE$.apply$default$19();
        Option x$20 = CatalogTable$.MODULE$.apply$default$20();
        return new CatalogTable(x$1, x$2, x$3, x$4, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$6, x$14, (Option)x$5, x$15, x$16, x$17, x$18, x$19, x$20);
    }

    private CatalogTable prepareTemporaryViewStoringAnalyzedPlan(TableIdentifier viewName, LogicalPlan analyzedPlan) {
        TableIdentifier x$1 = viewName;
        CatalogTableType x$2 = CatalogTableType$.MODULE$.VIEW();
        CatalogStorageFormat x$3 = CatalogStorageFormat$.MODULE$.empty();
        StructType x$4 = analyzedPlan.schema();
        Map x$5 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)CatalogTable$.MODULE$.VIEW_STORING_ANALYZED_PLAN(), (Object)"true")}));
        Option x$6 = CatalogTable$.MODULE$.apply$default$5();
        Seq x$7 = CatalogTable$.MODULE$.apply$default$6();
        Option x$8 = CatalogTable$.MODULE$.apply$default$7();
        String x$9 = CatalogTable$.MODULE$.apply$default$8();
        long x$10 = CatalogTable$.MODULE$.apply$default$9();
        long x$11 = CatalogTable$.MODULE$.apply$default$10();
        String x$12 = CatalogTable$.MODULE$.apply$default$11();
        Option x$13 = CatalogTable$.MODULE$.apply$default$13();
        Option x$14 = CatalogTable$.MODULE$.apply$default$14();
        Option x$15 = CatalogTable$.MODULE$.apply$default$15();
        Seq x$16 = CatalogTable$.MODULE$.apply$default$16();
        boolean x$17 = CatalogTable$.MODULE$.apply$default$17();
        boolean x$18 = CatalogTable$.MODULE$.apply$default$18();
        Map x$19 = CatalogTable$.MODULE$.apply$default$19();
        Option x$20 = CatalogTable$.MODULE$.apply$default$20();
        return new CatalogTable(x$1, x$2, x$3, x$4, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$5, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
    }

    public static final /* synthetic */ boolean $anonfun$removeQueryColumnNames$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        boolean bl = key.startsWith(CatalogTable$.MODULE$.VIEW_QUERY_OUTPUT_PREFIX());
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$sqlConfigsToProps$1(SQLConf conf$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        boolean bl = conf$1.isModifiable(k) && MODULE$.shouldCaptureConfig(k);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$sqlConfigsToProps$2(Map modifiedConfs$1, ConfigEntry c) {
        return !modifiedConfs$1.contains((Object)c.key());
    }

    public static final /* synthetic */ boolean $anonfun$sqlConfigsToProps$4(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$removeSQLConfigs$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        boolean bl = key.startsWith(CatalogTable$.MODULE$.VIEW_SQL_CONFIG_PREFIX());
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$removeReferredTempNames$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        boolean bl = key.startsWith(CatalogTable$.MODULE$.VIEW_REFERRED_TEMP_VIEW_NAMES()) || key.startsWith(CatalogTable$.MODULE$.VIEW_REFERRED_TEMP_FUNCTION_NAMES());
        return bl;
    }

    public static final /* synthetic */ void $anonfun$checkCyclicViewReference$3(Seq path$1, TableIdentifier viewIdent$3, Expression expr) {
        Expression expression = expr;
        if (expression instanceof SubqueryExpression) {
            SubqueryExpression subqueryExpression = (SubqueryExpression)expression;
            MODULE$.checkCyclicViewReference((LogicalPlan)subqueryExpression.plan(), (Seq<TableIdentifier>)path$1, viewIdent$3);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$verifyAutoGeneratedAliasesNotExists$1(TableIdentifier name$1, Attribute attr) {
        if (attr.metadata().contains("__autoGeneratedAlias")) {
            throw QueryCompilationErrors$.MODULE$.notAllowedToCreatePermanentViewWithoutAssigningAliasForExpressionError(name$1, attr.name());
        }
    }

    private static final Seq collectTempViews$1(LogicalPlan child) {
        return (Seq)child.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Seq seq;
            View view;
            LogicalPlan logicalPlan2 = x0$1;
            if (logicalPlan2 instanceof View && (view = (View)logicalPlan2).isTempView()) {
                TableIdentifier ident = view.desc().identifier();
                seq = (Seq)new .colon.colon((Object)((Seq)Option$.MODULE$.option2Iterable(ident.database()).toSeq().$colon$plus((Object)ident.table(), Seq$.MODULE$.canBuildFrom())), (List)Nil$.MODULE$);
            } else {
                seq = (Seq)logicalPlan2.expressions().flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Seq seq;
                    Expression expression = x0$2;
                    if (expression instanceof SubqueryExpression) {
                        SubqueryExpression subqueryExpression = (SubqueryExpression)expression;
                        seq = ViewHelper$.collectTempViews$1((LogicalPlan)subqueryExpression.plan());
                    } else {
                        seq = (Seq)Nil$.MODULE$;
                    }
                    return seq;
                }), Seq$.MODULE$.canBuildFrom());
            }
            return seq;
        }).distinct();
    }

    private ViewHelper$() {
        MODULE$ = this;
        SQLConfHelper.$init$((SQLConfHelper)this);
        Logging.$init$((Logging)this);
        this.configPrefixDenyList = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{SQLConf$.MODULE$.MAX_NESTED_VIEW_DEPTH().key(), "spark.sql.optimizer.", "spark.sql.codegen.", "spark.sql.execution.", "spark.sql.shuffle.", "spark.sql.adaptive.", "spark.sql.hive.convertMetastoreParquet", "spark.sql.hive.convertMetastoreOrc", "spark.sql.hive.convertInsertingPartitionedTable", "spark.sql.hive.convertMetastoreCtas", SQLConf$.MODULE$.ADDITIONAL_REMOTE_REPOSITORIES().key()}));
        this.configAllowList = (Seq)new .colon.colon((Object)SQLConf$.MODULE$.DISABLE_HINTS().key(), (List)Nil$.MODULE$);
    }
}

