/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.FileSourceMetadataAttribute$;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class FileFormat$ {
    public static FileFormat$ MODULE$;
    private final String FILE_PATH;
    private final String FILE_NAME;
    private final String FILE_BLOCK_START;
    private final String FILE_BLOCK_LENGTH;
    private final String FILE_SIZE;
    private final String FILE_MODIFICATION_TIME;
    private final String ROW_INDEX;
    private final String ROW_INDEX_TEMPORARY_COLUMN_NAME;
    private final String METADATA_NAME;
    private final String OPTION_RETURNING_BATCH;
    private final StructType BASE_METADATA_STRUCT;

    static {
        new FileFormat$();
    }

    public String FILE_PATH() {
        return this.FILE_PATH;
    }

    public String FILE_NAME() {
        return this.FILE_NAME;
    }

    public String FILE_BLOCK_START() {
        return this.FILE_BLOCK_START;
    }

    public String FILE_BLOCK_LENGTH() {
        return this.FILE_BLOCK_LENGTH;
    }

    public String FILE_SIZE() {
        return this.FILE_SIZE;
    }

    public String FILE_MODIFICATION_TIME() {
        return this.FILE_MODIFICATION_TIME;
    }

    public String ROW_INDEX() {
        return this.ROW_INDEX;
    }

    public String ROW_INDEX_TEMPORARY_COLUMN_NAME() {
        return this.ROW_INDEX_TEMPORARY_COLUMN_NAME;
    }

    public String METADATA_NAME() {
        return this.METADATA_NAME;
    }

    public String OPTION_RETURNING_BATCH() {
        return this.OPTION_RETURNING_BATCH;
    }

    public StructType BASE_METADATA_STRUCT() {
        return this.BASE_METADATA_STRUCT;
    }

    public AttributeReference createFileMetadataCol(FileFormat fileFormat) {
        StructType struct = fileFormat instanceof ParquetFileFormat ? this.BASE_METADATA_STRUCT().add(new StructField(this.ROW_INDEX(), (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4())) : this.BASE_METADATA_STRUCT();
        return FileSourceMetadataAttribute$.MODULE$.apply(this.METADATA_NAME(), (DataType)struct, FileSourceMetadataAttribute$.MODULE$.apply$default$3());
    }

    public InternalRow createMetadataInternalRow(Seq<String> fieldNames, Path filePath, long fileSize, long fileModificationTime) {
        Predef$.MODULE$.assert(!fieldNames.contains((Object)this.FILE_BLOCK_START()) && !fieldNames.contains((Object)this.FILE_BLOCK_LENGTH()));
        return this.updateMetadataInternalRow((InternalRow)new GenericInternalRow(fieldNames.length()), fieldNames, filePath, fileSize, 0L, fileSize, fileModificationTime);
    }

    public InternalRow updateMetadataInternalRow(InternalRow row, Seq<String> fieldNames, Path filePath, long fileSize, long fileBlockStart, long fileBlockLength, long fileModificationTime) {
        ((IterableLike)fieldNames.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            FileFormat$.$anonfun$updateMetadataInternalRow$1(row, filePath, fileSize, fileBlockStart, fileBlockLength, fileModificationTime, x0$1);
            return BoxedUnit.UNIT;
        });
        return row;
    }

    public static final /* synthetic */ void $anonfun$updateMetadataInternalRow$1(InternalRow row$1, Path filePath$1, long fileSize$1, long fileBlockStart$1, long fileBlockLength$1, long fileModificationTime$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            int i = tuple2._2$mcI$sp();
            String string = name;
            String string2 = MODULE$.FILE_PATH();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                row$1.update(i, (Object)UTF8String.fromString((String)filePath$1.toString()));
            } else {
                String string4 = MODULE$.FILE_NAME();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    row$1.update(i, (Object)UTF8String.fromString((String)filePath$1.getName()));
                } else {
                    String string6 = MODULE$.FILE_SIZE();
                    String string7 = string;
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        row$1.update(i, (Object)BoxesRunTime.boxToLong((long)fileSize$1));
                    } else {
                        String string8 = MODULE$.FILE_BLOCK_START();
                        String string9 = string;
                        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                            row$1.update(i, (Object)BoxesRunTime.boxToLong((long)fileBlockStart$1));
                        } else {
                            String string10 = MODULE$.FILE_BLOCK_LENGTH();
                            String string11 = string;
                            if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                                row$1.update(i, (Object)BoxesRunTime.boxToLong((long)fileBlockLength$1));
                            } else {
                                String string12 = MODULE$.FILE_MODIFICATION_TIME();
                                String string13 = string;
                                if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
                                    row$1.update(i, (Object)BoxesRunTime.boxToLong((long)(fileModificationTime$1 * 1000L)));
                                } else {
                                    String string14 = MODULE$.ROW_INDEX();
                                    String string15 = string;
                                    if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
                                    } else {
                                        throw new MatchError((Object)string);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private FileFormat$() {
        MODULE$ = this;
        this.FILE_PATH = "file_path";
        this.FILE_NAME = "file_name";
        this.FILE_BLOCK_START = "file_block_start";
        this.FILE_BLOCK_LENGTH = "file_block_length";
        this.FILE_SIZE = "file_size";
        this.FILE_MODIFICATION_TIME = "file_modification_time";
        this.ROW_INDEX = "row_index";
        this.ROW_INDEX_TEMPORARY_COLUMN_NAME = new StringBuilder(14).append("_tmp_metadata_").append(this.ROW_INDEX()).toString();
        this.METADATA_NAME = "_metadata";
        this.OPTION_RETURNING_BATCH = "returning_batch";
        this.BASE_METADATA_STRUCT = new StructType().add(new StructField(this.FILE_PATH(), (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4())).add(new StructField(this.FILE_NAME(), (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4())).add(new StructField(this.FILE_SIZE(), (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4())).add(new StructField(this.FILE_BLOCK_START(), (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4())).add(new StructField(this.FILE_BLOCK_LENGTH(), (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4())).add(new StructField(this.FILE_MODIFICATION_TIME(), (DataType)TimestampType$.MODULE$, false, StructField$.MODULE$.apply$default$4()));
    }
}

