/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.util.Locale;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;

public final class DerbyDialect$
extends JdbcDialect {
    public static DerbyDialect$ MODULE$;
    private final Set<String> supportedAggregateFunctions;
    private final Set<String> supportedFunctions;

    static {
        new DerbyDialect$();
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:derby");
    }

    private Set<String> supportedAggregateFunctions() {
        return this.supportedAggregateFunctions;
    }

    private Set<String> supportedFunctions() {
        return this.supportedFunctions;
    }

    @Override
    public boolean isSupportedFunction(String funcName) {
        return this.supportedFunctions().contains((Object)funcName);
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        if (sqlType == 7) {
            return Option$.MODULE$.apply((Object)FloatType$.MODULE$);
        }
        return None$.MODULE$;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DecimalType decimalType;
        DataType dataType = dt;
        if (StringType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("CLOB", 2005));
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("SMALLINT", 5));
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("SMALLINT", 5));
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("BOOLEAN", 16));
        }
        if (dataType instanceof DecimalType && (decimalType = (DecimalType)dataType).precision() > 31) {
            return Option$.MODULE$.apply((Object)new JdbcType("DECIMAL(31,5)", 3));
        }
        return None$.MODULE$;
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public String renameTable(String oldTable, String newTable) {
        return new StringBuilder(17).append("RENAME TABLE ").append(oldTable).append(" TO ").append(newTable).toString();
    }

    @Override
    public String getTableCommentQuery(String table, String comment) {
        throw QueryExecutionErrors$.MODULE$.commentOnTableUnsupportedError();
    }

    @Override
    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        String nullable = isNullable ? "NULL" : "NOT NULL";
        return new StringBuilder(27).append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(this.quoteIdentifier(columnName)).append(" ").append(nullable).toString();
    }

    @Override
    public String getLimitClause(Integer limit) {
        return "";
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DerbyDialect$() {
        MODULE$ = this;
        this.supportedAggregateFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MAX", "MIN", "SUM", "COUNT", "AVG", "VAR_POP", "VAR_SAMP", "STDDEV_POP", "STDDEV_SAMP"}));
        this.supportedFunctions = this.supportedAggregateFunctions();
    }
}

