/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import java.util.HashMap;
import org.apache.spark.SparkConf;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.internal.config.package$;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.memory.UnifiedMemoryManager;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.execution.benchmark.SqlBasedBenchmark;
import org.apache.spark.sql.execution.joins.LongToUnsafeRowMap;
import org.apache.spark.sql.execution.joins.LongToUnsafeRowMap$;
import org.apache.spark.sql.execution.vectorized.AggregateHashMap;
import org.apache.spark.sql.execution.vectorized.MutableColumnarRow;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.hash.Murmur3_x86_32;
import org.apache.spark.unsafe.map.BytesToBytesMap;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class AggregateBenchmark$
extends BenchmarkBase
implements SqlBasedBenchmark {
    public static AggregateBenchmark$ MODULE$;
    private final SparkSession spark;
    private String sparkHome;
    private volatile boolean bitmap$0;

    static {
        new AggregateBenchmark$();
    }

    @Override
    public SparkSession getSparkSession() {
        return SqlBasedBenchmark.getSparkSession$(this);
    }

    @Override
    public final void codegenBenchmark(String name, long cardinality, Function0<BoxedUnit> f) {
        SqlBasedBenchmark.codegenBenchmark$(this, name, cardinality, f);
    }

    @Override
    public SqlBasedBenchmark.DatasetToBenchmark DatasetToBenchmark(Dataset<?> ds) {
        return SqlBasedBenchmark.DatasetToBenchmark$(this, ds);
    }

    @Override
    public void prepareDataInfo(Benchmark benchmark) {
        SqlBasedBenchmark.prepareDataInfo$(this, benchmark);
    }

    @Override
    public StructType writeWideRow(String path, int rowsNum, int numCols) {
        return SqlBasedBenchmark.writeWideRow$(this, path, rowsNum, numCols);
    }

    @Override
    public void afterAll() {
        SqlBasedBenchmark.afterAll$(this);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void org$apache$spark$sql$execution$benchmark$SqlBasedBenchmark$_setter_$spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    private String sparkHome$lzycompute() {
        AggregateBenchmark$ aggregateBenchmark$ = this;
        synchronized (aggregateBenchmark$) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        this.runBenchmark("aggregate without grouping", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            long N = 0x7D000000L;
            MODULE$.codegenBenchmark("agg w/o group", N, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.DatasetToBenchmark(MODULE$.spark().range(N).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sum(id)"}))).noop());
        });
        this.runBenchmark("stat functions", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            long N = 0x6400000L;
            MODULE$.codegenBenchmark("stddev", N, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.DatasetToBenchmark(MODULE$.spark().range(N).agg(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)"stddev"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]))).noop());
            MODULE$.codegenBenchmark("kurtosis", N, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.DatasetToBenchmark(MODULE$.spark().range(N).agg(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)"kurtosis"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]))).noop());
        });
        this.runBenchmark("aggregate with linear keys", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int N = 0x5000000;
            String x$12 = "Aggregate w keys";
            long x$22 = N;
            Option x$32 = MODULE$.output();
            int x$42 = Benchmark$.MODULE$.$lessinit$greater$default$3();
            FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
            FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
            boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
            Benchmark benchmark = new Benchmark(x$12, x$22, x$42, x$5, x$6, x$7, x$32);
            benchmark.addCase("codegen = F", 2, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.WHOLESTAGE_CODEGEN_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AggregateBenchmark$.f$1(N)));
            benchmark.addCase("codegen = T, hashmap = F", 3, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$2 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.WHOLESTAGE_CODEGEN_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_TWOLEVEL_AGG_MAP().key()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_VECTORIZED_HASH_MAP().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AggregateBenchmark$.f$1(N)));
            benchmark.addCase("codegen = T, row-based hashmap = T", 5, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$3 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.WHOLESTAGE_CODEGEN_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_TWOLEVEL_AGG_MAP().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_VECTORIZED_HASH_MAP().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AggregateBenchmark$.f$1(N)));
            benchmark.addCase("codegen = T, vectorized hashmap = T", 5, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$4 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.WHOLESTAGE_CODEGEN_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_TWOLEVEL_AGG_MAP().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_VECTORIZED_HASH_MAP().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AggregateBenchmark$.f$1(N)));
            benchmark.run();
        });
        this.runBenchmark("aggregate with randomized keys", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int N = 0x5000000;
            String x$82 = "Aggregate w keys";
            long x$9 = N;
            Option x$10 = MODULE$.output();
            int x$11 = Benchmark$.MODULE$.$lessinit$greater$default$3();
            FiniteDuration x$12 = Benchmark$.MODULE$.$lessinit$greater$default$4();
            FiniteDuration x$13 = Benchmark$.MODULE$.$lessinit$greater$default$5();
            boolean x$14 = Benchmark$.MODULE$.$lessinit$greater$default$6();
            Benchmark benchmark = new Benchmark(x$82, x$9, x$11, x$12, x$13, x$14, x$10);
            MODULE$.spark().range((long)N).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "floor(rand() * 10000) as k"})).createOrReplaceTempView("test");
            benchmark.addCase("codegen = F", 2, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$5 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.WHOLESTAGE_CODEGEN_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AggregateBenchmark$.f$2()));
            benchmark.addCase("codegen = T, hashmap = F", 3, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$6 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.WHOLESTAGE_CODEGEN_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_TWOLEVEL_AGG_MAP().key()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_VECTORIZED_HASH_MAP().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AggregateBenchmark$.f$2()));
            benchmark.addCase("codegen = T, row-based hashmap = T", 5, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$7 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.WHOLESTAGE_CODEGEN_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_TWOLEVEL_AGG_MAP().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_VECTORIZED_HASH_MAP().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AggregateBenchmark$.f$2()));
            benchmark.addCase("codegen = T, vectorized hashmap = T", 5, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$8 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.WHOLESTAGE_CODEGEN_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_TWOLEVEL_AGG_MAP().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_VECTORIZED_HASH_MAP().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AggregateBenchmark$.f$2()));
            benchmark.run();
        });
        this.runBenchmark("aggregate with string key", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int N = 0x1400000;
            String x$15 = "Aggregate w string key";
            long x$16 = N;
            Option x$17 = MODULE$.output();
            int x$18 = Benchmark$.MODULE$.$lessinit$greater$default$3();
            FiniteDuration x$19 = Benchmark$.MODULE$.$lessinit$greater$default$4();
            FiniteDuration x$20 = Benchmark$.MODULE$.$lessinit$greater$default$5();
            boolean x$21 = Benchmark$.MODULE$.$lessinit$greater$default$6();
            Benchmark benchmark = new Benchmark(x$15, x$16, x$18, x$19, x$20, x$21, x$17);
            benchmark.addCase("codegen = F", 2, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$9 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.WHOLESTAGE_CODEGEN_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AggregateBenchmark$.f$3(N)));
            benchmark.addCase("codegen = T, hashmap = F", 3, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$10 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.WHOLESTAGE_CODEGEN_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_TWOLEVEL_AGG_MAP().key()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_VECTORIZED_HASH_MAP().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AggregateBenchmark$.f$3(N)));
            benchmark.addCase("codegen = T, row-based hashmap = T", 5, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$11 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.WHOLESTAGE_CODEGEN_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_TWOLEVEL_AGG_MAP().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_VECTORIZED_HASH_MAP().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AggregateBenchmark$.f$3(N)));
            benchmark.addCase("codegen = T, vectorized hashmap = T", 5, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$12 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.WHOLESTAGE_CODEGEN_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_TWOLEVEL_AGG_MAP().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_VECTORIZED_HASH_MAP().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AggregateBenchmark$.f$3(N)));
            benchmark.run();
        });
        this.runBenchmark("aggregate with decimal key", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int N = 0x1400000;
            String x$22 = "Aggregate w decimal key";
            long x$23 = N;
            Option x$24 = MODULE$.output();
            int x$25 = Benchmark$.MODULE$.$lessinit$greater$default$3();
            FiniteDuration x$26 = Benchmark$.MODULE$.$lessinit$greater$default$4();
            FiniteDuration x$27 = Benchmark$.MODULE$.$lessinit$greater$default$5();
            boolean x$28 = Benchmark$.MODULE$.$lessinit$greater$default$6();
            Benchmark benchmark = new Benchmark(x$22, x$23, x$25, x$26, x$27, x$28, x$24);
            benchmark.addCase("codegen = F", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$13 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.WHOLESTAGE_CODEGEN_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AggregateBenchmark$.f$4(N)));
            benchmark.addCase("codegen = T, hashmap = F", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$14 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.WHOLESTAGE_CODEGEN_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_TWOLEVEL_AGG_MAP().key()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_VECTORIZED_HASH_MAP().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AggregateBenchmark$.f$4(N)));
            benchmark.addCase("codegen = T, row-based hashmap = T", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$15 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.WHOLESTAGE_CODEGEN_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_TWOLEVEL_AGG_MAP().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_VECTORIZED_HASH_MAP().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AggregateBenchmark$.f$4(N)));
            benchmark.addCase("codegen = T, vectorized hashmap = T", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$16 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.WHOLESTAGE_CODEGEN_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_TWOLEVEL_AGG_MAP().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_VECTORIZED_HASH_MAP().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AggregateBenchmark$.f$4(N)));
            benchmark.run();
        });
        this.runBenchmark("aggregate with multiple key types", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int N = 0x1400000;
            String x$29 = "Aggregate w multiple keys";
            long x$30 = N;
            Option x$31 = MODULE$.output();
            int x$32 = Benchmark$.MODULE$.$lessinit$greater$default$3();
            FiniteDuration x$33 = Benchmark$.MODULE$.$lessinit$greater$default$4();
            FiniteDuration x$34 = Benchmark$.MODULE$.$lessinit$greater$default$5();
            boolean x$35 = Benchmark$.MODULE$.$lessinit$greater$default$6();
            Benchmark benchmark = new Benchmark(x$29, x$30, x$32, x$33, x$34, x$35, x$31);
            benchmark.addCase("codegen = F", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$17 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.WHOLESTAGE_CODEGEN_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AggregateBenchmark$.f$5(N)));
            benchmark.addCase("codegen = T, hashmap = F", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$18 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.WHOLESTAGE_CODEGEN_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_TWOLEVEL_AGG_MAP().key()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_VECTORIZED_HASH_MAP().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AggregateBenchmark$.f$5(N)));
            benchmark.addCase("codegen = T, row-based hashmap = T", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$19 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.WHOLESTAGE_CODEGEN_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_TWOLEVEL_AGG_MAP().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_VECTORIZED_HASH_MAP().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AggregateBenchmark$.f$5(N)));
            benchmark.addCase("codegen = T, vectorized hashmap = T", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$20 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.WHOLESTAGE_CODEGEN_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_TWOLEVEL_AGG_MAP().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_VECTORIZED_HASH_MAP().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AggregateBenchmark$.f$5(N)));
            benchmark.run();
        });
        this.runBenchmark("max function bytecode size of wholestagecodegen", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int N = 655360;
            String x$36 = "max function bytecode size";
            long x$37 = N;
            Option x$38 = MODULE$.output();
            int x$39 = Benchmark$.MODULE$.$lessinit$greater$default$3();
            FiniteDuration x$40 = Benchmark$.MODULE$.$lessinit$greater$default$4();
            FiniteDuration x$41 = Benchmark$.MODULE$.$lessinit$greater$default$5();
            boolean x$42 = Benchmark$.MODULE$.$lessinit$greater$default$6();
            Benchmark benchmark = new Benchmark(x$36, x$37, x$39, x$40, x$41, x$42, x$38);
            benchmark.addCase("codegen = F", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$21 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.WHOLESTAGE_CODEGEN_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AggregateBenchmark$.f$6(N)));
            benchmark.addCase("codegen = T, hugeMethodLimit = 10000", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$22 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.WHOLESTAGE_CODEGEN_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.WHOLESTAGE_HUGE_METHOD_LIMIT().key()), (Object)"10000")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AggregateBenchmark$.f$6(N)));
            benchmark.addCase("codegen = T, hugeMethodLimit = 1500", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$23 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.WHOLESTAGE_CODEGEN_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.WHOLESTAGE_HUGE_METHOD_LIMIT().key()), (Object)"1500")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AggregateBenchmark$.f$6(N)));
            benchmark.run();
        });
        this.runBenchmark("cube", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int N = 0x500000;
            MODULE$.codegenBenchmark("cube", N, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.DatasetToBenchmark(MODULE$.spark().range((long)N).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "id % 1000 as k1", "id & 256 as k2"})).cube("k1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k2"})).sum((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).noop());
        });
        this.runBenchmark("hash and BytesToBytesMap", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int N = 0x1400000;
            String x$43 = "BytesToBytesMap";
            long x$44 = N;
            Option x$45 = MODULE$.output();
            int x$46 = Benchmark$.MODULE$.$lessinit$greater$default$3();
            FiniteDuration x$47 = Benchmark$.MODULE$.$lessinit$greater$default$4();
            FiniteDuration x$48 = Benchmark$.MODULE$.$lessinit$greater$default$5();
            boolean x$49 = Benchmark$.MODULE$.$lessinit$greater$default$6();
            Benchmark benchmark = new Benchmark(x$43, x$44, x$46, x$47, x$48, x$49, x$45);
            benchmark.addCase("UnsafeRowhash", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$24 -> {
                byte[] keyBytes = new byte[16];
                UnsafeRow key = new UnsafeRow(1);
                key.pointTo((Object)keyBytes, (long)Platform.BYTE_ARRAY_OFFSET, 16);
                int s = 0;
                for (int i = 0; i < N; ++i) {
                    key.setInt(0, i % 1000);
                    int h = Murmur3_x86_32.hashUnsafeWords((Object)key.getBaseObject(), (long)key.getBaseOffset(), (int)key.getSizeInBytes(), (int)42);
                    s += h;
                }
            });
            benchmark.addCase("murmur3 hash", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$25 -> {
                byte[] keyBytes = new byte[16];
                UnsafeRow key = new UnsafeRow(1);
                key.pointTo((Object)keyBytes, (long)Platform.BYTE_ARRAY_OFFSET, 16);
                int p = 524283;
                int s = 0;
                for (int i = 0; i < N; ++i) {
                    int h = Murmur3_x86_32.hashLong((long)i, (int)42);
                    key.setInt(0, h);
                    s += h;
                }
            });
            benchmark.addCase("fast hash", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$26 -> {
                byte[] keyBytes = new byte[16];
                UnsafeRow key = new UnsafeRow(1);
                key.pointTo((Object)keyBytes, (long)Platform.BYTE_ARRAY_OFFSET, 16);
                int p = 524283;
                int s = 0;
                for (int i = 0; i < N; ++i) {
                    int h = i % p;
                    if (h < 0) {
                        h += p;
                    }
                    key.setInt(0, h);
                    s += h;
                }
            });
            benchmark.addCase("arrayEqual", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$27 -> {
                byte[] keyBytes = new byte[16];
                byte[] valueBytes = new byte[16];
                UnsafeRow key = new UnsafeRow(1);
                key.pointTo((Object)keyBytes, (long)Platform.BYTE_ARRAY_OFFSET, 16);
                UnsafeRow value = new UnsafeRow(1);
                value.pointTo((Object)valueBytes, (long)Platform.BYTE_ARRAY_OFFSET, 16);
                value.setInt(0, 555);
                int s = 0;
                for (int i = 0; i < N; ++i) {
                    key.setInt(0, i % 1000);
                    if (!key.equals((Object)value)) continue;
                    ++s;
                }
            });
            benchmark.addCase("Java HashMap (Long)", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$28 -> {
                int i;
                byte[] keyBytes = new byte[16];
                byte[] valueBytes = new byte[16];
                UnsafeRow value = new UnsafeRow(1);
                value.pointTo((Object)valueBytes, (long)Platform.BYTE_ARRAY_OFFSET, 16);
                value.setInt(0, 555);
                HashMap<Long, UnsafeRow> map = new HashMap<Long, UnsafeRow>();
                for (i = 0; i < 65536; ++i) {
                    value.setInt(0, i);
                    map.put(BoxesRunTime.boxToLong((long)i), value);
                }
                int s = 0;
                for (i = 0; i < N; ++i) {
                    if (map.get(BoxesRunTime.boxToInteger((int)(i % 100000))) == null) continue;
                    ++s;
                }
            });
            benchmark.addCase("Java HashMap (two ints) ", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$29 -> {
                int i;
                byte[] valueBytes = new byte[16];
                UnsafeRow value = new UnsafeRow(1);
                value.pointTo((Object)valueBytes, (long)Platform.BYTE_ARRAY_OFFSET, 16);
                value.setInt(0, 555);
                HashMap<Long, UnsafeRow> map = new HashMap<Long, UnsafeRow>();
                for (i = 0; i < 65536; ++i) {
                    value.setInt(0, i);
                    long key = ((long)i << 32) + (long)Integer.rotateRight(i, 15);
                    map.put(BoxesRunTime.boxToLong((long)key), value);
                }
                int s = 0;
                for (i = 0; i < N; ++i) {
                    long key = ((long)(i & 0x186A0) << 32) + (long)Integer.rotateRight(i & 0x186A0, 15);
                    if (map.get(BoxesRunTime.boxToLong((long)key)) == null) continue;
                    ++s;
                }
            });
            benchmark.addCase("Java HashMap (UnsafeRow)", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$30 -> {
                int i;
                byte[] keyBytes = new byte[16];
                byte[] valueBytes = new byte[16];
                UnsafeRow key = new UnsafeRow(1);
                key.pointTo((Object)keyBytes, (long)Platform.BYTE_ARRAY_OFFSET, 16);
                UnsafeRow value = new UnsafeRow(1);
                value.pointTo((Object)valueBytes, (long)Platform.BYTE_ARRAY_OFFSET, 16);
                value.setInt(0, 555);
                HashMap<UnsafeRow, UnsafeRow> map = new HashMap<UnsafeRow, UnsafeRow>();
                for (i = 0; i < 65536; ++i) {
                    key.setInt(0, i);
                    value.setInt(0, i);
                    map.put(key, value.copy());
                }
                int s = 0;
                for (i = 0; i < N; ++i) {
                    key.setInt(0, i % 100000);
                    if (map.get(key) == null) continue;
                    ++s;
                }
            });
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)optimized -> {
                benchmark.addCase(new StringBuilder(25).append("LongToUnsafeRowMap (opt=").append(BoxesRunTime.unboxToBoolean((Object)optimized)).append(")").toString(), benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$31 -> {
                    int i;
                    byte[] valueBytes = new byte[16];
                    UnsafeRow value = new UnsafeRow(1);
                    value.pointTo((Object)valueBytes, (long)Platform.BYTE_ARRAY_OFFSET, 16);
                    value.setInt(0, 555);
                    TaskMemoryManager taskMemoryManager = new TaskMemoryManager((MemoryManager)new UnifiedMemoryManager(new SparkConf().set(package$.MODULE$.MEMORY_OFFHEAP_ENABLED().key(), "false"), Long.MAX_VALUE, 0x3FFFFFFFFFFFFFFFL, 1), 0L);
                    LongToUnsafeRowMap map = new LongToUnsafeRowMap(taskMemoryManager, 64, LongToUnsafeRowMap$.MODULE$.$lessinit$greater$default$3());
                    for (i = 0; i < 65536; ++i) {
                        value.setInt(0, i);
                        int key = i % 100000;
                        map.append((long)key, value);
                    }
                    if (optimized) {
                        map.optimize();
                    }
                    int s = 0;
                    for (i = 0; i < N$9; ++i) {
                        int key = i % 100000;
                        if (map.getValue((long)key, value) == null) continue;
                        ++s;
                    }
                });
                return BoxedUnit.UNIT;
            });
            ((IterableLike)new .colon.colon((Object)"off", (List)new .colon.colon((Object)"on", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)heap -> {
                benchmark.addCase(new StringBuilder(23).append("BytesToBytesMap (").append(heap).append(" Heap)").toString(), benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$32 -> {
                    int i;
                    String string = heap;
                    String string2 = "off";
                    TaskMemoryManager taskMemoryManager = new TaskMemoryManager((MemoryManager)new UnifiedMemoryManager(new SparkConf().set(package$.MODULE$.MEMORY_OFFHEAP_ENABLED().key(), String.valueOf(BoxesRunTime.boxToBoolean((!(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0))).set(package$.MODULE$.MEMORY_OFFHEAP_SIZE().key(), "102400000"), Long.MAX_VALUE, 0x3FFFFFFFFFFFFFFFL, 1), 0L);
                    BytesToBytesMap map = new BytesToBytesMap(taskMemoryManager, 1024, 0x4000000L);
                    byte[] keyBytes = new byte[16];
                    byte[] valueBytes = new byte[16];
                    UnsafeRow key = new UnsafeRow(1);
                    key.pointTo((Object)keyBytes, (long)Platform.BYTE_ARRAY_OFFSET, 16);
                    UnsafeRow value = new UnsafeRow(1);
                    value.pointTo((Object)valueBytes, (long)Platform.BYTE_ARRAY_OFFSET, 16);
                    int numKeys = 65536;
                    for (i = 0; i < numKeys; ++i) {
                        key.setInt(0, i % 65536);
                        BytesToBytesMap.Location loc = map.lookup(key.getBaseObject(), key.getBaseOffset(), key.getSizeInBytes(), Murmur3_x86_32.hashLong((long)(i % 65536), (int)42));
                        Object object = !loc.isDefined() ? BoxesRunTime.boxToBoolean((boolean)loc.append(key.getBaseObject(), key.getBaseOffset(), key.getSizeInBytes(), value.getBaseObject(), value.getBaseOffset(), value.getSizeInBytes())) : BoxedUnit.UNIT;
                    }
                    int s = 0;
                    for (i = 0; i < N$9; ++i) {
                        key.setInt(0, i % 100000);
                        BytesToBytesMap.Location loc = map.lookup(key.getBaseObject(), key.getBaseOffset(), key.getSizeInBytes(), Murmur3_x86_32.hashLong((long)(i % 100000), (int)42));
                        if (!loc.isDefined()) continue;
                        ++s;
                    }
                });
                return BoxedUnit.UNIT;
            });
            benchmark.addCase("Aggregate HashMap", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$33 -> {
                int i;
                int numKeys = 65536;
                StructType schema = new StructType().add("key", (DataType)LongType$.MODULE$).add("value", (DataType)LongType$.MODULE$);
                AggregateHashMap map = new AggregateHashMap(schema);
                for (i = 0; i < numKeys; ++i) {
                    MutableColumnarRow row = map.findOrInsert((long)i);
                    row.setLong(1, row.getLong(1) + 1L);
                }
                int s = 0;
                for (i = 0; i < N; ++i) {
                    if (map.find((long)(i % 100000)) == -1) continue;
                    ++s;
                }
            });
            benchmark.run();
        });
    }

    private static final void f$1(int N$3) {
        MODULE$.DatasetToBenchmark(MODULE$.spark().range((long)N$3).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(id & 65535) as k"})).groupBy("k", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).sum((Seq)Nil$.MODULE$)).noop();
    }

    private static final void f$2() {
        MODULE$.DatasetToBenchmark(MODULE$.spark().sql("select k, k, sum(id) from test group by k, k")).noop();
    }

    private static final void f$3(int N$4) {
        MODULE$.DatasetToBenchmark(MODULE$.spark().range((long)N$4).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "cast(id & 1023 as string) as k"})).groupBy("k", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count()).noop();
    }

    private static final void f$4(int N$5) {
        MODULE$.DatasetToBenchmark(MODULE$.spark().range((long)N$5).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "cast(id & 65535 as decimal) as k"})).groupBy("k", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count()).noop();
    }

    private static final void f$5(int N$6) {
        MODULE$.DatasetToBenchmark(MODULE$.spark().range((long)N$6).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "(id & 1023) as k1", "cast(id & 1023 as string) as k2", "cast(id & 1023 as int) as k3", "cast(id & 1023 as double) as k4", "cast(id & 1023 as float) as k5", "id > 1023 as k6"})).groupBy("k1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k2", "k3", "k4", "k5", "k6"})).sum((Seq)Nil$.MODULE$)).noop();
    }

    private static final void f$6(int N$7) {
        MODULE$.DatasetToBenchmark(MODULE$.spark().range((long)N$7).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "(id & 1023) as k1", "cast(id & 1023 as double) as k2", "cast(id & 1023 as int) as k3", "case when id > 100 and id <= 200 then 1 else 0 end as v1", "case when id > 200 and id <= 300 then 1 else 0 end as v2", "case when id > 300 and id <= 400 then 1 else 0 end as v3", "case when id > 400 and id <= 500 then 1 else 0 end as v4", "case when id > 500 and id <= 600 then 1 else 0 end as v5", "case when id > 600 and id <= 700 then 1 else 0 end as v6", "case when id > 700 and id <= 800 then 1 else 0 end as v7", "case when id > 800 and id <= 900 then 1 else 0 end as v8", "case when id > 900 and id <= 1000 then 1 else 0 end as v9", "case when id > 1000 and id <= 1100 then 1 else 0 end as v10", "case when id > 1100 and id <= 1200 then 1 else 0 end as v11", "case when id > 1200 and id <= 1300 then 1 else 0 end as v12", "case when id > 1300 and id <= 1400 then 1 else 0 end as v13", "case when id > 1400 and id <= 1500 then 1 else 0 end as v14", "case when id > 1500 and id <= 1600 then 1 else 0 end as v15", "case when id > 1600 and id <= 1700 then 1 else 0 end as v16", "case when id > 1700 and id <= 1800 then 1 else 0 end as v17", "case when id > 1800 and id <= 1900 then 1 else 0 end as v18"})).groupBy("k1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k2", "k3"})).sum((Seq)Nil$.MODULE$)).noop();
    }

    private AggregateBenchmark$() {
        MODULE$ = this;
        SQLHelper.$init$((SQLHelper)this);
        SqlBasedBenchmark.$init$(this);
    }
}

