/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001q4Qa\u0004\t\u0002\u0002uAQA\t\u0001\u0005\u0002\rBQA\n\u0001\u0007\u0012\u001dBQa\u000f\u0001\u0007\u0012qBQa\u0010\u0001\u0007\u0012\u00013A!\u0012\u0001\u0006\r\"A!*\u0002B\u0001B\u0003%1\nC\u0003#\u000b\u0011\u0005\u0011\rC\u0003f\u000b\u0011\u0005a\rC\u0004m\u0001\u0005\u0005I1B7\u0007\t=\u0004Q\u0001\u001d\u0005\t\u0015*\u0011\t\u0011)A\u0005c\")!E\u0003C\u0001i\")qO\u0003C\u0001q\"9\u0011\u0010AA\u0001\n\u0017Q(AG\"iK\u000e\\\u0007o\\5oi\u001aKG.Z'b]\u0006<WM\u001d+fgR\u001c(BA\t\u0013\u0003%\u0019HO]3b[&twM\u0003\u0002\u0014)\u0005IQ\r_3dkRLwN\u001c\u0006\u0003+Y\t1a]9m\u0015\t9\u0002$A\u0003ta\u0006\u00148N\u0003\u0002\u001a5\u00051\u0011\r]1dQ\u0016T\u0011aG\u0001\u0004_J<7\u0001A\n\u0003\u0001y\u0001\"a\b\u0011\u000e\u0003YI!!\t\f\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f\u0003\u0019a\u0014N\\5u}Q\tA\u0005\u0005\u0002&\u00015\t\u0001#\u0001\nxSRDG+Z7q\u0011\u0006$wn\u001c9QCRDGC\u0001\u0015/!\tIC&D\u0001+\u0015\u0005Y\u0013!B:dC2\f\u0017BA\u0017+\u0005\u0011)f.\u001b;\t\u000b=\u0012\u0001\u0019\u0001\u0019\u0002\u0003A\u0004B!K\u00194Q%\u0011!G\u000b\u0002\n\rVt7\r^5p]F\u0002\"\u0001N\u001d\u000e\u0003UR!AN\u001c\u0002\u0005\u0019\u001c(B\u0001\u001d\u0019\u0003\u0019A\u0017\rZ8pa&\u0011!(\u000e\u0002\u0005!\u0006$\b.\u0001\u000bdQ\u0016\u001c7\u000eT3bW&twm\u0011:d\r&dWm\u001d\u000b\u0003QuBQAP\u0002A\u0002M\nA\u0001]1uQ\u0006i1M]3bi\u0016l\u0015M\\1hKJ$\"!\u0011#\u0011\u0005\u0015\u0012\u0015BA\"\u0011\u0005U\u0019\u0005.Z2la>Lg\u000e\u001e$jY\u0016l\u0015M\\1hKJDQA\u0010\u0003A\u0002M\u0012QCU5dQ\u000e\u000bgnY3mY\u0006\u0014G.Z*ue\u0016\fWn\u0005\u0002\u0006\u000fB\u0011\u0011\u0006S\u0005\u0003\u0013*\u0012a!\u00118z%\u00164\u0017AB:ue\u0016\fW\u000e\u0005\u0002M=:\u0011Q\n\u0018\b\u0003\u001dns!a\u0014.\u000f\u0005AKfBA)Y\u001d\t\u0011vK\u0004\u0002T-6\tAK\u0003\u0002V9\u00051AH]8pizJ\u0011aG\u0005\u00033iI!a\u0006\r\n\u0005U1\u0012BA\n\u0015\u0013\t\t\"#\u0003\u0002^!\u0005)2\t[3dWB|\u0017N\u001c;GS2,W*\u00198bO\u0016\u0014\u0018BA0a\u0005u\u0019\u0015M\\2fY2\f'\r\\3G'\u0012\u000bG/Y(viB,Ho\u0015;sK\u0006l'BA/\u0011)\t\u0011G\r\u0005\u0002d\u000b5\t\u0001\u0001C\u0003K\u000f\u0001\u00071*\u0001\u0007xe&$XmQ8oi\u0016tG\u000f\u0006\u0002LO\")\u0001\u000e\u0003a\u0001S\u0006\t\u0011\u000e\u0005\u0002*U&\u00111N\u000b\u0002\u0004\u0013:$\u0018!\u0006*jG\"\u001c\u0015M\\2fY2\f'\r\\3TiJ,\u0017-\u001c\u000b\u0003E:DQAS\u0005A\u0002-\u0013QCU5dQ\u001a\u001bF)\u0019;b\u0013:\u0004X\u000f^*ue\u0016\fWn\u0005\u0002\u000b\u000fB\u0011AG]\u0005\u0003gV\u0012\u0011CR*ECR\f\u0017J\u001c9viN#(/Z1n)\t)h\u000f\u0005\u0002d\u0015!)!\n\u0004a\u0001c\u0006Y!/Z1e\u0007>tG/\u001a8u)\u0005I\u0017!\u0006*jG\"45\u000bR1uC&s\u0007/\u001e;TiJ,\u0017-\u001c\u000b\u0003knDQA\u0013\bA\u0002E\u0004")
public abstract class CheckpointFileManagerTests
extends SparkFunSuite {
    public abstract void withTempHadoopPath(Function1<Path, BoxedUnit> var1);

    public abstract void checkLeakingCrcFiles(Path var1);

    public abstract CheckpointFileManager createManager(Path var1);

    private RichCancellableStream RichCancellableStream(CheckpointFileManager.CancellableFSDataOutputStream stream) {
        return new RichCancellableStream(this, stream);
    }

    private RichFSDataInputStream RichFSDataInputStream(FSDataInputStream stream) {
        return new RichFSDataInputStream(this, stream);
    }

    public static final /* synthetic */ boolean $anonfun$new$3(FileStatus x$1) {
        String string = x$1.getPath().getName();
        String string2 = "dir";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$new$2(CheckpointFileManagerTests $this, Path x0$1) {
        Path path = x0$1;
        CheckpointFileManager fm = $this.createManager(path);
        Path dir = new Path(new StringBuilder(21).append(path).append("/dir/subdir/subsubdir").toString());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(fm.exists(dir), "fm.exists(dir)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        fm.mkdirs(dir);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(fm.exists(dir), "fm.exists(dir)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        fm.mkdirs(dir);
        PathFilter acceptAllFilter = new PathFilter(null){

            public boolean accept(Path path) {
                return true;
            }
        };
        PathFilter rejectAllFilter = new PathFilter(null){

            public boolean accept(Path path) {
                return false;
            }
        };
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fm.list(path, acceptAllFilter))).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CheckpointFileManagerTests.$anonfun$new$3(x$1))), "scala.Predef.refArrayOps[org.apache.hadoop.fs.FileStatus](fm.list(basePath, acceptAllFilter)).exists(((x$1: org.apache.hadoop.fs.FileStatus) => x$1.getPath().getName().==(\"dir\")))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)fm.list(path, rejectAllFilter).length));
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        ObjectRef path2 = ObjectRef.create((Object)new Path(new StringBuilder(5).append(dir).append("/file").toString()));
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(fm.exists((Path)path2.elem), "fm.exists(path)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        $this.RichCancellableStream(fm.createAtomic((Path)path2.elem, false)).writeContent(1).cancel();
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(fm.exists((Path)path2.elem), "fm.exists(path)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        $this.RichCancellableStream(fm.createAtomic((Path)path2.elem, false)).writeContent(2).close();
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(fm.exists((Path)path2.elem), "fm.exists(path)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
        int $org_scalatest_assert_macro_left2 = $this.RichFSDataInputStream(fm.open((Path)path2.elem)).readContent();
        int $org_scalatest_assert_macro_right2 = 2;
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        package$.MODULE$.quietly((Function0 & Serializable & scala.Serializable)() -> (IOException)$this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.RichCancellableStream(fm.createAtomic((Path)path$1.elem, false)).writeContent(3).close(), ClassTag$.MODULE$.apply(IOException.class), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86)));
        int $org_scalatest_assert_macro_left3 = $this.RichFSDataInputStream(fm.open((Path)path2.elem)).readContent();
        int $org_scalatest_assert_macro_right3 = 2;
        Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        path2.elem = new Path(new StringBuilder(6).append(dir).append("/file2").toString());
        Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(fm.exists((Path)path2.elem), "fm.exists(path)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        $this.RichCancellableStream(fm.createAtomic((Path)path2.elem, true)).writeContent(4).cancel();
        Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(fm.exists((Path)path2.elem), "fm.exists(path)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        $this.RichCancellableStream(fm.createAtomic((Path)path2.elem, true)).writeContent(5).close();
        Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(fm.exists((Path)path2.elem), "fm.exists(path)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        int $org_scalatest_assert_macro_left4 = $this.RichFSDataInputStream(fm.open((Path)path2.elem)).readContent();
        int $org_scalatest_assert_macro_right4 = 5;
        Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        $this.RichCancellableStream(fm.createAtomic((Path)path2.elem, true)).writeContent(6).close();
        int $org_scalatest_assert_macro_left5 = $this.RichFSDataInputStream(fm.open((Path)path2.elem)).readContent();
        int $org_scalatest_assert_macro_right5 = 6;
        Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        $this.checkLeakingCrcFiles(dir);
        fm.open((Path)path2.elem).close();
        fm.delete((Path)path2.elem);
        Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(fm.exists((Path)path2.elem), "fm.exists(path)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        $this.intercept((Function0 & Serializable & scala.Serializable)() -> fm.open((Path)path$1.elem), ClassTag$.MODULE$.apply(IOException.class), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        fm.delete((Path)path2.elem);
    }

    public CheckpointFileManagerTests() {
        this.test("mkdirs, list, createAtomic, open, delete, exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempHadoopPath((Function1<Path, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x0$1 -> {
            CheckpointFileManagerTests.$anonfun$new$2(this, x0$1);
            return BoxedUnit.UNIT;
        }), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
    }

    private class RichCancellableStream {
        private final CheckpointFileManager.CancellableFSDataOutputStream stream;
        public final /* synthetic */ CheckpointFileManagerTests $outer;

        public CheckpointFileManager.CancellableFSDataOutputStream writeContent(int i) {
            this.stream.writeInt(i);
            return this.stream;
        }

        public /* synthetic */ CheckpointFileManagerTests org$apache$spark$sql$execution$streaming$CheckpointFileManagerTests$RichCancellableStream$$$outer() {
            return this.$outer;
        }

        public RichCancellableStream(CheckpointFileManagerTests $outer, CheckpointFileManager.CancellableFSDataOutputStream stream) {
            this.stream = stream;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    private class RichFSDataInputStream {
        private final FSDataInputStream stream;
        public final /* synthetic */ CheckpointFileManagerTests $outer;

        public int readContent() {
            int res = this.stream.readInt();
            this.stream.close();
            return res;
        }

        public /* synthetic */ CheckpointFileManagerTests org$apache$spark$sql$execution$streaming$CheckpointFileManagerTests$RichFSDataInputStream$$$outer() {
            return this.$outer;
        }

        public RichFSDataInputStream(CheckpointFileManagerTests $outer, FSDataInputStream stream) {
            this.stream = stream;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

