/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.test.TestSparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JavaColumnExpressionSuite {
    private transient TestSparkSession spark;

    @Before
    public void setUp() {
        this.spark = new TestSparkSession();
    }

    @After
    public void tearDown() {
        this.spark.stop();
        this.spark = null;
    }

    @Test
    public void isInCollectionWorksCorrectlyOnJava() {
        List<Row> rows = Arrays.asList(RowFactory.create((Object[])new Object[]{1, "x"}), RowFactory.create((Object[])new Object[]{2, "y"}), RowFactory.create((Object[])new Object[]{3, "z"}));
        StructType schema = DataTypes.createStructType(Arrays.asList(DataTypes.createStructField((String)"a", (DataType)DataTypes.IntegerType, (boolean)false), DataTypes.createStructField((String)"b", (DataType)DataTypes.StringType, (boolean)false)));
        Dataset df = this.spark.createDataFrame(rows, schema);
        Assert.assertArrayEquals((Object[])((Row[])df.filter(df.col("a").isInCollection(Arrays.asList(1, 2))).collect()), (Object[])((Row[])df.filter((FilterFunction & Serializable)r -> r.getInt(0) == 1 || r.getInt(0) == 2).collect()));
        Assert.assertArrayEquals((Object[])((Row[])df.filter(df.col("a").isInCollection(new HashSet<Integer>(Arrays.asList(1, 2)))).collect()), (Object[])((Row[])df.filter((FilterFunction & Serializable)r -> r.getInt(0) == 1 || r.getInt(0) == 2).collect()));
        Assert.assertArrayEquals((Object[])((Row[])df.filter(df.col("a").isInCollection(new ArrayList<Integer>(Arrays.asList(3, 1)))).collect()), (Object[])((Row[])df.filter((FilterFunction & Serializable)r -> r.getInt(0) == 3 || r.getInt(0) == 1).collect()));
    }

    @Test
    public void isInCollectionCheckExceptionMessage() {
        List<Row> rows = Arrays.asList(RowFactory.create((Object[])new Object[]{1, Arrays.asList(1)}), RowFactory.create((Object[])new Object[]{2, Arrays.asList(2)}), RowFactory.create((Object[])new Object[]{3, Arrays.asList(3)}));
        StructType schema = DataTypes.createStructType(Arrays.asList(DataTypes.createStructField((String)"a", (DataType)DataTypes.IntegerType, (boolean)false), DataTypes.createStructField((String)"b", (DataType)DataTypes.createArrayType((DataType)DataTypes.IntegerType, (boolean)false), (boolean)false)));
        Dataset df = this.spark.createDataFrame(rows, schema);
        AnalysisException e = (AnalysisException)Assert.assertThrows(AnalysisException.class, () -> df.filter(df.col("a").isInCollection(Arrays.asList(new Column("b")))));
        Assert.assertTrue((boolean)e.getErrorClass().equals("DATATYPE_MISMATCH.DATA_DIFF_TYPES"));
        HashMap<String, String> messageParameters = new HashMap<String, String>();
        messageParameters.put("functionName", "`in`");
        messageParameters.put("dataType", "[\"INT\", \"ARRAY<INT>\"]");
        messageParameters.put("sqlExpr", "\"(a IN (b))\"");
        Assert.assertTrue((boolean)Maps.difference((Map)e.getMessageParameters(), messageParameters).areEqual());
    }
}

