/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.text;

import java.io.Closeable;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.UnsafeRowWriter;
import org.apache.spark.sql.catalyst.util.CompressionCodecs$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.CodecStreams$;
import org.apache.spark.sql.execution.datasources.HadoopFileLinesReader;
import org.apache.spark.sql.execution.datasources.HadoopFileWholeTextReader;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.TextBasedFileFormat;
import org.apache.spark.sql.execution.datasources.text.TextOptions;
import org.apache.spark.sql.execution.datasources.text.TextOutputWriter;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015f\u0001B\u0006\r\u0001mAQA\n\u0001\u0005\u0002\u001dBQA\u000b\u0001\u0005B-BQ!\u000f\u0001\u0005B-BQA\u000f\u0001\u0005\nmBQ\u0001\u0013\u0001\u0005B%CQA\u0019\u0001\u0005B\rDQa\u001e\u0001\u0005BaDq!!\u0005\u0001\t\u0003\n\u0019\u0002C\u0004\u0002^\u0001!I!a\u0018\t\u000f\u0005]\u0005\u0001\"\u0011\u0002\u001a\nqA+\u001a=u\r&dWMR8s[\u0006$(BA\u0007\u000f\u0003\u0011!X\r\u001f;\u000b\u0005=\u0001\u0012a\u00033bi\u0006\u001cx.\u001e:dKNT!!\u0005\n\u0002\u0013\u0015DXmY;uS>t'BA\n\u0015\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003+Y\tQa\u001d9be.T!a\u0006\r\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0012aA8sO\u000e\u00011c\u0001\u0001\u001dAA\u0011QDH\u0007\u0002\u001d%\u0011qD\u0004\u0002\u0014)\u0016DHOQ1tK\u00124\u0015\u000e\\3G_Jl\u0017\r\u001e\t\u0003C\u0011j\u0011A\t\u0006\u0003GI\tqa]8ve\u000e,7/\u0003\u0002&E\t\u0011B)\u0019;b'>,(oY3SK\u001eL7\u000f^3s\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0006\u0005\u0002*\u00015\tA\"A\u0005tQ>\u0014HOT1nKR\tA\u0006\u0005\u0002.m9\u0011a\u0006\u000e\t\u0003_Ij\u0011\u0001\r\u0006\u0003ci\ta\u0001\u0010:p_Rt$\"A\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0012\u0014A\u0002)sK\u0012,g-\u0003\u00028q\t11\u000b\u001e:j]\u001eT!!\u000e\u001a\u0002\u0011Q|7\u000b\u001e:j]\u001e\fAB^3sS\u001aL8k\u00195f[\u0006$\"\u0001\u0010!\u0011\u0005urT\"\u0001\u001a\n\u0005}\u0012$\u0001B+oSRDQ!\u0011\u0003A\u0002\t\u000baa]2iK6\f\u0007CA\"G\u001b\u0005!%BA#\u0013\u0003\u0015!\u0018\u0010]3t\u0013\t9EI\u0001\u0006TiJ,8\r\u001e+za\u0016\f1\"[:Ta2LG/\u00192mKR!!*T*Y!\ti4*\u0003\u0002Me\t9!i\\8mK\u0006t\u0007\"\u0002(\u0006\u0001\u0004y\u0015\u0001D:qCJ\\7+Z:tS>t\u0007C\u0001)R\u001b\u0005\u0011\u0012B\u0001*\u0013\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0011\u0015!V\u00011\u0001V\u0003\u001dy\u0007\u000f^5p]N\u0004B!\f,-Y%\u0011q\u000b\u000f\u0002\u0004\u001b\u0006\u0004\b\"B-\u0006\u0001\u0004Q\u0016\u0001\u00029bi\"\u0004\"a\u00171\u000e\u0003qS!!\u00180\u0002\u0005\u0019\u001c(BA0\u0017\u0003\u0019A\u0017\rZ8pa&\u0011\u0011\r\u0018\u0002\u0005!\u0006$\b.A\u0006j]\u001a,'oU2iK6\fG\u0003\u00023hQ&\u00042!P3C\u0013\t1'G\u0001\u0004PaRLwN\u001c\u0005\u0006\u001d\u001a\u0001\ra\u0014\u0005\u0006)\u001a\u0001\r!\u0016\u0005\u0006U\u001a\u0001\ra[\u0001\u0006M&dWm\u001d\t\u0004YF$hBA7p\u001d\tyc.C\u00014\u0013\t\u0001('A\u0004qC\u000e\\\u0017mZ3\n\u0005I\u001c(aA*fc*\u0011\u0001O\r\t\u00037VL!A\u001e/\u0003\u0015\u0019KG.Z*uCR,8/\u0001\u0007qe\u0016\u0004\u0018M]3Xe&$X\rF\u0004zyv\fY!!\u0004\u0011\u0005uQ\u0018BA>\u000f\u0005MyU\u000f\u001e9vi^\u0013\u0018\u000e^3s\r\u0006\u001cGo\u001c:z\u0011\u0015qu\u00011\u0001P\u0011\u0015qx\u00011\u0001\u0000\u0003\rQwN\u0019\t\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011Q\u00010\u0002\u00135\f\u0007O]3ek\u000e,\u0017\u0002BA\u0005\u0003\u0007\u00111AS8c\u0011\u0015!v\u00011\u0001V\u0011\u0019\tya\u0002a\u0001\u0005\u0006QA-\u0019;b'\u000eDW-\\1\u0002\u0017\t,\u0018\u000e\u001c3SK\u0006$WM\u001d\u000b\u0011\u0003+\t\u0019$!\u000e\u00028\u0005m\u0012qHA&\u0003\u001b\u0002r!PA\f\u00037\t\t#C\u0002\u0002\u001aI\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0007u\ti\"C\u0002\u0002 9\u0011q\u0002U1si&$\u0018n\u001c8fI\u001aKG.\u001a\t\u0006Y\u0006\r\u0012qE\u0005\u0004\u0003K\u0019(\u0001C%uKJ\fGo\u001c:\u0011\t\u0005%\u0012qF\u0007\u0003\u0003WQ1!!\f\u0013\u0003!\u0019\u0017\r^1msN$\u0018\u0002BA\u0019\u0003W\u00111\"\u00138uKJt\u0017\r\u001c*po\")a\n\u0003a\u0001\u001f\"1\u0011q\u0002\u0005A\u0002\tCa!!\u000f\t\u0001\u0004\u0011\u0015a\u00049beRLG/[8o'\u000eDW-\\1\t\r\u0005u\u0002\u00021\u0001C\u00039\u0011X-];je\u0016$7k\u00195f[\u0006Dq!!\u0011\t\u0001\u0004\t\u0019%A\u0004gS2$XM]:\u0011\t1\f\u0018Q\t\t\u0004C\u0005\u001d\u0013bAA%E\t1a)\u001b7uKJDQ\u0001\u0016\u0005A\u0002UCq!a\u0014\t\u0001\u0004\t\t&\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\u0004B!a\u0015\u0002Z5\u0011\u0011Q\u000b\u0006\u0004\u0003/r\u0016\u0001B2p]\u001aLA!a\u0017\u0002V\ti1i\u001c8gS\u001e,(/\u0019;j_:\fqB]3bIR{WK\\:bM\u0016lU-\u001c\u000b\t\u0003C\n\t(a#\u0002\u000eB9Q(a\u0006\u0002\u001c\u0005\r\u0004#\u00027\u0002$\u0005\u0015\u0004\u0003BA4\u0003[j!!!\u001b\u000b\t\u0005-\u00141F\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0003\u0002p\u0005%$!C+og\u00064WMU8x\u0011\u001d\t9&\u0003a\u0001\u0003g\u0002b!!\u001e\u0002|\u0005}TBAA<\u0015\r\tI\bF\u0001\nEJ|\u0017\rZ2bgRLA!! \u0002x\tI!I]8bI\u000e\f7\u000f\u001e\t\u0005\u0003\u0003\u000b9)\u0004\u0002\u0002\u0004*\u0019\u0011Q\u0011\u000b\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u0013\u000b\u0019IA\rTKJL\u0017\r\\5{C\ndWmQ8oM&<WO]1uS>t\u0007BBA\u001f\u0013\u0001\u0007!\tC\u0004\u0002\u0010&\u0001\r!!%\u0002\u0017Q,\u0007\u0010^(qi&|gn\u001d\t\u0004S\u0005M\u0015bAAK\u0019\tYA+\u001a=u\u001fB$\u0018n\u001c8t\u0003=\u0019X\u000f\u001d9peR$\u0015\r^1UsB,Gc\u0001&\u0002\u001c\"9\u0011Q\u0014\u0006A\u0002\u0005}\u0015\u0001\u00033bi\u0006$\u0016\u0010]3\u0011\u0007\r\u000b\t+C\u0002\u0002$\u0012\u0013\u0001\u0002R1uCRK\b/\u001a")
public class TextFileFormat
extends TextBasedFileFormat
implements DataSourceRegister {
    @Override
    public String shortName() {
        return "text";
    }

    public String toString() {
        return "Text";
    }

    private void verifySchema(StructType schema) {
        if (schema.size() != 1) {
            throw QueryCompilationErrors$.MODULE$.textDataSourceWithMultiColumnsError(schema);
        }
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        TextOptions textOptions = new TextOptions(options);
        return super.isSplitable(sparkSession, options, path) && !textOptions.wholeText();
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        return new Some((Object)new StructType().add("value", (DataType)StringType$.MODULE$));
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        this.verifySchema(dataSchema);
        TextOptions textOptions = new TextOptions(options);
        Configuration conf = job.getConfiguration();
        textOptions.compressionCodec().foreach((Function1 & Serializable & scala.Serializable)codec -> {
            CompressionCodecs$.MODULE$.setCodecConfiguration(conf, codec);
            return BoxedUnit.UNIT;
        });
        return new OutputWriterFactory(null, textOptions){
            private final TextOptions textOptions$1;

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new TextOutputWriter(path, dataSchema, this.textOptions$1.lineSeparatorInWrite(), context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder(4).append(".txt").append(CodecStreams$.MODULE$.getCompressionExtension((JobContext)context)).toString();
            }
            {
                this.textOptions$1 = textOptions$1;
            }
        };
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        Predef$.MODULE$.assert(requiredSchema.length() <= 1, (Function0 & Serializable & scala.Serializable)() -> "Text data source only produces a single data column named \"value\".");
        TextOptions textOptions = new TextOptions(options);
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        return this.readToUnsafeMem((Broadcast<SerializableConfiguration>)broadcastedHadoopConf, requiredSchema, textOptions);
    }

    private Function1<PartitionedFile, Iterator<UnsafeRow>> readToUnsafeMem(Broadcast<SerializableConfiguration> conf, StructType requiredSchema, TextOptions textOptions) {
        return (Function1 & Serializable & scala.Serializable)file -> {
            Configuration confValue = ((SerializableConfiguration)conf.value()).value();
            Closeable reader = !textOptions.wholeText() ? new HadoopFileLinesReader((PartitionedFile)file, textOptions.lineSeparatorInRead(), confValue) : new HadoopFileWholeTextReader((PartitionedFile)file, confValue);
            Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach(arg_0 -> TextFileFormat.$anonfun$readToUnsafeMem$2((Iterator)reader, arg_0));
            if (requiredSchema.isEmpty()) {
                UnsafeRow emptyUnsafeRow = new UnsafeRow(0);
                return reader.map((Function1 & Serializable & scala.Serializable)x$3 -> emptyUnsafeRow);
            }
            UnsafeRowWriter unsafeRowWriter = new UnsafeRowWriter(1);
            return reader.map((Function1 & Serializable & scala.Serializable)line -> {
                unsafeRowWriter.reset();
                unsafeRowWriter.write(0, line.getBytes(), 0, line.getLength());
                return unsafeRowWriter.getRow();
            });
        };
    }

    @Override
    public boolean supportDataType(DataType dataType) {
        DataType dataType2 = dataType;
        StringType$ stringType$ = StringType$.MODULE$;
        return !(dataType2 != null ? !dataType2.equals(stringType$) : stringType$ != null);
    }

    public static final /* synthetic */ void $anonfun$readToUnsafeMem$3(Iterator reader$1, TaskContext x$2) {
        ((Closeable)reader$1).close();
    }

    public static final /* synthetic */ TaskContext $anonfun$readToUnsafeMem$2(Iterator reader$1, TaskContext x$1) {
        return x$1.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$2 -> {
            TextFileFormat.$anonfun$readToUnsafeMem$3(reader$1, x$2);
            return BoxedUnit.UNIT;
        });
    }
}

