/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager$;
import org.apache.spark.sql.execution.streaming.state.RocksDBCheckpointMetadata;
import org.apache.spark.sql.execution.streaming.state.RocksDBCheckpointMetadata$;
import org.apache.spark.sql.execution.streaming.state.RocksDBFileManager$;
import org.apache.spark.sql.execution.streaming.state.RocksDBFileManagerMetrics;
import org.apache.spark.sql.execution.streaming.state.RocksDBFileManagerMetrics$;
import org.apache.spark.sql.execution.streaming.state.RocksDBImmutableFile;
import org.apache.spark.sql.execution.streaming.state.RocksDBImmutableFile$;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangelogReader;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangelogWriter;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\tMg\u0001B\u001c9\u0001\u001dC\u0001\u0002\u0016\u0001\u0003\u0002\u0003\u0006I!\u0016\u0005\tA\u0002\u0011\t\u0011)A\u0005C\"A\u0011\u000e\u0001B\u0001B\u0003%!\u000e\u0003\u0005s\u0001\t\u0005\t\u0015!\u0003V\u0011!\u0019\bA!A!\u0002\u0013)\u0006\"\u0002;\u0001\t\u0003)\bbB?\u0001\u0005\u0004%IA \u0005\b\u0003[\u0001\u0001\u0015!\u0003\u0000\u0011)\ty\u0003\u0001b\u0001\n\u0003q\u0014\u0011\u0007\u0005\t\u0003k\u0001\u0001\u0015!\u0003\u00024!Q\u0011q\u0007\u0001\t\u0006\u0004%I!!\u000f\t\u0013\u0005\r\u0003A1A\u0005\n\u0005\u0015\u0003\u0002CA)\u0001\u0001\u0006I!a\u0012\t\u0013\u0005M\u0003A1A\u0005\n\u0005U\u0003\u0002CA/\u0001\u0001\u0006I!a\u0016\t\u0013\u0005E\u0004A1A\u0005\n\u0005M\u0004\u0002CA=\u0001\u0001\u0006I!!\u001e\t\u0015\u0005m\u0004\u0001#b\u0001\n\u0013\ti\bC\u0004\u0002\b\u0002!I!!#\t\u000f\u0005U\u0005\u0001\"\u0001\u0002\u0018\"9\u00111\u0015\u0001\u0005\u0002\u0005\u0015\u0006\"CAX\u0001\u0001\u0007I\u0011BAY\u0011%\tI\f\u0001a\u0001\n\u0013\tY\f\u0003\u0005\u0002H\u0002\u0001\u000b\u0015BAZ\u0011%\t\t\u000e\u0001a\u0001\n\u0013\t\t\fC\u0005\u0002T\u0002\u0001\r\u0011\"\u0003\u0002V\"A\u0011\u0011\u001c\u0001!B\u0013\t\u0019\fC\u0004\u0002^\u0002!\t!!-\t\u000f\u0005}\u0007\u0001\"\u0001\u00022\"9\u0011\u0011\u001d\u0001\u0005\u0002\u0005\r\bbBAx\u0001\u0011\u0005\u0011\u0011\u001f\u0005\b\u0003\u007f\u0004A\u0011\u0001B\u0001\u0011\u001d\u0011)\u0001\u0001C\u0001\u0005\u000fAqA!\u0003\u0001\t\u0003\u0011Y\u0001C\u0004\u0003 \u0001!IA!\t\t\u000f\t5\u0002\u0001\"\u0001\u00030!9!1\b\u0001\u0005\n\tu\u0002b\u0002B$\u0001\u0011%!\u0011\n\u0005\b\u0005#\u0002A\u0011\u0002B*\u0011\u001d\u00119\u0006\u0001C\u0005\u00053BqA!\u001b\u0001\t\u0013\u0011Y\u0007C\u0004\u0003v\u0001!IAa\u001e\t\u000f\tu\u0004\u0001\"\u0003\u0003\u0000!9!1\u0011\u0001\u0005\n\t\u0015\u0005b\u0002BE\u0001\u0011%!1\u0012\u0005\b\u0005#\u0003A\u0011\u000bBJ\u0011\u001d\u0011)\n\u0001C\u0005\u0005/CqA!(\u0001\t\u0013\u0011y\nC\u0004\u0003&\u0002!IAa*\b\u0013\tE\u0006(!A\t\u0002\tMf\u0001C\u001c9\u0003\u0003E\tA!.\t\rQ\u001cD\u0011\u0001B\\\u0011%\u0011IlMI\u0001\n\u0003\u0011Y\fC\u0005\u0003RN\n\n\u0011\"\u0001\u0003<\n\u0011\"k\\2lg\u0012\u0013e)\u001b7f\u001b\u0006t\u0017mZ3s\u0015\tI$(A\u0003ti\u0006$XM\u0003\u0002<y\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003{y\n\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005}\u0002\u0015aA:rY*\u0011\u0011IQ\u0001\u0006gB\f'o\u001b\u0006\u0003\u0007\u0012\u000ba!\u00199bG\",'\"A#\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Ae\n\u0005\u0002J\u00196\t!JC\u0001L\u0003\u0015\u00198-\u00197b\u0013\ti%J\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0003#\u0002\u000b\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003'B\u0013q\u0001T8hO&tw-\u0001\u0006eMN\u0014vn\u001c;ESJ\u0004\"AV/\u000f\u0005][\u0006C\u0001-K\u001b\u0005I&B\u0001.G\u0003\u0019a$o\\8u}%\u0011ALS\u0001\u0007!J,G-\u001a4\n\u0005y{&AB*ue&twM\u0003\u0002]\u0015\u0006aAn\\2bYR+W\u000e\u001d#jeB\u0011!mZ\u0007\u0002G*\u0011A-Z\u0001\u0003S>T\u0011AZ\u0001\u0005U\u00064\u0018-\u0003\u0002iG\n!a)\u001b7f\u0003)A\u0017\rZ8pa\u000e{gN\u001a\t\u0003WBl\u0011\u0001\u001c\u0006\u0003[:\fAaY8oM*\u0011qNQ\u0001\u0007Q\u0006$wn\u001c9\n\u0005Ed'!D\"p]\u001aLw-\u001e:bi&|g.A\u0005d_\u0012,7MT1nK\u0006IAn\\4hS:<\u0017\nZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\rYD\u0018P_>}!\t9\b!D\u00019\u0011\u0015!f\u00011\u0001V\u0011\u0015\u0001g\u00011\u0001b\u0011\u0015Ig\u00011\u0001k\u0011\u001d\u0011h\u0001%AA\u0002UCqa\u001d\u0004\u0011\u0002\u0003\u0007Q+A\u000bwKJ\u001c\u0018n\u001c8U_J{7m[:E\u0005\u001aKG.Z:\u0016\u0003}\u0004\u0002\"!\u0001\u0002\f\u0005=\u0011QC\u0007\u0003\u0003\u0007QA!!\u0002\u0002\b\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0007\u0005%Q-\u0001\u0003vi&d\u0017\u0002BA\u0007\u0003\u0007\u0011\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\rI\u0015\u0011C\u0005\u0004\u0003'Q%\u0001\u0002'p]\u001e\u0004b!a\u0006\u0002\"\u0005\u001db\u0002BA\r\u0003;q1\u0001WA\u000e\u0013\u0005Y\u0015bAA\u0010\u0015\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u0012\u0003K\u00111aU3r\u0015\r\tyB\u0013\t\u0004o\u0006%\u0012bAA\u0016q\t!\"k\\2lg\u0012\u0013\u0015*\\7vi\u0006\u0014G.\u001a$jY\u0016\faC^3sg&|g\u000eV8S_\u000e\\7\u000f\u0012\"GS2,7\u000fI\u0001\u0015Y>\u001c\u0017\r\u001c$jY\u0016\u001cHk\u001c#gg\u001aKG.Z:\u0016\u0005\u0005M\u0002cBA\u0001\u0003\u0017)\u0016qE\u0001\u0016Y>\u001c\u0017\r\u001c$jY\u0016\u001cHk\u001c#gg\u001aKG.Z:!\u0003\t1W.\u0006\u0002\u0002<A!\u0011QHA \u001b\u0005Q\u0014bAA!u\t)2\t[3dWB|\u0017N\u001c;GS2,W*\u00198bO\u0016\u0014\u0018A\u00014t+\t\t9\u0005\u0005\u0003\u0002J\u00055SBAA&\u0015\r\t\u0019E\\\u0005\u0005\u0003\u001f\nYE\u0001\u0006GS2,7+_:uK6\f1AZ:!\u00031yg\u000e\\=[SB4\u0015\u000e\\3t+\t\t9F\u0005\u0004\u0002Z\u0005}\u00131\u000e\u0004\u0007\u00037z\u0001!a\u0016\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0002\u001b=tG.\u001f.ja\u001aKG.Z:!!\u0011\t\t'a\u001a\u000e\u0005\u0005\r$bAA3K\u0006!A.\u00198h\u0013\u0011\tI'a\u0019\u0003\r=\u0013'.Z2u!\u0011\tI%!\u001c\n\t\u0005=\u00141\n\u0002\u000b!\u0006$\bNR5mi\u0016\u0014\u0018AE8oYf\u001c\u0005.\u00198hK2|wMR5mKN,\"!!\u001e\u0013\r\u0005]\u0014qLA6\r\u0019\tY&\u0005\u0001\u0002v\u0005\u0019rN\u001c7z\u0007\"\fgnZ3m_\u001e4\u0015\u000e\\3tA\u0005I1\u000f]1sW\u000e{gNZ\u000b\u0003\u0003\u007f\u0002B!!!\u0002\u00046\t\u0001)C\u0002\u0002\u0006\u0002\u0013\u0011b\u00159be.\u001cuN\u001c4\u0002\u000b\r|G-Z2\u0016\u0005\u0005-\u0005\u0003BAG\u0003#k!!a$\u000b\u0005\u0011\u0004\u0015\u0002BAJ\u0003\u001f\u0013\u0001cQ8naJ,7o]5p]\u000e{G-Z2\u0002%\u001d,Go\u00115b]\u001e,Gj\\4Xe&$XM\u001d\u000b\u0005\u00033\u000by\nE\u0002x\u00037K1!!(9\u0005e\u0019F/\u0019;f'R|'/Z\"iC:<W\r\\8h/JLG/\u001a:\t\u000f\u0005\u0005F\u00031\u0001\u0002\u0010\u00059a/\u001a:tS>t\u0017AE4fi\u000eC\u0017M\\4fY><'+Z1eKJ$B!a*\u0002.B\u0019q/!+\n\u0007\u0005-\u0006HA\rTi\u0006$Xm\u0015;pe\u0016\u001c\u0005.\u00198hK2|wMU3bI\u0016\u0014\bbBAQ+\u0001\u0007\u0011qB\u0001\u0016Y>\fGm\u00115fG.\u0004x.\u001b8u\u001b\u0016$(/[2t+\t\t\u0019\fE\u0002x\u0003kK1!a.9\u0005e\u0011vnY6t\t\n3\u0015\u000e\\3NC:\fw-\u001a:NKR\u0014\u0018nY:\u000231|\u0017\rZ\"iK\u000e\\\u0007o\\5oi6+GO]5dg~#S-\u001d\u000b\u0005\u0003{\u000b\u0019\rE\u0002J\u0003\u007fK1!!1K\u0005\u0011)f.\u001b;\t\u0013\u0005\u0015w#!AA\u0002\u0005M\u0016a\u0001=%c\u00051Bn\\1e\u0007\",7m\u001b9pS:$X*\u001a;sS\u000e\u001c\b\u0005K\u0002\u0019\u0003\u0017\u00042!SAg\u0013\r\tyM\u0013\u0002\tm>d\u0017\r^5mK\u0006)2/\u0019<f\u0007\",7m\u001b9pS:$X*\u001a;sS\u000e\u001c\u0018!G:bm\u0016\u001c\u0005.Z2la>Lg\u000e^'fiJL7m]0%KF$B!!0\u0002X\"I\u0011Q\u0019\u000e\u0002\u0002\u0003\u0007\u00111W\u0001\u0017g\u00064Xm\u00115fG.\u0004x.\u001b8u\u001b\u0016$(/[2tA!\u001a1$a3\u000271\fG/Z:u\u0019>\fGm\u00115fG.\u0004x.\u001b8u\u001b\u0016$(/[2t\u0003ma\u0017\r^3tiN\u000bg/Z\"iK\u000e\\\u0007o\\5oi6+GO]5dg\u0006\u00192/\u0019<f\u0007\",7m\u001b9pS:$Hk\u001c#ggRA\u0011QXAs\u0003S\fY\u000f\u0003\u0004\u0002hz\u0001\r!Y\u0001\u000eG\",7m\u001b9pS:$H)\u001b:\t\u000f\u0005\u0005f\u00041\u0001\u0002\u0010!9\u0011Q\u001e\u0010A\u0002\u0005=\u0011a\u00028v[.+\u0017p]\u0001\u0016Y>\fGm\u00115fG.\u0004x.\u001b8u\rJ|W\u000e\u00124t)\u0019\t\u00190!?\u0002|B\u0019q/!>\n\u0007\u0005]\bHA\rS_\u000e\\7\u000f\u0012\"DQ\u0016\u001c7\u000e]8j]RlU\r^1eCR\f\u0007bBAQ?\u0001\u0007\u0011q\u0002\u0005\u0007\u0003{|\u0002\u0019A1\u0002\u00111|7-\u00197ESJ\f\u0001dZ3u\u0019\u0006$Xm\u001d;T]\u0006\u00048\u000f[8u-\u0016\u00148/[8o)\u0011\tyAa\u0001\t\u000f\u0005\u0005\u0006\u00051\u0001\u0002\u0010\u0005\u0001r-\u001a;MCR,7\u000f\u001e,feNLwN\u001c\u000b\u0003\u0003\u001f\tqBZ5oI>\u0013\b\u000f[1o\r&dWm\u001d\u000b\u0007\u0005\u001b\u0011yAa\u0005\u0011\u000b\u0005]\u0011\u0011E+\t\u000f\tE!\u00051\u0001\u0003\u000e\u0005aAO]1dW\u0016$g)\u001b7fg\"9!Q\u0003\u0012A\u0002\t]\u0011\u0001C1mY\u001aKG.Z:\u0011\r\u0005]\u0011\u0011\u0005B\r!\u0011\tIEa\u0007\n\t\tu\u00111\n\u0002\u000b\r&dWm\u0015;biV\u001c\u0018\u0001\u00063fY\u0016$Xm\u00115b]\u001e,Gn\\4GS2,7\u000f\u0006\u0003\u0002>\n\r\u0002b\u0002B\u0013G\u0001\u0007!qE\u0001\u0011m\u0016\u00148/[8ogR{G)\u001a7fi\u0016\u0004R!\u0013B\u0015\u0003\u001fI1Aa\u000bK\u0005\u0015\t%O]1z\u0003E!W\r\\3uK>cGMV3sg&|gn\u001d\u000b\u0005\u0003{\u0013\t\u0004C\u0004\u00034\u0011\u0002\rA!\u000e\u0002'9,XNV3sg&|gn\u001d+p%\u0016$\u0018-\u001b8\u0011\u0007%\u00139$C\u0002\u0003:)\u00131!\u00138u\u0003]\u0019\u0018M^3J[6,H/\u00192mK\u001aKG.Z:U_\u001237\u000f\u0006\u0004\u0002\u0016\t}\"\u0011\t\u0005\b\u0003C+\u0003\u0019AA\b\u0011\u001d\u0011\u0019%\na\u0001\u0005\u000b\n!\u0002\\8dC24\u0015\u000e\\3t!\u0015\t9\"!\tb\u0003eaw.\u00193J[6,H/\u00192mK\u001aKG.Z:Ge>lGIZ:\u0015\r\u0005u&1\nB(\u0011\u001d\u0011iE\na\u0001\u0003+\ta\"[7nkR\f'\r\\3GS2,7\u000f\u0003\u0004\u0002~\u001a\u0002\r!Y\u0001 O\u0016$\u0018*\\7vi\u0006\u0014G.\u001a$jY\u0016\u001chI]8n-\u0016\u00148/[8o5&\u0004H\u0003BA\u000b\u0005+Bq!!)(\u0001\u0004\ty!\u0001\u0007{SB$v\u000e\u00124t\r&dW\r\u0006\u0004\u0002>\nm#q\f\u0005\b\u0005;B\u0003\u0019\u0001B#\u0003\u00151\u0017\u000e\\3t\u0011\u001d\u0011\t\u0007\u000ba\u0001\u0005G\n!\u0002\u001a4t5&\u0004h)\u001b7f!\u0011\tIE!\u001a\n\t\t\u001d\u00141\n\u0002\u0005!\u0006$\b.A\u0007m_\u001e4\u0015\u000e\\3t\u0013:$\u0015N\u001d\u000b\u0007\u0003{\u0013iG!\u001d\t\r\t=\u0014\u00061\u0001b\u0003\r!\u0017N\u001d\u0005\u0007\u0005gJ\u0003\u0019A+\u0002\u00075\u001cx-\u0001\boK^$ei\u0015$jY\u0016t\u0015-\\3\u0015\u0007U\u0013I\b\u0003\u0004\u0003|)\u0002\r!V\u0001\u000eY>\u001c\u0017\r\u001c$jY\u0016t\u0015-\\3\u0002\u001f\u001147OQ1uG\"T\u0016\u000e\u001d$jY\u0016$BAa\u0019\u0003\u0002\"9\u0011\u0011U\u0016A\u0002\u0005=\u0011\u0001\u00053gg\u000eC\u0017M\\4fY><g)\u001b7f)\u0011\u0011\u0019Ga\"\t\u000f\u0005\u0005F\u00061\u0001\u0002\u0010\u0005\tBn\\2bY6+G/\u00193bi\u00064\u0015\u000e\\3\u0015\u0007\u0005\u0014i\t\u0003\u0004\u0003\u00106\u0002\r!Y\u0001\na\u0006\u0014XM\u001c;ESJ\fq\u0001\\8h\u001d\u0006lW-F\u0001V\u0003-!gm\u001d$jY\u0016\u0004\u0016\r\u001e5\u0015\t\t\r$\u0011\u0014\u0005\u0007\u00057{\u0003\u0019A+\u0002\u0011\u0019LG.\u001a(b[\u0016\fQ\u0002\\8dC24\u0015\u000e\\3QCRDG#B1\u0003\"\n\r\u0006BBA\u007fa\u0001\u0007\u0011\r\u0003\u0004\u0003\u001cB\u0002\r!V\u0001\u0011Y&\u001cHOU8dWN$%IR5mKN$BA!+\u00030B9\u0011Ja+\u0003F\t\u0015\u0013b\u0001BW\u0015\n1A+\u001e9mKJBa!!@2\u0001\u0004\t\u0017A\u0005*pG.\u001cHI\u0011$jY\u0016l\u0015M\\1hKJ\u0004\"a^\u001a\u0014\u0005MBEC\u0001BZ\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!Q\u0018\u0016\u0004+\n}6F\u0001Ba!\u0011\u0011\u0019M!4\u000e\u0005\t\u0015'\u0002\u0002Bd\u0005\u0013\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t-'*\u0001\u0006b]:|G/\u0019;j_:LAAa4\u0003F\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136\u0001")
public class RocksDBFileManager
implements Logging {
    private CheckpointFileManager fm;
    private SparkConf sparkConf;
    private final String dfsRootDir;
    private final File localTempDir;
    private Configuration hadoopConf;
    private final String codecName;
    private final String loggingId;
    private final ConcurrentHashMap<Object, Seq<RocksDBImmutableFile>> versionToRocksDBFiles;
    private final ConcurrentHashMap<String, RocksDBImmutableFile> localFilesToDfsFiles;
    private final FileSystem fs;
    private final PathFilter onlyZipFiles;
    private final PathFilter onlyChangelogFiles;
    private volatile RocksDBFileManagerMetrics loadCheckpointMetrics;
    private volatile RocksDBFileManagerMetrics saveCheckpointMetrics;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static String $lessinit$greater$default$5() {
        return RocksDBFileManager$.MODULE$.$lessinit$greater$default$5();
    }

    public static String $lessinit$greater$default$4() {
        return RocksDBFileManager$.MODULE$.$lessinit$greater$default$4();
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ConcurrentHashMap<Object, Seq<RocksDBImmutableFile>> versionToRocksDBFiles() {
        return this.versionToRocksDBFiles;
    }

    public ConcurrentHashMap<String, RocksDBImmutableFile> localFilesToDfsFiles() {
        return this.localFilesToDfsFiles;
    }

    private CheckpointFileManager fm$lzycompute() {
        RocksDBFileManager rocksDBFileManager = this;
        synchronized (rocksDBFileManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.fm = CheckpointFileManager$.MODULE$.create(new Path(this.dfsRootDir), this.hadoopConf);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        this.hadoopConf = null;
        return this.fm;
    }

    private CheckpointFileManager fm() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.fm$lzycompute();
        }
        return this.fm;
    }

    private FileSystem fs() {
        return this.fs;
    }

    private PathFilter onlyZipFiles() {
        return this.onlyZipFiles;
    }

    private PathFilter onlyChangelogFiles() {
        return this.onlyChangelogFiles;
    }

    private SparkConf sparkConf$lzycompute() {
        RocksDBFileManager rocksDBFileManager = this;
        synchronized (rocksDBFileManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.sparkConf = (SparkConf)Option$.MODULE$.apply((Object)SparkEnv$.MODULE$.get()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.conf()).getOrElse((Function0 & Serializable & scala.Serializable)() -> new SparkConf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.sparkConf;
    }

    private SparkConf sparkConf() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.sparkConf$lzycompute();
        }
        return this.sparkConf;
    }

    private CompressionCodec codec() {
        return CompressionCodec$.MODULE$.createCodec(this.sparkConf(), this.codecName);
    }

    public StateStoreChangelogWriter getChangeLogWriter(long version) {
        Path rootDir = new Path(this.dfsRootDir);
        Path changelogFile = this.dfsChangelogFile(version);
        if (!this.fm().exists(rootDir)) {
            this.fm().mkdirs(rootDir);
        }
        StateStoreChangelogWriter changelogWriter = new StateStoreChangelogWriter(this.fm(), changelogFile, this.codec());
        return changelogWriter;
    }

    public StateStoreChangelogReader getChangelogReader(long version) {
        Path changelogFile = this.dfsChangelogFile(version);
        return new StateStoreChangelogReader(this.fm(), changelogFile, this.codec());
    }

    private RocksDBFileManagerMetrics loadCheckpointMetrics() {
        return this.loadCheckpointMetrics;
    }

    private void loadCheckpointMetrics_$eq(RocksDBFileManagerMetrics x$1) {
        this.loadCheckpointMetrics = x$1;
    }

    private RocksDBFileManagerMetrics saveCheckpointMetrics() {
        return this.saveCheckpointMetrics;
    }

    private void saveCheckpointMetrics_$eq(RocksDBFileManagerMetrics x$1) {
        this.saveCheckpointMetrics = x$1;
    }

    public RocksDBFileManagerMetrics latestLoadCheckpointMetrics() {
        return this.loadCheckpointMetrics();
    }

    public RocksDBFileManagerMetrics latestSaveCheckpointMetrics() {
        return this.saveCheckpointMetrics();
    }

    public void saveCheckpointToDfs(File checkpointDir, long version, long numKeys) {
        this.logFilesInDir(checkpointDir, new StringBuilder(36).append("Saving checkpoint files for version ").append(version).toString());
        Tuple2<Seq<File>, Seq<File>> tuple2 = this.listRocksDBFiles(checkpointDir);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq localImmutableFiles = (Seq)tuple2._1();
        Seq localOtherFiles = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)localImmutableFiles, (Object)localOtherFiles);
        Seq localImmutableFiles2 = (Seq)tuple22._1();
        Seq localOtherFiles2 = (Seq)tuple22._2();
        Seq<RocksDBImmutableFile> rocksDBFiles = this.saveImmutableFilesToDfs(version, (Seq<File>)localImmutableFiles2);
        RocksDBCheckpointMetadata metadata = RocksDBCheckpointMetadata$.MODULE$.apply(rocksDBFiles, numKeys);
        File metadataFile = this.localMetadataFile(checkpointDir);
        metadata.writeToFile(metadataFile);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Written metadata for version ").append(version).append(":\n").append(metadata.prettyJson()).toString());
        if (version <= 1L && numKeys <= 0L) {
            Path path = new Path(this.dfsRootDir);
            if (!this.fm().exists(path)) {
                this.fm().mkdirs(path);
            }
        }
        this.zipToDfsFile((Seq<File>)((Seq)localOtherFiles2.$colon$plus((Object)metadataFile, Seq$.MODULE$.canBuildFrom())), this.dfsBatchZipFile(version));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Saved checkpoint file for version ").append(version).toString());
    }

    public RocksDBCheckpointMetadata loadCheckpointFromDfs(long version, File localDir) {
        RocksDBCheckpointMetadata rocksDBCheckpointMetadata;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Loading checkpoint files for version ").append(version).toString());
        this.versionToRocksDBFiles().keySet().removeIf(x$3 -> RocksDBFileManager.$anonfun$loadCheckpointFromDfs$2(version, BoxesRunTime.unboxToLong((Object)x$3)));
        if (version == 0L) {
            if (localDir.exists()) {
                Utils$.MODULE$.deleteRecursively(localDir);
            }
            this.localFilesToDfsFiles().clear();
            localDir.mkdirs();
            rocksDBCheckpointMetadata = RocksDBCheckpointMetadata$.MODULE$.apply((Seq<RocksDBImmutableFile>)((Seq)Nil$.MODULE$), 0L);
        } else {
            ((IterableLike)this.listRocksDBFiles(localDir)._2()).foreach((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.delete()));
            Utils$.MODULE$.unzipFilesFromFile(this.fs(), this.dfsBatchZipFile(version), localDir);
            File metadataFile = this.localMetadataFile(localDir);
            RocksDBCheckpointMetadata metadata = RocksDBCheckpointMetadata$.MODULE$.readFromFile(metadataFile);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Read metadata for version ").append(version).append(":\n").append(metadata.prettyJson()).toString());
            this.loadImmutableFilesFromDfs(metadata.immutableFiles(), localDir);
            this.versionToRocksDBFiles().put(BoxesRunTime.boxToLong((long)version), metadata.immutableFiles());
            metadataFile.delete();
            rocksDBCheckpointMetadata = metadata;
        }
        RocksDBCheckpointMetadata metadata = rocksDBCheckpointMetadata;
        this.logFilesInDir(localDir, new StringBuilder(36).append("Loaded checkpoint files for version ").append(version).toString());
        return metadata;
    }

    public long getLatestSnapshotVersion(long version) {
        Path path = new Path(this.dfsRootDir);
        if (this.fm().exists(path)) {
            if (this.fm().exists(this.dfsBatchZipFile(version))) {
                return version;
            }
            return BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fm().list(path, this.onlyZipFiles()))).map((Function1 & Serializable & scala.Serializable)x$5 -> new StringOps(Predef$.MODULE$.augmentString(x$5.getPath().getName())).stripSuffix(".zip"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)RocksDBFileManager.$anonfun$getLatestSnapshotVersion$2(x$6)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$7 -> x$7 <= version))).foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(x, y) -> package$.MODULE$.max(x, y)));
        }
        return 0L;
    }

    public long getLatestVersion() {
        Path path = new Path(this.dfsRootDir);
        if (this.fm().exists(path)) {
            Path[] files = (Path[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fm().list(path))).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.getPath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)));
            long[] changelogFileVersions = (long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$getLatestVersion$2(this, x$9))))).map((Function1 & Serializable & scala.Serializable)x$10 -> new StringOps(Predef$.MODULE$.augmentString(x$10.getName())).stripSuffix(".changelog"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)RocksDBFileManager.$anonfun$getLatestVersion$4(x$11)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
            long[] snapshotFileVersions = (long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$getLatestVersion$5(this, x$12))))).map((Function1 & Serializable & scala.Serializable)x$13 -> new StringOps(Predef$.MODULE$.augmentString(x$13.getName())).stripSuffix(".zip"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)RocksDBFileManager.$anonfun$getLatestVersion$7(x$14)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
            long[] versions = (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(changelogFileVersions)).$plus$plus((GenTraversableOnce)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(snapshotFileVersions)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
            return BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(versions)).foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(x, y) -> package$.MODULE$.max(x, y)));
        }
        return 0L;
    }

    public Seq<String> findOrphanFiles(Seq<String> trackedFiles, Seq<FileStatus> allFiles) {
        Map fileModificationTimes = ((TraversableOnce)allFiles.map((Function1 & Serializable & scala.Serializable)file -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)file.getPath().getName()), (Object)BoxesRunTime.boxToLong((long)file.getModificationTime())), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        if (trackedFiles.nonEmpty() && allFiles.size() > trackedFiles.size()) {
            long oldestTrackedFileModificationTime = BoxesRunTime.unboxToLong((Object)((TraversableOnce)trackedFiles.flatMap((Function1 & Serializable & scala.Serializable)x$15 -> Option$.MODULE$.option2Iterable(fileModificationTimes.get(x$15)), Seq$.MODULE$.canBuildFrom())).min((Ordering)Ordering.Long$.MODULE$));
            Seq orphanFiles = ((MapLike)fileModificationTimes.filter((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$findOrphanFiles$3(oldestTrackedFileModificationTime, x$16)))).keys().toSeq();
            if (orphanFiles.nonEmpty()) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("Found ").append(orphanFiles.size()).append(" orphan files: ").append(((TraversableOnce)orphanFiles.take(20)).mkString(", ")).append("... (display at most 20 filenames) that should be deleted.").toString());
            }
            return orphanFiles;
        }
        return (Seq)Nil$.MODULE$;
    }

    private void deleteChangelogFiles(long[] versionsToDelete) {
        new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(versionsToDelete)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)version -> {
            try {
                this.fm().delete(this.dfsChangelogFile(version));
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Deleted changelog file ").append(version).toString());
            }
            catch (Exception e) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Error deleting changelog file for version ").append(version).toString(), e);
            }
        });
    }

    public void deleteOldVersions(int numVersionsToRetain) {
        Path path = new Path(this.dfsRootDir);
        Path[] allFiles = (Path[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fm().list(path))).map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.getPath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)));
        Path[] snapshotFiles = (Path[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allFiles)).filter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$deleteOldVersions$2(this, file)));
        Path[] changelogFiles = (Path[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allFiles)).filter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$deleteOldVersions$3(this, file)));
        long[] sortedSnapshotVersions = (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])snapshotFiles)).map((Function1 & Serializable & scala.Serializable)x$18 -> new StringOps(Predef$.MODULE$.augmentString(x$18.getName())).stripSuffix(".zip"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).map((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToLong((long)RocksDBFileManager.$anonfun$deleteOldVersions$5(x$19)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sorted((Ordering)Ordering.Long$.MODULE$);
        if (new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(sortedSnapshotVersions)).isEmpty()) {
            return;
        }
        long maxSnapshotVersionPresent = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(sortedSnapshotVersions)).last());
        long minVersionToRetain = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(sortedSnapshotVersions)).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$20 -> x$20 <= maxSnapshotVersionPresent - (long)numVersionsToRetain + 1L))).foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(x, y) -> package$.MODULE$.max(x, y)));
        long[] snapshotVersionsToDelete = (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(sortedSnapshotVersions)).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$21 -> x$21 < minVersionToRetain);
        if (new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(snapshotVersionsToDelete)).isEmpty()) {
            return;
        }
        HashMap fileToMaxUsedVersion = new HashMap();
        new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(sortedSnapshotVersions)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)version -> {
            Seq files = (Seq)Option$.MODULE$.apply(this.versionToRocksDBFiles().get(BoxesRunTime.boxToLong((long)version))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                Seq<RocksDBImmutableFile> newResolvedFiles = this.getImmutableFilesFromVersionZip(version);
                this.versionToRocksDBFiles().put(BoxesRunTime.boxToLong((long)version), newResolvedFiles);
                return newResolvedFiles;
            });
            files.foreach((Function1 & Serializable & scala.Serializable)f -> {
                fileToMaxUsedVersion.update((Object)f.dfsFileName(), (Object)BoxesRunTime.boxToLong((long)package$.MODULE$.max(version, BoxesRunTime.unboxToLong((Object)fileToMaxUsedVersion.getOrElse((Object)f.dfsFileName(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> version$5)))));
                return BoxedUnit.UNIT;
            });
        });
        HashMap filesToDelete = (HashMap)fileToMaxUsedVersion.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$deleteOldVersions$13(snapshotVersionsToDelete, x0$1)));
        Path sstDir = new Path(this.dfsRootDir, RocksDBImmutableFile$.MODULE$.SST_FILES_DFS_SUBDIR());
        Path logDir = new Path(this.dfsRootDir, RocksDBImmutableFile$.MODULE$.LOG_FILES_DFS_SUBDIR());
        Seq allSstFiles = this.fm().exists(sstDir) ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fm().list(sstDir))).toSeq() : (Seq)Nil$.MODULE$;
        Seq allLogFiles = this.fm().exists(logDir) ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fm().list(logDir))).toSeq() : (Seq)Nil$.MODULE$;
        filesToDelete.$plus$plus$eq((TraversableOnce)this.findOrphanFiles((Seq<String>)fileToMaxUsedVersion.keys().toSeq(), (Seq<FileStatus>)((Seq)allSstFiles.$plus$plus((GenTraversableOnce)allLogFiles, Seq$.MODULE$.canBuildFrom()))).map((Function1 & Serializable & scala.Serializable)x$22 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$22), (Object)BoxesRunTime.boxToLong((long)-1L)), Seq$.MODULE$.canBuildFrom()));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Deleting ").append(filesToDelete.size()).append(" files not used in versions >= ").append(minVersionToRetain).toString());
        IntRef failedToDelete = IntRef.create((int)0);
        filesToDelete.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            RocksDBFileManager.$anonfun$deleteOldVersions$16(this, failedToDelete, x0$2);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(snapshotVersionsToDelete)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)version -> {
            Path versionFile = this.dfsBatchZipFile(version);
            try {
                this.fm().delete(versionFile);
                this.versionToRocksDBFiles().remove(BoxesRunTime.boxToLong((long)version));
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Deleted version ").append(version).toString());
            }
            catch (Exception e) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Error deleting version file ").append(versionFile).append(" for version ").append(version).toString(), e);
            }
        });
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Deleted ").append(filesToDelete.size() - failedToDelete$1.elem).append(" files (failed to delete").append(failedToDelete$1.elem).append(" files) not used in versions >= ").append(minVersionToRetain).toString());
        long[] changelogVersionsToDelete = (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])changelogFiles)).map((Function1 & Serializable & scala.Serializable)x$23 -> new StringOps(Predef$.MODULE$.augmentString(x$23.getName())).stripSuffix(".changelog"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).map((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToLong((long)RocksDBFileManager.$anonfun$deleteOldVersions$26(x$24)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$25 -> x$25 < minVersionToRetain);
        this.deleteChangelogFiles(changelogVersionsToDelete);
    }

    private Seq<RocksDBImmutableFile> saveImmutableFilesToDfs(long version, Seq<File> localFiles) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Saving RocksDB files to DFS for ").append(version).toString());
        LongRef bytesCopied = LongRef.create((long)0L);
        LongRef filesCopied = LongRef.create((long)0L);
        LongRef filesReused = LongRef.create((long)0L);
        Seq immutableFiles = (Seq)localFiles.map((Function1 & Serializable & scala.Serializable)localFile -> {
            Option existingDfsFile = ((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.localFilesToDfsFiles()).asScala()).get((Object)localFile.getName());
            if (existingDfsFile.isDefined() && ((RocksDBImmutableFile)existingDfsFile.get()).sizeBytes() == localFile.length()) {
                RocksDBImmutableFile dfsFile = (RocksDBImmutableFile)existingDfsFile.get();
                ++filesReused$1.elem;
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("reusing file ").append(dfsFile).append(" for ").append(localFile).toString());
                return RocksDBImmutableFile$.MODULE$.apply(localFile.getName(), dfsFile.dfsFileName(), dfsFile.sizeBytes());
            }
            String localFileName = localFile.getName();
            String dfsFileName = this.newDFSFileName(localFileName);
            Path dfsFile = this.dfsFilePath(dfsFileName);
            this.fs().copyFromLocalFile(new Path(localFile.getAbsoluteFile().toURI()), dfsFile);
            long localFileSize = localFile.length();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Copied ").append(localFile).append(" to ").append(dfsFile).append(" - ").append(localFileSize).append(" bytes").toString());
            ++filesCopied$1.elem;
            bytesCopied$1.elem += localFileSize;
            RocksDBImmutableFile immutableDfsFile = RocksDBImmutableFile$.MODULE$.apply(localFile.getName(), dfsFileName, localFileSize);
            this.localFilesToDfsFiles().put(localFileName, immutableDfsFile);
            return immutableDfsFile;
        }, Seq$.MODULE$.canBuildFrom());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(85).append("Copied ").append(filesCopied$1.elem).append(" files (").append(bytesCopied$1.elem).append(" bytes) from local to").append(" DFS for version ").append(version).append(". ").append(filesReused$1.elem).append(" files reused without copying.").toString());
        this.versionToRocksDBFiles().put(BoxesRunTime.boxToLong((long)version), (Seq<RocksDBImmutableFile>)immutableFiles);
        Set currentLocalFiles = ((TraversableOnce)localFiles.map((Function1 & Serializable & scala.Serializable)x$26 -> x$26.getName(), Seq$.MODULE$.canBuildFrom())).toSet();
        Iterable mappingsToClean = (Iterable)((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.localFilesToDfsFiles()).asScala()).keys().filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)currentLocalFiles.contains((Object)elem)));
        mappingsToClean.foreach((Function1 & Serializable & scala.Serializable)f -> {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("cleaning ").append((String)f).append(" from the localFilesToDfsFiles map").toString());
            return this.localFilesToDfsFiles().remove(f);
        });
        long x$1 = bytesCopied.elem;
        long x$2 = filesCopied.elem;
        long x$3 = filesReused.elem;
        Option<Object> x$4 = RocksDBFileManagerMetrics$.MODULE$.apply$default$4();
        this.saveCheckpointMetrics_$eq(new RocksDBFileManagerMetrics(x$2, x$1, x$3, x$4));
        return immutableFiles;
    }

    private void loadImmutableFilesFromDfs(Seq<RocksDBImmutableFile> immutableFiles, File localDir) {
        Map requiredFileNameToFileDetails = ((TraversableOnce)immutableFiles.map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.localFileName()), f), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        ((IterableLike)this.listRocksDBFiles(localDir)._1()).foreach((Function1 & Serializable & scala.Serializable)existingFile -> {
            RocksDBFileManager.$anonfun$loadImmutableFilesFromDfs$2(this, requiredFileNameToFileDetails, existingFile);
            return BoxedUnit.UNIT;
        });
        LongRef filesCopied = LongRef.create((long)0L);
        LongRef bytesCopied = LongRef.create((long)0L);
        LongRef filesReused = LongRef.create((long)0L);
        immutableFiles.foreach((Function1 & Serializable & scala.Serializable)file -> {
            RocksDBFileManager.$anonfun$loadImmutableFilesFromDfs$6(this, localDir, filesCopied, bytesCopied, filesReused, file);
            return BoxedUnit.UNIT;
        });
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Copied ").append(filesCopied$2.elem).append(" files (").append(bytesCopied$2.elem).append(" bytes) from DFS to local with ").append(filesReused$2.elem).append(" files reused.").toString());
        long x$1 = bytesCopied.elem;
        long x$2 = filesCopied.elem;
        long x$3 = filesReused.elem;
        Option<Object> x$4 = RocksDBFileManagerMetrics$.MODULE$.apply$default$4();
        this.loadCheckpointMetrics_$eq(new RocksDBFileManagerMetrics(x$2, x$1, x$3, x$4));
    }

    private Seq<RocksDBImmutableFile> getImmutableFilesFromVersionZip(long version) {
        Utils$.MODULE$.deleteRecursively(this.localTempDir);
        this.localTempDir.mkdirs();
        Utils$.MODULE$.unzipFilesFromFile(this.fs(), this.dfsBatchZipFile(version), this.localTempDir);
        File metadataFile = this.localMetadataFile(this.localTempDir);
        RocksDBCheckpointMetadata metadata = RocksDBCheckpointMetadata$.MODULE$.readFromFile(metadataFile);
        return metadata.immutableFiles();
    }

    private void zipToDfsFile(Seq<File> files, Path dfsZipFile) {
        LazyRef filesStr$lzy = new LazyRef();
        ObjectRef in = ObjectRef.create(null);
        CheckpointFileManager.CancellableFSDataOutputStream out = this.fm().createAtomic(dfsZipFile, true);
        LongRef totalBytes = LongRef.create((long)0L);
        ZipOutputStream zout = new ZipOutputStream((OutputStream)((Object)out));
        try {
            try {
                files.foreach((Function1 & Serializable & scala.Serializable)file -> {
                    RocksDBFileManager.$anonfun$zipToDfsFile$1(zout, in, totalBytes, file);
                    return BoxedUnit.UNIT;
                });
                zout.close();
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Zipped ").append(totalBytes$1.elem).append(" bytes (before compression) to ").append(RocksDBFileManager.filesStr$1(filesStr$lzy, dfsZipFile, files)).toString());
                RocksDBFileManagerMetrics qual$1 = this.saveCheckpointMetrics();
                Some x$1 = new Some((Object)BoxesRunTime.boxToLong((long)totalBytes.elem));
                long x$2 = qual$1.copy$default$1();
                long x$3 = qual$1.copy$default$2();
                long x$4 = qual$1.copy$default$3();
                this.saveCheckpointMetrics_$eq(qual$1.copy(x$2, x$3, x$4, (Option<Object>)x$1));
            }
            catch (Exception e) {
                out.cancel();
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Error zipping to ").append(RocksDBFileManager.filesStr$1(filesStr$lzy, dfsZipFile, files)).toString(), e);
                throw e;
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)((InputStream)in.elem));
            IOUtils.closeQuietly((OutputStream)zout);
        }
    }

    private void logFilesInDir(File dir, String msg) {
        LazyRef files$lzy = new LazyRef();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append(msg).append(" - ").append(RocksDBFileManager.files$2(files$lzy, dir).length).append(" files\n\t").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RocksDBFileManager.files$2(files$lzy, dir))).mkString("\n\t")).toString());
    }

    private String newDFSFileName(String localFileName) {
        String baseName = FilenameUtils.getBaseName((String)localFileName);
        String extension = FilenameUtils.getExtension((String)localFileName);
        return new StringBuilder(2).append(baseName).append("-").append(UUID.randomUUID()).append(".").append(extension).toString();
    }

    private Path dfsBatchZipFile(long version) {
        return new Path(new StringBuilder(5).append(this.dfsRootDir).append("/").append(version).append(".zip").toString());
    }

    private Path dfsChangelogFile(long version) {
        return new Path(new StringBuilder(11).append(this.dfsRootDir).append("/").append(version).append(".changelog").toString());
    }

    private File localMetadataFile(File parentDir) {
        return new File(parentDir, "metadata");
    }

    public String logName() {
        return new StringBuilder(1).append(Logging.logName$((Logging)this)).append(" ").append(this.loggingId).toString();
    }

    private Path dfsFilePath(String fileName) {
        if (RocksDBImmutableFile$.MODULE$.isSstFile(fileName)) {
            return new Path(new Path(this.dfsRootDir, RocksDBImmutableFile$.MODULE$.SST_FILES_DFS_SUBDIR()), fileName);
        }
        if (RocksDBImmutableFile$.MODULE$.isLogFile(fileName)) {
            return new Path(new Path(this.dfsRootDir, RocksDBImmutableFile$.MODULE$.LOG_FILES_DFS_SUBDIR()), fileName);
        }
        return new Path(this.dfsRootDir, fileName);
    }

    private File localFilePath(File localDir, String fileName) {
        if (RocksDBImmutableFile$.MODULE$.isLogFile(fileName)) {
            return new File(new File(localDir, RocksDBImmutableFile$.MODULE$.LOG_FILES_LOCAL_SUBDIR()), fileName);
        }
        return new File(localDir, fileName);
    }

    private Tuple2<Seq<File>, Seq<File>> listRocksDBFiles(File localDir) {
        File[] topLevelFiles = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])localDir.listFiles())).filter((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$listRocksDBFiles$1(x$27)));
        File[] archivedLogFiles = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Option$.MODULE$.apply((Object)new File(localDir, RocksDBImmutableFile$.MODULE$.LOG_FILES_LOCAL_SUBDIR()).listFiles()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (File[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(File.class))))).filter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)RocksDBImmutableFile$.MODULE$.isLogFile(file.getName())));
        Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topLevelFiles)).partition((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)RocksDBImmutableFile$.MODULE$.isSstFile(f.getName())));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File[] topLevelSstFiles = (File[])tuple2._1();
        File[] topLevelOtherFiles = (File[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)topLevelSstFiles, (Object)topLevelOtherFiles);
        File[] topLevelSstFiles2 = (File[])tuple22._1();
        File[] topLevelOtherFiles2 = (File[])tuple22._2();
        return new Tuple2(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topLevelSstFiles2)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])archivedLogFiles)), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())), (Object)Predef$.MODULE$.wrapRefArray((Object[])topLevelOtherFiles2));
    }

    public static final /* synthetic */ boolean $anonfun$loadCheckpointFromDfs$2(long version$2, long x$3) {
        return x$3 >= version$2;
    }

    public static final /* synthetic */ long $anonfun$getLatestSnapshotVersion$2(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).toLong();
    }

    public static final /* synthetic */ boolean $anonfun$getLatestVersion$2(RocksDBFileManager $this, Path x$9) {
        return $this.onlyChangelogFiles().accept(x$9);
    }

    public static final /* synthetic */ long $anonfun$getLatestVersion$4(String x$11) {
        return new StringOps(Predef$.MODULE$.augmentString(x$11)).toLong();
    }

    public static final /* synthetic */ boolean $anonfun$getLatestVersion$5(RocksDBFileManager $this, Path x$12) {
        return $this.onlyZipFiles().accept(x$12);
    }

    public static final /* synthetic */ long $anonfun$getLatestVersion$7(String x$14) {
        return new StringOps(Predef$.MODULE$.augmentString(x$14)).toLong();
    }

    public static final /* synthetic */ boolean $anonfun$findOrphanFiles$3(long oldestTrackedFileModificationTime$1, Tuple2 x$16) {
        return x$16._2$mcJ$sp() < oldestTrackedFileModificationTime$1;
    }

    public static final /* synthetic */ boolean $anonfun$deleteOldVersions$2(RocksDBFileManager $this, Path file) {
        return $this.onlyZipFiles().accept(file);
    }

    public static final /* synthetic */ boolean $anonfun$deleteOldVersions$3(RocksDBFileManager $this, Path file) {
        return $this.onlyChangelogFiles().accept(file);
    }

    public static final /* synthetic */ long $anonfun$deleteOldVersions$5(String x$19) {
        return new StringOps(Predef$.MODULE$.augmentString(x$19)).toLong();
    }

    public static final /* synthetic */ boolean $anonfun$deleteOldVersions$13(long[] snapshotVersionsToDelete$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            long v = tuple2._2$mcJ$sp();
            return new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(snapshotVersionsToDelete$1)).contains((Object)BoxesRunTime.boxToLong((long)v));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$deleteOldVersions$16(RocksDBFileManager $this, IntRef failedToDelete$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            BoxedUnit boxedUnit;
            String dfsFileName = (String)tuple2._1();
            long maxUsedVersion = tuple2._2$mcJ$sp();
            try {
                Path dfsFile = $this.dfsFilePath(dfsFileName);
                $this.fm().delete(dfsFile);
                if (maxUsedVersion == -1L) {
                    $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Deleted orphan file ").append(dfsFileName).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Deleted file ").append(dfsFileName).append(" that was last used in version ").append(maxUsedVersion).toString());
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (Exception e) {
                ++failedToDelete$1.elem;
                if (maxUsedVersion == -1L) {
                    $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Error deleting orphan file ").append(dfsFileName).toString(), e);
                    boxedUnit = BoxedUnit.UNIT;
                }
                $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Error deleting file ").append(dfsFileName).append(", last used in version ").append(maxUsedVersion).toString(), e);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ long $anonfun$deleteOldVersions$26(String x$24) {
        return new StringOps(Predef$.MODULE$.augmentString(x$24)).toLong();
    }

    public static final /* synthetic */ void $anonfun$loadImmutableFilesFromDfs$2(RocksDBFileManager $this, Map requiredFileNameToFileDetails$1, File existingFile) {
        boolean isSameFile;
        boolean bl;
        Option requiredFile = requiredFileNameToFileDetails$1.get((Object)existingFile.getName());
        Option prevDfsFile = ((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter($this.localFilesToDfsFiles()).asScala()).get((Object)existingFile.getName());
        if (requiredFile.isDefined() && prevDfsFile.isDefined()) {
            String string = ((RocksDBImmutableFile)requiredFile.get()).dfsFileName();
            String string2 = ((RocksDBImmutableFile)prevDfsFile.get()).dfsFileName();
            bl = !(string != null ? !string.equals(string2) : string2 != null) && existingFile.length() == ((RocksDBImmutableFile)requiredFile.get()).sizeBytes();
        } else {
            bl = isSameFile = false;
        }
        if (!isSameFile) {
            existingFile.delete();
            $this.localFilesToDfsFiles().remove(existingFile.getName());
            $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Deleted local file ").append(existingFile).append(" with size ").append(existingFile.length()).append(" mapped").append(" to previous dfsFile ").append(prevDfsFile.getOrElse((Function0 & Serializable & scala.Serializable)() -> "null")).toString());
            return;
        }
        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("reusing ").append(prevDfsFile).append(" present at ").append(existingFile).append(" for ").append(requiredFile).toString());
    }

    public static final /* synthetic */ void $anonfun$loadImmutableFilesFromDfs$6(RocksDBFileManager $this, File localDir$1, LongRef filesCopied$2, LongRef bytesCopied$2, LongRef filesReused$2, RocksDBImmutableFile file) {
        String localFileName = file.localFileName();
        File localFile = $this.localFilePath(localDir$1, localFileName);
        if (!localFile.exists()) {
            Path dfsFile = $this.dfsFilePath(file.dfsFileName());
            $this.fs().copyToLocalFile(dfsFile, new Path(localFile.getAbsoluteFile().toURI()));
            long localFileSize = localFile.length();
            long expectedSize = file.sizeBytes();
            if (localFileSize != expectedSize) {
                throw new IllegalStateException(new StringBuilder(43).append("Copied ").append(dfsFile).append(" to ").append(localFile).append(",").append(" expected ").append(expectedSize).append(" bytes, found ").append(localFileSize).append(" bytes ").toString());
            }
            ++filesCopied$2.elem;
            bytesCopied$2.elem += localFileSize;
            $this.localFilesToDfsFiles().put(localFileName, file);
            $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Copied ").append(dfsFile).append(" to ").append(localFile).append(" - ").append(localFileSize).append(" bytes").toString());
            return;
        }
        ++filesReused$2.elem;
    }

    private static final /* synthetic */ String filesStr$lzycompute$1(LazyRef filesStr$lzy$1, Path dfsZipFile$1, Seq files$1) {
        String string;
        LazyRef lazyRef = filesStr$lzy$1;
        synchronized (lazyRef) {
            string = filesStr$lzy$1.initialized() ? (String)filesStr$lzy$1.value() : (String)filesStr$lzy$1.initialize((Object)new StringBuilder(2).append(dfsZipFile$1).append("\n\t").append(files$1.mkString("\n\t")).toString());
        }
        return string;
    }

    private static final String filesStr$1(LazyRef filesStr$lzy$1, Path dfsZipFile$1, Seq files$1) {
        if (filesStr$lzy$1.initialized()) {
            return (String)filesStr$lzy$1.value();
        }
        return RocksDBFileManager.filesStr$lzycompute$1(filesStr$lzy$1, dfsZipFile$1, files$1);
    }

    public static final /* synthetic */ void $anonfun$zipToDfsFile$1(ZipOutputStream zout$1, ObjectRef in$1, LongRef totalBytes$1, File file) {
        zout$1.putNextEntry(new ZipEntry(file.getName()));
        in$1.elem = new FileInputStream(file);
        int bytes = IOUtils.copy((InputStream)((InputStream)in$1.elem), (OutputStream)zout$1);
        ((InputStream)in$1.elem).close();
        zout$1.closeEntry();
        totalBytes$1.elem += (long)bytes;
    }

    private static final /* synthetic */ String[] files$lzycompute$1(LazyRef files$lzy$1, File dir$1) {
        String[] stringArray;
        LazyRef lazyRef = files$lzy$1;
        synchronized (lazyRef) {
            stringArray = files$lzy$1.initialized() ? (String[])files$lzy$1.value() : (String[])files$lzy$1.initialize(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Option$.MODULE$.apply((Object)Utils$.MODULE$.recursiveList(dir$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class))))).map((Function1 & Serializable & scala.Serializable)f -> new StringBuilder(9).append(f.getAbsolutePath()).append(" - ").append(f.length()).append(" bytes").toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        }
        return stringArray;
    }

    private static final String[] files$2(LazyRef files$lzy$1, File dir$1) {
        if (files$lzy$1.initialized()) {
            return (String[])files$lzy$1.value();
        }
        return RocksDBFileManager.files$lzycompute$1(files$lzy$1, dir$1);
    }

    public static final /* synthetic */ boolean $anonfun$listRocksDBFiles$1(File x$27) {
        return !x$27.isDirectory();
    }

    public RocksDBFileManager(String dfsRootDir, File localTempDir, Configuration hadoopConf, String codecName, String loggingId) {
        this.dfsRootDir = dfsRootDir;
        this.localTempDir = localTempDir;
        this.hadoopConf = hadoopConf;
        this.codecName = codecName;
        this.loggingId = loggingId;
        Logging.$init$((Logging)this);
        this.versionToRocksDBFiles = new ConcurrentHashMap();
        this.localFilesToDfsFiles = new ConcurrentHashMap();
        this.fs = new Path(dfsRootDir).getFileSystem(hadoopConf);
        this.onlyZipFiles = new PathFilter(null){

            public boolean accept(Path path) {
                return path.toString().endsWith(".zip");
            }
        };
        this.onlyChangelogFiles = new PathFilter(null){

            public boolean accept(Path path) {
                return path.toString().endsWith(".changelog");
            }
        };
        this.loadCheckpointMetrics = RocksDBFileManagerMetrics$.MODULE$.EMPTY_METRICS();
        this.saveCheckpointMetrics = RocksDBFileManagerMetrics$.MODULE$.EMPTY_METRICS();
    }
}

