/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.compression;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.types.PhysicalDataType;
import org.apache.spark.sql.catalyst.types.PhysicalIntegerType;
import org.apache.spark.sql.catalyst.types.PhysicalLongType;
import org.apache.spark.sql.catalyst.types.PhysicalStringType;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.columnar.ByteBufferHelper$;
import org.apache.spark.sql.execution.columnar.ColumnDictionary;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.compression.DictionaryEncoding$;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t-uA\u0002\u001e<\u0011\u0003k\u0014J\u0002\u0004Lw!\u0005U\b\u0014\u0005\u00069\u0006!\tA\u0018\u0005\b?\u0006\u0011\r\u0011\"\u0011a\u0011\u0019!\u0017\u0001)A\u0005C\"9Q-\u0001b\u0001\n\u00031\u0007B\u00026\u0002A\u0003%q\rC\u0003l\u0003\u0011\u0005C\u000eC\u0004\u00020\u0006!\t%!-\t\u000f\te\u0012\u0001\"\u0011\u0003<\u00191\u0011qW\u0001\u0001\u0003sC!\"!\b\u000b\u0005\u0003\u0005\u000b\u0011BAc\u0011\u0019a&\u0002\"\u0001\u0002H\"A\u0011Q\u001a\u0006A\u0002\u0013%\u0001\rC\u0005\u0002P*\u0001\r\u0011\"\u0003\u0002R\"9\u0011Q\u001b\u0006!B\u0013\t\u0007\"CAl\u0015\u0001\u0007I\u0011BAC\u0011%\tIN\u0003a\u0001\n\u0013\tY\u000e\u0003\u0005\u0002`*\u0001\u000b\u0015BAD\u0011!\t\tO\u0003a\u0001\n\u0013\u0001\u0007\"CAr\u0015\u0001\u0007I\u0011BAs\u0011\u001d\tIO\u0003Q!\n\u0005D\u0011\"a;\u000b\u0005\u0004%I!!<\t\u0011\t\u0015!\u0002)A\u0005\u0003_D\u0011\"a\r\u000b\u0005\u0004%IAa\u0002\t\u0011\u0005\r#\u0002)A\u0005\u0005\u0013A\u0001Ba\u0004\u000b\u0001\u0004%I\u0001\u0019\u0005\n\u0005#Q\u0001\u0019!C\u0005\u0005'AqAa\u0006\u000bA\u0003&\u0011\rC\u0004\u0003\u001a)!\tEa\u0007\t\u000f\t\u0005\"\u0002\"\u0011\u0003$!1!Q\u0006\u0006\u0005B\u0001DaAa\f\u000b\t\u0003\u0002g\u0001\u00029\u0002\u0001ED!\"a\u0003\"\u0005\u0003\u0005\u000b\u0011BA\u0007\u0011)\ti\"\tB\u0001B\u0003%\u0011q\u0004\u0005\u00079\u0006\"\t!a\n\t\u0011\u0005=\u0012E1A\u0005\u0002\u0001Dq!!\r\"A\u0003%\u0011\rC\u0005\u00024\u0005\u0012\r\u0011\"\u0003\u00026!A\u00111I\u0011!\u0002\u0013\t9\u0004C\u0005\u0002F\u0005\u0002\r\u0011\"\u0003\u0002H!I\u00111J\u0011A\u0002\u0013%\u0011Q\n\u0005\t\u00033\n\u0003\u0015)\u0003\u0002J!I\u00111L\u0011A\u0002\u0013%\u0011Q\f\u0005\n\u0003O\n\u0003\u0019!C\u0005\u0003SB\u0001\"!\u001c\"A\u0003&\u0011q\f\u0005\b\u0003_\nC\u0011IA9\u0011\u001d\t\u0019)\tC!\u0003\u000bCq!!$\"\t\u0003\ny\tC\u0005\u0003P\u0005\t\t\u0011\"\u0011\u0003R!A!qL\u0001\u0002\u0002\u0013\u0005\u0001\rC\u0005\u0003b\u0005\t\t\u0011\"\u0001\u0003d!I!qM\u0001\u0002\u0002\u0013\u0005#\u0011\u000e\u0005\n\u0005g\n\u0011\u0011!C\u0001\u0005kB\u0011B!\u001f\u0002\u0003\u0003%\tEa\u001f\t\u0013\tu\u0014!!A\u0005B\t}\u0004\"\u0003BA\u0003\u0005\u0005I\u0011\u0002BB\u0003I!\u0015n\u0019;j_:\f'/_#oG>$\u0017N\\4\u000b\u0005qj\u0014aC2p[B\u0014Xm]:j_:T!AP \u0002\u0011\r|G.^7oCJT!\u0001Q!\u0002\u0013\u0015DXmY;uS>t'B\u0001\"D\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\t\u0016\u000bQa\u001d9be.T!AR$\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0015aA8sOB\u0011!*A\u0007\u0002w\t\u0011B)[2uS>t\u0017M]=F]\u000e|G-\u001b8h'\u0015\tQj\u0015,Z!\tq\u0015+D\u0001P\u0015\u0005\u0001\u0016!B:dC2\f\u0017B\u0001*P\u0005\u0019\te.\u001f*fMB\u0011!\nV\u0005\u0003+n\u0012\u0011cQ8naJ,7o]5p]N\u001b\u0007.Z7f!\tqu+\u0003\u0002Y\u001f\n9\u0001K]8ek\u000e$\bC\u0001([\u0013\tYvJ\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0004=S:LGOP\u0002\u0001)\u0005I\u0015A\u0002;za\u0016LE-F\u0001b!\tq%-\u0003\u0002d\u001f\n\u0019\u0011J\u001c;\u0002\u000fQL\b/Z%eA\u0005iQ*\u0011-`\t&\u001bEkX*J5\u0016+\u0012a\u001a\t\u0003\u001d\"L!![(\u0003\u000bMCwN\u001d;\u0002\u001d5\u000b\u0005l\u0018#J\u0007R{6+\u0013.FA\u00059A-Z2pI\u0016\u0014XcA7\u0002(R)a.!+\u0002,B!q.IAS\u001b\u0005\t!a\u0002#fG>$WM]\u000b\u0003e^\u001c2!I't!\rQE/^\u0005\u0003an\u0002\"A^<\r\u0001\u0011)\u00010\tb\u0001s\n\tA+\u0005\u0002{{B\u0011aj_\u0005\u0003y>\u0013qAT8uQ&tw\rE\u0002\u007f\u0003\u000fi\u0011a \u0006\u0005\u0003\u0003\t\u0019!A\u0003usB,7OC\u0002\u0002\u0006\u0005\u000b\u0001bY1uC2L8\u000f^\u0005\u0004\u0003\u0013y(\u0001\u0005)isNL7-\u00197ECR\fG+\u001f9f\u0003\u0019\u0011WO\u001a4feB!\u0011qBA\r\u001b\t\t\tB\u0003\u0003\u0002\u0014\u0005U\u0011a\u00018j_*\u0011\u0011qC\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u001c\u0005E!A\u0003\"zi\u0016\u0014UO\u001a4fe\u0006Q1m\u001c7v[:$\u0016\u0010]3\u0011\u000b\u0005\u0005\u00121E;\u000e\u0003uJ1!!\n>\u0005Aq\u0015\r^5wK\u000e{G.^7o)f\u0004X\r\u0006\u0004\u0002*\u0005-\u0012Q\u0006\t\u0004_\u0006*\bbBA\u0006I\u0001\u0007\u0011Q\u0002\u0005\b\u0003;!\u0003\u0019AA\u0010\u0003))G.Z7f]RtU/\\\u0001\fK2,W.\u001a8u\u001dVl\u0007%\u0001\u0006eS\u000e$\u0018n\u001c8bef,\"!a\u000e\u0011\u000b9\u000bI$!\u0010\n\u0007\u0005mrJA\u0003BeJ\f\u0017\u0010E\u0002O\u0003\u007fI1!!\u0011P\u0005\r\te._\u0001\fI&\u001cG/[8oCJL\b%A\u0007j]R$\u0015n\u0019;j_:\f'/_\u000b\u0003\u0003\u0013\u0002BATA\u001dC\u0006\t\u0012N\u001c;ES\u000e$\u0018n\u001c8bef|F%Z9\u0015\t\u0005=\u0013Q\u000b\t\u0004\u001d\u0006E\u0013bAA*\u001f\n!QK\\5u\u0011%\t9FKA\u0001\u0002\u0004\tI%A\u0002yIE\na\"\u001b8u\t&\u001cG/[8oCJL\b%\u0001\bm_:<G)[2uS>t\u0017M]=\u0016\u0005\u0005}\u0003#\u0002(\u0002:\u0005\u0005\u0004c\u0001(\u0002d%\u0019\u0011QM(\u0003\t1{gnZ\u0001\u0013Y>tw\rR5di&|g.\u0019:z?\u0012*\u0017\u000f\u0006\u0003\u0002P\u0005-\u0004\"CA,[\u0005\u0005\t\u0019AA0\u0003=awN\\4ES\u000e$\u0018n\u001c8bef\u0004\u0013\u0001\u00028fqR$b!a\u0014\u0002t\u0005}\u0004bBA;_\u0001\u0007\u0011qO\u0001\u0004e><\b\u0003BA=\u0003wj!!a\u0001\n\t\u0005u\u00141\u0001\u0002\f\u0013:$XM\u001d8bYJ{w\u000f\u0003\u0004\u0002\u0002>\u0002\r!Y\u0001\b_J$\u0017N\\1m\u0003\u001dA\u0017m\u001d(fqR,\"!a\"\u0011\u00079\u000bI)C\u0002\u0002\f>\u0013qAQ8pY\u0016\fg.\u0001\u0006eK\u000e|W\u000e\u001d:fgN$b!a\u0014\u0002\u0012\u0006\u0005\u0006bBAJc\u0001\u0007\u0011QS\u0001\rG>dW/\u001c8WK\u000e$xN\u001d\t\u0005\u0003/\u000bi*\u0004\u0002\u0002\u001a*\u0019\u00111T \u0002\u0015Y,7\r^8sSj,G-\u0003\u0003\u0002 \u0006e%\u0001F,sSR\f'\r\\3D_2,XN\u001c,fGR|'\u000f\u0003\u0004\u0002$F\u0002\r!Y\u0001\tG\u0006\u0004\u0018mY5usB\u0019a/a*\u0005\u000ba<!\u0019A=\t\u000f\u0005-q\u00011\u0001\u0002\u000e!9\u0011QD\u0004A\u0002\u00055\u0006CBA\u0011\u0003G\t)+A\u0004f]\u000e|G-\u001a:\u0016\t\u0005M&1\u0007\u000b\u0005\u0003k\u0013)\u0004\u0005\u0003p\u0015\tE\"aB#oG>$WM]\u000b\u0005\u0003w\u000b\u0019m\u0005\u0003\u000b\u001b\u0006u\u0006#\u0002&\u0002@\u0006\u0005\u0017bAA\\wA\u0019a/a1\u0005\u000baT!\u0019A=\u0011\r\u0005\u0005\u00121EAa)\u0011\tI-a3\u0011\t=T\u0011\u0011\u0019\u0005\b\u0003;a\u0001\u0019AAc\u0003EyVO\\2p[B\u0014Xm]:fINK'0Z\u0001\u0016?Vt7m\\7qe\u0016\u001c8/\u001a3TSj,w\fJ3r)\u0011\ty%a5\t\u0011\u0005]c\"!AA\u0002\u0005\f!cX;oG>l\u0007O]3tg\u0016$7+\u001b>fA\u0005AqN^3sM2|w/\u0001\u0007pm\u0016\u0014h\r\\8x?\u0012*\u0017\u000f\u0006\u0003\u0002P\u0005u\u0007\"CA,#\u0005\u0005\t\u0019AAD\u0003%yg/\u001a:gY><\b%A\u0003d_VtG/A\u0005d_VtGo\u0018\u0013fcR!\u0011qJAt\u0011!\t9\u0006FA\u0001\u0002\u0004\t\u0017AB2pk:$\b%\u0001\u0004wC2,Xm]\u000b\u0003\u0003_\u0004b!!=\u0002|\u0006}XBAAz\u0015\u0011\t)0a>\u0002\u000f5,H/\u00192mK*\u0019\u0011\u0011`(\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002~\u0006M(aC!se\u0006L()\u001e4gKJ\u0004B!!1\u0003\u0002%!!1AA\u0004\u00051Ie\u000e^3s]\u0006dG+\u001f9f\u0003\u001d1\u0018\r\\;fg\u0002*\"A!\u0003\u0011\u000f\u0005E(1BA\u001fO&!!QBAz\u0005\u001dA\u0015m\u001d5NCB\fa\u0002Z5di&|g.\u0019:z'&TX-\u0001\neS\u000e$\u0018n\u001c8bef\u001c\u0016N_3`I\u0015\fH\u0003BA(\u0005+A\u0001\"a\u0016\u001c\u0003\u0003\u0005\r!Y\u0001\u0010I&\u001cG/[8oCJL8+\u001b>fA\u0005Qr-\u0019;iKJ\u001cu.\u001c9sKN\u001c\u0018NY5mSRL8\u000b^1ugR1\u0011q\nB\u000f\u0005?Aq!!\u001e\u001e\u0001\u0004\t9\b\u0003\u0004\u0002\u0002v\u0001\r!Y\u0001\tG>l\u0007O]3tgR1\u0011Q\u0002B\u0013\u0005SAqAa\n\u001f\u0001\u0004\ti!\u0001\u0003ge>l\u0007b\u0002B\u0016=\u0001\u0007\u0011QB\u0001\u0003i>\f\u0001#\u001e8d_6\u0004(/Z:tK\u0012\u001c\u0016N_3\u0002\u001d\r|W\u000e\u001d:fgN,GmU5{KB\u0019aOa\r\u0005\u000baD!\u0019A=\t\u000f\u0005u\u0001\u00021\u0001\u00038A1\u0011\u0011EA\u0012\u0005c\t\u0001b];qa>\u0014Ho\u001d\u000b\u0005\u0003\u000f\u0013i\u0004C\u0004\u0002\u001e%\u0001\rAa\u00101\t\t\u0005#\u0011\n\t\u0007\u0003C\u0011\u0019Ea\u0012\n\u0007\t\u0015SH\u0001\u0006D_2,XN\u001c+za\u0016\u00042A\u001eB%\t1\u0011YE!\u0010\u0002\u0002\u0003\u0005)\u0011\u0001B'\u0005\ryFeM\t\u0004u\u0006u\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003TA!!Q\u000bB.\u001b\t\u00119F\u0003\u0003\u0003Z\u0005U\u0011\u0001\u00027b]\u001eLAA!\u0018\u0003X\t11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002>\t\u0015\u0004\u0002CA,i\u0005\u0005\t\u0019A1\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\u001b\u0011\r\t5$qNA\u001f\u001b\t\t90\u0003\u0003\u0003r\u0005](\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\"\u0003x!I\u0011q\u000b\u001c\u0002\u0002\u0003\u0007\u0011QH\u0001\tQ\u0006\u001c\bnQ8eKR\t\u0011-\u0001\u0005u_N#(/\u001b8h)\t\u0011\u0019&A\u0006sK\u0006$'+Z:pYZ,GC\u0001BC!\u0011\u0011)Fa\"\n\t\t%%q\u000b\u0002\u0007\u001f\nTWm\u0019;")
public final class DictionaryEncoding {
    public static String toString() {
        return DictionaryEncoding$.MODULE$.toString();
    }

    public static int hashCode() {
        return DictionaryEncoding$.MODULE$.hashCode();
    }

    public static boolean canEqual(Object object) {
        return DictionaryEncoding$.MODULE$.canEqual(object);
    }

    public static Iterator<Object> productIterator() {
        return DictionaryEncoding$.MODULE$.productIterator();
    }

    public static Object productElement(int n) {
        return DictionaryEncoding$.MODULE$.productElement(n);
    }

    public static int productArity() {
        return DictionaryEncoding$.MODULE$.productArity();
    }

    public static String productPrefix() {
        return DictionaryEncoding$.MODULE$.productPrefix();
    }

    public static boolean supports(ColumnType<?> columnType) {
        return DictionaryEncoding$.MODULE$.supports(columnType);
    }

    public static <T extends PhysicalDataType> Encoder<T> encoder(NativeColumnType<T> nativeColumnType) {
        return DictionaryEncoding$.MODULE$.encoder((NativeColumnType)nativeColumnType);
    }

    public static <T extends PhysicalDataType> Decoder<T> decoder(ByteBuffer byteBuffer, NativeColumnType<T> nativeColumnType) {
        return DictionaryEncoding$.MODULE$.decoder(byteBuffer, (NativeColumnType)nativeColumnType);
    }

    public static short MAX_DICT_SIZE() {
        return DictionaryEncoding$.MODULE$.MAX_DICT_SIZE();
    }

    public static int typeId() {
        return DictionaryEncoding$.MODULE$.typeId();
    }

    public static class Decoder<T extends PhysicalDataType>
    implements org.apache.spark.sql.execution.columnar.compression.Decoder<T> {
        private final ByteBuffer buffer;
        private final NativeColumnType<T> columnType;
        private final int elementNum;
        private final Object[] dictionary;
        private int[] intDictionary;
        private long[] longDictionary;

        public int elementNum() {
            return this.elementNum;
        }

        private Object[] dictionary() {
            return this.dictionary;
        }

        private int[] intDictionary() {
            return this.intDictionary;
        }

        private void intDictionary_$eq(int[] x$1) {
            this.intDictionary = x$1;
        }

        private long[] longDictionary() {
            return this.longDictionary;
        }

        private void longDictionary_$eq(long[] x$1) {
            this.longDictionary = x$1;
        }

        @Override
        public void next(InternalRow row, int ordinal) {
            this.columnType.setField(row, ordinal, this.dictionary()[this.buffer.getShort()]);
        }

        @Override
        public boolean hasNext() {
            return this.buffer.hasRemaining();
        }

        @Override
        public void decompress(WritableColumnVector columnVector, int capacity) {
            int pos;
            ByteBuffer nullsBuffer = this.buffer.duplicate().order(ByteOrder.nativeOrder());
            nullsBuffer.rewind();
            int nullCount = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
            int nextNullIndex = nullCount > 0 ? ByteBufferHelper$.MODULE$.getInt(nullsBuffer) : -1;
            int seenNulls = 0;
            T t = this.columnType.dataType();
            if (t instanceof PhysicalIntegerType) {
                WritableColumnVector dictionaryIds = columnVector.reserveDictionaryIds(capacity);
                columnVector.setDictionary(new ColumnDictionary(this.intDictionary()));
                for (pos = 0; pos < capacity; ++pos) {
                    if (pos != nextNullIndex) {
                        dictionaryIds.putInt(pos, this.buffer.getShort());
                        continue;
                    }
                    if (++seenNulls < nullCount) {
                        nextNullIndex = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
                    }
                    columnVector.putNull(pos);
                }
                return;
            }
            if (t instanceof PhysicalLongType) {
                WritableColumnVector dictionaryIds = columnVector.reserveDictionaryIds(capacity);
                columnVector.setDictionary(new ColumnDictionary(this.longDictionary()));
                while (pos < capacity) {
                    if (pos != nextNullIndex) {
                        dictionaryIds.putInt(pos, this.buffer.getShort());
                    } else {
                        if (++seenNulls < nullCount) {
                            nextNullIndex = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
                        }
                        columnVector.putNull(pos);
                    }
                    ++pos;
                }
                return;
            }
            throw new IllegalStateException("Not supported type in DictionaryEncoding.");
        }

        public Decoder(ByteBuffer buffer, NativeColumnType<T> columnType) {
            this.buffer = buffer;
            this.columnType = columnType;
            this.elementNum = ByteBufferHelper$.MODULE$.getInt(buffer);
            this.dictionary = new Object[this.elementNum()];
            this.intDictionary = null;
            this.longDictionary = null;
            T t = columnType.dataType();
            if (t instanceof PhysicalIntegerType) {
                this.intDictionary_$eq(new int[this.elementNum()]);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.elementNum()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    int v;
                    $this.intDictionary()[i] = v = BoxesRunTime.unboxToInt($this.columnType.extract($this.buffer));
                    $this.dictionary()[i] = BoxesRunTime.boxToInteger((int)v);
                });
            } else if (t instanceof PhysicalLongType) {
                this.longDictionary_$eq(new long[this.elementNum()]);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.elementNum()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    long v;
                    $this.longDictionary()[i] = v = BoxesRunTime.unboxToLong($this.columnType.extract($this.buffer));
                    $this.dictionary()[i] = BoxesRunTime.boxToLong((long)v);
                });
            } else if (t instanceof PhysicalStringType) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.elementNum()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    Object v = $this.columnType.extract($this.buffer);
                    $this.dictionary()[i] = v;
                });
            } else {
                throw new MatchError(t);
            }
        }
    }

    public static class Encoder<T extends PhysicalDataType>
    implements org.apache.spark.sql.execution.columnar.compression.Encoder<T> {
        private final NativeColumnType<T> columnType;
        private int _uncompressedSize;
        private boolean overflow;
        private int count;
        private final ArrayBuffer<Object> values;
        private final HashMap<Object, Object> dictionary;
        private int dictionarySize;

        @Override
        public double compressionRatio() {
            return org.apache.spark.sql.execution.columnar.compression.Encoder.compressionRatio$(this);
        }

        private int _uncompressedSize() {
            return this._uncompressedSize;
        }

        private void _uncompressedSize_$eq(int x$1) {
            this._uncompressedSize = x$1;
        }

        private boolean overflow() {
            return this.overflow;
        }

        private void overflow_$eq(boolean x$1) {
            this.overflow = x$1;
        }

        private int count() {
            return this.count;
        }

        private void count_$eq(int x$1) {
            this.count = x$1;
        }

        private ArrayBuffer<Object> values() {
            return this.values;
        }

        private HashMap<Object, Object> dictionary() {
            return this.dictionary;
        }

        private int dictionarySize() {
            return this.dictionarySize;
        }

        private void dictionarySize_$eq(int x$1) {
            this.dictionarySize = x$1;
        }

        @Override
        public void gatherCompressibilityStats(InternalRow row, int ordinal) {
            Object value = this.columnType.getField(row, ordinal);
            if (!this.overflow()) {
                int actualSize = this.columnType.actualSize(row, ordinal);
                this.count_$eq(this.count() + 1);
                this._uncompressedSize_$eq(this._uncompressedSize() + actualSize);
                if (!this.dictionary().contains(value)) {
                    if (this.dictionary().size() < DictionaryEncoding$.MODULE$.MAX_DICT_SIZE()) {
                        Object clone = this.columnType.clone(value);
                        this.values().$plus$eq(clone);
                        this.dictionarySize_$eq(this.dictionarySize() + actualSize);
                        this.dictionary().update(clone, (Object)BoxesRunTime.boxToShort((short)((short)this.dictionary().size())));
                        return;
                    }
                    this.overflow_$eq(true);
                    this.values().clear();
                    this.dictionary().clear();
                    return;
                }
                return;
            }
        }

        @Override
        public ByteBuffer compress(ByteBuffer from, ByteBuffer to) {
            if (this.overflow()) {
                throw QueryExecutionErrors$.MODULE$.useDictionaryEncodingWhenDictionaryOverflowError();
            }
            to.putInt(DictionaryEncoding$.MODULE$.typeId()).putInt(this.dictionary().size());
            for (int i = 0; i < this.values().length(); ++i) {
                this.columnType.append(this.values().apply(i), to);
            }
            while (from.hasRemaining()) {
                to.putShort(BoxesRunTime.unboxToShort((Object)this.dictionary().apply(this.columnType.extract(from))));
            }
            to.rewind();
            return to;
        }

        @Override
        public int uncompressedSize() {
            return this._uncompressedSize();
        }

        @Override
        public int compressedSize() {
            if (this.overflow()) {
                return Integer.MAX_VALUE;
            }
            return this.dictionarySize() + this.count() * 2;
        }

        public Encoder(NativeColumnType<T> columnType) {
            this.columnType = columnType;
            org.apache.spark.sql.execution.columnar.compression.Encoder.$init$(this);
            this._uncompressedSize = 0;
            this.overflow = false;
            this.count = 0;
            this.values = new ArrayBuffer(1024);
            this.dictionary = HashMap$.MODULE$.empty();
            this.dictionarySize = 4;
        }
    }
}

