/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression;
import org.apache.spark.sql.catalyst.optimizer.EliminateResolvedHint$;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.HintInfo;
import org.apache.spark.sql.catalyst.plans.logical.IgnoreCachedData;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.ResolvedHint;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.execution.CachedData;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.adaptive.AdaptiveSparkPlanHelper;
import org.apache.spark.sql.execution.columnar.InMemoryRelation;
import org.apache.spark.sql.execution.columnar.InMemoryRelation$;
import org.apache.spark.sql.execution.command.CommandUtils$;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.FileTable;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tmc\u0001\u0002\u000f\u001e\u0001!BQa\u000f\u0001\u0005\u0002qBqa\u0010\u0001A\u0002\u0013%\u0001\tC\u0004M\u0001\u0001\u0007I\u0011B'\t\rM\u0003\u0001\u0015)\u0003B\u0011\u001da\u0006A1A\u0005\nuCaa\u001d\u0001!\u0002\u0013q\u0006\"\u0002;\u0001\t\u0003)\b\"\u0002<\u0001\t\u00039\b\"\u0002=\u0001\t\u0003I\b\"CA\"\u0001E\u0005I\u0011AA#\u0011%\tY\u0006AI\u0001\n\u0003\ti\u0006\u0003\u0004y\u0001\u0011\u0005\u0011\u0011\r\u0005\u0007q\u0002!\t!!\"\t\u000f\u0005=\u0005\u0001\"\u0001\u0002\u0012\"9\u0011q\u0012\u0001\u0005\u0002\u0005\r\u0006\"CAY\u0001E\u0005I\u0011AAZ\u0011!\t9\f\u0001C\u0001?\u0005e\u0006bBAj\u0001\u0011\u0005\u0011Q\u001b\u0005\b\u00037\u0004A\u0011BAo\u0011\u001d\tY\u000f\u0001C\u0001\u0003[Dq!a;\u0001\t\u0003\ti\u0010C\u0004\u0003\u0002\u0001!\tAa\u0001\t\u000f\t\u001d\u0001\u0001\"\u0001\u0003\n!9!q\u0001\u0001\u0005\u0002\tE\u0001b\u0002B\u0018\u0001\u0011%!\u0011\u0007\u0005\b\u0005w\u0001A\u0011\u0002B\u001f\u0011\u001d\u0011\u0019\u0006\u0001C\u0005\u0005+\u0012AbQ1dQ\u0016l\u0015M\\1hKJT!AH\u0010\u0002\u0013\u0015DXmY;uS>t'B\u0001\u0011\"\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003E\r\nQa\u001d9be.T!\u0001J\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0013aA8sO\u000e\u00011\u0003\u0002\u0001*_U\u0002\"AK\u0017\u000e\u0003-R\u0011\u0001L\u0001\u0006g\u000e\fG.Y\u0005\u0003]-\u0012a!\u00118z%\u00164\u0007C\u0001\u00194\u001b\u0005\t$B\u0001\u001a\"\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u001b2\u0005\u001daunZ4j]\u001e\u0004\"AN\u001d\u000e\u0003]R!\u0001O\u000f\u0002\u0011\u0005$\u0017\r\u001d;jm\u0016L!AO\u001c\u0003/\u0005#\u0017\r\u001d;jm\u0016\u001c\u0006/\u0019:l!2\fg\u000eS3ma\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0001>!\tq\u0004!D\u0001\u001e\u0003)\u0019\u0017m\u00195fI\u0012\u000bG/Y\u000b\u0002\u0003B\u0019!iR%\u000e\u0003\rS!\u0001R#\u0002\u0013%lW.\u001e;bE2,'B\u0001$,\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u0011\u000e\u0013!\"\u00138eKb,GmU3r!\tq$*\u0003\u0002L;\tQ1)Y2iK\u0012$\u0015\r^1\u0002\u001d\r\f7\r[3e\t\u0006$\u0018m\u0018\u0013fcR\u0011a*\u0015\t\u0003U=K!\u0001U\u0016\u0003\tUs\u0017\u000e\u001e\u0005\b%\u000e\t\t\u00111\u0001B\u0003\rAH%M\u0001\fG\u0006\u001c\u0007.\u001a3ECR\f\u0007\u0005\u000b\u0002\u0005+B\u0011!FV\u0005\u0003/.\u0012\u0001B^8mCRLG.\u001a\u0015\u0003\te\u0003\"A\u000b.\n\u0005m[#!\u0003;sC:\u001c\u0018.\u001a8u\u0003M1wN]2f\t&\u001c\u0018M\u00197f\u0007>tg-[4t+\u0005q\u0006cA0hU:\u0011\u0001-\u001a\b\u0003C\u0012l\u0011A\u0019\u0006\u0003G\u001e\na\u0001\u0010:p_Rt\u0014\"\u0001\u0017\n\u0005\u0019\\\u0013a\u00029bG.\fw-Z\u0005\u0003Q&\u00141aU3r\u0015\t17\u0006E\u0002l]Bl\u0011\u0001\u001c\u0006\u0003[F\naaY8oM&<\u0017BA8m\u0005-\u0019uN\u001c4jO\u0016sGO]=\u0011\u0005)\n\u0018B\u0001:,\u0005\u001d\u0011un\u001c7fC:\fACZ8sG\u0016$\u0015n]1cY\u0016\u001cuN\u001c4jON\u0004\u0013AC2mK\u0006\u00148)Y2iKR\ta*A\u0004jg\u0016k\u0007\u000f^=\u0016\u0003A\f!bY1dQ\u0016\fV/\u001a:z)\u0019q%0!\u0007\u00024!)10\u0003a\u0001y\u0006)\u0011/^3ssB\u001aQ0a\u0002\u0011\ty|\u00181A\u0007\u0002?%\u0019\u0011\u0011A\u0010\u0003\u000f\u0011\u000bG/Y:fiB!\u0011QAA\u0004\u0019\u0001!1\"!\u0003{\u0003\u0003\u0005\tQ!\u0001\u0002\f\t\u0019q\fJ\u0019\u0012\t\u00055\u00111\u0003\t\u0004U\u0005=\u0011bAA\tW\t9aj\u001c;iS:<\u0007c\u0001\u0016\u0002\u0016%\u0019\u0011qC\u0016\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002\u001c%\u0001\n\u00111\u0001\u0002\u001e\u0005IA/\u00192mK:\u000bW.\u001a\t\u0006U\u0005}\u00111E\u0005\u0004\u0003CY#AB(qi&|g\u000e\u0005\u0003\u0002&\u00055b\u0002BA\u0014\u0003S\u0001\"!Y\u0016\n\u0007\u0005-2&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003_\t\tD\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003WY\u0003\"CA\u001b\u0013A\u0005\t\u0019AA\u001c\u00031\u0019Ho\u001c:bO\u0016dUM^3m!\u0011\tI$a\u0010\u000e\u0005\u0005m\"bAA\u001fC\u000591\u000f^8sC\u001e,\u0017\u0002BA!\u0003w\u0011Ab\u0015;pe\u0006<W\rT3wK2\fAcY1dQ\u0016\fV/\u001a:zI\u0011,g-Y;mi\u0012\u0012TCAA$U\u0011\ti\"!\u0013,\u0005\u0005-\u0003\u0003BA'\u0003/j!!a\u0014\u000b\t\u0005E\u00131K\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0016,\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00033\nyEA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fAcY1dQ\u0016\fV/\u001a:zI\u0011,g-Y;mi\u0012\u001aTCAA0U\u0011\t9$!\u0013\u0015\u000f9\u000b\u0019'a\u001b\u0002\u0004\"1!\u0005\u0004a\u0001\u0003K\u00022A`A4\u0013\r\tIg\b\u0002\r'B\f'o[*fgNLwN\u001c\u0005\b\u0003[b\u0001\u0019AA8\u0003-\u0001H.\u00198U_\u000e\u000b7\r[3\u0011\t\u0005E\u0014qP\u0007\u0003\u0003gRA!!\u001e\u0002x\u00059An\\4jG\u0006d'\u0002BA=\u0003w\nQ\u0001\u001d7b]NT1!!  \u0003!\u0019\u0017\r^1msN$\u0018\u0002BAA\u0003g\u00121\u0002T8hS\u000e\fG\u000e\u00157b]\"9\u00111\u0004\u0007A\u0002\u0005uA#\u0003(\u0002\b\u0006%\u00151RAG\u0011\u0019\u0011S\u00021\u0001\u0002f!9\u0011QN\u0007A\u0002\u0005=\u0004bBA\u000e\u001b\u0001\u0007\u0011Q\u0004\u0005\b\u0003ki\u0001\u0019AA\u001c\u00031)hnY1dQ\u0016\fV/\u001a:z)\u0015q\u00151SAP\u0011\u0019Yh\u00021\u0001\u0002\u0016B\"\u0011qSAN!\u0011qx0!'\u0011\t\u0005\u0015\u00111\u0014\u0003\r\u0003;\u000b\u0019*!A\u0001\u0002\u000b\u0005\u00111\u0002\u0002\u0004?\u0012\u0012\u0004BBAQ\u001d\u0001\u0007\u0001/A\u0004dCN\u001c\u0017\rZ3\u0015\u00139\u000b)+a*\u0002,\u00065\u0006B\u0002\u0012\u0010\u0001\u0004\t)\u0007C\u0004\u0002*>\u0001\r!a\u001c\u0002\tAd\u0017M\u001c\u0005\u0007\u0003C{\u0001\u0019\u00019\t\u0011\u0005=v\u0002%AA\u0002A\f\u0001B\u00197pG.LgnZ\u0001\u0017k:\u001c\u0017m\u00195f#V,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011Q\u0017\u0016\u0004a\u0006%\u0013aF1oC2L(0Z\"pYVlgnQ1dQ\u0016\fV/\u001a:z)\u001dq\u00151XA`\u0003\u0003Dq!!0\u0012\u0001\u0004\t)'\u0001\u0007ta\u0006\u00148nU3tg&|g\u000eC\u0003@#\u0001\u0007\u0011\nC\u0004\u0002DF\u0001\r!!2\u0002\r\r|G.^7o!\u0011yv-a2\u0011\t\u0005%\u0017qZ\u0007\u0003\u0003\u0017TA!!4\u0002|\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\u0011\t\t.a3\u0003\u0013\u0005#HO]5ckR,\u0017!\u0004:fG\u0006\u001c\u0007.\u001a\"z!2\fg\u000eF\u0003O\u0003/\fI\u000e\u0003\u0004#%\u0001\u0007\u0011Q\r\u0005\b\u0003S\u0013\u0002\u0019AA8\u0003I\u0011XmY1dQ\u0016\u0014\u0015pQ8oI&$\u0018n\u001c8\u0015\u000b9\u000by.!9\t\r\t\u001a\u0002\u0019AA3\u0011\u001d\t\u0019o\u0005a\u0001\u0003K\f\u0011bY8oI&$\u0018n\u001c8\u0011\u000b)\n9/\u00139\n\u0007\u0005%8FA\u0005Gk:\u001cG/[8oc\u0005\u0001Bn\\8lkB\u001c\u0015m\u00195fI\u0012\u000bG/\u0019\u000b\u0005\u0003_\f\t\u0010\u0005\u0003+\u0003?I\u0005BB>\u0015\u0001\u0004\t\u0019\u0010\r\u0003\u0002v\u0006e\b\u0003\u0002@\u0000\u0003o\u0004B!!\u0002\u0002z\u0012a\u00111`Ay\u0003\u0003\u0005\tQ!\u0001\u0002\f\t\u0019q\fJ\u001a\u0015\t\u0005=\u0018q \u0005\b\u0003S+\u0002\u0019AA8\u00035)8/Z\"bG\",G\rR1uCR!\u0011q\u000eB\u0003\u0011\u001d\tIK\u0006a\u0001\u0003_\nQB]3dC\u000eDWMQ=QCRDG#\u0002(\u0003\f\t5\u0001B\u0002\u0012\u0018\u0001\u0004\t)\u0007C\u0004\u0003\u0010]\u0001\r!a\t\u0002\u0019I,7o\\;sG\u0016\u0004\u0016\r\u001e5\u0015\u000f9\u0013\u0019B!\u0006\u0003(!1!\u0005\u0007a\u0001\u0003KBqAa\u0004\u0019\u0001\u0004\u00119\u0002\u0005\u0003\u0003\u001a\t\rRB\u0001B\u000e\u0015\u0011\u0011iBa\b\u0002\u0005\u0019\u001c(b\u0001B\u0011G\u00051\u0001.\u00193p_BLAA!\n\u0003\u001c\t!\u0001+\u0019;i\u0011\u001d\u0011i\u0002\u0007a\u0001\u0005S\u0001BA!\u0007\u0003,%!!Q\u0006B\u000e\u0005)1\u0015\u000e\\3TsN$X-\\\u0001\u0011Y>|7.\u001e9B]\u0012\u0014VM\u001a:fg\"$r\u0001\u001dB\u001a\u0005k\u00119\u0004C\u0004\u0002*f\u0001\r!a\u001c\t\u000f\tu\u0011\u00041\u0001\u0003*!9!\u0011H\rA\u0002\t]\u0011!D9vC2Lg-[3e!\u0006$\b.A\u000esK\u001a\u0014Xm\u001d5GS2,\u0017J\u001c3fq&3g*Z2fgN\f'/\u001f\u000b\ba\n}\"q\nB)\u0011\u001d\u0011\tE\u0007a\u0001\u0005\u0007\n\u0011BZ5mK&sG-\u001a=\u0011\t\t\u0015#1J\u0007\u0003\u0005\u000fR1A!\u0013\u001e\u0003-!\u0017\r^1t_V\u00148-Z:\n\t\t5#q\t\u0002\n\r&dW-\u00138eKbDqA!\b\u001b\u0001\u0004\u0011I\u0003C\u0004\u0003:i\u0001\rAa\u0006\u0002?\u001d,Go\u0014:DY>tWmU3tg&|gnV5uQ\u000e{gNZ5hg>3g\r\u0006\u0003\u0002f\t]\u0003b\u0002B-7\u0001\u0007\u0011QM\u0001\bg\u0016\u001c8/[8o\u0001")
public class CacheManager
implements Logging,
AdaptiveSparkPlanHelper {
    private volatile transient IndexedSeq<CachedData> cachedData;
    private final Seq<ConfigEntry<Object>> forceDisableConfigs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public Option<SparkPlan> find(SparkPlan p, Function1<SparkPlan, Object> f) {
        return AdaptiveSparkPlanHelper.find$(this, p, f);
    }

    @Override
    public void foreach(SparkPlan p, Function1<SparkPlan, BoxedUnit> f) {
        AdaptiveSparkPlanHelper.foreach$(this, p, f);
    }

    @Override
    public void foreachUp(SparkPlan p, Function1<SparkPlan, BoxedUnit> f) {
        AdaptiveSparkPlanHelper.foreachUp$(this, p, f);
    }

    @Override
    public <A> Seq<A> mapPlans(SparkPlan p, Function1<SparkPlan, A> f) {
        return AdaptiveSparkPlanHelper.mapPlans$(this, p, f);
    }

    @Override
    public <A> Seq<A> flatMap(SparkPlan p, Function1<SparkPlan, IterableOnce<A>> f) {
        return AdaptiveSparkPlanHelper.flatMap$(this, p, f);
    }

    @Override
    public <B> Seq<B> collect(SparkPlan p, PartialFunction<SparkPlan, B> pf) {
        return AdaptiveSparkPlanHelper.collect$(this, p, pf);
    }

    @Override
    public Seq<SparkPlan> collectLeaves(SparkPlan p) {
        return AdaptiveSparkPlanHelper.collectLeaves$(this, p);
    }

    @Override
    public <B> Option<B> collectFirst(SparkPlan p, PartialFunction<SparkPlan, B> pf) {
        return AdaptiveSparkPlanHelper.collectFirst$(this, p, pf);
    }

    @Override
    public <B> Seq<B> collectWithSubqueries(SparkPlan p, PartialFunction<SparkPlan, B> f) {
        return AdaptiveSparkPlanHelper.collectWithSubqueries$(this, p, f);
    }

    @Override
    public Seq<SparkPlan> subqueriesAll(SparkPlan p) {
        return AdaptiveSparkPlanHelper.subqueriesAll$(this, p);
    }

    @Override
    public SparkPlan stripAQEPlan(SparkPlan p) {
        return AdaptiveSparkPlanHelper.stripAQEPlan$(this, p);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private IndexedSeq<CachedData> cachedData() {
        return this.cachedData;
    }

    private void cachedData_$eq(IndexedSeq<CachedData> x$1) {
        this.cachedData = x$1;
    }

    private Seq<ConfigEntry<Object>> forceDisableConfigs() {
        return this.forceDisableConfigs;
    }

    public synchronized void clearCache() {
        this.cachedData().foreach((Function1 & Serializable)x$1 -> {
            CacheManager.$anonfun$clearCache$1(x$1);
            return BoxedUnit.UNIT;
        });
        this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)IndexedSeq$.MODULE$.apply((Seq)Nil$.MODULE$)));
    }

    public boolean isEmpty() {
        return this.cachedData().isEmpty();
    }

    public void cacheQuery(Dataset<?> query, Option<String> tableName, StorageLevel storageLevel) {
        this.cacheQuery(query.sparkSession(), query.logicalPlan(), tableName, storageLevel);
    }

    public void cacheQuery(SparkSession spark, LogicalPlan planToCache, Option<String> tableName) {
        this.cacheQuery(spark, planToCache, tableName, StorageLevel$.MODULE$.MEMORY_AND_DISK());
    }

    public void cacheQuery(SparkSession spark, LogicalPlan planToCache, Option<String> tableName, StorageLevel storageLevel) {
        if (this.lookupCachedData(planToCache).nonEmpty()) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Asked to cache already cached data.");
        } else {
            SparkSession sessionWithConfigsOff = this.getOrCloneSessionWithConfigsOff(spark);
            InMemoryRelation inMemoryRelation = (InMemoryRelation)sessionWithConfigsOff.withActive((Function0 & Serializable)() -> {
                QueryExecution qe = sessionWithConfigsOff.sessionState().executePlan(planToCache, sessionWithConfigsOff.sessionState().executePlan$default$2());
                return InMemoryRelation$.MODULE$.apply(storageLevel, qe, tableName);
            });
            CacheManager cacheManager = this;
            synchronized (cacheManager) {
                if (this.lookupCachedData(planToCache).nonEmpty()) {
                    this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Data has already been cached.");
                } else {
                    CachedData cachedData = new CachedData(planToCache, inMemoryRelation);
                    this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)this.cachedData().$plus$colon((Object)cachedData)));
                }
            }
        }
    }

    public Option<String> cacheQuery$default$2() {
        return None$.MODULE$;
    }

    public StorageLevel cacheQuery$default$3() {
        return StorageLevel$.MODULE$.MEMORY_AND_DISK();
    }

    public void uncacheQuery(Dataset<?> query, boolean cascade) {
        this.uncacheQuery(query.sparkSession(), query.logicalPlan(), cascade, this.uncacheQuery$default$4());
    }

    public void uncacheQuery(SparkSession spark, LogicalPlan plan, boolean cascade, boolean blocking) {
        block3: {
            Function1 & Serializable shouldRemove = cascade ? (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheQuery$1(plan, x$2)) : (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.sameResult((QueryPlan)plan));
            IndexedSeq plansToUncache = (IndexedSeq)this.cachedData().filter((Function1 & Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheQuery$4(shouldRemove, cd)));
            CacheManager cacheManager = this;
            synchronized (cacheManager) {
                this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)this.cachedData().filterNot((Function1 & Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)plansToUncache.exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheQuery$6(cd, x$5)))))));
            }
            plansToUncache.foreach((Function1 & Serializable)x$6 -> {
                CacheManager.$anonfun$uncacheQuery$7(blocking, x$6);
                return BoxedUnit.UNIT;
            });
            if (cascade) break block3;
            this.recacheByCondition(spark, (Function1<CachedData, Object>)(Function1 & Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheQuery$8(plan, cd)));
        }
    }

    public boolean uncacheQuery$default$4() {
        return false;
    }

    public void analyzeColumnCacheQuery(SparkSession sparkSession, CachedData cachedData, Seq<Attribute> column) {
        InMemoryRelation relation = cachedData.cachedRepresentation();
        Tuple2<Object, Map<Attribute, ColumnStat>> tuple2 = CommandUtils$.MODULE$.computeColumnStats(sparkSession, relation, column);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long rowCount = tuple2._1$mcJ$sp();
        Map newColStats = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)rowCount), (Object)newColStats);
        Tuple2 tuple23 = tuple22;
        long rowCount2 = tuple23._1$mcJ$sp();
        Map newColStats2 = (Map)tuple23._2();
        relation.updateStats(rowCount2, (Map<Attribute, ColumnStat>)newColStats2);
    }

    public void recacheByPlan(SparkSession spark, LogicalPlan plan) {
        this.recacheByCondition(spark, (Function1<CachedData, Object>)(Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByPlan$1(plan, x$9)));
    }

    private void recacheByCondition(SparkSession spark, Function1<CachedData, Object> condition) {
        IndexedSeq needToRecache = (IndexedSeq)this.cachedData().filter(condition);
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)this.cachedData().filterNot((Function1 & Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)needToRecache.exists((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByCondition$2(cd, x$11)))))));
        }
        needToRecache.foreach((Function1 & Serializable)cd -> {
            CacheManager.$anonfun$recacheByCondition$3(this, spark, cd);
            return BoxedUnit.UNIT;
        });
    }

    public Option<CachedData> lookupCachedData(Dataset<?> query) {
        return this.lookupCachedData(query.logicalPlan());
    }

    public Option<CachedData> lookupCachedData(LogicalPlan plan) {
        return this.cachedData().find((Function1 & Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)plan.sameResult((QueryPlan)cd.plan())));
    }

    public LogicalPlan useCachedData(LogicalPlan plan) {
        LogicalPlan newPlan = (LogicalPlan)plan.transformDown((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheManager $outer;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                IgnoreCachedData ignoreCachedData;
                A1 A1 = x1;
                Object object = A1 instanceof IgnoreCachedData ? (ignoreCachedData = (IgnoreCachedData)A1) : this.$outer.lookupCachedData(A1).map((Function1 & Serializable)cached -> {
                    Seq hints = (Seq)EliminateResolvedHint$.MODULE$.extractHintsFromPlan(A1)._2();
                    InMemoryRelation cachedPlan = cached.cachedRepresentation().withOutput((Seq<Attribute>)A1.output());
                    return (LogicalPlan)hints.foldRight((Object)cachedPlan, (Function2 & Serializable)(x0$1, x1$1) -> {
                        Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        HintInfo hint = (HintInfo)tuple2._1();
                        LogicalPlan p = (LogicalPlan)tuple2._2();
                        ResolvedHint resolvedHint = new ResolvedHint(p, hint);
                        return resolvedHint;
                    });
                }).getOrElse((Function0 & Serializable)() -> A1);
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                boolean bl = logicalPlan2 instanceof IgnoreCachedData ? true : true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan org.apache.spark.sql.execution.CachedData ), $anonfun$applyOrElse$2(org.apache.spark.sql.catalyst.plans.logical.HintInfo org.apache.spark.sql.catalyst.plans.logical.LogicalPlan ), $anonfun$applyOrElse$3(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan )}, serializedLambda);
            }
        });
        return newPlan.transformAllExpressionsWithPruning((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.containsPattern(TreePattern$.MODULE$.PLAN_EXPRESSION())), newPlan.transformAllExpressionsWithPruning$default$2(), (PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheManager $outer;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof SubqueryExpression) {
                    SubqueryExpression subqueryExpression = (SubqueryExpression)A1;
                    object = subqueryExpression.withNewPlan(this.$outer.useCachedData((LogicalPlan)subqueryExpression.plan()));
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x2) {
                Expression expression = x2;
                boolean bl = expression instanceof SubqueryExpression;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void recacheByPath(SparkSession spark, String resourcePath) {
        Path path = new Path(resourcePath);
        FileSystem fs = path.getFileSystem(spark.sessionState().newHadoopConf());
        this.recacheByPath(spark, path, fs);
    }

    public void recacheByPath(SparkSession spark, Path resourcePath, FileSystem fs) {
        Path qualifiedPath = fs.makeQualified(resourcePath);
        this.recacheByCondition(spark, (Function1<CachedData, Object>)(Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByPath$1(this, fs, qualifiedPath, x$13)));
    }

    private boolean lookupAndRefresh(LogicalPlan plan, FileSystem fs, Path qualifiedPath) {
        DataSourceV2Relation dataSourceV2Relation;
        Table fileTable;
        boolean bl;
        LogicalPlan logicalPlan2 = plan;
        if (logicalPlan2 instanceof LogicalRelation) {
            boolean bl2;
            LogicalRelation logicalRelation = (LogicalRelation)logicalPlan2;
            BaseRelation baseRelation = logicalRelation.relation();
            if (baseRelation instanceof HadoopFsRelation) {
                HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)baseRelation;
                bl2 = this.refreshFileIndexIfNecessary(hadoopFsRelation.location(), fs, qualifiedPath);
            } else {
                bl2 = false;
            }
            bl = bl2;
        } else if (logicalPlan2 instanceof DataSourceV2Relation && (fileTable = (dataSourceV2Relation = (DataSourceV2Relation)logicalPlan2).table()) instanceof FileTable) {
            FileTable fileTable2 = (FileTable)fileTable;
            bl = this.refreshFileIndexIfNecessary(fileTable2.fileIndex(), fs, qualifiedPath);
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean refreshFileIndexIfNecessary(FileIndex fileIndex, FileSystem fs, Path qualifiedPath) {
        boolean needToRefresh;
        block0: {
            String prefixToInvalidate = qualifiedPath.toString();
            needToRefresh = ((IterableOnceOps)fileIndex.rootPaths().map((Function1 & Serializable)x$15 -> x$15.makeQualified(fs.getUri(), fs.getWorkingDirectory()).toString())).exists((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)x$16.startsWith(prefixToInvalidate)));
            if (!needToRefresh) break block0;
            fileIndex.refresh();
        }
        return needToRefresh;
    }

    private SparkSession getOrCloneSessionWithConfigsOff(SparkSession session) {
        return BoxesRunTime.unboxToBoolean((Object)session.sessionState().conf().getConf(SQLConf$.MODULE$.CAN_CHANGE_CACHED_PLAN_OUTPUT_PARTITIONING())) ? session : SparkSession$.MODULE$.getOrCloneSessionWithConfigsOff(session, this.forceDisableConfigs());
    }

    public static final /* synthetic */ void $anonfun$clearCache$1(CachedData x$1) {
        x$1.cachedRepresentation().cacheBuilder().clearCache(x$1.cachedRepresentation().cacheBuilder().clearCache$default$1());
    }

    public static final /* synthetic */ boolean $anonfun$uncacheQuery$1(LogicalPlan plan$1, LogicalPlan x$2) {
        return x$2.find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.sameResult((QueryPlan)plan$1))).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$uncacheQuery$4(Function1 shouldRemove$1, CachedData cd) {
        return BoxesRunTime.unboxToBoolean((Object)shouldRemove$1.apply((Object)cd.plan()));
    }

    public static final /* synthetic */ boolean $anonfun$uncacheQuery$6(CachedData cd$1, CachedData x$5) {
        return x$5 == cd$1;
    }

    public static final /* synthetic */ void $anonfun$uncacheQuery$7(boolean blocking$1, CachedData x$6) {
        x$6.cachedRepresentation().cacheBuilder().clearCache(blocking$1);
    }

    public static final /* synthetic */ boolean $anonfun$uncacheQuery$8(LogicalPlan plan$1, CachedData cd) {
        boolean cacheAlreadyLoaded = cd.cachedRepresentation().cacheBuilder().isCachedColumnBuffersLoaded();
        return cd.plan().find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.sameResult((QueryPlan)plan$1))).isDefined() && !cacheAlreadyLoaded;
    }

    public static final /* synthetic */ boolean $anonfun$recacheByPlan$1(LogicalPlan plan$2, CachedData x$9) {
        return x$9.plan().find((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.sameResult((QueryPlan)plan$2))).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$recacheByCondition$2(CachedData cd$2, CachedData x$11) {
        return x$11 == cd$2;
    }

    public static final /* synthetic */ void $anonfun$recacheByCondition$3(CacheManager $this, SparkSession spark$1, CachedData cd) {
        InMemoryRelation newCache;
        cd.cachedRepresentation().cacheBuilder().clearCache(cd.cachedRepresentation().cacheBuilder().clearCache$default$1());
        SparkSession sessionWithConfigsOff = $this.getOrCloneSessionWithConfigsOff(spark$1);
        InMemoryRelation x$1 = newCache = (InMemoryRelation)sessionWithConfigsOff.withActive((Function0 & Serializable)() -> {
            QueryExecution qe = sessionWithConfigsOff.sessionState().executePlan(cd.plan(), sessionWithConfigsOff.sessionState().executePlan$default$2());
            return InMemoryRelation$.MODULE$.apply(cd.cachedRepresentation().cacheBuilder(), qe);
        });
        LogicalPlan x$2 = cd.copy$default$1();
        CachedData recomputedPlan = cd.copy(x$2, x$1);
        CacheManager cacheManager = $this;
        synchronized (cacheManager) {
            if ($this.lookupCachedData(recomputedPlan.plan()).nonEmpty()) {
                $this.logWarning((Function0<String>)(Function0 & Serializable)() -> "While recaching, data was already added to cache.");
            } else {
                CachedData cachedData = recomputedPlan;
                $this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)$this.cachedData().$plus$colon((Object)cachedData)));
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$recacheByPath$1(CacheManager $this, FileSystem fs$1, Path qualifiedPath$1, CachedData x$13) {
        return x$13.plan().find((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)$this.lookupAndRefresh(x$14, fs$1, qualifiedPath$1))).isDefined();
    }

    public CacheManager() {
        Logging.$init$((Logging)this);
        AdaptiveSparkPlanHelper.$init$(this);
        this.cachedData = (IndexedSeq)IndexedSeq$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.forceDisableConfigs = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{SQLConf$.MODULE$.ADAPTIVE_EXECUTION_ENABLED(), SQLConf$.MODULE$.AUTO_BUCKETED_SCAN_ENABLED()}));
    }
}

