/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.compression;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.columnar.BOOLEAN$;
import org.apache.spark.sql.execution.columnar.ByteBufferHelper$;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.compression.BooleanBitSet$;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType$;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\tUqAB\u0015+\u0011\u0003c\u0003H\u0002\u0004;U!\u0005Ef\u000f\u0005\u0006+\u0006!\tA\u0016\u0005\b/\u0006\u0011\r\u0011\"\u0011Y\u0011\u0019a\u0016\u0001)A\u00053\"9Q,\u0001b\u0001\n\u0003A\u0006B\u00020\u0002A\u0003%\u0011\fC\u0003`\u0003\u0011\u0005\u0003\rC\u0004\u0002\b\u0005!\t%!\u0003\t\u000f\u0005m\u0011\u0001\"\u0011\u0002\u001e\u00191\u0011\u0011C\u0001\u0001\u0003{Aa!\u0016\u0006\u0005\u0002\u0005\u001d\u0003\u0002CA'\u0015\u0001\u0007I\u0011\u0002-\t\u0013\u0005=#\u00021A\u0005\n\u0005E\u0003bBA/\u0015\u0001\u0006K!\u0017\u0005\b\u0003?RA\u0011IA1\u0011\u001d\t9H\u0003C!\u0003sBa!a!\u000b\t\u0003B\u0006BBAC\u0015\u0011\u0005\u0003LB\u0003e\u0003\u0001\t9\t\u0003\u0005u'\t\u0005\t\u0015!\u0003v\u0011\u0019)6\u0003\"\u0001\u0002\f\"A\u0011\u0011S\nC\u0002\u0013%\u0001\fC\u0004\u0002\u0014N\u0001\u000b\u0011B-\t\u0013\u0005U5\u00031A\u0005\n\u0005]\u0005\"CAP'\u0001\u0007I\u0011BAQ\u0011!\t)k\u0005Q!\n\u0005e\u0005\u0002CAT'\u0001\u0007I\u0011\u0002-\t\u0013\u0005%6\u00031A\u0005\n\u0005-\u0006bBAX'\u0001\u0006K!\u0017\u0005\b\u0003c\u001bB\u0011IAZ\u0011\u001d\tIl\u0005C!\u0003wCq!!0\u0014\t\u0003\ny\fC\u0005\u0002V\u0006\t\t\u0011\"\u0011\u0002X\"A\u0011Q]\u0001\u0002\u0002\u0013\u0005\u0001\fC\u0005\u0002h\u0006\t\t\u0011\"\u0001\u0002j\"I\u0011Q^\u0001\u0002\u0002\u0013\u0005\u0013q\u001e\u0005\n\u0003{\f\u0011\u0011!C\u0001\u0003\u007fD\u0011Ba\u0001\u0002\u0003\u0003%\tE!\u0002\t\u0013\t\u001d\u0011!!A\u0005B\t%\u0001\"\u0003B\u0006\u0003\u0005\u0005I\u0011\u0002B\u0007\u00035\u0011un\u001c7fC:\u0014\u0015\u000e^*fi*\u00111\u0006L\u0001\fG>l\u0007O]3tg&|gN\u0003\u0002.]\u0005A1m\u001c7v[:\f'O\u0003\u00020a\u0005IQ\r_3dkRLwN\u001c\u0006\u0003cI\n1a]9m\u0015\t\u0019D'A\u0003ta\u0006\u00148N\u0003\u00026m\u00051\u0011\r]1dQ\u0016T\u0011aN\u0001\u0004_J<\u0007CA\u001d\u0002\u001b\u0005Q#!\u0004\"p_2,\u0017M\u001c\"jiN+GoE\u0003\u0002y\t+\u0005\n\u0005\u0002>\u00016\taHC\u0001@\u0003\u0015\u00198-\u00197b\u0013\t\teH\u0001\u0004B]f\u0014VM\u001a\t\u0003s\rK!\u0001\u0012\u0016\u0003#\r{W\u000e\u001d:fgNLwN\\*dQ\u0016lW\r\u0005\u0002>\r&\u0011qI\u0010\u0002\b!J|G-^2u!\tI%K\u0004\u0002K!:\u00111jT\u0007\u0002\u0019*\u0011QJT\u0001\u0007yI|w\u000e\u001e \u0004\u0001%\tq(\u0003\u0002R}\u00059\u0001/Y2lC\u001e,\u0017BA*U\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t\tf(\u0001\u0004=S:LGO\u0010\u000b\u0002q\u00051A/\u001f9f\u0013\u0012,\u0012!\u0017\t\u0003{iK!a\u0017 \u0003\u0007%sG/A\u0004usB,\u0017\n\u001a\u0011\u0002\u001b\tKEkU0Q\u000bJ{Fj\u0014(H\u00039\u0011\u0015\nV*`!\u0016\u0013v\fT(O\u000f\u0002\nq\u0001Z3d_\u0012,'/\u0006\u0002bOR\u0019!m]?\u0011\u0007e\u001aW-\u0003\u0002eU\t9A)Z2pI\u0016\u0014\bC\u00014h\u0019\u0001!Q\u0001[\u0004C\u0002%\u0014\u0011\u0001V\t\u0003U6\u0004\"!P6\n\u00051t$a\u0002(pi\"Lgn\u001a\t\u0003]Fl\u0011a\u001c\u0006\u0003aB\nQ\u0001^=qKNL!A]8\u0003\u0015\u0005#x.\\5d)f\u0004X\rC\u0003u\u000f\u0001\u0007Q/\u0001\u0004ck\u001a4WM\u001d\t\u0003mnl\u0011a\u001e\u0006\u0003qf\f1A\\5p\u0015\u0005Q\u0018\u0001\u00026bm\u0006L!\u0001`<\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000fC\u0003\u007f\u000f\u0001\u0007q0\u0001\u0006d_2,XN\u001c+za\u0016\u0004R!!\u0001\u0002\u0004\u0015l\u0011\u0001L\u0005\u0004\u0003\u000ba#\u0001\u0005(bi&4XmQ8mk6tG+\u001f9f\u0003\u001d)gnY8eKJ,B!a\u0003\u0002\u0016Q!\u0011QBA\f!\u0015I\u0014qBA\n\u0013\r\t\tB\u000b\u0002\b\u000b:\u001cw\u000eZ3s!\r1\u0017Q\u0003\u0003\u0006Q\"\u0011\r!\u001b\u0005\u0007}\"\u0001\r!!\u0007\u0011\r\u0005\u0005\u00111AA\n\u0003!\u0019X\u000f\u001d9peR\u001cH\u0003BA\u0010\u0003K\u00012!PA\u0011\u0013\r\t\u0019C\u0010\u0002\b\u0005>|G.Z1o\u0011\u0019q\u0018\u00021\u0001\u0002(A\"\u0011\u0011FA\u0019!\u0019\t\t!a\u000b\u00020%\u0019\u0011Q\u0006\u0017\u0003\u0015\r{G.^7o)f\u0004X\rE\u0002g\u0003c!A\"a\r\u0002&\u0005\u0005\t\u0011!B\u0001\u0003k\u00111a\u0018\u00135#\rQ\u0017q\u0007\t\u0004{\u0005e\u0012bAA\u001e}\t\u0019\u0011I\\=\u0014\t)a\u0014q\b\t\u0006s\u0005=\u0011\u0011\t\b\u0004]\u0006\r\u0013bAA#_\u0006Y!i\\8mK\u0006tG+\u001f9f)\t\tI\u0005E\u0002\u0002L)i\u0011!A\u0001\u0012?Vt7m\\7qe\u0016\u001c8/\u001a3TSj,\u0017!F0v]\u000e|W\u000e\u001d:fgN,GmU5{K~#S-\u001d\u000b\u0005\u0003'\nI\u0006E\u0002>\u0003+J1!a\u0016?\u0005\u0011)f.\u001b;\t\u0011\u0005mS\"!AA\u0002e\u000b1\u0001\u001f\u00132\u0003IyVO\\2p[B\u0014Xm]:fINK'0\u001a\u0011\u00025\u001d\fG\u000f[3s\u0007>l\u0007O]3tg&\u0014\u0017\u000e\\5usN#\u0018\r^:\u0015\r\u0005M\u00131MA:\u0011\u001d\t)g\u0004a\u0001\u0003O\n1A]8x!\u0011\tI'a\u001c\u000e\u0005\u0005-$bAA7a\u0005A1-\u0019;bYf\u001cH/\u0003\u0003\u0002r\u0005-$aC%oi\u0016\u0014h.\u00197S_^Da!!\u001e\u0010\u0001\u0004I\u0016aB8sI&t\u0017\r\\\u0001\tG>l\u0007O]3tgR)Q/a\u001f\u0002\u0000!1\u0011Q\u0010\tA\u0002U\fAA\u001a:p[\"1\u0011\u0011\u0011\tA\u0002U\f!\u0001^8\u0002!Ut7m\\7qe\u0016\u001c8/\u001a3TSj,\u0017AD2p[B\u0014Xm]:fINK'0Z\n\u0005'q\nI\t\u0005\u0003:G\u0006\u0005C\u0003BAG\u0003\u001f\u00032!a\u0013\u0014\u0011\u0015!X\u00031\u0001v\u0003\u0015\u0019w.\u001e8u\u0003\u0019\u0019w.\u001e8uA\u0005Y1-\u001e:sK:$xk\u001c:e+\t\tI\nE\u0002>\u00037K1!!(?\u0005\u0011auN\\4\u0002\u001f\r,(O]3oi^{'\u000fZ0%KF$B!a\u0015\u0002$\"I\u00111L\r\u0002\u0002\u0003\u0007\u0011\u0011T\u0001\rGV\u0014(/\u001a8u/>\u0014H\rI\u0001\bm&\u001c\u0018\u000e^3e\u0003-1\u0018n]5uK\u0012|F%Z9\u0015\t\u0005M\u0013Q\u0016\u0005\t\u00037b\u0012\u0011!a\u00013\u0006Aa/[:ji\u0016$\u0007%\u0001\u0003oKb$HCBA*\u0003k\u000b9\fC\u0004\u0002fy\u0001\r!a\u001a\t\r\u0005Ud\u00041\u0001Z\u0003\u001dA\u0017m\u001d(fqR,\"!a\b\u0002\u0015\u0011,7m\\7qe\u0016\u001c8\u000f\u0006\u0004\u0002T\u0005\u0005\u0017\u0011\u001b\u0005\b\u0003\u0007\u0004\u0003\u0019AAc\u00031\u0019w\u000e\\;n]Z+7\r^8s!\u0011\t9-!4\u000e\u0005\u0005%'bAAf]\u0005Qa/Z2u_JL'0\u001a3\n\t\u0005=\u0017\u0011\u001a\u0002\u0015/JLG/\u00192mK\u000e{G.^7o-\u0016\u001cGo\u001c:\t\r\u0005M\u0007\u00051\u0001Z\u0003!\u0019\u0017\r]1dSRL\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002ZB!\u00111\\Aq\u001b\t\tiNC\u0002\u0002`f\fA\u0001\\1oO&!\u00111]Ao\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u001c\u0003WD\u0001\"a\u0017$\u0003\u0003\u0005\r!W\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011\u0011\u001f\t\u0007\u0003g\fI0a\u000e\u000e\u0005\u0005U(bAA|}\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005m\u0018Q\u001f\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002 \t\u0005\u0001\"CA.K\u0005\u0005\t\u0019AA\u001c\u0003!A\u0017m\u001d5D_\u0012,G#A-\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!7\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t=\u0001\u0003BAn\u0005#IAAa\u0005\u0002^\n1qJ\u00196fGR\u0004")
public final class BooleanBitSet {
    public static String toString() {
        return BooleanBitSet$.MODULE$.toString();
    }

    public static int hashCode() {
        return BooleanBitSet$.MODULE$.hashCode();
    }

    public static boolean canEqual(Object object) {
        return BooleanBitSet$.MODULE$.canEqual(object);
    }

    public static Iterator<Object> productIterator() {
        return BooleanBitSet$.MODULE$.productIterator();
    }

    public static Object productElement(int n) {
        return BooleanBitSet$.MODULE$.productElement(n);
    }

    public static int productArity() {
        return BooleanBitSet$.MODULE$.productArity();
    }

    public static String productPrefix() {
        return BooleanBitSet$.MODULE$.productPrefix();
    }

    public static boolean supports(ColumnType<?> columnType) {
        return BooleanBitSet$.MODULE$.supports(columnType);
    }

    public static <T extends AtomicType> org.apache.spark.sql.execution.columnar.compression.Encoder<T> encoder(NativeColumnType<T> nativeColumnType) {
        return BooleanBitSet$.MODULE$.encoder(nativeColumnType);
    }

    public static <T extends AtomicType> org.apache.spark.sql.execution.columnar.compression.Decoder<T> decoder(ByteBuffer byteBuffer, NativeColumnType<T> nativeColumnType) {
        return BooleanBitSet$.MODULE$.decoder(byteBuffer, nativeColumnType);
    }

    public static int BITS_PER_LONG() {
        return BooleanBitSet$.MODULE$.BITS_PER_LONG();
    }

    public static int typeId() {
        return BooleanBitSet$.MODULE$.typeId();
    }

    public static Iterator<String> productElementNames() {
        return BooleanBitSet$.MODULE$.productElementNames();
    }

    public static String productElementName(int n) {
        return BooleanBitSet$.MODULE$.productElementName(n);
    }

    public static class Decoder
    implements org.apache.spark.sql.execution.columnar.compression.Decoder<BooleanType$> {
        private final ByteBuffer buffer;
        private final int count;
        private long currentWord;
        private int visited;

        private int count() {
            return this.count;
        }

        private long currentWord() {
            return this.currentWord;
        }

        private void currentWord_$eq(long x$1) {
            this.currentWord = x$1;
        }

        private int visited() {
            return this.visited;
        }

        private void visited_$eq(int x$1) {
            this.visited = x$1;
        }

        @Override
        public void next(InternalRow row, int ordinal) {
            int bit = this.visited() % BooleanBitSet$.MODULE$.BITS_PER_LONG();
            this.visited_$eq(this.visited() + 1);
            if (bit == 0) {
                this.currentWord_$eq(ByteBufferHelper$.MODULE$.getLong(this.buffer));
            }
            row.setBoolean(ordinal, (this.currentWord() >> bit & 1L) != 0L);
        }

        @Override
        public boolean hasNext() {
            return this.visited() < this.count();
        }

        @Override
        public void decompress(WritableColumnVector columnVector, int capacity) {
            long currentWordLocal = 0L;
            int visitedLocal = 0;
            ByteBuffer nullsBuffer = this.buffer.duplicate().order(ByteOrder.nativeOrder());
            nullsBuffer.rewind();
            int nullCount = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
            int nextNullIndex = nullCount > 0 ? ByteBufferHelper$.MODULE$.getInt(nullsBuffer) : -1;
            int seenNulls = 0;
            for (int pos = 0; pos < capacity; ++pos) {
                if (pos != nextNullIndex) {
                    int bit = visitedLocal % BooleanBitSet$.MODULE$.BITS_PER_LONG();
                    ++visitedLocal;
                    if (bit == 0) {
                        currentWordLocal = ByteBufferHelper$.MODULE$.getLong(this.buffer);
                    }
                    columnVector.putBoolean(pos, (currentWordLocal >> bit & 1L) != 0L);
                    continue;
                }
                if (++seenNulls < nullCount) {
                    nextNullIndex = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
                }
                columnVector.putNull(pos);
            }
        }

        public Decoder(ByteBuffer buffer) {
            this.buffer = buffer;
            this.count = ByteBufferHelper$.MODULE$.getInt(buffer);
            this.currentWord = 0L;
            this.visited = 0;
        }
    }

    public static class Encoder
    implements org.apache.spark.sql.execution.columnar.compression.Encoder<BooleanType$> {
        private int _uncompressedSize;

        @Override
        public double compressionRatio() {
            return org.apache.spark.sql.execution.columnar.compression.Encoder.compressionRatio$(this);
        }

        private int _uncompressedSize() {
            return this._uncompressedSize;
        }

        private void _uncompressedSize_$eq(int x$1) {
            this._uncompressedSize = x$1;
        }

        @Override
        public void gatherCompressibilityStats(InternalRow row, int ordinal) {
            this._uncompressedSize_$eq(this._uncompressedSize() + BOOLEAN$.MODULE$.defaultSize());
        }

        @Override
        public ByteBuffer compress(ByteBuffer from, ByteBuffer to) {
            Object object;
            to.putInt(BooleanBitSet$.MODULE$.typeId()).putInt(from.remaining());
            while (from.remaining() >= BooleanBitSet$.MODULE$.BITS_PER_LONG()) {
                long word = 0L;
                for (int i = 0; i < BooleanBitSet$.MODULE$.BITS_PER_LONG(); ++i) {
                    if (!BOOLEAN$.MODULE$.extract(from)) continue;
                    word |= 1L << i;
                }
                to.putLong(word);
            }
            if (from.hasRemaining()) {
                long word = 0L;
                int i = 0;
                while (from.hasRemaining()) {
                    if (BOOLEAN$.MODULE$.extract(from)) {
                        word |= 1L << i;
                    }
                    ++i;
                }
                object = to.putLong(word);
            } else {
                object = BoxedUnit.UNIT;
            }
            to.rewind();
            return to;
        }

        @Override
        public int uncompressedSize() {
            return this._uncompressedSize();
        }

        @Override
        public int compressedSize() {
            int extra = this._uncompressedSize() % BooleanBitSet$.MODULE$.BITS_PER_LONG() == 0 ? 0 : 1;
            return (this._uncompressedSize() / BooleanBitSet$.MODULE$.BITS_PER_LONG() + extra) * 8 + 4;
        }

        public Encoder() {
            org.apache.spark.sql.execution.columnar.compression.Encoder.$init$(this);
            this._uncompressedSize = 0;
        }
    }
}

