/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.CatalogUtils$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.command.CreateDataSourceTableCommand$;
import org.apache.spark.sql.execution.command.LeafRunnableCommand;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.internal.SessionState;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.StructType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005=e\u0001\u0002\r\u001a\u0001\u001aB\u0001b\u0012\u0001\u0003\u0016\u0004%\t\u0001\u0013\u0005\t\u001f\u0002\u0011\t\u0012)A\u0005\u0013\"A\u0001\u000b\u0001BK\u0002\u0013\u0005\u0011\u000b\u0003\u0005V\u0001\tE\t\u0015!\u0003S\u0011\u00151\u0006\u0001\"\u0001X\u0011\u0015Y\u0006\u0001\"\u0011]\u0011\u001dI\u0007!!A\u0005\u0002)Dq!\u001c\u0001\u0012\u0002\u0013\u0005a\u000eC\u0004z\u0001E\u0005I\u0011\u0001>\t\u000fq\u0004\u0011\u0011!C!{\"I\u0011Q\u0002\u0001\u0002\u0002\u0013\u0005\u0011q\u0002\u0005\n\u0003/\u0001\u0011\u0011!C\u0001\u00033A\u0011\"!\n\u0001\u0003\u0003%\t%a\n\t\u0013\u0005U\u0002!!A\u0005\u0002\u0005]\u0002\"CA\u001e\u0001\u0005\u0005I\u0011IA\u001f\u0011%\t\t\u0005AA\u0001\n\u0003\n\u0019eB\u0005\u0002He\t\t\u0011#\u0001\u0002J\u0019A\u0001$GA\u0001\u0012\u0003\tY\u0005\u0003\u0004W%\u0011\u0005\u00111\r\u0005\n\u0003K\u0012\u0012\u0011!C#\u0003OB\u0011\"!\u001b\u0013\u0003\u0003%\t)a\u001b\t\u0013\u0005E$#!A\u0005\u0002\u0006M\u0004\"CAC%\u0005\u0005I\u0011BAD\u0005q\u0019%/Z1uK\u0012\u000bG/Y*pkJ\u001cW\rV1cY\u0016\u001cu.\\7b]\u0012T!AG\u000e\u0002\u000f\r|W.\\1oI*\u0011A$H\u0001\nKb,7-\u001e;j_:T!AH\u0010\u0002\u0007M\fHN\u0003\u0002!C\u0005)1\u000f]1sW*\u0011!eI\u0001\u0007CB\f7\r[3\u000b\u0003\u0011\n1a\u001c:h\u0007\u0001\u0019R\u0001A\u00142km\u0002\"\u0001K\u0018\u000e\u0003%R!AK\u0016\u0002\u000f1|w-[2bY*\u0011A&L\u0001\u0006a2\fgn\u001d\u0006\u0003]u\t\u0001bY1uC2L8\u000f^\u0005\u0003a%\u00121\u0002T8hS\u000e\fG\u000e\u00157b]B\u0011!gM\u0007\u00023%\u0011A'\u0007\u0002\u0014\u0019\u0016\fgMU;o]\u0006\u0014G.Z\"p[6\fg\u000e\u001a\t\u0003mej\u0011a\u000e\u0006\u0002q\u0005)1oY1mC&\u0011!h\u000e\u0002\b!J|G-^2u!\taDI\u0004\u0002>\u0005:\u0011a(Q\u0007\u0002\u007f)\u0011\u0001)J\u0001\u0007yI|w\u000e\u001e \n\u0003aJ!aQ\u001c\u0002\u000fA\f7m[1hK&\u0011QI\u0012\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\u0007^\nQ\u0001^1cY\u0016,\u0012!\u0013\t\u0003\u00156k\u0011a\u0013\u0006\u0003\u00196\nqaY1uC2|w-\u0003\u0002O\u0017\na1)\u0019;bY><G+\u00192mK\u00061A/\u00192mK\u0002\na\"[4o_J,\u0017JZ#ySN$8/F\u0001S!\t14+\u0003\u0002Uo\t9!i\\8mK\u0006t\u0017aD5h]>\u0014X-\u00134Fq&\u001cHo\u001d\u0011\u0002\rqJg.\u001b;?)\rA\u0016L\u0017\t\u0003e\u0001AQaR\u0003A\u0002%CQ\u0001U\u0003A\u0002I\u000b1A];o)\tiF\rE\u0002==\u0002L!a\u0018$\u0003\u0007M+\u0017\u000f\u0005\u0002bE6\tQ$\u0003\u0002d;\t\u0019!k\\<\t\u000b\u00154\u0001\u0019\u00014\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005\u0005<\u0017B\u00015\u001e\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003\u0011\u0019w\u000e]=\u0015\u0007a[G\u000eC\u0004H\u000fA\u0005\t\u0019A%\t\u000fA;\u0001\u0013!a\u0001%\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#A8+\u0005%\u00038&A9\u0011\u0005I<X\"A:\u000b\u0005Q,\u0018!C;oG\",7m[3e\u0015\t1x'\u0001\u0006b]:|G/\u0019;j_:L!\u0001_:\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003mT#A\u00159\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\u0005q\bcA@\u0002\n5\u0011\u0011\u0011\u0001\u0006\u0005\u0003\u0007\t)!\u0001\u0003mC:<'BAA\u0004\u0003\u0011Q\u0017M^1\n\t\u0005-\u0011\u0011\u0001\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005E\u0001c\u0001\u001c\u0002\u0014%\u0019\u0011QC\u001c\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005m\u0011\u0011\u0005\t\u0004m\u0005u\u0011bAA\u0010o\t\u0019\u0011I\\=\t\u0013\u0005\rB\"!AA\u0002\u0005E\u0011a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002*A1\u00111FA\u0019\u00037i!!!\f\u000b\u0007\u0005=r'\u0001\u0006d_2dWm\u0019;j_:LA!a\r\u0002.\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\r\u0011\u0016\u0011\b\u0005\n\u0003Gq\u0011\u0011!a\u0001\u00037\t!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR\u0019a0a\u0010\t\u0013\u0005\rr\"!AA\u0002\u0005E\u0011AB3rk\u0006d7\u000fF\u0002S\u0003\u000bB\u0011\"a\t\u0011\u0003\u0003\u0005\r!a\u0007\u00029\r\u0013X-\u0019;f\t\u0006$\u0018mU8ve\u000e,G+\u00192mK\u000e{W.\\1oIB\u0011!GE\n\u0006%\u00055\u0013\u0011\f\t\b\u0003\u001f\n)&\u0013*Y\u001b\t\t\tFC\u0002\u0002T]\nqA];oi&lW-\u0003\u0003\u0002X\u0005E#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!\u00111LA1\u001b\t\tiF\u0003\u0003\u0002`\u0005\u0015\u0011AA5p\u0013\r)\u0015Q\f\u000b\u0003\u0003\u0013\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002}\u0006)\u0011\r\u001d9msR)\u0001,!\u001c\u0002p!)q)\u0006a\u0001\u0013\")\u0001+\u0006a\u0001%\u00069QO\\1qa2LH\u0003BA;\u0003\u0003\u0003RANA<\u0003wJ1!!\u001f8\u0005\u0019y\u0005\u000f^5p]B)a'! J%&\u0019\u0011qP\u001c\u0003\rQ+\b\u000f\\33\u0011!\t\u0019IFA\u0001\u0002\u0004A\u0016a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011\u0011\u0012\t\u0004\u007f\u0006-\u0015\u0002BAG\u0003\u0003\u0011aa\u00142kK\u000e$\b")
public class CreateDataSourceTableCommand
extends LogicalPlan
implements LeafRunnableCommand,
Serializable {
    private final CatalogTable table;
    private final boolean ignoreIfExists;
    private Map<String, SQLMetric> metrics;
    private Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<CatalogTable, Object>> unapply(CreateDataSourceTableCommand createDataSourceTableCommand) {
        return CreateDataSourceTableCommand$.MODULE$.unapply(createDataSourceTableCommand);
    }

    public static Function1<Tuple2<CatalogTable, Object>, CreateDataSourceTableCommand> tupled() {
        return CreateDataSourceTableCommand$.MODULE$.tupled();
    }

    public static Function1<CatalogTable, Function1<Object, CreateDataSourceTableCommand>> curried() {
        return CreateDataSourceTableCommand$.MODULE$.curried();
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        CreateDataSourceTableCommand createDataSourceTableCommand = this;
        synchronized (createDataSourceTableCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public CatalogTable table() {
        return this.table;
    }

    public boolean ignoreIfExists() {
        return this.ignoreIfExists;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        CatalogTable catalogTable;
        HadoopFsRelation hadoopFsRelation;
        Seq seq;
        CatalogTableType catalogTableType = this.table().tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        Predef$.MODULE$.assert(catalogTableType == null ? catalogTableType2 != null : !catalogTableType.equals(catalogTableType2));
        Predef$.MODULE$.assert(this.table().provider().isDefined());
        SessionState sessionState = sparkSession.sessionState();
        if (sessionState.catalog().tableExists(this.table().identifier())) {
            if (this.ignoreIfExists()) {
                return (Seq)package$.MODULE$.Seq().empty();
            }
            throw QueryCompilationErrors$.MODULE$.tableAlreadyExistsError(this.table().identifier().unquotedString(), QueryCompilationErrors$.MODULE$.tableAlreadyExistsError$default$2());
        }
        Option pathOption = this.table().storage().locationUri().map((Function1 & Serializable)x$1 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)CatalogUtils$.MODULE$.URIToString(x$1)));
        Some x$12 = new Some(this.table().identifier().database().getOrElse((Function0 & Serializable)() -> sessionState.catalog().getCurrentDatabase()));
        String x$2 = this.table().identifier().copy$default$1();
        TableIdentifier x$3 = this.table().identifier().copy(x$2, (Option)x$12);
        boolean x$4 = sessionState.conf().manageFilesourcePartitions();
        CatalogTableType x$5 = this.table().copy$default$2();
        CatalogStorageFormat x$6 = this.table().copy$default$3();
        StructType x$7 = this.table().copy$default$4();
        Option x$8 = this.table().copy$default$5();
        Seq x$9 = this.table().copy$default$6();
        Option x$10 = this.table().copy$default$7();
        String x$11 = this.table().copy$default$8();
        long x$122 = this.table().copy$default$9();
        long x$13 = this.table().copy$default$10();
        String x$14 = this.table().copy$default$11();
        Map x$15 = this.table().copy$default$12();
        Option x$16 = this.table().copy$default$13();
        Option x$17 = this.table().copy$default$14();
        Option x$18 = this.table().copy$default$15();
        Seq x$19 = this.table().copy$default$16();
        boolean x$20 = this.table().copy$default$18();
        Map x$21 = this.table().copy$default$19();
        Option x$22 = this.table().copy$default$20();
        CatalogTable tableWithDefaultOptions = this.table().copy(x$3, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$122, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$4, x$20, x$21, x$22);
        SparkSession x$23 = sparkSession;
        None$ x$24 = this.table().schema().isEmpty() ? None$.MODULE$ : new Some((Object)this.table().schema());
        Seq x$25 = this.table().partitionColumnNames();
        String x$26 = (String)this.table().provider().get();
        Option x$27 = this.table().bucketSpec();
        Map x$28 = (Map)this.table().storage().properties().$plus$plus((IterableOnce)pathOption);
        Some x$29 = new Some((Object)tableWithDefaultOptions);
        Seq<String> x$30 = DataSource$.MODULE$.apply$default$3();
        BaseRelation dataSource = new DataSource(x$23, x$26, x$30, (Option<StructType>)x$24, (Seq<String>)x$25, (Option<BucketSpec>)x$27, (Map<String, String>)x$28, (Option<CatalogTable>)x$29).resolveRelation(false);
        if (this.table().schema().nonEmpty()) {
            seq = this.table().partitionColumnNames();
        } else {
            Nil$ nil$;
            Predef$.MODULE$.assert(this.table().partitionColumnNames().isEmpty());
            BaseRelation baseRelation = dataSource;
            if (baseRelation instanceof HadoopFsRelation) {
                HadoopFsRelation hadoopFsRelation2 = (HadoopFsRelation)baseRelation;
                nil$ = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])hadoopFsRelation2.partitionSchema().fieldNames()));
            } else {
                nil$ = package$.MODULE$.Nil();
            }
            seq = nil$;
        }
        Seq partitionColumnNames = seq;
        BaseRelation baseRelation = dataSource;
        if (baseRelation instanceof HadoopFsRelation && (hadoopFsRelation = (HadoopFsRelation)baseRelation).overlappedPartCols().nonEmpty()) {
            this.logWarning((Function0 & Serializable)() -> "It is not recommended to create a table with overlapped data and partition columns, as Spark cannot store a valid table schema and has to infer it at runtime, which hurts performance. Please check your data files and remove the partition columns in it.");
            StructType x$31 = new StructType();
            Nil$ x$32 = package$.MODULE$.Nil();
            TableIdentifier x$33 = this.table().copy$default$1();
            CatalogTableType x$34 = this.table().copy$default$2();
            CatalogStorageFormat x$35 = this.table().copy$default$3();
            Option x$36 = this.table().copy$default$5();
            Option x$37 = this.table().copy$default$7();
            String x$38 = this.table().copy$default$8();
            long x$39 = this.table().copy$default$9();
            long x$40 = this.table().copy$default$10();
            String x$41 = this.table().copy$default$11();
            Map x$42 = this.table().copy$default$12();
            Option x$43 = this.table().copy$default$13();
            Option x$44 = this.table().copy$default$14();
            Option x$45 = this.table().copy$default$15();
            Seq x$46 = this.table().copy$default$16();
            boolean x$47 = this.table().copy$default$17();
            boolean x$48 = this.table().copy$default$18();
            Map x$49 = this.table().copy$default$19();
            Option x$50 = this.table().copy$default$20();
            catalogTable = this.table().copy(x$33, x$34, x$35, x$31, x$36, (Seq)x$32, x$37, x$38, x$39, x$40, x$41, x$42, x$43, x$44, x$45, x$46, x$47, x$48, x$49, x$50);
        } else {
            StructType x$51 = dataSource.schema();
            Seq x$52 = partitionColumnNames;
            boolean x$53 = partitionColumnNames.nonEmpty() && sessionState.conf().manageFilesourcePartitions();
            TableIdentifier x$54 = this.table().copy$default$1();
            CatalogTableType x$55 = this.table().copy$default$2();
            CatalogStorageFormat x$56 = this.table().copy$default$3();
            Option x$57 = this.table().copy$default$5();
            Option x$58 = this.table().copy$default$7();
            String x$59 = this.table().copy$default$8();
            long x$60 = this.table().copy$default$9();
            long x$61 = this.table().copy$default$10();
            String x$62 = this.table().copy$default$11();
            Map x$63 = this.table().copy$default$12();
            Option x$64 = this.table().copy$default$13();
            Option x$65 = this.table().copy$default$14();
            Option x$66 = this.table().copy$default$15();
            Seq x$67 = this.table().copy$default$16();
            boolean x$68 = this.table().copy$default$18();
            Map x$69 = this.table().copy$default$19();
            Option x$70 = this.table().copy$default$20();
            catalogTable = this.table().copy(x$54, x$55, x$56, x$51, x$57, x$52, x$58, x$59, x$60, x$61, x$62, x$63, x$64, x$65, x$66, x$67, x$53, x$68, x$69, x$70);
        }
        CatalogTable newTable = catalogTable;
        sessionState.catalog().createTable(newTable, false, sessionState.catalog().createTable$default$3());
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public CreateDataSourceTableCommand copy(CatalogTable table, boolean ignoreIfExists) {
        return new CreateDataSourceTableCommand(table, ignoreIfExists);
    }

    public CatalogTable copy$default$1() {
        return this.table();
    }

    public boolean copy$default$2() {
        return this.ignoreIfExists();
    }

    public String productPrefix() {
        return "CreateDataSourceTableCommand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.table();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ignoreIfExists());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CreateDataSourceTableCommand;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "table";
                break;
            }
            case 1: {
                string = "ignoreIfExists";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CreateDataSourceTableCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        CreateDataSourceTableCommand createDataSourceTableCommand = (CreateDataSourceTableCommand)x$1;
        if (this.ignoreIfExists() != createDataSourceTableCommand.ignoreIfExists()) return false;
        CatalogTable catalogTable = this.table();
        CatalogTable catalogTable2 = createDataSourceTableCommand.table();
        if (catalogTable == null) {
            if (catalogTable2 != null) {
                return false;
            }
        } else if (!catalogTable.equals(catalogTable2)) return false;
        if (!createDataSourceTableCommand.canEqual(this)) return false;
        return true;
    }

    public CreateDataSourceTableCommand(CatalogTable table, boolean ignoreIfExists) {
        this.table = table;
        this.ignoreIfExists = ignoreIfExists;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
        LeafLike.$init$((LeafLike)this);
        Statics.releaseFence();
    }
}

