/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.net.URI;
import java.time.ZoneId;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetOutputCommitter;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.codec.CodecConfig;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.util.ContextUtil;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFilters;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFooterReader;
import org.apache.spark.sql.execution.datasources.parquet.ParquetLogRedirector;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOutputWriter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetUtils$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedParquetRecordReader;
import org.apache.spark.sql.execution.vectorized.OffHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.AnsiIntervalType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

@ScalaSignature(bytes="\u0006\u0005\tUc\u0001B\r\u001b\u0001%BQ\u0001\u0014\u0001\u0005\u00025Cq\u0001\u0015\u0001C\u0002\u0013%\u0011\u000b\u0003\u0004V\u0001\u0001\u0006IA\u0015\u0005\u0006-\u0002!\te\u0016\u0005\u0006A\u0002!\te\u0016\u0005\u0006C\u0002!\tE\u0019\u0005\u0006M\u0002!\te\u001a\u0005\u0006a\u0002!\t%\u001d\u0005\b\u0003K\u0001A\u0011IA\u0014\u0011\u001d\tY\u0005\u0001C!\u0003\u001bBq!!\u0016\u0001\t\u0003\n9\u0006C\u0004\u0002t\u0001!\t%!\u001e\t\u000f\u0005\u0015\u0005\u0001\"\u0011\u0002\b\"9\u0011Q\u001a\u0001\u0005B\u0005=\u0007bBAn\u0001\u0011\u0005\u0013Q\\\u0004\b\u0003GT\u0002\u0012AAs\r\u0019I\"\u0004#\u0001\u0002h\"1A*\u0005C\u0001\u0003oD\u0001\"!?\u0012\t\u0003Q\u00121 \u0005\t\u0005#\tB\u0011\u0001\u000e\u0003\u0014!9!qD\t\u0005\u0002\t\u0005\u0002b\u0002B\u0016#\u0011\u0005!Q\u0006\u0005\b\u0005{\tB\u0011\u0002B \u0011%\u0011)%EA\u0001\n\u0013\u00119EA\tQCJ\fX/\u001a;GS2,gi\u001c:nCRT!a\u0007\u000f\u0002\u000fA\f'/];fi*\u0011QDH\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002 A\u0005IQ\r_3dkRLwN\u001c\u0006\u0003C\t\n1a]9m\u0015\t\u0019C%A\u0003ta\u0006\u00148N\u0003\u0002&M\u00051\u0011\r]1dQ\u0016T\u0011aJ\u0001\u0004_J<7\u0001A\n\u0007\u0001)\u0002DG\u000f!\u0011\u0005-rS\"\u0001\u0017\u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0003\r\u0005s\u0017PU3g!\t\t$'D\u0001\u001d\u0013\t\u0019DD\u0001\u0006GS2,gi\u001c:nCR\u0004\"!\u000e\u001d\u000e\u0003YR!a\u000e\u0011\u0002\u000fM|WO]2fg&\u0011\u0011H\u000e\u0002\u0013\t\u0006$\u0018mU8ve\u000e,'+Z4jgR,'\u000f\u0005\u0002<}5\tAH\u0003\u0002>E\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002@y\t9Aj\\4hS:<\u0007CA!J\u001d\t\u0011uI\u0004\u0002D\r6\tAI\u0003\u0002FQ\u00051AH]8pizJ\u0011!L\u0005\u0003\u00112\nq\u0001]1dW\u0006<W-\u0003\u0002K\u0017\na1+\u001a:jC2L'0\u00192mK*\u0011\u0001\nL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00039\u0003\"a\u0014\u0001\u000e\u0003i\tA\u0003]1scV,G\u000fT8h%\u0016$\u0017N]3di>\u0014X#\u0001*\u0011\u0005=\u001b\u0016B\u0001+\u001b\u0005Q\u0001\u0016M]9vKRdun\u001a*fI&\u0014Xm\u0019;pe\u0006)\u0002/\u0019:rk\u0016$Hj\\4SK\u0012L'/Z2u_J\u0004\u0013!C:i_J$h*Y7f)\u0005A\u0006CA-^\u001d\tQ6\f\u0005\u0002DY%\u0011A\fL\u0001\u0007!J,G-\u001a4\n\u0005y{&AB*ue&twM\u0003\u0002]Y\u0005AAo\\*ue&tw-\u0001\u0005iCND7i\u001c3f)\u0005\u0019\u0007CA\u0016e\u0013\t)GFA\u0002J]R\fa!Z9vC2\u001cHC\u00015l!\tY\u0013.\u0003\u0002kY\t9!i\\8mK\u0006t\u0007\"\u00027\b\u0001\u0004i\u0017!B8uQ\u0016\u0014\bCA\u0016o\u0013\tyGFA\u0002B]f\fA\u0002\u001d:fa\u0006\u0014Xm\u0016:ji\u0016$rA];|\u0003\u0017\t)\u0002\u0005\u00022g&\u0011A\u000f\b\u0002\u0014\u001fV$\b/\u001e;Xe&$XM\u001d$bGR|'/\u001f\u0005\u0006m\"\u0001\ra^\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003qfl\u0011\u0001I\u0005\u0003u\u0002\u0012Ab\u00159be.\u001cVm]:j_:DQ\u0001 \u0005A\u0002u\f1A[8c!\rq\u0018qA\u0007\u0002\u007f*!\u0011\u0011AA\u0002\u0003%i\u0017\r\u001d:fIV\u001cWMC\u0002\u0002\u0006\u0011\na\u0001[1e_>\u0004\u0018bAA\u0005\u007f\n\u0019!j\u001c2\t\u000f\u00055\u0001\u00021\u0001\u0002\u0010\u00059q\u000e\u001d;j_:\u001c\b#B-\u0002\u0012aC\u0016bAA\n?\n\u0019Q*\u00199\t\u000f\u0005]\u0001\u00021\u0001\u0002\u001a\u0005QA-\u0019;b'\u000eDW-\\1\u0011\t\u0005m\u0011\u0011E\u0007\u0003\u0003;Q1!a\b!\u0003\u0015!\u0018\u0010]3t\u0013\u0011\t\u0019#!\b\u0003\u0015M#(/^2u)f\u0004X-A\u0006j]\u001a,'oU2iK6\fG\u0003CA\u0015\u0003_\t\t$!\u000e\u0011\u000b-\nY#!\u0007\n\u0007\u00055BF\u0001\u0004PaRLwN\u001c\u0005\u0006m&\u0001\ra\u001e\u0005\b\u0003gI\u0001\u0019AA\b\u0003)\u0001\u0018M]1nKR,'o\u001d\u0005\b\u0003oI\u0001\u0019AA\u001d\u0003\u00151\u0017\u000e\\3t!\u0015\t\u00151HA \u0013\r\tid\u0013\u0002\u0004'\u0016\f\b\u0003BA!\u0003\u000fj!!a\u0011\u000b\t\u0005\u0015\u00131A\u0001\u0003MNLA!!\u0013\u0002D\tQa)\u001b7f'R\fG/^:\u0002\u0019M,\b\u000f]8si\n\u000bGo\u00195\u0015\u000b!\fy%!\u0015\t\u000bYT\u0001\u0019A<\t\u000f\u0005M#\u00021\u0001\u0002\u001a\u000511o\u00195f[\u0006\f1B^3di>\u0014H+\u001f9fgRA\u0011\u0011LA/\u0003C\n)\u0007E\u0003,\u0003W\tY\u0006\u0005\u0003B\u0003wA\u0006bBA0\u0017\u0001\u0007\u0011\u0011D\u0001\u000fe\u0016\fX/\u001b:fIN\u001b\u0007.Z7b\u0011\u001d\t\u0019g\u0003a\u0001\u00033\tq\u0002]1si&$\u0018n\u001c8TG\",W.\u0019\u0005\b\u0003OZ\u0001\u0019AA5\u0003\u001d\u0019\u0018\u000f\\\"p]\u001a\u0004B!a\u001b\u0002p5\u0011\u0011Q\u000e\u0006\u0003{\u0001JA!!\u001d\u0002n\t91+\u0015'D_:4\u0017aC5t'Bd\u0017\u000e^1cY\u0016$r\u0001[A<\u0003s\nY\bC\u0003w\u0019\u0001\u0007q\u000fC\u0004\u0002\u000e1\u0001\r!a\u0004\t\u000f\u0005uD\u00021\u0001\u0002\u0000\u0005!\u0001/\u0019;i!\u0011\t\t%!!\n\t\u0005\r\u00151\t\u0002\u0005!\u0006$\b.\u0001\u0010ck&dGMU3bI\u0016\u0014x+\u001b;i!\u0006\u0014H/\u001b;j_:4\u0016\r\\;fgR\u0001\u0012\u0011RAT\u0003S\u000bY+!,\u00020\u0006m\u0016Q\u0018\t\bW\u0005-\u0015qRAK\u0013\r\ti\t\f\u0002\n\rVt7\r^5p]F\u00022!MAI\u0013\r\t\u0019\n\b\u0002\u0010!\u0006\u0014H/\u001b;j_:,GMR5mKB)\u0011)a&\u0002\u001c&\u0019\u0011\u0011T&\u0003\u0011%#XM]1u_J\u0004B!!(\u0002$6\u0011\u0011q\u0014\u0006\u0004\u0003C\u0003\u0013\u0001C2bi\u0006d\u0017p\u001d;\n\t\u0005\u0015\u0016q\u0014\u0002\f\u0013:$XM\u001d8bYJ{w\u000fC\u0003w\u001b\u0001\u0007q\u000fC\u0004\u0002\u00185\u0001\r!!\u0007\t\u000f\u0005\rT\u00021\u0001\u0002\u001a!9\u0011qL\u0007A\u0002\u0005e\u0001bBAY\u001b\u0001\u0007\u00111W\u0001\bM&dG/\u001a:t!\u0015\t\u00151HA[!\r)\u0014qW\u0005\u0004\u0003s3$A\u0002$jYR,'\u000fC\u0004\u0002\u000e5\u0001\r!a\u0004\t\u000f\u0005}V\u00021\u0001\u0002B\u0006Q\u0001.\u00193p_B\u001cuN\u001c4\u0011\t\u0005\r\u0017\u0011Z\u0007\u0003\u0003\u000bTA!a2\u0002\u0004\u0005!1m\u001c8g\u0013\u0011\tY-!2\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003=\u0019X\u000f\u001d9peR$\u0015\r^1UsB,Gc\u00015\u0002R\"9\u00111\u001b\bA\u0002\u0005U\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0011\t\u0005m\u0011q[\u0005\u0005\u00033\fiB\u0001\u0005ECR\fG+\u001f9f\u0003A\u0019X\u000f\u001d9peR4\u0015.\u001a7e\u001d\u0006lW\rF\u0002i\u0003?Da!!9\u0010\u0001\u0004A\u0016\u0001\u00028b[\u0016\f\u0011\u0003U1scV,GOR5mK\u001a{'/\\1u!\ty\u0015cE\u0003\u0012Ui\nI\u000f\u0005\u0003\u0002l\u0006UXBAAw\u0015\u0011\ty/!=\u0002\u0005%|'BAAz\u0003\u0011Q\u0017M^1\n\u0007)\u000bi\u000f\u0006\u0002\u0002f\u0006Q!/Z1e'\u000eDW-\\1\u0015\r\u0005%\u0012Q B\b\u0011\u001d\typ\u0005a\u0001\u0005\u0003\tqAZ8pi\u0016\u00148\u000fE\u0003B\u0003w\u0011\u0019\u0001\u0005\u0003\u0003\u0006\t-QB\u0001B\u0004\u0015\u0011\t)A!\u0003\u000b\u0005m!\u0013\u0002\u0002B\u0007\u0005\u000f\u0011aAR8pi\u0016\u0014\b\"\u0002<\u0014\u0001\u00049\u0018\u0001\b:fC\u0012\u0004\u0016M]9vKR4un\u001c;feNLe\u000eU1sC2dW\r\u001c\u000b\t\u0005\u0003\u0011)Ba\u0006\u0003\u001c!9\u0011q\u0019\u000bA\u0002\u0005\u0005\u0007b\u0002B\r)\u0001\u0007\u0011\u0011H\u0001\na\u0006\u0014HOR5mKNDaA!\b\u0015\u0001\u0004A\u0017AE5h]>\u0014XmQ8seV\u0004HOR5mKN\fa#\\3sO\u0016\u001c6\r[3nCNLe\u000eU1sC2dW\r\u001c\u000b\t\u0003S\u0011\u0019C!\n\u0003*!9\u00111G\u000bA\u0002\u0005=\u0001b\u0002B\u0014+\u0001\u0007\u0011\u0011H\u0001\rM&dWm\u001d+p)>,8\r\u001b\u0005\u0006mV\u0001\ra^\u0001\u0015e\u0016\fGmU2iK6\fgI]8n\r>|G/\u001a:\u0015\r\u0005e!q\u0006B\u001a\u0011\u001d\u0011\tD\u0006a\u0001\u0005\u0007\taAZ8pi\u0016\u0014\bb\u0002B\u001b-\u0001\u0007!qG\u0001\nG>tg/\u001a:uKJ\u00042a\u0014B\u001d\u0013\r\u0011YD\u0007\u0002\u001e!\u0006\u0014\u0018/^3u)>\u001c\u0006/\u0019:l'\u000eDW-\\1D_:4XM\u001d;fe\u00069B-Z:fe&\fG.\u001b>f'\u000eDW-\\1TiJLgn\u001a\u000b\u0005\u0003S\u0011\t\u0005\u0003\u0004\u0003D]\u0001\r\u0001W\u0001\rg\u000eDW-\\1TiJLgnZ\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005\u0013\u0002BAa\u0013\u0003R5\u0011!Q\n\u0006\u0005\u0005\u001f\n\t0\u0001\u0003mC:<\u0017\u0002\u0002B*\u0005\u001b\u0012aa\u00142kK\u000e$\b")
public class ParquetFileFormat
implements FileFormat,
DataSourceRegister,
Logging,
Serializable {
    private final ParquetLogRedirector parquetLogRedirector;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static StructType readSchemaFromFooter(Footer footer, ParquetToSparkSchemaConverter parquetToSparkSchemaConverter) {
        return ParquetFileFormat$.MODULE$.readSchemaFromFooter(footer, parquetToSparkSchemaConverter);
    }

    public static Option<StructType> mergeSchemasInParallel(scala.collection.immutable.Map<String, String> map, Seq<FileStatus> seq, SparkSession sparkSession) {
        return ParquetFileFormat$.MODULE$.mergeSchemasInParallel(map, seq, sparkSession);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, scala.collection.immutable.Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.buildReader$(this, sparkSession, dataSchema, partitionSchema, requiredSchema, filters, options, hadoopConf);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ParquetLogRedirector parquetLogRedirector() {
        return this.parquetLogRedirector;
    }

    @Override
    public String shortName() {
        return "parquet";
    }

    public String toString() {
        return "Parquet";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof ParquetFileFormat;
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, scala.collection.immutable.Map<String, String> options, StructType dataSchema) {
        ParquetOptions parquetOptions = new ParquetOptions(options, sparkSession.sessionState().conf());
        Configuration conf = ContextUtil.getConfiguration((JobContext)job);
        Class committerClass = conf.getClass(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key(), ParquetOutputCommitter.class, OutputCommitter.class);
        if (conf.get(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key()) == null) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Using default output committer for Parquet: ").append(ParquetOutputCommitter.class.getCanonicalName()).toString());
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(49).append("Using user defined output committer for Parquet: ").append(committerClass.getCanonicalName()).toString());
        }
        conf.setClass(SQLConf$.MODULE$.OUTPUT_COMMITTER_CLASS().key(), committerClass, OutputCommitter.class);
        job.setOutputFormatClass(ParquetOutputFormat.class);
        ParquetOutputFormat.setWriteSupportClass((Job)job, ParquetWriteSupport.class);
        ParquetWriteSupport$.MODULE$.setSchema(dataSchema, conf);
        conf.set(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key(), Boolean.toString(sparkSession.sessionState().conf().writeLegacyParquetFormat()));
        conf.set(SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key(), sparkSession.sessionState().conf().parquetOutputTimestampType().toString());
        conf.set("parquet.compression", parquetOptions.compressionCodecClassName());
        if (conf.get("parquet.summary.metadata.level") == null && conf.get("parquet.enable.summary-metadata") == null) {
            conf.setEnum("parquet.summary.metadata.level", (Enum)ParquetOutputFormat.JobSummaryLevel.NONE);
        }
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel = ParquetOutputFormat.getJobSummaryLevel((Configuration)conf);
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel2 = ParquetOutputFormat.JobSummaryLevel.NONE;
        if ((jobSummaryLevel == null ? jobSummaryLevel2 != null : !jobSummaryLevel.equals(jobSummaryLevel2)) && !ParquetOutputCommitter.class.isAssignableFrom(committerClass)) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(53).append("Committer ").append(committerClass).append(" is not a ParquetOutputCommitter and cannot").toString()).append(" create job summaries. ").append(new StringBuilder(58).append("Set Parquet option ").append("parquet.summary.metadata.level").append(" to NONE.").toString()).toString());
        }
        return new OutputWriterFactory(null){
            private final ParquetLogRedirector parquetLogRedirector;

            private ParquetLogRedirector parquetLogRedirector() {
                return this.parquetLogRedirector;
            }

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new ParquetOutputWriter(path, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder(8).append(CodecConfig.from((TaskAttemptContext)context).getCodec().getExtension()).append(".parquet").toString();
            }
            {
                this.parquetLogRedirector = ParquetLogRedirector.INSTANCE;
            }
        };
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, scala.collection.immutable.Map<String, String> parameters, Seq<FileStatus> files) {
        return ParquetUtils$.MODULE$.inferSchema(sparkSession, parameters, files);
    }

    @Override
    public boolean supportBatch(SparkSession sparkSession, StructType schema) {
        SQLConf conf = sparkSession.sessionState().conf();
        return conf.parquetVectorizedReaderEnabled() && conf.wholeStageEnabled() && schema.length() <= conf.wholeStageMaxNumFields() && schema.forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ParquetFileFormat.$anonfun$supportBatch$1(x$1)));
    }

    @Override
    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return Option$.MODULE$.apply(package$.MODULE$.Seq().fill(requiredSchema.fields().length + partitionSchema.fields().length, (Function0 & Serializable)() -> !sqlConf.offHeapColumnVectorEnabled() ? OnHeapColumnVector.class.getName() : OffHeapColumnVector.class.getName()));
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, scala.collection.immutable.Map<String, String> options, Path path) {
        return true;
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, scala.collection.immutable.Map<String, String> options, Configuration hadoopConf) {
        hadoopConf.set("parquet.read.support.class", ParquetReadSupport.class.getName());
        hadoopConf.set(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA(), requiredSchema.json());
        hadoopConf.set(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA(), requiredSchema.json());
        hadoopConf.set(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key(), sparkSession.sessionState().conf().sessionLocalTimeZone());
        hadoopConf.setBoolean(SQLConf$.MODULE$.NESTED_SCHEMA_PRUNING_ENABLED().key(), sparkSession.sessionState().conf().nestedSchemaPruningEnabled());
        hadoopConf.setBoolean(SQLConf$.MODULE$.CASE_SENSITIVE().key(), sparkSession.sessionState().conf().caseSensitiveAnalysis());
        ParquetWriteSupport$.MODULE$.setSchema(requiredSchema, hadoopConf);
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), sparkSession.sessionState().conf().isParquetBinaryAsString());
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), sparkSession.sessionState().conf().isParquetINT96AsTimestamp());
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        StructType resultSchema = new StructType((StructField[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields()), (Object)requiredSchema.fields(), ClassTag$.MODULE$.apply(StructField.class)));
        SQLConf sqlConf = sparkSession.sessionState().conf();
        boolean enableOffHeapColumnVector = sqlConf.offHeapColumnVectorEnabled();
        boolean enableVectorizedReader = sqlConf.parquetVectorizedReaderEnabled() && resultSchema.forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ParquetFileFormat.$anonfun$buildReaderWithPartitionValues$1(x$2)));
        boolean enableRecordFilter = sqlConf.parquetRecordFilterEnabled();
        boolean timestampConversion = sqlConf.isParquetINT96TimestampConversion();
        int capacity = sqlConf.parquetVectorizedReaderBatchSize();
        boolean enableParquetFilterPushDown = sqlConf.parquetFilterPushDown();
        boolean returningBatch = this.supportBatch(sparkSession, resultSchema);
        boolean pushDownDate = sqlConf.parquetFilterPushDownDate();
        boolean pushDownTimestamp = sqlConf.parquetFilterPushDownTimestamp();
        boolean pushDownDecimal = sqlConf.parquetFilterPushDownDecimal();
        boolean pushDownStringStartWith = sqlConf.parquetFilterPushDownStringStartWith();
        int pushDownInFilterThreshold = sqlConf.parquetFilterPushDownInFilterThreshold();
        boolean isCaseSensitive = sqlConf.caseSensitiveAnalysis();
        ParquetOptions parquetOptions = new ParquetOptions(options, sparkSession.sessionState().conf());
        String datetimeRebaseModeInRead = parquetOptions.datetimeRebaseModeInRead();
        String int96RebaseModeInRead = parquetOptions.int96RebaseModeInRead();
        return (Function1 & Serializable)file -> {
            RecordReaderIterator<Object> recordReaderIterator;
            None$ none$;
            LazyRef footerFileMetaData$lzy = new LazyRef();
            Predef$.MODULE$.assert(file.partitionValues().numFields() == partitionSchema.size());
            Path filePath = new Path(new URI(file.filePath()));
            FileSplit split = new FileSplit(filePath, file.start(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
            Configuration sharedConf = ((SerializableConfiguration)broadcastedHadoopConf.value()).value();
            Map map = ParquetFileFormat.footerFileMetaData$1(footerFileMetaData$lzy, sharedConf, filePath).getKeyValueMetaData();
            Enumeration.Value datetimeRebaseMode = DataSourceUtils$.MODULE$.datetimeRebaseMode((Function1<String, String>)(Function1 & Serializable)x$1 -> (String)map.get(x$1), datetimeRebaseModeInRead);
            if (enableParquetFilterPushDown) {
                MessageType parquetSchema = ParquetFileFormat.footerFileMetaData$1(footerFileMetaData$lzy, sharedConf, filePath).getSchema();
                ParquetFilters parquetFilters = new ParquetFilters(parquetSchema, pushDownDate, pushDownTimestamp, pushDownDecimal, pushDownStringStartWith, pushDownInFilterThreshold, isCaseSensitive, datetimeRebaseMode);
                none$ = ((IterableOnceOps)filters.flatMap((Function1 & Serializable)x$3 -> parquetFilters.createFilter((Filter)x$3))).reduceOption((Function2 & Serializable)(x$1, x$2) -> FilterApi.and((FilterPredicate)x$1, (FilterPredicate)x$2));
            } else {
                none$ = None$.MODULE$;
            }
            None$ pushed = none$;
            None$ convertTz = timestampConversion && !ParquetFileFormat.isCreatedByParquetMr$1(footerFileMetaData$lzy, sharedConf, filePath) ? new Some((Object)DateTimeUtils$.MODULE$.getZoneId(sharedConf.get(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()))) : None$.MODULE$;
            Map map2 = ParquetFileFormat.footerFileMetaData$1(footerFileMetaData$lzy, sharedConf, filePath).getKeyValueMetaData();
            Enumeration.Value int96RebaseMode = DataSourceUtils$.MODULE$.int96RebaseMode((Function1<String, String>)(Function1 & Serializable)x$1 -> (String)map2.get(x$1), int96RebaseModeInRead);
            TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
            TaskAttemptContextImpl hadoopAttemptContext = new TaskAttemptContextImpl(((SerializableConfiguration)broadcastedHadoopConf.value()).value(), attemptId);
            if (pushed.isDefined()) {
                ParquetInputFormat.setFilterPredicate((Configuration)hadoopAttemptContext.getConfiguration(), (FilterPredicate)((FilterPredicate)pushed.get()));
            }
            Option taskContext = Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get());
            if (enableVectorizedReader) {
                VectorizedParquetRecordReader vectorizedReader = new VectorizedParquetRecordReader((ZoneId)convertTz.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), datetimeRebaseMode.toString(), int96RebaseMode.toString(), enableOffHeapColumnVector && taskContext.isDefined(), capacity);
                RecordReaderIterator<Object> iter = new RecordReaderIterator<Object>(vectorizedReader);
                taskContext.foreach((Function1 & Serializable)x$4 -> x$4.addTaskCompletionListener((Function1 & Serializable)x$5 -> {
                    iter.close();
                    return BoxedUnit.UNIT;
                }));
                vectorizedReader.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
                this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(11).append("Appending ").append(partitionSchema).append(" ").append(file.partitionValues()).toString());
                vectorizedReader.initBatch(partitionSchema, file.partitionValues());
                if (returningBatch) {
                    vectorizedReader.enableReturningBatches();
                }
                recordReaderIterator = iter;
            } else {
                ParquetRecordReader parquetRecordReader;
                this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Falling back to parquet-mr");
                ParquetReadSupport readSupport = new ParquetReadSupport((Option<ZoneId>)convertTz, false, datetimeRebaseMode, int96RebaseMode);
                if (pushed.isDefined() && enableRecordFilter) {
                    FilterCompat.Filter parquetFilter = FilterCompat.get((FilterPredicate)((FilterPredicate)pushed.get()), null);
                    parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport, parquetFilter);
                } else {
                    parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport);
                }
                ParquetRecordReader reader = parquetRecordReader;
                RecordReaderIterator iter = new RecordReaderIterator(reader);
                taskContext.foreach((Function1 & Serializable)x$6 -> x$6.addTaskCompletionListener((Function1 & Serializable)x$7 -> {
                    iter.close();
                    return BoxedUnit.UNIT;
                }));
                reader.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
                Seq fullSchema = (Seq)requiredSchema.toAttributes().$plus$plus((IterableOnce)partitionSchema.toAttributes());
                UnsafeProjection unsafeProjection = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)fullSchema, fullSchema);
                if (partitionSchema.length() == 0) {
                    recordReaderIterator = iter.map(unsafeProjection);
                } else {
                    JoinedRow joinedRow = new JoinedRow();
                    recordReaderIterator = iter.map((Function1 & Serializable)d -> unsafeProjection.apply((InternalRow)joinedRow.apply(d, file.partitionValues())));
                }
            }
            return recordReaderIterator;
        };
    }

    @Override
    public boolean supportDataType(DataType dataType) {
        boolean bl;
        DataType dataType2 = dataType;
        if (dataType2 instanceof AnsiIntervalType) {
            bl = false;
        } else if (dataType2 instanceof AtomicType) {
            bl = true;
        } else if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            bl = structType.forall((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.supportDataType(f.dataType())));
        } else if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            bl = this.supportDataType(elementType);
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            bl = this.supportDataType(keyType) && this.supportDataType(valueType);
        } else if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            bl = this.supportDataType(userDefinedType.sqlType());
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean supportFieldName(String name) {
        return !name.matches(".*[ ,;{}()\n\t=].*");
    }

    public static final /* synthetic */ boolean $anonfun$supportBatch$1(StructField x$1) {
        return x$1.dataType() instanceof AtomicType;
    }

    public static final /* synthetic */ boolean $anonfun$buildReaderWithPartitionValues$1(StructField x$2) {
        return x$2.dataType() instanceof AtomicType;
    }

    private static final /* synthetic */ FileMetaData footerFileMetaData$lzycompute$1(LazyRef footerFileMetaData$lzy$1, Configuration sharedConf$1, Path filePath$1) {
        FileMetaData fileMetaData;
        LazyRef lazyRef = footerFileMetaData$lzy$1;
        synchronized (lazyRef) {
            fileMetaData = footerFileMetaData$lzy$1.initialized() ? (FileMetaData)footerFileMetaData$lzy$1.value() : (FileMetaData)footerFileMetaData$lzy$1.initialize((Object)ParquetFooterReader.readFooter(sharedConf$1, filePath$1, ParquetMetadataConverter.SKIP_ROW_GROUPS).getFileMetaData());
        }
        return fileMetaData;
    }

    private static final FileMetaData footerFileMetaData$1(LazyRef footerFileMetaData$lzy$1, Configuration sharedConf$1, Path filePath$1) {
        return footerFileMetaData$lzy$1.initialized() ? (FileMetaData)footerFileMetaData$lzy$1.value() : ParquetFileFormat.footerFileMetaData$lzycompute$1(footerFileMetaData$lzy$1, sharedConf$1, filePath$1);
    }

    private static final boolean isCreatedByParquetMr$1(LazyRef footerFileMetaData$lzy$1, Configuration sharedConf$1, Path filePath$1) {
        return ParquetFileFormat.footerFileMetaData$1(footerFileMetaData$lzy$1, sharedConf$1, filePath$1).getCreatedBy().startsWith("parquet-mr");
    }

    public ParquetFileFormat() {
        FileFormat.$init$(this);
        Logging.$init$((Logging)this);
        this.parquetLogRedirector = ParquetLogRedirector.INSTANCE;
    }
}

